/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.storeevent.mconsole;

import com.savvion.sbm.bizlogic.storeevent.mconsole.PopulatorDaemon;
import com.savvion.sbm.replication.ReplicationManager;
import com.savvion.sbm.replication.service.IServiceHandler;
import com.savvion.sbm.replication.service.ServiceRegister;
import com.savvion.sbm.util.LoggerUtil;
import com.savvion.sbm.util.MessageFactory;
import com.savvion.sbm.util.ResourceUtil;
import com.savvion.sbm.util.SBMConstants;
import com.savvion.sbm.util.SBMControl;
import com.savvion.sbm.util.SBMUtil;
import com.savvion.sbm.util.ServiceLocator;
import com.savvion.sbm.util.logger.SBMLogger;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import javax.ejb.EJBException;
import javax.jms.Message;

public class MConsole {
    public static final String DBTYPE_ORACLE = "oracle";
    public static final String DBTYPE_MSSQLSERVER = "mssqlserver";
    public static final String DBTYPE_SYBASE = "sybase";
    public static final String DBTYPE_IBMDB2 = "ibmdb2";
    public static final String DBTYPE_OPENEDGE = "openedge";
    public static final String DBTYPE_POSTGRESQL = "postgresql";
    private static final String MCONSOLE_CONF_FILE = "bizstore.conf";
    private static String MCONSOLE_SLEEP_TIME = "300";
    private static String MCONSOLE_DB_NAME = "oracle";
    public static final String MCONSOLESERVICEMDB = "MCONSOLESERVICEMDB";
    public static final int STOPPED = 0;
    public static final int STARTED = 1;
    public static final String STARTED_MSG = "Management Console is started atnode: ";
    public static final String STOPPED_MSG = "Management Console is stopped atnode: ";
    public static final String ALREADY_STARTED_MSG = "Management Console is already started at node: ";
    public static final String ALREADY_STOPPED_MSG = "Management Console is already stopped at node: ";
    private static boolean stopping = false;
    private static boolean running = false;
    private static boolean initialized = false;
    public static final String MESSAGE_FILE = "MConsoleMessages";
    public static final String MCONSOLE = "MConsole";
    private static PopulatorDaemon mgrcd = null;
    public static SBMLogger logger;
    public static MessageFactory msgFact;
    public static boolean isReadingAllTablesEnabled;
    private static boolean multibyteSchema;
    static final String MULTIBYTE_KEY = "sbm.db.multibyteschema";
    public static final String MCONSOLESERVICEMDB_NAME = "MConsoleServiceMDB";
    public static final String SERVICE_NAME = "Management Console Service";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initDaemon() throws Exception {
        Properties mcp = new Properties();
        mcp.setProperty("persistence.populator.sleepTime", MCONSOLE_SLEEP_TIME);
        mcp.setProperty("sbm.db.default", MCONSOLE_DB_NAME);
        mcp.setProperty("sbm.application.home", SBMControl.util.SBM_APPS_DIR);
        mcp.setProperty(MULTIBYTE_KEY, Boolean.toString(multibyteSchema));
        Class<MConsole> clazz = MConsole.class;
        synchronized (MConsole.class) {
            mgrcd = new PopulatorDaemon(mcp);
            initialized = true;
            running = true;
            stopping = false;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            LoggerUtil.logSOP((Object)"Management Console Table Populator started.\n");
            logger.info((Object)"####################################");
            logger.infoKey("MConsole_MSG_501", new Object[]{new Date()});
            logger.info((Object)"####################################");
            return;
        }
    }

    public static void init() throws Exception {
        if (initialized) {
            return;
        }
        SBMControl.init();
        SBMConstants.self().getClass();
        SBMControl.register((String)MCONSOLE);
        MConsole.initLogger();
        MConsole.readProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start() {
        if (logger == null) {
            MConsole.initLogger();
        }
        if (MConsole.isRunning()) {
            SBMUtil.logDuplicateMessage((SBMLogger)logger, (String)"MConsole_MSG_1002", (String)SERVICE_NAME);
            return;
        }
        if (!ReplicationManager.self().isPrimaryDatabase()) {
            logger.warnKey("MConsole_MSG_1529", new Object[]{SERVICE_NAME});
            return;
        }
        Class<MConsole> clazz = MConsole.class;
        synchronized (MConsole.class) {
            if (MConsole.isRunning()) {
                SBMUtil.logDuplicateMessage((SBMLogger)logger, (String)"MConsole_MSG_1002", (String)SERVICE_NAME);
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            try {
                MConsole.init();
                MConsole.initDaemon();
            }
            catch (Throwable t) {
                logger.errorKey("MConsole_MSG_1501", "MConsole.start()", t, new Object[]{t.getMessage()});
            }
            try {
                if (initialized && mgrcd != null) {
                    mgrcd.process();
                    MConsole.cleanup();
                }
            }
            catch (Throwable t) {
                logger.errorKey("MConsole_MSG_1502", "MConsole.start()", t, new Object[]{t.getMessage()});
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void shutdown() {
        if (!MConsole.isRunning() || mgrcd == null || MConsole.isMConsoleStopping()) return;
        LoggerUtil.logSOP((Object)"Management Console Table Populator shutting down...");
        logger.info((Object)"####################################");
        logger.infoKey("MConsole_MSG_502");
        logger.info((Object)"####################################");
        Class<MConsole> clazz = MConsole.class;
        synchronized (MConsole.class) {
            stopping = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static synchronized void cleanup() {
        mgrcd = null;
        running = false;
        stopping = false;
        initialized = false;
        LoggerUtil.logSOP((Object)"Management Console Table Populator daemon stopped.");
        logger.info((Object)"####################################");
        logger.infoKey("MConsole_MSG_503", new Object[]{new Date()});
        logger.info((Object)"####################################");
        msgFact = null;
        logger = null;
        SBMConstants.self().getClass();
        SBMControl.unregister((String)MCONSOLE);
    }

    public static boolean isRunning() {
        return running;
    }

    public static boolean isMConsoleStopping() {
        return stopping;
    }

    public static String getDatabaseName() {
        return MCONSOLE_DB_NAME;
    }

    public static boolean refresh() {
        try {
            if (!MConsole.isRunning()) {
                return false;
            }
            MConsole.initLogger();
            MConsole.readProperties();
            return true;
        }
        catch (Throwable t) {
            logger.errorKey("MConsole_MSG_1503", "MConsole.refresh()", t, new Object[]{t.getMessage()});
            return false;
        }
    }

    private static synchronized void initLogger() {
        logger = SBMControl.createLogger((String)MCONSOLE, (String)MESSAGE_FILE, (ClassLoader)MConsole.class.getClassLoader());
        msgFact = logger.getMessageFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void readProperties() throws Exception {
        String propStr = null;
        try {
            Class<MConsole> clazz;
            String mconsoleFile = MCONSOLE_CONF_FILE;
            Properties p = ResourceUtil.getPropertyObject((String)(SBMControl.util.ABSOLUTE_CONF_PATH + mconsoleFile));
            propStr = p.getProperty("mconsole.populator.sleepTime");
            if (SBMUtil.isValidProperty((String)propStr)) {
                clazz = MConsole.class;
                // MONITORENTER : com.savvion.sbm.bizlogic.storeevent.mconsole.MConsole.class
                MCONSOLE_SLEEP_TIME = propStr;
                // MONITOREXIT : clazz
            }
            propStr = p.getProperty("mconsole.read.alltables.enable");
            clazz = MConsole.class;
            // MONITORENTER : com.savvion.sbm.bizlogic.storeevent.mconsole.MConsole.class
            isReadingAllTablesEnabled = SBMUtil.isValidProperty((String)propStr) ? Boolean.valueOf(propStr.trim()) : false;
            // MONITOREXIT : clazz
            StringBuilder stringBuilder = new StringBuilder().append(SBMControl.util.ABSOLUTE_CONF_PATH);
            SBMConstants.self().getClass();
            p = ResourceUtil.getPropertyObject((String)stringBuilder.append("sbmdb.properties").toString());
            propStr = p.getProperty("sbm.db.default");
            if (SBMUtil.isValidProperty((String)propStr)) {
                MCONSOLE_DB_NAME = propStr;
            }
            propStr = p.getProperty(MULTIBYTE_KEY);
            if (!SBMUtil.isValidProperty((String)propStr)) return;
            clazz = MConsole.class;
            // MONITORENTER : com.savvion.sbm.bizlogic.storeevent.mconsole.MConsole.class
            multibyteSchema = Boolean.parseBoolean(propStr.trim());
            // MONITOREXIT : clazz
            return;
        }
        catch (Throwable t) {
            logger.errorKey("MConsole_MSG_1505", "MConsole.readProperties()", t, new Object[]{t.getMessage()});
        }
    }

    public static void sendMessage(String operation) {
        MConsole.sendMessage(operation, null);
    }

    public static void sendMessage(String operation, String sender) {
        try {
            MConsole.init();
            String destination = null;
            HashMap<String, String> selectors = new HashMap<String, String>();
            SBMConstants.self().getClass();
            selectors.put("OPERATION", operation);
            SBMConstants.self().getClass();
            selectors.put("TYPE", MCONSOLESERVICEMDB);
            if (sender != null && !sender.trim().isEmpty()) {
                selectors.put("SENDER_NODE_NAME", sender);
            }
            SBMConstants.self().getClass();
            destination = "sbmtopic";
            SBMUtil.self().getBMJMSService().sendMessage(destination, (Object)"", 1, selectors);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception in MConsole.sendMessage():", (Throwable)ex);
        }
    }

    public static void performOperation(Message message) {
        String operation = null;
        try {
            SBMConstants.self().getClass();
            operation = message.getStringProperty("OPERATION");
        }
        catch (Exception e) {
            throw new EJBException("Error getting string property operation", e);
        }
        String errorMsg = "Operation <" + operation + "> is not a valid one.Please check if the operation is null, empty or valid one.";
        SBMUtil.self();
        if (!SBMUtil.isValidProperty((String)operation)) {
            throw new RuntimeException(errorMsg);
        }
        try {
            SBMConstants.self().getClass();
            if ("START".equals(operation)) {
                MConsole.start();
            } else {
                SBMConstants.self().getClass();
                if ("STOP".equals(operation)) {
                    if (!MConsole.isRunning()) {
                        if (!ServiceLocator.self().isCluster()) {
                            StringBuilder stringBuilder = new StringBuilder().append(ALREADY_STOPPED_MSG);
                            SBMUtil.self();
                            LoggerUtil.logSEP((Object)stringBuilder.append(SBMUtil.getHost()).append("!").toString());
                        }
                        if (logger != null) {
                            logger.info((Object)"MConsole.performOperation(STOP): Duplicate stop request is rejected.");
                        } else {
                            LoggerUtil.logSEP((Object)"MConsole.performOperation(STOP): Duplicate stop request is rejected.");
                        }
                        return;
                    }
                    MConsole.shutdown();
                }
            }
        }
        catch (Throwable t) {
            if (logger != null) {
                logger.errorKey("MConsole_MSG_1527", "MConsole.performOperation()", t, new Object[]{operation});
            }
            throw new RuntimeException("MConsole.performOperation() Operation " + operation + " Failed.", t);
        }
    }

    public static int getStatus() {
        if (MConsole.isRunning()) {
            return 1;
        }
        return 0;
    }

    public static String getStatusMsg() {
        if (MConsole.getStatus() == 1) {
            StringBuilder stringBuilder = new StringBuilder().append(STARTED_MSG);
            SBMUtil.self();
            return stringBuilder.append(SBMUtil.getHost()).toString();
        }
        StringBuilder stringBuilder = new StringBuilder().append(STOPPED_MSG);
        SBMUtil.self();
        return stringBuilder.append(SBMUtil.getHost()).toString();
    }

    public static boolean ignoreRedeliveredLifeCycleMessages(Message msg, String context) {
        block6: {
            try {
                if (null != msg && msg.getJMSRedelivered()) {
                    MessageFactory messageFactory = MessageFactory.getInstance((String)MESSAGE_FILE, (ClassLoader)MConsole.class.getClassLoader());
                    String logMessage = null;
                    if (null != messageFactory) {
                        Object[] objectArray = new Object[3];
                        objectArray[0] = context;
                        SBMConstants.self().getClass();
                        objectArray[1] = msg.getStringProperty("OPERATION");
                        objectArray[2] = msg.getJMSMessageID();
                        logMessage = messageFactory.lookup("MConsole_MSG_2002", objectArray);
                    }
                    if (null != logger) {
                        logger.debug(logMessage);
                    } else {
                        LoggerUtil.logSOP(logMessage);
                    }
                    return true;
                }
            }
            catch (Throwable th) {
                if (null == logger || !logger.isDebugEnabled()) break block6;
                logger.debug((Object)"Exception in ignoreRedeliveredLifeCycleMessages()...", th);
            }
        }
        return false;
    }

    static {
        isReadingAllTablesEnabled = false;
        multibyteSchema = false;
        ServiceRegister.self().registerService((IServiceHandler)new ManagementConsoleHandler());
    }

    private static class ManagementConsoleHandler
    implements IServiceHandler {
        private ManagementConsoleHandler() {
        }

        public String getServiceName() {
            return "ManagementConsole";
        }

        public void startService() {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    MConsole.start();
                }
            }).start();
        }

        public void stopService() {
            MConsole.shutdown();
        }

        public boolean isServiceRunning() {
            return MConsole.isRunning();
        }
    }
}

