/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.smp.model;

import java.util.ArrayList;
import java.util.List;

public enum OperationType {
    CREATE_INSTANCE(1, "CREATE_INSTANCE"),
    ACTIVATE_WORKSTEP(2, "ACTIVATE_WORKSTEP"),
    COMPLETE_WORKSTEP(3, "COMPLETE_WORKSTEP"),
    UPDATE_DATASLOT(4, "UPDATE_DATASLOT");

    private int id;
    private String description;

    private OperationType(int id, String description) {
        this.id = id;
        this.description = description;
    }

    public static OperationType getType(String operationType) {
        if (operationType != null) {
            operationType.trim();
        }
        for (OperationType opType : OperationType.values()) {
            String opTypeName = opType.getDescription();
            if (!opTypeName.equalsIgnoreCase(operationType)) continue;
            return opType;
        }
        return null;
    }

    public static boolean isValidType(String operationType) {
        OperationType opType = OperationType.getType(operationType);
        return opType != null;
    }

    public static OperationType getType(int id) {
        for (OperationType opType : OperationType.values()) {
            int opTypeId = opType.getId();
            if (opTypeId != id) continue;
            return opType;
        }
        return null;
    }

    public boolean isCreateInstance() {
        return this == CREATE_INSTANCE;
    }

    public boolean isActivateWorkstep() {
        return this == ACTIVATE_WORKSTEP;
    }

    public boolean isCompleteWorkstep() {
        return this == COMPLETE_WORKSTEP;
    }

    public boolean isUpdateDataslot() {
        return this == UPDATE_DATASLOT;
    }

    public boolean isWorkstep() {
        return this == ACTIVATE_WORKSTEP || this == COMPLETE_WORKSTEP;
    }

    public int getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public static List<String> getValidValues() {
        ArrayList<String> opTypeValues = new ArrayList<String>();
        for (OperationType opType : OperationType.values()) {
            opTypeValues.add(opType.getDescription());
        }
        return opTypeValues;
    }

    public static List<Integer> getValidIds() {
        ArrayList<Integer> opTypeIds = new ArrayList<Integer>();
        for (OperationType opType : OperationType.values()) {
            opTypeIds.add(opType.getId());
        }
        return opTypeIds;
    }

    public String toString() {
        return this.description;
    }
}

