/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.smp.core;

import com.savvion.sbm.bizlogic.smp.MPService;
import com.savvion.sbm.bizlogic.smp.core.QuartzThreadHandler;
import com.savvion.sbm.bizlogic.smp.util.MPUtil;
import com.savvion.sbm.bizlogic.smp.util.SMPConfig;
import com.savvion.sbm.util.TransactionService;
import com.savvion.sbm.util.logger.SBMLogger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.UserTransaction;

public class WaitWorkStepProcessor
extends QuartzThreadHandler {
    private static WaitWorkStepProcessor self = null;
    private long waitJobCompletionTime = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WaitWorkStepProcessor self() {
        if (null != self) return self;
        Class<WaitWorkStepProcessor> clazz = WaitWorkStepProcessor.class;
        synchronized (WaitWorkStepProcessor.class) {
            if (null != self) return self;
            self = new WaitWorkStepProcessor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return self;
        }
    }

    public void execute() {
        if (MPUtil.isDebugScheduler() && this.waitJobCompletionTime > 0L) {
            MPService.self().getLogger().debugKey("BM_MPSH206", "WaitWorkStepProcessor.execute()", new Object[]{System.currentTimeMillis() - this.waitJobCompletionTime});
        }
        this.doExecute();
        this.waitJobCompletionTime = System.currentTimeMillis();
    }

    public void doExecute() {
        List<Map<String, Object>> waitWSList = this.getWaitWorkStepList(SMPConfig.self().getWaitWSJobBatch());
        if (waitWSList.isEmpty()) {
            if (MPUtil.isDebug()) {
                MPService.self().getLogger().debugKey("BM_MPSH204", "WaitWorkStepProcessor.doExecute()", new Object[0]);
            }
            return;
        }
        long startTime = System.currentTimeMillis();
        if (SMPConfig.self().isWaitWSMultiTransEnabled()) {
            this.updateEventStatusMultiTrans(waitWSList);
        } else {
            this.updateEventStatusUniTrans(waitWSList);
        }
        long endTime = System.currentTimeMillis();
        MPService.self().getLogger().infoKey("BM_MPSH205", "WaitWorkStepProcessor.doExecute()", new Object[]{waitWSList.size(), endTime - startTime});
    }

    private List<Map<String, Object>> getWaitWorkStepList(int batchSize) {
        return MPService.self().getPersistenceService().getWaitWSAttributes(batchSize);
    }

    private void updateEventStatusMultiTrans(List<Map<String, Object>> waitWSList) {
        UserTransaction utx = null;
        if (MPUtil.isDebug()) {
            MPService.self().getLogger().debugKey("BM_MPSH313", "WaitWorkStepProcessor.updateEventStatusMultiTrans()", new Object[0]);
        }
        for (Map<String, Object> waitWSAttributes : waitWSList) {
            try {
                utx = this.getUserTransaction();
                utx.begin();
                this.updateEventStatus(waitWSAttributes);
                utx.commit();
            }
            catch (Throwable th) {
                TransactionService.rollback((UserTransaction)utx, (SBMLogger)this.getLogger());
                MPUtil.handleThrowable("BM_MPSH203", "WaitWorkStepProcessor.updateEventStatusMultiTrans()", null, th);
            }
        }
    }

    private void updateEventStatusUniTrans(List<Map<String, Object>> waitWSList) {
        UserTransaction utx = null;
        if (MPUtil.isDebug()) {
            MPService.self().getLogger().debugKey("BM_MPSH314", "WaitWorkStepProcessor.updateEventStatusUniTrans()", new Object[0]);
        }
        try {
            utx = TransactionService.getUserTransaction();
            utx.begin();
            for (Map<String, Object> waitWSAttributes : waitWSList) {
                this.updateEventStatus(waitWSAttributes);
            }
            utx.commit();
        }
        catch (Throwable th) {
            TransactionService.rollback((UserTransaction)utx, (SBMLogger)this.getLogger());
            MPUtil.handleThrowable("BM_MPSH203", "WaitWorkStepProcessor.updateEventStatusUniTrans()", null, th);
        }
    }

    private void updateEventStatus(Map<String, Object> waitWSAttributes) {
        HashMap<String, Object> processCtxAttrs = new HashMap<String, Object>();
        processCtxAttrs.put("BL_PROCESS_INSTANCE_ID", waitWSAttributes.get("PROCESS_INSTANCE_ID"));
        processCtxAttrs.put("BL_WORKSTEP_ID", waitWSAttributes.get("WORKSTEP_ID"));
        processCtxAttrs.put("BL_LOOP_COUNTER", waitWSAttributes.get("LOOP_COUNTER"));
        processCtxAttrs.put("BL_PROCESS_TEMPLATE_ID", waitWSAttributes.get("PROCESS_TEMPLATE_ID"));
        processCtxAttrs.put("READY_TO_PROCESS", 1);
        long eventId = (Long)waitWSAttributes.get("EVENT_ID");
        MPService.self().getPersistenceService().updateEvent(eventId, processCtxAttrs);
    }

    private SBMLogger getLogger() {
        return MPService.self().getLogger();
    }
}

