/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.svo;

import com.savvion.common.proxy.ProxyException;
import com.savvion.common.proxy.ProxyManager;
import com.savvion.sbm.bizlogic.enums.PTState;
import com.savvion.sbm.bizlogic.server.ApplicationManager;
import com.savvion.sbm.bizlogic.server.ProcessControl;
import com.savvion.sbm.bizlogic.server.WFAtomicInstance;
import com.savvion.sbm.bizlogic.server.WFAtomicWS;
import com.savvion.sbm.bizlogic.server.WFCWorkItem;
import com.savvion.sbm.bizlogic.server.WFDataSlotInstance;
import com.savvion.sbm.bizlogic.server.WFDataslot;
import com.savvion.sbm.bizlogic.server.WFInlineBlockWS;
import com.savvion.sbm.bizlogic.server.WFNestedWS;
import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.server.WFProcessContext;
import com.savvion.sbm.bizlogic.server.WFVoteWS;
import com.savvion.sbm.bizlogic.server.WFWorkItem;
import com.savvion.sbm.bizlogic.server.WFWorkstep;
import com.savvion.sbm.bizlogic.server.WFWorkstepInstance;
import com.savvion.sbm.bizlogic.server.dao.CWorkItemDAO;
import com.savvion.sbm.bizlogic.server.dao.ProcessInstanceDAO;
import com.savvion.sbm.bizlogic.server.dao.ProcessInstanceTemplateDAO;
import com.savvion.sbm.bizlogic.server.dao.ProcessNotesDAO;
import com.savvion.sbm.bizlogic.server.dao.SubProcessDAO;
import com.savvion.sbm.bizlogic.server.dao.WorkItemDAO;
import com.savvion.sbm.bizlogic.server.dao.WorkStepInstanceDAO;
import com.savvion.sbm.bizlogic.server.ejb.BLServer;
import com.savvion.sbm.bizlogic.server.ejb.BLServerHome;
import com.savvion.sbm.bizlogic.server.ejb.ProcessInstanceEBLocal;
import com.savvion.sbm.bizlogic.server.ejb.ProcessInstanceSB;
import com.savvion.sbm.bizlogic.server.ejb.ProcessInstanceSBHome;
import com.savvion.sbm.bizlogic.server.ejb.WorkItemEBLocal;
import com.savvion.sbm.bizlogic.server.ejb.WorkStepInstanceEBLocal;
import com.savvion.sbm.bizlogic.server.svo.ActivityWSInstance;
import com.savvion.sbm.bizlogic.server.svo.ActivityWSTemplate;
import com.savvion.sbm.bizlogic.server.svo.Application;
import com.savvion.sbm.bizlogic.server.svo.CWorkItem;
import com.savvion.sbm.bizlogic.server.svo.DataSlot;
import com.savvion.sbm.bizlogic.server.svo.DataSlotList;
import com.savvion.sbm.bizlogic.server.svo.DataSlotTemplate;
import com.savvion.sbm.bizlogic.server.svo.DelayWSTemplate;
import com.savvion.sbm.bizlogic.server.svo.DocumentDS;
import com.savvion.sbm.bizlogic.server.svo.InlineBlockWSInstance;
import com.savvion.sbm.bizlogic.server.svo.MessagePublisherWSTemplate;
import com.savvion.sbm.bizlogic.server.svo.ProcessCount;
import com.savvion.sbm.bizlogic.server.svo.ProcessCountList;
import com.savvion.sbm.bizlogic.server.svo.ProcessInstance;
import com.savvion.sbm.bizlogic.server.svo.ProcessInstanceList;
import com.savvion.sbm.bizlogic.server.svo.ProcessNotes;
import com.savvion.sbm.bizlogic.server.svo.ProcessTemplate;
import com.savvion.sbm.bizlogic.server.svo.ProcessTemplateList;
import com.savvion.sbm.bizlogic.server.svo.SubProcessWSInstance;
import com.savvion.sbm.bizlogic.server.svo.SubscriberWSInstance;
import com.savvion.sbm.bizlogic.server.svo.VoteCriteria;
import com.savvion.sbm.bizlogic.server.svo.VoteResult;
import com.savvion.sbm.bizlogic.server.svo.WebServiceWSTemplate;
import com.savvion.sbm.bizlogic.server.svo.WorkItem;
import com.savvion.sbm.bizlogic.server.svo.WorkItemList;
import com.savvion.sbm.bizlogic.server.svo.WorkStepInstance;
import com.savvion.sbm.bizlogic.server.svo.WorkStepInstanceList;
import com.savvion.sbm.bizlogic.server.svo.WorkStepTemplate;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.PerformerUtil;
import com.savvion.sbm.bizlogic.util.Session;
import com.savvion.sbm.bizlogic.util.SessionManager;
import com.savvion.sbm.dms.DSContext;
import com.savvion.sbm.util.SBMControl;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.ejb.EJBLocalHome;
import javax.ejb.FinderException;
import javax.naming.NamingException;

public class SVOFactory {
    public static ProcessTemplate getProcessTemplate(Session session, long ptid) {
        WFProcess ptObject = ProcessControl.getProcessTemplate(ptid);
        return new ProcessTemplate(session, ptObject.getAttributes());
    }

    public static ProcessTemplate getProcessTemplate(Session session, String ptName) {
        WFProcess ptObject = ProcessControl.getProcessTemplate(ptName);
        return new ProcessTemplate(session, ptObject.getAttributes());
    }

    public static ProcessTemplate getProcessTemplate(Session session, WFProcessContext pCtx) {
        WFProcess ptObject = pCtx.getProcess();
        HashMap attrs = ptObject.getAttributes();
        return new ProcessTemplate(session, attrs);
    }

    public static ProcessTemplate getProcessTemplate(Session session, WFProcess ptObject) {
        return new ProcessTemplate(session, ptObject.getAttributes());
    }

    public static ProcessInstance getProcessInstance(Session session, long piid) {
        HashMap piAttrs = BLControl.util.getProcessInstanceEB(piid).getAttributes();
        WFProcessContext pctx = new WFProcessContext(session, piid);
        return SVOFactory.createProcessInstance(session, piAttrs, pctx.getProcess());
    }

    public static ProcessInstance getProcessInstance(Session session, WFProcessContext pCtx) {
        if (pCtx.isPICompleted()) {
            return null;
        }
        HashMap piAttrs = BLControl.util.getProcessInstanceEB(pCtx.getProcessInstanceID()).getAttributes();
        return SVOFactory.createProcessInstance(session, piAttrs, pCtx.getProcess());
    }

    public static ProcessInstance getCompletedProcessInstance(Session ses, WFProcessContext pCtx) {
        ProcessInstance pi = SVOFactory.getProcessInstance(ses, pCtx);
        BLConstants.single();
        pi.setState(11);
        return pi;
    }

    public static WorkStepTemplate getWorkStepTemplate(Session session, long piid, long wsid) {
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        WFWorkstep wsObject = pCtx.getWorkstep(wsid);
        return SVOFactory.getWorkStepTemplate(session, wsObject);
    }

    public static WorkStepTemplate getWorkStepTemplate(Session session, WFProcess ptObject, String wsName) {
        WFWorkstep wsObject = ptObject.getWorkstep(wsName);
        return SVOFactory.getWorkStepTemplate(session, wsObject);
    }

    private static WorkStepTemplate getWorkStepTemplate(Session session, WFWorkstep wsObject) {
        int wsType = wsObject.getType();
        WorkStepTemplate wsTemplate = null;
        wsTemplate = wsType == 109 ? new WebServiceWSTemplate(session, wsObject.getAttributes()) : (wsType == 111 ? new MessagePublisherWSTemplate(session, wsObject.getAttributes()) : (wsType == 102 ? new ActivityWSTemplate(session, wsObject.getAttributes()) : (wsType == 112 ? new DelayWSTemplate(session, wsObject.getAttributes()) : new WorkStepTemplate(session, wsObject.getAttributes()))));
        return wsTemplate;
    }

    private static final WFProcess getProcess(HashMap attrbs) {
        WFProcess pt = null;
        long ptid = (Long)attrbs.get("PROCESSTEMPLATEID");
        long piid = (Long)attrbs.get("PROCESSINSTANCEID");
        Object obj = attrbs.get("PARENTID");
        if (obj == null) {
            throw new BizLogicException("Bizlogic_ERR_3702", "SVOFactory.getProcess(attrbs)", new Object[]{piid, ptid});
        }
        long parentID = (Long)obj;
        pt = parentID > 0L ? ProcessInstanceTemplateDAO.load(piid) : ProcessControl.getProcessTemplate(ptid);
        return pt;
    }

    public static WorkStepInstance getWorkStepInstance(Session session, long piid, String wsName) {
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        long wsid = pCtx.getProcess().getWorkstep(wsName).getID();
        return SVOFactory.getWorkStepInstance(session, pCtx, wsid);
    }

    public static WorkStepInstance getWorkStepInstance(Session session, long piid, long wsid) {
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        return SVOFactory.getWorkStepInstance(session, pCtx, wsid);
    }

    public static WorkStepInstance getParentWorkStepInstance(Session session, long subpiid) {
        HashMap subPIInfo = SubProcessDAO.findBySubProcessInstance(subpiid);
        long wsid = (Long)subPIInfo.get("WORKSTEPID");
        long piid = (Long)subPIInfo.get("PROCESSINSTANCEID");
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        return SVOFactory.getWorkStepInstance(session, pCtx, wsid);
    }

    private static final WorkStepInstance getWorkStepInstance(Session session, WFProcessContext pCtx, long wsid) {
        HashMap attrbs = pCtx.getWorkstepInstanceEB(wsid).getAttributes();
        BLConstants.single();
        attrbs.put("PROCESSINSTANCENAME", pCtx.getProcessInstanceName());
        BLConstants.single();
        attrbs.put("PARENTID", pCtx.getProcessInstanceEB().getParentID());
        BLConstants.single();
        attrbs.put("CREATOR", pCtx.getProcessInstanceEB().getCreator());
        BLConstants.single();
        attrbs.put("ISCALLBACKCALLER", pCtx.getProcessInstanceEB().getIsCallbackCaller());
        return SVOFactory.getWorkStepInstance(session, attrbs);
    }

    private static final WorkStepInstance getWorkStepInstance(Session session, HashMap attrbs) {
        WFProcess pt = SVOFactory.getProcess(attrbs);
        attrbs.put("PROCESSTEMPLATENAME", pt.getName());
        attrbs.put("ACTIVATIONTIME", attrbs.get("STARTTIME"));
        attrbs.put("APP_NAME", pt.getAppName());
        long wsid = (Long)attrbs.get("WORKSTEPID");
        WFWorkstep ws = pt.getWorkstep(wsid);
        if (ws.isAtomic()) {
            if (((WFAtomicWS)ws).isVoteEnabled()) {
                attrbs.put("VOTEINFO", Boolean.TRUE);
            }
            return new ActivityWSInstance(session, attrbs);
        }
        if (ws.isSubProcess()) {
            WFNestedWS nws = (WFNestedWS)ws;
            attrbs.put("SYNC_SUBPROCESS", nws.isSynchronous());
            return new SubProcessWSInstance(session, attrbs);
        }
        if (ws.isInlineBlock()) {
            WFInlineBlockWS inlineWS = (WFInlineBlockWS)ws;
            attrbs.put("BLOCKSTART_NAME", inlineWS.getBlockStartWSName());
            return new InlineBlockWSInstance(session, attrbs);
        }
        if (ws.isMessageSubscriberWS()) {
            return new SubscriberWSInstance(session, attrbs);
        }
        return new WorkStepInstance(session, attrbs);
    }

    public static WorkItem getWorkItem(Session session, long wiID) {
        return SVOFactory.getWorkItem(session, wiID, false);
    }

    public static WorkItem getWorkItem(Session session, long wiID, boolean withDS) {
        WorkItemEBLocal wiEB = BLUtil.self().getWorkItemEB(wiID);
        HashMap attrsList = wiEB.getAttributes();
        long wsid = (Long)attrsList.get("WORKSTEPID");
        long piid = (Long)attrsList.get("PROCESSINSTANCEID");
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        WorkStepInstanceEBLocal wsiEB = pCtx.getWorkstepInstanceEB(wsid);
        attrsList.put("INSTRUCTION", wsiEB.getInstruction());
        ProcessInstanceEBLocal piEB = BLUtil.self().getProcessInstanceEB(piid);
        attrsList.put("CREATOR", piEB.getCreator());
        attrsList.put("PARENTID", new Long(piEB.getParentID()));
        attrsList.put("PROCESSINSTANCENAME", piEB.getName());
        attrsList.put("DURATION", new Long(WFWorkstepInstance.single().getDuration(pCtx, wsid)));
        if (withDS) {
            HashMap dataslots = SVOFactory.getWorkItemDataSlotList(pCtx, wiID, true);
            attrsList.put("INPUTDATASLOTS", dataslots.get("INPUTDATASLOTS"));
            attrsList.put("OUTPUTDATASLOTS", dataslots.get("OUTPUTDATASLOTS"));
        }
        return SVOFactory.getWorkItem(session, attrsList);
    }

    public static DataSlotTemplate getDataSlotTemplate(Session session, WFProcess pt, String dsName) {
        WFDataslot ds = pt.getDataslot(dsName);
        Object dsValue = null;
        dsValue = ds.isGlobal() ? WFDataSlotInstance.self().getGlobalDSValue(session, ds) : ds.getValue();
        DataSlotTemplate dst = new DataSlotTemplate(pt.getID(), dsName, dsValue, ds.getMetaData());
        dst.setSession(session);
        return dst;
    }

    public static DataSlot getDataSlot(Session session, long piid, String dsName) {
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        long ptid = pCtx.getProcessTemplateID();
        Object dsValue = pCtx.getSlotValue(dsName, true);
        DataSlot ds = new DataSlot(ptid, piid, dsName, dsValue, null);
        ds.setSession(session);
        return ds;
    }

    public static Object getExtBusinessObject(Session session, long piid, String dsName, Object pkInfo) {
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        Object dsValue = pCtx.getExtBusinessObject(dsName, pkInfo);
        return dsValue;
    }

    public static ProcessTemplateList getProcessTemplateList(Session session) {
        Collection ptList = ProcessControl.getAllProcessTemplates();
        Vector<ProcessTemplate> newList = new Vector<ProcessTemplate>(ptList.size());
        for (WFProcess ptObject : ptList) {
            ProcessTemplate ptsvoObject = new ProcessTemplate(session, ptObject.getAttributes());
            newList.addElement(ptsvoObject);
        }
        ProcessTemplateList list = new ProcessTemplateList(session, newList);
        return list;
    }

    public static ProcessTemplateList getActivatedProcessTemplateList(Session session) {
        Collection ptList = ProcessControl.getAllProcessTemplates();
        Vector<ProcessTemplate> newList = new Vector<ProcessTemplate>(ptList.size());
        for (WFProcess ptObject : ptList) {
            if (!ptObject.isActivated()) continue;
            newList.addElement(new ProcessTemplate(session, ptObject.getAttributes()));
        }
        ProcessTemplateList list = new ProcessTemplateList(session, newList);
        return list;
    }

    public static ProcessTemplateList getSuspendedProcessTemplateList(Session session) {
        Vector ptList = ProcessControl.getSuspendedProcessTemplateList();
        Vector<ProcessTemplate> newList = new Vector<ProcessTemplate>(ptList.size());
        for (WFProcess ptObject : ptList) {
            newList.addElement(new ProcessTemplate(session, ptObject.getAttributes()));
        }
        ProcessTemplateList list = new ProcessTemplateList(session, newList);
        return list;
    }

    public static ProcessTemplateList getUserProcessTemplateList(Session session) {
        Vector ptList = ProcessControl.getUserProcessTemplateList(session.getUser());
        Vector<ProcessTemplate> newList = new Vector<ProcessTemplate>(ptList.size());
        for (WFProcess ptObject : ptList) {
            newList.addElement(new ProcessTemplate(session, ptObject.getAttributes()));
        }
        ProcessTemplateList list = new ProcessTemplateList(session, newList);
        return list;
    }

    public static ProcessTemplateList getUserAuthorizedProcessTemplateList(Session session) {
        Vector ptList = ProcessControl.getUserAuthorizedProcessTemplateList(session.getUser());
        Vector<ProcessTemplate> newList = new Vector<ProcessTemplate>(ptList.size());
        for (WFProcess ptObject : ptList) {
            newList.addElement(new ProcessTemplate(session, ptObject.getAttributes()));
        }
        ProcessTemplateList list = new ProcessTemplateList(session, newList);
        return list;
    }

    public static ProcessTemplateList getProcessTemplateList(Session session, Collection wfProcesses) {
        Vector<ProcessTemplate> list = new Vector<ProcessTemplate>();
        for (WFProcess ptObject : wfProcesses) {
            list.add(SVOFactory.getProcessTemplate(session, ptObject.getID()));
        }
        ProcessTemplateList svoList = new ProcessTemplateList(session, list);
        return svoList;
    }

    public static ProcessTemplateList getProcessTemplateList(Session session, String category, String subCategory) {
        Collection ptList = ProcessControl.getProcessTemplateListByCategory(category, subCategory);
        return SVOFactory.getProcessTemplateList(session, ptList);
    }

    public static List<ProcessTemplate> getProcessTemplates(Session session, EnumSet<PTState> ptStates) {
        List<WFProcess> ptObjects = ProcessControl.getTemplates(session, ptStates);
        ArrayList<ProcessTemplate> ptList = new ArrayList<ProcessTemplate>(ptObjects.size());
        for (WFProcess ptObject : ptObjects) {
            ptList.add(SVOFactory.getProcessTemplate(session, ptObject));
        }
        return ptList;
    }

    public static Vector getWorkStepTemplateList(Session session, WFProcess ptObject) {
        return SVOFactory.getWorkStepTemplateList(session, ptObject, true);
    }

    public static Vector getWorkStepTemplateList(Session session, WFProcess ptObject, boolean inlcudeInlineActivities) {
        Vector wfWorksteps = ptObject.getWorksteps();
        Vector<WorkStepTemplate> wsList = new Vector<WorkStepTemplate>(wfWorksteps.size());
        WFWorkstep wsObject = null;
        ProcessTemplate ptSVO = SVOFactory.getProcessTemplate(session, ptObject);
        Enumeration enumeration = wfWorksteps.elements();
        while (enumeration.hasMoreElements()) {
            wsObject = (WFWorkstep)enumeration.nextElement();
            if (!inlcudeInlineActivities && wsObject.isWithinInlineBlock()) continue;
            WorkStepTemplate wst = SVOFactory.getWorkStepTemplate(session, wsObject);
            wst.setProcessTemplate(ptSVO);
            wsList.addElement(wst);
        }
        return wsList;
    }

    public static List<WorkStepTemplate> getWorkStepTemplateList(Session session, WFProcess ptObject, int wsType) {
        ArrayList<WorkStepTemplate> worksteps = new ArrayList<WorkStepTemplate>();
        Vector wsTemplates = SVOFactory.getWorkStepTemplateList(session, ptObject, true);
        for (WorkStepTemplate wsTemplate : wsTemplates) {
            if (wsTemplate.getType() != wsType) continue;
            worksteps.add(wsTemplate);
        }
        return worksteps;
    }

    public static ProcessInstanceList getProcessInstanceList(Session session, long[] ptIDs, long[] piIDs, int[] status, String creator) {
        return SVOFactory.getProcessInstanceList(session, ptIDs, piIDs, status, creator, false);
    }

    public static ProcessInstanceList getProcessInstanceListRO(Session session, long[] ptIDs, long[] piIDs, int[] status, String creator) {
        return SVOFactory.getProcessInstanceList(session, ptIDs, piIDs, status, creator, true);
    }

    private static ProcessInstanceList getProcessInstanceList(Session session, long[] ptIDs, long[] piIDs, int[] status, String creator, boolean readOnly) {
        List<Long> invalidPTIDs;
        if (ptIDs != null && ptIDs.length > 0 && (invalidPTIDs = ProcessControl.getInvalidProcessTemplates(ptIDs)) != null && !invalidPTIDs.isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_4534", "SVOFactory.getProcessInstanceList", new Object[]{"ProcessInstanceList", invalidPTIDs});
        }
        Vector piAttrList = ProcessInstanceDAO.getProcessInstanceList(ptIDs, piIDs, status, creator, readOnly);
        Vector<ProcessInstance> piVOList = new Vector<ProcessInstance>();
        if (piAttrList != null && !piAttrList.isEmpty()) {
            for (int ix = 0; ix < piAttrList.size(); ++ix) {
                HashMap piAttr = (HashMap)piAttrList.elementAt(ix);
                Long parentID = (Long)piAttr.get("PARENTID");
                WFProcess pt = null;
                if (parentID == null || parentID <= 0L) {
                    long ptID = (Long)piAttr.get("PROCESSTEMPLATEID");
                    pt = ProcessControl.getProcessTemplate(ptID);
                } else {
                    long piID = (Long)piAttr.get("PROCESSINSTANCEID");
                    pt = ProcessControl.getProcess(piID);
                }
                piVOList.addElement(SVOFactory.createProcessInstance(session, piAttr, pt));
            }
        }
        ProcessInstanceList piList = new ProcessInstanceList(session, piVOList);
        return piList;
    }

    public static ProcessInstanceList getActiveSubProcessList(Session session, long piid, String wsName) {
        long wsid = -1L;
        if (wsName != null && !wsName.trim().isEmpty()) {
            WFProcessContext pCtx = new WFProcessContext(session, piid);
            wsid = pCtx.getProcess().getWorkstep(wsName).getID();
        }
        return SVOFactory.getActiveSubProcessList(session, piid, wsid);
    }

    public static ProcessInstanceList getActiveSubProcessList(Session session, long piid, long wsid) {
        List subPIList = null;
        subPIList = wsid == -1L ? SubProcessDAO.findByProcessInstance(piid) : SubProcessDAO.findByWorkstepInstance(piid, wsid);
        return SVOFactory.getActiveSubProcessList(session, piid, subPIList);
    }

    private static ProcessInstanceList getActiveSubProcessList(Session session, long piid, List subPIList) {
        Vector piVOList = new Vector();
        if (subPIList.isEmpty()) {
            return new ProcessInstanceList(session, piVOList);
        }
        HashMap subPIInfo = (HashMap)subPIList.get(0);
        boolean isRemote = (Boolean)subPIInfo.get("IS_REMOTE");
        piVOList = isRemote ? SVOFactory.getRemoteSubProcessInstanceList(session, piid, subPIList) : SVOFactory.getLocalSubProcessInstanceList(session, subPIList);
        ProcessInstanceList piList = new ProcessInstanceList(session, piVOList);
        return piList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Vector getRemoteSubProcessInstanceList(Session session, long piid, List subPIList) {
        Vector<ProcessInstance> piVOList;
        block17: {
            piVOList = new Vector<ProcessInstance>();
            if (subPIList == null || subPIList.isEmpty()) {
                return piVOList;
            }
            ArrayList<Long> remoteSubpiids = new ArrayList<Long>();
            HashMap subPIInfo = null;
            for (int ix = 0; ix < subPIList.size(); ++ix) {
                subPIInfo = (HashMap)subPIList.get(ix);
                long subpiid = (Long)subPIInfo.get("SUBPROCESS_INSTANCE_ID");
                remoteSubpiids.add(subpiid);
            }
            String appServer = null;
            if (subPIInfo != null) {
                appServer = (String)subPIInfo.get("APPSERVER_ID");
            }
            BLServer remoteBL = null;
            Session remoteSes = null;
            BLServerHome blServerHome2333333332 = (BLServerHome)SBMControl.homeFactory.lookupHome(appServer, BLServerHome.class);
            remoteBL = blServerHome2333333332.create();
            remoteSes = remoteBL.connect(SBMControl.util.getGuestUser(), SBMControl.util.getGuestPasswd());
            ProcessInstanceSBHome piSBHome = (ProcessInstanceSBHome)SBMControl.homeFactory.lookupHome(appServer, ProcessInstanceSBHome.class);
            ProcessInstanceSB piSB = piSBHome.create();
            HashMap piAttributes = piSB.getAttributes(remoteSes, remoteSubpiids);
            for (int ix = 0; ix < remoteSubpiids.size(); ++ix) {
                Long subpiid = (Long)remoteSubpiids.get(ix);
                HashMap piAttr = (HashMap)piAttributes.get(subpiid);
                piAttr.put("APPSERVER_ID", appServer);
                WFProcessContext pctx = new WFProcessContext(session, subpiid);
                piVOList.addElement(SVOFactory.createProcessInstance(remoteSes, piAttr, pctx.getProcess()));
            }
            try {
                if (remoteBL != null) {
                    remoteBL.disConnect(remoteSes);
                }
                break block17;
            }
            catch (Throwable blServerHome2333333332) {}
            break block17;
            catch (Exception e) {
                try {
                    WFProcessContext pCtx = new WFProcessContext(session, piid);
                    BLControl.logger.errorKey("BizLogic_ERR_881", new Object[]{pCtx.getProcessInstanceName()}, (Throwable)e);
                }
                catch (Throwable throwable) {
                    try {
                        if (remoteBL != null) {
                            remoteBL.disConnect(remoteSes);
                        }
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    if (remoteBL != null) {
                        remoteBL.disConnect(remoteSes);
                    }
                }
                catch (Throwable throwable) {}
            }
        }
        return piVOList;
    }

    private static Vector getLocalSubProcessInstanceList(Session session, List subPIList) {
        Vector<ProcessInstance> piVOList = new Vector<ProcessInstance>();
        if (subPIList == null || subPIList.isEmpty()) {
            return piVOList;
        }
        long[] piids = new long[subPIList.size()];
        for (int ix = 0; ix < subPIList.size(); ++ix) {
            long subpiid;
            HashMap subPIInfo = (HashMap)subPIList.get(ix);
            piids[ix] = subpiid = ((Long)subPIInfo.get("SUBPROCESS_INSTANCE_ID")).longValue();
        }
        Vector piAttrList = ProcessInstanceDAO.getProcessInstanceList(null, piids, null, null, false);
        if (piAttrList != null && !piAttrList.isEmpty()) {
            for (int ix = 0; ix < piAttrList.size(); ++ix) {
                HashMap piAttr = (HashMap)piAttrList.elementAt(ix);
                WFProcessContext pctx = new WFProcessContext(session, piids[ix]);
                piVOList.addElement(SVOFactory.createProcessInstance(session, piAttr, pctx.getProcess()));
            }
        }
        return piVOList;
    }

    public static WorkItemList getWorkItemList(Session session, long[] ptIDs, long[] piIDs, int[] status, String performer) {
        return SVOFactory.getWorkItemList(session, ptIDs, piIDs, status, performer, false);
    }

    public static WorkItemList getWorkItemListRO(Session session, long[] ptIDs, long[] piIDs, int[] status, String performer) {
        return SVOFactory.getWorkItemList(session, ptIDs, piIDs, status, performer, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WorkItemList getWorkItemList(Session session, long[] ptIDs, long[] piIDs, int[] status, String performer, boolean readOnly) {
        List queues = new ArrayList();
        if (SBMControl.util.isUseQueue() && performer != null) {
            if (status == null) {
                queues = PerformerUtil.getQueues((Session)session, (String)performer);
            } else {
                for (int i = 0; i < status.length; ++i) {
                    if (status[i] != 27) continue;
                    queues = PerformerUtil.getQueues((Session)session, (String)performer);
                }
            }
        }
        Vector wiAttrList = null;
        try {
            SessionManager.setThreadSession((Session)session);
            wiAttrList = WorkItemDAO.getWorkItemList(ptIDs, piIDs, status, performer, queues, readOnly);
        }
        finally {
            SessionManager.removeThreadSession();
        }
        return SVOFactory.getWorkItemList(session, wiAttrList);
    }

    public static WorkItemList getWorkItemList(Session session, long piID, long wsID) {
        return SVOFactory.getWorkItemList(session, piID, wsID, false);
    }

    public static WorkItemList getWorkItemListRO(Session session, long piID, long wsID) {
        return SVOFactory.getWorkItemList(session, piID, wsID, true);
    }

    public static WorkItemList getQueueWorkItemList(Session session, String[] queueNames, String[] excludeUsers) {
        if (!SBMControl.util.isUseQueue()) {
            throw new BizLogicException("BizLogic_ERR_852", "SVOFactory.getQueueWorkItemList");
        }
        if (queueNames == null || queueNames.length == 0) {
            throw new BizLogicException("BizLogic_ERR_851", "SVOFactory.getQueueWorkItemList");
        }
        Vector wiAttrList = WorkItemDAO.getQueueWorkItemList(queueNames, excludeUsers, false);
        return SVOFactory.getWorkItemList(session, wiAttrList);
    }

    private static WorkItemList getWorkItemList(Session session, long piID, long wsID, boolean readOnly) {
        Vector wiAttrList = WorkItemDAO.getWorkItemList(piID, wsID, readOnly);
        return SVOFactory.getWorkItemList(session, wiAttrList);
    }

    public static WorkItem getNextAvailableWorkItem(Session session, String performer) {
        WorkItemList wiList = SVOFactory.getNextAvailableWorkItemList(session, performer, null);
        if (wiList == null || wiList.isEmptyList()) {
            return null;
        }
        return (WorkItem)wiList.first();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorkItemList getNextAvailableWorkItemList(Session session, String performer, Map filter) {
        if (performer == null) {
            throw new BizLogicException("BizLogic_ERR_811", "SVOFactory.getNextAvailableWorkItems", new Object[]{performer});
        }
        if (!performer.equals(session.getUser())) {
            if (BLUtil.getUser((String)performer) == null) {
                throw new BizLogicException("BizLogic_ERR_811", "SVOFactory.getNextAvailableWorkItems", new Object[]{performer});
            }
        }
        filter = SVOFactory.prepareWIFilter(filter);
        try {
            BLControl.blLock.lock();
        }
        catch (SQLException sqlex) {
            throw new BizLogicException("BizLogic_ERR_1694", "SVOFactory.getNextAvailableWorkItems", new Object[]{"lock()", sqlex.getMessage()}, (Throwable)sqlex);
        }
        Vector wiAttrList = null;
        try {
            SessionManager.setThreadSession((Session)session);
            wiAttrList = WorkItemDAO.getNextAvailableWorkItems(performer, filter);
        }
        finally {
            SessionManager.removeThreadSession();
        }
        Vector<WorkItem> wiVOList = null;
        if (wiAttrList != null && !wiAttrList.isEmpty()) {
            BLConstants.single();
            int fetchsize = (Integer)filter.get("FETCHSIZE");
            if (wiAttrList.size() < fetchsize) {
                fetchsize = wiAttrList.size();
            }
            wiVOList = new Vector<WorkItem>(fetchsize + 1);
            for (int ix = 0; ix < fetchsize; ++ix) {
                HashMap wiAttr = (HashMap)wiAttrList.elementAt(ix);
                BLConstants.single();
                long wiID = (Long)wiAttr.get("WORKITEMID");
                WFProcessContext pCtx = new WFProcessContext(session, wiID, true);
                WFWorkItem.self().assignWorkItem(pCtx, wiID, performer);
                BLConstants.single();
                wiAttr.put("PERFORMER", performer);
                WorkItem wi = SVOFactory.getWorkItem(session, wiAttr);
                BLConstants.single();
                wi.setState(28);
                wiVOList.addElement(wi);
            }
        }
        return new WorkItemList(session, wiVOList);
    }

    private static Map prepareWIFilter(Map filter) {
        BLConstants.single();
        int fetchsize = 1;
        String orderBy = null;
        if (filter == null) {
            filter = new HashMap<String, Object>(2);
            BLConstants.single();
            filter.put("ORDER_BY", WorkItemDAO.orderByDueDate);
            BLConstants.single();
            filter.put("FETCHSIZE", fetchsize);
            return filter;
        }
        BLConstants.single();
        String ord = (String)filter.get("ORDER_BY");
        if (ord == null) {
            BLConstants.single();
            filter.put("ORDER_BY", WorkItemDAO.orderByDueDate);
        } else {
            BLConstants.single();
            if ("DUEDATE".equalsIgnoreCase(ord)) {
                orderBy = WorkItemDAO.orderByDueDate;
            } else {
                BLConstants.single();
                if ("PRIORITY".equalsIgnoreCase(ord)) {
                    orderBy = WorkItemDAO.orderByPriority;
                } else {
                    BLConstants.single();
                    if ("STARTTIME".equalsIgnoreCase(ord)) {
                        orderBy = WorkItemDAO.orderByStartTime;
                    } else {
                        Object[] objectArray = new Object[2];
                        objectArray[0] = ord;
                        BLConstants.single();
                        objectArray[1] = "ORDER_BY";
                        throw new BizLogicException("BizLogic_ERR_915", "SVOFactory.prepareWIFilter", objectArray);
                    }
                }
            }
            BLConstants.single();
            filter.put("ORDER_BY", orderBy);
        }
        BLConstants.single();
        String fetch = (String)filter.get("FETCHSIZE");
        if (fetch == null) {
            BLConstants.single();
            filter.put("FETCHSIZE", fetchsize);
        } else {
            try {
                fetchsize = Integer.parseInt(fetch);
            }
            catch (NumberFormatException nex) {
                Object[] objectArray = new Object[2];
                objectArray[0] = fetch;
                BLConstants.single();
                objectArray[1] = "FETCHSIZE";
                throw new BizLogicException("BizLogic_ERR_915", "SVOFactory.prepareWIFilter", objectArray);
            }
            BLConstants.single();
            filter.put("FETCHSIZE", fetchsize);
        }
        BLConstants.single();
        Object obj = filter.get("PROCESSTEMPLATEID");
        if (obj != null) {
            BLConstants.single();
            filter.put("PROCESSTEMPLATEID", SVOFactory.getFilterValue(obj));
        }
        BLConstants.single();
        obj = filter.get("WORKSTEPNAME");
        if (obj != null) {
            BLConstants.single();
            filter.put("WORKSTEPNAME", SVOFactory.getFilterValue(obj));
        }
        return filter;
    }

    private static List getFilterValue(Object obj) {
        List<Object> listObj = null;
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            listObj = new Vector<Object>(1);
            listObj.add(obj);
        } else if (obj instanceof List) {
            listObj = (List)obj;
        } else {
            throw new BizLogicException("BizLogic_ERR_810", "SVOFactory.getFilterValue", new Object[]{obj.getClass().getName()});
        }
        return listObj;
    }

    public static WorkStepInstanceList getWorkStepInstanceList(Session session, long[] ptids, long[] piids, int[] status, String creator, boolean inlcudeInlineActivities) {
        return SVOFactory.getWorkStepInstanceList(session, ptids, piids, status, null, creator, false, false, inlcudeInlineActivities);
    }

    public static WorkStepInstanceList getWorkStepInstanceList(Session session, long[] ptids, long[] piids, int[] status, String creator) {
        return SVOFactory.getWorkStepInstanceList(session, ptids, piids, status, null, creator, false, false, true);
    }

    public static WorkStepInstanceList getSuspendedWorkStepInstanceList(Session session, long[] ptids, long[] piids, int[] status, String creator) {
        return SVOFactory.getWorkStepInstanceList(session, ptids, piids, status, null, creator, false, true, true);
    }

    public static WorkStepInstanceList getWorkStepInstanceListRO(Session session, long[] ptids, long[] piids, int[] status, String creator) {
        return SVOFactory.getWorkStepInstanceList(session, ptids, piids, status, null, creator, true, false, true);
    }

    private static WorkStepInstanceList getWorkStepInstanceList(Session session, long[] ptids, long[] piids, int[] status, int[] types, String creator, boolean readOnly, boolean orderByPiid, boolean inlcudeInlineActivities) {
        List<Long> invalidPTIDs;
        if (ptids != null && ptids.length > 0 && (invalidPTIDs = ProcessControl.getInvalidProcessTemplates(ptids)) != null && !invalidPTIDs.isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_4534", "SVOFactory.getWorkStepInstanceList", new Object[]{"WorkStepInstanceList", invalidPTIDs});
        }
        Vector attrsList = WorkStepInstanceDAO.getWorkStepInstanceList(ptids, piids, status, types, creator, readOnly, orderByPiid, inlcudeInlineActivities);
        Vector<WorkStepInstance> wsiList = new Vector<WorkStepInstance>();
        for (int ix = 0; ix < attrsList.size(); ++ix) {
            HashMap attrs = (HashMap)attrsList.elementAt(ix);
            wsiList.addElement(SVOFactory.getWorkStepInstance(session, attrs));
        }
        WorkStepInstanceList wsl = new WorkStepInstanceList(session, wsiList);
        return wsl;
    }

    public static Vector getDataSlotTemplateList(Session session, WFProcess ptObject, String[] dsNames, boolean startWS) {
        if (dsNames == null || dsNames.length == 0) {
            return new Vector();
        }
        Vector dsBlobList = ptObject.getDataslots();
        Vector<DataSlotTemplate> dsList = new Vector<DataSlotTemplate>(dsNames.length);
        WFDataslot dsObject = null;
        DataSlotTemplate dsTemplate = null;
        block0: for (int count = 0; count < dsNames.length; ++count) {
            Enumeration enumeration = dsBlobList.elements();
            while (enumeration.hasMoreElements()) {
                dsObject = (WFDataslot)enumeration.nextElement();
                String dsName = dsObject.getName();
                if (!dsName.equals(dsNames[count])) continue;
                Object val = null;
                val = dsObject.isGlobal() ? WFDataSlotInstance.self().getGlobalDSValue(session, dsObject) : dsObject.getValue();
                if (startWS && dsObject.isValueMapped()) {
                    val = null;
                }
                dsTemplate = new DataSlotTemplate(dsObject.getParentProcess().getID(), dsObject.getName(), val, dsObject.getMetaData());
                dsTemplate.setSession(session);
                dsList.addElement(dsTemplate);
                continue block0;
            }
        }
        return dsList;
    }

    public static Vector getDataSlotTemplateList(Session session, WFProcess ptObject) {
        Vector dsBlobList = ptObject.getDataslots();
        Vector<DataSlotTemplate> dsList = new Vector<DataSlotTemplate>(dsBlobList.size());
        WFDataslot dsObject = null;
        DataSlotTemplate dsTemplate = null;
        Enumeration enumeration = dsBlobList.elements();
        while (enumeration.hasMoreElements()) {
            dsObject = (WFDataslot)enumeration.nextElement();
            Object dsValue = null;
            dsValue = dsObject.isGlobal() ? WFDataSlotInstance.self().getGlobalDSValue(session, dsObject) : dsObject.getValue();
            dsTemplate = new DataSlotTemplate(dsObject.getParentProcess().getID(), dsObject.getName(), dsValue, dsObject.getMetaData());
            dsTemplate.setSession(session);
            dsList.addElement(dsTemplate);
        }
        return dsList;
    }

    public static DataSlotList getDataSlotList(Session session, long piid) {
        return SVOFactory.getDataSlotList(session, piid, false);
    }

    public static DataSlotList getDataSlotList(Session session, long piid, boolean withMetaData) {
        return SVOFactory.getDataSlotList(session, piid, withMetaData, true);
    }

    public static DataSlotList getDataSlotList(Session session, long piid, boolean withMetaData, boolean isPublicOnly) {
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        HashMap dataslots = pCtx.getInstanceSlotValue(isPublicOnly);
        return SVOFactory.convertToDataSlotList(pCtx, session, dataslots, withMetaData);
    }

    public static DataSlotList getDataSlotList(Session session, long piid, String[] dsNames) {
        return SVOFactory.getDataSlotList(session, piid, dsNames, false);
    }

    public static DataSlotList getDataSlotList(Session session, long piid, String[] dsNames, boolean withMetaData) {
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        HashMap dataslots = pCtx.getSlotValue(dsNames);
        return SVOFactory.convertToDataSlotList(pCtx, session, dataslots, withMetaData);
    }

    public static DataSlotList getDataSlotList(Session session, long[] piidList, Vector dsNames) {
        Vector list = new Vector();
        for (int i = 0; i < piidList.length; ++i) {
            Vector v = (Vector)SVOFactory.getDataSlotList(session, piidList[i]).getList();
            list.setSize(list.size() + v.size());
            list.addAll(v);
        }
        DataSlotList dsList = new DataSlotList(session, list);
        return dsList;
    }

    /*
     * Unable to fully structure code
     */
    public static DataSlotList getDataSlotList(WFProcessContext pCtx, long ptid, long piid, long wsid, String[] dsNames, boolean withMetaInfo) {
        block4: {
            block3: {
                list = null;
                if (dsNames != null && dsNames.length != 0) break block3;
                list = new Vector<DataSlot>();
                break block4;
            }
            list = new Vector<E>(dsNames.length);
            dsNameValueList = pCtx.getSlotValue(wsid, dsNames);
            iter = dsNameValueList.keySet().iterator();
            dsName = null;
            dsValue = null;
            ds = null;
            while (iter.hasNext()) {
                dsName = (String)iter.next();
                dsValue = dsNameValueList.get(dsName);
                if (!withMetaInfo) ** GOTO lbl-1000
                if (!dsName.startsWith("@")) {
                    dsTemp = pCtx.getWorkstep(wsid).getDataslot(dsName);
                    ds = new DataSlot(ptid, piid, dsName, dsValue, dsTemp.getMetaData());
                } else lbl-1000:
                // 2 sources

                {
                    ds = new DataSlot(ptid, piid, dsName, dsValue, null);
                }
                ds.setSession(pCtx.getSession());
                list.add(ds);
            }
        }
        dsSVOList = new DataSlotList(pCtx.getSession(), list);
        return dsSVOList;
    }

    public static HashMap getWorkItemDataSlotList(WFProcessContext pCtx, long wiid, boolean withMetaData) {
        if (BLControl.util.DEBUG_API) {
            BLControl.logger.debugKey("BizLogic_ERR_4721", "SVOFactory.getWorkItemDataSlotList(pCtx,wiid,withMetaData)", new Object[]{pCtx.getProcessInstanceID(), wiid});
        }
        HashMap<String, DataSlotList> wiDSList = new HashMap<String, DataSlotList>();
        WorkItemEBLocal wieb = pCtx.getWorkItemEB(wiid);
        long ptid = wieb.getProcessTemplateID();
        long piid = wieb.getProcessInstanceID();
        long wsid = wieb.getWorkStepID();
        WFWorkstep ws = pCtx.getWorkstep(wsid);
        String[] dsNameList = ws.getSlotKeys();
        if (dsNameList.length == 0) {
            return wiDSList;
        }
        List<String> dsInputNameList = Arrays.asList(ws.getInputSlotsKeys());
        List<String> dsOutputNameList = Arrays.asList(ws.getOutputSlotsKeys());
        DataSlotList dsList = SVOFactory.getDataSlotList(pCtx, ptid, piid, wsid, dsNameList, withMetaData);
        List dsSVOlist = dsList.getList();
        Vector<DataSlot> inputDSlist = new Vector<DataSlot>();
        Vector<DataSlot> outputDSlist = new Vector<DataSlot>();
        for (Object dsObj : dsSVOlist) {
            DataSlot ds = (DataSlot)dsObj;
            if (dsInputNameList.contains(ds.getName())) {
                inputDSlist.add(ds);
            }
            if (!dsOutputNameList.contains(ds.getName())) continue;
            outputDSlist.add(ds);
        }
        dsList = new DataSlotList(pCtx.getSession(), inputDSlist);
        wiDSList.put("INPUTDATASLOTS", dsList);
        dsList = new DataSlotList(pCtx.getSession(), outputDSlist);
        wiDSList.put("OUTPUTDATASLOTS", dsList);
        return wiDSList;
    }

    /*
     * Unable to fully structure code
     */
    private static DataSlotList convertToDataSlotList(WFProcessContext pCtx, Session session, HashMap dataslots, boolean withMetaData) {
        block4: {
            block3: {
                list = null;
                if (dataslots != null && !dataslots.isEmpty()) break block3;
                list = new Vector<DataSlot>();
                break block4;
            }
            list = new Vector<E>(dataslots.size());
            ds = null;
            dsName = null;
            dsValue = null;
            iter = dataslots.keySet().iterator();
            ptid = pCtx.getProcessTemplateID();
            piid = pCtx.getProcessInstanceID();
            while (iter.hasNext()) {
                dsName = (String)iter.next();
                dsValue = dataslots.get(dsName);
                if (!withMetaData) ** GOTO lbl-1000
                if (!dsName.startsWith("@")) {
                    dsTemp = pCtx.getDataslot(dsName);
                    ds = new DataSlot(ptid, piid, dsName, dsValue, dsTemp.getMetaData());
                } else lbl-1000:
                // 2 sources

                {
                    ds = new DataSlot(ptid, piid, dsName, dsValue, null);
                }
                ds.setSession(session);
                list.add(ds);
            }
        }
        dsList = new DataSlotList(session, list);
        return dsList;
    }

    public static ProcessCountList getProcessCountList(String performer, boolean readOnly) {
        return SVOFactory.getProcessCountList(performer, null, null, readOnly);
    }

    public static ProcessCountList getProcessCountList(String performer, List<String> ptNames, String appName, boolean readOnly) {
        Long ptid;
        List<String> invalidPTNames;
        BLControl.logger.debugKey("BizLogic_ERR_3230", "SVOFactory.getProcessCountList", new Object[]{performer, ptNames, appName});
        if (ptNames != null && !ptNames.isEmpty() && (invalidPTNames = ProcessControl.getInvalidProcessTemplates(ptNames)) != null && !invalidPTNames.isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_4529", "SVOFactory.getProcessCountList", new Object[]{invalidPTNames});
        }
        if (appName != null && appName.trim().length() > 0 && !ApplicationManager.isApplicationExist(appName)) {
            throw new BizLogicException("BizLogic_ERR_4530", "SVOFactory.getProcessCountList", new Object[]{appName});
        }
        HashMap workitem = WorkItemDAO.getCountByProcessTemplate(performer, readOnly);
        HashMap processinstance = ProcessInstanceDAO.getCountByProcessTemplate(performer, readOnly);
        WFProcess pt = null;
        Vector<ProcessCount> pclist = new Vector<ProcessCount>();
        ProcessCount pc = null;
        HashMap pistatus = null;
        Iterator itr = processinstance.keySet().iterator();
        HashMap wistatus = null;
        while (itr.hasNext()) {
            ptid = (Long)itr.next();
            pistatus = (HashMap)processinstance.get(ptid);
            Object o = workitem.get(ptid);
            if (o == null) {
                wistatus = new HashMap();
            } else {
                wistatus = (HashMap)o;
                workitem.remove(ptid);
            }
            if (!SVOFactory.isProcessCountSelected(pt = ProcessControl.getProcessTemplate(ptid), ptNames, appName)) continue;
            pc = new ProcessCount(ptid, pistatus, wistatus, pt.getName(), pt.getAppName(), pt.getStatus());
            pclist.add(pc);
        }
        itr = workitem.keySet().iterator();
        pistatus = new HashMap();
        while (itr.hasNext()) {
            ptid = (Long)itr.next();
            wistatus = (HashMap)workitem.get(ptid);
            pt = ProcessControl.getProcessTemplate(ptid);
            if (!SVOFactory.isProcessCountSelected(pt, ptNames, appName)) continue;
            pc = new ProcessCount(ptid, pistatus, wistatus, pt.getName(), pt.getAppName(), pt.getStatus());
            pclist.add(pc);
        }
        ProcessCountList pcl = new ProcessCountList(pclist, performer);
        return pcl;
    }

    private static boolean isProcessCountSelected(WFProcess pt, List ptNames, String appName) {
        if ((ptNames == null || ptNames.isEmpty()) && (appName == null || appName.trim().isEmpty())) {
            return true;
        }
        if (ptNames == null || ptNames.isEmpty() ? appName.equals(pt.getAppName()) : (appName == null || appName.trim().isEmpty() ? ptNames.contains(pt.getName()) : appName.equals(pt.getAppName()) && ptNames.contains(pt.getName()))) {
            return true;
        }
        BLControl.logger.debugKey("BizLogic_ERR_3231", "SVOFactory.isValidProcessCount", new Object[]{pt.getName(), ptNames, pt.getAppName(), appName});
        return false;
    }

    private static EJBLocalHome getEJBLocalHome(Class object) throws NamingException {
        return SBMControl.homeFactory.lookupLocalHome(object);
    }

    private static void handleException(Exception e, String ctx, Object[] args) {
        if (e instanceof NamingException) {
            throw new BizLogicException("BizLogic_ERR_1527", ctx, args, (Throwable)e);
        }
        if (e instanceof FinderException) {
            throw new BizLogicException("BizLogic_ERR_1589", ctx, args, (Throwable)e);
        }
    }

    private static WorkItem getWorkItem(Session session, HashMap attrsList) {
        long wsid = (Long)attrsList.get("WORKSTEPID");
        long piid = (Long)attrsList.get("PROCESSINSTANCEID");
        long ptid = (Long)attrsList.get("PROCESSTEMPLATEID");
        WFProcess pt = SVOFactory.getProcess(attrsList);
        WFWorkstep ws = pt.getWorkstep(wsid);
        if (!ws.hasMappedDuration()) {
            attrsList.put("DURATION", ws.getDuration());
        }
        attrsList.put("OUTPUTDATASLOTNAMES", ws.getOutputSlotsMapping());
        attrsList.put("INPUTDATASLOTNAMES", ws.getInputSlotsMapping());
        attrsList.put("PROCESSTEMPLATENAME", pt.getName());
        attrsList.put("APP_NAME", pt.getAppName());
        attrsList.put("PERFORMINGAPP", ((WFAtomicWS)ws).getPerformingApp());
        String milestoneName = ws.getMilestoneName();
        if (milestoneName != null && !"".equals(milestoneName)) {
            String milestoneDesc = ws.getMilestoneDescription();
            attrsList.put("MILESTONE_NAME", milestoneName);
            attrsList.put("MILESTONE_DESC", milestoneDesc);
        }
        boolean collaborationEnabled = ((WFAtomicWS)ws).isCollaborationEnabled();
        attrsList.put("COLLABORATION_ENABLED", collaborationEnabled);
        if (collaborationEnabled) {
            List<String> actualCollaborators = WFCWorkItem.self().getRealCollaborators(piid, (WFAtomicWS)ws);
            attrsList.put("COLLABORATORS", actualCollaborators);
        } else {
            attrsList.put("COLLABORATORS", new CopyOnWriteArrayList());
        }
        return new WorkItem(session, attrsList);
    }

    public static WorkItemList getProxyWorkItemList(Session session, String proxyPerformer, ArrayList proxyFor, long[] ptIDs, int[] status, boolean isOnlyAvailable, boolean readOnly) {
        Map proxyForAndApp = null;
        try {
            proxyForAndApp = ProxyManager.getActiveProxyForAndApplications((String)proxyPerformer);
        }
        catch (ProxyException e) {
            throw new BizLogicException("BizLogic_ERR_1694", "SVOFactory::getProxyWorkItemList()", new Object[]{"ProxyManager.getActiveProxyForAndApplications", e.getMessage()}, (Throwable)e);
        }
        if (proxyForAndApp == null || proxyForAndApp.isEmpty()) {
            return new WorkItemList(session, null);
        }
        if (proxyFor != null && !proxyFor.isEmpty()) {
            proxyForAndApp.keySet().retainAll(proxyFor);
            if (proxyForAndApp.isEmpty()) {
                return new WorkItemList(session, null);
            }
        }
        HashMap filteredProxyForAndApp = new HashMap(proxyForAndApp.size());
        ArrayList<Long> userSpecifiedPTIDs = null;
        if (ptIDs != null && ptIDs.length > 0) {
            userSpecifiedPTIDs = new ArrayList<Long>(ptIDs.length);
            for (int ix = ptIDs.length - 1; ix >= 0; --ix) {
                userSpecifiedPTIDs.add(ptIDs[ix]);
            }
        }
        Map.Entry entry2 = null;
        ArrayList appIDs = null;
        for (Map.Entry entry2 : proxyForAndApp.entrySet()) {
            appIDs = SVOFactory.convertAppNameToLongID((List)entry2.getValue());
            if (appIDs != null && userSpecifiedPTIDs != null && !userSpecifiedPTIDs.isEmpty()) {
                appIDs.retainAll(userSpecifiedPTIDs);
            }
            if (appIDs == null || appIDs.isEmpty()) continue;
            filteredProxyForAndApp.put(entry2.getKey(), appIDs);
        }
        Vector wiAttrList = null;
        if (filteredProxyForAndApp != null && !filteredProxyForAndApp.isEmpty()) {
            wiAttrList = WorkItemDAO.getProxyWorkItemList(filteredProxyForAndApp, status, isOnlyAvailable, readOnly);
        }
        return SVOFactory.getWorkItemList(session, wiAttrList);
    }

    private static final ArrayList convertAppNameToLongID(List ptAppNames) {
        if (ptAppNames == null) {
            return null;
        }
        ArrayList<Long> ptIDs = new ArrayList<Long>(ptAppNames.size());
        for (int ix = ptAppNames.size() - 1; ix >= 0; --ix) {
            String ptAppName = (String)ptAppNames.get(ix);
            ptIDs.add(ProcessControl.getProcessTemplate(ptAppName).getID());
        }
        return ptIDs;
    }

    public static final WorkItemList getWorkItemList(Session session, Vector wiAttrList) {
        Vector<WorkItem> wiVOList = null;
        if (wiAttrList != null && !wiAttrList.isEmpty()) {
            wiVOList = new Vector<WorkItem>(wiAttrList.size() + 1);
            for (int ix = 0; ix < wiAttrList.size(); ++ix) {
                HashMap wiAttr = (HashMap)wiAttrList.elementAt(ix);
                wiVOList.addElement(SVOFactory.getWorkItem(session, wiAttr));
            }
        }
        return new WorkItemList(session, wiVOList);
    }

    public static VoteResult getVoteResult(Session session, long piid, long wsid) {
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        HashMap voteattrs = WFAtomicInstance.self().getVoteResultAttributes(pCtx, wsid);
        return SVOFactory.getVoteResult(voteattrs);
    }

    public static VoteCriteria getVoteCriteria(long pid, String wsName, boolean dynamic) {
        WFProcess pt = ProcessControl.getProcess(pid, dynamic);
        WFWorkstep ws = pt.getWorkstep(wsName);
        if (ws.isAtomic() && ((WFAtomicWS)ws).isVoteEnabled()) {
            return ((WFVoteWS)ws).getVoteCriteria();
        }
        return null;
    }

    public static VoteCriteria getVoteCriteria(HashMap attribs) {
        try {
            return new VoteCriteria(attribs);
        }
        catch (Throwable th) {
            throw new BizLogicException("BizLogic_ERR_6022", "SVOFactory.getVoteCriteria", th);
        }
    }

    public static VoteResult getVoteResult(HashMap attribs) {
        return new VoteResult(attribs);
    }

    public static ProcessInstanceList getProcessInstanceList(Session session, long ptid, String milestoneName) {
        WFProcess pt = ProcessControl.getProcessTemplate(ptid);
        Vector<ProcessInstance> piVOList = new Vector<ProcessInstance>();
        Vector piAttrList = null;
        List wsidList = pt.getWorkstepIDList(milestoneName);
        BLControl.logger.debugKey("Bizlogic_ERR_3201", "SVOFactory.getProcessInstanceList", new Object[]{pt.getName(), wsidList, milestoneName});
        if (wsidList != null && !wsidList.isEmpty()) {
            piAttrList = ProcessInstanceDAO.getProcessInstanceList(ptid, wsidList);
        }
        if (piAttrList != null && !piAttrList.isEmpty()) {
            for (int ix = 0; ix < piAttrList.size(); ++ix) {
                HashMap piAttr = (HashMap)piAttrList.elementAt(ix);
                BLConstants.single();
                WFProcessContext pctx = new WFProcessContext(session, (Long)piAttr.get("PROCESSINSTANCEID"));
                piVOList.addElement(SVOFactory.createProcessInstance(session, piAttr, pctx.getProcess()));
            }
        }
        ProcessInstanceList piList = new ProcessInstanceList(session, piVOList);
        return piList;
    }

    public static WorkStepInstanceList getWorkStepInstanceListForMilestone(Session session, long ptid, long piid) {
        return SVOFactory.getWorkStepInstanceList(session, ptid, piid, null);
    }

    public static WorkStepInstanceList getWorkStepInstanceList(Session session, long ptid, String milestoneName) {
        return SVOFactory.getWorkStepInstanceList(session, ptid, -1L, milestoneName);
    }

    private static WorkStepInstanceList getWorkStepInstanceList(Session session, long ptid, long piid, String milestoneName) {
        WFProcess pt = ProcessControl.getProcessTemplate(ptid);
        Vector<WorkStepInstance> wsiVOList = new Vector<WorkStepInstance>();
        Vector wsiAttrList = null;
        List wsidList = pt.getWorkstepIDList(milestoneName);
        BLControl.logger.debugKey("Bizlogic_ERR_3201", "SVOFactory.getWorkStepInstanceList", new Object[]{pt.getName(), wsidList, milestoneName});
        if (wsidList != null && !wsidList.isEmpty()) {
            wsiAttrList = WorkStepInstanceDAO.getWorkStepInstanceList(ptid, piid, wsidList);
        }
        if (wsiAttrList != null && !wsiAttrList.isEmpty()) {
            for (int ix = 0; ix < wsiAttrList.size(); ++ix) {
                HashMap wsiAttr = (HashMap)wsiAttrList.elementAt(ix);
                long wsid = (Long)wsiAttr.get("WORKSTEPID");
                milestoneName = pt.getMilestoneName(wsid);
                if (milestoneName != null && !"".equals(milestoneName)) {
                    wsiAttr.put("MILESTONE_NAME", milestoneName);
                    wsiAttr.put("MILESTONE_DESC", pt.getMilestoneDescription(milestoneName));
                }
                wsiVOList.addElement(SVOFactory.getWorkStepInstance(session, wsiAttr));
            }
        }
        return new WorkStepInstanceList(session, wsiVOList);
    }

    public static Application getApplication(Session session, String appName) {
        BLControl.logger.debugKey("Bizlogic_ERR_3203", "SVOFactory.getApplication(ses)", new Object[]{appName});
        if (null == appName || appName.trim().length() == 0) {
            throw new BizLogicException("Bizlogic_ERR_3801", "SVOFactory.getApplication");
        }
        Collection ptCollection = ProcessControl.getVersions(appName);
        if (ptCollection.isEmpty()) {
            throw new BizLogicException("Bizlogic_ERR_3714", "SVOFactory.getApplication", new Object[]{appName});
        }
        Iterator iterator = ptCollection.iterator();
        TreeMap<Long, ProcessTemplate> treeMap = new TreeMap<Long, ProcessTemplate>();
        while (iterator.hasNext()) {
            WFProcess ptObject = (WFProcess)iterator.next();
            treeMap.put(ptObject.getStartTime(), SVOFactory.getProcessTemplate(session, ptObject));
        }
        ArrayList ptsvos = new ArrayList(treeMap.values());
        return new Application(session, appName, ptsvos);
    }

    public static ProcessTemplate getLastVersion(Session session, String appName) {
        if (null == appName || appName.trim().length() == 0) {
            throw new BizLogicException("Bizlogic_ERR_3801", "SVOFactory.getLastVersion(ses, appName)");
        }
        Application app = SVOFactory.getApplication(session, appName);
        ProcessTemplate pt = app.getLastVersion();
        if (BLControl.util.DEBUG_CREATE) {
            BLControl.logger.debugKey("BizLogic_ERR_8109", "SVOFactory.getLastVersion(ses,appName)", new Object[]{pt.getName(), appName});
        }
        return pt;
    }

    public static ArrayList getApplicationList(Session session) {
        Collection appNameList = ProcessControl.getAppNames();
        BLControl.logger.debugKey("Bizlogic_ERR_3202", "SVOFactory.getApplicationList(ses)", new Object[]{appNameList});
        ArrayList<Application> appList = new ArrayList<Application>();
        for (String appName : appNameList) {
            try {
                Application app = SVOFactory.getApplication(session, appName);
                appList.add(app);
            }
            catch (Throwable throwable) {}
        }
        return appList;
    }

    private static ProcessInstance createProcessInstance(Session session, HashMap attrs, WFProcess process) {
        BLConstants.single();
        attrs.put("ISDATASLOTSQLMAP", process.hasSqlMapDatsSlots());
        WFProcess pt = SVOFactory.getProcess(attrs);
        String appName = pt.getAppName();
        String ptName = pt.getName();
        attrs.put("APP_NAME", appName);
        attrs.put("PROCESSTEMPLATENAME", ptName);
        return new ProcessInstance(session, attrs);
    }

    public static DocumentDS getDocumentDS(DSContext dsContext, long ptid, long piid, String dsName, String dsFolderId, long parentPiid, boolean isEditableByAuthor, boolean isDocBundle) {
        if (piid == -1L) {
            return new DocumentDS(dsContext, ptid, dsName, dsFolderId, parentPiid, isEditableByAuthor, isDocBundle);
        }
        return new DocumentDS(dsContext, ptid, piid, dsName, dsFolderId, parentPiid, isEditableByAuthor, isDocBundle);
    }

    public static CWorkItem getCWorkItem(Session session, long cwiid) {
        Map<String, Object> cwiData = CWorkItemDAO.getCWorkItem(cwiid, true);
        return new CWorkItem(session, cwiData);
    }

    public static ProcessNotes getProcessNotes(Session session, long notesID) {
        Map<String, Object> notesData = ProcessNotesDAO.getProcessNotes(notesID);
        return new ProcessNotes(session, notesID, notesData);
    }

    public static HashMap getQSWorkItemDataAttributes(Session session, long piid, long wsID, long wiID) {
        if (BLControl.util.DEBUG_API) {
            BLControl.logger.debugKey("BizLogic_ERR_4722", "SVOFactory.getQSWorkItemDataAttributes(session,piid,wsID,wiID)", new Object[]{piid, wsID, wiID});
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        WorkStepInstanceEBLocal wsiEB = pCtx.getWorkstepInstanceEB(wsID);
        BLConstants.single();
        attributes.put("PERFORMINGAPP", pCtx.getWorkstepRealPerformingApp(wsID));
        BLConstants.single();
        attributes.put("INSTRUCTION", wsiEB.getInstruction());
        WFProcess pt = pCtx.getProcess();
        WFWorkstep ws = pt.getWorkstep(wsID);
        long duration = WFWorkstepInstance.single().getDuration(pCtx, wsID);
        attributes.put("DURATION", duration);
        attributes.put("OUTPUTDATASLOTNAMES", ws.getOutputSlotsMapping());
        attributes.put("INPUTDATASLOTNAMES", ws.getInputSlotsMapping());
        return attributes;
    }
}

