/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.dao;

import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLDAOService;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.DBConstants;
import com.savvion.sbm.util.BMTimer;
import com.savvion.sbm.util.SBMDatabase;
import com.savvion.sbm.util.ServiceLocator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Vector;

public class TimerActionDAO
extends BLDAOService {
    private static final String DELETE_FROM = "delete from ";
    private static final String WHERE = " where ";
    private static final String QUESTION_WITH_SPACE = " = ? ";
    private static final String QUESTION_WITH_AND = " = ? AND ";
    private static final String QUESTION_WITH_COMMA = "= ?, ";
    private static final String QUESTION_WITH_WHERE = "= ? where ";
    private static final String QUESTION = " = ?";
    private static final String UPDATE = "update ";
    private static final String SET = " set ";
    private static final String EQUALS = " = ";
    private static final String PLUS_1_WHERE = " + 1 where ";
    private static final String SELECT = "select ";
    private static final String BLTA = "BLTA.";
    private static final String BLWSI = "BLWSI.";
    private static final String COMMA = ", ";
    private static final String FROM = " from ";
    private static final String BLTA_VALUE = " BLTA ";
    private static final String BLWSI_VALUE = " BLWSI ";
    private static final String AND = " AND ";
    private static final String LESS_THAN_OR_EQUAL_QUESTION = " <= ? ";
    private static final String NOT_EQUAL = " != ";
    private static final String ORDER_BY = " order by ";
    private static String insert = null;
    private static String removeByProcessInstance = null;
    private static String removeByProcessTemplate = null;
    private static String removeByWorkStepInstance = null;
    private static String removeByID = null;
    private static String increaseOverDueTimes = null;
    private static String increaseOverDueTimesOnly = null;
    private static String updateDueDate = null;
    private static String getOverDueList = null;
    private static String getOverDueCount = null;
    private static final String[] CREATE_LIST;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long create(long piid, long wsid, long ptid, long duedate, String actionName, String actionInput, String notifyEmail, String actionCreator) {
        long taid = -1L;
        Connection conn = null;
        PreparedStatement pstmtInsert = null;
        try {
            conn = TimerActionDAO.getConnection();
            pstmtInsert = conn.prepareStatement(insert);
            Vector<Object> values = new Vector<Object>(10);
            taid = BLControl.util.taSeq.getNextNumber();
            values.addElement(taid);
            values.addElement(ptid);
            values.addElement(piid);
            values.addElement(wsid);
            values.addElement(TimerActionDAO.getDateValue((long)duedate));
            values.addElement(0);
            if (actionName == null) {
                actionName = "";
            }
            values.addElement(actionName);
            if (actionInput == null) {
                actionInput = "";
            }
            values.addElement(actionInput);
            if (notifyEmail == null) {
                notifyEmail = "";
            }
            values.addElement(notifyEmail);
            if (actionCreator == null) {
                actionCreator = "";
            }
            values.addElement(actionCreator);
            TimerActionDAO.setPrepStmtValues((PreparedStatement)pstmtInsert, values);
            pstmtInsert.executeUpdate();
            if (BLControl.util.DEBUG_DAO) {
                String parameters = TimerActionDAO.getDebugMessage(taid, ptid, piid, wsid, duedate);
                BLControl.logger.debugKey("BizLogic_ERR_1207", new Object[]{insert, parameters});
            }
        }
        catch (SQLException sqlex) {
            TimerActionDAO.handle((SQLException)sqlex);
        }
        finally {
            TimerActionDAO.clean(null, (Statement)pstmtInsert, (Connection)conn);
        }
        return taid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeByProcessTemplate(long ptid) {
        Connection conn = null;
        PreparedStatement pstmtRemove = null;
        try {
            conn = TimerActionDAO.getConnection();
            pstmtRemove = conn.prepareStatement(removeByProcessTemplate);
            if (BLControl.util.DEBUG_DAO) {
                StringBuffer buffer = TimerActionDAO.getDebugMessage(-1L, ptid, -1L, -1L);
                BLControl.logger.debugKey("BizLogic_ERR_1207", new Object[]{removeByProcessTemplate, buffer.toString()});
            }
            pstmtRemove.setLong(1, ptid);
            pstmtRemove.executeUpdate();
        }
        catch (SQLException sqlex) {
            TimerActionDAO.handle((SQLException)sqlex);
        }
        finally {
            TimerActionDAO.clean(null, (Statement)pstmtRemove, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeByProcessInstance(long piid) {
        Connection conn = null;
        PreparedStatement pstmtRemove = null;
        try {
            conn = TimerActionDAO.getConnection();
            pstmtRemove = conn.prepareStatement(removeByProcessInstance);
            if (BLControl.util.DEBUG_DAO) {
                StringBuffer buffer = TimerActionDAO.getDebugMessage(-1L, -1L, piid, -1L);
                BLControl.logger.debugKey("BizLogic_ERR_1207", new Object[]{removeByProcessInstance, buffer.toString()});
            }
            pstmtRemove.setLong(1, piid);
            pstmtRemove.executeUpdate();
        }
        catch (SQLException sqlex) {
            TimerActionDAO.handle((SQLException)sqlex);
        }
        finally {
            TimerActionDAO.clean(null, (Statement)pstmtRemove, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeByWorkStepInstance(long piid, long wsid) {
        Connection conn = null;
        PreparedStatement pstmtRemove = null;
        try {
            conn = TimerActionDAO.getConnection();
            pstmtRemove = conn.prepareStatement(removeByWorkStepInstance);
            if (BLControl.util.DEBUG_DAO) {
                StringBuffer buffer = TimerActionDAO.getDebugMessage(-1L, -1L, piid, wsid);
                BLControl.logger.debugKey("BizLogic_ERR_1207", new Object[]{removeByWorkStepInstance, buffer.toString()});
            }
            pstmtRemove.setLong(1, piid);
            pstmtRemove.setLong(2, wsid);
            pstmtRemove.executeUpdate();
        }
        catch (SQLException sqlex) {
            TimerActionDAO.handle((SQLException)sqlex);
        }
        finally {
            TimerActionDAO.clean(null, (Statement)pstmtRemove, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeByID(long taid) {
        Connection conn = null;
        PreparedStatement pstmtRemove = null;
        try {
            conn = TimerActionDAO.getConnection();
            pstmtRemove = conn.prepareStatement(removeByID);
            if (BLControl.util.DEBUG_DAO) {
                StringBuffer buffer = TimerActionDAO.getDebugMessage(taid, -1L, -1L, -1L);
                BLControl.logger.debugKey("BizLogic_ERR_1207", new Object[]{removeByID, buffer.toString()});
            }
            pstmtRemove.setLong(1, taid);
            pstmtRemove.executeUpdate();
        }
        catch (SQLException sqlex) {
            TimerActionDAO.handle((SQLException)sqlex);
        }
        finally {
            TimerActionDAO.clean(null, (Statement)pstmtRemove, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void increaseOverDueTimes(long piid, long wsid, long newDueDate, boolean isDueDateSetAlready) {
        Connection conn = null;
        PreparedStatement pstmtIncreaseOverDueTimes = null;
        String stmt = null;
        stmt = isDueDateSetAlready ? increaseOverDueTimesOnly : increaseOverDueTimes;
        try {
            conn = TimerActionDAO.getConnection();
            pstmtIncreaseOverDueTimes = conn.prepareStatement(stmt);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", stmt, new Object[0]);
            }
            int ix = 1;
            if (!isDueDateSetAlready) {
                TimerActionDAO.setDateValue((PreparedStatement)pstmtIncreaseOverDueTimes, (int)ix++, (long)newDueDate);
            }
            pstmtIncreaseOverDueTimes.setLong(ix++, piid);
            pstmtIncreaseOverDueTimes.setLong(ix++, wsid);
            pstmtIncreaseOverDueTimes.executeUpdate();
        }
        catch (SQLException sqlex) {
            TimerActionDAO.handle((SQLException)sqlex);
        }
        finally {
            TimerActionDAO.clean(null, (Statement)pstmtIncreaseOverDueTimes, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateDueDate(long piid, long wsid, long newDueDate) {
        Connection conn = null;
        PreparedStatement pstmtUpdateDueDate = null;
        try {
            conn = TimerActionDAO.getConnection();
            pstmtUpdateDueDate = conn.prepareStatement(updateDueDate);
            if (BLControl.util.DEBUG_DAO) {
                String debugMessage = TimerActionDAO.getDebugMessage(-1L, -1L, piid, wsid, newDueDate);
                BLControl.logger.debugKey("BizLogic_ERR_1207", new Object[]{updateDueDate, debugMessage});
            }
            TimerActionDAO.setDateValue((PreparedStatement)pstmtUpdateDueDate, (int)1, (long)newDueDate);
            pstmtUpdateDueDate.setLong(2, piid);
            pstmtUpdateDueDate.setLong(3, wsid);
            pstmtUpdateDueDate.executeUpdate();
        }
        catch (SQLException sqlex) {
            TimerActionDAO.handle((SQLException)sqlex);
        }
        finally {
            TimerActionDAO.clean(null, (Statement)pstmtUpdateDueDate, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getOverDueCount(long piid, long wsid) {
        Connection conn = null;
        PreparedStatement pstmtGetOverDueCount = null;
        ResultSet rs = null;
        int overDueCount = -1;
        try {
            conn = TimerActionDAO.getConnection();
            pstmtGetOverDueCount = conn.prepareStatement(getOverDueCount);
            if (BLControl.util.DEBUG_DAO) {
                StringBuffer buffer = TimerActionDAO.getDebugMessage(-1L, -1L, piid, wsid);
                BLControl.logger.debugKey("BizLogic_ERR_1207", new Object[]{getOverDueCount, buffer.toString()});
            }
            pstmtGetOverDueCount.setLong(1, piid);
            pstmtGetOverDueCount.setLong(2, wsid);
            rs = pstmtGetOverDueCount.executeQuery();
            if (!rs.next()) {
                throw new BizLogicException("BizLogic_ERR_1705", "TimerActionDAO.getOverDueCount(piid, wsid)", new Object[]{wsid, piid});
            }
            overDueCount = rs.getInt(1);
            TimerActionDAO.clean((ResultSet)rs, (Statement)pstmtGetOverDueCount, (Connection)conn);
        }
        catch (SQLException sqlex) {
            TimerActionDAO.handle((SQLException)sqlex);
        }
        finally {
            TimerActionDAO.clean(rs, (Statement)pstmtGetOverDueCount, (Connection)conn);
        }
        return overDueCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getOverDueList() {
        Connection conn = null;
        PreparedStatement pstmtGetOverDueList = null;
        ResultSet rs = null;
        Vector list = new Vector();
        BMTimer timer = null;
        try {
            conn = TimerActionDAO.getConnection();
            pstmtGetOverDueList = conn.prepareStatement(getOverDueList);
            if (BLControl.util.DEBUG_TIMERACTION) {
                BLControl.logger.debugKey("Bizlogic_ERR_3219", "TimerActionDAO.getOverDueList", new Object[]{BLControl.util.getOverDueFetchSize()});
            }
            TimerActionDAO.setMaxRows((Statement)pstmtGetOverDueList, (int)BLControl.util.getOverDueFetchSize());
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", getOverDueList, new Object[0]);
            }
            TimerActionDAO.setDateValue((PreparedStatement)pstmtGetOverDueList, (int)1, (long)System.currentTimeMillis());
            if (BLControl.util.BENCHMARK) {
                timer = BMTimer.getInstance((String)"CHECKDUEDAO");
                timer.setLogger(BLControl.logger);
                timer.resetStartTime();
            }
            long startTime = System.currentTimeMillis();
            rs = pstmtGetOverDueList.executeQuery();
            long endTime = System.currentTimeMillis();
            while (rs.next()) {
                HashMap<String, Object> hm = new HashMap<String, Object>(7);
                BLConstants.TAConstants cfr_ignored_0 = BLConstants.single().ta;
                hm.put("TIMERACTION_ID", rs.getLong(1));
                BLConstants.single();
                hm.put("PROCESSTEMPLATEID", rs.getLong(2));
                BLConstants.single();
                hm.put("PROCESSINSTANCEID", rs.getLong(3));
                BLConstants.single();
                hm.put("WORKSTEPID", rs.getLong(4));
                BLConstants.single();
                hm.put("OVERDUE_TIMES", rs.getInt(5));
                BLConstants.single();
                hm.put("ACTION_NAME", rs.getString(6));
                BLConstants.TAConstants cfr_ignored_1 = BLConstants.single().ta;
                hm.put("ACTION_INPUT", rs.getString(7));
                BLConstants.TAConstants cfr_ignored_2 = BLConstants.single().ta;
                hm.put("NOTIFY_EMAIL", rs.getString(8));
                list.addElement(hm);
            }
            if (BLControl.util.DEBUG_TIMERACTION) {
                BLControl.logger.debugKey("BizLogic_ERR_3260", "TimerActionDAO.getOverDueList()", new Object[]{list.size(), endTime - startTime});
            }
            if (BLControl.util.BENCHMARK && timer != null) {
                timer.printTime("Loading " + list.size() + " records from DB");
            }
            TimerActionDAO.clean((ResultSet)rs, (Statement)pstmtGetOverDueList, (Connection)conn);
        }
        catch (SQLException sqlex) {
            TimerActionDAO.handle((SQLException)sqlex);
        }
        finally {
            TimerActionDAO.clean(rs, (Statement)pstmtGetOverDueList, (Connection)conn);
        }
        return list;
    }

    public static synchronized void initSQLStatements() {
        insert = TimerActionDAO.composeInsertStatement((String)"BIZLOGIC_TIMERACTION", (String[])CREATE_LIST);
        TimerActionDAO.initSqlStatementRemoveByProcessInstance();
        TimerActionDAO.initSqlStatementRemoveByProcessTemplate();
        TimerActionDAO.initSqlStatementRemoveByWorkStepInstance();
        TimerActionDAO.initSqlStatementRemoveByID();
        TimerActionDAO.initSqlStatementIncreaseOverDueTimes();
        TimerActionDAO.initSqlStatementIncreaseOverDueTimesOnly();
        TimerActionDAO.initSqlStatementUpdateDueDate();
        TimerActionDAO.initSqlStatementGetOverDueList();
        TimerActionDAO.initSqlStatementGetOverDueCount();
        TimerActionDAO.printSQLStatements();
    }

    private static void initSqlStatementRemoveByProcessInstance() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DELETE_FROM).append("BIZLOGIC_TIMERACTION").append(WHERE).append("PROCESS_INSTANCE_ID").append(QUESTION_WITH_SPACE);
        removeByProcessInstance = stringBuilder.toString();
    }

    private static void initSqlStatementRemoveByProcessTemplate() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DELETE_FROM).append("BIZLOGIC_TIMERACTION").append(WHERE).append("PROCESS_TEMPLATE_ID").append(QUESTION_WITH_SPACE);
        removeByProcessTemplate = stringBuilder.toString();
    }

    private static void initSqlStatementRemoveByWorkStepInstance() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DELETE_FROM).append("BIZLOGIC_TIMERACTION").append(WHERE).append("PROCESS_INSTANCE_ID").append(QUESTION_WITH_AND).append("WORKSTEP_ID").append(QUESTION);
        removeByWorkStepInstance = stringBuilder.toString();
    }

    private static void initSqlStatementRemoveByID() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DELETE_FROM).append("BIZLOGIC_TIMERACTION").append(WHERE).append("TIMERACTION_ID").append(QUESTION);
        removeByID = stringBuilder.toString();
    }

    private static void initSqlStatementIncreaseOverDueTimes() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(UPDATE).append("BIZLOGIC_TIMERACTION").append(SET).append("DUEDATE").append(QUESTION_WITH_COMMA).append("OVERDUE_TIMES").append(EQUALS).append("OVERDUE_TIMES").append(PLUS_1_WHERE).append("PROCESS_INSTANCE_ID").append(QUESTION_WITH_AND).append("WORKSTEP_ID").append(QUESTION);
        increaseOverDueTimes = stringBuilder.toString();
    }

    private static void initSqlStatementIncreaseOverDueTimesOnly() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(UPDATE).append("BIZLOGIC_TIMERACTION").append(SET).append("OVERDUE_TIMES").append(EQUALS).append("OVERDUE_TIMES").append(PLUS_1_WHERE).append("PROCESS_INSTANCE_ID").append(QUESTION_WITH_AND).append("WORKSTEP_ID").append(QUESTION);
        increaseOverDueTimesOnly = stringBuilder.toString();
    }

    private static void initSqlStatementUpdateDueDate() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(UPDATE).append("BIZLOGIC_TIMERACTION").append(SET).append("DUEDATE").append(QUESTION_WITH_WHERE).append("PROCESS_INSTANCE_ID").append(QUESTION_WITH_AND).append("WORKSTEP_ID").append(QUESTION);
        updateDueDate = stringBuilder.toString();
    }

    private static void initSqlStatementGetOverDueList() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SELECT).append(BLTA).append("TIMERACTION_ID").append(COMMA).append(BLTA).append("PROCESS_TEMPLATE_ID").append(COMMA).append(BLTA).append("PROCESS_INSTANCE_ID").append(COMMA).append(BLTA).append("WORKSTEP_ID").append(COMMA).append(BLTA).append("OVERDUE_TIMES").append(COMMA).append(BLTA).append("ACTION_NAME").append(COMMA).append(BLTA).append("ACTION_INPUT").append(COMMA).append(BLTA).append("NOTIFY_EMAIL").append(FROM).append("BIZLOGIC_TIMERACTION").append(BLTA_VALUE);
        TimerActionDAO.addReadpastHint((StringBuffer)stringBuffer);
        stringBuffer.append(COMMA).append("BIZLOGIC_WORKSTEPINSTANCE").append(BLWSI_VALUE);
        TimerActionDAO.addReadpastHint((StringBuffer)stringBuffer);
        stringBuffer.append(WHERE).append(BLTA).append("DUEDATE").append(LESS_THAN_OR_EQUAL_QUESTION).append(AND).append(BLTA).append("PROCESS_INSTANCE_ID").append(EQUALS).append(BLWSI).append("PROCESS_INSTANCE_ID").append(AND).append(BLTA).append("WORKSTEP_ID").append(EQUALS).append(BLWSI).append("WORKSTEP_ID").append(AND).append(BLWSI).append("STATUS").append(NOT_EQUAL).append(16).append(AND).append(BLWSI).append("STATUS").append(NOT_EQUAL).append(62).append(ORDER_BY).append(BLTA).append("DUEDATE");
        if (ServiceLocator.self().isDB2()) {
            TimerActionDAO.addReadUncommittedHint((StringBuffer)stringBuffer);
        }
        SBMDatabase.addReadPastHintOpenEdge((StringBuffer)stringBuffer);
        getOverDueList = stringBuffer.toString();
    }

    private static void initSqlStatementGetOverDueCount() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SELECT).append("OVERDUE_TIMES").append(FROM).append("BIZLOGIC_TIMERACTION").append(WHERE).append("PROCESS_INSTANCE_ID").append(QUESTION_WITH_AND).append("WORKSTEP_ID").append(QUESTION);
        getOverDueCount = stringBuilder.toString();
    }

    private static void printSQLStatements() {
        if (BLControl.util.DEBUG_DAO) {
            BLControl.logger.debug((Object)"TimerActionDAO:");
            BLControl.logger.debugKey("BizLogic_ERR_1199", insert, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", removeByProcessInstance, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", removeByProcessTemplate, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", removeByWorkStepInstance, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", removeByID, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", increaseOverDueTimes, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", updateDueDate, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getOverDueList, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getOverDueCount, new Object[0]);
        }
    }

    private static String getDebugMessage(long taid, long ptid, long piid, long wsid, long dueDate) {
        StringBuffer buffer = TimerActionDAO.getDebugMessage(taid, ptid, piid, wsid);
        buffer.append(";dueDate=");
        buffer.append(dueDate);
        return buffer.toString();
    }

    private static StringBuffer getDebugMessage(long taid, long ptid, long piid, long wsid) {
        int length;
        StringBuffer buffer = new StringBuffer();
        if (taid != -1L) {
            buffer.append("taid=");
            buffer.append(taid);
            buffer.append(";");
        }
        if (ptid != -1L) {
            buffer.append("ptid=");
            buffer.append(ptid);
            buffer.append(";");
        }
        if (piid != -1L) {
            buffer.append("piid=");
            buffer.append(piid);
            buffer.append(";");
        }
        if (wsid != -1L) {
            buffer.append("wsid=");
            buffer.append(wsid);
            buffer.append(";");
        }
        if ((length = buffer.length()) > 0) {
            buffer.deleteCharAt(length - 1);
        }
        return buffer;
    }

    static {
        String[] stringArray = new String[10];
        DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
        stringArray[0] = "TIMERACTION_ID";
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        stringArray[1] = "PROCESS_TEMPLATE_ID";
        DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
        stringArray[2] = "PROCESS_INSTANCE_ID";
        DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
        stringArray[3] = "WORKSTEP_ID";
        DBConstants.ColConstants cfr_ignored_4 = BLControl.dbconsts.col;
        stringArray[4] = "DUEDATE";
        DBConstants.ColConstants cfr_ignored_5 = BLControl.dbconsts.col;
        stringArray[5] = "OVERDUE_TIMES";
        DBConstants.ColConstants cfr_ignored_6 = BLControl.dbconsts.col;
        stringArray[6] = "ACTION_NAME";
        DBConstants.ColConstants cfr_ignored_7 = BLControl.dbconsts.col;
        stringArray[7] = "ACTION_INPUT";
        DBConstants.ColConstants cfr_ignored_8 = BLControl.dbconsts.col;
        stringArray[8] = "NOTIFY_EMAIL";
        DBConstants.ColConstants cfr_ignored_9 = BLControl.dbconsts.col;
        stringArray[9] = "CREATOR";
        CREATE_LIST = stringArray;
    }
}

