/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.dao;

import com.savvion.sbm.bizlogic.util.BLDAOService;
import com.savvion.sbm.bizlogic.util.DBConstants;
import com.savvion.sbm.util.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class PTReplaceInfoDAO
extends BLDAOService {
    private static String insertPTReplaceInfo = null;
    private static String updatePTReplaceInfo_piid = null;
    private static String updatePTReplaceInfo_status = null;
    private static String getLastUpdatePID = null;
    private static String removePTReplaceInfo = null;

    public static void create(long ptReplaceID, long ptID, String ptName, long createDate, String xmlDefinition) {
        PTReplaceInfoDAO.create(ptReplaceID, ptID, ptName, createDate, -1L, false, xmlDefinition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void create(long ptReplaceID, long ptID, String ptName, long createDate, long lastUpdatePID, boolean completed, String xmlDefinition) {
        block6: {
            Connection conn = null;
            PreparedStatement pstmt = null;
            ByteArrayInputStream ptXML = null;
            int status = 0;
            if (completed) {
                status = 1;
            }
            try {
                conn = PTReplaceInfoDAO.getConnection();
                pstmt = conn.prepareStatement(insertPTReplaceInfo);
                pstmt.setLong(1, ptReplaceID);
                pstmt.setLong(2, ptID);
                pstmt.setString(3, ptName);
                PTReplaceInfoDAO.setDateValue((PreparedStatement)pstmt, (int)4, (long)createDate);
                pstmt.setLong(5, lastUpdatePID);
                pstmt.setInt(6, status);
                ptXML = new ByteArrayInputStream(PTReplaceInfoDAO.convertToBytes((Object)xmlDefinition));
                pstmt.setBinaryStream(7, (InputStream)ptXML, ptXML.available());
                pstmt.executeUpdate();
                PTReplaceInfoDAO.clean(null, (Statement)pstmt, (Connection)conn);
            }
            catch (SQLException sqlerr) {
                PTReplaceInfoDAO.handle((SQLException)sqlerr);
                break block6;
            }
            finally {
                PTReplaceInfoDAO.clean(null, (Statement)pstmt, (Connection)conn);
                FileUtil.close(ptXML);
            }
            FileUtil.close((InputStream)ptXML);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(long ptReplaceID, long lastUpdatePID) {
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = PTReplaceInfoDAO.getConnection();
            pstmt = conn.prepareStatement(updatePTReplaceInfo_piid);
            pstmt.setLong(1, lastUpdatePID);
            pstmt.setLong(2, ptReplaceID);
            pstmt.executeUpdate();
        }
        catch (SQLException sqlerr) {
            PTReplaceInfoDAO.handle((SQLException)sqlerr);
        }
        finally {
            PTReplaceInfoDAO.clean(null, (Statement)pstmt, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(long ptReplaceID, boolean completed) {
        Connection conn = null;
        PreparedStatement pstmt = null;
        int status = 0;
        if (completed) {
            status = 1;
        }
        try {
            conn = PTReplaceInfoDAO.getConnection();
            pstmt = conn.prepareStatement(updatePTReplaceInfo_status);
            pstmt.setInt(1, status);
            pstmt.setLong(2, ptReplaceID);
            pstmt.executeUpdate();
        }
        catch (SQLException sqlerr) {
            PTReplaceInfoDAO.handle((SQLException)sqlerr);
        }
        finally {
            PTReplaceInfoDAO.clean(null, (Statement)pstmt, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getLastPID(long ptReplaceID) {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        long lastPID = 0L;
        try {
            conn = PTReplaceInfoDAO.getConnection();
            pstmt = conn.prepareStatement(getLastUpdatePID);
            pstmt.setLong(1, ptReplaceID);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                lastPID = rs.getLong(1);
            }
            PTReplaceInfoDAO.clean((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        }
        catch (SQLException sqlerr) {
            PTReplaceInfoDAO.handle((SQLException)sqlerr);
        }
        finally {
            PTReplaceInfoDAO.clean(rs, (Statement)pstmt, (Connection)conn);
        }
        return lastPID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(long ptID) {
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = PTReplaceInfoDAO.getConnection();
            pstmt = conn.prepareStatement(removePTReplaceInfo);
            pstmt.setLong(1, ptID);
            pstmt.executeUpdate();
        }
        catch (Throwable th) {
            PTReplaceInfoDAO.handle((Throwable)th);
        }
        finally {
            PTReplaceInfoDAO.clean(null, (Statement)pstmt, (Connection)conn);
        }
    }

    public static synchronized void initSQLStatements() {
        StringBuffer sb = new StringBuffer(500);
        sb.append("INSERT INTO ");
        DBConstants.TableConstants cfr_ignored_0 = DBConstants.single().tab;
        sb.append("BIZLOGIC_PT_REPLACE_INFO");
        DBConstants.ColConstants cfr_ignored_1 = DBConstants.single().col;
        sb.append(" ( ").append("PT_REPLACE_ID");
        DBConstants.ColConstants cfr_ignored_2 = DBConstants.single().col;
        sb.append(" , ").append("PROCESS_TEMPLATE_ID");
        DBConstants.ColConstants cfr_ignored_3 = DBConstants.single().col;
        sb.append(" , ").append("PROCESS_TEMPLATE_NAME");
        DBConstants.ColConstants cfr_ignored_4 = DBConstants.single().col;
        sb.append(" , ").append("CREATE_DATE");
        DBConstants.ColConstants cfr_ignored_5 = DBConstants.single().col;
        sb.append(" , ").append("LAST_UPDATE_PID");
        DBConstants.ColConstants cfr_ignored_6 = DBConstants.single().col;
        sb.append(" , ").append("COMPLETED");
        DBConstants.ColConstants cfr_ignored_7 = DBConstants.single().col;
        sb.append(" , ").append("PROCESS_XML");
        sb.append(" ) ").append(" VALUES (?, ?, ?, ?, ?, ?, ?)");
        insertPTReplaceInfo = sb.toString();
        sb = new StringBuffer(200);
        sb.append("UPDATE ");
        DBConstants.TableConstants cfr_ignored_8 = DBConstants.single().tab;
        sb.append("BIZLOGIC_PT_REPLACE_INFO");
        DBConstants.ColConstants cfr_ignored_9 = DBConstants.single().col;
        sb.append(" SET ").append("LAST_UPDATE_PID");
        sb.append(" = ? ").append(" WHERE ");
        DBConstants.ColConstants cfr_ignored_10 = DBConstants.single().col;
        sb.append("PT_REPLACE_ID");
        sb.append(" = ? ");
        updatePTReplaceInfo_piid = sb.toString();
        sb = new StringBuffer(200);
        sb.append("UPDATE ");
        DBConstants.TableConstants cfr_ignored_11 = DBConstants.single().tab;
        sb.append("BIZLOGIC_PT_REPLACE_INFO");
        DBConstants.ColConstants cfr_ignored_12 = DBConstants.single().col;
        sb.append(" SET ").append("COMPLETED");
        sb.append(" = ? ").append(" WHERE ");
        DBConstants.ColConstants cfr_ignored_13 = DBConstants.single().col;
        sb.append("PT_REPLACE_ID");
        sb.append(" = ? ");
        updatePTReplaceInfo_status = sb.toString();
        sb = new StringBuffer(200);
        sb.append("SELECT ");
        DBConstants.ColConstants cfr_ignored_14 = DBConstants.single().col;
        sb.append("LAST_UPDATE_PID");
        DBConstants.TableConstants cfr_ignored_15 = DBConstants.single().tab;
        sb.append(" FROM ").append("BIZLOGIC_PT_REPLACE_INFO");
        sb.append(" WHERE ");
        DBConstants.ColConstants cfr_ignored_16 = DBConstants.single().col;
        sb.append("PT_REPLACE_ID");
        sb.append(" = ? ");
        getLastUpdatePID = sb.toString();
        sb = new StringBuffer(200);
        DBConstants.KeywordConstants kwd = DBConstants.single().kwd;
        sb.append(" DELETE ");
        sb.append(" FROM ");
        DBConstants.TableConstants cfr_ignored_17 = DBConstants.single().tab;
        sb.append("BIZLOGIC_PT_REPLACE_INFO");
        sb.append(" WHERE ");
        DBConstants.ColConstants cfr_ignored_18 = DBConstants.single().col;
        sb.append("PROCESS_TEMPLATE_ID");
        sb.append(" = ? ");
        removePTReplaceInfo = sb.toString();
    }
}

