/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.savvion.sbm.bizlogic.server.WFDataslot;
import com.savvion.sbm.bizlogic.server.WFWorkstep;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.util.SBMUtil;
import com.savvion.sbm.util.WSDLParser;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class WFWebServiceWS
extends WFWorkstep {
    static final long serialVersionUID = 1225160275709606655L;
    public static final int NUM_PARTS_ELEMENTS = 2;
    public static final int API_MAPPING_ELEMENTS = 3;
    public static String XSD_URI = "http://www.w3.org/2001/XMLSchema";
    String service;
    String portName;
    String operation;
    String[][] inpParams;
    String[][] outParams;
    boolean synchronous;
    String endpoint;
    String soapAction;
    String namespaceURI;
    String targetNamespace;
    transient String[][] complexTypeInfo;

    public WFWebServiceWS(String name, String wsdl, String endpt, String wservice, String port, String opn, String[][] iparams, String[][] oparams, boolean sync) {
        block14: {
            block13: {
                block12: {
                    block11: {
                        this.synchronous = true;
                        this.complexTypeInfo = null;
                        this.setName(name);
                        if (wsdl == null || wsdl.trim().isEmpty()) {
                            throw new BizLogicException("BizLogic_ERR_3104", "WFWebServiceWS()", new Object[]{this.getPTName(), this.getName()});
                        }
                        if (opn == null || opn.trim().isEmpty()) {
                            throw new BizLogicException("BizLogic_ERR_3105", "WFWebServiceWS()", new Object[]{this.getPTName(), this.getName()});
                        }
                        if (iparams == null) break block11;
                        if (iparams.length <= 0) break block12;
                        int n = iparams[0].length;
                        BLConstants.single();
                        if (n == 4) break block12;
                    }
                    throw new BizLogicException("BizLogic_ERR_3106", "WFWebServiceWS()", new Object[]{this.operation, this.getPTName(), this.getName()});
                }
                if (oparams == null || oparams.length > 1) break block13;
                if (oparams.length <= 0) break block14;
                int n = oparams[0].length;
                BLConstants.single();
                if (n == 4) break block14;
            }
            throw new BizLogicException("BizLogic_ERR_3107", "WFWebServiceWS()", new Object[]{this.operation, this.getPTName(), this.getName()});
        }
        this.hasPerformer = wsdl;
        this.endpoint = endpt;
        this.service = wservice;
        this.portName = port;
        this.operation = opn;
        this.inpParams = (String[][])SBMUtil.arrayCopy2D((Object[][])iparams);
        this.outParams = (String[][])SBMUtil.arrayCopy2D((Object[][])oparams);
        this.synchronous = sync;
        this.typeTag = 109;
        if (this.service == null) {
            this.service = "";
        }
        if (this.portName == null) {
            this.portName = "";
        }
        if (this.endpoint == null) {
            this.endpoint = "";
        }
        this.updateTargetData();
    }

    @Override
    public HashMap getAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("PERFORMER", this.hasPerformer);
        attributes.put("WSDL_ENDPOINT", this.endpoint);
        attributes.put("PERFORMER", this.hasPerformer);
        attributes.put("WSDL_SERVICE", this.service);
        attributes.put("WSDL_PORTNAME", this.portName);
        attributes.put("WSDL_OPERATION", this.operation);
        attributes.put("WSDL_INPPARAMS", this.inpParams);
        attributes.put("WSDL_OUTPARAMS", this.outParams);
        attributes.put("SYNCHRONOUS", this.synchronous);
        attributes.putAll(super.getAttributes());
        return attributes;
    }

    public String getURL() {
        return this.hasPerformer;
    }

    public String getService() {
        return this.service;
    }

    public String getPortName() {
        return this.portName;
    }

    public String getOperation() {
        return this.operation;
    }

    public String[] getInpSlotNames() {
        String[] inpds = new String[this.inpParams.length];
        for (int ix = 0; ix < inpds.length; ++ix) {
            inpds[ix] = this.inpParams[ix][0];
        }
        return inpds;
    }

    public String[] getOutSlotNames() {
        String[] outds = new String[this.outParams.length];
        for (int ix = 0; ix < outds.length; ++ix) {
            outds[ix] = this.outParams[ix][0];
        }
        return outds;
    }

    public String[][] getInpParams() {
        return this.inpParams;
    }

    public String[][] getOutParams() {
        return this.outParams;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String ep) {
        this.endpoint = ep;
    }

    public String getSOAPAction() {
        return this.soapAction;
    }

    public void setSOAPAction(String sa) {
        this.soapAction = sa;
    }

    public void setService(String service) {
        this.service = service;
    }

    public void setPortName(String name) {
        this.portName = name;
    }

    public void setWSDLURL(String url) {
        this.hasPerformer = url;
    }

    public void setOperation(String opn) {
        this.operation = opn;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public void setNamespaceURI(String uri) {
        this.namespaceURI = uri;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String tns) {
        this.targetNamespace = tns;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    private void setInputDSMappings(String[][] imaps) {
        if (imaps == null || imaps.length != 3) {
            throw new BizLogicException("BizLogic_ERR_3111", "WFWebService.setInputDSMappings()", new Object[]{this.getName(), this.getPTName(), this.hasPerformer, this.operation});
        }
        int n = imaps.length;
        BLConstants.single();
        String[][] ip = new String[n][4];
        for (int ix = 0; ix < imaps.length; ++ix) {
            ip[ix][0] = imaps[ix][0];
            ip[ix][2] = imaps[ix][1];
        }
        this.inpParams = ip;
    }

    private void setOutputDSMappings(String[][] omaps) {
        if (omaps == null || omaps.length != 3) {
            throw new BizLogicException("BizLogic_ERR_3111", "WFWebService.setInputDSMappings()", new Object[]{this.getName(), this.getPTName(), this.hasPerformer, this.operation});
        }
        int n = omaps.length;
        BLConstants.single();
        String[][] op = new String[n][4];
        for (int ix = 0; ix < omaps.length; ++ix) {
            op[ix][0] = omaps[ix][0];
            op[ix][2] = omaps[ix][1];
        }
        this.outParams = op;
    }

    public final synchronized void updateTargetData() {
        WSDLParser wsdlObj = null;
        try {
            if (BLControl.util.DEBUG_ENGINE) {
                BLControl.logger.debug((Object)("Parsing WSDL:" + this.hasPerformer));
            }
            wsdlObj = new WSDLParser(this.hasPerformer, this.endpoint, this.service, this.portName);
            if (this.portName == null || this.portName.trim().isEmpty()) {
                this.portName = wsdlObj.getDefaultPort();
            }
            if (this.endpoint == null || this.endpoint.trim().isEmpty()) {
                this.endpoint = wsdlObj.getEndpoint(this.portName);
            }
            this.soapAction = wsdlObj.getSOAPActionURI(this.portName, this.operation);
            this.namespaceURI = wsdlObj.getNamespaceURI(this.portName, this.operation);
            this.targetNamespace = wsdlObj.getTargetNamespace();
            String inpMsgName = wsdlObj.getInputMessageName(this.operation);
            String outMsgName = wsdlObj.getOutputMessageName(this.operation);
            String[][] inparts = wsdlObj.getOperationInputMessageParts(this.operation);
            String[][] outparts = wsdlObj.getOperationOutputMessageParts(this.operation);
            if (inparts == null || inparts.length != 0 && inparts[0].length != 2) {
                throw new BizLogicException("BizLogic_ERR_3109", "WFWebService.updateTargetData", new Object[]{inpMsgName, this.hasPerformer, this.operation, this.getPTName(), this.getName()});
            }
            if (outparts == null || outparts.length != 0 && outparts[0].length != 2) {
                throw new BizLogicException("BizLogic_ERR_3110", "WFWebService.updateTargetData", new Object[]{outMsgName, this.hasPerformer, this.operation, this.getPTName(), this.getName()});
            }
            if (inparts.length == 0) {
                BLControl.logger.warnKey("BizLogic_ERR_3119", new Object[]{"Input", inpMsgName, this.hasPerformer, this.operation, this.getPTName(), this.getName()});
            }
            if (outparts.length == 0) {
                BLControl.logger.warnKey("BizLogic_ERR_3119", new Object[]{"Output", outMsgName, this.hasPerformer, this.operation, this.getPTName(), this.getName()});
            }
            if (inparts.length != this.inpParams.length) {
                throw new BizLogicException("BizLogic_ERR_3114", "WFWebService.updateTargetData", new Object[]{this.hasPerformer, this.operation, this.getPTName(), this.getName()});
            }
            int n = inparts.length;
            BLConstants.single();
            String[][] ip = new String[n][4];
            for (int ix = 0; ix < this.inpParams.length; ++ix) {
                ip[ix][0] = this.getMappedDS(inparts[ix][0], this.inpParams);
                ip[ix][1] = inpMsgName;
                ip[ix][2] = inparts[ix][0];
                ip[ix][3] = inparts[ix][1];
            }
            this.inpParams = ip;
            if (outparts.length != this.outParams.length) {
                throw new BizLogicException("BizLogic_ERR_3115", "WFWebService.updateTargetData", new Object[]{this.hasPerformer, this.operation, this.getPTName(), this.getName()});
            }
            int n2 = outparts.length;
            BLConstants.single();
            String[][] op = new String[n2][4];
            for (int ix = 0; ix < this.outParams.length; ++ix) {
                op[ix][0] = this.getMappedDS(outparts[ix][0], this.outParams);
                op[ix][1] = outMsgName;
                op[ix][2] = outparts[ix][0];
                op[ix][3] = outparts[ix][1];
            }
            this.outParams = op;
            this.printInfo();
        }
        catch (BizLogicException be) {
            throw be;
        }
        catch (Exception ex) {
            throw new BizLogicException("BizLogic_ERR_3108", "WFWebService.updateTargetData", new Object[]{this.hasPerformer, this.getPTName(), this.getName(), this.operation}, (Throwable)ex);
        }
        finally {
            if (wsdlObj != null) {
                wsdlObj.clean();
            }
            wsdlObj = null;
        }
    }

    public String[][] getComplexTypeInfo() {
        if (this.complexTypeInfo != null) {
            return this.complexTypeInfo;
        }
        Vector objDSList = this.getObjectDataSlotList();
        this.complexTypeInfo = new String[objDSList.size()][5];
        String fcname = null;
        String cname = null;
        for (int ix = 0; ix < objDSList.size(); ++ix) {
            this.complexTypeInfo[ix][0] = this.targetNamespace;
            WFDataslot ds = (WFDataslot)objDSList.get(ix);
            if (ds.isObject()) {
                fcname = ds.getJavaClassName();
                cname = this.getObjectClassName(fcname);
            } else if (ds.isDate()) {
                // empty if block
            }
            this.complexTypeInfo[ix][1] = cname;
            this.complexTypeInfo[ix][2] = fcname;
        }
        return this.complexTypeInfo;
    }

    public Vector getWSObjectDataSlotList() {
        int ix;
        WFDataslot ds = null;
        Vector<WFDataslot> cDSList = new Vector<WFDataslot>();
        String[] dsNames = this.getInputSlotsKeys();
        if (dsNames != null) {
            for (ix = 0; ix < dsNames.length; ++ix) {
                ds = this.getDataslot(dsNames[ix]);
                if (ds == null || !ds.isObject() && !ds.isDate()) continue;
                cDSList.add(ds);
            }
        }
        if ((dsNames = this.getOutputSlotsKeys()) != null) {
            for (ix = 0; ix < dsNames.length; ++ix) {
                ds = this.getDataslot(dsNames[ix]);
                if (ds == null || !ds.isObject() && !ds.isDate()) continue;
                cDSList.add(ds);
            }
        }
        return cDSList;
    }

    private final void printInfo() {
        BLControl.logger.infoKey("BizLogic_ERR_1005", new Object[]{this.hasPerformer, this.getPTName(), this.getName(), this.portName, this.endpoint, this.soapAction, this.namespaceURI, this.operation, this.targetNamespace});
        if (BLControl.util.DEBUG_ENGINE) {
            int ix;
            StringBuilder buf = new StringBuilder();
            if (this.inpParams != null && this.inpParams.length > 0) {
                for (ix = 0; ix < this.inpParams.length; ++ix) {
                    buf.append("<Input DSName: ").append(this.inpParams[ix][0]);
                    buf.append(">");
                    buf.append("<Input msgName: ").append(this.inpParams[ix][1]);
                    buf.append(">");
                    buf.append("<Input PartName: ").append(this.inpParams[ix][2]);
                    buf.append(">");
                    buf.append("<Input PartType: ").append(this.inpParams[ix][3]);
                    buf.append(">");
                    buf.append("\n");
                }
            }
            if (this.outParams != null && this.outParams.length > 0) {
                for (ix = 0; ix < this.outParams.length; ++ix) {
                    buf.append("<Output DSName: ").append(this.outParams[ix][0]);
                    buf.append(">");
                    buf.append("<Output msgName: ").append(this.outParams[ix][1]);
                    buf.append(">");
                    buf.append("<Output PartName: ").append(this.outParams[ix][2]);
                    buf.append(">");
                    buf.append("<Output PartType: ").append(this.outParams[ix][3]);
                    buf.append(">");
                    buf.append("\n");
                }
            }
            if (buf.length() > 0) {
                BLControl.logger.debug((Object)buf.toString());
            }
        }
    }

    private final String getPTName() {
        String ptName = "";
        if (this.getParentProcess() != null) {
            ptName = this.getProcessName();
        }
        return ptName;
    }

    @Override
    public void setAttributes(HashMap hm) {
        String[][] imaps = null;
        String[][] omaps = null;
        Iterator iter = hm.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (key.equals("WSDL_SERVICE")) {
                this.setService((String)hm.get(key));
                iter.remove();
                continue;
            }
            if (key.equals("WSDL_PORTNAME")) {
                this.setPortName((String)hm.get(key));
                iter.remove();
                continue;
            }
            if (key.equals("PERFORMER")) {
                this.setWSDLURL((String)hm.get(key));
                iter.remove();
                continue;
            }
            if (key.equals("WSDL_ENDPOINT")) {
                this.setEndpoint((String)hm.get(key));
                iter.remove();
                continue;
            }
            if (key.equals("WSDL_OPERATION")) {
                this.setOperation((String)hm.get(key));
                iter.remove();
                continue;
            }
            if (key.equals("INP_DSMAPPINGS")) {
                imaps = (String[][])hm.get(key);
                continue;
            }
            if (!key.equals("OUT_DSMAPPINGS")) continue;
            omaps = (String[][])hm.get(key);
        }
        if (imaps != null) {
            this.setInputDSMappings(imaps);
        }
        if (omaps != null) {
            this.setOutputDSMappings(omaps);
        }
        this.updateTargetData();
        this.validate();
        super.setAttributes(hm);
    }

    @Override
    public boolean validate() {
        boolean valid = super.validate();
        if (!valid) {
            return false;
        }
        if (!this.validateMappings(this.inpParams)) {
            return false;
        }
        return this.validateMappings(this.outParams);
    }

    private boolean validateMappings(String[][] params) {
        boolean valid = false;
        if (params.length == 0) {
            return true;
        }
        for (int ix = 0; ix < params.length; ++ix) {
            WFDataslot ds = this.getDataslot(params[ix][0]);
            if (ds == null) {
                return false;
            }
            if (params[ix][3] == null) {
                return false;
            }
            if ("string".equalsIgnoreCase(params[ix][3]) && (ds.isString() || ds.isURL() || ds.isXML() || ds.isDocument())) {
                valid = true;
                continue;
            }
            if (("int".equalsIgnoreCase(params[ix][3]) || "integer".equalsIgnoreCase(params[ix][3]) || "long".equalsIgnoreCase(params[ix][3]) || "short".equalsIgnoreCase(params[ix][3])) && ds.isLong()) {
                valid = true;
                continue;
            }
            if (("float".equalsIgnoreCase(params[ix][3]) || "double".equalsIgnoreCase(params[ix][3])) && ds.isDouble()) {
                valid = true;
                continue;
            }
            if ("boolean".equalsIgnoreCase(params[ix][3]) && ds.isBoolean()) {
                valid = true;
                continue;
            }
            if (("bigdecimal".equalsIgnoreCase(params[ix][3]) || "decimal".equalsIgnoreCase(params[ix][3])) && ds.isDecimal()) {
                valid = true;
                continue;
            }
            if (("long".equalsIgnoreCase(params[ix][3]) || "datetime".equalsIgnoreCase(params[ix][3])) && ds.isDate()) {
                valid = true;
                continue;
            }
            if (ds.isObject()) {
                String cname = this.getObjectClassName(ds.getJavaClassName());
                if (!params[ix][3].equalsIgnoreCase(cname)) continue;
                valid = true;
                continue;
            }
            throw new BizLogicException("BizLogic_ERR_3118", "WFWebServiceWS.validate", new Object[]{params[ix][3], params[ix][2], ds.getType(), ds.getName(), this.getPTName(), this.getName()});
        }
        return valid;
    }

    private String getMappedDS(String partName, String[][] params) {
        if (partName == null) {
            throw new BizLogicException("BizLogic_ERR_3112", "WFWebServiceWS.getMappedDS", new Object[]{this.getPTName(), this.getName()});
        }
        for (int ix = 0; ix < params.length; ++ix) {
            if (params[ix][2] == null || !partName.equalsIgnoreCase(params[ix][2])) continue;
            return params[ix][0];
        }
        throw new BizLogicException("BizLogic_ERR_3113", "WFWebServiceWS.getMappedDS", new Object[]{partName, this.getPTName(), this.getName(), this.hasPerformer, this.operation});
    }

    private String getObjectClassName(String fullyQualifiedClassName) {
        if (fullyQualifiedClassName == null) {
            return null;
        }
        String cname = fullyQualifiedClassName;
        int dotidx = cname.lastIndexOf(".");
        if (dotidx >= 0) {
            cname = fullyQualifiedClassName.substring(dotidx + 1);
        }
        return cname.trim();
    }

    public synchronized String getXSDUri() {
        return XSD_URI;
    }

    public synchronized void setXSDUri(String uri) {
        XSD_URI = uri;
    }
}

