/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.savvion.sbm.bizlogic.server.DataSlotTableIndex;
import com.savvion.sbm.bizlogic.server.ProcessControl;
import com.savvion.sbm.bizlogic.server.WFAppObject;
import com.savvion.sbm.bizlogic.server.WFAtomicWS;
import com.savvion.sbm.bizlogic.server.WFConnectorWS;
import com.savvion.sbm.bizlogic.server.WFDataslot;
import com.savvion.sbm.bizlogic.server.WFJavaScript;
import com.savvion.sbm.bizlogic.server.WFLink;
import com.savvion.sbm.bizlogic.server.WFProcessReplaceInfo;
import com.savvion.sbm.bizlogic.server.WFValidateProcess;
import com.savvion.sbm.bizlogic.server.WFVoteWS;
import com.savvion.sbm.bizlogic.server.WFWorkstep;
import com.savvion.sbm.bizlogic.server.dao.ProcessTemplateDAO;
import com.savvion.sbm.bizlogic.server.svo.DateTime;
import com.savvion.sbm.bizlogic.server.svo.MessageSubscriptionList;
import com.savvion.sbm.bizlogic.server.svo.TimerAction;
import com.savvion.sbm.bizlogic.server.svo.TimerActionList;
import com.savvion.sbm.bizlogic.server.svo.XML;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.ProcessContext;
import com.savvion.sbm.bizlogic.util.ProcessType;
import com.savvion.sbm.util.FileUtil;
import com.savvion.sbm.util.SBMConstants;
import com.savvion.sbm.util.SBMContext;
import com.savvion.sbm.util.SBMControl;
import com.savvion.sbm.util.SBMUtil;
import com.savvion.sbm.util.callback.ProcessCallback;
import com.tdiinc.userManager.Group;
import com.tdiinc.userManager.User;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class WFProcess
extends WFAppObject {
    static final long serialVersionUID = 6131445828741201304L;
    static final long BLOCKSIZE = 32768L;
    long estimatedDuration;
    String xmlfile;
    String category;
    String subCategory;
    String group;
    String manager;
    String description;
    String info;
    String versionID;
    long parentID;
    String appName;
    Vector fyi;
    Hashtable WSfyi;
    Vector hasConnections;
    Vector hasWorksteps;
    Vector hasDataslots;
    HashMap hashDataSlotList;
    long wsCounter = 0L;
    private boolean suspendedBySeqVersion = false;
    private transient Hashtable pwsjscript = null;
    private transient int estSize = 0;
    private boolean dynamic = false;
    transient HashMap globalDSAccess = null;
    transient HashMap instanceDSAccess = null;
    transient HashMap metaDataDS = null;
    transient Vector globalDS = null;
    transient Vector instanceDS = null;
    transient HashMap metaDSSize = null;
    transient HashMap metaDSType = null;
    transient HashMap metaDSAccess = null;
    transient String[] dsnames = null;
    transient String[] instancePrivateDocDSName = null;
    transient HashMap workstepsOnType = null;
    transient String docLocation = null;
    int recordSize;
    String globalDSTableName;
    String instanceDSTableName;
    String instruction;
    private long timeStarted = -1L;
    private int priority = 0;
    TimerActionList timerActions = null;
    long dynamicinstanceid = -1L;
    boolean hasCollectionDS = false;
    private boolean hasVoteWorksteps = false;
    private boolean inLineTasks = false;
    Hashtable milestones;
    transient HashMap milestoneNameWSIDList;
    transient HashMap wsidMilestoneName;
    private boolean hasSqlMapDataSlots = false;
    private WFProcessReplaceInfo replaceInfo = null;
    private long lastModifiedTime = -1L;
    private String folderId = null;
    public transient List<HashMap<String, Object>> AlertData = null;
    private transient Boolean hasWorkstepAlerts = null;
    private boolean hasProcessAlerts = false;
    private List<DataSlotTableIndex> dsTableIndexData = null;
    transient List<Map<String, Object>> resourceList = null;
    private boolean hasResources = false;
    private transient Boolean hasPerfomByAnyHumanWS = null;
    boolean isAuditEnabled = true;
    private ProcessType processType = ProcessType.BUSINESS;
    private String monitorDSName = null;
    boolean isMonitorDSMappedPIID = false;

    public WFProcess(String ptName, int processtype, long id, long maxwsid) throws BizLogicException {
        BLConstants.single();
        if (processtype == 1) {
            this.dynamic = true;
        }
        this.ID = id;
        this.hasWorksteps = new Vector();
        this.hasConnections = new Vector();
        this.hasDataslots = new Vector();
        this.hashDataSlotList = new HashMap();
        this.WSfyi = new Hashtable();
        this.setName(ptName);
        this.wsCounter = maxwsid;
        this.milestones = new Hashtable();
        this.timeStarted = System.currentTimeMillis();
        this.lastModifiedTime = this.getStartTime();
    }

    void setResources(List<Map<String, Object>> resList) {
        this.resourceList = resList;
        this.hasResources = resList != null && !resList.isEmpty();
    }

    public boolean hasResources() {
        return this.hasResources;
    }

    public void addWorkstep(WFWorkstep ws, long wsid) {
        String wsName = ws.getName();
        if (wsName == null || wsName.trim().isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_540", "WFProcess.addWorkstep", new Object[]{this.getName()});
        }
        for (int x = 0; x < this.hasWorksteps.size(); ++x) {
            if (!((WFWorkstep)this.hasWorksteps.elementAt(x)).getName().equals(wsName)) continue;
            throw new BizLogicException("BizLogic_ERR_541", "WFProcess.addWorkstep", (Object[])new String[]{this.getName(), ws.getName()});
        }
        if (wsid == 0L) {
            ws.setID(++this.wsCounter);
        } else {
            ws.setID(wsid);
        }
        this.hasWorksteps.addElement(ws);
        ws.setParentProcess(this);
    }

    public void addDataslot(WFDataslot ds) {
        if (this.isDataslotExist(ds.getName())) {
            throw new BizLogicException("BizLogic_ERR_644", "WFProcess.addDataslot", (Object[])new String[]{this.getName(), ds.getName()});
        }
        ds.setParentProcess(this);
        this.hasDataslots.addElement(ds);
        this.hashDataSlotList.put(ds.getName(), ds);
        if (!this.hasCollectionDS && ds.isCollection()) {
            this.hasCollectionDS = true;
        }
    }

    public boolean isDataslotExist(String dsName) {
        for (int ix = 0; ix < this.hasDataslots.size(); ++ix) {
            WFDataslot wds = (WFDataslot)this.hasDataslots.get(ix);
            if (!dsName.equalsIgnoreCase(wds.getName())) continue;
            return true;
        }
        return false;
    }

    public void addLink(WFLink link) {
        WFWorkstep ws = link.getSource();
        ws.addOutConnection(link);
        ws = link.getTarget();
        ws.addInConnection(link);
        link.setParentProcess(this);
        this.hasConnections.addElement(link);
    }

    public synchronized void activate() throws BizLogicException {
        if (!this.isCreated()) {
            throw new BizLogicException("BizLogic_ERR_544", "WFProcess.activate", new Object[]{this.getName()});
        }
        this.setStatus(2);
        ProcessTemplateDAO.store(this);
        BLUtil.fireEvent(this.getEventContext(), (int)2);
        if (BLControl.util.isCallback()) {
            if (ProcessCallback.hasCallback((int)2, (String)this.getName(), (String)this.getAppName())) {
                ProcessContext pctx = BLUtil.getProcessContext((WFProcess)this);
                ProcessCallback.execute((int)2, (SBMContext)pctx, (boolean)true);
            }
        }
    }

    private void setInLineTasks(boolean val) {
        this.inLineTasks = val;
    }

    public boolean hasInLineTasks() {
        return this.inLineTasks;
    }

    protected void validateWSData() {
        this.setInLineTasks(false);
        for (int ix = 0; ix < this.hasWorksteps.size(); ++ix) {
            WFWorkstep ws = (WFWorkstep)this.hasWorksteps.get(ix);
            if (!ws.isInLineTask()) continue;
            this.setInLineTasks(true);
            break;
        }
    }

    public boolean validateProcess() {
        int x;
        boolean startWFFound = false;
        boolean endWFFound = false;
        if (!this.isValidAppName()) {
            throw new BizLogicException("BizLogic_ERR_8805", "WFProcess.validateProcess", new Object[]{this.getName()});
        }
        if (this.getName().length() == 0) {
            throw new BizLogicException("BizLogic_ERR_546", "WFProcess.validateProcess", new Object[]{this.getName()});
        }
        this.validateMaxLength(this.getName(), "TEMPLATE_NAME");
        if (!WFValidateProcess.validateLogic(this)) {
            throw new BizLogicException("BizLogic_ERR_547", "WFProcess.validateProcess", new Object[]{this.getName()});
        }
        for (x = 0; x < this.hasWorksteps.size(); ++x) {
            int tagType = ((WFWorkstep)this.hasWorksteps.elementAt(x)).getType();
            if (tagType == 100) {
                startWFFound = true;
            }
            if (tagType != 101) continue;
            endWFFound = true;
        }
        if (!startWFFound) {
            throw new BizLogicException("BizLogic_ERR_613", "WFProcess.validateProcess", new Object[]{this.getName()});
        }
        if (!endWFFound) {
            throw new BizLogicException("BizLogic_ERR_614", "WFProcess.validateProcess", new Object[]{this.getName()});
        }
        for (x = 0; x < this.hasWorksteps.size(); ++x) {
            Vector dsNames;
            WFWorkstep wsObject = (WFWorkstep)this.hasWorksteps.elementAt(x);
            wsObject.validate();
            String reactivateWorkstepName = wsObject.getReactivateWorkStepName();
            if (reactivateWorkstepName != null) {
                this.getWorkstep(reactivateWorkstepName);
            }
            if (!wsObject.hasDSCopies() || "ALL".equalsIgnoreCase((String)(dsNames = wsObject.getDSCopyNames()).firstElement())) continue;
            for (int i = 0; i < dsNames.size(); ++i) {
                this.getDataslot((String)dsNames.elementAt(i));
            }
        }
        for (x = 0; x < this.hasDataslots.size(); ++x) {
            ((WFDataslot)this.hasDataslots.elementAt(x)).validate();
        }
        this.validateExpressions();
        this.getDSFromJS();
        this.validateLoopDS();
        this.validateWSData();
        this.validateManagerAndGroup();
        return true;
    }

    private void validateExpressions() {
        int x;
        for (x = 0; x < this.hasWorksteps.size(); ++x) {
            WFWorkstep wsObject = (WFWorkstep)this.hasWorksteps.elementAt(x);
            wsObject.validatePreCondition();
            wsObject.validateSkipCondition();
            wsObject.validateLoopCondition();
        }
        for (x = 0; x < this.hasConnections.size(); ++x) {
            WFLink linkObj = (WFLink)this.hasConnections.elementAt(x);
            linkObj.validateQuery();
        }
    }

    private void validateManagerAndGroup() {
        Group group;
        if (!this.isManagerValid()) {
            BLControl.logger.warnKey("BizLogic_ERR_3866", new Object[]{this.getManager(), this.getName()});
        }
        if (this.getGroup() != null && !this.getGroup().trim().isEmpty() && (group = BLUtil.getGroup((String)this.getGroup())) == null) {
            BLControl.logger.warnKey("BizLogic_ERR_3867", new Object[]{this.getGroup(), this.getName()});
        }
    }

    private boolean isManagerValid() {
        WFDataslot ds;
        String mgr = this.getManager();
        if (mgr.equals("@CREATOR")) {
            return true;
        }
        if (BLUtil.isParameter((String)mgr) && (ds = this.getDataslot(BLUtil.getParameter((String)mgr), true)) != null && ds.isGlobal() && ds.isString()) {
            return true;
        }
        User user = BLUtil.getUser((String)mgr);
        if (user != null) {
            return true;
        }
        Group group = BLUtil.getGroup((String)mgr);
        return group != null;
    }

    public Vector getFYI() {
        return this.fyi;
    }

    public void setFYI(Vector pifyi) {
        this.fyi = pifyi;
    }

    public Vector getWSFYI(String wsName) {
        return (Vector)this.WSfyi.get(wsName);
    }

    public void setWSFYI(String wsName, Vector wsfyi) {
        if (wsfyi == null) {
            this.WSfyi.remove(wsName);
        } else {
            this.WSfyi.put(wsName, wsfyi);
        }
    }

    public boolean isActivated() {
        return 2 == this.getStatus();
    }

    public boolean isCreated() {
        return 1 == this.getStatus();
    }

    public boolean isSuspendedBySeqVersion() {
        return this.suspendedBySeqVersion && this.isSuspended();
    }

    synchronized void suspendOnSeqVersion() {
        this.suspendedBySeqVersion = true;
        this.suspend();
    }

    public boolean isSuspended() {
        return 4 == this.getStatus();
    }

    public boolean isDeprecated() {
        return this.isSuspendedBySeqVersion();
    }

    synchronized void suspend() {
        if (this.isSuspended()) {
            BLControl.logger.warnKey("BizLogic_ERR_1653", new Object[]{this.getName()});
            return;
        }
        if (this.isCreated()) {
            throw new BizLogicException("BizLogic_ERR_1657", "WFProcess.suspend", new Object[]{this.getName()});
        }
        this.setStatus(4);
        BLUtil.fireEvent(this.getEventContext(), (int)4);
        if (BLControl.util.isCallback()) {
            if (ProcessCallback.hasCallback((int)4, (String)this.getName(), (String)this.getAppName())) {
                ProcessContext pctx = BLUtil.getProcessContext((WFProcess)this);
                ProcessCallback.execute((int)4, (SBMContext)pctx, (boolean)true);
            }
        }
        ProcessTemplateDAO.store(this);
        BLControl.logger.infoKey("BizLogic_ERR_1081", new Object[]{this.getName()});
    }

    synchronized void resume() {
        if (this.isActivated()) {
            BLControl.logger.warnKey("BizLogic_ERR_1658", new Object[]{this.getName()});
            return;
        }
        if (!this.isSuspended()) {
            throw new BizLogicException("BizLogic_ERR_1659", "WFProcess.resume", new Object[]{this.getName()});
        }
        if (this.isSuspendedBySeqVersion()) {
            WFProcess activeProcessObject = ProcessControl.getActiveProcessTemplate(this.appName);
            if (activeProcessObject != null) {
                throw new BizLogicException("BizLogic_ERR_1513", "WFProcess.resume", new Object[]{this.getName(), activeProcessObject.getName()});
            }
            if (ProcessControl.getMaxID(this.appName) != this.getID()) {
                throw new BizLogicException("BizLogic_ERR_1514", "WFProcess.resume", new Object[]{this.getName()});
            }
            this.suspendedBySeqVersion = false;
        }
        this.setStatus(2);
        BLUtil.fireEvent(this.getEventContext(), (int)5);
        if (BLControl.util.isCallback()) {
            if (ProcessCallback.hasCallback((int)5, (String)this.getName(), (String)this.getAppName())) {
                ProcessContext pctx = BLUtil.getProcessContext((WFProcess)this);
                ProcessCallback.execute((int)5, (SBMContext)pctx, (boolean)true);
            }
        }
        ProcessTemplateDAO.store(this);
        BLControl.logger.infoKey("BizLogic_ERR_1082", new Object[]{this.getName()});
    }

    public void setXMLFileName(String xml) {
        this.xmlfile = xml;
    }

    public String getXMLFileName() {
        return this.xmlfile;
    }

    public WFLink getLink(String lname) {
        String t = "";
        for (int x = 0; x < this.hasConnections.size(); ++x) {
            t = ((WFLink)this.hasConnections.elementAt(x)).getName();
            if (lname.compareTo(t) != 0) continue;
            return (WFLink)this.hasConnections.elementAt(x);
        }
        throw new BizLogicException("BizLogic_ERR_601", "WFProcess.getLink", (Object[])new String[]{this.getName(), lname});
    }

    public Vector getLinks() {
        return this.hasConnections;
    }

    public WFWorkstep getWorkstep(String wsName) {
        return this.getWorkstep(wsName, false);
    }

    public WFWorkstep getWorkstep(String wsName, boolean nullIfNotFound) {
        if (wsName == null || wsName.length() == 0) {
            if (nullIfNotFound) {
                return null;
            }
            throw new BizLogicException("BizLogic_ERR_548", "WFProcess.getWorkstep", (Object[])new String[]{this.getName(), "null"});
        }
        String t = "";
        for (int x = 0; x < this.hasWorksteps.size(); ++x) {
            t = ((WFWorkstep)this.hasWorksteps.elementAt(x)).getName();
            if (!wsName.equals(t)) continue;
            return (WFWorkstep)this.hasWorksteps.elementAt(x);
        }
        if (nullIfNotFound) {
            return null;
        }
        throw new BizLogicException("BizLogic_ERR_548", "WFProcess.getWorkstep", (Object[])new String[]{this.getName(), wsName});
    }

    public Vector getWorksteps() {
        return this.hasWorksteps;
    }

    public Vector getDataslots() {
        return this.hasDataslots;
    }

    public WFWorkstep getInitialWorkstep() {
        for (int x = 0; x < this.hasWorksteps.size(); ++x) {
            WFWorkstep ws = (WFWorkstep)this.hasWorksteps.elementAt(x);
            if (!ws.isInitialWorkstep()) continue;
            return ws;
        }
        throw new BizLogicException("BizLogic_ERR_549", "WFProcess.getInitialWorkstep", new Object[]{this.getName()});
    }

    public WFDataslot getDataslot(String processName, String dsName) {
        return this.getDataslot(processName, dsName, false);
    }

    public WFDataslot getDataslot(String processName, String dsName, boolean nullNotFound) {
        if (dsName == null || dsName.length() == 0) {
            throw new BizLogicException("BizLogic_ERR_550", "WFProcess.getDataslot", (Object[])new String[]{this.getName(), "null"});
        }
        Object ds = this.hashDataSlotList.get(dsName);
        if (ds != null) {
            return (WFDataslot)ds;
        }
        if (nullNotFound) {
            return null;
        }
        throw new BizLogicException("BizLogic_ERR_550", "WFProcess.getDataslot", (Object[])new String[]{processName, dsName});
    }

    public WFDataslot getDataslot(String dsName) {
        return this.getDataslot(this.getName(), dsName);
    }

    public WFDataslot getDataslot(String dsName, boolean nullNotFound) {
        return this.getDataslot(this.getName(), dsName, nullNotFound);
    }

    public Object getSlotValue(String dsName) {
        WFDataslot ds = this.getDataslot(dsName);
        return ds.getValue();
    }

    String[] getWSInputDataslots(String wsName) {
        for (int i = 0; i < this.hasWorksteps.size(); ++i) {
            WFWorkstep ws = (WFWorkstep)this.hasWorksteps.elementAt(i);
            if (!ws.getName().equals(wsName)) continue;
            return ws.getInputSlotsKeys();
        }
        throw new BizLogicException("BizLogic_ERR_548", "WFProcess.getWSInputDataslots", (Object[])new String[]{this.getName(), wsName});
    }

    String[] getWSOutputDataslots(String wsName) {
        for (int i = 0; i < this.hasWorksteps.size(); ++i) {
            WFWorkstep ws = (WFWorkstep)this.hasWorksteps.elementAt(i);
            if (!ws.getName().equals(wsName)) continue;
            return ws.getOutputSlotsKeys();
        }
        throw new BizLogicException("BizLogic_ERR_548", "WFProcess.getWSOutputDataslots", (Object[])new String[]{this.getName(), wsName});
    }

    public void setDescription(String c) {
        this.description = c;
        if (this.description != null) {
            this.checkDescriptionLength();
        }
    }

    public void setCategory(String c) {
        if (c == null || c.trim().isEmpty()) {
            this.category = "";
            return;
        }
        if (c.trim().length() > 64) {
            this.category = c.substring(0, 64);
            BLControl.logger.warnKey("BizLogic_ERR_8110", "WFProcess.setCategory()", (Object[])new String[]{Integer.toString(64), c, this.category});
        } else {
            this.category = c;
        }
    }

    public String getCategory() {
        return this.category == null ? "" : this.category;
    }

    public void setSubCategory(String subCat) {
        this.subCategory = subCat;
    }

    public String getSubCategory() {
        return this.subCategory;
    }

    public void setGroup(String c) {
        this.group = c;
    }

    public String getGroup() {
        return this.group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setManager(String m) {
        WFProcess wFProcess = this;
        synchronized (wFProcess) {
            this.manager = m;
        }
    }

    public String getManager() {
        return this.manager;
    }

    public void setVersionID(String v) {
        this.versionID = v;
    }

    public String getVersion() {
        return this.versionID;
    }

    public String getDescription() {
        return this.description;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String i) {
        this.info = i;
    }

    public void setEstimatedDuration(long s) {
        this.estimatedDuration = s;
    }

    public void setRecordSize(int rs) {
        this.recordSize = rs;
    }

    public int getRecordSize() {
        return this.recordSize;
    }

    public void setGlobalDSTableName(String tn) {
        this.globalDSTableName = tn;
    }

    public String getGlobalDSTableName() {
        return this.globalDSTableName;
    }

    public void setDSTableName(String tn) {
        this.instanceDSTableName = tn;
    }

    public String getDSTableName() {
        return this.instanceDSTableName;
    }

    public void setFolderId(String folderId) {
        this.folderId = folderId;
    }

    public String getFolderId() {
        return this.folderId;
    }

    public void setAppName(String applName) {
        this.validateMaxLength(applName, "APPLICATION_NAME");
        this.appName = applName;
        if (BLControl.util.DEBUG_CREATE) {
            BLControl.logger.debugKey("Bizlogic_ERR_3204", "WFProcess.setAppName", new Object[]{this.appName, this.getName()});
        }
    }

    public void setAppNameForAllVersions(String applName) {
        if (this.suspendedBySeqVersion) {
            throw new BizLogicException("BizLogic_ERR_673", "WFProcess.setAppNameForAllVersions(applName)", new Object[]{this.getName()});
        }
        Vector v = (Vector)ProcessControl.getVersions(this.getID());
        for (int itr = 0; itr < v.size(); ++itr) {
            WFProcess pt = (WFProcess)v.get(itr);
            if (pt.getID() == this.getID() || pt.getAppName().equals(applName)) continue;
            pt.setAppName(applName);
            ProcessControl.updateProcessTemplate(pt);
        }
        this.setAppName(applName);
    }

    public String getAppName() {
        return this.appName;
    }

    public boolean isValidAppName() {
        return this.appName != null && !this.appName.trim().isEmpty();
    }

    public boolean hasDocumentDataslot() {
        for (int ix = 0; ix < this.hasDataslots.size(); ++ix) {
            WFDataslot ds = (WFDataslot)this.hasDataslots.elementAt(ix);
            if (!ds.isDocument()) continue;
            return true;
        }
        return false;
    }

    public boolean hasGlobalBlobDS() {
        for (int ix = 0; ix < this.hasDataslots.size(); ++ix) {
            WFDataslot ds = (WFDataslot)this.hasDataslots.elementAt(ix);
            if (!ds.isGlobal() || !ds.isObject() && !ds.isList() && !ds.isMap()) continue;
            return true;
        }
        return false;
    }

    public boolean hasInstanceBlobDS() {
        for (int ix = 0; ix < this.hasDataslots.size(); ++ix) {
            WFDataslot ds = (WFDataslot)this.hasDataslots.elementAt(ix);
            if (ds.isGlobal() || !ds.isObject() && !ds.isList() && !ds.isMap()) continue;
            return true;
        }
        return false;
    }

    public void replacePerformer(String oldp, String newp) {
        WFWorkstep ws = null;
        if (oldp.length() == 0 || newp.length() == 0 || oldp == null || newp == null) {
            throw new BizLogicException("BizLogic_ERR_551", "WFProcess.replacePerformer", new Object[]{this.getName()});
        }
        for (int x = 0; x < this.hasWorksteps.size(); ++x) {
            ws = (WFWorkstep)this.hasWorksteps.elementAt(x);
            if (ws.hasPerformer == null || !ws.hasPerformer.equals(oldp)) continue;
            ws.setPerformer(newp);
        }
        if (ws == null) {
            throw new BizLogicException("BizLogic_ERR_552", "WFProcess.replacePerformer", new Object[]{this.getName()});
        }
    }

    public void setWorkstepPerformer(String wsname, String performer, boolean performedByAll) {
        WFWorkstep ws = null;
        boolean found = false;
        for (int x = 0; x < this.hasWorksteps.size(); ++x) {
            ws = (WFWorkstep)this.hasWorksteps.elementAt(x);
            if (!ws.getName().equals(wsname)) continue;
            found = true;
            if (ws instanceof WFConnectorWS) {
                throw new BizLogicException("BizLogic_ERR_595", "WFProcess.setWorkstepPerformer", new Object[]{this.getName()});
            }
            ws.setPerformer(performer);
            if (!(ws instanceof WFAtomicWS)) break;
            ((WFAtomicWS)ws).setPerformedByAll(performedByAll);
            break;
        }
        if (ws == null || !found) {
            throw new BizLogicException("BizLogic_ERR_553", "WFProcess.setWorkstepPerformer", new Object[]{wsname});
        }
    }

    protected Map<String, Object> getEventContext() {
        Map eventContext = SBMUtil.getNewEventContext();
        eventContext.put("PROCESSTEMPLATENAME", this.getName());
        eventContext.put("PROCESSTEMPLATEID", this.getID());
        eventContext.put("DURATION", String.valueOf(this.getEstimatedDuration()));
        if (this.category != null) {
            eventContext.put("CATEGORY", this.category);
        }
        if (this.group != null) {
            eventContext.put("GROUP", this.group);
        }
        if (this.manager != null) {
            eventContext.put("PMANAGER", this.manager);
        }
        Map<String, String> processData = this.getProcessData();
        eventContext.put("PROCESSDATA", processData);
        this.addDsIndexData(eventContext);
        Map<String, Object> voteWSInfo = this.addProcessWSList(eventContext);
        this.addDescription(eventContext);
        this.addVoteInfo(eventContext, voteWSInfo);
        this.addPrintEventName(eventContext);
        eventContext.put("APP_NAME", this.getAppName());
        this.addMilestone(eventContext);
        this.addMonitoringProcessInfo(eventContext);
        return eventContext;
    }

    private Map<String, String> getProcessData() {
        HashMap<String, String> processData = new HashMap<String, String>();
        for (int x = 0; x < this.hasDataslots.size(); ++x) {
            WFDataslot ds = (WFDataslot)this.hasDataslots.elementAt(x);
            if (!ds.isPublic() || ds.isObject()) continue;
            StringBuilder sb = new StringBuilder(ds.getType4DB());
            sb.append("|").append(ds.getValue4Event(ds.getValue())).append("|").append(ds.getSize()).append("|").append(ds.getBizManageAccess()).append("|").append(ds.getScale()).append("|").append(ds.isGlobal()).append("|").append(ds.getLabel()).append("|").append(ds.getBizSiteAccess()).append("|").append(ds.isMonitorDS());
            processData.put(ds.getName(), sb.toString());
        }
        return processData;
    }

    private void addDsIndexData(Map<String, Object> eventContext) {
        HashMap<String, List<String>> dsIndexData = null;
        if (this.dsTableIndexData != null) {
            dsIndexData = new HashMap<String, List<String>>();
            for (DataSlotTableIndex dsTableIndex : this.dsTableIndexData) {
                String indexName = dsTableIndex.getBizStoreIndexName();
                List<String> cols = dsTableIndex.getDataslotNames();
                dsIndexData.put(indexName, cols);
            }
        }
        if (this.dsTableIndexData != null) {
            eventContext.put("DSINDEXDATA", dsIndexData);
        }
    }

    private Map<String, Object> addProcessWSList(Map<String, Object> eventContext) {
        HashMap<String, HashMap> voteWSInfo = null;
        StringBuilder buf = new StringBuilder();
        for (int x = 0; x < this.hasWorksteps.size(); ++x) {
            WFWorkstep ws = (WFWorkstep)this.hasWorksteps.elementAt(x);
            buf.append(ws.getName());
            buf.append(";");
            buf.append(ws.getWSType());
            buf.append(";");
            buf.append(ws.getID());
            if (ws.getMilestoneName() != null) {
                buf.append(";");
                buf.append(ws.getMilestoneName());
            }
            buf.append("|");
            if (!this.isCreated() || !ws.isAtomic() || !((WFAtomicWS)ws).isVoteEnabled()) continue;
            WFVoteWS vws = (WFVoteWS)ws;
            if (voteWSInfo == null) {
                voteWSInfo = new HashMap<String, HashMap>();
            }
            voteWSInfo.put(vws.getName(), vws.getVoteCriteria().getAttributes());
        }
        eventContext.put("PROCESSWSLIST", buf.toString());
        return voteWSInfo;
    }

    private void addDescription(Map<String, Object> eventContext) {
        if (this.description == null) {
            return;
        }
        if (this.description.length() > 1000) {
            eventContext.put("DESCRIPTION", this.description.substring(0, 1000));
        } else {
            eventContext.put("DESCRIPTION", this.description);
        }
    }

    private void addVoteInfo(Map<String, Object> eventContext, Map voteWSInfo) {
        if (this.isCreated() && voteWSInfo != null) {
            eventContext.put("VOTEINFO", voteWSInfo);
        }
    }

    private void addPrintEventName(Map<String, Object> eventContext) {
        if (BLControl.util.isPrintEvent()) {
            eventContext.put("NAME", this.getName());
        }
    }

    private void addMilestone(Map<String, Object> eventContext) {
        if (this.milestones != null && !this.milestones.isEmpty()) {
            eventContext.put("@@ALL_MILESTONE@@", this.milestones);
        }
    }

    private void addMonitoringProcessInfo(Map<String, Object> eventContext) {
        eventContext.put("PROCESS_TYPE", this.getProcessType());
        if (this.isMonitoringProcess()) {
            eventContext.put("MONITOR_DS", this.getMonitorDSName());
        }
    }

    public String[] getProcessFile() {
        String fn = BLUtil.getPTXMLFilePath((String)this.getXMLFileName());
        File tf = new File(fn);
        int fl = (int)tf.length();
        int sz = (int)((long)fl / 32768L);
        if ((long)fl % 32768L > 0L) {
            ++sz;
        }
        String[] ret = new String[sz];
        StringBuilder sBuf = new StringBuilder();
        try {
            int ch;
            FileInputStream fis = new FileInputStream(fn);
            SBMConstants.self().getClass();
            InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
            BufferedReader in = new BufferedReader(isr);
            int i = 0;
            int j = 0;
            while ((ch = ((Reader)in).read()) != -1) {
                if ((long)j == 32768L) {
                    j = 0;
                    ret[i++] = sBuf.toString();
                    sBuf.setLength(0);
                }
                ++j;
                sBuf.append((char)ch);
            }
            ret[i++] = sBuf.toString();
            ((Reader)in).close();
        }
        catch (IOException e) {
            return new String[]{"Can not read the XML file " + fn + " !"};
        }
        return ret;
    }

    public long getEstimatedDuration() {
        return this.estimatedDuration;
    }

    public HashMap getAllDataSlots() {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        for (int x = 0; x < this.hasDataslots.size(); ++x) {
            WFDataslot ds = (WFDataslot)this.hasDataslots.elementAt(x);
            if (ds.isPublic()) {
                if (ds.getValue() == null) continue;
                hm.put(ds.getName(), ds.getValue());
                continue;
            }
            hm.put(ds.getName(), "Not Public");
        }
        return hm;
    }

    public synchronized String[] getAllDataSlotName() {
        return BLUtil.getHashMapKeys((HashMap)this.hashDataSlotList);
    }

    public Vector getDataSlotNames() {
        Vector<String> ptds = new Vector<String>();
        for (int x = 0; x < this.hasDataslots.size(); ++x) {
            WFDataslot ds = (WFDataslot)this.hasDataslots.elementAt(x);
            ptds.add(ds.getName());
        }
        return ptds;
    }

    public Vector getDataslotInfo() {
        Vector dsList = this.getDataslots();
        Vector dsInfos = new Vector();
        for (int x = 0; x < dsList.size(); ++x) {
            WFDataslot ds = (WFDataslot)dsList.elementAt(x);
            Hashtable<String, Object> h = new Hashtable<String, Object>();
            h.put("DATASLOTNAME", ds.getName());
            h.put("DATASLOTTYPE", ds.getType());
            if (ds.isObject()) {
                if (ds.getJavaClassName() == null) {
                    h.put("JAVACLASSNAME", "<NULL>");
                } else {
                    h.put("JAVACLASSNAME", ds.getJavaClassName());
                }
            }
            if (ds.isPublic()) {
                if (ds.getValue() == null) {
                    h.put("DATASLOTVALUE", "<NULL>");
                } else {
                    h.put("DATASLOTVALUE", ds.getValue());
                }
                if (ds.getChoices() == null) {
                    h.put("DATASLOTVALUECHOICE", "<NULL>");
                } else {
                    h.put("DATASLOTVALUECHOICE", ds.getChoices());
                }
            } else {
                h.put("DATASLOTVALUE", "Not Public");
                h.put("DATASLOTVALUECHOICE", "Not Public");
            }
            if (ds.isMultiLine()) {
                h.put("MULTILINE", "true");
            } else {
                h.put("MULTILINE", "false");
            }
            h.put("REQUIRED", ds.isRequired());
            h.put("LABEL", ds.getLabel());
            h.put("ISMONITORDS", ds.isMonitorDS());
            dsInfos.addElement(h);
        }
        return dsInfos;
    }

    public Hashtable getDataslotInfo(String dsName) {
        Vector dsInfos = this.getDataslotInfo();
        for (int ix = 0; ix < dsInfos.size(); ++ix) {
            String name = (String)((Hashtable)dsInfos.elementAt(ix)).get("DATASLOTNAME");
            if (!name.equals(dsName)) continue;
            return (Hashtable)dsInfos.elementAt(ix);
        }
        return null;
    }

    public void updateSlotDataToNull(String dsName) {
        WFDataslot ds = this.getDataslot(dsName);
        ds.setValueToNull();
    }

    public WFWorkstep getWorkstep(long id) {
        for (int x = 0; x < this.hasWorksteps.size(); ++x) {
            if (((WFWorkstep)this.hasWorksteps.elementAt(x)).getID() != id) continue;
            return (WFWorkstep)this.hasWorksteps.elementAt(x);
        }
        throw new BizLogicException("BizLogic_ERR_548", "WFProcess.getWorkstep", (Object[])new String[]{this.getName(), "ID = " + id});
    }

    public WFJavaScript getJavaScript(long wsid) {
        WFWorkstep ws = this.getWorkstep(wsid);
        if (ws != null) {
            return ws.getJavaScript();
        }
        return null;
    }

    public long getWorkstepID(String wsName) {
        WFWorkstep ws = this.getWorkstep(wsName);
        return ws.getID();
    }

    public long generateTemplateID() {
        try {
            this.ID = BLControl.util.ptSeq.getNextNumber();
            return this.ID;
        }
        catch (Exception ex) {
            throw new BizLogicException("BizLogic_ERR_5008", "WFProcess.generateTemplateID", (Throwable)ex);
        }
    }

    public void addJScript(String key, WFJavaScript value) {
        if (this.pwsjscript == null) {
            this.pwsjscript = new Hashtable();
        }
        this.pwsjscript.put(key, value);
    }

    public WFJavaScript getJScript(String key) {
        if (this.pwsjscript == null) {
            return null;
        }
        WFJavaScript js = (WFJavaScript)this.pwsjscript.get(key);
        return js;
    }

    public int getMemSize() {
        if (this.estSize != 0) {
            return this.estSize;
        }
        try {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            ObjectOutputStream oo = new ObjectOutputStream(bo);
            oo.writeObject(this);
            oo.flush();
            this.estSize = bo.size();
            return this.estSize;
        }
        catch (Exception e) {
            BLControl.logger.errorKey("BizLogic_ERR_2607", new Object[]{this.getName()}, (Throwable)e);
            return -1;
        }
    }

    public synchronized Vector getGlobalDSNamesList() {
        WFDataslot ds = null;
        if (this.globalDS == null) {
            this.globalDS = new Vector();
            for (int i = 0; i < this.hasDataslots.size(); ++i) {
                ds = (WFDataslot)this.hasDataslots.elementAt(i);
                if (!ds.isGlobal()) continue;
                this.globalDS.add(ds.getName());
            }
        }
        return new Vector(this.globalDS);
    }

    public Map<String, Object> getDefaultDSValues(boolean onlyGlobal) {
        HashMap<String, Object> dsValues = new HashMap<String, Object>();
        WFDataslot ds = null;
        for (int i = 0; i < this.hasDataslots.size(); ++i) {
            ds = (WFDataslot)this.hasDataslots.elementAt(i);
            if (onlyGlobal && ds.isGlobal()) {
                dsValues.put(ds.getName(), ds.getValue());
                continue;
            }
            dsValues.put(ds.getName(), ds.getValue());
        }
        return dsValues;
    }

    public synchronized HashMap getGlobalDSAccessNameList() {
        WFDataslot ds = null;
        if (this.globalDSAccess == null) {
            this.globalDSAccess = new HashMap();
            for (int i = 0; i < this.hasDataslots.size(); ++i) {
                ds = (WFDataslot)this.hasDataslots.elementAt(i);
                if (!ds.isGlobal()) continue;
                this.globalDSAccess.put(ds.getName(), ds.isPublic());
            }
        }
        return this.globalDSAccess;
    }

    public synchronized Vector getInstanceDSNameList() {
        WFDataslot ds = null;
        if (this.instanceDS == null) {
            this.instanceDS = new Vector();
            for (int i = 0; i < this.hasDataslots.size(); ++i) {
                ds = (WFDataslot)this.hasDataslots.elementAt(i);
                if (ds.isGlobal()) continue;
                this.instanceDS.add(ds.getName());
            }
        }
        return this.instanceDS;
    }

    public synchronized String[] getInstanceDSNamesArray() {
        Vector instanceDSList = this.getInstanceDSNameList();
        String[] dsNames = new String[instanceDSList.size()];
        return instanceDSList.toArray(dsNames);
    }

    public synchronized HashMap getInstanceDSAccessNameList() {
        WFDataslot ds = null;
        if (this.instanceDSAccess == null) {
            this.instanceDSAccess = new HashMap();
            for (int i = 0; i < this.hasDataslots.size(); ++i) {
                ds = (WFDataslot)this.hasDataslots.elementAt(i);
                if (ds.isGlobal()) continue;
                this.instanceDSAccess.put(ds.getName(), ds.isPublic());
            }
        }
        return this.instanceDSAccess;
    }

    public HashMap getInstanceDataSlotMetaInfo() {
        LinkedHashMap<String, HashMap> dsList = new LinkedHashMap<String, HashMap>();
        for (int ix = 0; ix < this.hasDataslots.size(); ++ix) {
            WFDataslot ds = (WFDataslot)this.hasDataslots.elementAt(ix);
            if (ds.isGlobal()) continue;
            HashMap dsAttrs = ds.getMetaData();
            dsList.put(ds.getName(), dsAttrs);
        }
        return dsList;
    }

    public HashMap getDataSlotMetaData(String[] dsNames) {
        LinkedHashMap<String, HashMap> dsList = new LinkedHashMap<String, HashMap>(dsNames.length);
        for (int ix = 0; ix < dsNames.length; ++ix) {
            WFDataslot ds = this.getDataslot(dsNames[ix]);
            dsList.put(dsNames[ix], ds.getMetaData());
        }
        return dsList;
    }

    public HashMap getGlobalDataSlotMetaInfo() {
        LinkedHashMap<String, HashMap> dsList = new LinkedHashMap<String, HashMap>();
        for (int ix = 0; ix < this.hasDataslots.size(); ++ix) {
            WFDataslot ds = (WFDataslot)this.hasDataslots.elementAt(ix);
            if (!ds.isGlobal()) continue;
            HashMap dsAttrs = ds.getMetaData();
            dsList.put(ds.getName(), dsAttrs);
        }
        return dsList;
    }

    public HashMap getDataSlotMetaInfo() {
        if (this.metaDataDS != null) {
            return this.metaDataDS;
        }
        LinkedHashMap<String, HashMap> dsList = new LinkedHashMap<String, HashMap>();
        for (int ix = 0; ix < this.hasDataslots.size(); ++ix) {
            WFDataslot ds = (WFDataslot)this.hasDataslots.elementAt(ix);
            HashMap dsAttrs = ds.getMetaData();
            dsList.put(ds.getName(), dsAttrs);
        }
        this.metaDataDS = dsList;
        return dsList;
    }

    public void refreshMetaDataDSCache() {
        this.metaDataDS = null;
        this.getDataSlotMetaInfo();
    }

    public HashMap getDataSlotMetaInfo(String dsname) {
        return (HashMap)this.getDataSlotMetaInfo().get(dsname);
    }

    public synchronized String[] getInstancePrivateDocDSNames() {
        WFDataslot ds = null;
        if (this.instancePrivateDocDSName == null && this.hasDataslots != null) {
            ArrayList<String> dsNameArr = new ArrayList<String>();
            for (int x = 0; x < this.hasDataslots.size(); ++x) {
                ds = (WFDataslot)this.hasDataslots.elementAt(x);
                if (!ds.isDocument() || ds.isGlobal() || ds.isPublic()) continue;
                dsNameArr.add(ds.getName());
            }
            this.instancePrivateDocDSName = dsNameArr.toArray(new String[0]);
        }
        return this.instancePrivateDocDSName;
    }

    public void setAttributes(HashMap hm) {
        if (this.isSuspended()) {
            throw new BizLogicException("BizLogic_ERR_674", "WFProcess.setAttributes(hm)", new Object[]{this.getName()});
        }
        for (String key : hm.keySet()) {
            if (key.equals("PMANAGER")) {
                String manager = (String)hm.get(key);
                this.setManager(manager);
                continue;
            }
            if (key.equals("DESCRIPTION")) {
                String desc = (String)hm.get(key);
                this.setDescription(desc);
                continue;
            }
            if (key.equals("APP_NAME")) {
                String name = (String)hm.get(key);
                this.setAppNameForAllVersions(name);
                continue;
            }
            if (key.equals("FYI")) {
                Vector fyi = (Vector)hm.get(key);
                this.setFYI(fyi);
                continue;
            }
            if (key.equals("INSTRUCTION")) {
                String instr = (String)hm.get(key);
                this.setInstruction(instr);
                continue;
            }
            if (key.equals("ESTIMATEDDURATION")) {
                long duration = (Long)hm.get(key);
                this.setEstimatedDuration(duration);
                continue;
            }
            if (key.equals("TIMER_ACTION")) {
                TimerActionList actions = (TimerActionList)hm.get(key);
                this.setOverDueAction(actions);
                continue;
            }
            if (key.equals("PRIORITY")) {
                this.setPriority((String)hm.get(key));
                continue;
            }
            throw new BizLogicException("BizLogic_ERR_1517", "WFProcess.setAttributes", new Object[]{this.getName(), key, hm.get(key)});
        }
        ProcessControl.updateProcessTemplate(this);
    }

    public HashMap getAttributes() {
        HashMap<String, Object> attribs = new HashMap<String, Object>();
        attribs.put("PROCESSTEMPLATEID", this.getID());
        attribs.put("PROCESSTEMPLATENAME", this.getName());
        attribs.put("PARENT_ID", this.getParentID());
        attribs.put("CREATOR", this.getCreator());
        attribs.put("PMANAGER", this.getManager());
        attribs.put("VERSION", this.getVersion());
        attribs.put("STATUS", super.getStatus());
        attribs.put("CATEGORY", this.getCategory());
        attribs.put("SUBCATEGORY", this.getSubCategory());
        attribs.put("GROUP", this.getGroup());
        attribs.put("INFO", this.getInfo());
        attribs.put("DESCRIPTION", this.getDescription());
        attribs.put("APP_NAME", this.getAppName());
        attribs.put("ESTIMATEDDURATION", this.getEstimatedDuration());
        attribs.put("ISSUSPENDEDBYVERSION", this.isSuspendedBySeqVersion());
        attribs.put("STARTTIME", this.timeStarted);
        attribs.put("LAST_MODIFIED_TIME", this.lastModifiedTime);
        attribs.put("PRIORITY", this.priority);
        attribs.put("DYNAMIC", this.isDynamic());
        attribs.put("AUDIT", this.isAuditEnabled());
        attribs.put("FYI", this.getFYI());
        attribs.put("XMLFILE", this.getXMLFileName());
        if (this.isDynamic()) {
            attribs.put("DYNAMICINSTANCEID", this.dynamicinstanceid);
        }
        attribs.put("PROCESS_TYPE", this.processType);
        if (this.isMonitoringProcess()) {
            attribs.put("MONITOR_DS", this.getMonitorDSName());
            attribs.put("ISMONITORDSMAPPEDTOPIID", this.isMonitorDSMappedToPIID());
        }
        return attribs;
    }

    public String toString() {
        String tmp = "";
        tmp = "\nProcess Name: " + this.getName() + "\n";
        for (int x = 0; x < this.hasWorksteps.size(); ++x) {
            Object ws = this.hasWorksteps.elementAt(x);
            tmp = tmp + ((WFWorkstep)ws).toString();
        }
        return tmp;
    }

    public boolean compileJavaScript() {
        boolean compileOK = true;
        Vector wsv = this.getWorksteps();
        String wsName = null;
        for (int ix = 0; ix < wsv.size(); ++ix) {
            WFWorkstep ws = (WFWorkstep)wsv.elementAt(ix);
            wsName = ws.getName();
            if (ws.wsjscript == null) continue;
            try {
                ws.wsjscript.reCompileJavaScript();
                this.addJScript(ws.getName(), ws.wsjscript);
                continue;
            }
            catch (Exception e) {
                BLControl.logger.errorKey("BizLogic_ERR_1516", (Object[])new String[]{this.getName(), wsName}, (Throwable)e);
                compileOK = false;
            }
        }
        return compileOK;
    }

    public boolean getDSFromJS() {
        boolean status = true;
        Vector wsv = this.getWorksteps();
        for (int ix = 0; ix < wsv.size(); ++ix) {
            WFWorkstep ws = (WFWorkstep)wsv.elementAt(ix);
            if (ws.wsjscript == null) continue;
            String wsName = ws.getName();
            try {
                Vector ptDSNames = this.getDataSlotNames();
                Vector dsUsed = null;
                String tmp = ws.wsjscript.getPreCondition();
                if (tmp != null) {
                    dsUsed = BLUtil.getJavaScriptSlots((String)tmp, (Vector)ptDSNames);
                    ws.setPreCondReadDS(dsUsed);
                    ws.checkPreCondReadDS();
                }
                if ((tmp = ws.wsjscript.getPreFunction()) != null && !(dsUsed = BLUtil.getJavaScriptSlots((String)tmp, (Vector)ptDSNames)).isEmpty()) {
                    ws.setPreJSReadDS(dsUsed);
                }
                if ((tmp = ws.wsjscript.getPostFunction()) == null || (dsUsed = BLUtil.getJavaScriptSlots((String)tmp, (Vector)ptDSNames)).isEmpty()) continue;
                ws.setPostJSReadDS(dsUsed);
                continue;
            }
            catch (Exception e) {
                BLControl.logger.errorKey("BizLogic_ERR_1515", (Object[])new String[]{this.getName(), wsName}, (Throwable)e);
                status = false;
            }
        }
        return status;
    }

    public void validateLoopDS() {
        Vector wsv = this.getWorksteps();
        for (int ix = 0; ix < wsv.size(); ++ix) {
            WFWorkstep ws = (WFWorkstep)wsv.get(ix);
            String loopDS = ws.getLoopConditionCounterDSName();
            if (loopDS == null) continue;
            WFDataslot ds = this.getDataslot(loopDS);
            if (!ds.isLong()) {
                throw new BizLogicException("BizLogic_ERR_3673", "WFProcess.validateLoopDS", new Object[]{this.getName(), ws.getName(), loopDS});
            }
            if (!ds.isGlobal()) continue;
            throw new BizLogicException("BizLogic_ERR_3676", "WFProcess.validateLoopDS", new Object[]{this.getName(), ws.getName(), loopDS});
        }
    }

    public synchronized HashMap getDataSlotsMetaInfo(String metatype) {
        WFDataslot ds = null;
        if ("TYPE".equals(metatype)) {
            if (this.metaDSType == null) {
                this.metaDSType = new HashMap();
                for (int i = 0; i < this.hasDataslots.size(); ++i) {
                    ds = (WFDataslot)this.hasDataslots.elementAt(i);
                    this.metaDSType.put(ds.getName(), ds.getType());
                }
            }
            return this.metaDSType;
        }
        if ("SIZE".equals(metatype)) {
            if (this.metaDSSize == null) {
                this.metaDSSize = new HashMap();
                for (int i = 0; i < this.hasDataslots.size(); ++i) {
                    ds = (WFDataslot)this.hasDataslots.elementAt(i);
                    this.metaDSSize.put(ds.getName(), ds.getSize());
                }
            }
            return this.metaDSSize;
        }
        if ("ACCESS".equals(metatype)) {
            if (this.metaDSAccess == null) {
                this.metaDSAccess = new HashMap();
                for (int i = 0; i < this.hasDataslots.size(); ++i) {
                    ds = (WFDataslot)this.hasDataslots.elementAt(i);
                    this.metaDSAccess.put(ds.getName(), ds.isPublic());
                }
            }
            return this.metaDSAccess;
        }
        return null;
    }

    public HashMap getDataSlotsType() {
        return this.getTemplateDSType();
    }

    public HashMap<String, String> getAllDSType() {
        HashMap<String, String> dsType = this.getTemplateDSType();
        dsType.putAll(this.getSystemDSType());
        return dsType;
    }

    public HashMap<String, String> getTemplateDSType() {
        HashMap<String, String> dsType = new HashMap<String, String>();
        WFDataslot ds = null;
        for (int i = 0; i < this.hasDataslots.size(); ++i) {
            ds = (WFDataslot)this.hasDataslots.elementAt(i);
            if (ds.isObject()) {
                dsType.put(ds.getName(), ds.getType() + ":" + ds.getJavaClassName());
                continue;
            }
            dsType.put(ds.getName(), ds.getType());
        }
        return dsType;
    }

    public HashMap<String, String> getSystemDSType() {
        HashMap<String, String> dsType = new HashMap<String, String>();
        BLConstants.single();
        BLConstants.single();
        dsType.put("@CREATOR", "STRING");
        BLConstants.single();
        BLConstants.single();
        dsType.put("@PRIORITY", "STRING");
        BLConstants.single();
        BLConstants.single();
        dsType.put("@PROCESSNAME", "STRING");
        BLConstants.single();
        BLConstants.single();
        dsType.put("@WORKSTEPNAME", "STRING");
        BLConstants.single();
        BLConstants.single();
        dsType.put("@STARTTIME", "LONG");
        BLConstants.single();
        dsType.put("@PROCESS_INSTANCE_ID", "LONG");
        BLConstants.single();
        dsType.put("@PROCESS_TEMPLATE_NAME", "STRING");
        return dsType;
    }

    public HashMap getDataSlotsWithDefaultValues(String dsType) {
        return this.getDataSlotsWithDefaultValues(dsType, false);
    }

    public HashMap getDataSlotsWithDefaultValues(String dsType, boolean onlyGlobalDS) {
        HashMap<String, Object> dsValues = new HashMap<String, Object>();
        WFDataslot ds = null;
        for (int ix = 0; ix < this.hasDataslots.size(); ++ix) {
            Object defvalue;
            ds = (WFDataslot)this.hasDataslots.get(ix);
            if (ds.isGlobal() != onlyGlobalDS || !ds.getType().equals(dsType) || (defvalue = ds.getDefaultValue()) == null || defvalue.toString().trim().isEmpty()) continue;
            dsValues.put(ds.getName(), defvalue);
        }
        return dsValues;
    }

    public HashMap getXMLDSWithDefaultValues(HashMap excludeDS, boolean onlyGlobalDS) {
        HashMap<String, XML> dsValues = new HashMap<String, XML>();
        Map.Entry entry = null;
        BLConstants.single();
        HashMap dslist = this.getDataSlotsWithDefaultValues("XML", onlyGlobalDS);
        if (dslist.isEmpty()) {
            return dsValues;
        }
        Iterator itr = dslist.entrySet().iterator();
        String dsName = null;
        String defaultValue = null;
        URL fileurl = null;
        File file = null;
        XML xmlds = null;
        while (itr.hasNext()) {
            Object obj;
            String dsContent = null;
            entry = itr.next();
            dsName = (String)entry.getKey();
            defaultValue = entry.getValue().toString();
            if (defaultValue == null || defaultValue.trim().isEmpty() || excludeDS != null && excludeDS.containsKey(dsName) && ((obj = excludeDS.get(dsName)) instanceof XML ? (xmlds = (XML)obj).getID() > 0L || xmlds.isContentUpdated() : obj instanceof String)) continue;
            try {
                SBMConstants.self().getClass();
                if (defaultValue.startsWith("http://")) {
                    URL url = new URL(defaultValue);
                    SBMConstants.self().getClass();
                    dsContent = FileUtil.getString((URL)url, (String)"UTF-8");
                } else {
                    SBMConstants.self().getClass();
                    if (defaultValue.startsWith("file://")) {
                        fileurl = new URL(defaultValue);
                        SBMConstants.self().getClass();
                        dsContent = FileUtil.getString((URL)fileurl, (String)"UTF-8");
                    } else {
                        String fileloc = this.getDocLocation() + defaultValue;
                        file = new File(fileloc);
                        if (file.exists()) {
                            SBMConstants.self().getClass();
                            dsContent = FileUtil.getString((File)file, (String)"UTF-8");
                            if (BLControl.util.DEBUG_UTIL) {
                                BLControl.logger.debugKey("BizLogic_ERR_3510", "getXMLDSWithDefaultValues", new Object[]{defaultValue, this.getName(), dsName});
                            }
                        } else {
                            BLControl.logger.warnKey("BizLogic_ERR_3509", "getXMLDSWithDefaultValues", new Object[]{defaultValue, this.getName(), dsName});
                        }
                    }
                }
            }
            catch (Exception ignore) {
                BLControl.logger.errorKey("BizLogic_ERR_3508", "getXMLDSWithDefaultValues", (Throwable)ignore, new Object[]{defaultValue, this.getName(), dsName});
            }
            if (dsContent == null) continue;
            XML xmlObj = new XML(dsContent);
            String docName = FileUtil.getFileName((String)defaultValue);
            if (docName != null && !docName.trim().isEmpty()) {
                xmlObj.setName(docName);
            }
            dsValues.put(dsName, xmlObj);
        }
        return dsValues;
    }

    public HashMap getDateTimeDSWithDefaultValues(HashMap excludeDS, boolean onlyGlobalDS, long startTime) {
        HashMap<String, DateTime> dsValues = new HashMap<String, DateTime>();
        BLConstants.single();
        HashMap dslist = this.getDataSlotsWithDefaultValues("DATETIME", onlyGlobalDS);
        if (dslist.isEmpty()) {
            return dsValues;
        }
        Iterator itr = dslist.entrySet().iterator();
        String dsName = null;
        String defaultValue = null;
        Map.Entry entry = null;
        while (itr.hasNext()) {
            long curTime = -1L;
            entry = itr.next();
            dsName = (String)entry.getKey();
            defaultValue = entry.getValue().toString();
            if (defaultValue == null || defaultValue.trim().isEmpty() || excludeDS != null && excludeDS.containsKey(dsName) || !"@STARTTIME".equals(defaultValue)) continue;
            curTime = startTime > 0L ? startTime : System.currentTimeMillis();
            dsValues.put(dsName, new DateTime(curTime));
            if (!BLControl.util.DEBUG_UTIL) continue;
            BLControl.logger.debugKey("BizLogic_ERR_3510", "getDateTimeDSWithDefaultValues", new Object[]{new Date(curTime), this.getName(), dsName});
        }
        return dsValues;
    }

    public String getInstruction() {
        return this.instruction;
    }

    public void setInstruction(String instr) {
        this.instruction = instr;
    }

    public void checkPreCondGlobalSlotReference() {
        for (int ix = this.hasWorksteps.size() - 1; ix >= 0; --ix) {
            WFWorkstep ws = (WFWorkstep)this.hasWorksteps.elementAt(ix);
            ws.checkPreCondReadDS();
        }
    }

    public boolean isValidateSlot(String dsName) {
        return this.hashDataSlotList.containsKey(dsName);
    }

    public boolean isValidGlobalSlot(String dsName) {
        Vector v = this.getGlobalDSNamesList();
        return v.contains(dsName);
    }

    public boolean isValidInstanceSlot(String dsName) {
        Vector v = this.getInstanceDSNameList();
        return v.contains(dsName);
    }

    public Vector getRollbackPoints() {
        Vector<String> wsNames = new Vector<String>();
        for (int i = 0; i < this.hasWorksteps.size(); ++i) {
            if (!((WFWorkstep)this.hasWorksteps.elementAt(i)).isRollbackPoint()) continue;
            wsNames.addElement(((WFWorkstep)this.hasWorksteps.elementAt(i)).getName());
        }
        return wsNames;
    }

    public Vector getWorkstepsAsc() {
        Vector wslist = new Vector();
        WFWorkstep ws = null;
        for (int itr = 0; itr < this.hasWorksteps.size(); ++itr) {
            ws = (WFWorkstep)this.hasWorksteps.elementAt(itr);
            this.putWSInPlace(wslist, ws);
        }
        return wslist;
    }

    private void putWSInPlace(Vector wslist, WFWorkstep ws) {
        WFWorkstep listws = null;
        for (int itr = 0; itr < wslist.size(); ++itr) {
            listws = (WFWorkstep)wslist.elementAt(itr);
            if (listws.getName().compareTo(ws.getName()) <= 0) continue;
            wslist.add(itr, ws);
            return;
        }
        wslist.add(ws);
    }

    String getReactivateWorkStepName(String wsName) {
        WFWorkstep ws = this.getWorkstep(wsName);
        return ws.getReactivateWorkStepName();
    }

    public synchronized void setReactivateWorkStepName(String failureWSname, String reactivateWSname) {
        WFWorkstep failureWS = this.getWorkstep(failureWSname);
        failureWS.setReactivateWorkStepName(reactivateWSname);
    }

    public synchronized void removeReactivateWorkStepName(String wsName) {
        WFWorkstep ws = this.getWorkstep(wsName);
        ws.setReactivateWorkStepName(null);
    }

    String getCompFunction(String wsName) {
        WFWorkstep ws = this.getWorkstep(wsName);
        return ws.getCompFunction();
    }

    int getCompFunctionType(String wsName) {
        WFWorkstep ws = this.getWorkstep(wsName);
        return ws.getCompFunctionType();
    }

    public synchronized void setCompFunction(String wsName, String compJScript, int compScriptType) {
        WFWorkstep ws = this.getWorkstep(wsName);
        try {
            ws.setCompFunction(compJScript, compScriptType);
        }
        catch (Exception e) {
            throw new BizLogicException("BizLogic_ERR_2557", "WFProcess.setCompFunction", (Throwable)e);
        }
    }

    public void setSaveDataslots(String wsName, Vector dsNames) {
        WFWorkstep ws = this.getWorkstep(wsName);
        for (int ix = 0; ix < dsNames.size(); ++ix) {
            String dsName = (String)dsNames.elementAt(ix);
            this.getDataslot(dsName);
        }
        ws.setDSCopyNames(dsNames);
    }

    public ArrayList getInstanceObjectDataSlots() {
        ArrayList<WFDataslot> dslist = new ArrayList<WFDataslot>();
        for (int ix = 0; ix < this.hasDataslots.size(); ++ix) {
            WFDataslot ds = (WFDataslot)this.hasDataslots.get(ix);
            if (ds.isGlobal()) continue;
            if (!ds.getType().equals("OBJECT")) continue;
            dslist.add(ds);
        }
        return dslist;
    }

    public Vector getPrivateInstanceXMLDSNames() {
        Vector<String> dsNames = new Vector<String>();
        for (int ix = this.hasDataslots.size() - 1; ix >= 0; --ix) {
            WFDataslot ds = (WFDataslot)this.hasDataslots.elementAt(ix);
            if (!ds.getType().equals("XML") || ds.isGlobal() || ds.isPublic()) continue;
            dsNames.addElement(ds.getName());
        }
        return dsNames;
    }

    public long getMaxWorkstepID() {
        long maxwsid = 0L;
        WFWorkstep ws = null;
        long wsid = 0L;
        for (int itr = 0; itr < this.hasWorksteps.size(); ++itr) {
            ws = (WFWorkstep)this.hasWorksteps.elementAt(itr);
            wsid = ws.getID();
            if (wsid <= maxwsid) continue;
            maxwsid = wsid;
        }
        return maxwsid;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public final long getStartTime() {
        return this.timeStarted;
    }

    public void setStartTime(long st) {
        this.timeStarted = st;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int pri) {
        this.priority = pri;
    }

    public void setPriority(String priority) {
        int pri;
        if (priority != null && (pri = SBMControl.util.getIntegerPriority(priority)) != -1) {
            this.setPriority(pri);
            return;
        }
        throw new BizLogicException("BizLogic_ERR_1647", "WFProcess.setPriority", new Object[]{SBMControl.util.strPriority});
    }

    public String getStartWorkStepName() {
        WFWorkstep ws = null;
        for (int ix = 0; ix < this.hasWorksteps.size(); ++ix) {
            ws = (WFWorkstep)this.hasWorksteps.elementAt(ix);
            if (ws.getType() != 100) continue;
            return ws.getName();
        }
        throw new BizLogicException("BizLogic_ERR_549", "", new Object[]{this.getName()});
    }

    public long getParentID() {
        return this.parentID;
    }

    public void setParentID(long id) {
        this.parentID = id;
    }

    public TimerActionList getOverDueAction() {
        return this.timerActions;
    }

    public TimerAction getOverDueAction(int escalateLevel) {
        if (this.timerActions != null) {
            return this.timerActions.get(escalateLevel);
        }
        return null;
    }

    public void setOverDueAction(TimerActionList actions) {
        this.timerActions = actions;
    }

    public int getMaxOverDueTimes() {
        if (this.timerActions != null) {
            return this.timerActions.getNumberOfEscalation();
        }
        return 0;
    }

    public boolean isCheckDue() {
        return this.getMaxOverDueTimes() > 0;
    }

    public boolean hasWorkStep(int wsType) {
        Vector wsList = this.getWorksteps();
        int size = wsList.size();
        for (int ix = 0; ix < size; ++ix) {
            WFWorkstep ws = (WFWorkstep)wsList.get(ix);
            if (ws.getType() != wsType) continue;
            return true;
        }
        return false;
    }

    public boolean hasMessageSubscriberWS() {
        return this.hasWorkStep(110);
    }

    public boolean hasSubProcessWS() {
        return this.hasWorkStep(108);
    }

    public Vector getDataslots(String dstype, boolean isPublic, boolean isGlobal) {
        Vector<WFDataslot> dataslots = new Vector<WFDataslot>();
        if (dstype != null && this.hasDataslots != null) {
            for (int ix = 0; ix < this.hasDataslots.size(); ++ix) {
                WFDataslot ds = (WFDataslot)this.hasDataslots.elementAt(ix);
                if (ds == null || !dstype.equals(ds.getType()) || ds.isPublic() != isPublic || ds.isGlobal() != isGlobal) continue;
                dataslots.add(ds);
            }
        }
        return dataslots;
    }

    public Vector getWorksteps(int wsType) {
        Vector<WFWorkstep> worksteps;
        if (this.workstepsOnType == null) {
            this.workstepsOnType = new HashMap();
        }
        if ((worksteps = (Vector<WFWorkstep>)this.workstepsOnType.get(wsType)) == null) {
            worksteps = new Vector<WFWorkstep>();
            for (int i = 0; i < this.hasWorksteps.size(); ++i) {
                WFWorkstep ws = (WFWorkstep)this.hasWorksteps.get(i);
                if (wsType != ws.getType()) continue;
                worksteps.addElement(ws);
            }
            this.workstepsOnType.put(wsType, worksteps);
        }
        return worksteps;
    }

    public boolean hasCollectionDS() {
        return this.hasCollectionDS;
    }

    public void setHasVoteWorksteps(boolean hasVoteWs) {
        this.hasVoteWorksteps = hasVoteWs;
    }

    public boolean hasVoteWorksteps() {
        return this.hasVoteWorksteps;
    }

    public void setReplaceInfo(WFProcessReplaceInfo replaceInfo) {
        this.replaceInfo = replaceInfo;
    }

    public WFProcessReplaceInfo getReplaceInfo() {
        return this.replaceInfo;
    }

    public HashMap getWorkstepNameList() {
        HashMap<String, Long> wsNameIDMap = new HashMap<String, Long>();
        for (int itr = 0; itr < this.hasWorksteps.size(); ++itr) {
            WFWorkstep ws = (WFWorkstep)this.hasWorksteps.elementAt(itr);
            wsNameIDMap.put(ws.getName(), ws.getID());
        }
        return wsNameIDMap;
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void setLastModifiedTime(long lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public boolean isInstantiateOnMessage(String messageName) {
        MessageSubscriptionList msgSubscriptionList = this.getInitialWorkstep().getMessageSubscriptionList();
        return msgSubscriptionList.isSubscribedToMessage(messageName);
    }

    public boolean isSubscribedToMessage(String messageName) {
        return !this.getWorkstepsSubscribedToMessage(messageName).isEmpty();
    }

    public List getWorkstepsSubscribedToMessage(String msgName) {
        ArrayList<WFWorkstep> wsForMessage = new ArrayList<WFWorkstep>();
        MessageSubscriptionList msgSubscriptionList = null;
        for (int itr = 0; itr < this.hasWorksteps.size(); ++itr) {
            WFWorkstep ws = (WFWorkstep)this.hasWorksteps.elementAt(itr);
            msgSubscriptionList = ws.getMessageSubscriptionList();
            if (!msgSubscriptionList.isSubscribedToMessage(msgName) || ws.isInitialWorkstep()) continue;
            wsForMessage.add(ws);
        }
        return wsForMessage;
    }

    public List getWorkstepsSubscribedToAnyMessage() {
        ArrayList<WFWorkstep> wsForMessage = new ArrayList<WFWorkstep>();
        MessageSubscriptionList msgSubscriptionList = null;
        for (int itr = 0; itr < this.hasWorksteps.size(); ++itr) {
            WFWorkstep ws = (WFWorkstep)this.hasWorksteps.elementAt(itr);
            msgSubscriptionList = ws.getMessageSubscriptionList();
            if (!msgSubscriptionList.isSubscribedToAnyMessage() || ws.isInitialWorkstep()) continue;
            wsForMessage.add(ws);
        }
        return wsForMessage;
    }

    private void checkDescriptionLength() {
        if (this.description != null) {
            int len = this.description.length();
            int maxlen = BLControl.util.getMaxPTDescriptionSize();
            if (len > maxlen) {
                String removedText = this.description.substring(maxlen, len);
                this.description = this.description.substring(0, maxlen);
                BLControl.logger.warnKey("BizLogic_ERR_206", new Object[]{this.getName(), maxlen, removedText});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDocLocation() {
        if (this.docLocation == null) {
            WFProcess wFProcess = this;
            synchronized (wFProcess) {
                if (this.docLocation == null) {
                    this.docLocation = SBMUtil.self().getSBMHome() + "/ebmsapps/" + this.getName() + "/docs/";
                }
            }
        }
        return this.docLocation;
    }

    public boolean hasCollaborationEnabledWS() {
        for (int ix = 0; ix < this.hasWorksteps.size(); ++ix) {
            WFWorkstep ws = (WFWorkstep)this.hasWorksteps.get(ix);
            if (!ws.isAtomic() || !((WFAtomicWS)ws).isCollaborationEnabled()) continue;
            return true;
        }
        return false;
    }

    public void populateData() {
        for (int itr = 0; itr < this.hasWorksteps.size(); ++itr) {
            WFWorkstep ws = (WFWorkstep)this.hasWorksteps.elementAt(itr);
            ws.fillDataslotMappingInfo();
        }
    }

    public void migration_setSuspendOnSeqVersion(boolean value) {
        this.suspendedBySeqVersion = value;
    }

    public void migration_setDescription(String description) {
        this.description = description;
    }

    public void migration_setTimeStarted(long time) {
        this.timeStarted = time;
    }

    public long getDynamicInstanceID() {
        return this.dynamicinstanceid;
    }

    public void addMilestone(String name, String description) {
        if (name == null || name.trim().isEmpty()) {
            throw new BizLogicException("Bizlogic_ERR_3705", "WFProcess.setMilestone(name, desc)", new Object[]{name, this.getName()});
        }
        if (name.length() > BLControl.util.getMilestoneNameSize()) {
            throw new BizLogicException("Bizlogic_ERR_3709", "WFProcess.setMilestone(name, desc)", new Object[]{this.getName(), name, BLControl.util.getMilestoneNameSize()});
        }
        if (description == null || description.trim().isEmpty()) {
            BLControl.logger.warnKey("Bizlogic_ERR_3704", "setMilestone(name, desc)", new Object[]{description, name});
            description = name;
        }
        if (description.length() > BLControl.util.getMilestoneDescriptionSize()) {
            throw new BizLogicException("Bizlogic_ERR_4803", "WFProcess.setMilestone(name, desc)", new Object[]{this.getName(), name, BLControl.util.getMilestoneDescriptionSize()});
        }
        this.milestones.put(name, description);
    }

    public Map getMilestoneList() {
        return this.milestones;
    }

    public String getMilestoneDescription(String milestoneName) {
        if (milestoneName == null || milestoneName.trim().isEmpty() || !this.milestones.containsKey(milestoneName)) {
            throw new BizLogicException("Bizlogic_ERR_3705", "WFProcess.getMilestoneDescription(name)", new Object[]{milestoneName, this.getName()});
        }
        return (String)this.milestones.get(milestoneName);
    }

    boolean hasMilestone(String milestoneName) {
        if (milestoneName == null || milestoneName.trim().isEmpty()) {
            return false;
        }
        return this.milestones.containsKey(milestoneName);
    }

    public List getWorkstepIDList(String milestoneName) {
        if (milestoneName == null || milestoneName.trim().isEmpty()) {
            return new ArrayList(this.getWSIDMilestoneNameMap().keySet());
        }
        return (ArrayList)this.getMilestoneNameWSIDListMap().get(milestoneName);
    }

    public String getMilestoneName(long wsid) {
        return (String)this.getWSIDMilestoneNameMap().get(wsid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map getWSIDMilestoneNameMap() {
        if (this.wsidMilestoneName != null) {
            return this.wsidMilestoneName;
        }
        WFProcess wFProcess = this;
        synchronized (wFProcess) {
            if (this.wsidMilestoneName != null) {
                return this.wsidMilestoneName;
            }
            this.wsidMilestoneName = new HashMap();
            for (int ix = 0; ix < this.hasWorksteps.size(); ++ix) {
                WFWorkstep wsObject = (WFWorkstep)this.hasWorksteps.elementAt(ix);
                if (!wsObject.isMilestone()) continue;
                this.wsidMilestoneName.put(wsObject.getID(), wsObject.getMilestoneName());
            }
        }
        return this.wsidMilestoneName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map getMilestoneNameWSIDListMap() {
        if (this.milestoneNameWSIDList != null) {
            return this.milestoneNameWSIDList;
        }
        WFProcess wFProcess = this;
        synchronized (wFProcess) {
            if (this.milestoneNameWSIDList != null) {
                return this.milestoneNameWSIDList;
            }
            this.milestoneNameWSIDList = new HashMap();
            ArrayList list = null;
            for (int ix = 0; ix < this.hasWorksteps.size(); ++ix) {
                WFWorkstep wsObject = (WFWorkstep)this.hasWorksteps.elementAt(ix);
                if (!wsObject.isMilestone()) continue;
                String milestoneName = wsObject.getMilestoneName();
                long wsid = wsObject.getID();
                list = this.milestoneNameWSIDList.containsKey(milestoneName) ? (ArrayList)this.milestoneNameWSIDList.get(milestoneName) : new ArrayList();
                list.add(wsid);
                this.milestoneNameWSIDList.put(milestoneName, list);
            }
        }
        return this.milestoneNameWSIDList;
    }

    public final void setSqlMapDataSlots(boolean flag) {
        this.hasSqlMapDataSlots = flag;
    }

    public final boolean hasSqlMapDatsSlots() {
        return this.hasSqlMapDataSlots;
    }

    private void validateMaxLength(String name, String type) {
        int maxLength = BLControl.util.getMaxTableNameLength();
        if (name != null && name.trim().length() > maxLength) {
            throw new BizLogicException("Bizlogic_ERR_3719", "WFProcess.validateMaxLength(name, type)", new Object[]{name, type, maxLength});
        }
    }

    public ArrayList<WFWorkstep> getWorkStepsWithAlerts() {
        ArrayList<WFWorkstep> wsList = new ArrayList<WFWorkstep>();
        for (Object ws : this.hasWorksteps) {
            WFWorkstep theWorkstep = (WFWorkstep)ws;
            if (!theWorkstep.hasAlerts()) continue;
            wsList.add(theWorkstep);
        }
        return wsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasWorkstepAlerts() {
        if (this.hasWorkstepAlerts == null) {
            WFProcess wFProcess = this;
            synchronized (wFProcess) {
                if (this.hasWorkstepAlerts == null) {
                    this.hasWorkstepAlerts = Boolean.FALSE;
                    for (Object ws : this.hasWorksteps) {
                        WFWorkstep theWorkstep = (WFWorkstep)ws;
                        if (!theWorkstep.hasAlerts()) continue;
                        this.hasWorkstepAlerts = Boolean.TRUE;
                        break;
                    }
                }
            }
        }
        return this.hasWorkstepAlerts;
    }

    public static final HashMap convertStringToObjectValue(WFProcess ptObj, HashMap dsWithStringValues) {
        if (dsWithStringValues == null || dsWithStringValues.isEmpty()) {
            return dsWithStringValues;
        }
        HashMap<String, Object> dsWithObjectValues = new HashMap<String, Object>(dsWithStringValues);
        String dsName2 = null;
        String stringDSValue = null;
        Object objDSValue = null;
        WFDataslot ds = null;
        for (String dsName2 : dsWithStringValues.keySet()) {
            Object value = dsWithStringValues.get(dsName2);
            if (!(value instanceof String)) continue;
            stringDSValue = (String)value;
            ds = ptObj.getDataslot(dsName2);
            objDSValue = ds.convertToObjectValue(stringDSValue);
            dsWithObjectValues.put(dsName2, objDSValue);
        }
        return dsWithObjectValues;
    }

    public boolean hasProcessAlerts() {
        return this.hasProcessAlerts;
    }

    public void setProcessAlerts(boolean hasProcessAlerts) {
        this.hasProcessAlerts = hasProcessAlerts;
    }

    public List<DataSlotTableIndex> getDataSlotIndexData() {
        return this.dsTableIndexData;
    }

    void setDataSlotIndexData(List<DataSlotTableIndex> dsTableIndexData) {
        this.dsTableIndexData = dsTableIndexData;
    }

    public boolean hasPerfomByAnyHumanWS() {
        if (this.hasPerfomByAnyHumanWS != null) {
            return this.hasPerfomByAnyHumanWS;
        }
        this.hasPerfomByAnyHumanWS = false;
        for (Object ws : this.hasWorksteps) {
            WFAtomicWS atomicWS;
            if (!(ws instanceof WFAtomicWS) || (atomicWS = (WFAtomicWS)ws).getPerformedByAll()) continue;
            this.hasPerfomByAnyHumanWS = true;
        }
        return this.hasPerfomByAnyHumanWS;
    }

    public boolean isAuditEnabled() {
        return this.isAuditEnabled;
    }

    void setAuditEnabled(boolean enable) {
        this.isAuditEnabled = enable;
    }

    Hashtable getWSFYI() {
        return this.WSfyi;
    }

    void setWSFYI(Hashtable wsFYI) {
        if (wsFYI != null) {
            this.WSfyi = wsFYI;
        }
    }

    public boolean hasMilestones() {
        return this.milestones != null && !this.milestones.isEmpty();
    }

    public List<String> excludeBlobDataslots(List<String> dsNames) {
        if (dsNames == null || dsNames.isEmpty()) {
            return dsNames;
        }
        ArrayList<String> validDsNames = new ArrayList<String>();
        for (String dsName : dsNames) {
            WFDataslot ds;
            if (dsName == null || dsName.trim().length() == 0 || (ds = this.getDataslot(dsName)).isBlob()) continue;
            validDsNames.add(dsName);
        }
        return validDsNames;
    }

    public List<String> getBlobDataslots(List<String> dsNames) {
        ArrayList<String> blobDsNames = new ArrayList<String>();
        if (dsNames == null || dsNames.isEmpty()) {
            return blobDsNames;
        }
        for (String dsName : dsNames) {
            WFDataslot ds;
            if (dsName == null || dsName.trim().length() == 0 || !(ds = this.getDataslot(dsName)).isBlob()) continue;
            blobDsNames.add(dsName);
        }
        return blobDsNames;
    }

    public void setProcessType(ProcessType processType) {
        this.processType = processType;
    }

    public ProcessType getProcessType() {
        if (this.processType == null) {
            this.processType = ProcessType.BUSINESS;
        }
        return this.processType;
    }

    public boolean isMonitoringProcess() {
        return ProcessType.MONITORING == this.getProcessType();
    }

    public boolean isBusinessProcess() {
        return ProcessType.BUSINESS == this.getProcessType();
    }

    public boolean isSystemProcess() {
        return ProcessType.SYSTEM == this.getProcessType();
    }

    protected void setMonitorDSName(String monitorDSName) {
        this.monitorDSName = monitorDSName;
    }

    public String getMonitorDSName() {
        return this.monitorDSName;
    }

    public boolean isMonitorDS(String dsName) {
        return dsName != null && dsName.trim().length() != 0 && dsName.equalsIgnoreCase(this.getMonitorDSName());
    }

    public boolean isMonitorDSMappedToPIID() {
        return this.isMonitorDSMappedPIID;
    }

    void setSuspendedBySeqVersion(boolean param) {
        if (!this.isSuspended() && param) {
            throw new BizLogicException("Bizlogic_ERR_8803", "WFProcess.setSuspendedBySeqVersion(param)", new Object[]{this.appName});
        }
        this.suspendedBySeqVersion = param;
    }
}

