/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.savvion.sbm.bizlogic.server.WFDelayWS;
import com.savvion.sbm.bizlogic.server.WFProcessContext;
import com.savvion.sbm.bizlogic.server.WFWorkstepInstance;
import com.savvion.sbm.bizlogic.server.dao.TimerActionDAO;
import com.savvion.sbm.bizlogic.util.BLUtil;

public class WFDelayInstance
extends WFWorkstepInstance {
    private static WFDelayInstance self;

    public static synchronized WFDelayInstance self() {
        if (self == null) {
            self = new WFDelayInstance();
        }
        return self;
    }

    @Override
    public void execute(WFProcessContext pCtx, long wsid) {
        long executeTime = System.currentTimeMillis() + this.getDelayTime(pCtx, wsid);
        TimerActionDAO.create(pCtx.getProcessInstanceID(), wsid, pCtx.getProcessTemplateID(), executeTime, "COMPLETE_WORKSTEP_INSTANCE", null, null, "BIZLOGIC");
    }

    private long getDelayTime(WFProcessContext pCtx, long wsid) {
        WFDelayWS ws = (WFDelayWS)pCtx.getWorkstep(wsid);
        String delayTime = ws.getDelayTime();
        if (BLUtil.isMappedDataSlot((String)delayTime)) {
            delayTime = delayTime.substring("@".length());
            return (Long)pCtx.getSlotValue(wsid, delayTime);
        }
        return Long.parseLong(delayTime);
    }

    @Override
    public void complete(WFProcessContext pCtx, long wsid) {
        this.validateCompletion(pCtx, wsid);
        super.complete(pCtx, wsid);
        long wsstate = pCtx.getWorkstepInstanceEB(wsid).getState();
        if (wsstate != 21L) {
            return;
        }
        BLUtil.fireEvent(this.getEventContext(pCtx, wsid, 21), (int)21);
        super.afterComplete(pCtx, wsid);
        if (!this.isSuspendedByCompensatory(pCtx, wsid)) {
            this.activateNextWorksteps(pCtx, wsid);
        }
    }
}

