/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.scheduler;

import com.savvion.sbm.util.ResourceUtil;
import com.savvion.sbm.util.SBMDatabase;
import java.util.Properties;

public class SchedulerUtil {
    private static SchedulerUtil self;
    private Properties props = null;
    public static final String SCHED_PROPERTIES = "blscheduler.properties";
    public static final String QUARTZ_JOBSTORE_DATASOURCE = "org.quartz.jobStore.dataSource";
    public static final String QUARTZ_DATASOURCE = "org.quartz.dataSource.";
    public static final String DOT_DRIVER = ".driver";
    public static final String DOT_URL = ".URL";
    public static final String DOT_USER = ".user";
    public static final String DOT_PASSWD = ".password";

    private SchedulerUtil() {
        this.init();
    }

    private void init() {
        try {
            this.props = ResourceUtil.getPropertyObject((String)SCHED_PROPERTIES);
            String storeDSName = this.props.getProperty(QUARTZ_JOBSTORE_DATASOURCE);
            this.props.setProperty(QUARTZ_DATASOURCE + storeDSName + DOT_DRIVER, SBMDatabase.self().getDriver());
            this.props.setProperty(QUARTZ_DATASOURCE + storeDSName + DOT_URL, SBMDatabase.self().getURL());
            this.props.setProperty(QUARTZ_DATASOURCE + storeDSName + DOT_USER, SBMDatabase.self().getUser());
            this.props.setProperty(QUARTZ_DATASOURCE + storeDSName + DOT_PASSWD, SBMDatabase.self().getPassword());
        }
        catch (Throwable th) {
            throw new RuntimeException("Error occurred loading the <blscheduler.properties> file", th);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SchedulerUtil self() {
        if (self != null) return self;
        Class<SchedulerUtil> clazz = SchedulerUtil.class;
        synchronized (SchedulerUtil.class) {
            if (self != null) return self;
            self = new SchedulerUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return self;
        }
    }

    public Properties getSchedulerProps() {
        return this.props;
    }

    public String getProperty(String propName) {
        if (propName == null || propName.trim().length() == 0) {
            throw new RuntimeException("Property name passed cannot be null or empty.");
        }
        return this.props.getProperty(propName);
    }
}

