/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.client.messagehandler.util;

import com.savvion.sbm.alerts.svo.RuntimeAlert;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.util.SBMDAOService;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;

public class HandlerUtil {
    public static String validsteMessageName(Message message, String validMsgName) throws JMSException {
        String name = message.getStringProperty("messageName");
        if (name == null || name.trim().length() == 0 || !name.equalsIgnoreCase(validMsgName)) {
            throw new BizLogicException("BizLogic_ERR_3771", "HandlerUtil.validsteMessageName", new Object[]{name, validMsgName});
        }
        return name;
    }

    public static HashMap<String, Object> constructMapFromMsg(MapMessage mapMsg, Map<String, Class<?>> expectedKeyTypes) throws JMSException {
        if (mapMsg == null) {
            throw new BizLogicException("BizLogic_ERR_4687", "HandlerUtil.constructMapFromMsg()", new Object[]{"Map message object"});
        }
        if (expectedKeyTypes == null) {
            throw new BizLogicException("BizLogic_ERR_4687", "HandlerUtil.constructMapFromMsg()", new Object[]{"key-name and key-type map"});
        }
        HashMap<String, Object> messageObject = new HashMap<String, Object>();
        Set<Map.Entry<String, Class<?>>> entries = expectedKeyTypes.entrySet();
        for (Map.Entry<String, Class<?>> keyType : entries) {
            String key = keyType.getKey();
            Class<?> type = keyType.getValue();
            Object obj = mapMsg.getObject(key);
            if (obj == null) {
                throw new BizLogicException("BizLogic_ERR_4680", "HandlerUtil.constructMapFromMsg()", new Object[]{key, type});
            }
            if (obj.getClass().isInstance(type)) {
                throw new BizLogicException("BizLogic_ERR_4681", "HandlerUtil.constructMapFromMsg()", new Object[]{key, obj.getClass(), type});
            }
            messageObject.put(key, obj);
        }
        return messageObject;
    }

    public static String getValidStringValue(Map<String, Object> data, String key, String ctx) {
        String value = null;
        value = (String)data.get(key);
        if (value == null || value.trim().length() == 0) {
            throw new BizLogicException("BizLogic_ERR_4687", ctx, new Object[]{key});
        }
        return value;
    }

    public static void vaildatePropVal(String val, String property, String ctx) {
        if (val == null || val.trim().length() == 0) {
            throw new BizLogicException("BizLogic_ERR_4687", ctx, new Object[]{property});
        }
    }

    public static <T> T convertToType(Class<T> type, byte[] bytes) {
        Object obj;
        if (type == null) {
            throw new BizLogicException("The Type object passed cannot be null. Context(HandlerUtil.convertToType)");
        }
        Object typedObject = null;
        if (bytes != null && bytes.length != 0 && (obj = SBMDAOService.convertToObject((byte[])bytes)) != null) {
            if (!type.isAssignableFrom(obj.getClass())) {
                throw new BizLogicException("BizLogic_ERR_4679", "HandlerUtil.convertToType", new Object[]{obj, obj.getClass().getName(), type.getClass()});
            }
            typedObject = obj;
        }
        return (T)typedObject;
    }

    public static RuntimeAlert createRuntimeAlert(String alertName, String templateName, String message, String severity) {
        RuntimeAlert rAlert = null;
        rAlert = new RuntimeAlert();
        rAlert.setName(alertName);
        rAlert.setMessage(message);
        rAlert.setTemplateName(templateName);
        rAlert.setSeverity(severity);
        rAlert.setSource("EXT");
        rAlert.setStatus("ACTIVE");
        return rAlert;
    }

    public static Map<String, Object> getJMSMessageProperties(Message message) {
        if (message == null) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> messageMap = null;
        try {
            messageMap = new HashMap<String, Object>();
            Enumeration mapNamesEnum = message.getPropertyNames();
            while (mapNamesEnum.hasMoreElements()) {
                String mapName = (String)mapNamesEnum.nextElement();
                messageMap.put(mapName, message.getObjectProperty(mapName));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return messageMap;
    }

    public static Map<String, Object> getJMSMapMessageBody(MapMessage message) {
        if (message == null) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> messageMap = null;
        try {
            messageMap = new HashMap<String, Object>();
            Enumeration mapNamesEnum = message.getMapNames();
            while (mapNamesEnum.hasMoreElements()) {
                String mapName = (String)mapNamesEnum.nextElement();
                messageMap.put(mapName, message.getObject(mapName));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return messageMap;
    }
}

