/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.client;

import com.savvion.common.distcache.core.AbstractCache;
import com.savvion.common.distcache.core.AbstractCacheListener;
import com.savvion.sbm.bizlogic.client.queryservice.QSClientUtil;
import com.savvion.sbm.bizlogic.enums.PTAttribute;
import com.savvion.sbm.bizlogic.enums.PTState;
import com.savvion.sbm.distcache.cacheconfig.ConfigGeneratorConstant;
import com.savvion.sbm.distcache.config.CacheConfigService;
import com.savvion.sbm.distcache.core.AppCacheService;
import com.savvion.sbm.distcache.listener.ProcessKeyCacheListener;
import com.savvion.sbm.distcache.listener.ProcessMetaDataCacheListener;
import com.savvion.sbm.distcache.model.ProcessMetaData;
import com.savvion.sbm.distcache.util.AppCacheConstant;
import com.savvion.sbm.distcache.util.AppCacheException;
import com.savvion.sbm.distcache.util.AppCacheUtil;
import com.savvion.sbm.processgraph.core.ProcessGraphService;
import com.savvion.sbm.processgraph.model.WorkflowProcess;
import com.savvion.sbm.util.ExceptionService;
import com.savvion.sbm.util.logger.SBMLogger;
import com.tdiinc.BizLogic.Server.PAKClientWorkitem;
import java.util.HashMap;
import java.util.Map;

public class ProcessCacheService {
    private AppCacheService appCacheSvc;
    private SBMLogger logger;
    private final ExceptionService<AppCacheException> excpService;
    private boolean isProcessCacheCategoryEnabled = false;
    private boolean isTemplateIdNameCacheEnabled = true;
    private boolean isDebugEnabled = false;
    private String processMetaDataCache = null;
    private String templateIdNameCache = null;
    private static ProcessCacheService self = null;
    protected static final long INVALID_PTID = -1L;

    protected ProcessCacheService(AppCacheService appCacheService, SBMLogger sbmLogger) {
        this(sbmLogger);
        if (appCacheService == null) {
            throw (AppCacheException)this.getExcpService().createException("BM_DCAC006", "ProcessCacheService(appCacheService, logger)");
        }
        this.appCacheSvc = appCacheService;
        this.processMetaDataCache = AppCacheUtil.self().getOrgCacheName("DEFAULT", AppCacheConstant.CacheName.PC_PROCESSMETADATACACHE.name());
        this.templateIdNameCache = AppCacheUtil.self().getOrgCacheName("DEFAULT", AppCacheConstant.CacheName.PC_PTID_PTNAME_CACHE.name());
        this.addCacheListener();
    }

    protected ProcessCacheService(SBMLogger sbmLogger) {
        this.logger = sbmLogger != null ? sbmLogger.cloneInstance("sbmdistcachemessages", ProcessCacheService.class.getClassLoader()) : AppCacheUtil.self().getDefaultLogger();
        this.excpService = new ExceptionService(AppCacheException.class, "sbmdistcachemessages", this.logger);
        this.isProcessCacheCategoryEnabled = CacheConfigService.self().isCategoryEnabled(ConfigGeneratorConstant.CacheClusterType.EJBWEB, AppCacheConstant.CacheCategory.PROCESSCACHE.name());
        this.isTemplateIdNameCacheEnabled = CacheConfigService.self().isSubCacheEnabled(ConfigGeneratorConstant.CacheClusterType.EJBWEB, AppCacheConstant.CacheCategory.PROCESSCACHE.name(), AppCacheConstant.CacheName.PC_PTID_PTNAME_CACHE.name());
        this.isDebugEnabled = CacheConfigService.self().isCategoryDebugEnabled(ConfigGeneratorConstant.CacheClusterType.EJBWEB, AppCacheConstant.CacheCategory.PROCESSCACHE.name());
    }

    public static synchronized void createInstance(AppCacheService appCacheService, SBMLogger sbmLogger) {
        if (self == null) {
            self = new ProcessCacheService(appCacheService, sbmLogger);
        }
    }

    public static synchronized void createInstance(SBMLogger sbmLogger) {
        if (self == null) {
            self = new ProcessCacheService(sbmLogger);
        }
    }

    public static ProcessCacheService self() {
        if (self != null) {
            return self;
        }
        boolean isProcessCacheEnabled = CacheConfigService.self().isCategoryEnabled(ConfigGeneratorConstant.CacheClusterType.EJBWEB, AppCacheConstant.CacheCategory.PROCESSCACHE.name());
        if (isProcessCacheEnabled) {
            throw (AppCacheException)AppCacheUtil.self().getExService().createException("BM_DCAC052", "ProcessCacheService.self()", new Object[]{"ProcessCacheService.createInstance(AppCacheService, SBMLogger)"});
        }
        throw (AppCacheException)AppCacheUtil.self().getExService().createException("BM_DCAC052", "ProcessCacheService.self()", new Object[]{"ProcessCacheService.createInstance(SBMLogger)"});
    }

    public String getProcessTemplateName(long ptId) {
        if (!this.isProcessCacheCategoryEnabled() || !this.isTemplateIdNameCacheEnabled()) {
            if (this.isDebugEnabled()) {
                this.getLogger().debugKey("BM_DCAC288", "ProcessCacheService.getProcessTemplateName(ptId)", new Object[0]);
            }
            return QSClientUtil.getProcessTemplateName((long)ptId);
        }
        return this.getDataFromTemplateIdNameCache(ptId);
    }

    public long getProcessTemplateId(String ptName) {
        if (!this.isProcessCacheCategoryEnabled()) {
            return -1L;
        }
        this.validateTemplateName(ptName);
        ptName = ptName.trim();
        ProcessMetaData processMetaData = this.getDataFromProcessMetaDataCache(ptName);
        if (processMetaData == null) {
            return -1L;
        }
        return processMetaData.getProcessTemplateId();
    }

    public WorkflowProcess getWorkflowProcess(String ptName) {
        if (!this.isProcessCacheCategoryEnabled()) {
            return null;
        }
        this.validateTemplateName(ptName);
        ptName = ptName.trim();
        ProcessMetaData processMetaData = this.getDataFromProcessMetaDataCache(ptName);
        if (processMetaData == null) {
            return null;
        }
        return (WorkflowProcess)processMetaData.getWorkflowProcess();
    }

    public PTState getProcessStatus(String ptName) {
        if (!this.isProcessCacheCategoryEnabled()) {
            return null;
        }
        this.validateTemplateName(ptName);
        ptName = ptName.trim();
        ProcessMetaData processMetaData = this.getDataFromProcessMetaDataCache(ptName);
        if (processMetaData == null) {
            return null;
        }
        return processMetaData.getProcessStatus();
    }

    public Map<String, Long> getWorkStepNameId(String ptName) {
        if (!this.isProcessCacheCategoryEnabled()) {
            return new HashMap<String, Long>();
        }
        this.validateTemplateName(ptName);
        ptName = ptName.trim();
        ProcessMetaData processMetaData = this.getDataFromProcessMetaDataCache(ptName);
        if (processMetaData == null) {
            return null;
        }
        return processMetaData.getWorkStepNameId();
    }

    public PAKClientWorkitem getPAKClientWIForStartWS(String ptName) {
        if (!this.isProcessCacheCategoryEnabled()) {
            return null;
        }
        this.validateTemplateName(ptName);
        ptName = ptName.trim();
        ProcessMetaData processMetaData = this.getDataFromProcessMetaDataCache(ptName);
        PAKClientWorkitem pakCWI = null;
        if (processMetaData != null) {
            pakCWI = (PAKClientWorkitem)processMetaData.getPAKClientWIForStartWS();
        }
        if (this.isDebugEnabled()) {
            this.getLogger().debugKey("BM_DCAC275", "ProcessCacheService.getPAKClientWIForStartWS(String)", new Object[]{pakCWI, "ptName", ptName, this.processMetaDataCache});
        }
        return pakCWI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPAKClientWIForStartWS(String ptName, PAKClientWorkitem pakClientWorkitem) {
        if (!this.isProcessCacheCategoryEnabled()) {
            return;
        }
        this.validateTemplateName(ptName);
        ptName = ptName.trim();
        if (this.getPAKClientWIForStartWS(ptName) != null) {
            return;
        }
        Class<ProcessCacheService> clazz = ProcessCacheService.class;
        synchronized (ProcessCacheService.class) {
            ProcessMetaData processMetaData;
            if (this.getPAKClientWIForStartWS(ptName) == null && (processMetaData = this.getDataFromProcessMetaDataCache(ptName)) != null) {
                if (this.isDebugEnabled()) {
                    this.getLogger().debugKey("BM_DCAC276", "ProcessCacheService.setPAKClientWIForStartWS(String,PAKClientWorkitem)", new Object[]{pakClientWorkitem, "ptName", ptName, this.processMetaDataCache});
                }
                processMetaData.setPAKClientWIForStartWS((Object)pakClientWorkitem);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void addToProcessCache(ProcessMetaData ptMetaData) {
        if (!this.isProcessCacheCategoryEnabled()) {
            return;
        }
        if (ptMetaData == null) {
            throw (AppCacheException)this.getExcpService().createException("BM_DCAC038", "ProcessCacheService.addToProcessCache(ptMetaData)", new Object[]{"ptMetaData"});
        }
        if (PTState.CREATED != ptMetaData.getProcessStatus()) {
            this.addProcessMetaData(ptMetaData.getProcessTemplateName(), ptMetaData);
            this.addTemplateIdName(ptMetaData.getProcessTemplateId(), ptMetaData.getProcessTemplateName());
        }
    }

    public void addProcessMetaData(String ptName, ProcessMetaData processMetaData) {
        if (!this.isProcessCacheCategoryEnabled()) {
            return;
        }
        this.validateTemplateName(ptName);
        ptName = ptName.trim();
        if (PTState.CREATED != processMetaData.getProcessStatus()) {
            if (this.isDebugEnabled()) {
                this.getLogger().debugKey("BM_DCAC278", "ProcessCacheService.addProcessMetaData(String,ProcessMetaData,boolean,boolean)", new Object[]{this.processMetaDataCache, ptName, ProcessCacheService.getProcessMetaDataInfo(processMetaData)});
            }
            this.getProcessMetaDataCache().put((Object)ptName, (Object)processMetaData);
        }
    }

    public void addTemplateIdName(long ptId, String ptName) {
        if (!this.isProcessCacheCategoryEnabled()) {
            return;
        }
        if (!this.isValidTemplateId(ptId)) {
            return;
        }
        if (!this.isValidStr(ptName)) {
            return;
        }
        ProcessMetaData processMetaData = this.loadProcessMetaData(ptName = ptName.trim());
        if (PTState.CREATED != processMetaData.getProcessStatus()) {
            if (this.isDebugEnabled()) {
                this.getLogger().debugKey("BM_DCAC279", "ProcessCacheService.addPtIdPtName(long,String,boolean,boolean)", new Object[]{this.templateIdNameCache, ptId, ptName});
            }
            this.getTemplateIdNameCache().put((Object)ptId, (Object)ptName);
        }
    }

    public void remove(long ptId, String ptName) {
        if (!this.isProcessCacheCategoryEnabled()) {
            return;
        }
        if (this.isValidStr(ptName)) {
            if (this.isDebugEnabled()) {
                this.getLogger().debugKey("BM_DCAC280", "ProcessCacheService.remove(String,long)", new Object[]{this.processMetaDataCache, "ptName", ptName});
            }
            this.getProcessMetaDataCache().remove((Object)ptName);
        }
        if (this.isTemplateIdNameCacheEnabled()) {
            if (this.isDebugEnabled()) {
                this.getLogger().debugKey("BM_DCAC280", "ProcessCacheService.remove(String,long)", new Object[]{this.templateIdNameCache, "ptid", ptId});
            }
            this.getTemplateIdNameCache().remove((Object)ptId);
        }
    }

    public boolean isProcessMetaDataExist(String ptName) {
        this.validateTemplateName(ptName);
        return this.getProcessMetaData(ptName) != null;
    }

    public Map<Long, String> getAllProcessTemplates() {
        if (!this.isProcessCacheCategoryEnabled() || !this.isTemplateIdNameCacheEnabled()) {
            if (this.isDebugEnabled()) {
                this.getLogger().debugKey("BM_DCAC288", "ProcessCacheService.getAllProcessTemplates()", new Object[0]);
            }
            return QSClientUtil.getAllProcessTemplates();
        }
        if (this.isDebugEnabled()) {
            this.getLogger().debugKey("BM_DCAC284", "ProcessCacheService.getAllProcessTemplates()", new Object[]{this.templateIdNameCache, ConfigGeneratorConstant.CacheClusterType.EJBWEB.name()});
        }
        HashMap<Long, String> ptIdNames = new HashMap<Long, String>();
        Map idNameData = this.getTemplateIdNameCache().getValues();
        if (idNameData != null && !idNameData.isEmpty()) {
            for (Map.Entry cacheEntry : idNameData.entrySet()) {
                Object currentKey = cacheEntry.getKey();
                Long currentKeyLong = null;
                if (currentKey instanceof String) {
                    String currentKeyString = (String)currentKey;
                    currentKeyLong = Long.parseLong(currentKeyString);
                } else {
                    currentKeyLong = (Long)currentKey;
                }
                ptIdNames.put(currentKeyLong, (String)cacheEntry.getValue());
            }
        }
        return ptIdNames;
    }

    public ProcessMetaData getProcessMetaData(String ptName) {
        if (!this.isProcessCacheCategoryEnabled()) {
            return null;
        }
        this.validateTemplateName(ptName);
        ptName = ptName.trim();
        return this.getDataFromProcessMetaDataCache(ptName);
    }

    protected synchronized WorkflowProcess loadWorkflowProcess(String ptName) {
        if (!this.isValidStr(ptName)) {
            throw (AppCacheException)this.getExcpService().createException("BM_DCAC034", "ProcessCacheService.loadWorkflowProcess(String)", new Object[]{"ptName", ptName});
        }
        ptName = ptName.trim();
        long ptId = this.getProcessTemplateId(ptName);
        String processXML = QSClientUtil.getProcessXML((long)ptId);
        WorkflowProcess workflowProcess = null;
        try {
            workflowProcess = ProcessGraphService.get((String)processXML, (String)ptName, null);
        }
        catch (Throwable th) {
            throw (AppCacheException)this.getExcpService().createException("BM_DCAC054", "ProcessCacheService.loadWorkflowProcess(String)", new Object[]{ptName, processXML}, th);
        }
        return workflowProcess;
    }

    protected synchronized WorkflowProcess loadWorkflowProcess(long ptId) {
        this.validateTemplateId(ptId);
        String ptName = this.getProcessTemplateName(ptId);
        String processXML = QSClientUtil.getProcessXML((long)ptId);
        WorkflowProcess workflowProcess = null;
        try {
            workflowProcess = ProcessGraphService.get((String)processXML, (String)ptName, null);
        }
        catch (Throwable th) {
            throw (AppCacheException)this.getExcpService().createException("BM_DCAC054", "ProcessCacheService.loadWorkflowProcess(long)", new Object[]{ptName, processXML}, th);
        }
        return workflowProcess;
    }

    protected synchronized ProcessMetaData loadProcessMetaData(String ptName) {
        this.validateTemplateName(ptName);
        ptName = ptName.trim();
        Map ptInfo = QSClientUtil.getTemplateMetaData((String)ptName);
        ProcessMetaData ptMetaData = this.prepareProcessMetaData(ptInfo);
        return ptMetaData;
    }

    protected synchronized ProcessMetaData loadProcessMetaData(long ptId) {
        this.validateTemplateId(ptId);
        Map ptInfo = QSClientUtil.getTemplateMetaData((long)ptId);
        ProcessMetaData ptMetaData = this.prepareProcessMetaData(ptInfo);
        return ptMetaData;
    }

    protected ProcessMetaData prepareProcessMetaData(Map<PTAttribute, Object> ptInfo) {
        if (ptInfo == null || ptInfo.isEmpty()) {
            throw (AppCacheException)this.getExcpService().createException("BM_DCAC034", "ProcessCacheService.prepareProcessMetaData(Map)", new Object[]{"ptInfo"});
        }
        long ptId = (Long)ptInfo.get(PTAttribute.ID);
        String ptName = (String)ptInfo.get(PTAttribute.NAME);
        PTState ptStatus = (PTState)ptInfo.get(PTAttribute.STATUS);
        ProcessMetaData processMetaData = new ProcessMetaData(ptId, ptName, ptStatus);
        return processMetaData;
    }

    private ProcessMetaData getDataFromProcessMetaDataCache(String ptName) {
        if (!this.isProcessCacheCategoryEnabled()) {
            return null;
        }
        ProcessMetaData prMetaData = null;
        if (this.isDebugEnabled()) {
            this.getLogger().debugKey("BM_DCAC281", "ProcessCacheService.getDataFromProcessMetaDataCache(String)", new Object[]{this.processMetaDataCache, "ptName", ptName});
        }
        prMetaData = (ProcessMetaData)this.getProcessMetaDataCache().getValue((Object)ptName);
        if (this.isDebugEnabled()) {
            this.getLogger().debugKey("BM_DCAC282", "ProcessCacheService.getDataFromProcessMetaDataCache(String)", new Object[]{this.processMetaDataCache, ptName, ProcessCacheService.getProcessMetaDataInfo(prMetaData)});
        }
        return prMetaData;
    }

    private String getDataFromTemplateIdNameCache(long ptId) {
        if (!this.isProcessCacheCategoryEnabled() || !this.isTemplateIdNameCacheEnabled()) {
            if (this.isDebugEnabled()) {
                this.getLogger().debugKey("BM_DCAC288", "ProcessCacheService.getDataFromTemplateIdNameCache(ptId)", new Object[0]);
            }
            return QSClientUtil.getProcessTemplateName((long)ptId);
        }
        String ptName = null;
        if (this.isDebugEnabled()) {
            this.getLogger().debugKey("BM_DCAC281", "ProcessCacheService.getDataFromTemplateIdNameCache(long)", new Object[]{this.templateIdNameCache, "ptId", ptId});
        }
        ptName = (String)this.getTemplateIdNameCache().getValue((Object)ptId);
        if (this.isDebugEnabled()) {
            this.getLogger().debugKey("BM_DCAC283", "ProcessCacheService.getDataFromTemplateIdNameCache(long)", new Object[]{this.templateIdNameCache, ptId, ptName});
        }
        return ptName;
    }

    private AbstractCache<String, ProcessMetaData> getProcessMetaDataCache() {
        if (this.isDebugEnabled()) {
            this.getLogger().debugKey("BM_DCAC284", "ProcessCacheService.getProcessMetaDataCache()", new Object[]{this.processMetaDataCache, ConfigGeneratorConstant.CacheClusterType.EJBWEB.name()});
        }
        return this.appCacheSvc.getCacheCluster(ConfigGeneratorConstant.CacheClusterType.EJBWEB).getCache(this.processMetaDataCache);
    }

    private AbstractCache<Long, String> getTemplateIdNameCache() {
        if (this.isDebugEnabled()) {
            this.getLogger().debugKey("BM_DCAC284", "ProcessCacheService.getPtIdPtNameCache()", new Object[]{this.templateIdNameCache, ConfigGeneratorConstant.CacheClusterType.EJBWEB.name()});
        }
        return this.appCacheSvc.getCacheCluster(ConfigGeneratorConstant.CacheClusterType.EJBWEB).getCache(this.templateIdNameCache);
    }

    private void addCacheListener() {
        if (!this.isProcessCacheCategoryEnabled()) {
            return;
        }
        this.getProcessMetaDataCache().setLogger(this.getLogger());
        if (this.isTemplateIdNameCacheEnabled()) {
            this.getTemplateIdNameCache().setLogger(this.getLogger());
        }
        if (this.isDebugEnabled()) {
            ProcessMetaDataCacheListener cacheLstnr = null;
            cacheLstnr = new ProcessMetaDataCacheListener();
            cacheLstnr.setLogger(this.getLogger());
            this.getProcessMetaDataCache().addListener((AbstractCacheListener)cacheLstnr);
            if (this.isTemplateIdNameCacheEnabled()) {
                cacheLstnr = new ProcessKeyCacheListener();
                cacheLstnr.setLogger(this.getLogger());
                this.getTemplateIdNameCache().addListener((AbstractCacheListener)cacheLstnr);
            }
        }
    }

    private static String getProcessMetaDataInfo(ProcessMetaData processMetaData) {
        if (processMetaData != null) {
            return processMetaData.toString();
        }
        return null;
    }

    protected boolean isValidStr(String str) {
        return str != null && !str.trim().isEmpty();
    }

    protected final boolean isValidTemplateId(long ptId) {
        return ptId > 0L;
    }

    protected final void validateTemplateName(String ptName) {
        if (!this.isValidStr(ptName)) {
            throw (AppCacheException)this.getExcpService().createException("BM_DCAC034", "ProcessCacheService.validateTemplateName(String)", new Object[]{"ptName", ptName});
        }
    }

    protected final void validateTemplateId(long ptId) {
        if (!this.isValidTemplateId(ptId)) {
            throw (AppCacheException)this.getExcpService().createException("BM_DCAC059", "ProcessCacheService.validateTemplateId(long)", new Object[]{ptId});
        }
    }

    protected boolean isProcessCacheCategoryEnabled() {
        return this.isProcessCacheCategoryEnabled;
    }

    protected boolean isTemplateIdNameCacheEnabled() {
        return this.isTemplateIdNameCacheEnabled;
    }

    protected boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }

    protected final ExceptionService<AppCacheException> getExcpService() {
        return this.excpService;
    }

    protected SBMLogger getLogger() {
        return this.logger;
    }

    public static synchronized void cleanup() {
        self = null;
    }

    private static enum QUERY {
        GET_PT_XML("select XML from PROCESSXML where PROCESS_TEMPLATE_ID = ?");

        private String sql;

        private QUERY(String sql) {
            this.sql = sql;
        }

        String getSql() {
            return this.sql;
        }
    }
}

