/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.storeevent.mconsole;

import com.savvion.sbm.bizlogic.storeevent.mconsole.ConsoleTable;
import com.savvion.sbm.bizlogic.storeevent.mconsole.MConsole;
import com.savvion.sbm.bizlogic.storeevent.mconsole.SbmApp;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Vector;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.helpers.ParserFactory;

public class ConsoleTableHandler
extends HandlerBase {
    private ConsoleTable consoleTable;
    private String element;
    private final Vector tableList;
    private StringBuffer buffer;
    private final String dbtype;
    private final SbmApp app;
    private static final String OPENEDGESCHEMA = "openedgeschema";
    private static final String POSTGRESQL_SCHEMA = "postgresqlschema";

    public ConsoleTableHandler(SbmApp app) {
        this.app = app;
        this.dbtype = app.getDB();
        this.tableList = new Vector();
        this.startParsing();
    }

    @Override
    public void startElement(String raw, AttributeList attrs) {
        this.buffer = new StringBuffer();
        this.element = raw.toLowerCase();
        if ("consoletable".equals(this.element)) {
            this.consoleTable = new ConsoleTable(this.app.getDB(), this.app.getCounter());
            this.consoleTable.setName(attrs.getValue("name"));
            this.consoleTable.setTimeColumn(attrs.getValue("timecolumn"));
            this.consoleTable.setOneRowPer(attrs.getValue("onerowper"));
            this.consoleTable.setUpdateFrequency(attrs.getValue("updatefrequency"));
            this.consoleTable.setReflection(this.app.getPopObject(), this.app.getInsert(), this.app.getUpdate());
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        String tagValue = new String(ch, start, length);
        this.appendBuffer(tagValue);
    }

    private void appendBuffer(String value) {
        if (this.buffer == null) {
            this.buffer = new StringBuffer();
        }
        this.buffer.append(value);
    }

    @Override
    public void endElement(String raw) {
        String dbmsname = MConsole.getDatabaseName();
        this.element = raw.toLowerCase();
        if ("consoletable".equals(this.element)) {
            this.tableList.addElement(this.consoleTable);
        } else if ("maxrows".equals(this.element)) {
            this.consoleTable.setMaxRows(this.buffer.toString());
        } else if ("oracleschema".equals(this.element) && dbmsname.equalsIgnoreCase("oracle")) {
            this.consoleTable.setSchema(this.buffer.toString());
        } else if ("mssqlschema".equals(this.element) && dbmsname.equalsIgnoreCase("mssqlserver")) {
            this.consoleTable.setSchema(this.buffer.toString());
        } else if ("ibmdb2schema".equals(this.element) && dbmsname.equalsIgnoreCase("ibmdb2")) {
            this.consoleTable.setSchema(this.buffer.toString());
        } else if ("sybaseschema".equals(this.element) && dbmsname.equalsIgnoreCase("sybase")) {
            this.consoleTable.setSchema(this.buffer.toString());
        } else if (OPENEDGESCHEMA.equalsIgnoreCase(this.element) && "openedge".equalsIgnoreCase(dbmsname)) {
            this.consoleTable.setSchema(this.buffer.toString());
        } else if (POSTGRESQL_SCHEMA.equalsIgnoreCase(this.element) && "postgresql".equalsIgnoreCase(dbmsname)) {
            this.consoleTable.setSchema(this.buffer.toString());
        }
    }

    @Override
    public void endDocument() {
    }

    public Vector getTableList() {
        return this.tableList;
    }

    private void startParsing() {
        try {
            Parser parser = ParserFactory.makeParser("com.ibm.xml.parsers.SAXParser");
            parser.setDocumentHandler(this);
            String dirroot = this.app.getPath();
            FileInputStream fis = new FileInputStream(dirroot + "/html/ConsoleTable.xml");
            parser.parse(new InputSource(fis));
            fis.close();
        }
        catch (IOException ioe) {
            MConsole.logger.warnKey("MConsole_MSG_1512", "ConsoleTableHandler.startParsing()", (Throwable)ioe, new Object[]{ioe.getMessage()});
        }
        catch (Exception e) {
            MConsole.logger.warnKey("MConsole_MSG_1513", "ConsoleTableHandler.startParsing()", (Throwable)e, new Object[]{e.getMessage()});
        }
    }
}

