/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.storeevent;

import com.savvion.sbm.bizlogic.storeevent.BSControl;
import com.savvion.sbm.bizlogic.storeevent.BSProcess;
import com.savvion.sbm.bizlogic.storeevent.BizLogicEventMap;
import com.savvion.sbm.util.CommonEvent;
import com.savvion.sbm.util.SBMDAOService;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;

public class BSProcessStatus
extends BSProcess {
    private static final String SQL_INSERT_PS = "INSERT INTO PROCESS_STATUS ( PROCESS_TEMPLATE_ID, PROCESS_INSTANCE_DATE, CREATED, ACTIVATED, REMOVED, COMPLETED) VALUES (?, ?, ?, ?, ?, ?)";
    private static final String SQL_SELECT_PS = "SELECT CREATED, ACTIVATED, REMOVED, COMPLETED FROM PROCESS_STATUS WHERE PROCESS_TEMPLATE_ID=? AND PROCESS_INSTANCE_DATE=?";
    private static final String SQL_CREATEUPDATE_PS = "UPDATE PROCESS_STATUS SET CREATED=CREATED+1 WHERE PROCESS_TEMPLATE_ID=? AND PROCESS_INSTANCE_DATE=?";
    private static final String SQL_ACTIVATEUPDATE_PS = "UPDATE PROCESS_STATUS SET ACTIVATED=ACTIVATED+1 WHERE PROCESS_TEMPLATE_ID=? AND PROCESS_INSTANCE_DATE=?";
    private static final String SQL_COMPLETEUPDATE_PS = "UPDATE PROCESS_STATUS SET COMPLETED=COMPLETED+1 WHERE PROCESS_TEMPLATE_ID=? AND PROCESS_INSTANCE_DATE=?";
    private static final String SQL_REMOVEUPDATE_PS = "UPDATE PROCESS_STATUS SET REMOVED=REMOVED+1 WHERE PROCESS_TEMPLATE_ID=? AND PROCESS_INSTANCE_DATE=?";
    private static final String SQL_DELETE_PS = "DELETE FROM PROCESS_STATUS WHERE PROCESS_TEMPLATE_ID = ?";
    private static PreparedStatement stmtInsertPS;
    private static PreparedStatement stmtSelectPS;
    private static PreparedStatement stmtCreateUpdatePS;
    private static PreparedStatement stmtActiveUpdatePS;
    private static PreparedStatement stmtCompleteUpdatePS;
    private static PreparedStatement stmtRemoveUpdatePS;
    private static PreparedStatement stmtDeletePS;

    private static void processStatusInsert(long ptId, Date date) throws SQLException {
        Connection conn = null;
        try {
            conn = BSControl.util.getBSConnection();
            stmtInsertPS = conn.prepareStatement(SQL_INSERT_PS);
            stmtInsertPS.setLong(1, ptId);
            stmtInsertPS.setDate(2, date);
            stmtInsertPS.setLong(3, 0L);
            stmtInsertPS.setLong(4, 0L);
            stmtInsertPS.setLong(5, 0L);
            stmtInsertPS.setLong(6, 0L);
            stmtInsertPS.executeUpdate();
        }
        catch (SQLException se) {
            BSControl.logger.errorKey("BizStore_MSG_1501", new Object[]{SQL_INSERT_PS, se.getMessage()});
            throw se;
        }
        finally {
            SBMDAOService.clean(null, (Statement)stmtInsertPS, (Connection)conn);
        }
    }

    private static boolean isProcessStatusExists(long ptId, Date date) throws SQLException {
        ResultSet rs;
        Connection conn;
        block4: {
            boolean bl;
            conn = null;
            rs = null;
            try {
                conn = BSControl.util.getBSConnection();
                stmtSelectPS = conn.prepareStatement(SQL_SELECT_PS);
                stmtSelectPS.setLong(1, ptId);
                stmtSelectPS.setDate(2, date);
                rs = stmtSelectPS.executeQuery();
                if (!rs.next()) break block4;
                bl = true;
            }
            catch (SQLException se) {
                try {
                    BSControl.logger.errorKey("BizStore_MSG_1501", new Object[]{SQL_SELECT_PS, se.getMessage()});
                    throw se;
                }
                catch (Throwable throwable) {
                    SBMDAOService.clean(rs, (Statement)stmtSelectPS, (Connection)conn);
                    throw throwable;
                }
            }
            SBMDAOService.clean((ResultSet)rs, (Statement)stmtSelectPS, (Connection)conn);
            return bl;
        }
        SBMDAOService.clean((ResultSet)rs, (Statement)stmtSelectPS, (Connection)conn);
        return false;
    }

    private static void updateCreatedInstance(long ptId, Date date) throws SQLException {
        Connection conn = null;
        try {
            conn = BSControl.util.getBSConnection();
            stmtCreateUpdatePS = conn.prepareStatement(SQL_CREATEUPDATE_PS);
            stmtCreateUpdatePS.setLong(1, ptId);
            stmtCreateUpdatePS.setDate(2, date);
            stmtCreateUpdatePS.executeUpdate();
        }
        catch (SQLException se) {
            BSControl.logger.errorKey("BizStore_MSG_1501", new Object[]{SQL_CREATEUPDATE_PS, se.getMessage()});
            throw se;
        }
        finally {
            SBMDAOService.clean(null, (Statement)stmtCreateUpdatePS, (Connection)conn);
        }
    }

    private static void updateActivatedInstance(long ptId, Date date) throws SQLException {
        Connection conn = null;
        try {
            conn = BSControl.util.getBSConnection();
            stmtActiveUpdatePS = conn.prepareStatement(SQL_ACTIVATEUPDATE_PS);
            stmtActiveUpdatePS.setLong(1, ptId);
            stmtActiveUpdatePS.setDate(2, date);
            stmtActiveUpdatePS.executeUpdate();
        }
        catch (SQLException se) {
            BSControl.logger.errorKey("BizStore_MSG_1501", new Object[]{SQL_ACTIVATEUPDATE_PS, se.getMessage()});
            throw se;
        }
        finally {
            SBMDAOService.clean(null, (Statement)stmtActiveUpdatePS, (Connection)conn);
        }
    }

    private static void updateCompletedInstance(long ptId, Date date) throws SQLException {
        Connection conn = null;
        try {
            conn = BSControl.util.getBSConnection();
            stmtCompleteUpdatePS = conn.prepareStatement(SQL_COMPLETEUPDATE_PS);
            stmtCompleteUpdatePS.setLong(1, ptId);
            stmtCompleteUpdatePS.setDate(2, date);
            stmtCompleteUpdatePS.executeUpdate();
        }
        catch (SQLException se) {
            BSControl.logger.errorKey("BizStore_MSG_1501", new Object[]{SQL_COMPLETEUPDATE_PS, se.getMessage()});
            throw se;
        }
        finally {
            SBMDAOService.clean(null, (Statement)stmtCompleteUpdatePS, (Connection)conn);
        }
    }

    private static void updateRemovedInstance(long ptId, Date date) throws SQLException {
        Connection conn = null;
        try {
            conn = BSControl.util.getBSConnection();
            stmtRemoveUpdatePS = conn.prepareStatement(SQL_REMOVEUPDATE_PS);
            stmtRemoveUpdatePS.setLong(1, ptId);
            stmtRemoveUpdatePS.setDate(2, date);
            stmtRemoveUpdatePS.executeUpdate();
        }
        catch (SQLException se) {
            BSControl.logger.errorKey("BizStore_MSG_1501", new Object[]{SQL_REMOVEUPDATE_PS, se.getMessage()});
            throw se;
        }
        finally {
            SBMDAOService.clean(null, (Statement)stmtRemoveUpdatePS, (Connection)conn);
        }
    }

    public static void onCreate(CommonEvent event) throws SQLException {
        long ptId = BizLogicEventMap.getProcessTemplateID(event);
        Timestamp ts = new Timestamp(BizLogicEventMap.getDate(event));
        Date date = BSProcessStatus.getDate(ts);
        if (!BSProcessStatus.isProcessStatusExists(ptId, date)) {
            BSProcessStatus.processStatusInsert(ptId, date);
        }
        BSProcessStatus.updateCreatedInstance(ptId, date);
    }

    public static void onStatusChange(CommonEvent event) throws SQLException {
        long ptId = BizLogicEventMap.getProcessTemplateID(event);
        Timestamp ts = new Timestamp(BizLogicEventMap.getDate(event));
        Date date = BSProcessStatus.getDate(ts);
        String status = BizLogicEventMap.getStatusString(event);
        if (!BSProcessStatus.isProcessStatusExists(ptId, date)) {
            BSProcessStatus.processStatusInsert(ptId, date);
        }
        if ("PI_ACTIVATED".equals(status)) {
            BSProcessStatus.updateActivatedInstance(ptId, date);
        } else if ("PI_COMPLETED".equals(status)) {
            BSProcessStatus.updateCompletedInstance(ptId, date);
        } else if ("PI_REMOVED".equals(status)) {
            BSProcessStatus.updateRemovedInstance(ptId, date);
        }
    }

    public static void removeProcessStatus(CommonEvent event) throws SQLException {
        Connection conn = null;
        try {
            conn = BSControl.util.getBSConnection();
            long ptId = BizLogicEventMap.getProcessTemplateID(event);
            stmtDeletePS = conn.prepareStatement(SQL_DELETE_PS);
            stmtDeletePS.setLong(1, ptId);
            stmtDeletePS.executeUpdate();
        }
        catch (SQLException se) {
            BSControl.logger.errorKey("BizStore_MSG_1501", new Object[]{SQL_DELETE_PS, se.getMessage()});
            throw se;
        }
        finally {
            SBMDAOService.clean(null, (Statement)stmtDeletePS, (Connection)conn);
        }
    }

    private static Date getDate(Timestamp ts) {
        return new Date(ts.getTime());
    }

    public static void printSQLStatements() {
        BSControl.logger.debug((Object)"BSProcessStatus.printSQLStatements:");
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_INSERT_PS});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_SELECT_PS});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_CREATEUPDATE_PS});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_ACTIVATEUPDATE_PS});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_COMPLETEUPDATE_PS});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_REMOVEUPDATE_PS});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_DELETE_PS});
    }
}

