/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.svo;

import com.savvion.sbm.bizlogic.util.BLConstants;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ProcessNotesData
implements Serializable {
    protected long notesID;
    Map<String, Object> notesAttributes = new HashMap<String, Object>();

    ProcessNotesData(long notesID, Map<String, Object> notesAttributes) {
        if (notesAttributes == null || notesAttributes.isEmpty()) {
            throw new RuntimeException("The notes attributes cannot be null/empty");
        }
        this.notesID = notesID;
        this.notesAttributes = notesAttributes;
    }

    public long getNotesID() {
        BLConstants.single();
        return this.getLongField("NOTES_ID", "notes id");
    }

    public long getProcessTemplateID() {
        BLConstants.single();
        return this.getLongField("PROCESSTEMPLATEID", "process template id");
    }

    public long getProcessInstanceID() {
        BLConstants.single();
        return this.getLongField("PROCESSINSTANCEID", "process instance id");
    }

    private long getLoopCounter() {
        BLConstants.single();
        return this.getIntField("LOOPCOUNTER", "loop counter");
    }

    public String getWorkstepName() {
        BLConstants.single();
        return this.getStringField("WORKSTEPNAME");
    }

    public long getWorkItemID() {
        BLConstants.single();
        return this.getLongField("WORKITEMID", "workitem id");
    }

    public String getCWorkItemName() {
        BLConstants.single();
        return this.getStringField("CWORKITEM_NAME");
    }

    public long getCStepID() {
        BLConstants.single();
        return this.getLongField("CSTEP_ID", "collaborative step id");
    }

    public long getCWorkItemID() {
        BLConstants.single();
        return this.getLongField("CWORKITEM_ID", "collaborative workitem id");
    }

    public long getReferenceID() {
        BLConstants.single();
        return this.getLongField("REFERENCE_ID", "reference id");
    }

    public long getLastModifiedTime() {
        BLConstants.single();
        return this.getLongField("LAST_MODIFIED_TIME", "last modified time");
    }

    public String getUser() {
        BLConstants.single();
        return this.getStringField("NOTES_USER");
    }

    public String getThreadName() {
        BLConstants.single();
        return this.getStringField("THREAD_NAME");
    }

    public String getNotes() {
        BLConstants.single();
        return this.getStringField("NOTES");
    }

    public boolean isInfo() {
        BLConstants.single();
        return 1 == this.getNotesType();
    }

    public boolean isError() {
        BLConstants.single();
        return 3 == this.getNotesType();
    }

    public boolean isWarn() {
        BLConstants.single();
        return 2 == this.getNotesType();
    }

    public boolean isProcessInstanceContext() {
        BLConstants.single();
        return 1 == this.getNotesContext();
    }

    public boolean isWorkStepInstanceContext() {
        BLConstants.single();
        return 2 == this.getNotesContext();
    }

    public boolean isWorkItemContext() {
        BLConstants.single();
        return 3 == this.getNotesContext();
    }

    public boolean isCWorkItemContext() {
        BLConstants.single();
        return 5 == this.getNotesContext();
    }

    private int getNotesType() {
        BLConstants.single();
        return this.getIntField("NOTES_TYPE", "notes type");
    }

    private int getNotesContext() {
        BLConstants.single();
        return this.getIntField("NOTES_CONTEXT", "notes context");
    }

    public String getProcessTemplateName() {
        BLConstants.single();
        return (String)this.notesAttributes.get("PROCESSTEMPLATENAME");
    }

    public String getAppName() {
        BLConstants.single();
        return (String)this.notesAttributes.get("APP_NAME");
    }

    public String getProcessInstanceName() {
        BLConstants.single();
        return (String)this.notesAttributes.get("PROCESSINSTANCENAME");
    }

    private String getStringField(String key) {
        return (String)this.notesAttributes.get(key);
    }

    private int getIntField(String key, String fieldName) {
        Integer intObject = (Integer)this.notesAttributes.get(key);
        if (intObject == null) {
            throw new RuntimeException("The property <" + fieldName + "> does not exist in these notes");
        }
        int intValue = -1;
        try {
            intValue = intObject;
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("The property <" + fieldName + "> has an invalid value <" + intObject + ">. It should be of the type integer");
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
        return intValue;
    }

    protected long getLongField(String key, String fieldName) {
        Long longObject = (Long)this.notesAttributes.get(key);
        if (longObject == null) {
            throw new RuntimeException("The property <" + fieldName + "> does not exist in these notes");
        }
        long longValue = -1L;
        try {
            longValue = longObject;
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("The property <" + fieldName + "> has an invalid value <" + longObject + ">. It should be of the type long");
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
        return longValue;
    }
}

