/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.svo;

import com.savvion.sbm.bizlogic.server.svo.DataSlotType;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;

public class DateTime
implements DataSlotType {
    static final long serialVersionUID = 1265384147805568330L;
    private static final int DEFAULT_DATE_STYLE = 3;
    private static final int DEFAULT_TIME_STYLE = 3;
    private static final String TYPE = "DATETIME";
    private Timestamp dt;

    public DateTime(String sdt) throws ParseException {
        try {
            this.dt = new Timestamp(Long.valueOf(sdt));
        }
        catch (Throwable th) {
            try {
                this.dt = DateTime.parse(sdt, 3, 3);
            }
            catch (ParseException pe2) {
                this.dt = DateTime.parse(sdt, 3);
            }
        }
    }

    public DateTime(String sdt, int dateStyle) throws ParseException {
        this.dt = DateTime.parse(sdt, dateStyle);
    }

    public DateTime(String sdt, int dateStyle, int timeStyle) throws ParseException {
        this.dt = DateTime.parse(sdt, dateStyle, timeStyle);
    }

    public DateTime(Timestamp tdt) {
        this.dt = tdt;
    }

    public DateTime(long ldt) {
        this.dt = new Timestamp(ldt);
    }

    public DateTime(Calendar cal) {
        this.dt = null;
        if (cal != null) {
            Date udate = cal.getTime();
            this.dt = new Timestamp(udate.getTime());
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public Timestamp getValue() {
        return this.dt;
    }

    public String getStringValue() {
        if (this.dt == null) {
            return null;
        }
        DateFormat df = DateFormat.getDateInstance(3);
        return df.format(this.dt);
    }

    public String getStringValue(int dateStyle) {
        if (this.dt == null) {
            return null;
        }
        DateFormat df = DateFormat.getDateInstance(dateStyle);
        return df.format(this.dt);
    }

    public String getStringValue(int dateStyle, int timeStyle) {
        if (this.dt == null) {
            return null;
        }
        DateFormat df = DateFormat.getDateTimeInstance(dateStyle, timeStyle);
        return df.format(this.dt);
    }

    static Timestamp parse(String sdt, int dateStyle) throws ParseException {
        if (sdt == null) {
            throw new RuntimeException("Null value provided for Date during creation of DateTime object.");
        }
        DateFormat df = DateFormat.getDateInstance(dateStyle);
        df.setLenient(false);
        return new Timestamp(df.parse(sdt).getTime());
    }

    static Timestamp parse(String sdt, int dateStyle, int timeStyle) throws ParseException {
        if (sdt == null) {
            throw new RuntimeException("Null value provided for Date during creation of DateTime object.");
        }
        DateFormat df = DateFormat.getDateTimeInstance(dateStyle, timeStyle);
        df.setLenient(false);
        return new Timestamp(df.parse(sdt).getTime());
    }

    public String toString() {
        if (this.dt == null) {
            return "";
        }
        return String.valueOf(this.getTime());
    }

    public long getTime() {
        if (this.dt != null) {
            return this.dt.getTime();
        }
        return -1L;
    }

    public Calendar getCalendar() {
        Calendar cal = null;
        if (this.dt != null) {
            Date udate = new Date(this.dt.getTime());
            cal = Calendar.getInstance();
            cal.setTime(udate);
        }
        return cal;
    }

    public static DateTime getInstance(long ldt) {
        return new DateTime(ldt);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DateTime) {
            DateTime anotherDt = (DateTime)obj;
            Timestamp tdt = anotherDt.getValue();
            if (this.dt != null && tdt != null) {
                return this.dt.equals(tdt);
            }
            return this.dt == null && tdt == null;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.dt);
    }

    public boolean isNull() {
        return this.dt == null;
    }
}

