/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.ejb;

import com.savvion.sbm.bizlogic.smp.util.SMPConfig;
import com.savvion.sbm.bizlogic.util.BLAlertService;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.MDBAdapter;
import com.savvion.sbm.messaging.core.ChannelService;
import com.savvion.sbm.messaging.core.MDService;
import com.savvion.sbm.util.SBMConstants;
import com.savvion.sbm.util.SBMControl;
import com.savvion.sbm.util.SBMUtil;
import com.savvion.sbm.util.ServiceLocator;
import com.savvion.sbm.util.TransactionService;
import com.savvion.sbm.util.logger.SBMLogger;
import java.util.HashMap;
import java.util.List;
import javax.jms.Message;
import javax.jms.TextMessage;
import javax.transaction.UserTransaction;

public class BLServiceMDB
extends MDBAdapter {
    public void onMessage(Message message) {
        if (message == null || !(message instanceof TextMessage)) {
            this.log(BLControl.logger, "BLServiceMDB:Ignored message " + message);
            return;
        }
        String operation = null;
        try {
            BLConstants consts = BLConstants.single();
            BLConstants.ClusterConstants cfr_ignored_0 = consts.cluster;
            operation = message.getStringProperty("CLUSTER_OPERATION");
            this.logMessageInfo(BLControl.logger, "BLServiceMDB", message.getStringProperty("TYPE"), operation);
            BLConstants.ClusterConstants cfr_ignored_1 = consts.cluster;
            if ("BL_START".equalsIgnoreCase(operation)) {
                this.startServer(message);
            } else {
                BLConstants.ClusterConstants cfr_ignored_2 = consts.cluster;
                if ("BL_STOP".equalsIgnoreCase(operation)) {
                    this.stopServer(message);
                } else {
                    BLConstants.ClusterConstants cfr_ignored_3 = consts.cluster;
                    if ("BL_SUSPEND".equalsIgnoreCase(operation)) {
                        BLControl.doSuspend();
                    } else {
                        BLConstants.ClusterConstants cfr_ignored_4 = consts.cluster;
                        if ("BL_RESUME".equalsIgnoreCase(operation)) {
                            BLControl.doResume();
                        } else {
                            BLConstants.ClusterConstants cfr_ignored_5 = consts.cluster;
                            if ("BL_SUSPEND_CONNECTIONS".equalsIgnoreCase(operation)) {
                                BLControl.doSuspendConnections();
                            } else {
                                BLConstants.ClusterConstants cfr_ignored_6 = consts.cluster;
                                if ("BL_RESUME_CONNECTIONS".equalsIgnoreCase(operation)) {
                                    BLControl.doResumeConnections();
                                } else {
                                    BLConstants.ClusterConstants cfr_ignored_7 = consts.cluster;
                                    if ("BL_SESSION_TIMEOUT".equalsIgnoreCase(operation)) {
                                        BLConstants.ClusterConstants cfr_ignored_8 = consts.cluster;
                                        long sessionTimeOut = message.getLongProperty("BL_SESSION_TIMEOUT");
                                        BLControl.doSetSessionTimeOut((long)sessionTimeOut);
                                    } else {
                                        BLConstants.ClusterConstants cfr_ignored_9 = consts.cluster;
                                        if ("BL_MAX_SESSIONS".equalsIgnoreCase(operation)) {
                                            BLConstants.ClusterConstants cfr_ignored_10 = consts.cluster;
                                            int maxSessions = message.getIntProperty("BL_MAX_SESSIONS");
                                            BLControl.doSetMaxSessions((int)maxSessions);
                                        } else {
                                            BLConstants.ClusterConstants cfr_ignored_11 = consts.cluster;
                                            if ("BL_ADDNODE".equalsIgnoreCase(operation)) {
                                                this.addNode(message);
                                            } else {
                                                BLConstants.ClusterConstants cfr_ignored_12 = consts.cluster;
                                                if ("BL_PROPS_REFRESH".equalsIgnoreCase(operation)) {
                                                    BLControl.doRefresh();
                                                } else {
                                                    BLConstants.ClusterConstants cfr_ignored_13 = consts.cluster;
                                                    if ("BL_JMS_REFRESH".equalsIgnoreCase(operation)) {
                                                        BLControl.doRefreshJMS();
                                                    } else {
                                                        BLConstants.ClusterConstants cfr_ignored_14 = consts.cluster;
                                                        if ("BL_SBM_REFRESH".equalsIgnoreCase(operation)) {
                                                            SBMControl.refresh();
                                                        } else {
                                                            BLConstants.ClusterConstants cfr_ignored_15 = consts.cluster;
                                                            if ("CALLBACK_REFRESH".equalsIgnoreCase(operation)) {
                                                                BLControl.refreshCallback();
                                                            } else {
                                                                BLConstants.ClusterConstants cfr_ignored_16 = BLControl.consts.cluster;
                                                                if ("MP_REFRESH".equalsIgnoreCase(operation)) {
                                                                    SMPConfig.self().refresh();
                                                                } else if ("ALERT_ENABLE_CACHE".equals(operation)) {
                                                                    BLAlertService.single().doEnableAlertCache();
                                                                } else if ("ALERT_DISABLE_CACHE".equals(operation)) {
                                                                    BLAlertService.single().doDisableAlertCache();
                                                                } else if ("ALERT_CLEAR_TEMPLATE_CACHE".equals(operation)) {
                                                                    String ptName = message.getStringProperty("PROCESS_TEMPLATE");
                                                                    BLAlertService.single().doClearAlertCache(ptName);
                                                                } else if ("ALERT_CLEAR_CACHE".equals(operation)) {
                                                                    BLAlertService.single().doClearAlertCache();
                                                                } else if ("REFRESH_CHANNELS".equals(operation)) {
                                                                    List channelNames = (List)message.getObjectProperty("CHANNEL_NAMES");
                                                                    ChannelService.self().doRefresh(channelNames);
                                                                } else if ("REFRESH_MESSAGE_DESCRIPTORS".equals(operation)) {
                                                                    List mdNames = (List)message.getObjectProperty("MESSAGEDESCRIPTOR_NAMES");
                                                                    MDService.self().doRefresh(mdNames);
                                                                } else {
                                                                    BLConstants.ClusterConstants cfr_ignored_17 = consts.cluster;
                                                                    if ("SYSTEM_CALENDAR_REFRESH".equals(operation)) {
                                                                        BLControl.doRefreshSystemCalendar();
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.log(BLControl.logger, "Exception in BLServiceMDB for the operation <" + operation + ">", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startServer(Message message) {
        Class<BLServiceMDB> clazz = BLServiceMDB.class;
        synchronized (BLServiceMDB.class) {
            int n = BLControl.getServerState();
            BLConstants.single();
            if (n == 1) {
                this.log(BLControl.logger, "BLServiceMDB.startServer(): Duplicate start request is rejected");
                BLConstants.single();
                this.reply(message, "BizLogic Server is already started");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            UserTransaction ut = this.mdc.getUserTransaction();
            try {
                ut.begin();
                BLControl.start();
                ut.commit();
                this.log(BLControl.logger, "BLServiceMDB.startServer() finished.");
                BLConstants.single();
                this.reply(message, "BizLogic Server is started");
            }
            catch (Exception e) {
                if (ut != null) {
                    TransactionService.rollback((UserTransaction)ut, (SBMLogger)BLControl.logger);
                }
                this.log(BLControl.logger, "BLServiceMDB.startServer() failed.", e);
                BLConstants.single();
                this.reply(message, "BizLogic Server failed to start");
            }
            return;
        }
    }

    private void stopServer(Message message) {
        if (BLControl.isServerNotReady()) {
            this.log(BLControl.logger, "BLServiceMDB.stopServer(): Duplicate stop request is rejected");
            BLConstants.single();
            this.reply(message, "BizLogic Server is already stopped");
            return;
        }
        UserTransaction ut = this.mdc.getUserTransaction();
        try {
            ut.begin();
            BLControl.shutdown();
            ut.commit();
            this.log(BLControl.logger, "BLServiceMDB.stopServer() finished.");
            BLConstants.single();
            this.reply(message, "BizLogic Server is stopped");
        }
        catch (Exception e) {
            if (ut != null) {
                TransactionService.rollback((UserTransaction)ut, (SBMLogger)BLControl.logger);
            }
            this.log(BLControl.logger, "BLServiceMDB.stopServer() failed.", e);
            BLConstants.single();
            this.reply(message, "BizLogic Server failed to stop");
        }
    }

    private void startServerNode(Message message) {
        int n = BLControl.getServerState();
        BLConstants.single();
        if (n == 1) {
            this.log(BLControl.logger, "BLServiceMDB.startServer(): Duplicate start request is rejected");
            BLConstants.single();
            this.reply(message, "BizLogic Server is already started");
            return;
        }
        HashMap map = new HashMap(2);
        UserTransaction ut = this.mdc.getUserTransaction();
        try {
            ut.begin();
            BLControl.start(map);
            ut.commit();
            this.log(BLControl.logger, "BLServiceMDB.startServer() finished.");
            BLConstants.single();
            this.reply(message, "BizLogic Server is started");
        }
        catch (Exception e) {
            if (ut != null) {
                TransactionService.rollback((UserTransaction)ut, (SBMLogger)BLControl.logger);
            }
            this.log(BLControl.logger, "BLServiceMDB.startServer() failed.", e);
            BLConstants.single();
            this.reply(message, "BizLogic Server failed to start");
        }
    }

    private void reply(Message message, String statusMsg) {
        BLConstants consts = BLConstants.single();
        String nodecount = null;
        boolean cluster = false;
        try {
            if (message.getJMSReplyTo() == null) {
                return;
            }
            BLConstants.ClusterConstants cfr_ignored_0 = consts.cluster;
            nodecount = message.getStringProperty("NODECOUNT");
            cluster = BLControl.isServerReady() ? ServiceLocator.self().isCluster() && BLControl.util.isClustering() : ServiceLocator.self().isCluster();
        }
        catch (Exception ex) {
            this.log(BLControl.logger, "Exception BLServiceMDB.reply():", ex);
        }
        if (!cluster && nodecount != null) {
            try {
                statusMsg = BLUtil.getMessage((String)"BizLogic_ERR_2139", null);
            }
            catch (Throwable th) {
                this.log(BLControl.logger, "Exception in getting message.");
                statusMsg = "Cluster flags may not be properly set.";
            }
            this.log(BLControl.logger, statusMsg);
        }
        HashMap<String, String> selectors = new HashMap<String, String>();
        BLConstants.ClusterConstants cfr_ignored_1 = consts.cluster;
        selectors.put("TYPE", "BIZLOGICSERVER");
        selectors.put("SERVER_ID", "" + BLControl.serverID);
        selectors.put("SERVER_STATUS", "" + BLControl.getServerState());
        selectors.put("SERVER_HOST", SBMUtil.getHost());
        SBMConstants.self().getClass();
        selectors.put("SERVER_NAME", System.getProperty("sbm.server.name"));
        if (BLControl.serverID == null || BLControl.serverID.trim().isEmpty()) {
            selectors.put("SERVER_MSG", statusMsg);
        } else {
            statusMsg = statusMsg + "(" + BLControl.serverID + ")";
            selectors.put("SERVER_MSG", statusMsg);
        }
        try {
            BLConstants.ClusterConstants cfr_ignored_2 = consts.cluster;
            Thread.sleep(5000L);
            this.acknowledge(message.getJMSReplyTo(), "", 1, selectors);
        }
        catch (Exception e) {
            this.log(BLControl.logger, "Exception in BLServiceMDB.reply", e);
        }
    }

    private void addNode(Message message) {
        if (BLControl.isServerReady()) {
            return;
        }
        this.startServerNode(message);
    }
}

