/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.ejb;

import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.MDBAdapter;
import com.savvion.sbm.util.TransactionService;
import com.savvion.sbm.util.logger.SBMLogger;
import javax.jms.Message;
import javax.jms.TextMessage;
import javax.transaction.UserTransaction;

public class BLAdminMDB
extends MDBAdapter {
    public void onMessage(Message message) {
        block8: {
            if (this.waitForBizLogicStartup(message)) {
                return;
            }
            if (!BLControl.isServerReady()) {
                this.log(BLControl.logger, "BLAdminMDB: BizLogic Server is not READY");
                return;
            }
            if (message == null || !(message instanceof TextMessage)) {
                this.log(BLControl.logger, "BLAdminMDB: Ignored message " + message);
                return;
            }
            try {
                BLConstants consts = BLConstants.single();
                BLConstants.ClusterConstants cfr_ignored_0 = consts.cluster;
                String operation = message.getStringProperty("CLUSTER_OPERATION");
                if (operation == null) {
                    operation = message.getStringProperty("OPERATION");
                }
                this.logMessageInfo(BLControl.logger, "BLAdminMDB", message.getStringProperty("TYPE"), operation);
                BLConstants.ClusterConstants cfr_ignored_1 = consts.cluster;
                if (!"BL_RESTART_EXTERNAL_SERVICES".equalsIgnoreCase(operation)) {
                    if (!"BL_RESTART_EXTERNAL_SERVICES".equalsIgnoreCase(operation)) break block8;
                }
                this.restartExternalServices();
            }
            catch (Exception e) {
                this.log(BLControl.logger, "Exception in BLAdminMDB", e);
            }
        }
    }

    private void restartExternalServices() {
        UserTransaction ut = this.mdc.getUserTransaction();
        try {
            ut.begin();
            BLControl.doRestartExternalServices();
            ut.commit();
        }
        catch (Exception e) {
            if (ut != null) {
                TransactionService.rollback((UserTransaction)ut, (SBMLogger)BLControl.logger);
            }
            this.log(BLControl.logger, "BLAdminMDB: Restart of ExternalServices failed.", e);
        }
    }

    private boolean waitForBizLogicStartup(Message msg) {
        try {
            int count = BLUtil.self().checkAndRetryServerStart(msg);
            BLConstants.ClusterConstants cfr_ignored_0 = BLConstants.single().cluster;
            if (count == -1) {
                return false;
            }
            this.log(BLControl.logger, BLUtil.getMessage((String)"BizLogic_ERR_2140", (Object[])new Object[]{count}));
            BLConstants.ClusterConstants cfr_ignored_1 = BLConstants.single().cluster;
            if (count == 5) {
                this.log(BLControl.logger, BLUtil.getMessage((String)"BizLogic_ERR_2141", null));
                BLUtil.resumeConnectionsOnly();
            }
        }
        catch (Exception ex) {
            this.log(BLControl.logger, "BLAdminMDB: waitForBizLogicStartup failed.", ex);
        }
        return true;
    }
}

