/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.dao;

import com.savvion.sbm.bizlogic.server.WFProcessContext;
import com.savvion.sbm.bizlogic.server.ejb.WorkStepInstanceEBBBean;
import com.savvion.sbm.bizlogic.server.ejb.WorkStepInstancePK;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLDAOService;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.DBConstants;
import com.savvion.sbm.util.FileUtil;
import com.savvion.sbm.util.QueryAcc;
import com.savvion.sbm.util.QueryAccThreadBound;
import com.savvion.sbm.util.SBMDatabase;
import com.savvion.sbm.util.SBMUtil;
import com.savvion.sbm.util.ServiceLocator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.ObjectNotFoundException;
import javax.sql.DataSource;

public class WorkStepInstanceDAO
extends BLDAOService {
    private static final String[] CREATE_LIST;
    private static final String[] CREATE_TABLELIST;
    private static final String[] LOAD_TABLELIST;
    private static final String[] CREATE_DYNAMIC_PROCESSLIST;
    private static final String[] CREATE_DYNAMIC_PROCESS_TABLELIST;
    private static final String[] CLIENT_ATTR_LIST;
    private static final String[] CLIENT_ATTR_TABLELIST;
    public static final String ORDER_BY_CLAUSE;
    private static final String BIZ_LOGIC_ERR_1588 = "BizLogic_ERR_1588";
    private static final String WORKSTEPINSTANCE = "WORKSTEPINSTANCE";
    private static final String INSERT_INTO = "insert into ";
    private static final String VALUES = ") values (";
    private static final String CLOSE_PARENTHESIS = ")";
    private static final String OPEN_PARENTHESIS = " (";
    private static final String SELECT = "select ";
    private static final String COMMA_SPACE = ", ";
    private static final String FROM = " from ";
    private static final String DELETE_FROM = "delete from ";
    private static final String QUESTION_MARK = "?";
    private static final String WHERE = " where ";
    private static final String COMMA_PI = ", pi.";
    private static final String QUESTION_AND = "= ? AND ";
    private static final String SPACE_EQUALS_QUESTION = " = ?";
    private static final String EQUALS_QUESTION_AND = " = ? AND ";
    private static final String SPACE_EQUALS_QUESTION_SPACE = " = ? ";
    private static final String EQUALS = " = ";
    private static final String DOUBLE_OPEN_PARENTHESIS = " ((";
    private static final String DOUBLE_CLOSE_PARENTHESIS_OR = " )) OR (";
    private static final String PERIOD = ".";
    private static final String QUESTION_SMALL_AND = " = ? and ";
    private static final String SELECT_COUNT = "select count(*) from ";
    private static final String NOT_IN = " NOT IN ( ";
    private static final String TRIPLE_CLOSE_PARENTHESIS = " ))) ";
    private static final String COMMA = ",";
    private static final String IN_OPEN_PARENTHESIS = " in (";
    private static final String AND = " AND ";
    private static final String EQUALS_ZERO = " = 0 ";
    private static final String PREFIX_WSI = "wsi.";
    private static final String WSI_COMMA = " wsi, ";
    private static final String ASCENDING = " ASC ";
    private static final String PI_VALUE = " pi ";
    private static final String PREFIX_PI = "pi.";
    private static final String SPACE_PREFIX_WSI = " wsi.";
    private static final String EQUALS_PREFIX_PI = " = pi.";
    private static final String VALUES_QUESTIONS = ") values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String EQUALS_QUESTION_SPACE = "= ? ";
    private static final int INITIAL_CAPACITY_90 = 90;
    private static final int INITIAL_CAPACITY_100 = 100;
    private static final int INITIAL_CAPACITY_200 = 200;
    private static final int INITIAL_CAPACITY_380 = 380;
    public static String removeWorkStepInstance;
    public static String findByPrimaryKey;
    public static String findNoWhere;
    public static String createWorkStepInstance;
    public static String loadWorkStepInstance;
    public static String getDataSlotCopies;
    public static String getWorkStepNameListByStatus;
    public static String getWorkStepPrimaryKeyListByStatus;
    public static String getWorkStepInstanceList;
    public static String findByProcessInstance;
    public static String findStatusByProcessInstance;
    public static String createDynamicProcessWorkStepInstance;
    public static String removeByProcessInstance;
    public static String getWorkStepNameListByProcessInstance;
    public static String getPKListForRestartExternalService;
    public static String getWorkstepState;
    public static String getWorkstepStateByLoopCounter;
    public static String getCount;
    public static String getExpectArrivals;
    public static String getMilestoneWSIList;
    public static String getLoopCounterAndStatus;
    private static String joinWhereClause;

    public static void create(final HashMap attrsList) throws CreateException {
        long piid = -1L;
        long wid = -1L;
        try {
            QueryAccThreadBound.query((String)createWorkStepInstance, (DataSource)WorkStepInstanceDAO.getDataSource(), (QueryAcc.ParameterSetter)new QueryAcc.ParameterSetter(){

                public void set(PreparedStatement pstmtCreateWorkStepInstance) throws SQLException, CreateException {
                    for (int ix = 0; ix < CREATE_LIST.length; ++ix) {
                        Object value;
                        String key;
                        block20: {
                            block19: {
                                block18: {
                                    block17: {
                                        key = CREATE_LIST[ix];
                                        value = attrsList.get(key);
                                        if (key.equalsIgnoreCase("TYPE")) break block17;
                                        if (key.equalsIgnoreCase("PRIORITY")) break block17;
                                        if (!key.equalsIgnoreCase("STATUS")) break block18;
                                    }
                                    if (value == null) {
                                        pstmtCreateWorkStepInstance.setNull(ix + 1, 4);
                                        continue;
                                    }
                                    pstmtCreateWorkStepInstance.setInt(ix + 1, (Integer)value);
                                    continue;
                                }
                                if (key.equalsIgnoreCase("WORKSTEPNAME")) break block19;
                                if (key.equalsIgnoreCase("CREATOR")) break block19;
                                if (key.equalsIgnoreCase("PERFORMER")) break block19;
                                if (key.equalsIgnoreCase("INSTRUCTION")) break block19;
                                if (key.equalsIgnoreCase("INLINEBLOCK_NAME")) break block19;
                                if (key.equalsIgnoreCase("MILESTONE_NAME")) break block19;
                                if (!key.equalsIgnoreCase("MILESTONE_DESC")) break block20;
                            }
                            if (value == null) {
                                pstmtCreateWorkStepInstance.setNull(ix + 1, 12);
                                continue;
                            }
                            pstmtCreateWorkStepInstance.setString(ix + 1, (String)value);
                            continue;
                        }
                        if (key.equalsIgnoreCase("PROCESSTEMPLATEID")) {
                            if (value == null) {
                                pstmtCreateWorkStepInstance.setNull(ix + 1, -5);
                                continue;
                            }
                            pstmtCreateWorkStepInstance.setLong(ix + 1, (Long)value);
                            continue;
                        }
                        if (key.equalsIgnoreCase("WORKSTEPID")) {
                            if (value == null) {
                                Object[] objectArray = new Object[2];
                                objectArray[0] = "WORKSTEPID";
                                objectArray[1] = WorkStepInstanceDAO.WORKSTEPINSTANCE;
                                throw new CreateException(BLControl.msgFactory.lookup(WorkStepInstanceDAO.BIZ_LOGIC_ERR_1588, objectArray));
                            }
                            pstmtCreateWorkStepInstance.setLong(ix + 1, (Long)value);
                            continue;
                        }
                        if (key.equalsIgnoreCase("PROCESSINSTANCEID")) {
                            if (value == null) {
                                Object[] objectArray = new Object[2];
                                objectArray[0] = "PROCESSINSTANCEID";
                                objectArray[1] = WorkStepInstanceDAO.WORKSTEPINSTANCE;
                                throw new CreateException(BLControl.msgFactory.lookup(WorkStepInstanceDAO.BIZ_LOGIC_ERR_1588, objectArray));
                            }
                            pstmtCreateWorkStepInstance.setLong(ix + 1, (Long)value);
                            continue;
                        }
                        if (!key.equalsIgnoreCase("MONITOR_STEP")) continue;
                        if (value == null) {
                            pstmtCreateWorkStepInstance.setNull(ix + 1, 4);
                            continue;
                        }
                        pstmtCreateWorkStepInstance.setInt(ix + 1, (Boolean)value != false ? 1 : 0);
                    }
                    if (BLControl.util.DEBUG_DAO) {
                        Object[] objectArray = new Object[2];
                        objectArray[0] = createWorkStepInstance;
                        objectArray[1] = WorkStepInstanceDAO.getPrimaryKey((Long)attrsList.get("PROCESSINSTANCEID"), (Long)attrsList.get("WORKSTEPID"));
                        BLControl.logger.debugKey("BizLogic_ERR_1207", objectArray);
                    }
                }
            });
        }
        catch (SQLException sqle) {
            if (WorkStepInstanceDAO.isDuplicateObjectException((SQLException)sqle)) {
                throw new DuplicateKeyException(SBMUtil.getStackTrace((Throwable)sqle));
            }
            WorkStepInstanceDAO.handle((Throwable)sqle, (String)("WorkStepInstanceDAO.create(PKey: " + piid + COMMA + wid + CLOSE_PARENTHESIS));
        }
        catch (Exception ex) {
            WorkStepInstanceDAO.handle((Throwable)ex, (String)("WorkStepInstanceDAO.create(PKey: " + piid + COMMA + wid + CLOSE_PARENTHESIS));
        }
    }

    public static void createDynamicProcess(HashMap attrsList) throws CreateException {
        try (Connection conn = WorkStepInstanceDAO.getConnection();
             PreparedStatement preparedStatement = conn.prepareStatement(createDynamicProcessWorkStepInstance);){
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", createDynamicProcessWorkStepInstance, new Object[0]);
            }
            for (int ix = 0; ix < CREATE_DYNAMIC_PROCESSLIST.length; ++ix) {
                WorkStepInstanceDAO.setPreparedStatementValues(attrsList, preparedStatement, ix);
            }
            preparedStatement.executeUpdate();
        }
        catch (SQLException sqlex) {
            WorkStepInstanceDAO.handle((SQLException)sqlex);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void setPreparedStatementValues(HashMap attrsList, PreparedStatement preparedStatement, int ix) throws SQLException, CreateException {
        int index;
        Object value;
        String key;
        block24: {
            block23: {
                block22: {
                    block21: {
                        block20: {
                            block19: {
                                block18: {
                                    block17: {
                                        key = CREATE_DYNAMIC_PROCESSLIST[ix];
                                        value = attrsList.get(key);
                                        index = ix + 1;
                                        if (key.equalsIgnoreCase("TYPE")) break block17;
                                        if (key.equalsIgnoreCase("PRIORITY")) break block17;
                                        if (key.equalsIgnoreCase("STATUS")) break block17;
                                        if (key.equalsIgnoreCase("SUSPENDSTATUS")) break block17;
                                        if (!key.equalsIgnoreCase("LOOPCOUNTER")) break block18;
                                    }
                                    WorkStepInstanceDAO.setIntegerToStatement(preparedStatement, value, index);
                                    return;
                                }
                                if (key.equalsIgnoreCase("WORKSTEPNAME")) break block19;
                                if (key.equalsIgnoreCase("CREATOR")) break block19;
                                if (key.equalsIgnoreCase("PERFORMER")) break block19;
                                if (key.equalsIgnoreCase("ACTUALPERFORMER")) break block19;
                                if (key.equalsIgnoreCase("INSTRUCTION")) break block19;
                                if (key.equalsIgnoreCase("INLINEBLOCK_NAME")) break block19;
                                if (key.equalsIgnoreCase("MILESTONE_NAME")) break block19;
                                if (!key.equalsIgnoreCase("MILESTONE_DESC")) break block20;
                            }
                            WorkStepInstanceDAO.setStringToStatement(preparedStatement, value, index);
                            return;
                        }
                        if (key.equalsIgnoreCase("WORKSTEPID")) break block21;
                        if (key.equalsIgnoreCase("PROCESSTEMPLATEID")) break block21;
                        if (!key.equalsIgnoreCase("PROCESSINSTANCEID")) break block22;
                    }
                    if (value != null) {
                        preparedStatement.setLong(index, (Long)value);
                        return;
                    }
                    if (key.equalsIgnoreCase("WORKSTEPID")) {
                        Object[] objectArray = new Object[2];
                        objectArray[0] = "WORKSTEPID";
                        objectArray[1] = WORKSTEPINSTANCE;
                        throw new CreateException(BLControl.msgFactory.lookup(BIZ_LOGIC_ERR_1588, objectArray));
                    }
                    if (key.equalsIgnoreCase("PROCESSINSTANCEID")) {
                        Object[] objectArray = new Object[2];
                        objectArray[0] = "PROCESSINSTANCEID";
                        objectArray[1] = WORKSTEPINSTANCE;
                        throw new CreateException(BLControl.msgFactory.lookup(BIZ_LOGIC_ERR_1588, objectArray));
                    }
                    preparedStatement.setNull(index, -5);
                    return;
                }
                if (key.equalsIgnoreCase("DUEDATE")) break block23;
                if (key.equalsIgnoreCase("STARTTIME")) break block23;
                if (!key.equalsIgnoreCase("ENDTIME")) break block24;
            }
            if (value == null) {
                preparedStatement.setNull(index, -5);
                return;
            }
            WorkStepInstanceDAO.setDateValue((PreparedStatement)preparedStatement, (int)index, (long)((Long)value));
            return;
        }
        if (key.equalsIgnoreCase("DATASLOTCOPIES")) {
            WorkStepInstanceDAO.setVarbinaryToStatement(preparedStatement, value, index);
            return;
        }
        if (!key.equalsIgnoreCase("MONITOR_STEP")) return;
        WorkStepInstanceDAO.setBooleanToStatement(preparedStatement, value, index);
    }

    private static void setBooleanToStatement(PreparedStatement pstmtCreateDynamicProcessWorkStepInstance, Object value, int index) throws SQLException {
        if (value == null) {
            pstmtCreateDynamicProcessWorkStepInstance.setNull(index, 4);
        } else {
            pstmtCreateDynamicProcessWorkStepInstance.setInt(index, (Boolean)value != false ? 1 : 0);
        }
    }

    private static void setVarbinaryToStatement(PreparedStatement pstmtCreateDynamicProcessWorkStepInstance, Object value, int index) throws SQLException {
        if (value == null) {
            pstmtCreateDynamicProcessWorkStepInstance.setNull(index, -3);
        } else {
            try (ByteArrayInputStream contextInsert = new ByteArrayInputStream(WorkStepInstanceDAO.convertToBytes((Object)value));){
                pstmtCreateDynamicProcessWorkStepInstance.setBinaryStream(index, (InputStream)contextInsert, contextInsert.available());
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
    }

    private static void setStringToStatement(PreparedStatement pstmtCreateDynamicProcessWorkStepInstance, Object value, int index) throws SQLException {
        if (value == null) {
            pstmtCreateDynamicProcessWorkStepInstance.setNull(index, 12);
        } else {
            pstmtCreateDynamicProcessWorkStepInstance.setString(index, (String)value);
        }
    }

    private static void setIntegerToStatement(PreparedStatement preparedStatement, Object value, int index) throws SQLException {
        if (value == null) {
            preparedStatement.setNull(index, 4);
        } else {
            preparedStatement.setInt(index, (Integer)value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static WorkStepInstancePK findByPrimaryKey(WorkStepInstancePK primaryKey) throws ObjectNotFoundException {
        Connection conn = null;
        PreparedStatement pstmtFindByPrimaryKey = null;
        ResultSet rs = null;
        try {
            conn = WorkStepInstanceDAO.getConnection();
            pstmtFindByPrimaryKey = conn.prepareStatement(findByPrimaryKey);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", findByPrimaryKey, new Object[0]);
            }
            pstmtFindByPrimaryKey.setLong(1, primaryKey.processinstanceID);
            pstmtFindByPrimaryKey.setLong(2, primaryKey.id);
            rs = pstmtFindByPrimaryKey.executeQuery();
            if (!rs.next()) {
                throw new ObjectNotFoundException(BLControl.msgFactory.lookup("BizLogic_ERR_9101", new Object[]{WORKSTEPINSTANCE, primaryKey.processinstanceID, primaryKey.id}));
            }
            WorkStepInstanceDAO.clean((ResultSet)rs, (Statement)pstmtFindByPrimaryKey, (Connection)conn);
            return primaryKey;
        }
        catch (ObjectNotFoundException finderEx) {
            throw finderEx;
            catch (Throwable th) {
                WorkStepInstanceDAO.handle((Throwable)th);
                return primaryKey;
            }
        }
        finally {
            WorkStepInstanceDAO.clean(rs, (Statement)pstmtFindByPrimaryKey, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection findByStatus(int[] status) {
        Vector<WorkStepInstancePK> primaryKeys = new Vector<WorkStepInstancePK>();
        StringBuffer mainClause = new StringBuffer(findNoWhere);
        DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
        mainClause.append("STATUS");
        mainClause.append("in (");
        for (int ix = 0; ix < status.length; ++ix) {
            mainClause.append(String.valueOf(status[ix]));
            if (ix == status.length - 1) {
                mainClause.append(CLOSE_PARENTHESIS);
                continue;
            }
            mainClause.append(COMMA_SPACE);
        }
        Connection conn = null;
        PreparedStatement pstmtFindByStatus = null;
        ResultSet rs = null;
        try {
            conn = WorkStepInstanceDAO.getConnection();
            pstmtFindByStatus = conn.prepareStatement(mainClause.toString());
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", mainClause.toString(), new Object[0]);
            }
            rs = pstmtFindByStatus.executeQuery();
            while (rs.next()) {
                primaryKeys.addElement(new WorkStepInstancePK(rs.getLong(1), rs.getLong(2)));
            }
        }
        catch (Throwable th) {
            try {
                WorkStepInstanceDAO.handle((Throwable)th);
            }
            catch (Throwable throwable) {
                WorkStepInstanceDAO.clean(rs, pstmtFindByStatus, (Connection)conn);
                throw throwable;
            }
            WorkStepInstanceDAO.clean(rs, (Statement)pstmtFindByStatus, (Connection)conn);
        }
        WorkStepInstanceDAO.clean((ResultSet)rs, (Statement)pstmtFindByStatus, (Connection)conn);
        return primaryKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(WorkStepInstanceEBBBean wsEB, WorkStepInstancePK primaryKey) {
        Connection conn = null;
        PreparedStatement pstmtLoadWorkStepInstance = null;
        ResultSet rs = null;
        try {
            conn = WorkStepInstanceDAO.getConnection();
            pstmtLoadWorkStepInstance = conn.prepareStatement(loadWorkStepInstance);
            pstmtLoadWorkStepInstance.setLong(1, primaryKey.processinstanceID);
            pstmtLoadWorkStepInstance.setLong(2, primaryKey.id);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1207", new Object[]{loadWorkStepInstance, WorkStepInstanceDAO.getPrimaryKey(primaryKey)});
            }
            if (!(rs = pstmtLoadWorkStepInstance.executeQuery()).next()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = primaryKey.id;
                objectArray[1] = primaryKey.processinstanceID;
                DBConstants.TableConstants cfr_ignored_0 = BLControl.dbconsts.tab;
                objectArray[2] = "BIZLOGIC_WORKSTEPINSTANCE";
                throw new BizLogicException("BizLogic_ERR_3683", "WorkStepInstanceDAO.load", objectArray);
            }
            wsEB.processInstanceID = rs.getLong(1);
            wsEB.id = rs.getLong(2);
            wsEB.processTemplateID = rs.getLong(3);
            wsEB.type = rs.getInt(4);
            wsEB.priority = rs.getInt(5);
            wsEB.state = rs.getInt(6);
            wsEB.previousState = rs.getInt(7);
            wsEB.suspendState = rs.getInt(8);
            wsEB.suspendedByCompensatory = rs.getInt(9);
            wsEB.loopcounter = rs.getInt(10);
            wsEB.name = rs.getString(11);
            wsEB.creator = rs.getString(12);
            wsEB.performer = rs.getString(13);
            wsEB.actualPerformer = rs.getString(14);
            String instruction = rs.getString(15);
            if (instruction != null) {
                if (instruction.startsWith("@")) {
                    String dsName = BLControl.util.cutoutSlotName(instruction);
                    WFProcessContext pCtx = new WFProcessContext(null, wsEB.processTemplateID, wsEB.processInstanceID);
                    instruction = (String)pCtx.getSlotValue(dsName);
                }
            }
            wsEB.instruction = instruction;
            wsEB.expectArrivals = rs.getString(16);
            wsEB.timeStarted = WorkStepInstanceDAO.getDateValue((ResultSet)rs, (int)17);
            wsEB.timeCompleted = WorkStepInstanceDAO.getDateValue((ResultSet)rs, (int)18);
            wsEB.duedate = WorkStepInstanceDAO.getDateValue((ResultSet)rs, (int)19);
            wsEB.subProcessInstanceID = rs.getLong(20);
            wsEB.isSubProcessActivated = rs.getInt(21);
            wsEB.duration = rs.getLong(22);
            wsEB.dataslotCopies = null;
            wsEB.inlineBlockName = rs.getString(23);
            wsEB.milestoneName = rs.getString(24);
            wsEB.milestoneDesc = rs.getString(25);
            wsEB.isMonitorStep = rs.getInt(26) == 1;
            WorkStepInstanceDAO.clean((ResultSet)rs, (Statement)pstmtLoadWorkStepInstance, (Connection)conn);
        }
        catch (Exception ex) {
            wsEB.handleEBEx("WSEB:load", primaryKey, ex);
            WorkStepInstanceDAO.handle((Throwable)ex);
        }
        finally {
            WorkStepInstanceDAO.clean(rs, (Statement)pstmtLoadWorkStepInstance, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store(WorkStepInstanceEBBBean wsEB, WorkStepInstancePK primaryKey, HashMap modifiedAttrs) {
        Connection conn = null;
        PreparedStatement pstmtStoreWorkStepInstance = null;
        int attrsCount = modifiedAttrs.size();
        StringBuffer sb = new StringBuffer(300);
        DBConstants.TableConstants cfr_ignored_0 = BLControl.dbconsts.tab;
        sb.append("update ").append("BIZLOGIC_WORKSTEPINSTANCE");
        WorkStepInstanceDAO.addRowlockHint((StringBuffer)sb);
        sb.append(" set ");
        Iterator keySet = modifiedAttrs.keySet().iterator();
        String key = null;
        Object value = null;
        int counter = 0;
        while (keySet.hasNext()) {
            key = (String)keySet.next();
            sb.append(key);
            sb.append(SPACE_EQUALS_QUESTION);
            if (counter != attrsCount - 1) {
                sb.append(COMMA_SPACE);
            }
            ++counter;
        }
        sb.append(WHERE);
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID");
        sb.append(QUESTION_SMALL_AND);
        DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
        sb.append("WORKSTEP_ID");
        sb.append(SPACE_EQUALS_QUESTION);
        String storeWorkStepInstance = sb.toString();
        try {
            conn = WorkStepInstanceDAO.getConnection();
            pstmtStoreWorkStepInstance = conn.prepareStatement(storeWorkStepInstance);
            keySet = modifiedAttrs.keySet().iterator();
            key = null;
            value = null;
            counter = 1;
            while (keySet.hasNext()) {
                block41: {
                    block40: {
                        block39: {
                            block38: {
                                block37: {
                                    block36: {
                                        block35: {
                                            block34: {
                                                block33: {
                                                    block32: {
                                                        key = (String)keySet.next();
                                                        value = modifiedAttrs.get(key);
                                                        if (key.equalsIgnoreCase("WORKSTEPID")) break block32;
                                                        if (key.equalsIgnoreCase("PROCESSTEMPLATEID")) break block32;
                                                        if (key.equalsIgnoreCase("PROCESSINSTANCEID")) break block32;
                                                        if (key.equalsIgnoreCase("TYPE")) break block32;
                                                        if (key.equalsIgnoreCase("WORKSTEPNAME")) break block32;
                                                        if (!key.equalsIgnoreCase("CREATOR")) break block33;
                                                    }
                                                    throw new BizLogicException("BizLogic_ERR_1587", "WorkItemInstanceDAO.store", new Object[]{key, "WorkStepInstance"});
                                                }
                                                if (key.equalsIgnoreCase("PRIORITY")) break block34;
                                                if (key.equalsIgnoreCase("STATUS")) break block34;
                                                if (key.equalsIgnoreCase("SUSPENDSTATUS")) break block34;
                                                if (key.equalsIgnoreCase("ISSUSPENDEDBYCOMP")) break block34;
                                                if (key.equalsIgnoreCase("ISSUBPIACTIVATED")) break block34;
                                                if (key.equalsIgnoreCase("LOOPCOUNTER")) break block34;
                                                if (!key.equalsIgnoreCase("PREVIOUSSTATUS")) break block35;
                                            }
                                            if (value == null) {
                                                pstmtStoreWorkStepInstance.setNull(counter++, 4);
                                                continue;
                                            }
                                            pstmtStoreWorkStepInstance.setInt(counter++, (Integer)value);
                                            continue;
                                        }
                                        if (key.equalsIgnoreCase("PERFORMER")) break block36;
                                        if (key.equalsIgnoreCase("INSTRUCTION")) break block36;
                                        if (key.equalsIgnoreCase("ACTUALPERFORMER")) break block36;
                                        if (key.equalsIgnoreCase("EXPECTARRIVALS")) break block36;
                                        if (key.equalsIgnoreCase("INLINEBLOCK_NAME")) break block36;
                                        if (key.equalsIgnoreCase("MILESTONE_NAME")) break block36;
                                        if (!key.equalsIgnoreCase("MILESTONE_DESC")) break block37;
                                    }
                                    if (value == null) {
                                        pstmtStoreWorkStepInstance.setNull(counter++, 12);
                                        continue;
                                    }
                                    pstmtStoreWorkStepInstance.setString(counter++, value);
                                    continue;
                                }
                                if (key.equalsIgnoreCase("SUBPIID")) break block38;
                                if (!key.equalsIgnoreCase("DURATION")) break block39;
                            }
                            if (value == null) {
                                pstmtStoreWorkStepInstance.setNull(counter++, -5);
                                continue;
                            }
                            pstmtStoreWorkStepInstance.setLong(counter++, (Long)value);
                            continue;
                        }
                        if (key.equalsIgnoreCase("DUEDATE")) break block40;
                        if (key.equalsIgnoreCase("ENDTIME")) break block40;
                        if (!key.equalsIgnoreCase("STARTTIME")) break block41;
                    }
                    if (value == null) {
                        pstmtStoreWorkStepInstance.setNull(counter++, -5);
                        continue;
                    }
                    WorkStepInstanceDAO.setDateValue((PreparedStatement)pstmtStoreWorkStepInstance, (int)counter++, (long)((Long)value).longValue());
                    continue;
                }
                if (key.equalsIgnoreCase("DATASLOTCOPIES")) {
                    if (value == null) {
                        pstmtStoreWorkStepInstance.setNull(counter++, -3);
                        continue;
                    }
                    ByteArrayInputStream contextInsert = new ByteArrayInputStream(WorkStepInstanceDAO.convertToBytes(value));
                    pstmtStoreWorkStepInstance.setBinaryStream(counter++, (InputStream)contextInsert, contextInsert.available());
                    continue;
                }
                if (!key.equalsIgnoreCase("MONITOR_STEP")) continue;
                if (value == null) {
                    pstmtStoreWorkStepInstance.setNull(counter++, 4);
                    continue;
                }
                pstmtStoreWorkStepInstance.setInt(counter++, (Boolean)value != false ? 1 : 0);
            }
            pstmtStoreWorkStepInstance.setLong(counter++, primaryKey.processinstanceID);
            pstmtStoreWorkStepInstance.setLong(counter, primaryKey.id);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1207", new Object[]{storeWorkStepInstance, WorkStepInstanceDAO.getPrimaryKey(primaryKey)});
            }
            pstmtStoreWorkStepInstance.executeUpdate();
        }
        catch (Exception ex) {
            wsEB.handleEBEx("WSEB:store", primaryKey, ex);
            WorkStepInstanceDAO.handle((Throwable)ex);
        }
        finally {
            WorkStepInstanceDAO.clean(null, (Statement)pstmtStoreWorkStepInstance, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(WorkStepInstancePK primaryKey) {
        Connection conn = null;
        PreparedStatement pstmtRemoveWorkStepInstance = null;
        try {
            conn = WorkStepInstanceDAO.getConnection();
            pstmtRemoveWorkStepInstance = conn.prepareStatement(removeWorkStepInstance);
            pstmtRemoveWorkStepInstance.setLong(1, primaryKey.processinstanceID);
            pstmtRemoveWorkStepInstance.setLong(2, primaryKey.id);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1207", new Object[]{removeWorkStepInstance, WorkStepInstanceDAO.getPrimaryKey(primaryKey)});
            }
            pstmtRemoveWorkStepInstance.executeUpdate();
        }
        catch (Throwable th) {
            WorkStepInstanceDAO.handle((Throwable)th);
        }
        finally {
            WorkStepInstanceDAO.clean(null, (Statement)pstmtRemoveWorkStepInstance, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeByProcessInstance(long piid) {
        Connection conn = null;
        PreparedStatement pstmtRemoveByProcessInstance = null;
        try {
            conn = WorkStepInstanceDAO.getConnection();
            pstmtRemoveByProcessInstance = conn.prepareStatement(removeByProcessInstance);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", removeByProcessInstance, new Object[0]);
            }
            pstmtRemoveByProcessInstance.setLong(1, piid);
            pstmtRemoveByProcessInstance.executeUpdate();
        }
        catch (Throwable th) {
            WorkStepInstanceDAO.handle((Throwable)th);
        }
        finally {
            WorkStepInstanceDAO.clean(null, (Statement)pstmtRemoveByProcessInstance, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void getDataSlotCopies(WorkStepInstanceEBBBean wsEB, WorkStepInstancePK primaryKey) {
        InputStream is;
        ResultSet rset;
        PreparedStatement pstmtGetDataSlotCopies;
        Connection conn;
        block9: {
            block8: {
                conn = null;
                pstmtGetDataSlotCopies = null;
                rset = null;
                is = null;
                try {
                    conn = WorkStepInstanceDAO.getConnection();
                    pstmtGetDataSlotCopies = conn.prepareStatement(getDataSlotCopies);
                    if (BLControl.util.DEBUG_DAO) {
                        BLControl.logger.debugKey("BizLogic_ERR_1185", getDataSlotCopies, new Object[0]);
                    }
                    pstmtGetDataSlotCopies.setLong(1, primaryKey.processinstanceID);
                    pstmtGetDataSlotCopies.setLong(2, primaryKey.id);
                    rset = pstmtGetDataSlotCopies.executeQuery();
                    if (rset.next() && (is = rset.getBinaryStream(1)) != null) {
                        Object obj = WorkStepInstanceDAO.convertToObject((InputStream)is);
                        wsEB.dataslotCopies = (HashMap)obj;
                        FileUtil.close((InputStream)is);
                        is = null;
                        break block8;
                    }
                    wsEB.dataslotCopies = null;
                    FileUtil.close((InputStream)is);
                    break block9;
                }
                catch (Exception ex) {
                    wsEB.handleEBEx("WSEB:getDataSlotCopies", primaryKey, ex);
                    WorkStepInstanceDAO.handle((Throwable)ex);
                    return;
                }
            }
            WorkStepInstanceDAO.clean((ResultSet)rset, (Statement)pstmtGetDataSlotCopies, (Connection)conn);
            return;
        }
        is = null;
        WorkStepInstanceDAO.clean((ResultSet)rset, (Statement)pstmtGetDataSlotCopies, (Connection)conn);
        return;
        finally {
            FileUtil.close(is);
            is = null;
            WorkStepInstanceDAO.clean(rset, (Statement)pstmtGetDataSlotCopies, (Connection)conn);
        }
    }

    public static String[] getActiveWorkStepNameList() {
        return WorkStepInstanceDAO.getWorkStepNameListByStatus(18, 0L, true);
    }

    public static String[] getActiveWorkStepNameList(long piid) {
        return WorkStepInstanceDAO.getWorkStepNameListByStatus(18, piid, false);
    }

    public static String[] getSuspendedWorkStepNameList() {
        return WorkStepInstanceDAO.getWorkStepNameListByStatus(16, 0L, true);
    }

    public static String[] getSuspendedWorkStepNameList(long piid) {
        return WorkStepInstanceDAO.getWorkStepNameListByStatus(16, piid, false);
    }

    public static String[] getCompletedWorkStepNameList(long piid) {
        return WorkStepInstanceDAO.getWorkStepNameListByStatus(21, piid, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getWorkStepNameListByStatus(int state, long piid, boolean isAllPI) {
        StringBuffer mainClause = new StringBuffer(getWorkStepNameListByStatus);
        if (!isAllPI) {
            mainClause.append(AND);
            DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
            mainClause.append("PROCESS_INSTANCE_ID");
            mainClause.append(SPACE_EQUALS_QUESTION_SPACE);
        }
        Connection conn = null;
        PreparedStatement pstmtGetWorkStepNameListByStatus = null;
        ResultSet rset = null;
        Vector<String> tmp = new Vector<String>();
        try {
            conn = WorkStepInstanceDAO.getConnection();
            pstmtGetWorkStepNameListByStatus = conn.prepareStatement(mainClause.toString());
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", mainClause.toString(), new Object[0]);
            }
            pstmtGetWorkStepNameListByStatus.setInt(1, state);
            if (!isAllPI) {
                pstmtGetWorkStepNameListByStatus.setLong(2, piid);
            }
            rset = pstmtGetWorkStepNameListByStatus.executeQuery();
            while (rset.next()) {
                tmp.addElement(rset.getString(1));
            }
        }
        catch (Throwable th) {
            try {
                WorkStepInstanceDAO.handle((Throwable)th);
            }
            catch (Throwable throwable) {
                WorkStepInstanceDAO.clean(rset, pstmtGetWorkStepNameListByStatus, (Connection)conn);
                throw throwable;
            }
            WorkStepInstanceDAO.clean(rset, (Statement)pstmtGetWorkStepNameListByStatus, (Connection)conn);
        }
        WorkStepInstanceDAO.clean((ResultSet)rset, (Statement)pstmtGetWorkStepNameListByStatus, (Connection)conn);
        return BLUtil.Vector2String(tmp);
    }

    public static Collection getActiveWorkStepPrimaryKeyList() {
        return WorkStepInstanceDAO.getWorkStepPrimaryKeyListByStatus(18, 0L, true, null);
    }

    public static Collection getActiveWorkStepPrimaryKeyList(long piid) {
        return WorkStepInstanceDAO.getWorkStepPrimaryKeyListByStatus(18, piid, false, null);
    }

    public static Collection getSuspendedWorkStepPrimaryKeyList() {
        return WorkStepInstanceDAO.getWorkStepPrimaryKeyListByStatus(16, 0L, true, null);
    }

    public static Collection getSuspendedWorkStepPrimaryKeyList(long piid) {
        return WorkStepInstanceDAO.getWorkStepPrimaryKeyListByStatus(16, piid, false, null);
    }

    public static Collection getActiveWorkStepPrimaryKeyList(int[] wsTypes) {
        return WorkStepInstanceDAO.getWorkStepPrimaryKeyListByStatus(18, 0L, true, wsTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCount(long piid, int[] wsStates, int[] wsTypes) {
        int wsCount;
        ResultSet rset;
        PreparedStatement pstmtGetCount;
        Connection conn;
        block7: {
            StringBuffer mainClause = new StringBuffer(getCount);
            if (wsStates != null && wsStates.length > 0) {
                mainClause.append(AND);
                DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
                mainClause.append("STATUS");
                mainClause.append(WorkStepInstanceDAO.getSQLCondition((int[])wsStates));
            }
            if (wsTypes != null && wsTypes.length > 0) {
                mainClause.append(AND);
                DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
                mainClause.append("TYPE");
                mainClause.append(WorkStepInstanceDAO.getSQLCondition((int[])wsTypes));
            }
            conn = null;
            pstmtGetCount = null;
            rset = null;
            wsCount = 0;
            try {
                conn = WorkStepInstanceDAO.getConnection();
                pstmtGetCount = conn.prepareStatement(mainClause.toString());
                if (BLControl.util.DEBUG_DAO) {
                    BLControl.logger.debugKey("BizLogic_ERR_1185", mainClause.toString(), new Object[0]);
                }
                pstmtGetCount.setLong(1, piid);
                rset = pstmtGetCount.executeQuery();
                if (!rset.next()) break block7;
                wsCount = rset.getInt(1);
            }
            catch (Throwable th) {
                try {
                    WorkStepInstanceDAO.handle((Throwable)th);
                }
                catch (Throwable throwable) {
                    WorkStepInstanceDAO.clean(rset, pstmtGetCount, (Connection)conn);
                    throw throwable;
                }
                WorkStepInstanceDAO.clean(rset, (Statement)pstmtGetCount, (Connection)conn);
            }
        }
        WorkStepInstanceDAO.clean((ResultSet)rset, (Statement)pstmtGetCount, (Connection)conn);
        return wsCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection getWorkStepPrimaryKeyListByStatus(int state, long piid, boolean isAllPI, int[] wsTypes) {
        StringBuffer mainClause = new StringBuffer(getWorkStepPrimaryKeyListByStatus);
        if (!isAllPI) {
            mainClause.append(AND);
            DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
            mainClause.append("PROCESS_INSTANCE_ID");
            mainClause.append(SPACE_EQUALS_QUESTION_SPACE);
        }
        if (wsTypes != null && wsTypes.length > 0) {
            mainClause.append(AND);
            DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
            mainClause.append("TYPE");
            mainClause.append(WorkStepInstanceDAO.getSQLCondition((int[])wsTypes));
        }
        Connection conn = null;
        PreparedStatement pstmtGetWorkStepPrimaryKeyListByStatus = null;
        ResultSet rset = null;
        Vector<WorkStepInstancePK> tmp = new Vector<WorkStepInstancePK>();
        int counter = 0;
        try {
            conn = WorkStepInstanceDAO.getConnection();
            pstmtGetWorkStepPrimaryKeyListByStatus = conn.prepareStatement(mainClause.toString());
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", mainClause.toString(), new Object[0]);
            }
            pstmtGetWorkStepPrimaryKeyListByStatus.setInt(++counter, state);
            if (!isAllPI) {
                pstmtGetWorkStepPrimaryKeyListByStatus.setLong(++counter, piid);
            }
            rset = pstmtGetWorkStepPrimaryKeyListByStatus.executeQuery();
            while (rset.next()) {
                WorkStepInstancePK primaryKey = new WorkStepInstancePK(rset.getLong(1), rset.getLong(2));
                tmp.addElement(primaryKey);
            }
        }
        catch (Throwable th) {
            try {
                WorkStepInstanceDAO.handle((Throwable)th);
            }
            catch (Throwable throwable) {
                WorkStepInstanceDAO.clean(rset, pstmtGetWorkStepPrimaryKeyListByStatus, (Connection)conn);
                throw throwable;
            }
            WorkStepInstanceDAO.clean(rset, (Statement)pstmtGetWorkStepPrimaryKeyListByStatus, (Connection)conn);
        }
        WorkStepInstanceDAO.clean((ResultSet)rset, (Statement)pstmtGetWorkStepPrimaryKeyListByStatus, (Connection)conn);
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection getPKListOrderedByStartTime(int state, int[] wsTypes) {
        StringBuffer mainClause = new StringBuffer(getWorkStepPrimaryKeyListByStatus);
        if (wsTypes != null && wsTypes.length > 0) {
            mainClause.append(AND);
            DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
            mainClause.append("TYPE");
            mainClause.append(WorkStepInstanceDAO.getSQLCondition((int[])wsTypes));
        }
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        mainClause.append(" ORDER BY ").append("STARTTIME");
        if (ServiceLocator.self().isDB2()) {
            WorkStepInstanceDAO.addReadUncommittedHint((StringBuffer)mainClause);
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rset = null;
        Vector<WorkStepInstancePK> pkList = new Vector<WorkStepInstancePK>();
        try {
            conn = WorkStepInstanceDAO.getConnection();
            pstmt = conn.prepareStatement(mainClause.toString());
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", mainClause.toString(), new Object[0]);
            }
            pstmt.setInt(1, state);
            rset = pstmt.executeQuery();
            while (rset.next()) {
                WorkStepInstancePK primaryKey = new WorkStepInstancePK(rset.getLong(1), rset.getLong(2));
                pkList.addElement(primaryKey);
            }
        }
        catch (Throwable th) {
            try {
                WorkStepInstanceDAO.handle((Throwable)th);
            }
            catch (Throwable throwable) {
                WorkStepInstanceDAO.clean(rset, pstmt, (Connection)conn);
                throw throwable;
            }
            WorkStepInstanceDAO.clean(rset, (Statement)pstmt, (Connection)conn);
        }
        WorkStepInstanceDAO.clean((ResultSet)rset, (Statement)pstmt, (Connection)conn);
        return pkList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getPKListForRestartExternalService() {
        StringBuffer mainClause = new StringBuffer(getPKListForRestartExternalService);
        if (ServiceLocator.self().isDB2()) {
            WorkStepInstanceDAO.addReadUncommittedHint((StringBuffer)mainClause);
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rset = null;
        Vector<long[]> pkList = new Vector<long[]>();
        try {
            conn = WorkStepInstanceDAO.getConnection();
            pstmt = conn.prepareStatement(mainClause.toString());
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", mainClause.toString(), new Object[0]);
            }
            rset = pstmt.executeQuery();
            while (rset.next()) {
                long[] wsDetails = new long[]{rset.getLong(1), rset.getLong(2), rset.getInt(3), rset.getInt(4)};
                pkList.add(wsDetails);
            }
        }
        catch (Throwable th) {
            try {
                WorkStepInstanceDAO.handle((Throwable)th);
            }
            catch (Throwable throwable) {
                WorkStepInstanceDAO.clean(rset, pstmt, (Connection)conn);
                throw throwable;
            }
            WorkStepInstanceDAO.clean(rset, (Statement)pstmt, (Connection)conn);
        }
        WorkStepInstanceDAO.clean((ResultSet)rset, (Statement)pstmt, (Connection)conn);
        return pkList;
    }

    public static Vector getWorkStepInstanceList(long[] ptIDs, long[] piIDs, int[] status, String creator, boolean readOnly) {
        return WorkStepInstanceDAO.getWorkStepInstanceList(ptIDs, piIDs, status, null, creator, readOnly, false);
    }

    public static Vector getWorkStepInstanceList(long[] ptIDs, long[] piIDs, int[] status, int[] type, String creator, boolean readOnly) {
        return WorkStepInstanceDAO.getWorkStepInstanceList(ptIDs, piIDs, status, type, creator, readOnly, false);
    }

    public static Vector getWorkStepInstanceList(long[] ptIDs, long[] piIDs, int[] status, int[] type, String creator, boolean readOnly, boolean orderByPiid) {
        return WorkStepInstanceDAO.getWorkStepInstanceList(ptIDs, piIDs, status, type, creator, readOnly, orderByPiid, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getWorkStepInstanceList(long[] ptIDs, long[] piIDs, int[] status, int[] type, String creator, boolean readOnly, boolean orderByPiid, boolean inlcudeInlineActivities) {
        Vector wsiList = new Vector();
        int ix = 0;
        boolean hasCondition = false;
        StringBuffer mainClause = new StringBuffer(getWorkStepInstanceList);
        StringBuffer whereClause = new StringBuffer(" WHERE ");
        if (ptIDs != null && ptIDs.length > 0) {
            DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
            whereClause.append(PREFIX_WSI).append("PROCESS_TEMPLATE_ID");
            if (ptIDs.length == 1) {
                whereClause.append(SPACE_EQUALS_QUESTION_SPACE);
            } else {
                whereClause.append(" IN (");
                for (ix = 0; ix < ptIDs.length; ++ix) {
                    whereClause.append(String.valueOf(ptIDs[ix]));
                    if (ix < ptIDs.length - 1) {
                        whereClause.append(COMMA_SPACE);
                        continue;
                    }
                    whereClause.append(") ");
                }
            }
            hasCondition = true;
        }
        if (!hasCondition && piIDs != null && piIDs.length > 0) {
            DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
            whereClause.append(PREFIX_WSI).append("PROCESS_INSTANCE_ID");
            if (piIDs.length == 1) {
                whereClause.append(SPACE_EQUALS_QUESTION_SPACE);
            } else {
                whereClause.append(" IN (");
                for (ix = 0; ix < piIDs.length; ++ix) {
                    whereClause.append(String.valueOf(piIDs[ix]));
                    if (ix < piIDs.length - 1) {
                        whereClause.append(COMMA_SPACE);
                        continue;
                    }
                    whereClause.append(") ");
                }
            }
            hasCondition = true;
        }
        if (status != null && status.length > 0) {
            if (hasCondition) {
                whereClause.append(AND);
            }
            DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
            whereClause.append(PREFIX_WSI).append("STATUS");
            if (status.length == 1) {
                whereClause.append(SPACE_EQUALS_QUESTION_SPACE);
            } else {
                whereClause.append(" IN (");
                for (ix = 0; ix < status.length; ++ix) {
                    whereClause.append(String.valueOf(status[ix]));
                    if (ix < status.length - 1) {
                        whereClause.append(COMMA_SPACE);
                        continue;
                    }
                    whereClause.append(") ");
                }
            }
            hasCondition = true;
        }
        if (type != null && type.length > 0) {
            if (hasCondition) {
                whereClause.append(AND);
            }
            DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
            whereClause.append(PREFIX_WSI).append("TYPE");
            if (type.length == 1) {
                whereClause.append(SPACE_EQUALS_QUESTION_SPACE);
            } else {
                whereClause.append(" IN (");
                for (ix = 0; ix < type.length; ++ix) {
                    whereClause.append(String.valueOf(type[ix]));
                    if (ix < type.length - 1) {
                        whereClause.append(COMMA_SPACE);
                        continue;
                    }
                    whereClause.append(") ");
                }
            }
            hasCondition = true;
        }
        if (creator != null) {
            if (hasCondition) {
                whereClause.append(AND);
            }
            if (BLUtil.isUserManagerCaseSensitive()) {
                DBConstants.ColConstants cfr_ignored_4 = BLControl.dbconsts.col;
                whereClause.append(PREFIX_PI).append("CREATOR");
                whereClause.append(SPACE_EQUALS_QUESTION_SPACE);
            } else {
                BLConstants.single();
                whereClause.append("lower(");
                DBConstants.ColConstants cfr_ignored_5 = BLControl.dbconsts.col;
                whereClause.append(PREFIX_PI).append("CREATOR");
                whereClause.append(") = ? ");
            }
            hasCondition = true;
        }
        if (hasCondition) {
            whereClause.append(AND);
        }
        if (!inlcudeInlineActivities) {
            DBConstants.ColConstants cfr_ignored_6 = BLControl.dbconsts.col;
            whereClause.append("INLINEBLOCK_NAME");
            whereClause.append(" IS NULL AND ");
        }
        whereClause.append(joinWhereClause);
        mainClause.append(whereClause.toString());
        if (orderByPiid) {
            mainClause.append(ORDER_BY_CLAUSE);
        }
        Connection conn = null;
        PreparedStatement pstmtGetWorkStepInstanceList = null;
        ResultSet rs = null;
        try {
            conn = WorkStepInstanceDAO.getConnection((boolean)readOnly);
            pstmtGetWorkStepInstanceList = conn.prepareStatement(mainClause.toString());
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", mainClause.toString(), new Object[0]);
            }
            int i = 1;
            if (ptIDs != null && ptIDs.length == 1) {
                pstmtGetWorkStepInstanceList.setLong(i++, ptIDs[0]);
            }
            if ((ptIDs == null || ptIDs.length == 0) && piIDs != null && piIDs.length == 1) {
                pstmtGetWorkStepInstanceList.setLong(i++, piIDs[0]);
            }
            if (status != null && status.length == 1) {
                pstmtGetWorkStepInstanceList.setInt(i++, status[0]);
            }
            if (type != null && type.length == 1) {
                pstmtGetWorkStepInstanceList.setInt(i++, type[0]);
            }
            if (creator != null) {
                if (BLUtil.isUserManagerCaseSensitive()) {
                    pstmtGetWorkStepInstanceList.setString(i, creator);
                } else {
                    pstmtGetWorkStepInstanceList.setString(i, creator.toLowerCase());
                }
            }
            rs = pstmtGetWorkStepInstanceList.executeQuery();
            while (rs.next()) {
                HashMap<String, Object> attrs = new HashMap<String, Object>();
                ix = 0;
                attrs.put(CLIENT_ATTR_LIST[ix++], rs.getLong(1));
                attrs.put(CLIENT_ATTR_LIST[ix++], rs.getLong(2));
                attrs.put(CLIENT_ATTR_LIST[ix++], rs.getLong(3));
                attrs.put(CLIENT_ATTR_LIST[ix++], rs.getInt(4));
                attrs.put(CLIENT_ATTR_LIST[ix++], rs.getInt(5));
                attrs.put(CLIENT_ATTR_LIST[ix++], rs.getInt(6));
                attrs.put(CLIENT_ATTR_LIST[ix++], rs.getString(7));
                attrs.put(CLIENT_ATTR_LIST[ix++], rs.getString(8));
                attrs.put(CLIENT_ATTR_LIST[ix++], rs.getString(9));
                attrs.put(CLIENT_ATTR_LIST[ix++], rs.getString(10));
                attrs.put(CLIENT_ATTR_LIST[ix++], WorkStepInstanceDAO.getDateValue((ResultSet)rs, (int)11));
                attrs.put(CLIENT_ATTR_LIST[ix++], WorkStepInstanceDAO.getDateValue((ResultSet)rs, (int)12));
                attrs.put(CLIENT_ATTR_LIST[ix++], WorkStepInstanceDAO.getDateValue((ResultSet)rs, (int)13));
                attrs.put(CLIENT_ATTR_LIST[ix++], rs.getInt(14));
                attrs.put(CLIENT_ATTR_LIST[ix++], rs.getString(15));
                attrs.put(CLIENT_ATTR_LIST[ix++], rs.getInt(16));
                attrs.put(CLIENT_ATTR_LIST[ix++], rs.getLong(17));
                attrs.put(CLIENT_ATTR_LIST[ix++], rs.getString(18));
                attrs.put(CLIENT_ATTR_LIST[ix++], rs.getString(19));
                attrs.put(CLIENT_ATTR_LIST[ix++], rs.getString(20));
                attrs.put(CLIENT_ATTR_LIST[ix++], rs.getInt(21) == 1);
                attrs.put(CLIENT_ATTR_LIST[ix++], rs.getString(22));
                attrs.put(CLIENT_ATTR_LIST[ix++], rs.getLong(23));
                attrs.put(CLIENT_ATTR_LIST[ix++], rs.getInt(24));
                wsiList.addElement(attrs);
            }
        }
        catch (Throwable th) {
            try {
                WorkStepInstanceDAO.handle((Throwable)th);
            }
            catch (Throwable throwable) {
                WorkStepInstanceDAO.clean(rs, pstmtGetWorkStepInstanceList, (Connection)conn);
                throw throwable;
            }
            WorkStepInstanceDAO.clean(rs, (Statement)pstmtGetWorkStepInstanceList, (Connection)conn);
        }
        WorkStepInstanceDAO.clean((ResultSet)rs, (Statement)pstmtGetWorkStepInstanceList, (Connection)conn);
        return wsiList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getWorkstepState(long piid, long wsid) {
        Connection conn = null;
        PreparedStatement pstmtGetWorkstepState = null;
        ResultSet rset = null;
        int state = -1;
        try {
            conn = WorkStepInstanceDAO.getConnection();
            pstmtGetWorkstepState = conn.prepareStatement(getWorkstepState);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", getWorkstepState, new Object[0]);
            }
            pstmtGetWorkstepState.setLong(1, piid);
            pstmtGetWorkstepState.setLong(2, wsid);
            rset = pstmtGetWorkstepState.executeQuery();
            while (rset.next()) {
                state = rset.getInt(1);
            }
        }
        catch (Throwable th) {
            try {
                WorkStepInstanceDAO.handle((Throwable)th);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                WorkStepInstanceDAO.clean(rset, (Statement)pstmtGetWorkstepState, (Connection)conn);
            }
        }
        WorkStepInstanceDAO.clean((ResultSet)rset, (Statement)pstmtGetWorkstepState, (Connection)conn);
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getWorkstepState(long piid, long wsid, int loopCounter) {
        Connection conn = null;
        PreparedStatement pstmtGetWorkstepState = null;
        ResultSet rset = null;
        int state = -1;
        try {
            conn = WorkStepInstanceDAO.getConnection();
            pstmtGetWorkstepState = conn.prepareStatement(getWorkstepStateByLoopCounter);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", getWorkstepState, new Object[0]);
            }
            pstmtGetWorkstepState.setLong(1, piid);
            pstmtGetWorkstepState.setLong(2, wsid);
            pstmtGetWorkstepState.setInt(3, loopCounter);
            rset = pstmtGetWorkstepState.executeQuery();
            while (rset.next()) {
                state = rset.getInt(1);
            }
        }
        catch (Throwable th) {
            try {
                WorkStepInstanceDAO.handle((Throwable)th);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                WorkStepInstanceDAO.clean(rset, (Statement)pstmtGetWorkstepState, (Connection)conn);
            }
        }
        WorkStepInstanceDAO.clean((ResultSet)rset, (Statement)pstmtGetWorkstepState, (Connection)conn);
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector findByProcessInstance(long piid, int state) {
        String sql = findByProcessInstance;
        if (state == 16) {
            StringBuffer sb = new StringBuffer(sql);
            sb.append(" and ");
            DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
            sb.append("ISSUSPENDEDBYCOMP");
            sb.append(SPACE_EQUALS_QUESTION_SPACE);
            sql = sb.toString();
        }
        Connection conn = null;
        PreparedStatement pstmtFindByProcessInstance = null;
        ResultSet rset = null;
        Vector tmp = new Vector();
        try {
            conn = WorkStepInstanceDAO.getConnection();
            pstmtFindByProcessInstance = conn.prepareStatement(sql);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", sql, new Object[0]);
            }
            pstmtFindByProcessInstance.setLong(1, piid);
            pstmtFindByProcessInstance.setInt(2, state);
            if (state == 16) {
                pstmtFindByProcessInstance.setInt(3, 0);
            }
            rset = pstmtFindByProcessInstance.executeQuery();
            HashMap<String, Number> attrs = null;
            while (rset.next()) {
                attrs = new HashMap<String, Number>();
                attrs.put("WORKSTEPID", rset.getLong(1));
                attrs.put("TYPE", rset.getInt(2));
                tmp.addElement(attrs);
            }
        }
        catch (Throwable th) {
            try {
                WorkStepInstanceDAO.handle((Throwable)th);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                WorkStepInstanceDAO.clean(rset, (Statement)pstmtFindByProcessInstance, (Connection)conn);
            }
        }
        WorkStepInstanceDAO.clean((ResultSet)rset, (Statement)pstmtFindByProcessInstance, (Connection)conn);
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap findStatusByProcessInstance(long piid) {
        String sql = findStatusByProcessInstance;
        Connection conn = null;
        PreparedStatement pstmtFindStatusByProcessInstance = null;
        ResultSet rset = null;
        HashMap<String, String> tmp = new HashMap<String, String>();
        try {
            conn = WorkStepInstanceDAO.getConnection();
            pstmtFindStatusByProcessInstance = conn.prepareStatement(sql);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", sql, new Object[0]);
            }
            pstmtFindStatusByProcessInstance.setLong(1, piid);
            rset = pstmtFindStatusByProcessInstance.executeQuery();
            while (rset.next()) {
                String wsName = new String(rset.getString(1));
                String status = BLControl.consts.wfStates[rset.getInt(2)];
                tmp.put(wsName, status);
            }
        }
        catch (Throwable th) {
            try {
                WorkStepInstanceDAO.handle((Throwable)th);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                WorkStepInstanceDAO.clean(rset, (Statement)pstmtFindStatusByProcessInstance, (Connection)conn);
            }
        }
        WorkStepInstanceDAO.clean((ResultSet)rset, (Statement)pstmtFindStatusByProcessInstance, (Connection)conn);
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getWorkStepInstanceList(long ptid, long piid, List wsidList) {
        Vector<Long> pstmtList = new Vector<Long>();
        StringBuffer sb = new StringBuffer(getMilestoneWSIList);
        sb.append(" WHERE ");
        DBConstants.TableAliasConstants cfr_ignored_0 = BLControl.dbconsts.tabalias;
        sb.append("BLWSI").append(PERIOD);
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        sb.append("PROCESS_TEMPLATE_ID");
        sb.append(SPACE_EQUALS_QUESTION_SPACE).append(AND);
        pstmtList.add(ptid);
        if (piid != -1L) {
            DBConstants.TableAliasConstants cfr_ignored_2 = BLControl.dbconsts.tabalias;
            sb.append("BLPI").append(PERIOD);
            DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
            sb.append("PROCESS_INSTANCE_ID");
            sb.append(SPACE_EQUALS_QUESTION_SPACE).append(AND);
            pstmtList.add(piid);
        }
        if (wsidList != null && !wsidList.isEmpty()) {
            DBConstants.TableAliasConstants cfr_ignored_4 = BLControl.dbconsts.tabalias;
            sb.append("BLWSI").append(PERIOD);
            DBConstants.ColConstants cfr_ignored_5 = BLControl.dbconsts.col;
            sb.append("WORKSTEP_ID");
            WorkStepInstanceDAO.appendParamToSQLCondition((StringBuffer)sb, (List)wsidList, null);
            pstmtList.addAll(wsidList);
            sb.append(AND);
        }
        DBConstants.TableAliasConstants cfr_ignored_6 = BLControl.dbconsts.tabalias;
        sb.append("BLWSI").append(PERIOD);
        DBConstants.ColConstants cfr_ignored_7 = BLControl.dbconsts.col;
        sb.append("STATUS").append(EQUALS);
        sb.append(21).append(AND);
        DBConstants.TableAliasConstants cfr_ignored_8 = BLControl.dbconsts.tabalias;
        sb.append("BLWSI").append(PERIOD);
        DBConstants.ColConstants cfr_ignored_9 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID").append(EQUALS);
        DBConstants.TableAliasConstants cfr_ignored_10 = BLControl.dbconsts.tabalias;
        sb.append("BLPI").append(PERIOD);
        DBConstants.ColConstants cfr_ignored_11 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID");
        sb.append(" ORDER BY ");
        DBConstants.TableAliasConstants cfr_ignored_12 = BLControl.dbconsts.tabalias;
        sb.append("BLPI").append(PERIOD);
        DBConstants.ColConstants cfr_ignored_13 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID").append(" ASC, ");
        DBConstants.TableAliasConstants cfr_ignored_14 = BLControl.dbconsts.tabalias;
        sb.append("BLWSI").append(PERIOD);
        DBConstants.ColConstants cfr_ignored_15 = BLControl.dbconsts.col;
        sb.append("ENDTIME").append(" DESC");
        Connection conn = null;
        PreparedStatement pstmtGetMilestoneWSIList = null;
        ResultSet rs = null;
        Vector wsiList = new Vector();
        try {
            conn = WorkStepInstanceDAO.getConnection();
            pstmtGetMilestoneWSIList = conn.prepareStatement(sb.toString());
            WorkStepInstanceDAO.setPrepStmtValues((PreparedStatement)pstmtGetMilestoneWSIList, pstmtList);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", sb.toString(), new Object[0]);
            }
            rs = pstmtGetMilestoneWSIList.executeQuery();
            while (rs.next()) {
                HashMap<String, Object> attrs = new HashMap<String, Object>();
                attrs.put(CLIENT_ATTR_LIST[0], rs.getLong(1));
                attrs.put(CLIENT_ATTR_LIST[1], rs.getLong(2));
                attrs.put(CLIENT_ATTR_LIST[2], rs.getLong(3));
                attrs.put(CLIENT_ATTR_LIST[3], rs.getInt(4));
                attrs.put(CLIENT_ATTR_LIST[4], rs.getInt(5));
                attrs.put(CLIENT_ATTR_LIST[5], rs.getInt(6));
                attrs.put(CLIENT_ATTR_LIST[6], rs.getString(7));
                attrs.put(CLIENT_ATTR_LIST[7], rs.getString(8));
                attrs.put(CLIENT_ATTR_LIST[8], rs.getString(9));
                attrs.put(CLIENT_ATTR_LIST[9], rs.getString(10));
                attrs.put(CLIENT_ATTR_LIST[10], WorkStepInstanceDAO.getDateValue((ResultSet)rs, (int)11));
                attrs.put(CLIENT_ATTR_LIST[11], WorkStepInstanceDAO.getDateValue((ResultSet)rs, (int)12));
                attrs.put(CLIENT_ATTR_LIST[12], WorkStepInstanceDAO.getDateValue((ResultSet)rs, (int)13));
                attrs.put(CLIENT_ATTR_LIST[13], rs.getInt(14));
                attrs.put(CLIENT_ATTR_LIST[14], rs.getString(15));
                attrs.put(CLIENT_ATTR_LIST[15], rs.getInt(16));
                attrs.put(CLIENT_ATTR_LIST[16], rs.getLong(17));
                attrs.put(CLIENT_ATTR_LIST[17], rs.getString(18));
                attrs.put(CLIENT_ATTR_LIST[18], rs.getString(19));
                attrs.put(CLIENT_ATTR_LIST[19], rs.getString(20));
                attrs.put(CLIENT_ATTR_LIST[19], rs.getInt(21) == 1);
                attrs.put(CLIENT_ATTR_LIST[20], rs.getString(22));
                attrs.put(CLIENT_ATTR_LIST[21], rs.getLong(23));
                wsiList.addElement(attrs);
            }
        }
        catch (Throwable th) {
            try {
                WorkStepInstanceDAO.handle((Throwable)th);
            }
            catch (Throwable throwable) {
                WorkStepInstanceDAO.clean(rs, pstmtGetMilestoneWSIList, (Connection)conn);
                throw throwable;
            }
            WorkStepInstanceDAO.clean(rs, (Statement)pstmtGetMilestoneWSIList, (Connection)conn);
        }
        WorkStepInstanceDAO.clean((ResultSet)rs, (Statement)pstmtGetMilestoneWSIList, (Connection)conn);
        return wsiList;
    }

    public static synchronized void initSQLStatements() {
        WorkStepInstanceDAO.initSqlStatementCreateWorkStepInstance();
        WorkStepInstanceDAO.initSqlStatementLoadWorkStepInstance();
        WorkStepInstanceDAO.initSqlStatementFindNoWhere();
        WorkStepInstanceDAO.initSqlStatementFindByPrimaryKey();
        WorkStepInstanceDAO.initSqlStatementRemoveWorkStepInstance();
        WorkStepInstanceDAO.initSqlStatementGetDataSlotCopies();
        WorkStepInstanceDAO.initSqlStatementGetWorkStepNameListByStatus();
        WorkStepInstanceDAO.initSqlStatementGetWorkStepPrimaryKeyListByStatus();
        WorkStepInstanceDAO.initSqlStatementGetPKListForRestartExternalService();
        WorkStepInstanceDAO.initSqlStatementGetWorkStepInstanceList();
        WorkStepInstanceDAO.initSqlStatementGetMilestoneWSIList();
        WorkStepInstanceDAO.initSqlStatementJoinWhereClause();
        WorkStepInstanceDAO.initSqlStatementFindByProcessInstance();
        WorkStepInstanceDAO.initSqlStatementFindStatusByProcessInstance();
        WorkStepInstanceDAO.initSqlStatementCreateDynamicProcessWorkStepInstance();
        WorkStepInstanceDAO.initSqlStatementRemoveByProcessInstance();
        WorkStepInstanceDAO.initSqlStatementGetWorkStepNameListByProcessInstance();
        WorkStepInstanceDAO.initSqlStatementGetWorkstepState();
        WorkStepInstanceDAO.initSqlStatementGetWorkstepStateByLoopCounter();
        WorkStepInstanceDAO.initSqlStatementGetCount();
        WorkStepInstanceDAO.initSqlStatementGetExpectArrivals();
        WorkStepInstanceDAO.initSqlStatementGetLoopCounterAndStatus();
        WorkStepInstanceDAO.printSQLStatements();
    }

    private static void initSqlStatementCreateWorkStepInstance() {
        int ix;
        StringBuffer tmpBuffer = new StringBuffer();
        tmpBuffer.append(INSERT_INTO);
        tmpBuffer.append("BIZLOGIC_WORKSTEPINSTANCE");
        WorkStepInstanceDAO.addRowlockHint((StringBuffer)tmpBuffer);
        StringBuilder stringBuilder = new StringBuilder(tmpBuffer);
        stringBuilder.append(OPEN_PARENTHESIS);
        for (ix = 0; ix < CREATE_TABLELIST.length; ++ix) {
            stringBuilder.append(CREATE_TABLELIST[ix]);
            if (ix == CREATE_TABLELIST.length - 1) continue;
            stringBuilder.append(COMMA_SPACE);
        }
        stringBuilder.append(VALUES);
        for (ix = 0; ix < CREATE_TABLELIST.length; ++ix) {
            stringBuilder.append(QUESTION_MARK);
            if (ix == CREATE_TABLELIST.length - 1) continue;
            stringBuilder.append(COMMA_SPACE);
        }
        stringBuilder.append(CLOSE_PARENTHESIS);
        createWorkStepInstance = stringBuilder.toString();
    }

    private static void initSqlStatementLoadWorkStepInstance() {
        StringBuffer stringBuilder = new StringBuffer(380);
        stringBuilder.append(SELECT);
        for (int ix = 0; ix < LOAD_TABLELIST.length; ++ix) {
            stringBuilder.append(LOAD_TABLELIST[ix]);
            if (ix == LOAD_TABLELIST.length - 1) continue;
            stringBuilder.append(COMMA_SPACE);
        }
        stringBuilder.append(FROM).append("BIZLOGIC_WORKSTEPINSTANCE");
        WorkStepInstanceDAO.addNolockHint((StringBuffer)stringBuilder);
        stringBuilder.append(WHERE).append("PROCESS_INSTANCE_ID").append(QUESTION_AND).append("WORKSTEP_ID").append(SPACE_EQUALS_QUESTION);
        WorkStepInstanceDAO.addReadUncommittedHint((StringBuffer)stringBuilder);
        loadWorkStepInstance = stringBuilder.toString();
    }

    private static void initSqlStatementFindNoWhere() {
        findNoWhere = "select PROCESS_INSTANCE_ID, WORKSTEP_ID from BIZLOGIC_WORKSTEPINSTANCE where ";
    }

    private static void initSqlStatementFindByPrimaryKey() {
        findByPrimaryKey = "select PROCESS_INSTANCE_ID from BIZLOGIC_WORKSTEPINSTANCE where PROCESS_INSTANCE_ID = ? AND WORKSTEP_ID = ?";
    }

    private static void initSqlStatementRemoveWorkStepInstance() {
        removeWorkStepInstance = "delete from BIZLOGIC_WORKSTEPINSTANCE where PROCESS_INSTANCE_ID = ? AND WORKSTEP_ID = ?";
    }

    private static void initSqlStatementGetDataSlotCopies() {
        getDataSlotCopies = "select DATASLOTCOPIES from BIZLOGIC_WORKSTEPINSTANCE where PROCESS_INSTANCE_ID = ? AND WORKSTEP_ID = ?";
    }

    private static void initSqlStatementGetWorkStepNameListByStatus() {
        getWorkStepNameListByStatus = "select WORKSTEP_NAME from BIZLOGIC_WORKSTEPINSTANCE where STATUS = ? ";
    }

    private static void initSqlStatementGetWorkStepPrimaryKeyListByStatus() {
        StringBuffer stringBuffer = new StringBuffer(90);
        stringBuffer.append(SELECT).append("PROCESS_INSTANCE_ID").append(COMMA_SPACE).append("WORKSTEP_ID").append(FROM).append("BIZLOGIC_WORKSTEPINSTANCE");
        WorkStepInstanceDAO.addReadpastHint((StringBuffer)stringBuffer);
        stringBuffer.append(WHERE).append("STATUS").append(SPACE_EQUALS_QUESTION_SPACE);
        SBMDatabase.addReadPastHintOpenEdge((StringBuffer)stringBuffer);
        getWorkStepPrimaryKeyListByStatus = stringBuffer.toString();
    }

    private static void initSqlStatementGetPKListForRestartExternalService() {
        StringBuffer stringBuffer = new StringBuffer(90);
        stringBuffer.append(" SELECT ").append("BLWSI").append(PERIOD).append("PROCESS_INSTANCE_ID").append(COMMA_SPACE).append("BLWSI").append(PERIOD).append("WORKSTEP_ID").append(COMMA_SPACE).append("BLWSI").append(PERIOD).append("STATUS").append(COMMA_SPACE).append("BLWSI").append(PERIOD).append("TYPE").append(" FROM ").append("BIZLOGIC_WORKSTEPINSTANCE").append(" ").append("BLWSI");
        WorkStepInstanceDAO.addReadpastHint((StringBuffer)stringBuffer);
        stringBuffer.append(" WHERE ").append(DOUBLE_OPEN_PARENTHESIS).append("STATUS").append(EQUALS).append(18).append(AND).append("TYPE").append(" IN ").append(OPEN_PARENTHESIS).append(110).append(COMMA_SPACE).append(107).append(COMMA_SPACE).append(109).append(DOUBLE_CLOSE_PARENTHESIS_OR).append("STATUS").append(EQUALS).append(60).append(AND).append("TYPE").append(NOT_IN).append(110).append(TRIPLE_CLOSE_PARENTHESIS).append(AND).append("MONITOR_STEP").append(EQUALS_ZERO).append(" ORDER BY ").append("STARTTIME").append(ASCENDING);
        SBMDatabase.addReadPastHintOpenEdge((StringBuffer)stringBuffer);
        getPKListForRestartExternalService = stringBuffer.toString();
    }

    private static void initSqlStatementGetWorkStepInstanceList() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(SELECT);
        for (int ix = 0; ix < CLIENT_ATTR_TABLELIST.length; ++ix) {
            if (CLIENT_ATTR_TABLELIST[ix].equals("CREATOR")) {
                stringBuilder.append(PREFIX_PI);
            } else {
                stringBuilder.append(PREFIX_WSI);
            }
            stringBuilder.append(CLIENT_ATTR_TABLELIST[ix]);
            if (ix == CLIENT_ATTR_TABLELIST.length - 1) continue;
            stringBuilder.append(COMMA_SPACE);
        }
        stringBuilder.append(COMMA_PI).append("PROCESS_INSTANCE_NAME").append(COMMA_PI).append("PARENTID").append(COMMA_PI).append("ISCALLBACKCALLER").append(FROM).append("BIZLOGIC_WORKSTEPINSTANCE").append(WSI_COMMA).append("BIZLOGIC_PROCESSINSTANCE").append(PI_VALUE);
        getWorkStepInstanceList = stringBuilder.toString();
    }

    private static void initSqlStatementGetMilestoneWSIList() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(" SELECT ");
        for (int ix = 0; ix < CLIENT_ATTR_TABLELIST.length; ++ix) {
            if (!CLIENT_ATTR_TABLELIST[ix].equals("CREATOR")) {
                stringBuilder.append("BLWSI").append(PERIOD);
            } else {
                stringBuilder.append("BLPI").append(PERIOD);
            }
            stringBuilder.append(CLIENT_ATTR_TABLELIST[ix]);
            if (ix == CLIENT_ATTR_TABLELIST.length - 1) continue;
            stringBuilder.append(COMMA_SPACE);
        }
        stringBuilder.append(COMMA_SPACE).append("BLPI").append(PERIOD).append("PROCESS_INSTANCE_NAME").append(COMMA_SPACE).append("BLPI").append(PERIOD).append("PARENTID").append(" FROM ").append("BIZLOGIC_WORKSTEPINSTANCE").append(" ").append("BLWSI").append(COMMA_SPACE).append("BIZLOGIC_PROCESSINSTANCE").append(" ").append("BLPI");
        getMilestoneWSIList = stringBuilder.toString();
    }

    private static void initSqlStatementJoinWhereClause() {
        joinWhereClause = " wsi.PROCESS_INSTANCE_ID = pi.PROCESS_INSTANCE_ID";
    }

    private static void initSqlStatementFindByProcessInstance() {
        findByProcessInstance = "select WORKSTEP_ID, TYPE from BIZLOGIC_WORKSTEPINSTANCE where PROCESS_INSTANCE_ID = ? and STATUS = ? ";
    }

    private static void initSqlStatementFindStatusByProcessInstance() {
        findStatusByProcessInstance = "select WORKSTEP_NAME, STATUS from BIZLOGIC_WORKSTEPINSTANCE where PROCESS_INSTANCE_ID = ?";
    }

    private static void initSqlStatementCreateDynamicProcessWorkStepInstance() {
        StringBuffer tmpBuffer = new StringBuffer();
        tmpBuffer.append(INSERT_INTO).append("BIZLOGIC_WORKSTEPINSTANCE");
        WorkStepInstanceDAO.addRowlockHint((StringBuffer)tmpBuffer);
        StringBuilder stringBuilder = new StringBuilder(tmpBuffer);
        stringBuilder.append(OPEN_PARENTHESIS);
        for (int ix = 0; ix < CREATE_DYNAMIC_PROCESS_TABLELIST.length; ++ix) {
            stringBuilder.append(CREATE_DYNAMIC_PROCESS_TABLELIST[ix]);
            if (ix == CREATE_DYNAMIC_PROCESS_TABLELIST.length - 1) continue;
            stringBuilder.append(COMMA_SPACE);
        }
        stringBuilder.append(VALUES_QUESTIONS);
        createDynamicProcessWorkStepInstance = stringBuilder.toString();
    }

    private static void initSqlStatementRemoveByProcessInstance() {
        removeByProcessInstance = "delete from BIZLOGIC_WORKSTEPINSTANCE where PROCESS_INSTANCE_ID = ?";
    }

    private static void initSqlStatementGetWorkStepNameListByProcessInstance() {
        getWorkStepNameListByProcessInstance = "select WORKSTEP_NAME from BIZLOGIC_WORKSTEPINSTANCE where PROCESS_INSTANCE_ID = ? and STATUS in (18,16)";
    }

    private static void initSqlStatementGetWorkstepState() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(SELECT).append("STATUS").append(FROM).append("BIZLOGIC_WORKSTEPINSTANCE");
        WorkStepInstanceDAO.addReadpastHint((StringBuffer)stringBuffer);
        stringBuffer.append(WHERE).append("PROCESS_INSTANCE_ID").append(QUESTION_AND).append("WORKSTEP_ID").append(SPACE_EQUALS_QUESTION);
        SBMDatabase.addReadPastHintOpenEdge((StringBuffer)stringBuffer);
        getWorkstepState = stringBuffer.toString();
    }

    private static void initSqlStatementGetWorkstepStateByLoopCounter() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(SELECT).append("STATUS").append(FROM).append("BIZLOGIC_WORKSTEPINSTANCE");
        WorkStepInstanceDAO.addReadpastHint((StringBuffer)stringBuffer);
        stringBuffer.append(WHERE).append("PROCESS_INSTANCE_ID").append(QUESTION_AND).append("WORKSTEP_ID").append(QUESTION_AND).append("LOOPCOUNTER").append(SPACE_EQUALS_QUESTION);
        if (ServiceLocator.self().isDB2() && ServiceLocator.self().isWebsphere() && !BLControl.util.isPublishMessageInNewTransaction()) {
            WorkStepInstanceDAO.addReadUncommittedHint((StringBuffer)stringBuffer);
        }
        SBMDatabase.addReadPastHintOpenEdge((StringBuffer)stringBuffer);
        getWorkstepStateByLoopCounter = stringBuffer.toString();
    }

    private static void initSqlStatementGetCount() {
        getCount = "select count(*) from BIZLOGIC_WORKSTEPINSTANCE where PROCESS_INSTANCE_ID= ? ";
    }

    private static void initSqlStatementGetExpectArrivals() {
        getExpectArrivals = "select EXPECTARRIVALS from BIZLOGIC_WORKSTEPINSTANCE where PROCESS_INSTANCE_ID = ? and WORKSTEP_ID = ? ";
    }

    private static void initSqlStatementGetLoopCounterAndStatus() {
        getLoopCounterAndStatus = WorkStepInstanceDAO.composeSelectStatement((String[])new String[]{"LOOPCOUNTER", "STATUS"}, (String)"BIZLOGIC_WORKSTEPINSTANCE", (String[])new String[]{"PROCESS_INSTANCE_ID", "WORKSTEP_ID"});
    }

    private static void printSQLStatements() {
        if (BLControl.util.DEBUG_DAO) {
            BLControl.logger.debug((Object)"WorkStepInstanceDAO:");
            BLControl.logger.debugKey("BizLogic_ERR_1199", removeWorkStepInstance, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", loadWorkStepInstance, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", createWorkStepInstance, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", findByPrimaryKey, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getDataSlotCopies, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", findStatusByProcessInstance, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", createDynamicProcessWorkStepInstance, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", removeByProcessInstance, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", findNoWhere, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getWorkStepNameListByStatus, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getWorkStepPrimaryKeyListByStatus, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getPKListForRestartExternalService, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getLoopCounterAndStatus, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getWorkStepInstanceList, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", findByProcessInstance, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getWorkstepState, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getExpectArrivals, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getMilestoneWSIList, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getWorkStepNameList(long piid) {
        StringBuffer mainClause = new StringBuffer(getWorkStepNameListByProcessInstance);
        Connection conn = null;
        PreparedStatement pstmtGetWorkStepNameListByPI = null;
        ResultSet rset = null;
        Vector<String> tmp = new Vector<String>();
        try {
            conn = WorkStepInstanceDAO.getConnection();
            pstmtGetWorkStepNameListByPI = conn.prepareStatement(mainClause.toString());
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", mainClause.toString(), new Object[0]);
            }
            pstmtGetWorkStepNameListByPI.setLong(1, piid);
            rset = pstmtGetWorkStepNameListByPI.executeQuery();
            while (rset.next()) {
                tmp.addElement(rset.getString(1));
            }
        }
        catch (Throwable th) {
            try {
                WorkStepInstanceDAO.handle((Throwable)th);
            }
            catch (Throwable throwable) {
                WorkStepInstanceDAO.clean(rset, pstmtGetWorkStepNameListByPI, (Connection)conn);
                throw throwable;
            }
            WorkStepInstanceDAO.clean(rset, (Statement)pstmtGetWorkStepNameListByPI, (Connection)conn);
        }
        WorkStepInstanceDAO.clean((ResultSet)rset, (Statement)pstmtGetWorkStepNameListByPI, (Connection)conn);
        return BLUtil.Vector2String(tmp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getExpectArrivals(long piid, long wsid) {
        String expectArrivals;
        ResultSet rs;
        PreparedStatement pstmt;
        Connection conn;
        block6: {
            conn = null;
            pstmt = null;
            rs = null;
            expectArrivals = "";
            try {
                conn = WorkStepInstanceDAO.getConnection();
                pstmt = conn.prepareStatement(getExpectArrivals);
                if (BLControl.util.DEBUG_DAO) {
                    BLControl.logger.debugKey("BizLogic_ERR_1185", getExpectArrivals, new Object[0]);
                }
                pstmt.setLong(1, piid);
                pstmt.setLong(2, wsid);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block6;
                expectArrivals = rs.getString(1);
            }
            catch (Throwable th) {
                try {
                    WorkStepInstanceDAO.handle((Throwable)th);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    WorkStepInstanceDAO.clean(rs, (Statement)pstmt, (Connection)conn);
                }
            }
        }
        WorkStepInstanceDAO.clean((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return expectArrivals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean isExist(long piid, long wsid) {
        boolean wiexist;
        ResultSet rset;
        PreparedStatement pstmtGetWorkItemID;
        Connection conn;
        block5: {
            conn = null;
            pstmtGetWorkItemID = null;
            rset = null;
            wiexist = false;
            try {
                conn = WorkStepInstanceDAO.getConnection();
                pstmtGetWorkItemID = conn.prepareStatement(findByPrimaryKey);
                if (BLControl.util.DEBUG_DAO) {
                    BLControl.logger.debugKey("BizLogic_ERR_1185", findByPrimaryKey, new Object[0]);
                }
                pstmtGetWorkItemID.setLong(1, piid);
                pstmtGetWorkItemID.setLong(2, wsid);
                rset = pstmtGetWorkItemID.executeQuery();
                if (!rset.next()) break block5;
                wiexist = true;
            }
            catch (Throwable throwable) {
                WorkStepInstanceDAO.clean(rset, (Statement)pstmtGetWorkItemID, (Connection)conn);
                catch (Throwable throwable2) {
                    WorkStepInstanceDAO.clean(rset, (Statement)pstmtGetWorkItemID, (Connection)conn);
                    throw throwable2;
                }
            }
        }
        WorkStepInstanceDAO.clean((ResultSet)rset, (Statement)pstmtGetWorkItemID, (Connection)conn);
        return wiexist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap getLoopCounterAndStatus(long piid, long wsid) {
        HashMap<String, Integer> loopCounterAndStatus;
        ResultSet rs;
        PreparedStatement pstmt;
        Connection conn;
        block6: {
            conn = null;
            pstmt = null;
            rs = null;
            loopCounterAndStatus = new HashMap<String, Integer>();
            try {
                conn = WorkStepInstanceDAO.getConnection();
                pstmt = conn.prepareStatement(getLoopCounterAndStatus);
                if (BLControl.util.DEBUG_DAO) {
                    BLControl.logger.debugKey("BizLogic_ERR_1185", getLoopCounterAndStatus, new Object[0]);
                }
                pstmt.setLong(1, piid);
                pstmt.setLong(2, wsid);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block6;
                loopCounterAndStatus.put("LOOPCOUNTER", rs.getInt(1));
                loopCounterAndStatus.put("STATUS", rs.getInt(2));
            }
            catch (Throwable th) {
                try {
                    WorkStepInstanceDAO.handle((Throwable)th);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    WorkStepInstanceDAO.clean(rs, (Statement)pstmt, (Connection)conn);
                }
            }
        }
        WorkStepInstanceDAO.clean((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return loopCounterAndStatus;
    }

    private static String getPrimaryKey(WorkStepInstancePK primaryKey) {
        return WorkStepInstanceDAO.getPrimaryKey(primaryKey.processinstanceID, primaryKey.id);
    }

    private static String getPrimaryKey(long piid, long wsid) {
        StringBuffer parameterValue = new StringBuffer("piid=");
        parameterValue.append(piid);
        parameterValue.append(";wsid=");
        parameterValue.append(wsid);
        return parameterValue.toString();
    }

    static {
        String[] stringArray = new String[14];
        stringArray[0] = "PROCESSINSTANCEID";
        stringArray[1] = "WORKSTEPID";
        stringArray[2] = "PROCESSTEMPLATEID";
        stringArray[3] = "TYPE";
        stringArray[4] = "PRIORITY";
        stringArray[5] = "STATUS";
        stringArray[6] = "WORKSTEPNAME";
        stringArray[7] = "CREATOR";
        stringArray[8] = "PERFORMER";
        stringArray[9] = "INSTRUCTION";
        stringArray[10] = "INLINEBLOCK_NAME";
        stringArray[11] = "MILESTONE_NAME";
        stringArray[12] = "MILESTONE_DESC";
        stringArray[13] = "MONITOR_STEP";
        CREATE_LIST = stringArray;
        String[] stringArray2 = new String[14];
        DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
        stringArray2[0] = "PROCESS_INSTANCE_ID";
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        stringArray2[1] = "WORKSTEP_ID";
        DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
        stringArray2[2] = "PROCESS_TEMPLATE_ID";
        DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
        stringArray2[3] = "TYPE";
        DBConstants.ColConstants cfr_ignored_4 = BLControl.dbconsts.col;
        stringArray2[4] = "PRIORITY";
        DBConstants.ColConstants cfr_ignored_5 = BLControl.dbconsts.col;
        stringArray2[5] = "STATUS";
        DBConstants.ColConstants cfr_ignored_6 = BLControl.dbconsts.col;
        stringArray2[6] = "WORKSTEP_NAME";
        DBConstants.ColConstants cfr_ignored_7 = BLControl.dbconsts.col;
        stringArray2[7] = "CREATOR";
        DBConstants.ColConstants cfr_ignored_8 = BLControl.dbconsts.col;
        stringArray2[8] = "PERFORMER";
        DBConstants.ColConstants cfr_ignored_9 = BLControl.dbconsts.col;
        stringArray2[9] = "INSTRUCTION";
        DBConstants.ColConstants cfr_ignored_10 = BLControl.dbconsts.col;
        stringArray2[10] = "INLINEBLOCK_NAME";
        DBConstants.ColConstants cfr_ignored_11 = BLControl.dbconsts.col;
        stringArray2[11] = "MILESTONE_NAME";
        DBConstants.ColConstants cfr_ignored_12 = BLControl.dbconsts.col;
        stringArray2[12] = "MILESTONE_DESC";
        DBConstants.ColConstants cfr_ignored_13 = BLControl.dbconsts.col;
        stringArray2[13] = "MONITOR_STEP";
        CREATE_TABLELIST = stringArray2;
        String[] stringArray3 = new String[26];
        DBConstants.ColConstants cfr_ignored_14 = BLControl.dbconsts.col;
        stringArray3[0] = "PROCESS_INSTANCE_ID";
        DBConstants.ColConstants cfr_ignored_15 = BLControl.dbconsts.col;
        stringArray3[1] = "WORKSTEP_ID";
        DBConstants.ColConstants cfr_ignored_16 = BLControl.dbconsts.col;
        stringArray3[2] = "PROCESS_TEMPLATE_ID";
        DBConstants.ColConstants cfr_ignored_17 = BLControl.dbconsts.col;
        stringArray3[3] = "TYPE";
        DBConstants.ColConstants cfr_ignored_18 = BLControl.dbconsts.col;
        stringArray3[4] = "PRIORITY";
        DBConstants.ColConstants cfr_ignored_19 = BLControl.dbconsts.col;
        stringArray3[5] = "STATUS";
        DBConstants.ColConstants cfr_ignored_20 = BLControl.dbconsts.col;
        stringArray3[6] = "PREVIOUSSTATUS";
        DBConstants.ColConstants cfr_ignored_21 = BLControl.dbconsts.col;
        stringArray3[7] = "SUSPENDSTATUS";
        DBConstants.ColConstants cfr_ignored_22 = BLControl.dbconsts.col;
        stringArray3[8] = "ISSUSPENDEDBYCOMP";
        DBConstants.ColConstants cfr_ignored_23 = BLControl.dbconsts.col;
        stringArray3[9] = "LOOPCOUNTER";
        DBConstants.ColConstants cfr_ignored_24 = BLControl.dbconsts.col;
        stringArray3[10] = "WORKSTEP_NAME";
        DBConstants.ColConstants cfr_ignored_25 = BLControl.dbconsts.col;
        stringArray3[11] = "CREATOR";
        DBConstants.ColConstants cfr_ignored_26 = BLControl.dbconsts.col;
        stringArray3[12] = "PERFORMER";
        DBConstants.ColConstants cfr_ignored_27 = BLControl.dbconsts.col;
        stringArray3[13] = "ACTUALPERFORMER";
        DBConstants.ColConstants cfr_ignored_28 = BLControl.dbconsts.col;
        stringArray3[14] = "INSTRUCTION";
        DBConstants.ColConstants cfr_ignored_29 = BLControl.dbconsts.col;
        stringArray3[15] = "EXPECTARRIVALS";
        DBConstants.ColConstants cfr_ignored_30 = BLControl.dbconsts.col;
        stringArray3[16] = "STARTTIME";
        DBConstants.ColConstants cfr_ignored_31 = BLControl.dbconsts.col;
        stringArray3[17] = "ENDTIME";
        DBConstants.ColConstants cfr_ignored_32 = BLControl.dbconsts.col;
        stringArray3[18] = "DUEDATE";
        DBConstants.ColConstants cfr_ignored_33 = BLControl.dbconsts.col;
        stringArray3[19] = "SUBPIID";
        DBConstants.ColConstants cfr_ignored_34 = BLControl.dbconsts.col;
        stringArray3[20] = "ISSUBPIACTIVATED";
        DBConstants.ColConstants cfr_ignored_35 = BLControl.dbconsts.col;
        stringArray3[21] = "DURATION";
        DBConstants.ColConstants cfr_ignored_36 = BLControl.dbconsts.col;
        stringArray3[22] = "INLINEBLOCK_NAME";
        DBConstants.ColConstants cfr_ignored_37 = BLControl.dbconsts.col;
        stringArray3[23] = "MILESTONE_NAME";
        DBConstants.ColConstants cfr_ignored_38 = BLControl.dbconsts.col;
        stringArray3[24] = "MILESTONE_DESC";
        DBConstants.ColConstants cfr_ignored_39 = BLControl.dbconsts.col;
        stringArray3[25] = "MONITOR_STEP";
        LOAD_TABLELIST = stringArray3;
        String[] stringArray4 = new String[21];
        stringArray4[0] = "PROCESSINSTANCEID";
        stringArray4[1] = "WORKSTEPID";
        stringArray4[2] = "PROCESSTEMPLATEID";
        stringArray4[3] = "TYPE";
        stringArray4[4] = "PRIORITY";
        stringArray4[5] = "STATUS";
        stringArray4[6] = "SUSPENDSTATUS";
        stringArray4[7] = "LOOPCOUNTER";
        stringArray4[8] = "WORKSTEPNAME";
        stringArray4[9] = "CREATOR";
        stringArray4[10] = "PERFORMER";
        stringArray4[11] = "ACTUALPERFORMER";
        stringArray4[12] = "INSTRUCTION";
        stringArray4[13] = "STARTTIME";
        stringArray4[14] = "DUEDATE";
        stringArray4[15] = "ENDTIME";
        stringArray4[16] = "DATASLOTCOPIES";
        stringArray4[17] = "INLINEBLOCK_NAME";
        stringArray4[18] = "MILESTONE_NAME";
        stringArray4[19] = "MILESTONE_DESC";
        stringArray4[20] = "MONITOR_STEP";
        CREATE_DYNAMIC_PROCESSLIST = stringArray4;
        String[] stringArray5 = new String[21];
        DBConstants.ColConstants cfr_ignored_40 = BLControl.dbconsts.col;
        stringArray5[0] = "PROCESS_INSTANCE_ID";
        DBConstants.ColConstants cfr_ignored_41 = BLControl.dbconsts.col;
        stringArray5[1] = "WORKSTEP_ID";
        DBConstants.ColConstants cfr_ignored_42 = BLControl.dbconsts.col;
        stringArray5[2] = "PROCESS_TEMPLATE_ID";
        DBConstants.ColConstants cfr_ignored_43 = BLControl.dbconsts.col;
        stringArray5[3] = "TYPE";
        DBConstants.ColConstants cfr_ignored_44 = BLControl.dbconsts.col;
        stringArray5[4] = "PRIORITY";
        DBConstants.ColConstants cfr_ignored_45 = BLControl.dbconsts.col;
        stringArray5[5] = "STATUS";
        DBConstants.ColConstants cfr_ignored_46 = BLControl.dbconsts.col;
        stringArray5[6] = "SUSPENDSTATUS";
        DBConstants.ColConstants cfr_ignored_47 = BLControl.dbconsts.col;
        stringArray5[7] = "LOOPCOUNTER";
        DBConstants.ColConstants cfr_ignored_48 = BLControl.dbconsts.col;
        stringArray5[8] = "WORKSTEP_NAME";
        DBConstants.ColConstants cfr_ignored_49 = BLControl.dbconsts.col;
        stringArray5[9] = "CREATOR";
        DBConstants.ColConstants cfr_ignored_50 = BLControl.dbconsts.col;
        stringArray5[10] = "PERFORMER";
        DBConstants.ColConstants cfr_ignored_51 = BLControl.dbconsts.col;
        stringArray5[11] = "ACTUALPERFORMER";
        DBConstants.ColConstants cfr_ignored_52 = BLControl.dbconsts.col;
        stringArray5[12] = "INSTRUCTION";
        DBConstants.ColConstants cfr_ignored_53 = BLControl.dbconsts.col;
        stringArray5[13] = "STARTTIME";
        DBConstants.ColConstants cfr_ignored_54 = BLControl.dbconsts.col;
        stringArray5[14] = "DUEDATE";
        DBConstants.ColConstants cfr_ignored_55 = BLControl.dbconsts.col;
        stringArray5[15] = "ENDTIME";
        DBConstants.ColConstants cfr_ignored_56 = BLControl.dbconsts.col;
        stringArray5[16] = "DATASLOTCOPIES";
        DBConstants.ColConstants cfr_ignored_57 = BLControl.dbconsts.col;
        stringArray5[17] = "INLINEBLOCK_NAME";
        stringArray5[18] = "MILESTONE_NAME";
        stringArray5[19] = "MILESTONE_DESC";
        DBConstants.ColConstants cfr_ignored_58 = BLControl.dbconsts.col;
        stringArray5[20] = "MONITOR_STEP";
        CREATE_DYNAMIC_PROCESS_TABLELIST = stringArray5;
        String[] stringArray6 = new String[24];
        stringArray6[0] = "PROCESSINSTANCEID";
        stringArray6[1] = "WORKSTEPID";
        stringArray6[2] = "PROCESSTEMPLATEID";
        stringArray6[3] = "TYPE";
        stringArray6[4] = "PRIORITY";
        stringArray6[5] = "STATUS";
        stringArray6[6] = "WORKSTEPNAME";
        stringArray6[7] = "CREATOR";
        stringArray6[8] = "ACTUALPERFORMER";
        stringArray6[9] = "INSTRUCTION";
        stringArray6[10] = "STARTTIME";
        stringArray6[11] = "ENDTIME";
        stringArray6[12] = "DUEDATE";
        stringArray6[13] = "PREVIOUSSTATUS";
        stringArray6[14] = "PERFORMER";
        stringArray6[15] = "LOOPCOUNTER";
        stringArray6[16] = "DURATION";
        stringArray6[17] = "INLINEBLOCK_NAME";
        stringArray6[18] = "MILESTONE_NAME";
        stringArray6[19] = "MILESTONE_DESC";
        stringArray6[20] = "MONITOR_STEP";
        stringArray6[21] = "PROCESSINSTANCENAME";
        stringArray6[22] = "PARENTID";
        stringArray6[23] = "ISCALLBACKCALLER";
        CLIENT_ATTR_LIST = stringArray6;
        String[] stringArray7 = new String[21];
        DBConstants.ColConstants cfr_ignored_59 = BLControl.dbconsts.col;
        stringArray7[0] = "PROCESS_INSTANCE_ID";
        DBConstants.ColConstants cfr_ignored_60 = BLControl.dbconsts.col;
        stringArray7[1] = "WORKSTEP_ID";
        DBConstants.ColConstants cfr_ignored_61 = BLControl.dbconsts.col;
        stringArray7[2] = "PROCESS_TEMPLATE_ID";
        DBConstants.ColConstants cfr_ignored_62 = BLControl.dbconsts.col;
        stringArray7[3] = "TYPE";
        DBConstants.ColConstants cfr_ignored_63 = BLControl.dbconsts.col;
        stringArray7[4] = "PRIORITY";
        DBConstants.ColConstants cfr_ignored_64 = BLControl.dbconsts.col;
        stringArray7[5] = "STATUS";
        DBConstants.ColConstants cfr_ignored_65 = BLControl.dbconsts.col;
        stringArray7[6] = "WORKSTEP_NAME";
        DBConstants.ColConstants cfr_ignored_66 = BLControl.dbconsts.col;
        stringArray7[7] = "CREATOR";
        DBConstants.ColConstants cfr_ignored_67 = BLControl.dbconsts.col;
        stringArray7[8] = "ACTUALPERFORMER";
        DBConstants.ColConstants cfr_ignored_68 = BLControl.dbconsts.col;
        stringArray7[9] = "INSTRUCTION";
        DBConstants.ColConstants cfr_ignored_69 = BLControl.dbconsts.col;
        stringArray7[10] = "STARTTIME";
        DBConstants.ColConstants cfr_ignored_70 = BLControl.dbconsts.col;
        stringArray7[11] = "ENDTIME";
        DBConstants.ColConstants cfr_ignored_71 = BLControl.dbconsts.col;
        stringArray7[12] = "DUEDATE";
        DBConstants.ColConstants cfr_ignored_72 = BLControl.dbconsts.col;
        stringArray7[13] = "PREVIOUSSTATUS";
        DBConstants.ColConstants cfr_ignored_73 = BLControl.dbconsts.col;
        stringArray7[14] = "PERFORMER";
        DBConstants.ColConstants cfr_ignored_74 = BLControl.dbconsts.col;
        stringArray7[15] = "LOOPCOUNTER";
        DBConstants.ColConstants cfr_ignored_75 = BLControl.dbconsts.col;
        stringArray7[16] = "DURATION";
        DBConstants.ColConstants cfr_ignored_76 = BLControl.dbconsts.col;
        stringArray7[17] = "INLINEBLOCK_NAME";
        DBConstants.ColConstants cfr_ignored_77 = BLControl.dbconsts.col;
        stringArray7[18] = "MILESTONE_NAME";
        DBConstants.ColConstants cfr_ignored_78 = BLControl.dbconsts.col;
        stringArray7[19] = "MILESTONE_DESC";
        DBConstants.ColConstants cfr_ignored_79 = BLControl.dbconsts.col;
        stringArray7[20] = "MONITOR_STEP";
        CLIENT_ATTR_TABLELIST = stringArray7;
        DBConstants.ColConstants cfr_ignored_80 = BLControl.dbconsts.col;
        ORDER_BY_CLAUSE = " ORDER BY pi." + "PROCESS_INSTANCE_ID";
    }
}

