/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.dao;

import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLDAOService;
import com.savvion.sbm.bizlogic.util.DBConstants;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;

public class WaitWorkStepDAO
extends BLDAOService {
    private static final String[] CREATE_LIST;
    private static final String[] LOAD_LIST;
    private static String insertWaitWorkStep;
    private static String removeWaitWorkStep;
    private static String loadWaitWorkSteps;
    private static String loadWaitWorkStepsJoin;
    private static String instanceDSQuery;
    private static final int REFER_INSTANCE_SLOT_WORKSTEP = 1;
    private static final int REFER_GLOBAL_SLOT_WORKSTEP = 2;
    private static final int VALIDATE_WORKSTEP = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(long ptid, long piid, long wsid, int hasGlobalSlotReference) {
        Connection conn = null;
        PreparedStatement pstmtInsertWaitWorkStep = null;
        try {
            conn = WaitWorkStepDAO.getConnection();
            pstmtInsertWaitWorkStep = conn.prepareStatement(insertWaitWorkStep);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", insertWaitWorkStep, new Object[0]);
            }
            pstmtInsertWaitWorkStep.setLong(1, ptid);
            pstmtInsertWaitWorkStep.setLong(2, piid);
            pstmtInsertWaitWorkStep.setLong(3, wsid);
            pstmtInsertWaitWorkStep.setInt(4, 0);
            pstmtInsertWaitWorkStep.setInt(5, hasGlobalSlotReference);
            pstmtInsertWaitWorkStep.setInt(6, 0);
            pstmtInsertWaitWorkStep.executeUpdate();
        }
        catch (SQLException sqlex) {
            WaitWorkStepDAO.handle((SQLException)sqlex);
        }
        finally {
            WaitWorkStepDAO.clean(null, (Statement)pstmtInsertWaitWorkStep, (Connection)conn);
        }
    }

    public static void remove(long piid) {
        WaitWorkStepDAO.remove(piid, -1L, true);
    }

    public static void remove(long piid, long wsid) {
        WaitWorkStepDAO.remove(piid, wsid, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void remove(long piid, long wsid, boolean isWholePI) {
        String sql = removeWaitWorkStep;
        if (!isWholePI) {
            StringBuffer sb = new StringBuffer(removeWaitWorkStep);
            sb.append(" and ");
            DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
            sb.append("WORKSTEP_ID");
            sb.append(" = ?");
            sql = sb.toString();
        }
        Connection conn = null;
        PreparedStatement pstmtRemoveWaitWorkStep = null;
        try {
            conn = WaitWorkStepDAO.getConnection();
            pstmtRemoveWaitWorkStep = conn.prepareStatement(sql);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", sql, new Object[0]);
            }
            pstmtRemoveWaitWorkStep.setLong(1, piid);
            if (!isWholePI) {
                pstmtRemoveWaitWorkStep.setLong(2, wsid);
            }
            pstmtRemoveWaitWorkStep.executeUpdate();
        }
        catch (SQLException sqlex) {
            WaitWorkStepDAO.handle((SQLException)sqlex);
        }
        finally {
            WaitWorkStepDAO.clean(null, (Statement)pstmtRemoveWaitWorkStep, (Connection)conn);
        }
    }

    public static Hashtable getISInvalidateWorkStepList() {
        return WaitWorkStepDAO.getWorkStepList(1);
    }

    public static Hashtable getGSInvalidateWorkStepList() {
        return WaitWorkStepDAO.getWorkStepList(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Hashtable getWorkStepList(int type) {
        String sql = loadWaitWorkSteps;
        StringBuilder sb = new StringBuilder(loadWaitWorkSteps);
        if (type == 2 || type == 1) {
            sb.append(" and ");
            DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
            sb.append("BLWW.").append("IS_REFERGLOBALSLOT");
            sb.append(" = ?");
        }
        sb.append(" AND ").append(loadWaitWorkStepsJoin);
        sb.append(" order by ");
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        sb.append("BLWW.").append("PROCESS_INSTANCE_ID");
        sql = sb.toString();
        Connection conn = null;
        PreparedStatement pstmtGetWorkStepList = null;
        ResultSet rs = null;
        Hashtable<Object, Cloneable> ht = new Hashtable<Object, Cloneable>();
        HashMap<Long, Long> ptInfo = new HashMap<Long, Long>();
        try {
            conn = WaitWorkStepDAO.getConnection();
            pstmtGetWorkStepList = conn.prepareStatement(sql);
            pstmtGetWorkStepList.setInt(1, 0);
            if (type == 3) {
                pstmtGetWorkStepList.setInt(2, 1);
            } else {
                pstmtGetWorkStepList.setInt(2, 0);
                if (type == 2) {
                    pstmtGetWorkStepList.setInt(3, 1);
                } else {
                    pstmtGetWorkStepList.setInt(3, 0);
                }
            }
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1207", new Object[]{sql, type});
            }
            long startTime = System.currentTimeMillis();
            rs = pstmtGetWorkStepList.executeQuery();
            long endTime = System.currentTimeMillis();
            while (rs.next()) {
                Long ptidObj = new Long(rs.getLong(1));
                Long piidObj = new Long(rs.getLong(2));
                Long wsidObj = new Long(rs.getLong(3));
                ptInfo.put(piidObj, ptidObj);
                Object obj = ht.get(piidObj);
                Vector<Long> v = null;
                if (obj == null) {
                    v = new Vector<Long>();
                    ht.put(piidObj, v);
                } else {
                    v = (Vector<Long>)obj;
                }
                v.addElement(wsidObj);
            }
            if (BLControl.util.DEBUG_PRECONDITION) {
                BLControl.logger.debugKey("BizLogic_ERR_3257", "WaitWorkStepDAO.getWorkStepList()", new Object[]{ht.size(), endTime - startTime});
            }
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_3251", new Object[]{sql, type, ht.size()});
            }
            WaitWorkStepDAO.clean((ResultSet)rs, (Statement)pstmtGetWorkStepList, (Connection)conn);
        }
        catch (SQLException sqlex) {
            WaitWorkStepDAO.handle((SQLException)sqlex);
        }
        finally {
            WaitWorkStepDAO.clean(rs, (Statement)pstmtGetWorkStepList, (Connection)conn);
        }
        if (ht.isEmpty()) {
            return null;
        }
        ht.put("PTINFO", ptInfo);
        return ht;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector<Long> getWsIdListForInstanceDS(long piid) {
        ResultSet rs;
        PreparedStatement pstmtInstanceDSQuery;
        Connection conn;
        Vector<Long> wsidList;
        block8: {
            block7: {
                wsidList = new Vector<Long>();
                conn = null;
                pstmtInstanceDSQuery = null;
                rs = null;
                conn = WaitWorkStepDAO.getConnection();
                pstmtInstanceDSQuery = conn.prepareStatement(instanceDSQuery);
                pstmtInstanceDSQuery.setLong(1, piid);
                if (BLControl.util.DEBUG_DAO) {
                    BLControl.logger.debugKey("BizLogic_ERR_1207", new Object[]{instanceDSQuery, piid});
                }
                rs = pstmtInstanceDSQuery.executeQuery();
                while (rs.next()) {
                    DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
                    long wsid = rs.getLong("WORKSTEP_ID");
                    wsidList.add(wsid);
                }
                if (wsidList != null && !wsidList.isEmpty()) break block7;
                Vector<Long> wsid = null;
                WaitWorkStepDAO.clean((ResultSet)rs, (Statement)pstmtInstanceDSQuery, (Connection)conn);
                return wsid;
            }
            try {
                if (!BLControl.util.DEBUG_DAO) break block8;
                BLControl.logger.debugKey("BizLogic_ERR_3251", new Object[]{instanceDSQuery, piid, wsidList});
            }
            catch (SQLException sqlex) {
                try {
                    WaitWorkStepDAO.handle((Throwable)sqlex, (String)("getWsIdListForInstanceDS(" + piid + ")"));
                }
                catch (Throwable throwable) {
                    WaitWorkStepDAO.clean(rs, (Statement)pstmtInstanceDSQuery, (Connection)conn);
                    throw throwable;
                }
                WaitWorkStepDAO.clean((ResultSet)rs, (Statement)pstmtInstanceDSQuery, (Connection)conn);
            }
        }
        WaitWorkStepDAO.clean((ResultSet)rs, (Statement)pstmtInstanceDSQuery, (Connection)conn);
        return wsidList;
    }

    public static synchronized void initSQLStatements() {
        insertWaitWorkStep = WaitWorkStepDAO.getInsertWaitWorkStep();
        loadWaitWorkSteps = WaitWorkStepDAO.getLoadWaitWorkSteps();
        loadWaitWorkStepsJoin = WaitWorkStepDAO.getLoadWaitWorkStepsJoin();
        instanceDSQuery = WaitWorkStepDAO.getInstanceDsQuery();
        removeWaitWorkStep = WaitWorkStepDAO.getRemoveWaitWorkSteps();
        WaitWorkStepDAO.printSQLStatements();
    }

    private static String getRemoveWaitWorkSteps() {
        DBConstants.TableConstants cfr_ignored_0 = BLControl.dbconsts.tab;
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        return new StringBuilder(100).append("delete from ").append("BIZLOGIC_WAITWORKSTEP").append(" where ").append("PROCESS_INSTANCE_ID").append(" = ?").toString();
    }

    private static String getInstanceDsQuery() {
        DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
        DBConstants.TableConstants cfr_ignored_1 = BLControl.dbconsts.tab;
        DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
        DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
        StringBuilder buffer = new StringBuilder(100).append("SELECT ").append("WORKSTEP_ID").append(" FROM ").append("BIZLOGIC_WAITWORKSTEP").append(" WHERE ").append("PROCESS_INSTANCE_ID").append(" = ? AND ").append("IS_REFERGLOBALSLOT").append(" = 0 ");
        return buffer.toString();
    }

    private static String getLoadWaitWorkStepsJoin() {
        StringBuilder buffer = new StringBuilder();
        DBConstants.ColConstants cfr_ignored_0 = DBConstants.single().col;
        buffer.append("BLWW.").append("PROCESS_INSTANCE_ID");
        DBConstants.ColConstants cfr_ignored_1 = DBConstants.single().col;
        buffer.append(" = ").append("BLPI.").append("PROCESS_INSTANCE_ID");
        buffer.append(" AND ");
        DBConstants.ColConstants cfr_ignored_2 = DBConstants.single().col;
        buffer.append("BLPI.").append("STATUS");
        StringBuilder stringBuilder = buffer.append(" != ");
        BLConstants.single();
        stringBuilder.append(8);
        return buffer.toString();
    }

    private static String getLoadWaitWorkSteps() {
        StringBuilder buffer = new StringBuilder("select ");
        for (int ix = 0; ix < LOAD_LIST.length; ++ix) {
            buffer.append("BLWW.").append(LOAD_LIST[ix]);
            if (ix == LOAD_LIST.length - 1) continue;
            buffer.append(", ");
        }
        DBConstants.TableConstants cfr_ignored_0 = BLControl.dbconsts.tab;
        DBConstants.TableConstants cfr_ignored_1 = BLControl.dbconsts.tab;
        DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
        DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
        buffer.append(" from ").append("BIZLOGIC_WAITWORKSTEP").append(" BLWW ").append(", ").append("BIZLOGIC_PROCESSINSTANCE").append(" BLPI ").append(" where ").append("BLWW.").append("IS_SUSPENDEDBYCOMP").append(" = ? and ").append("BLWW.").append("IS_VALIDATE").append(" = ?");
        return buffer.toString();
    }

    private static String getInsertWaitWorkStep() {
        int ix = 0;
        DBConstants.TableConstants cfr_ignored_0 = BLControl.dbconsts.tab;
        StringBuilder buffer = new StringBuilder().append("insert into ").append("BIZLOGIC_WAITWORKSTEP").append(" (");
        for (ix = 0; ix < CREATE_LIST.length; ++ix) {
            buffer.append(CREATE_LIST[ix]);
            if (ix == CREATE_LIST.length - 1) continue;
            buffer.append(", ");
        }
        buffer.append(") values (");
        for (ix = 0; ix < CREATE_LIST.length; ++ix) {
            buffer.append("?");
            if (ix == CREATE_LIST.length - 1) continue;
            buffer.append(", ");
        }
        buffer.append(")");
        return buffer.toString();
    }

    private static void printSQLStatements() {
        if (BLControl.util.DEBUG_DAO) {
            BLControl.logger.debug((Object)"WaitWorkStepDAO:");
            BLControl.logger.debugKey("BizLogic_ERR_1199", insertWaitWorkStep, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", removeWaitWorkStep, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", loadWaitWorkSteps, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", instanceDSQuery, new Object[0]);
        }
    }

    static {
        String[] stringArray = new String[6];
        DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
        stringArray[0] = "PROCESS_TEMPLATE_ID";
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        stringArray[1] = "PROCESS_INSTANCE_ID";
        DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
        stringArray[2] = "WORKSTEP_ID";
        DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
        stringArray[3] = "IS_VALIDATE";
        DBConstants.ColConstants cfr_ignored_4 = BLControl.dbconsts.col;
        stringArray[4] = "IS_REFERGLOBALSLOT";
        DBConstants.ColConstants cfr_ignored_5 = BLControl.dbconsts.col;
        stringArray[5] = "IS_SUSPENDEDBYCOMP";
        CREATE_LIST = stringArray;
        String[] stringArray2 = new String[3];
        DBConstants.ColConstants cfr_ignored_6 = BLControl.dbconsts.col;
        stringArray2[0] = "PROCESS_TEMPLATE_ID";
        DBConstants.ColConstants cfr_ignored_7 = BLControl.dbconsts.col;
        stringArray2[1] = "PROCESS_INSTANCE_ID";
        DBConstants.ColConstants cfr_ignored_8 = BLControl.dbconsts.col;
        stringArray2[2] = "WORKSTEP_ID";
        LOAD_LIST = stringArray2;
    }
}

