/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.savvion.sbm.bizlogic.server.WFAtomicWS;
import com.savvion.sbm.bizlogic.server.WFDataslot;
import com.savvion.sbm.bizlogic.server.svo.Decimal;
import com.savvion.sbm.bizlogic.server.svo.VoteCriteria;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import java.util.HashMap;
import java.util.List;

public class WFVoteWS
extends WFAtomicWS {
    static final long serialVersionUID = -4444236305439376510L;
    private VoteCriteria voteCriteria = null;
    private boolean mapVoteResultDS = false;

    public WFVoteWS(int type, String name, String performer, boolean who, String rol) {
        super(type, name, performer, who, rol);
    }

    void setVoteCriteria(VoteCriteria voteCrit) {
        this.voteCriteria = voteCrit;
    }

    public VoteCriteria getVoteCriteria() {
        return this.voteCriteria;
    }

    public int getVoteCount() {
        return this.voteCriteria.getExpectedCount();
    }

    public int getVoteCountType() {
        return this.voteCriteria.getVoteType();
    }

    public boolean isPercentageVoteCount() {
        int n = this.getVoteCountType();
        BLConstants.single();
        return n == 2;
    }

    public String getMajorityDSName() {
        return this.voteCriteria.getMajorityDataSlotName();
    }

    public String getVoteResultDSName() {
        return this.voteCriteria.getResultDataSlotName();
    }

    public List getVoteChoices() {
        return this.voteCriteria.getChoices();
    }

    public String getMappedChoiceDSName() {
        if (this.voteCriteria.isMappedChoices()) {
            return (String)this.getVoteChoices().get(0);
        }
        return null;
    }

    @Override
    public boolean validate() {
        if (this.voteCriteria == null) {
            throw new BizLogicException("BizLogic_ERR_6018", "WFVoteWS.validate()", new Object[]{this.getProcessName(), this.getName()});
        }
        this.validateVoteCriteria();
        super.validate();
        return true;
    }

    private void validateVoteCriteria() {
        List voteChoices;
        HashMap votedetails = this.voteCriteria.getAttributes();
        int count = this.voteCriteria.getExpectedCount();
        if (this.voteCriteria.isPercentage() && count > 100) {
            BLControl.logger.warnKey("BizLogic_ERR_6005", new Object[]{count, this.getName(), this.getProcessName(), "WFVoteWS.validateVoteCriteria()"});
            votedetails.put("EXPECTED_COUNT", 100);
        }
        if ((voteChoices = this.voteCriteria.getChoices()) == null) {
            return;
        }
        this.validateVoteChoices();
        String voteDS = this.voteCriteria.getMajorityDataSlotName();
        if (voteChoices != null && (voteDS == null || voteDS.trim().isEmpty())) {
            throw new BizLogicException("BizLogic_ERR_6006", "WFVoteWS.validateVoteCriteria()", new Object[]{this.getName(), this.getProcessName()});
        }
        WFDataslot ds = this.getDataslot(voteDS);
        if (ds.isString() || ds.isBoolean() || ds.isLong() || ds.isDecimal()) {
            for (int i = 0; i < voteChoices.size(); ++i) {
                String choice = (String)voteChoices.get(i);
                Object objChoice = this.getChoiceObj(choice, ds);
                voteChoices.set(i, objChoice);
            }
        } else {
            throw new BizLogicException("BizLogic_ERR_6007", "WFVoteWS.validateVoteDetails()", new Object[]{voteDS, ds.getType(), this.getName(), this.getProcessName()});
        }
        votedetails.put("CHOICES", voteChoices);
        votedetails.put("MAJORITYDS_TYPE", ds.getType());
        String voteResultDS = this.voteCriteria.getResultDataSlotName();
        if (voteResultDS != null) {
            this.validateVoteResultDS(voteResultDS);
        }
        votedetails.put(VoteCriteria.PROCESSTEMPLATEID, this.getParentProcess().getID());
        votedetails.put(VoteCriteria.WORKSTEPID, this.getID());
        this.getParentProcess().setHasVoteWorksteps(true);
    }

    private void validateVoteChoices() {
        if (this.voteCriteria.isMappedChoices()) {
            String choiceDS = (String)this.voteCriteria.getChoices().get(0);
            WFDataslot ds = this.getDataslot(choiceDS);
            if (!ds.isList()) {
                throw new BizLogicException("BizLogic_ERR_6020", "WFVoteWS.validateVoteCriteria()", new Object[]{this.getName(), this.getProcessName(), choiceDS});
            }
            return;
        }
        int choiceLength = this.voteCriteria.getStringChoices().length();
        if (choiceLength > BLControl.util.MAX_VOTECHOICES_SIZE) {
            throw new BizLogicException("BizLogic_ERR_6021", "WFVoteWS.validateVoteCriteria()", new Object[]{this.getName(), this.getProcessName(), choiceLength, BLControl.util.MAX_VOTECHOICES_SIZE});
        }
    }

    private void validateVoteResultDS(String resDS) {
        WFDataslot resultDS = this.getDataslot(resDS);
        if (!resultDS.isObject()) {
            throw new BizLogicException("BizLogic_ERR_6017", "WFVoteWS.validateVoteDetails()", new Object[]{this.getName(), this.getProcessName(), ""});
        }
        String javaclsname = resultDS.getJavaClassName();
        BLConstants consts = BLConstants.single();
        if ("com.savvion.sbm.bizlogic.server.svo.VoteResult".equalsIgnoreCase(javaclsname)) {
            this.mapVoteResultDS = false;
        } else if ("java.util.HashMap".equalsIgnoreCase(javaclsname)) {
            this.mapVoteResultDS = true;
        } else {
            throw new BizLogicException("BizLogic_ERR_6017", "WFVoteWS.validateVoteResultDS()", new Object[]{this.getName(), this.getProcessName(), javaclsname});
        }
    }

    public boolean isMapVoteResultDS() {
        return this.mapVoteResultDS;
    }

    private Object getChoiceObj(String choice, WFDataslot ds) {
        try {
            if (ds.isLong()) {
                Long longChoice = Long.valueOf(choice);
                return longChoice;
            }
            if (ds.isBoolean()) {
                Boolean boolChoice = Boolean.valueOf(choice);
                return boolChoice;
            }
            if (ds.isDecimal()) {
                Decimal decChoice = new Decimal(choice);
                return decChoice;
            }
        }
        catch (Throwable th) {
            throw new BizLogicException("BizLogic_ERR_6008", "WFVoteWS.getChoiceObj()", new Object[]{ds.getType(), this.getName(), this.getProcessName()});
        }
        return choice;
    }
}

