/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.savvion.sbm.bizlogic.enums.BLLockContext;
import com.savvion.sbm.bizlogic.server.DebugService;
import com.savvion.sbm.bizlogic.server.ProcessControl;
import com.savvion.sbm.bizlogic.server.WFAtomicInstance;
import com.savvion.sbm.bizlogic.server.WFCWorkItem;
import com.savvion.sbm.bizlogic.server.WFDataSlotInstance;
import com.savvion.sbm.bizlogic.server.WFDataslot;
import com.savvion.sbm.bizlogic.server.WFDynamicProcessInstance;
import com.savvion.sbm.bizlogic.server.WFMessageSubscriberInstance;
import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.server.WFProcessInstance;
import com.savvion.sbm.bizlogic.server.WFProcessNotes;
import com.savvion.sbm.bizlogic.server.WFWorkItem;
import com.savvion.sbm.bizlogic.server.WFWorkstep;
import com.savvion.sbm.bizlogic.server.WFWorkstepInstance;
import com.savvion.sbm.bizlogic.server.XMLDocRepository;
import com.savvion.sbm.bizlogic.server.dao.BLLockDAO;
import com.savvion.sbm.bizlogic.server.ejb.ProcessInstanceEBLocal;
import com.savvion.sbm.bizlogic.server.ejb.WorkItemEBLocal;
import com.savvion.sbm.bizlogic.server.ejb.WorkStepInstanceEBLocal;
import com.savvion.sbm.bizlogic.server.svo.ProcessInstance;
import com.savvion.sbm.bizlogic.server.svo.XML;
import com.savvion.sbm.bizlogic.smp.util.SMPConfig;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.PerformerUtil;
import com.savvion.sbm.bizlogic.util.Session;
import com.savvion.sbm.bizlogic.util.SessionManager;
import com.tdiinc.userManager.User;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.ejb.FinderException;

public class WFProcessContext {
    Session sess;
    long ptid = 0L;
    long rptid = 0L;
    long piid = 0L;
    long rpiid = 0L;
    String ptname = null;
    String piname = null;
    long parentid = -1L;
    long currentWSID = -1L;
    WFProcess pt = null;
    Hashtable wsList = null;
    ProcessInstanceEBLocal pieb = null;
    Hashtable wsiebList = null;
    Hashtable wiebList = null;
    long piTimeCompleted = -1L;
    boolean isCompProcess = false;
    long completeCallerPIID = -1L;
    HashMap users;
    ArrayList andWSInSameTxList = null;
    boolean emailSupport = false;
    ProcessInstance pisvo = null;
    HashMap voteDetails = null;
    boolean sendSUpdateEvent = true;
    boolean isInstanceMigration = false;
    boolean instanceCreation = false;
    Hashtable wsiDueDateBefPreScript = new Hashtable();
    Hashtable resourceMap;
    Vector<Long> validPreCondWSIdList = new Vector();
    private boolean wsDueDateSet;
    private boolean isDebug = false;
    private long wsActivationInLoop = -1L;
    private long adapterInvocationTime = -1L;
    private boolean piCompletedOnCreatePIRequest = false;
    private XORHelper XORHelperObj = null;
    private boolean isProcessRefresh = false;
    private boolean extEventsProcessedFromBL = false;
    private boolean instanceLockObtained = false;
    private boolean isResumeFromParent = false;
    private String copyDSContext = null;
    private boolean resumingSuspendedPI = false;
    private boolean removeDataslot = true;

    public boolean isRemoveDataslot() {
        return this.removeDataslot;
    }

    public void setRemoveDataslot(boolean removeDataslot) {
        this.removeDataslot = removeDataslot;
    }

    public boolean isExtEventsProcessedFromBL() {
        return this.extEventsProcessedFromBL;
    }

    public void setExtEventsProcessedFromBL(boolean extEventsProcessedFromBL) {
        this.extEventsProcessedFromBL = extEventsProcessedFromBL;
    }

    public boolean isPiCompletedOnCreatePIRequest() {
        return this.piCompletedOnCreatePIRequest;
    }

    public void setPiCompletedOnCreatePIRequest(boolean createPIRequest) {
        this.piCompletedOnCreatePIRequest = createPIRequest;
    }

    public WFProcessContext(Session s, long ptID, long piID) {
        this.sess = s;
        this.ptid = ptID;
        this.piid = piID;
        this.isDebug = DebugService.self().isDebug(this.piid);
    }

    public WFProcessContext(Session s, long piID) {
        this.sess = s;
        this.piid = piID;
        this.isDebug = DebugService.self().isDebug(this.piid);
    }

    public WFProcessContext(Session s, long piid, long ptid, String piname, long parentid, long rpiid, long rptid) {
        this.sess = s;
        this.parentid = parentid;
        this.ptid = ptid;
        this.rptid = rptid;
        this.piid = piid;
        this.rpiid = rpiid;
        this.piname = piname;
        this.isDebug = DebugService.self().isDebug(piid);
    }

    public WFProcessContext(Session s, ProcessInstanceEBLocal piEB) {
        this.sess = s;
        this.piid = piEB.getId();
        this.ptid = piEB.getProcessTemplateID();
        this.pieb = piEB;
        this.isDebug = DebugService.self().isDebug(this.piid);
    }

    public WFProcessContext(Session s, ProcessInstanceEBLocal piEB, WFProcess pt) {
        this.sess = s;
        this.piid = piEB.getId();
        this.ptid = piEB.getProcessTemplateID();
        this.pieb = piEB;
        this.pt = pt;
        this.isDebug = DebugService.self().isDebug(this.piid);
    }

    public WFProcessContext(Session s, long wiID, boolean isWIID) {
        WorkItemEBLocal wieb = BLUtil.self().getWorkItemEB(wiID);
        this.sess = s;
        this.piid = wieb.getProcessInstanceID();
        this.ptid = wieb.getProcessTemplateID();
        this.wiebList = new Hashtable();
        this.wiebList.put(wieb.getId(), wieb);
        this.isDebug = DebugService.self().isDebug(this.piid);
    }

    public WFProcessContext(Session s, WorkItemEBLocal wiEB) {
        this.sess = s;
        this.piid = wiEB.getProcessInstanceID();
        this.ptid = wiEB.getProcessTemplateID();
        this.wiebList = new Hashtable();
        this.wiebList.put(wiEB.getId(), wiEB);
        this.isDebug = DebugService.self().isDebug(this.piid);
    }

    public WFProcessContext(Session s, String piname) {
        this.sess = s;
        ProcessInstanceEBLocal piEb = this.getProcessInstanceEB(piname);
        this.piid = piEb.getId();
        this.ptid = piEb.getProcessTemplateID();
        this.pieb = piEb;
        this.piname = piname;
        this.isDebug = DebugService.self().isDebug(this.piid);
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    void setAdapterInvocationTime(long time) {
        this.adapterInvocationTime = time;
    }

    long getAdapterInvocationTime() {
        return this.adapterInvocationTime;
    }

    public void incrementLongSlotValue(String dsName, long value) {
        WFDataSlotInstance.self().incrementLongSlotValue(this, dsName, value);
    }

    public void appendStringSlotValue(String dsName, String value) {
        WFDataSlotInstance.self().appendStringSlotValue(this, dsName, value);
    }

    public boolean isWSActivationInLoop(long wsid) {
        return this.wsActivationInLoop == wsid;
    }

    public void setWSActivationInLoop(long wsid) {
        this.wsActivationInLoop = wsid;
    }

    public Session getSession() {
        return this.sess;
    }

    public Session getServerSession() {
        return BLControl.getServerSession();
    }

    public final long getProcessInstanceID() {
        return this.piid;
    }

    public final String getProcessInstanceName() {
        if (this.piname == null) {
            this.piname = this.getProcessInstanceEB().getName();
        }
        return this.piname;
    }

    public final String getWorkStepInstanceName(long wsid) {
        WFProcess pt = this.getProcess();
        WFWorkstep ws = pt.getWorkstep(wsid);
        String wsName = "";
        if (ws != null) {
            wsName = ws.getName();
        }
        return wsName;
    }

    public final long getProcessTemplateID() {
        if (this.ptid <= 0L) {
            this.ptid = this.getProcessInstanceEB().getProcessTemplateID();
        }
        return this.ptid;
    }

    public final long getRootTemplateID() {
        if (this.rptid <= 0L) {
            this.rptid = this.getProcessInstanceEB().getRootTemplateID();
        }
        return this.rptid;
    }

    public final long getRootInstanceID() {
        if (this.rpiid <= 0L) {
            this.rpiid = this.getProcessInstanceEB().getRootInstanceID();
        }
        return this.rpiid;
    }

    public final String getProcessTemplateName() {
        if (this.ptname == null) {
            this.ptname = this.getProcess().getName();
        }
        return this.ptname;
    }

    public final WFProcess getProcess() {
        if (this.pt != null) {
            return this.pt;
        }
        this.pt = this.isProcessInstanceDynamic() ? ProcessControl.getProcess(this.getProcessInstanceID()) : ProcessControl.getProcessTemplate(this.getProcessTemplateID());
        return this.pt;
    }

    public final boolean isProcessInstanceDynamic() {
        return this.getParentID() > 0L;
    }

    public final long getParentID() {
        if (this.parentid == -1L) {
            this.parentid = this.getProcessInstanceEB().getParentID();
        }
        return this.parentid;
    }

    public final void setCurrentWorkStepID(long wsid) {
        this.currentWSID = wsid;
    }

    public final WFWorkstep getCurrentWorkStep() {
        if (this.currentWSID > 0L) {
            return this.getWorkstep(this.currentWSID);
        }
        return null;
    }

    public final WFWorkstep getWorkstep(long wsid) {
        WFWorkstep ws;
        if (this.wsList == null) {
            this.wsList = new Hashtable();
        }
        if ((ws = (WFWorkstep)this.wsList.get(wsid)) == null) {
            ws = this.getProcess().getWorkstep(wsid);
            this.wsList.put(wsid, ws);
        }
        return ws;
    }

    public final WorkStepInstanceEBLocal getWorkstepInstanceEB(long wsid) {
        return this.getWorkstepInstanceEB(wsid, false);
    }

    public final WorkStepInstanceEBLocal getWorkstepInstanceEB(long wsid, boolean nullIfNotFound) {
        WorkStepInstanceEBLocal wsieb;
        if (this.wsiebList == null) {
            this.wsiebList = new Hashtable();
        }
        if ((wsieb = (WorkStepInstanceEBLocal)this.wsiebList.get(wsid)) == null) {
            try {
                if (nullIfNotFound) {
                    wsieb = BLUtil.self().getWorkStepInstanceEBThrowFinder(this.piid, wsid);
                } else {
                    try {
                        wsieb = BLUtil.self().getWorkStepInstanceEB(this.piid, wsid);
                    }
                    catch (BizLogicException e) {
                        wsieb = WFWorkstepInstance.single().createInstance(this, wsid);
                    }
                }
            }
            catch (FinderException e) {
                return null;
            }
            this.wsiebList.put(wsid, wsieb);
        }
        if (this.ptid <= 0L) {
            this.ptid = wsieb.getProcessTemplateID();
        }
        return wsieb;
    }

    public final ProcessInstanceEBLocal getProcessInstanceEB() {
        if (this.pieb == null) {
            this.pieb = BLUtil.self().getProcessInstanceEB(this.piid);
        }
        return this.pieb;
    }

    public final ProcessInstanceEBLocal getProcessInstanceEB(String piname) {
        if (this.pieb == null) {
            this.pieb = BLUtil.self().getProcessInstanceEB(piname);
        }
        return this.pieb;
    }

    public final WorkItemEBLocal getWorkItemEB(long wiid) {
        WorkItemEBLocal wieb;
        if (this.wiebList == null) {
            this.wiebList = new Hashtable();
        }
        if ((wieb = (WorkItemEBLocal)this.wiebList.get(wiid)) == null) {
            wieb = BLUtil.self().getWorkItemEB(wiid);
            this.wiebList.put(wiid, wieb);
        }
        return wieb;
    }

    public void cacheIt(long wsid, WorkStepInstanceEBLocal wsieb) {
        if (this.wsiebList == null) {
            this.wsiebList = new Hashtable();
        }
        this.wsiebList.put(wsid, wsieb);
    }

    public void cacheIt(long wiid, WorkItemEBLocal wieb) {
        if (this.wiebList == null) {
            this.wiebList = new Hashtable();
        }
        this.wiebList.put(wiid, wieb);
    }

    public final void updateSlotValue(String dsname, Object dsvalue) {
        HashMap<String, Object> dsNameValue = new HashMap<String, Object>();
        dsNameValue.put(dsname, dsvalue);
        this.updateSlotValue(dsNameValue);
    }

    public final void updateSlotValue(Map dsNameValueList) {
        WFDataSlotInstance.self().updateSlotValue(this, dsNameValueList);
    }

    public final void updateInstance(Map<String, Object> dsValues, Map<String, Object> attributes) {
        if (dsValues != null && !dsValues.isEmpty()) {
            this.updateSlotValue(dsValues);
        }
        if (attributes != null && !attributes.isEmpty()) {
            this.setProcessInstanceAttributes(new HashMap<String, Object>(attributes));
        }
    }

    public final HashMap getSlotsType() {
        return this.getProcess().getDataSlotsMetaInfo("TYPE");
    }

    public final HashMap getSlotsSize() {
        return this.getProcess().getDataSlotsMetaInfo("SIZE");
    }

    public final Object getSlotValue(String dsname) {
        return this.getSlotValue(dsname, false);
    }

    public Object getSlotValue(String dsname, boolean isPublic) {
        HashMap tmp = WFProcessInstance.self().getSlotValue(this, new String[]{dsname}, isPublic);
        return tmp.get(dsname);
    }

    public Object getExtBusinessObject(String dsName, Object pkInfo) {
        return WFProcessInstance.self().getExtBusinessObject(this, dsName, pkInfo);
    }

    public final Object getSlotValue(long wsid, String dsname) {
        WFWorkstep ws = this.getProcess().getWorkstep(wsid);
        HashMap tmp = WFWorkstepInstance.getWorkstepInstance(ws.getType()).getSlotValue(this, wsid, new String[]{dsname}, false);
        return tmp.get(dsname);
    }

    public final HashMap getSlotValue(String[] dsList) {
        return WFProcessInstance.self().getSlotValue(this, dsList, false);
    }

    public final HashMap getSlotValue(long wsid, String[] dsList) {
        WFWorkstep ws = this.getProcess().getWorkstep(wsid);
        return WFWorkstepInstance.getWorkstepInstance(ws.getType()).getSlotValue(this, wsid, dsList, false);
    }

    public final String getSlotType(String dsname) {
        return (String)this.getSlotsType().get(dsname);
    }

    public final HashMap getAllSlotValue() {
        return WFProcessInstance.self().getSlotValue(this, this.getAllSlotName(), true);
    }

    public final HashMap getInstanceSlotValue() {
        return this.getInstanceSlotValue(true);
    }

    public final HashMap getInstanceSlotValue(boolean isPublicOnly) {
        Vector instDS = this.getProcess().getInstanceDSNameList();
        String[] dsNames = new String[instDS.size()];
        dsNames = instDS.toArray(dsNames);
        return WFProcessInstance.self().getSlotValue(this, dsNames, isPublicOnly);
    }

    public final String[] getAllSlotName() {
        return this.getProcess().getAllDataSlotName();
    }

    public final WFDataslot getDataslot(String dsname) {
        return this.getProcess().getDataslot(dsname);
    }

    public Object getValueMappedSlotValue(String dsName, String mappedValue) {
        return WFProcessInstance.self().getValueMappedSlotValue(this, dsName, mappedValue);
    }

    public Object getSystemPredefinedSlotValue(String dsName) {
        return WFProcessInstance.self().getSystemPredefinedSlotValue(this, dsName);
    }

    public HashMap createCompleteDSlist() {
        return WFProcessInstance.self().createCompleteDSlist(this);
    }

    public static final WFProcessContext createProcessInstance(Session s, HashMap piAttrs, HashMap dsValues, boolean toActivate) {
        return WFProcessInstance.self().createInstance(s, piAttrs, dsValues, toActivate);
    }

    public static final WFProcessContext createProcessInstance(Session s, long ptID, HashMap piAttrs) {
        piAttrs.put("PROCESSTEMPLATEID", ptID);
        return WFProcessInstance.self().createInstance(s, piAttrs, null, false);
    }

    public final boolean removeProcessInstance(boolean forceRemove) {
        return WFProcessInstance.self().remove(this, forceRemove);
    }

    public final boolean removeProcessInstance(boolean forceRemove, boolean throwExIfSyncSubprocess) {
        if (throwExIfSyncSubprocess) {
            return WFProcessInstance.self().remove(this, forceRemove);
        }
        if (!this.isSyncSubProcessInstance()) {
            return WFProcessInstance.self().remove(this, forceRemove);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createDynamicProcessInstance(String xmld, boolean removeOnCompletion) {
        try {
            SessionManager.setThreadSession((Session)this.sess);
            long l = WFDynamicProcessInstance.create(this, xmld, removeOnCompletion);
            return l;
        }
        finally {
            SessionManager.removeThreadSession();
        }
    }

    public final void completeProcessInstance() {
        WFProcessInstance.self().complete(this);
    }

    public void suspendProcessInstance() {
        WFProcessInstance.self().suspend(this);
    }

    public final void activateProcessInstance() {
        WFProcessInstance.self().activate(this);
    }

    public void resumeProcessInstance() {
        WFProcessInstance.self().resume(this);
    }

    public void setProcessInstanceCaller(HashMap callerInfo, boolean isCallback) {
        WFProcessInstance.self().setCaller(this, callerInfo, isCallback);
    }

    public String[] getActivatedWorkStepNames() {
        return WFProcessInstance.self().getActiveWorksteps(this);
    }

    public String[] getSuspendedWorkStepNames() {
        return WFProcessInstance.self().getSuspendedWorksteps(this);
    }

    public String[] getCompletedWorkStepNames() {
        return WFProcessInstance.self().getCompletedWorksteps(this);
    }

    public final WorkStepInstanceEBLocal createWorkstepInstance(long wsid) {
        return WFWorkstepInstance.getWorkstepInstance(this.getWorkstep(wsid).getType()).createInstance(this, wsid);
    }

    public final void activateWorkstep(long wsid) {
        WFWorkstepInstance.getWorkstepInstance(this.getWorkstep(wsid).getType()).activate(this, wsid);
    }

    public final void activateMonitorWorkstep(long wsId) {
        WFWorkstepInstance.single().activateMonitorStep(this, wsId);
    }

    public final void completeWorkstep(long wsid) {
        this.lockRootOrInstanceDS(BLLockContext.WS, "WFProcessContext.completeWorkstep", wsid);
        if (this.getWorkstep(wsid).isMonitorStep() && WFWorkstepInstance.single().isEventActivationWaitState(this, wsid) && SMPConfig.self().isFireActivationEvent()) {
            this.activateMonitorWorkstep(wsid);
        }
        WFWorkstepInstance.getWorkstepInstance(this.getWorkstep(wsid).getType()).complete(this, wsid);
    }

    public final void terminateWorkstep(long wsid) {
        this.lockRootOrInstanceDS(BLLockContext.WS, "WFProcessContext.terminateWorkstep", wsid);
        WFWorkstep ws = this.getWorkstep(wsid);
        if (ws.isAtomic()) {
            WFAtomicInstance.self().terminate(this, wsid);
        } else if (ws.isMessageSubscriberWS()) {
            WFMessageSubscriberInstance.self().terminate(this, wsid);
        }
    }

    public void suspendWorkstep(long wsid, boolean reactivateOnError) {
        this.suspendWorkstep(wsid, reactivateOnError, null, null);
    }

    public void suspendWorkstep(long wsid, boolean reactivateOnError, Throwable causedBy, String reason) {
        WFWorkstepInstance wsi = WFWorkstepInstance.getWorkstepInstance(this.getWorkstep(wsid).getType());
        wsi.suspend(this, wsid, reactivateOnError, causedBy, reason);
    }

    public void resumeWorkstep(long wsid) {
        WFWorkstepInstance.getWorkstepInstance(this.getWorkstep(wsid).getType()).resume(this, wsid);
    }

    public final String getWorkstepRealPerformer(long wsid, String performerID) {
        return WFWorkstepInstance.getWorkstepInstance(this.getWorkstep(wsid).getType()).getRealPerformer(this, wsid, performerID);
    }

    public final Object[] getWorkstepData(long wsid, String perf) {
        return WFWorkstepInstance.getWorkstepInstance(this.getWorkstep(wsid).getType()).getData(this, wsid, perf);
    }

    public final int getWorkstepPriority(long wsid) {
        return WFWorkstepInstance.getWorkstepInstance(this.getWorkstep(wsid).getType()).getPriority(this, wsid);
    }

    public final Object getWorkstepRealPerformingApp(long wsid) {
        return WFWorkstepInstance.single().getRealPerformingApp(this, wsid);
    }

    public final String getWorkstepRealInstruction(long wsid) {
        return WFWorkstepInstance.getWorkstepInstance(this.getWorkstep(wsid).getType()).getRealInstruction(this, wsid);
    }

    public final boolean isWorkstepSuspendedByCompensatory(long wsid) {
        return WFWorkstepInstance.getWorkstepInstance(this.getWorkstep(wsid).getType()).isSuspendedByCompensatory(this, wsid);
    }

    public final boolean isWorkstepSuspended(long wsid) {
        return WFWorkstepInstance.getWorkstepInstance(this.getWorkstep(wsid).getType()).isSuspended(this, wsid);
    }

    public final boolean isWorkstepCompleted(long wsid) {
        return WFWorkstepInstance.getWorkstepInstance(this.getWorkstep(wsid).getType()).isCompleted(this, wsid);
    }

    public final boolean isWorkstepSkipped(long wsid) {
        return WFWorkstepInstance.getWorkstepInstance(this.getWorkstep(wsid).getType()).isSkipped(this, wsid);
    }

    public final boolean isWorkstepTerminated(long wsid) {
        return WFWorkstepInstance.getWorkstepInstance(this.getWorkstep(wsid).getType()).isTerminated(this, wsid);
    }

    public final HashMap getWorkstepInputSlotValueList(long wsid) {
        return WFWorkstepInstance.getWorkstepInstance(this.getWorkstep(wsid).getType()).getInputSlotValueByName(this, wsid);
    }

    public final HashMap getWorkstepOutputSlotValueList(long wsid) {
        return WFWorkstepInstance.getWorkstepInstance(this.getWorkstep(wsid).getType()).getOutputSlotValueByName(this, wsid);
    }

    public final void assignWorkItem(long wiid, String performer) {
        WFWorkItem.self().assignWorkItem(this, wiid, performer, true);
    }

    public final boolean assignWorkItemIfAvailable(long wiid, String performer) {
        try {
            if (this.getWorkItemEB(wiid).getState() != 27) {
                return false;
            }
            WFWorkItem.self().assignWorkItem(this, wiid, performer, false);
        }
        catch (Throwable th) {
            return false;
        }
        return true;
    }

    public void reAssignWorkItem(long wiid, String performer) {
        WFWorkItem.self().reAssignWorkItem(this, wiid, performer);
    }

    public void suspendWorkItem(long wiid, String reason) {
        WFWorkItem.self().suspend(this, wiid, reason);
    }

    public void resumeWorkItem(long wiid) {
        WFWorkItem.self().resume(this, wiid);
    }

    public final boolean isAvailableWorkItemPerformer(long wiid, String performer) {
        return WFWorkItem.self().isAvailablePerformer(this, wiid, performer);
    }

    public final boolean isAssignedWorkItemPerformer(long wiid, String performer) {
        return WFWorkItem.self().isAssignedPerformer(this, wiid, performer);
    }

    public final Vector getAvailableWorkItemPerformers(long wiid) {
        return WFWorkItem.self().getAvailablePerformers(this, wiid);
    }

    public int createWorkItem(long piId, String wsName, String performer, HashMap attributes, HashMap dsValues) {
        return -1;
    }

    public void completeWorkItem(long wiId, Map<String, Object> dsValues) {
        this.prepareForCompleteWorkItem(wiId, dsValues);
        WFWorkItem.self().complete(this, wiId);
    }

    public void completeWorkItem(long wiId, String wiPerformer, Map<String, Object> dsValues) {
        this.prepareForCompleteWorkItem(wiId, dsValues);
        WFWorkItem.self().complete(this, wiId, wiPerformer);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void prepareForCompleteWorkItem(long wiId, Map<String, Object> dsValues) {
        block3: {
            block2: {
                if (dsValues == null || dsValues.isEmpty()) break block2;
                if (dsValues.size() != 1) break block3;
                BLConstants.single();
                if (!dsValues.containsKey("@WORKSTEPID")) break block3;
            }
            this.lockRootOrInstanceDS(BLLockContext.WI, "WFProcessContext.prepareForCompleteWorkItem", wiId);
            return;
        }
        this.updateSlotValue(dsValues);
    }

    public void skipWorkItem(long wiId) {
        this.lockRootOrInstanceDS(BLLockContext.WI, "WFProcessContext.skipWorkItem", wiId);
        WFWorkItem.self().skip(this, wiId);
    }

    public void setProcessInstanceCompleteTime(long time) {
        this.piTimeCompleted = time;
    }

    public long getProcessInstanceCompleteTime() {
        return this.piTimeCompleted;
    }

    public Map<String, Object> getEventContext(int eventType) {
        return WFProcessInstance.self().getEventContext(this, eventType);
    }

    public void reactivateWorkStep(String wsName) {
        WFWorkstepInstance.single().reactivate(this, wsName);
    }

    public Vector getWorkStepExecutedList(String wsIDpath) {
        if (wsIDpath == null || wsIDpath.length() == 0) {
            return null;
        }
        Vector<String> names = new Vector<String>();
        if (wsIDpath != null) {
            StringTokenizer tokens = new StringTokenizer(wsIDpath, ";");
            while (tokens.hasMoreTokens()) {
                WFWorkstep ws = this.getWorkstep(Integer.parseInt(tokens.nextToken()));
                names.addElement(ws.getName());
            }
        }
        return names;
    }

    public void removeWorkItem(long wiID) {
        WFWorkItem.self().remove(this, wiID);
    }

    public void addWorkItem(long wsID, String wiPerformer, String wiSuffix, int priority, long duedate) {
        WFWorkItem.self().add(this, wsID, wiPerformer, wiSuffix, priority, duedate);
    }

    public final String getStartWorkStepName() {
        String wsName = WFProcessInstance.self().getStartPoint(this);
        if (wsName == null) {
            wsName = this.getProcess().getInitialWorkstep().getName();
        }
        return wsName;
    }

    public void makeAvailable(long wsid, Vector performers) {
        WFAtomicInstance.self().makeAvailable(this, wsid, performers);
    }

    public final void setProcessInstanceAttributes(HashMap attributes) {
        WFProcessInstance.self().setAttributes(this, attributes);
    }

    public final void setWorkStepInstanceAttributes(long wsid, HashMap attributes) {
        WFWorkstepInstance.single().setAttributes(this, wsid, attributes);
    }

    public final void setWorkItemAttributes(long wiid, HashMap attributes) {
        WFWorkItem.self().setAttributes(this, wiid, attributes);
    }

    public final boolean isSubProcessInstance() {
        ProcessInstanceEBLocal pieb = this.getProcessInstanceEB();
        return pieb.isSubProcessInstance();
    }

    public final boolean isSyncSubProcessInstance() {
        ProcessInstanceEBLocal pieb = this.getProcessInstanceEB();
        return pieb.isSyncSubProcessInstance();
    }

    public final String getXMLContent(String dsName) {
        XML xmlDS = (XML)this.getSlotValue(dsName);
        long docid = xmlDS.getID();
        if (docid > 0L) {
            return XMLDocRepository.getContent(docid);
        }
        return null;
    }

    public final boolean isCompProcessRunning() {
        return this.isCompProcess;
    }

    public final boolean isCompleteCaller() {
        return this.completeCallerPIID > 0L;
    }

    public final void setCompleteCallerID(long completeCaller) {
        this.completeCallerPIID = completeCaller;
    }

    public final long getCompleteCallerID() {
        return this.completeCallerPIID;
    }

    public User getUser(String performer) {
        User user;
        if (performer == null) {
            return null;
        }
        if (this.users == null) {
            this.users = new HashMap();
        }
        if ((user = (User)this.users.get(performer)) == null) {
            user = BLUtil.getUser((String)performer);
            this.users.put(performer, user);
        }
        return user;
    }

    public String getUserEmailAddress(String performer) {
        User user = this.getUser(performer);
        return PerformerUtil.getUserEmailAddress((User)user);
    }

    protected void finalize() throws Throwable {
        this.wsList = null;
        this.wsiebList = null;
        this.wiebList = null;
        this.users = null;
        super.finalize();
    }

    public void addAndWSInSameTx(long wsid) {
        if (this.andWSInSameTxList == null) {
            this.andWSInSameTxList = new ArrayList(2);
        }
        this.andWSInSameTxList.add(wsid);
    }

    public boolean isAndActivatedInSameTx(long wsid) {
        return this.andWSInSameTxList != null && this.andWSInSameTxList.contains(wsid);
    }

    public boolean isPICompleted() {
        if (this.piTimeCompleted > 0L) {
            return !WFProcessInstance.self().isExist(this.piid);
        }
        return false;
    }

    public void overrideEmailSupport(boolean isEmailSupport) {
        this.emailSupport = isEmailSupport;
    }

    public boolean isEmailSupport() {
        return this.emailSupport;
    }

    public void setSVO(ProcessInstance svo) {
        this.pisvo = svo;
    }

    public ProcessInstance getSVO() {
        return this.pisvo;
    }

    void setInstanceCreation(boolean bval) {
        this.instanceCreation = bval;
    }

    boolean isInstanceCreation() {
        return this.instanceCreation;
    }

    public void setIsInstanceMigration(boolean bool) {
        this.isInstanceMigration = bool;
    }

    public void setSendSUpdateEvent(boolean bool) {
        this.sendSUpdateEvent = bool;
    }

    public boolean sendSUpdateEvent() {
        return this.sendSUpdateEvent;
    }

    public boolean isInstanceMigration() {
        return this.isInstanceMigration;
    }

    public HashMap getVoteDetails() {
        return this.voteDetails;
    }

    public void setVoteDetails(HashMap map) {
        this.voteDetails = map;
    }

    public void cacheDueDateBefPreScript(long wsid, long dueDate) {
        this.wsiDueDateBefPreScript.put(wsid, dueDate);
    }

    public long getDueDateBefPreScript(long wsid) {
        Long dueDate = (Long)this.wsiDueDateBefPreScript.get(wsid);
        if (dueDate == null) {
            return -1L;
        }
        return dueDate;
    }

    public long calculateDueDate(long wsid) {
        if (this.getWorkstep(wsid).isAtomic()) {
            return WFAtomicInstance.self().getWSIDueDate(this, wsid, null);
        }
        return this.getWorkstepInstanceEB(wsid).getDuedate();
    }

    public boolean isDueDateSetForWs(long wsid) {
        return "DUEDATE_SET_FOR_WS".equals(this.getWorkstepInstanceEB(wsid, false).getMilestoneName());
    }

    public void setDueDateSetForWs(long wsid) {
        this.getWorkstepInstanceEB(wsid, false).setMileStone("DUEDATE_SET_FOR_WS", "");
    }

    public void clearDueDateSetForWs(long wsid) {
        this.getWorkstepInstanceEB(wsid, false).setMileStone("", "");
    }

    public boolean hasResources() {
        return this.resourceMap != null && !this.resourceMap.isEmpty();
    }

    public void setResources(Hashtable resources) {
        this.resourceMap = resources;
    }

    public Hashtable getResources() {
        return this.resourceMap;
    }

    public final void forceSave() {
        if (this.wsiebList != null) {
            try {
                Object[] arWsieb = this.wsiebList.values().toArray();
                if (arWsieb != null && arWsieb.length > 0) {
                    for (int i = 0; i < arWsieb.length; ++i) {
                        WorkStepInstanceEBLocal wsieb = (WorkStepInstanceEBLocal)arWsieb[i];
                        wsieb.save();
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public final boolean isPISuspended() {
        return this.getProcessInstanceEB().getState() == 8;
    }

    public final void addValidPreCondWSId(long wsid) {
        this.validPreCondWSIdList.add(wsid);
    }

    public final boolean isWSPreConditionValid(long wsid) {
        if (this.validPreCondWSIdList.contains(wsid)) {
            this.validPreCondWSIdList.remove(wsid);
            return true;
        }
        return false;
    }

    public boolean isWsDueDateSet() {
        return this.wsDueDateSet;
    }

    public void setWsDueDateSet(boolean dueDateSet) {
        this.wsDueDateSet = dueDateSet;
    }

    public boolean isProcessRefresh() {
        return this.isProcessRefresh;
    }

    public void setProcessRefresh(boolean flag) {
        this.isProcessRefresh = flag;
    }

    public long createCWorkItems(long parentWIID, List<String> collaborators, String taskNameAlias, Map<String, Object> cwiData) {
        return WFCWorkItem.self().create(this, parentWIID, collaborators, taskNameAlias, cwiData);
    }

    public void reAssignCWorkItem(long cWorkItemId, String collaborator) {
        WFCWorkItem.self().reAssign(this, cWorkItemId, collaborator);
    }

    public void declineCWorkItem(long cWorkItemId, String reason) {
        WFCWorkItem.self().decline(this, cWorkItemId, reason);
    }

    public void assignCWorkItem(long cWorkItemId, String collaborator) {
        WFCWorkItem.self().assign(this, cWorkItemId, collaborator);
    }

    public void suspendCWorkItem(long cWorkItemId) {
        WFCWorkItem.self().suspend(this, cWorkItemId);
    }

    public void resumeCWorkItem(long cWorkItemId) {
        WFCWorkItem.self().resume(this, cWorkItemId);
    }

    public void terminateCWorkItem(long cWorkItemId) {
        WFCWorkItem.self().terminate(this, cWorkItemId);
    }

    public void completeCWorkItem(long cWorkItemId, HashMap dsValues, HashMap modifiedAttrs) {
        WFCWorkItem.self().complete(this, cWorkItemId, dsValues, modifiedAttrs);
    }

    public long createProcessNotes(String notes, Map<String, Object> processNotesInfo) {
        return WFProcessNotes.self().create(this, notes, processNotesInfo);
    }

    public Map<String, Integer> getRealUsersFromDataSlot(String dsName, boolean expandGroup, boolean allowQueue, boolean removeInvalid) {
        return WFProcessInstance.self().getRealUsersFromDataSlot(this, dsName, expandGroup, allowQueue, removeInvalid);
    }

    public final long getWorkStepInstanceID(String wsName) {
        WFProcess pt = this.getProcess();
        WFWorkstep ws = pt.getWorkstep(wsName);
        return ws.getID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public XORHelper getXORHelper() {
        if (this.XORHelperObj != null) return this.XORHelperObj;
        Class<WFProcessContext> clazz = WFProcessContext.class;
        synchronized (WFProcessContext.class) {
            if (this.XORHelperObj != null) return this.XORHelperObj;
            this.XORHelperObj = new XORHelper();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.XORHelperObj;
        }
    }

    public boolean isXORHelperExist() {
        return this.XORHelperObj != null;
    }

    public void setInstanceLockObtained(boolean obtained) {
        this.instanceLockObtained = obtained;
    }

    public boolean instanceLockObtained() {
        return this.instanceLockObtained;
    }

    boolean lockRootInstanceDS(BLLockContext blLockCtx, String context, Object ... debugValues) {
        if (this.instanceLockObtained()) {
            return true;
        }
        if (!BLUtil.self().rootInstanceDSLockEnabled() || !this.isSyncSubProcessInstance()) {
            return false;
        }
        String iDSTableName = ProcessControl.getProcessTemplate(this.getRootTemplateID()).getDSTableName();
        if (BLControl.util.DEBUG_LOCK) {
            BLControl.logger.debugKey("BizLogic_ERR_8120", new Object[]{"root instance dataslot", blLockCtx.getName(), this.getProcessInstanceID(), context, Thread.currentThread().getName()});
        }
        try {
            BLLockDAO.processInstance(this.getRootInstanceID(), this.getRootTemplateID(), context, iDSTableName, false);
        }
        catch (BizLogicException ble) {
            if (BLControl.util.DEBUG_LOCK) {
                BLControl.logger.debugKey("BizLogic_ERR_8124", new Object[]{blLockCtx.getName(), this.getProcessInstanceID(), this.getRootInstanceID(), ble.getMessage(), context, Thread.currentThread().getName()});
            }
            return false;
        }
        this.setInstanceLockObtained(true);
        if (BLControl.util.DEBUG_LOCK) {
            List<Object> debugVal = debugValues == null ? new ArrayList() : Arrays.asList(debugValues);
            BLControl.logger.debugKey("BizLogic_ERR_8121", new Object[]{"root instance dataslot", blLockCtx.getName(), this.getProcessInstanceID(), debugVal, context, Thread.currentThread().getName()});
        }
        return true;
    }

    void lockInstanceDS(BLLockContext blLockCtx, String context, Object ... debugValues) {
        if (this.instanceLockObtained()) {
            return;
        }
        if (this.isLockEnabled(blLockCtx)) {
            if (BLControl.util.DEBUG_LOCK) {
                BLControl.logger.debugKey("BizLogic_ERR_8120", new Object[]{"instance dataslot", blLockCtx.getName(), this.getProcessInstanceID(), context, Thread.currentThread().getName()});
            }
            BLLockDAO.processInstance(this.getProcessInstanceID(), this.getProcessTemplateID(), context, this.getProcess().getDSTableName(), true);
            this.setInstanceLockObtained(true);
            if (BLControl.util.DEBUG_LOCK) {
                List<Object> debugVal = debugValues == null ? new ArrayList() : Arrays.asList(debugValues);
                BLControl.logger.debugKey("BizLogic_ERR_8121", new Object[]{"instance dataslot", blLockCtx.getName(), this.getProcessInstanceID(), debugVal, context, Thread.currentThread().getName()});
            }
        } else if (BLControl.util.DEBUG_LOCK) {
            BLControl.logger.debugKey("BizLogic_ERR_8122", new Object[]{this.getProcessInstanceID(), blLockCtx.getName(), context, Thread.currentThread().getName()});
        }
    }

    public void lockRootOrInstanceDS(BLLockContext blLockCtx, String context, Object ... debugValues) {
        if (this.isLockEnabled(blLockCtx)) {
            boolean rootLockObtained = this.lockRootInstanceDS(blLockCtx, context, debugValues);
            if (!rootLockObtained) {
                this.lockInstanceDS(blLockCtx, context, debugValues);
            }
        } else if (BLControl.util.DEBUG_LOCK) {
            BLControl.logger.debugKey("BizLogic_ERR_8122", new Object[]{this.getProcessInstanceID(), blLockCtx.getName(), context, Thread.currentThread().getName()});
        }
    }

    private boolean isLockEnabled(BLLockContext blLockCtx) {
        boolean lockEnabled = false;
        if (blLockCtx.isPI() || blLockCtx.isWI() || blLockCtx.isPIDS()) {
            lockEnabled = true;
        } else if (blLockCtx.isWS() && BLUtil.self().isDSLockEnabledForWS()) {
            lockEnabled = true;
        }
        return lockEnabled;
    }

    public void setResumeFromParent(boolean isResumeFromParent) {
        this.isResumeFromParent = isResumeFromParent;
    }

    public boolean isResumeFromParent() {
        return this.isResumeFromParent;
    }

    public String getDefaultPerformer(long wsid) {
        if (!this.getWorkstep(wsid).isAtomic()) {
            return null;
        }
        return WFAtomicInstance.self().getDefaultPerformer(this, wsid);
    }

    public String getMonitorDSValue() {
        return WFDataSlotInstance.self().getMonitorDSValue(this);
    }

    public void setCopyDSContext(String srcDS) {
        this.copyDSContext = srcDS;
    }

    public String getCopyDSContext() {
        return this.copyDSContext;
    }

    public void setResumingSuspendedPI(boolean isPIResuming) {
        this.resumingSuspendedPI = isPIResuming;
    }

    public boolean isResumingSuspendedPI() {
        return this.resumingSuspendedPI;
    }

    class XORHelper {
        List<Long> wsMarkedForTermination = null;
        private long activatorWsId = -1L;

        XORHelper() {
        }

        public void markWSForTermination(long wsid) {
            if (this.wsMarkedForTermination == null) {
                this.wsMarkedForTermination = new ArrayList<Long>();
            }
            this.wsMarkedForTermination.add(wsid);
        }

        public void removeFromTerminationList(long wsid) {
            if (this.wsMarkedForTermination != null) {
                this.wsMarkedForTermination.remove(wsid);
            }
        }

        public boolean isMarkedForTermination(Long wsid) {
            if (this.wsMarkedForTermination == null) {
                return false;
            }
            return this.wsMarkedForTermination.contains(wsid);
        }

        public void setActivatorWsId(long wsid) {
            this.activatorWsId = wsid;
        }

        public long getActivatorWsId() {
            return this.activatorWsId;
        }
    }
}

