/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import bsh.Interpreter;
import bsh.Parser;
import bsh.TargetError;
import com.savvion.ejb.bizlogic.manager.BizLogicManager;
import com.savvion.ejb.bizlogic.manager.BizLogicManagerHome;
import com.savvion.sbm.bizlogic.server.JSTools;
import com.savvion.sbm.bizlogic.server.WFProcessContext;
import com.savvion.sbm.bizlogic.server.ejb.BLServer;
import com.savvion.sbm.bizlogic.server.ejb.BLServerHome;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.Session;
import com.savvion.sbm.util.FileUtil;
import com.savvion.sbm.util.SBMControl;
import com.savvion.sbm.util.SBMUtil;
import com.savvion.sbm.util.ServiceLocator;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Vector;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;

public final class WFJavaScript
implements Serializable {
    static final long serialVersionUID = 8571603771445324503L;
    protected static final int OPTIMIZATION_LEVEL = 9;
    protected static Scriptable gscope = null;
    protected static String jsFileName = null;
    private String preCondition = null;
    private String preFunction = null;
    private String postFunction = null;
    private String compFunction = null;
    private String perfFunction = null;
    private String dueFunction = null;
    private int preFunctionType = -1;
    private int postFunctionType = -1;
    private int compFunctionType = -1;
    private int dueFunctionType = -1;
    protected transient Script preCondCompileObj;
    protected transient Script preCompileObj;
    protected transient Script postCompileObj;
    protected transient Script compCompileObj;
    protected transient Script perfCompileObj;
    protected transient Script dueCompileObj;

    WFJavaScript() {
    }

    protected void setPreCondition(String precond) throws BizLogicException {
        this.preCondCompileObj = WFJavaScript.compileJS(precond, "PRECOND");
        this.preCondition = this.preCondCompileObj == null ? null : precond;
    }

    protected void setPreFunction(String pre, int preType) throws BizLogicException {
        if (preType == 201) {
            this.preCompileObj = WFJavaScript.compileJS(pre, "PRE");
            this.preFunction = this.preCompileObj == null ? null : pre;
        } else if (preType == 205) {
            this.preFunction = pre;
        }
        this.preFunctionType = preType;
    }

    protected void setPostFunction(String post, int postType) throws BizLogicException {
        if (postType == 201) {
            this.postCompileObj = WFJavaScript.compileJS(post, "POST");
            this.postFunction = this.postCompileObj == null ? null : post;
        } else if (postType == 205) {
            this.postFunction = post;
        }
        this.postFunctionType = postType;
    }

    protected void setCompFunction(String comp, int compType) throws BizLogicException {
        if (compType == 201) {
            this.compCompileObj = WFJavaScript.compileJS(comp, "COMP");
            this.compFunction = this.compCompileObj == null ? null : comp;
        } else if (compType == 205) {
            this.compFunction = comp;
        }
        this.compFunctionType = compType;
    }

    protected void setPerformerFunction(String perf) throws BizLogicException {
        this.perfCompileObj = WFJavaScript.compileJS(perf, "ASSIGN");
        this.perfFunction = this.perfCompileObj == null ? null : perf;
    }

    protected void setDueFunction(String dueAction, int dueType) throws BizLogicException {
        if (dueType == 201) {
            this.dueCompileObj = WFJavaScript.compileJS(dueAction, "DUE");
            this.dueFunction = this.dueCompileObj == null ? null : dueAction;
        } else if (dueType == 205) {
            this.dueFunction = dueAction;
        }
        this.dueFunctionType = dueType;
    }

    public String getPreCondition() {
        return this.preCondition;
    }

    public String getPreFunction() {
        return this.preFunction;
    }

    public int getPreFunctionType() {
        return this.preFunctionType;
    }

    public String getPostFunction() {
        return this.postFunction;
    }

    public int getPostFunctionType() {
        return this.postFunctionType;
    }

    public String getCompFunction() {
        return this.compFunction;
    }

    public int getCompFunctionType() {
        return this.compFunctionType;
    }

    public String getPerformerFunction() {
        return this.perfFunction;
    }

    public String getDueFunction() {
        return this.dueFunction;
    }

    public int getDueFunctionType() {
        return this.dueFunctionType;
    }

    public Script getPreCompileObj() {
        return this.preCompileObj;
    }

    public Script getPostCompileObj() {
        return this.postCompileObj;
    }

    public Script getCompCompileObj() {
        return this.compCompileObj;
    }

    public Script getPerformerCompileObj() {
        return this.perfCompileObj;
    }

    public Script getDueCompileObj() {
        return this.getCompileObj("DUE");
    }

    public boolean hasScript(String scriptLocation) {
        if (scriptLocation == null) {
            return false;
        }
        if (scriptLocation.equals("PRE") && WFJavaScript.isValidScript(this.preFunction)) {
            return true;
        }
        if (scriptLocation.equals("POST") && WFJavaScript.isValidScript(this.postFunction)) {
            return true;
        }
        if (scriptLocation.equals("COMP") && WFJavaScript.isValidScript(this.compFunction)) {
            return true;
        }
        if (scriptLocation.equals("DUE") && WFJavaScript.isValidScript(this.dueFunction)) {
            return true;
        }
        if (scriptLocation.equals("PRECOND") && WFJavaScript.isValidScript(this.preCondition)) {
            return true;
        }
        return scriptLocation.equals("ASSIGN") && WFJavaScript.isValidScript(this.perfFunction);
    }

    public static boolean isValidScript(String scriptCode) {
        return scriptCode != null && !scriptCode.trim().isEmpty();
    }

    public Script getCompileObj(String scriptLocation) {
        if (scriptLocation == null) {
            return null;
        }
        if (scriptLocation.equals("PRECOND")) {
            return this.preCondCompileObj;
        }
        if (scriptLocation.equals("PRE")) {
            return this.preCompileObj;
        }
        if (scriptLocation.equals("POST")) {
            return this.postCompileObj;
        }
        if (scriptLocation.equals("COMP")) {
            return this.compCompileObj;
        }
        if (scriptLocation.equals("ASSIGN")) {
            return this.perfCompileObj;
        }
        if (scriptLocation.equals("DUE")) {
            if (this.dueFunction != null && this.dueCompileObj == null) {
                this.dueCompileObj = WFJavaScript.compileJS(this.dueFunction, "DUE");
            }
            return this.dueCompileObj;
        }
        return null;
    }

    public String getJavaScriptCode(String scriptLocation) {
        if (scriptLocation == null) {
            return "";
        }
        if (scriptLocation.equals("PRECOND")) {
            return this.preCondition;
        }
        if (scriptLocation.equals("PRE")) {
            return this.preFunction;
        }
        if (scriptLocation.equals("POST")) {
            return this.postFunction;
        }
        if (scriptLocation.equals("COMP")) {
            return this.compFunction;
        }
        if (scriptLocation.equals("ASSIGN")) {
            return this.perfFunction;
        }
        if (scriptLocation.equals("DUE")) {
            return this.dueFunction;
        }
        return "";
    }

    private String getJavaCode(String scriptLocation) {
        if (scriptLocation == null) {
            return "";
        }
        if (scriptLocation.equals("PRE")) {
            return this.preFunction;
        }
        if (scriptLocation.equals("POST")) {
            return this.postFunction;
        }
        if (scriptLocation.equals("COMP")) {
            return this.compFunction;
        }
        if (scriptLocation.equals("DUE")) {
            return this.dueFunction;
        }
        return "";
    }

    public int getScriptType(String scriptLocation) {
        if (scriptLocation.equals("PRE")) {
            if (this.preFunctionType <= 0) {
                this.preFunctionType = 201;
            }
            return this.preFunctionType;
        }
        if (scriptLocation.equals("POST")) {
            if (this.postFunctionType <= 0) {
                this.postFunctionType = 201;
            }
            return this.postFunctionType;
        }
        if (scriptLocation.equals("COMP")) {
            if (this.compFunctionType <= 0) {
                this.compFunctionType = 201;
            }
            return this.compFunctionType;
        }
        if (scriptLocation.equals("DUE")) {
            if (this.dueFunctionType <= 0) {
                this.dueFunctionType = 201;
            }
            return this.dueFunctionType;
        }
        return -1;
    }

    protected static Script compileJS(String js, String scriptLocation) throws BizLogicException {
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.debug((Object)"JSCRIPT:compileJS:");
        }
        if (js == null) {
            return null;
        }
        if (js.compareTo("") == 0) {
            BLControl.logger.warnKey("BizLogic_ERR_611", new Object[]{js});
            return null;
        }
        Context cx = Context.enter();
        cx.setOptimizationLevel(9);
        StringReader sr = new StringReader(js);
        Script compObj = null;
        try {
            Scriptable tscope = cx.newObject(gscope);
            tscope.setPrototype(gscope);
            compObj = cx.compileReader(tscope, (Reader)sr, scriptLocation, 1, null);
            if (BLControl.util.DEBUG_ENGINE) {
                BLControl.logger.debugKey("BizLogic_ERR_609", new Object[]{js});
            }
        }
        catch (Exception e) {
            BLControl.logger.errorKey("BizLogic_ERR_605", new Object[]{js}, (Throwable)e);
            BizLogicException be = new BizLogicException("BizLogic_ERR_605", "WFJavaScript.compileJS", new Object[]{js});
            be.appendMessage(SBMUtil.getStackTrace((Throwable)e));
            throw be;
        }
        finally {
            Context.exit();
            cx = null;
        }
        return compObj;
    }

    protected void reCompileJavaScript() throws Exception {
        if (this.preCondition != null) {
            this.preCondCompileObj = WFJavaScript.compileJS(this.preCondition, "PRECOND");
        }
        if (this.preFunction != null && (this.preFunctionType <= 0 || this.preFunctionType == 201)) {
            this.preCompileObj = WFJavaScript.compileJS(this.preFunction, "PRE");
        }
        if (this.postFunction != null && (this.postFunctionType <= 0 || this.postFunctionType == 201)) {
            this.postCompileObj = WFJavaScript.compileJS(this.postFunction, "POST");
        }
        if (this.compFunction != null && (this.compFunctionType <= 0 || this.compFunctionType == 201)) {
            this.compCompileObj = WFJavaScript.compileJS(this.compFunction, "COMP");
        }
        if (this.perfFunction != null) {
            this.perfCompileObj = WFJavaScript.compileJS(this.perfFunction, "ASSIGN");
        }
        if (this.dueFunction != null) {
            this.dueCompileObj = WFJavaScript.compileJS(this.dueFunction, "DUE");
        }
    }

    public static void init() {
        block14: {
            File jsf = null;
            Context cx = null;
            try {
                Object blHome;
                cx = Context.enter();
                cx.setOptimizationLevel(9);
                cx.setCompileFunctionsWithDynamicScope(true);
                gscope = cx.initStandardObjects(null);
                ImporterTopLevel imp = new ImporterTopLevel();
                BizLogicManager blManager = null;
                try {
                    String beanName = "BizLogicManager";
                    beanName = ServiceLocator.self().appendLocalJNDIPrefix(beanName);
                    blHome = (BizLogicManagerHome)SBMControl.homeFactory.lookupHome(ServiceLocator.self().getAppServerID(), beanName, BizLogicManagerHome.class);
                    blManager = blHome.create();
                }
                catch (Throwable th) {
                    throw new BizLogicException("BizLogic_ERR_2533", "WFJavaScript.init");
                }
                BLServer blServer = null;
                try {
                    blHome = (BLServerHome)SBMControl.homeFactory.lookupHome(BLServerHome.class);
                    blServer = blHome.create();
                }
                catch (Throwable th) {
                    throw new BizLogicException("BizLogic_ERR_1527", "WFJavaScript.init", new Object[]{"BLServerHome"});
                }
                gscope.put("blserver", gscope, (Object)Context.toObject((Object)blServer, (Scriptable)gscope));
                gscope.put("pak", gscope, (Object)Context.toObject((Object)blManager, (Scriptable)gscope));
                gscope.put("imp", gscope, (Object)Context.toObject((Object)imp, (Scriptable)gscope));
                gscope.put("out", gscope, (Object)Context.toObject((Object)System.out, (Scriptable)gscope));
                gscope.put("BLLogger", gscope, (Object)Context.toObject((Object)BLControl.logger, (Scriptable)gscope));
                String jsfile = SBMControl.util.SBM_HOME + "/BizLogic/common.js";
                jsf = new File(jsfile);
                if (!jsf.exists()) break block14;
                FileReader fr = null;
                try {
                    fr = new FileReader(jsf);
                    cx.evaluateReader(gscope, (Reader)fr, jsfile, 1, null);
                    BLControl.logger.infoKey("BizLogic_ERR_1003", null);
                }
                catch (Exception ex) {
                    try {
                        throw new BizLogicException("BizLogic_ERR_612", "WFJavaScript.init", new Object[]{jsfile}, (Throwable)ex);
                    }
                    catch (Throwable throwable) {
                        FileUtil.close(fr);
                        throw throwable;
                    }
                }
                FileUtil.close((Reader)fr);
                jsFileName = jsfile;
            }
            catch (BizLogicException be) {
                throw be;
            }
            catch (Throwable th) {
                throw new BizLogicException("BizLogic_ERR_643", "WFJavaScript.init", th);
            }
            finally {
                Context.exit();
                cx = null;
                jsf = null;
            }
        }
    }

    public static Object executeScript(WFProcessContext pCtx, long wsid, WFJavaScript js, String scriptLocation) {
        int scriptType = js.getScriptType(scriptLocation);
        BLConstants.single();
        if (scriptType == 201) {
            return WFJavaScript.executeJS(pCtx, wsid, js, scriptLocation);
        }
        BLConstants.single();
        if (scriptType == 205) {
            return WFJavaScript.executeJavaCode(pCtx, wsid, null, js.getJavaCode(scriptLocation));
        }
        return null;
    }

    public static final Object executeJS(WFProcessContext pCtx, long wsid, WFJavaScript js, String scriptLocation) {
        Context jsCtx = Context.enter();
        JSTools jst = new JSTools(pCtx, wsid);
        Vector<String> retValue = null;
        try {
            Scriptable tscope = jsCtx.newObject(gscope);
            tscope.setPrototype(gscope);
            tscope.put("jst", tscope, (Object)Context.toObject((Object)jst, (Scriptable)tscope));
            Script sobj = js.getCompileObj(scriptLocation);
            if (sobj != null) {
                retValue = sobj.exec(jsCtx, tscope);
            }
            if (scriptLocation.equals("ASSIGN")) {
                if (BLControl.util.DEBUG_ENGINE) {
                    BLControl.logger.debug((Object)("Return of AssignScript:" + js.getPerformerFunction() + (retValue != null ? retValue.getClass().getName() : "null")));
                }
                if (!(retValue instanceof NativeArray)) {
                    throw new BizLogicException("BizLogic_ERR_2609", "WFJavaScript.executeJS", new Object[]{js.getPerformerFunction()});
                }
                Object[] retA = jsCtx.getElements(Context.toObject((Object)retValue, (Scriptable)tscope));
                Vector<String> retV = new Vector<String>();
                for (int j = 0; j < retA.length; ++j) {
                    retV.addElement(Context.toString((Object)retA[j]));
                }
                retValue = retV;
            } else if (scriptLocation.equals("PRECOND") && BLControl.util.DEBUG_ENGINE) {
                BLControl.logger.debug((Object)("workstep: " + wsid + "Return value of PreCondition JS: " + (retValue != null ? retValue.getClass().getName() : "null") + "  value:" + ((Object)retValue).toString()));
            }
            return retValue;
        }
        catch (Throwable th) {
            throw new BizLogicException("BizLogic_ERR_1504", "WFJavaScript.executeJS", new Object[]{scriptLocation, String.valueOf(pCtx.getProcessInstanceID()), wsid == -1L ? "" : pCtx.getWorkStepInstanceName(wsid), js.getJavaScriptCode(scriptLocation)}, th);
        }
    }

    public static final Object executeJS(WFProcessContext pCtx, String wfObjName, String js, Script jScript, String scriptLocation) {
        Context jsCtx = Context.enter();
        JSTools jst = new JSTools(pCtx, wfObjName);
        Object retValue = null;
        try {
            Scriptable tscope = jsCtx.newObject(gscope);
            tscope.setPrototype(gscope);
            tscope.put("jst", tscope, (Object)Context.toObject((Object)jst, (Scriptable)tscope));
            if (jScript == null) {
                throw new BizLogicException("BizLogic_ERR_1695", "WFJavaScript.executeJS", new Object[]{String.valueOf(pCtx.getProcessInstanceID()), wfObjName, js});
            }
            retValue = jScript.exec(jsCtx, tscope);
            return retValue;
        }
        catch (BizLogicException ble) {
            throw ble;
        }
        catch (Throwable th) {
            throw new BizLogicException("BizLogic_ERR_1504", "WFJavaScript.executeJS", new Object[]{scriptLocation, String.valueOf(pCtx.getProcessInstanceID()), wfObjName, js}, th);
        }
    }

    public static final void parseJavaCode(String code) {
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.debug((Object)"java code :parse begins:");
        }
        if (code == null) {
            throw new BizLogicException("BizLogic_ERR_1696", "WFJavaScript.parseJavaCode");
        }
        try {
            StringReader readerObj = new StringReader(code);
            Parser parser = new Parser((Reader)readerObj);
            parser.setRetainComments(true);
            while (!parser.Line()) {
                if (!BLControl.util.DEBUG_ENGINE) continue;
                BLControl.logger.debug((Object)parser.popNode());
            }
        }
        catch (Throwable th) {
            throw new BizLogicException("BizLogic_ERR_1697", "WFJavaScript.parseJavaCode", new Object[]{code}, th);
        }
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.debugKey("BizLogic_ERR_2136", new Object[]{code});
        }
    }

    public static final Object executeJavaCode(WFProcessContext pCtx, long wfObjId, String wfObjName, String code) {
        JSTools jst = null;
        jst = wfObjId > 0L ? new JSTools(pCtx, wfObjId) : new JSTools(pCtx, wfObjName);
        Object retValue = null;
        BLServer blServer = null;
        Interpreter interpreter = null;
        try {
            BLServerHome blHome = (BLServerHome)SBMControl.homeFactory.lookupHome(BLServerHome.class);
            blServer = blHome.create();
        }
        catch (Throwable th) {
            throw new BizLogicException("BizLogic_ERR_1527", "WFJavaScript.executeJavaCode", new Object[]{"BLServerHome"});
        }
        try {
            interpreter = new Interpreter();
            interpreter.setClassLoader(WFJavaScript.class.getClassLoader());
            interpreter.setStrictJava(true);
            interpreter.eval(JS_VAR.JST.getVarForEval());
            interpreter.eval(JS_VAR.BLSERVER.getVarForEval());
            interpreter.set(JS_VAR.JST.getVarName(), (Object)jst);
            interpreter.set(JS_VAR.BLSERVER.getVarName(), (Object)blServer);
            retValue = interpreter.eval(code);
        }
        catch (TargetError e) {
            Throwable t = e.getTarget();
            throw new BizLogicException("BizLogic_ERR_1698", "WFJavaScript.executeJavaCode", new Object[]{code, t, wfObjId, wfObjName}, (Throwable)e);
        }
        catch (Throwable th) {
            throw new BizLogicException("BizLogic_ERR_1699", "WFJavaScript.executeJavaCode", new Object[]{code, wfObjId, wfObjName}, th);
        }
        finally {
            if (interpreter != null) {
                interpreter.setStrictJava(false);
            }
        }
        return retValue;
    }

    public static void addServerSession(Session session) {
        try {
            Context.enter();
            gscope.put("bl_session", gscope, (Object)Context.toObject((Object)session, (Scriptable)gscope));
        }
        finally {
            Context.exit();
        }
    }

    private static enum JS_VAR {
        JST("jst", "com.savvion.sbm.bizlogic.server.JSTools"),
        BLSERVER("blserver", "com.savvion.sbm.bizlogic.server.ejb.BLServer");

        private String varName;
        private String varClass;
        private String varEval;

        private JS_VAR(String varName, String varClass) {
            this.varName = varName;
            this.varClass = varClass;
            this.varEval = varClass + " " + varName;
        }

        String getVarName() {
            return this.varName;
        }

        String getVarClass() {
            return this.varClass;
        }

        String getVarForEval() {
            return this.varEval;
        }
    }
}

