/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.savvion.sbm.bizlogic.server.DebugService;
import com.savvion.sbm.bizlogic.server.EPManager;
import com.savvion.sbm.bizlogic.server.WFExternalWS;
import com.savvion.sbm.bizlogic.server.WFProcessContext;
import com.savvion.sbm.bizlogic.server.WFWorkstepInstance;
import com.savvion.sbm.bizlogic.server.dao.ProcessInstanceDAO;
import com.savvion.sbm.bizlogic.server.ejb.WorkStepInstanceEBLocal;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicAppException;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.Session;
import java.lang.constant.Constable;
import java.util.HashMap;
import javax.jms.Message;

public class WFExternalInstance
extends WFWorkstepInstance {
    private static WFExternalInstance self;

    private WFExternalInstance() {
    }

    private void init() {
    }

    public static WFExternalInstance self() {
        if (self == null) {
            self = new WFExternalInstance();
        }
        return self;
    }

    @Override
    public void execute(WFProcessContext pCtx, long wsid) {
        this.sendMessage(pCtx, wsid);
    }

    public void sendMessage(WFProcessContext pCtx, long wsid) {
        HashMap<String, Constable> epMsg = new HashMap<String, Constable>();
        WFExternalWS ws = (WFExternalWS)pCtx.getWorkstep(wsid);
        epMsg.put("PROCESSTEMPLATEID", Long.valueOf(pCtx.getProcessTemplateID()));
        epMsg.put("PROCESSINSTANCEID", Long.valueOf(pCtx.getProcessInstanceID()));
        epMsg.put("WORKSTEPID", Long.valueOf(wsid));
        epMsg.put("SYNCHRONOUS", Boolean.valueOf(ws.isSynchron()));
        BLConstants.ClusterConstants cfr_ignored_0 = BLControl.consts.cluster;
        BLConstants.ClusterConstants cfr_ignored_1 = BLControl.consts.cluster;
        epMsg.put("REPEAT_MSG_COUNT", Integer.valueOf(1));
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
        int loopCounter = wsieb.getLoopCounter();
        epMsg.put("LOOPCOUNTER", Integer.valueOf(loopCounter));
        if (ws.isInLineTask() || pCtx.isDebug() && DebugService.self().isInlineTask(ws)) {
            this.runInSameThread(ws, wsieb, epMsg);
        } else {
            try {
                String useName = "ep";
                if (ws.isEnterpriseAdapter()) {
                    useName = "enterpriseadapter";
                }
                BLControl.util.epHandler.notify(epMsg, useName);
                if (pCtx.isDebug()) {
                    long piid = pCtx.getProcessInstanceID();
                    if (DebugService.self().isForceCompleteWS(piid)) {
                        BLControl.logger.info((Object)("As force complete is true for asynchronous adapter workstep <" + ws.getName() + "> with output dataslots, the workstep is completed"));
                        pCtx.completeWorkstep(wsid);
                    }
                }
            }
            catch (BizLogicAppException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInSameThread(WFExternalWS ws, WorkStepInstanceEBLocal wsieb, HashMap admMsg) {
        EPManager adm = null;
        try {
            if (BLControl.util.DEBUG_EP) {
                BLControl.logger.debugKey("BizLogic_ERR_3529", new Object[]{"BEGINS", wsieb.getProcessInstanceID(), wsieb.getId(), wsieb.getName(), Thread.currentThread().getName()});
            }
            wsieb.save();
            adm = EPManager.getInstance();
            adm.setTransactionType("CT");
            adm.execute(admMsg);
            if (BLControl.util.DEBUG_EP) {
                BLControl.logger.debugKey("BizLogic_ERR_3529", new Object[]{"ENDS", wsieb.getProcessInstanceID(), wsieb.getId(), wsieb.getName(), Thread.currentThread().getName()});
            }
        }
        catch (Throwable throwable) {
            EPManager.putInstance(adm);
            throw throwable;
        }
        EPManager.putInstance(adm);
    }

    public boolean processMessage(Message msg, String adapterType) {
        return super.processMessage(msg, adapterType, true);
    }

    @Override
    public void complete(WFProcessContext pCtx, long wsid) {
        if (pCtx.getWorkstep(wsid).isMonitorStep()) {
            this.completeMonitorStep(pCtx, wsid);
            return;
        }
        this.validateCompletion(pCtx, wsid);
        long piid = pCtx.getProcessInstanceID();
        if (!ProcessInstanceDAO.isProcessInstanceExist(piid)) {
            BLControl.logger.errorKey("BizLogic_ERR_862", new Object[]{piid, "external", wsid});
            return;
        }
        super.complete(pCtx, wsid);
        if (pCtx.getWorkstepInstanceEB(wsid).getState() != 21) {
            return;
        }
        BLUtil.fireEvent(this.getEventContext(pCtx, wsid, 21), (int)21);
        super.afterComplete(pCtx, wsid);
        if (!this.isSuspendedByCompensatory(pCtx, wsid)) {
            this.activateNextWorksteps(pCtx, wsid);
        }
    }

    private void completeMonitorStep(WFProcessContext pCtx, long wsid) {
        this.validateCompletion(pCtx, wsid);
        long piid = pCtx.getProcessInstanceID();
        if (!ProcessInstanceDAO.isProcessInstanceExist(piid)) {
            BLControl.logger.errorKey("BizLogic_ERR_862", new Object[]{piid, "external", wsid});
            return;
        }
        super.complete(pCtx, wsid);
        if (pCtx.getWorkstepInstanceEB(wsid).getState() != 21) {
            return;
        }
        if (BLControl.util.DEBUG_ENGINE || BLControl.util.DEBUG_MONITORING) {
            Object[] objectArray = new Object[3];
            objectArray[0] = pCtx.getProcessInstanceID();
            objectArray[1] = wsid;
            objectArray[2] = 21;
            BLControl.logger.debugKey("BizLogic_ERR_4303", "WFExternalInstance.completeMonitorStep", objectArray);
        }
        BLUtil.fireEvent(this.getEventContext(pCtx, wsid, 21), (int)21);
        super.afterComplete(pCtx, wsid);
        if (!this.isSuspendedByCompensatory(pCtx, wsid)) {
            this.activateNextWorksteps(pCtx, wsid);
        }
    }

    public void completeCallerWorkstep(Session ses, long piid, long wsid, HashMap dsValues) {
        WFProcessContext pCtx = new WFProcessContext(ses, piid);
        int type = pCtx.getWorkstep(wsid).getType();
        if (type != 107) {
            throw new BizLogicException("BizLogic_ERR_2691", "WFExternalInstance.completeCallerWorkStep", new Object[]{"WFExternalInstance.completeCallerWorkStep"});
        }
        super.completeCallerWorkstep(pCtx, wsid, dsValues);
        pCtx.completeWorkstep(wsid);
    }

    @Override
    public void skip(WFProcessContext pCtx, long wsID) {
        super.skip(pCtx, wsID);
    }
}

