/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.savvion.sbm.bizlogic.server.WFDataslot;
import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.server.WFWorkstep;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BOExpression;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.util.jax.SBMDOMParserFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WFAtomicWS
extends WFWorkstep {
    static final long serialVersionUID = -8384331584540495642L;
    private String role;
    private boolean performedByAll = true;
    boolean EmailSupport = false;
    private String excludedPerformerXML = null;
    private HashMap excludedPerformerOfWS = new HashMap();
    private HashSet excludedStaticPerformer = new HashSet();
    private HashSet excludedMappedDSPerformer = new HashSet();
    private String excludedJNDIPerformer = null;
    static transient boolean ISEXCLUDELASTPERFORMER_DEFAULT = true;
    private boolean isTrackWorkItemPerformer = false;
    int performingAppType = -1;
    boolean performingAppPrivate = false;
    private boolean voteEnabled = false;
    private boolean isCollaborationEnabled = false;
    private final List<Map> collaborators = new CopyOnWriteArrayList<Map>();
    private String defaultPerformer = null;

    public WFAtomicWS(int type, String name, String performer) {
        this.setName(name);
        this.setType(type);
        this.hasPerformer = performer;
    }

    public WFAtomicWS(int type, String name, String performer, boolean who, String rol) {
        this.setName(name);
        this.setType(type);
        this.hasPerformer = performer;
        this.performedByAll = who;
        this.role = rol;
    }

    void setDefaultPerformer(String performer) {
        this.defaultPerformer = performer;
    }

    public String getDefaultPerformer() {
        return this.defaultPerformer;
    }

    public void setEmailSupport(boolean s) {
        this.EmailSupport = s;
    }

    public boolean getEmailSupport() {
        return this.EmailSupport;
    }

    protected String getAdditionalStatus() {
        return "";
    }

    public void setPerformedByAll(boolean b) {
        this.performedByAll = b;
    }

    public boolean getPerformedByAll() {
        return this.performedByAll;
    }

    public String getRole() {
        return this.role;
    }

    @Override
    public HashMap getAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("PERFORMEDBYALL", this.performedByAll);
        attributes.put("ROLE", this.role);
        attributes.put("EMAIL", this.EmailSupport);
        attributes.put("EXCLUDED_PERFORMER", this.excludedPerformerXML);
        attributes.put("COLLABORATION_ENABLED", this.isCollaborationEnabled());
        if (this.isCollaborationEnabled()) {
            attributes.put("COLLABORATORS", this.getCollaborators());
        }
        if (this.defaultPerformer != null) {
            attributes.put("DEFAULT_PERFORMER", this.defaultPerformer);
        }
        attributes.putAll(super.getAttributes());
        return attributes;
    }

    @Override
    public void setAttributes(HashMap hm) {
        Iterator iter = hm.keySet().iterator();
        while (iter.hasNext()) {
            boolean val;
            String key = (String)iter.next();
            if (key.equals("PERFORMEDBYALL")) {
                val = (Boolean)hm.get(key);
                this.setPerformedByAll(val);
                iter.remove();
                continue;
            }
            if (key.equals("EMAIL")) {
                val = (Boolean)hm.get(key);
                this.setEmailSupport(val);
                iter.remove();
                continue;
            }
            if (!key.equals("EXCLUDED_PERFORMER")) continue;
            this.setExcludedPerformer(hm.get("EXCLUDED_PERFORMER").toString(), true);
            iter.remove();
        }
        super.setAttributes(hm);
    }

    public void setExcludedPerformer(String xmlString, boolean validate) {
        if (xmlString != null && xmlString.trim().length() > 0) {
            this.parseExcludedPerformerXML(xmlString);
            if (validate) {
                this.validateExcludePerformer();
            }
            this.excludedPerformerXML = xmlString;
        } else {
            this.excludedPerformerOfWS.clear();
            this.excludedStaticPerformer.clear();
            this.excludedMappedDSPerformer.clear();
            this.excludedJNDIPerformer = null;
            this.excludedPerformerXML = null;
        }
    }

    public String getExcludedPerformer() {
        return this.excludedPerformerXML;
    }

    private void parseExcludedPerformerXML(String xmlString) {
        Document doc = null;
        try {
            doc = SBMDOMParserFactory.self().getDocument(xmlString, false);
        }
        catch (Exception ex) {
            throw new BizLogicException("BizLogic_ERR_768", "WFAtmoicWS::setExcludedPerformer", new Object[]{xmlString}, (Throwable)ex);
        }
        HashSet<String> staticPerformer = new HashSet<String>();
        HashSet<String> mappedDSPerformer = new HashSet<String>();
        HashMap<String, Boolean> performerOfWS = new HashMap<String, Boolean>();
        String jndiPerformer = null;
        NodeList nl = doc.getChildNodes();
        if (nl.getLength() == 1) {
            if ("excludeperformers".equalsIgnoreCase(nl.item(0).getNodeName())) {
                nl = nl.item(0).getChildNodes();
                Node n = null;
                String nodeName = null;
                String nodeValue = null;
                String nodeAttr = null;
                for (int ix = 0; ix < nl.getLength(); ++ix) {
                    n = nl.item(ix);
                    nodeName = n.getNodeName().toLowerCase();
                    if ("#text".equals(nodeName)) continue;
                    nodeValue = n.getAttributes().getNamedItem("name").getNodeValue();
                    if ("performer".equals(nodeName)) {
                        BLConstants.single();
                        if (nodeValue.startsWith("@")) {
                            BLConstants.single();
                            mappedDSPerformer.add(nodeValue.substring("@".length()));
                            continue;
                        }
                        BLConstants.single();
                        if (nodeValue.startsWith("jndi://")) {
                            jndiPerformer = nodeValue;
                            continue;
                        }
                        staticPerformer.add(nodeValue);
                        continue;
                    }
                    if ("performerof".equals(nodeName)) {
                        Node attrNode = n.getAttributes().getNamedItem("lastperformer");
                        if (attrNode != null) {
                            nodeAttr = attrNode.getNodeValue();
                        }
                        boolean isLastPerformer = ISEXCLUDELASTPERFORMER_DEFAULT;
                        if (nodeAttr != null) {
                            isLastPerformer = Boolean.valueOf(nodeAttr);
                        }
                        performerOfWS.put(nodeValue, isLastPerformer);
                        continue;
                    }
                    throw new BizLogicException("BizLogic_ERR_768", "WFAtmoicWS::setExcludedPerformer", new Object[]{xmlString});
                }
                this.excludedStaticPerformer = staticPerformer;
                this.excludedMappedDSPerformer = mappedDSPerformer;
                this.excludedPerformerOfWS = performerOfWS;
                this.excludedJNDIPerformer = jndiPerformer;
                return;
            }
            throw new BizLogicException("BizLogic_ERR_768", "WFAtmoicWS::setExcludedPerformer", new Object[]{xmlString});
        }
        throw new BizLogicException("BizLogic_ERR_779", "WFAtomicWS::setExcludedPerformer", new Object[]{"Exclude", "exclude performer", this.getProcessName() + "::" + this.getName()});
    }

    public HashSet getStaticExcludedPerformer() {
        return this.excludedStaticPerformer;
    }

    public HashSet getMappedExcludedPerformer() {
        return this.excludedMappedDSPerformer;
    }

    public String getJNDIExcludedPerformer() {
        return this.excludedJNDIPerformer;
    }

    public HashMap getExcludedPerformerOfWS() {
        return this.excludedPerformerOfWS;
    }

    public void setIsTrackWorkItemPerformer(boolean isTrack) {
        this.isTrackWorkItemPerformer = isTrack;
    }

    public boolean isTrackWorkItemPerformer() {
        return this.isTrackWorkItemPerformer;
    }

    public boolean isWebApp() {
        BLConstants.PerfAppConstants cfr_ignored_0 = BLControl.consts.perfApp;
        return this.performingAppType == 1;
    }

    public void setPerformingAppType(int type) {
        this.performingAppType = type;
    }

    public boolean isPerformingAppPrivate() {
        return this.performingAppPrivate;
    }

    public void setPerformingAppPrivate(boolean privateAccess) {
        this.performingAppPrivate = privateAccess;
    }

    private void validateExcludePerformer() {
        Iterator<Object> i = null;
        if (this.excludedPerformerOfWS != null && !this.excludedPerformerOfWS.isEmpty()) {
            HashMap wsidList = new HashMap(this.excludedPerformerOfWS.size());
            String wsName = null;
            WFWorkstep ws = null;
            Object var5_5 = null;
            for (Map.Entry entry : this.excludedPerformerOfWS.entrySet()) {
                wsName = (String)entry.getKey();
                try {
                    ws = this.getParentProcess().getWorkstep(wsName);
                }
                catch (BizLogicException bex) {
                    bex.appendMessage(", but the performer of this workstep has been excluded for another workstep <" + this.getProcessName() + "::" + this.getName() + ">");
                    throw bex;
                }
                int n = ws.getType();
                BLConstants.single();
                if (n != 102) {
                    throw new BizLogicException("BizLogic_ERR_766", "WFAtomicWS::validate()", new Object[]{ws.getName(), this.getName()});
                }
                ((WFAtomicWS)ws).setIsTrackWorkItemPerformer(true);
                wsidList.put(ws.getID(), entry.getValue());
            }
            this.excludedPerformerOfWS = wsidList;
        }
        if (this.excludedMappedDSPerformer != null && !this.excludedMappedDSPerformer.isEmpty()) {
            String dsName = null;
            WFProcess pt = this.getParentProcess();
            WFDataslot ds = null;
            i = this.excludedMappedDSPerformer.iterator();
            while (i.hasNext()) {
                dsName = i.next().toString();
                try {
                    ds = pt.getDataslot(dsName);
                }
                catch (BizLogicException bizLogicException) {
                    bizLogicException.appendMessage(", but the value of this dataslot has been specified as excluded performer for workstep <" + this.getProcessName() + "::" + this.getName() + ">");
                    throw bizLogicException;
                }
                String string = ds.getType();
                BLConstants.single();
                if (string.equals("STRING")) continue;
                String string2 = ds.getType();
                BLConstants.single();
                if (string2.equals("LIST")) continue;
                String string3 = ds.getType();
                BLConstants.single();
                if (string3.equals("SET")) continue;
                throw new BizLogicException("BizLogic_ERR_767", "WFAtomicWS::validate", new Object[]{this.getName()});
            }
        }
    }

    @Override
    public boolean validate() {
        this.validateExcludePerformer();
        this.validateDefaultPerformer();
        this.validateCollaborators();
        super.validate();
        return true;
    }

    private void validateDefaultPerformer() {
        if (this.defaultPerformer != null && this.defaultPerformer.trim().length() != 0 && BLUtil.isParameter((String)this.defaultPerformer)) {
            String ptName = this.parentProcess.getName();
            String dsName = BLUtil.getParameter((String)this.defaultPerformer);
            if (!BOExpression.isObjExpression((String)dsName)) {
                WFDataslot ds = this.getParentProcess().getDataslot(dsName, true);
                if (ds == null) {
                    throw new BizLogicException("BizLogic_ERR_3812", "WFAtomicWS.validateDefaultPerformer", new Object[]{ptName, this.getName(), this.defaultPerformer});
                }
                if (!ds.isString()) {
                    throw new BizLogicException("BizLogic_ERR_4508", "WFWorkstep.validateDefaultPerformer", new Object[]{dsName, this.getName(), ptName});
                }
            } else {
                BOExpression.validate((WFProcess)this.parentProcess, (String)dsName);
            }
        }
    }

    private void validateCollaborators() {
        if (!this.isCollaborationEnabled()) {
            return;
        }
        if (this.collaborators != null && !this.collaborators.isEmpty()) {
            String ptName = this.parentProcess.getName();
            for (Map collaborationInfo : this.collaborators) {
                String collaborator = (String)collaborationInfo.get("COLLABORATOR");
                if (!BLUtil.isParameter((String)collaborator)) continue;
                String dsName = BLUtil.getParameter((String)collaborator);
                if (BOExpression.isObjExpression((String)collaborator)) {
                    BOExpression.validate((WFProcess)this.parentProcess, (String)dsName);
                    continue;
                }
                BLConstants.single();
                if ("CREATOR".equalsIgnoreCase(dsName)) continue;
                WFDataslot ds = this.getParentProcess().getDataslot(dsName, true);
                if (ds == null) {
                    throw new BizLogicException("BizLogic_ERR_3812", "WFAtomicWS.validateCollaborators", new Object[]{ptName, this.getName(), collaborator});
                }
                if (ds.isString() || ds.isList()) continue;
                throw new BizLogicException("BizLogic_ERR_3909", "WFWorkstep.validateCollaborators", new Object[]{dsName, this.getName(), ptName});
            }
        }
    }

    public void setVoteEnabled(boolean votingEnabled) {
        this.voteEnabled = votingEnabled;
    }

    public boolean isVoteEnabled() {
        return this.voteEnabled;
    }

    public void setCollaboration(boolean collaborationEnabled, List<Map> collaborators) {
        this.isCollaborationEnabled = collaborationEnabled;
        if (collaborationEnabled && collaborators != null) {
            this.collaborators.addAll(collaborators);
        }
    }

    public boolean isCollaborationEnabled() {
        return this.isCollaborationEnabled;
    }

    public List<Map> getCollaborators() {
        return this.collaborators;
    }

    public List<String> getCollaborators(int type) {
        ArrayList<String> typedCollaborators = new ArrayList<String>();
        for (int ix = 0; ix < this.collaborators.size(); ++ix) {
            Map collaboratorInfo = this.collaborators.get(ix);
            Integer collType = (Integer)collaboratorInfo.get("COLLABORATOR_TYPE");
            if (collType != type) continue;
            String collaborator = (String)collaboratorInfo.get("COLLABORATOR");
            typedCollaborators.add(collaborator);
        }
        return typedCollaborators;
    }
}

