/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.savvion.sbm.bizlogic.enums.PTState;
import com.savvion.sbm.bizlogic.scheduler.BLScheduler;
import com.savvion.sbm.bizlogic.server.DataSlotTableIndex;
import com.savvion.sbm.bizlogic.server.ProcessInfo;
import com.savvion.sbm.bizlogic.server.WFAppObject;
import com.savvion.sbm.bizlogic.server.WFDataSlotInstance;
import com.savvion.sbm.bizlogic.server.WFDataslot;
import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.server.WFProcessReplaceInfo;
import com.savvion.sbm.bizlogic.server.WFWorkstep;
import com.savvion.sbm.bizlogic.server.WFimportProcess;
import com.savvion.sbm.bizlogic.server.XMLDocRepository;
import com.savvion.sbm.bizlogic.server.dao.BLLockDAO;
import com.savvion.sbm.bizlogic.server.dao.BLResourcesDAO;
import com.savvion.sbm.bizlogic.server.dao.DataSlotDAO;
import com.savvion.sbm.bizlogic.server.dao.MilestoneDAO;
import com.savvion.sbm.bizlogic.server.dao.PTReplaceInfoDAO;
import com.savvion.sbm.bizlogic.server.dao.ProcessInstanceDAO;
import com.savvion.sbm.bizlogic.server.dao.ProcessInstanceTemplateDAO;
import com.savvion.sbm.bizlogic.server.dao.ProcessNotesDAO;
import com.savvion.sbm.bizlogic.server.dao.ProcessTemplateDAO;
import com.savvion.sbm.bizlogic.server.dao.ProcessXMLDAO;
import com.savvion.sbm.bizlogic.server.dao.RemovePiDAO;
import com.savvion.sbm.bizlogic.server.svo.DocumentDS;
import com.savvion.sbm.bizlogic.server.svo.ProcessTemplate;
import com.savvion.sbm.bizlogic.server.svo.XML;
import com.savvion.sbm.bizlogic.smp.MPService;
import com.savvion.sbm.bizlogic.util.BCLService;
import com.savvion.sbm.bizlogic.util.BLAlertService;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLDAOService;
import com.savvion.sbm.bizlogic.util.BLDocService;
import com.savvion.sbm.bizlogic.util.BLJMSService;
import com.savvion.sbm.bizlogic.util.BLProcessCacheService;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.DBConstants;
import com.savvion.sbm.bizlogic.util.ProcessContext;
import com.savvion.sbm.bizlogic.util.ProcessType;
import com.savvion.sbm.bizlogic.util.Session;
import com.savvion.sbm.dms.DSContext;
import com.savvion.sbm.dms.svo.DocumentFolder;
import com.savvion.sbm.util.DBService;
import com.savvion.sbm.util.FileUtil;
import com.savvion.sbm.util.SBMConstants;
import com.savvion.sbm.util.SBMContext;
import com.savvion.sbm.util.SBMControl;
import com.savvion.sbm.util.SBMDatabase;
import com.savvion.sbm.util.SBMUtil;
import com.savvion.sbm.util.ServiceLocator;
import com.savvion.sbm.util.callback.ProcessCallback;
import com.tdiinc.userManager.User;
import com.tdiinc.userManager.UserManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class ProcessControl
extends BLDAOService {
    private static Hashtable PTCache;
    private static final int UPDATE_DS_BATCH_SIZE = 1000;

    public static synchronized void initCache() {
        PTCache = new Hashtable();
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.debug((Object)"ProcessControl.loadCache(): Loading cache...");
        }
        PTCache = ProcessTemplateDAO.getProcessTemplateList();
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.debug((Object)("ProcessControl.loadCache(): Total number of process(es) are = " + PTCache.size()));
        }
    }

    public static void clearCache() {
        ProcessControl.doClearCache();
        try {
            BLConstants.ClusterConstants cfr_ignored_0 = BLControl.consts.cluster;
            BLJMSService.self().sendPTCacheChangeNotification("CLEAR_PT_CACHE");
        }
        catch (Throwable th) {
            throw new BizLogicException("BizLogic_ERR_9102", "ProcessControl.clearCache()", th);
        }
    }

    public static synchronized void doClearCache() {
        PTCache = new Hashtable();
    }

    public static WFProcess getProcessTemplate(long ptid) {
        WFProcess ptObject = (WFProcess)PTCache.get(ptid);
        if (ptObject == null) {
            if (BLControl.util.isClustering()) {
                ptObject = ProcessControl.addProcessTemplateToCache(ptid);
            }
            if (ptObject == null) {
                throw new BizLogicException("BizLogic_ERR_519", "ProcessControl.getPT", new Object[]{ptid});
            }
        }
        return ptObject;
    }

    public static WFProcess getProcessTemplate(long ptid, boolean force) {
        WFProcess ptObject = null;
        if (force) {
            ptObject = ProcessControl.addProcessTemplateToCache(ptid);
        }
        if (ptObject == null) {
            throw new BizLogicException("BizLogic_ERR_519", "ProcessControl.getPT", new Object[]{ptid});
        }
        return ptObject;
    }

    public static WFProcess getCurrentProcessTemplate(String appName) {
        Collection ptCollection = ProcessControl.getAllProcessTemplates();
        for (WFProcess ptObject : ptCollection) {
            if (!ptObject.getAppName().equals(appName) || ptObject.isSuspendedBySeqVersion() || !ptObject.isActivated() && !ptObject.isSuspended()) continue;
            return ptObject;
        }
        return null;
    }

    public static WFProcess getActiveProcessTemplate(String appName) {
        Collection ptCollection = ProcessControl.getAllProcessTemplates();
        for (WFProcess ptObject : ptCollection) {
            if (!ptObject.getAppName().equals(appName) || !ptObject.isActivated()) continue;
            return ptObject;
        }
        return null;
    }

    public static WFProcess getProcessTemplate(String ptName) {
        WFProcess ptObject = null;
        Enumeration pvalues = PTCache.elements();
        while (pvalues.hasMoreElements()) {
            ptObject = (WFProcess)pvalues.nextElement();
            if (!ptObject.getName().equalsIgnoreCase(ptName)) continue;
            return ptObject;
        }
        if (BLControl.util.isClustering() && (ptObject = ProcessTemplateDAO.load(ptName)) != null) {
            return ptObject;
        }
        throw new BizLogicException("BizLogic_ERR_519", "ProcessControl.getPT", new Object[]{ptName});
    }

    static boolean isProcessExists(String ptName) {
        WFProcess ptObject = null;
        Enumeration pvalues = PTCache.elements();
        while (pvalues.hasMoreElements()) {
            ptObject = (WFProcess)pvalues.nextElement();
            if (!ptObject.getName().equalsIgnoreCase(ptName)) continue;
            return true;
        }
        return false;
    }

    static boolean isProcessExists(long ptid) {
        Long ptidKey = null;
        Enumeration pkeys = PTCache.keys();
        while (pkeys.hasMoreElements()) {
            ptidKey = (Long)pkeys.nextElement();
            if (ptidKey != ptid) continue;
            return true;
        }
        return false;
    }

    public static synchronized WFProcess addProcessTemplateToCache(long ptid) {
        WFProcess ptObject = ProcessTemplateDAO.load(ptid);
        if (ptObject != null) {
            ProcessControl.addProcessTemplateToCache(ptid, ptObject);
        }
        return ptObject;
    }

    public static synchronized boolean addProcessTemplateToCache(long ptid, Object ptobj) {
        if (BLControl.util.DEBUG_UTIL) {
            BLControl.logger.debug((Object)("ProcessControl.addProcessTemplateToCache(): Adding <" + ptid + "," + ((WFProcess)ptobj).getName() + "> to process template cache ..."));
        }
        if (ptobj != null) {
            PTCache.put(ptid, ptobj);
            WFProcess ptObject = (WFProcess)ptobj;
            ProcessCallback.addTemplateName((String)ptObject.getAppName(), (String)ptObject.getName());
            if (BLScheduler.self().isStarted()) {
                if (BLScheduler.self().isPaused() && ProcessControl.isMonitoringProcessInstalled()) {
                    BLScheduler.self().resume();
                } else if (BLScheduler.self().isResumed() && !ProcessControl.isMonitoringProcessInstalled()) {
                    BLScheduler.self().pause();
                }
            }
            return true;
        }
        return false;
    }

    public static synchronized void removeAlertsFromCache(long ptid) {
        WFProcess pt = (WFProcess)PTCache.get(ptid);
        if (pt != null && pt.hasProcessAlerts()) {
            BLAlertService.single().removeAlertsFromCache(pt.getName());
            if (BLControl.util.DEBUG_ALERTS) {
                BLControl.logger.debugKey("BizLogic_ERR_3161", "ProcessControl.removeAlertsFromCache", new Object[]{pt.getName(), ptid});
            }
        }
    }

    public static synchronized WFProcess removeProcessTemplateFromCache(long ptid) {
        WFProcess pt = (WFProcess)PTCache.remove(ptid);
        if (pt != null) {
            BLProcessCacheService.self().onRemove(ptid, pt.getName());
            ProcessCallback.removeTemplateName((String)pt.getAppName(), (String)pt.getName());
            if (pt.isMonitoringProcess()) {
                ProcessControl.removeMonitorEventData(pt.getName());
            }
            BLLockDAO.removePtSqlFromCache(ptid);
            if (BLControl.util.DEBUG_UTIL) {
                BLControl.logger.debug((Object)("ProcessControl.removeProcessTemplateFromCache(): Removing <" + ptid + "," + pt.getName() + "> to process template cache ..."));
            }
        }
        if (BLScheduler.self().isStarted() && BLScheduler.self().isResumed() && !ProcessControl.isMonitoringProcessInstalled()) {
            BLScheduler.self().pause();
        }
        return pt;
    }

    public static synchronized void removeProcessTemplates(Session ses, boolean force) {
        ProcessControl.doRemoveProcessTemplates(ses, force);
        if (!PTCache.isEmpty()) {
            ProcessControl.doRemoveProcessTemplates(ses, force);
        }
    }

    public static synchronized void doRemoveProcessTemplates(Session ses, boolean force) {
        int i;
        ArrayList ptList = new ArrayList(PTCache.keySet());
        ArrayList<Long> unremovedPTs = new ArrayList<Long>();
        for (i = 0; i < ptList.size(); ++i) {
            long ptid = (Long)ptList.get(i);
            if (ProcessControl.removePT(ses, ptid, force)) continue;
            unremovedPTs.add(ptid);
        }
        if (!unremovedPTs.isEmpty()) {
            BLControl.logger.warnKey("BizLogic_ERR_867", new Object[]{unremovedPTs.toString()});
        }
        for (i = 0; i < ptList.size(); ++i) {
            Long ptidInCache = (Long)ptList.get(i);
            if (unremovedPTs.contains(ptidInCache)) continue;
            ProcessControl.removeProcessTemplateFromCache(ptidInCache);
        }
    }

    public static synchronized void removeProcessTemplate(Session ses, long id, boolean force) {
        if (ProcessControl.removePT(ses, id, force)) {
            ProcessControl.removeProcessTemplateFromCache(id);
        }
    }

    public static ProcessTemplate replace(Session session, long ptid, String xmldefinition) {
        WFProcess pt = ProcessControl.getProcessTemplate(ptid);
        if (xmldefinition == null) {
            xmldefinition = pt.getName() + ".xml";
        }
        ProcessTemplate ptsvo = BLUtil.getServiceLocal().replaceProcess(session, pt, xmldefinition);
        if (BLUtil.self().isPTRNewDSUpdate()) {
            ProcessControl.updateNewDataSlotsForPTR(session, ProcessControl.getProcessTemplate(ptid));
        }
        return ptsvo;
    }

    public static long getProcessTemplateId(String ptName) {
        WFProcess pt = ProcessControl.getProcessTemplate(ptName);
        return pt.getID();
    }

    static boolean shouldRemoveDataslot() {
        return !ServiceLocator.self().isJBossCommunity() || !ServiceLocator.self().isOracle();
    }

    private static synchronized boolean removePT(Session ses, long ptId, boolean force) {
        String ptName = ProcessControl.getProcessTemplate(ptId).getName();
        if (force) {
            ProcessControl.removeAllProcessInstances(ses, ptId, ProcessControl.shouldRemoveDataslot());
        }
        WFProcess pt = (WFProcess)PTCache.get(ptId);
        int piCount = ProcessInstanceDAO.getCount(ptId);
        if (piCount > 0) {
            if (!force) {
                throw new BizLogicException("BizLogic_ERR_589", "ProcessControl.removePT(ses,ptid,force)", new Object[]{ptName});
            }
            BLControl.logger.warnKey("BizLogic_ERR_866", new Object[]{ptName, piCount});
            return false;
        }
        if (pt.hasResources()) {
            BLResourcesDAO.delete(ptId);
        }
        Map<String, Object> eventContext = pt.getEventContext();
        if (pt.hasDocumentDataslot()) {
            try {
                ProcessControl.removeDocuments(ses, pt);
            }
            catch (Exception ex) {
                throw new BizLogicException("BizLogic_ERR_1552", "ProcessControl.removePT()", new Object[]{pt.getName()}, (Throwable)ex);
            }
        }
        ProcessControl.removeXMLCollections(pt);
        if (SBMControl.dbmap.isDDLAutocommit()) {
            ProcessControl.removeDataSlotTables(ptId);
        } else {
            DataSlotDAO.deleteTable(ptId);
        }
        ProcessTemplateDAO.remove(ptId);
        ProcessXMLDAO.remove(ptId);
        PTReplaceInfoDAO.remove(ptId);
        if (pt.hasMilestones()) {
            MilestoneDAO.removeMilestone(ptId);
        }
        if (pt.hasProcessAlerts()) {
            BLAlertService.single().removeAlerts(ptName);
            if (BLControl.util.DEBUG_ALERTS) {
                BLControl.logger.debugKey("BizLogic_ERR_3162", "ProcessControl.removePT", new Object[]{ptName, pt.getID()});
            }
        }
        if (pt.hasCollaborationEnabledWS()) {
            ProcessNotesDAO.removeByProcessTemplate(ptId);
        }
        if (BLControl.util.isClustering()) {
            if (BLControl.util.DEBUG_CLUSTERING) {
                BLControl.logger.debug((Object)("Clustering:Publishing message to remove process template " + ptId));
            }
            ProcessControl.sendPTChangeNotification(ptId, "REMOVE");
        }
        BCLService.removeService((String)ptName);
        BLUtil.fireEvent(eventContext, (int)3);
        if (BLControl.util.isCallback()) {
            if (ProcessCallback.hasCallback((int)3, (String)ptName, (String)ProcessControl.getProcessTemplate(ptId).getAppName())) {
                ProcessContext pctx = BLUtil.getProcessContext((WFProcess)pt);
                ProcessCallback.execute((int)3, (SBMContext)pctx, (boolean)true);
            }
        }
        pt = null;
        BLControl.logger.infoKey("BizLogic_ERR_1663", new Object[]{ptName, ptId});
        return true;
    }

    private static void removeXMLCollections(WFProcess pt) {
        WFDataslot ds = null;
        long collectionid = -1L;
        Vector dataslots = pt.getDataslots();
        for (int ix = dataslots.size() - 1; ix >= 0; --ix) {
            ds = (WFDataslot)dataslots.elementAt(ix);
            if (!ds.getType().equals("XML")) continue;
            collectionid = ds.getXMLCollectionID();
            XMLDocRepository.removeCollection(collectionid);
        }
    }

    public static void removeDataSlotTables(long ptid) {
        String instanceDSTableName = null;
        String globalDSTableName = null;
        WFProcess pt = ProcessControl.getProcessTemplate(ptid);
        instanceDSTableName = pt.getDSTableName();
        globalDSTableName = pt.getGlobalDSTableName();
        ProcessControl.dropDataSlotTable(instanceDSTableName, ptid);
        ProcessControl.dropDataSlotTable(globalDSTableName, ptid);
    }

    private static void dropDataSlotTable(String tableName, long ptid) {
        String sqlStmt = null;
        try {
            DBConstants.KeywordConstants cfr_ignored_0 = DBConstants.single().kwd;
            sqlStmt = " DROP TABLE " + tableName;
            if (BLControl.util.DEBUG_DAO && !SBMDatabase.self().isOpenEdge()) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", sqlStmt, new Object[0]);
            }
            if (!SBMDatabase.self().isOpenEdge()) {
                BLUtil.getServiceLocal().executeDDL(sqlStmt);
            }
        }
        catch (Throwable th) {
            if (SBMDatabase.self().isOracle() && !BLDAOService.checkTableExists((String)tableName)) {
                if (BLControl.util.DEBUG_DAO || BLControl.util.DEBUG_ENGINE) {
                    BLControl.logger.debugKey("BizLogic_ERR_9203", "ProcessControl.removeDataSlotTables", new Object[]{tableName, ptid});
                }
            }
            throw new BizLogicException("BizLogic_ERR_5015", "ProcessControl.removeDataSlotTables", new Object[]{tableName, sqlStmt}, th);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized int removeProcessTemplate(Session ses, long[] ptids, boolean force) {
        Vector piList;
        if (ses == null || ptids == null) {
            return 0;
        }
        if (!force && !(piList = ProcessInstanceDAO.getProcessInstanceList(ptids, null, null, null, false)).isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_1654", "ProcessControl.removeProcessTemplate(ses,ptids,force)");
        }
        int counter = 0;
        try {
            int i;
            ArrayList<Long> unremovedPTs = new ArrayList<Long>();
            for (i = 0; i < ptids.length; ++i) {
                if (ProcessControl.removePT(ses, ptids[i], force)) continue;
                unremovedPTs.add(ptids[i]);
            }
            for (i = 0; i < ptids.length; ++i) {
                Long ptid = ptids[i];
                if (unremovedPTs.contains(ptid)) continue;
                ProcessControl.removeProcessTemplateFromCache(ptid);
                ++counter;
            }
        }
        catch (Throwable throwable) {
            if (counter == ptids.length) {
                BLControl.logger.infoKey("BizLogic_ERR_1664", new Object[]{new Long(ptids.length)});
            } else {
                int unremovedCount = ptids.length - counter;
                BLControl.logger.infoKey("BizLogic_ERR_1546", new Object[]{new Long(unremovedCount), new Long(ptids.length)});
            }
            throw throwable;
        }
        if (counter == ptids.length) {
            BLControl.logger.infoKey("BizLogic_ERR_1664", new Object[]{new Long(ptids.length)});
        } else {
            int unremovedCount = ptids.length - counter;
            BLControl.logger.infoKey("BizLogic_ERR_1546", new Object[]{new Long(unremovedCount), new Long(ptids.length)});
        }
        return counter;
    }

    public static long removeAllProcessInstances(Session session, long ptid) {
        return ProcessControl.removeAllProcessInstances(session, ptid, true);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long removeAllProcessInstances(Session session, long ptid, boolean isRemoveDataslot) {
        long count;
        block7: {
            count = 0L;
            WFProcess pt = ProcessControl.getProcessTemplate(ptid);
            if (!BLUtil.self().PI_DB_REMOVE || pt.hasSubProcessWS()) break block7;
            long l = count = ProcessControl.removePIFromDB(ptid);
            BLControl.logger.infoKey("BizLogic_ERR_1662", new Object[]{count, ProcessControl.getProcessTemplate(ptid).getName()});
            return l;
        }
        try {
            Collection piids = BLUtil.getServiceLocal().findPIbyProcessTemplate(ptid);
            Iterator i = piids.iterator();
            while (i.hasNext()) {
                long piid = (Long)i.next();
                if (!BLUtil.getServiceLocal().removeProcessInstance(session, piid, false, isRemoveDataslot)) continue;
                ++count;
            }
        }
        catch (BizLogicException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new BizLogicException("BizLogic_ERR_1529", "ProcessControl.removeAllProcessInstance", new Object[]{"remove", ptid}, (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                BLControl.logger.infoKey("BizLogic_ERR_1662", new Object[]{count, ProcessControl.getProcessTemplate(ptid).getName()});
                throw throwable;
            }
        }
        BLControl.logger.infoKey("BizLogic_ERR_1662", new Object[]{count, ProcessControl.getProcessTemplate(ptid).getName()});
        return count;
    }

    private static long removePIFromDB(long ptid) {
        long count = RemovePiDAO.removeAllProcessInstances(ptid);
        return count;
    }

    private static void sendPTChangeNotification(long ptid, String operation) {
        try {
            WFProcess prc = ProcessControl.getProcessTemplate(ptid);
            long lastModifiedTime = prc.getLastModifiedTime();
            BLJMSService.self().sendPTChangeNotification(ptid, operation, lastModifiedTime, BLControl.serverID);
        }
        catch (Throwable th) {
            throw new BizLogicException("BizLogic_ERR_2612", "ProcessControl.sendPTChangeNotification", new Object[]{operation, ptid}, th);
        }
    }

    public static final synchronized void close() {
        PTCache = null;
    }

    static synchronized long createProcessTemplate(Session session, String processDefinition, boolean activate) throws BizLogicException {
        boolean dsTables = false;
        boolean ptInsert = false;
        boolean ptXmlInsert = false;
        WFAppObject pt = null;
        try {
            BLConstants.single();
            WFimportProcess importPr = new WFimportProcess(processDefinition, 0, -1L);
            pt = importPr.getProcess();
            if (BLControl.util.DEBUG_CREATE) {
                ProcessInfo.printProcess((WFProcess)pt);
            }
            if (pt.getName().length() > 25) {
                BLControl.logger.errorKey("BizLogic_ERR_4719", "ProcessControl.createProcessTemplate(sess,s,boolean,s,boolean)", new Object[]{pt.getName(), 25});
            }
            ProcessControl.checkProcessExists(pt.getName());
            long ptid = ((WFProcess)pt).generateTemplateID();
            if (BLControl.util.DEBUG_CREATE) {
                BLControl.logger.debugKey("Bizlogic_ERR_3214", "ProcessControl.createProcessTemplate", new Object[]{ptid, pt.getName()});
            }
            if (((WFProcess)pt).hasResources()) {
                BLResourcesDAO.create(ptid, ((WFProcess)pt).resourceList);
            }
            if (((WFProcess)pt).getPriority() == 0) {
                ((WFProcess)pt).setPriority(SBMControl.util.High_Priority_int);
            }
            ((WFProcess)pt).populateData();
            ((WFProcess)pt).validateProcess();
            ((WFProcess)pt).checkPreCondGlobalSlotReference();
            if (((WFProcess)pt).hasMilestones()) {
                ProcessControl.createMilestone((WFProcess)pt);
            }
            if (((WFProcess)pt).hasProcessAlerts()) {
                ProcessControl.createAlerts((WFProcess)pt);
            }
            ProcessControl.createDataSlotTables((WFProcess)pt);
            if (importPr.getDataSlotIndexData() != null) {
                List<DataSlotTableIndex> dsTableIndexData = importPr.generateIndexNames(ptid);
                ((WFProcess)pt).setDataSlotIndexData(dsTableIndexData);
                ProcessControl.createDataSlotIndexes((WFProcess)pt);
            }
            if (BLControl.util.DEBUG_CREATE) {
                BLControl.logger.debugKey("Bizlogic_ERR_3215", "ProcessControl.createProcessTemplate", new Object[]{pt.getName(), ptid});
            }
            dsTables = true;
            if (((WFProcess)pt).hasDocumentDataslot()) {
                DocumentFolder folder = BLDocService.createTemplateFolder((long)ptid, (String)pt.getName());
                ((WFProcess)pt).setFolderId(folder.getId());
            }
            ProcessTemplateDAO.create((WFProcess)pt);
            ptInsert = true;
            ProcessControl.addProcessTemplateToCache(ptid, pt);
            String xmlContent = processDefinition;
            if (SBMUtil.isValidXMLFileName((String)processDefinition)) {
                String filePath = BLUtil.getPTXMLFilePath((String)processDefinition);
                SBMConstants.self().getClass();
                xmlContent = FileUtil.getString((String)filePath, (String)"UTF-8");
            }
            ProcessXMLDAO.create(ptid, ((WFProcess)pt).getDescription(), xmlContent);
            ptXmlInsert = true;
            if (BLControl.util.DEBUG_CREATE) {
                BLControl.logger.debugKey("Bizlogic_ERR_3205", "ProcessControl.createProcessTemplate", new Object[]{pt.getName(), ((WFProcess)pt).getAppName()});
            }
            ProcessControl.insertGlobalDS(session, (WFProcess)pt);
            Map<String, Object> eventContext = ((WFProcess)pt).getEventContext();
            eventContext.put("PROCESS_XML", xmlContent);
            eventContext.put("STARTTIME", String.valueOf(((WFProcess)pt).getStartTime()));
            eventContext.put("LAST_MODIFIED_TIME", ((WFProcess)pt).getLastModifiedTime());
            BLUtil.fireEvent(eventContext, (int)1);
            if (activate) {
                ((WFProcess)pt).activate();
            }
            if (BLControl.util.isClustering()) {
                if (BLControl.util.DEBUG_CLUSTERING) {
                    BLControl.logger.debug((Object)("Clustering:Publishing message to add process template " + ptid));
                }
                ProcessControl.sendPTChangeNotification(ptid, "ADD");
            }
            BLControl.logger.infoKey("BizLogic_ERR_3223", new Object[]{pt.getName(), new Long(ptid)});
            return ptid;
        }
        catch (Exception e) {
            int size;
            StringBuilder exm = new StringBuilder();
            if (pt != null) {
                long ptid = pt.getID();
                if (dsTables) {
                    try {
                        DataSlotDAO.deleteTable((WFProcess)pt);
                    }
                    catch (Throwable th) {
                        exm.append("DataSlotDAO.deleteTable:");
                        exm.append(th.getMessage()).append("\n");
                    }
                }
                if (ptInsert) {
                    try {
                        ProcessTemplateDAO.remove(ptid);
                    }
                    catch (Throwable th) {
                        exm.append("ProcessTemplateDAO.remove:");
                        exm.append(th.getMessage()).append("\n");
                    }
                }
                if (ptXmlInsert) {
                    try {
                        ProcessXMLDAO.remove(ptid);
                    }
                    catch (Throwable th) {
                        exm.append("ProcessXMLDAO.remove:");
                        exm.append(th.getMessage()).append("\n");
                    }
                }
                try {
                    ProcessControl.removeProcessTemplateFromCache(ptid);
                }
                catch (Throwable th) {
                    exm.append("removeProcessTemplateFromCache:");
                    exm.append(th.getMessage()).append("\n");
                }
            }
            if ((size = processDefinition.length()) >= 100) {
                size = 100;
            }
            throw new BizLogicException("BizLogic_ERR_517", "ProcessControl.createProcessTemplate", new Object[]{processDefinition.substring(0, size), exm.toString()}, (Throwable)e);
        }
    }

    private static void checkProcessExists(String ptName) {
        boolean flag = ProcessControl.isProcessExists(ptName);
        if (!flag) {
            flag = ProcessTemplateDAO.checkRecordExists(ptName);
        }
        if (flag) {
            throw new BizLogicException("BizLogic_ERR_572", "ProcessControl.checkProcessExists", new Object[]{ptName});
        }
        if (BLDAOService.checkTableExists((String)ptName)) {
            BLControl.logger.warnKey("BizLogic_ERR_2649", new Object[]{ptName});
        }
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.debugKey("BizLogic_ERR_007", ptName, new Object[0]);
        }
    }

    private static void createAlerts(WFProcess pt) {
        BLAlertService.single().createAlerts(pt.getName(), pt.AlertData, pt.getAllDSType());
        if (BLControl.util.DEBUG_ALERTS) {
            BLControl.logger.debugKey("BizLogic_ERR_3163", "ProcessControl.createProcessTemplate", new Object[]{pt.getName()});
        }
        if (pt.hasWorkstepAlerts()) {
            BLAlertService.single().createWorkstepAlerts(pt);
            if (BLControl.util.DEBUG_ALERTS) {
                BLControl.logger.debugKey("BizLogic_ERR_3170", "ProcessControl.createProcessTemplate", new Object[]{pt.getName()});
            }
        }
        BLAlertService.single().validateAlertVariables(pt);
    }

    private static void createMilestone(WFProcess pt) {
        MilestoneDAO.createMilestone(pt);
        if (BLControl.util.DEBUG_CREATE) {
            BLControl.logger.debugKey("BizLogic_ERR_4802", "ProcessControl.createMilestone", new Object[]{pt.getName()});
        }
    }

    private static final void createDataSlotTables(WFProcess wfProcess) {
        boolean gds = false;
        Map keyAttrs = ProcessControl.getKeyAttributes();
        Map blobAttrs = ProcessControl.getBlobAttributes();
        long ptID = wfProcess.getID();
        DataSlotMeta dataSlotMeta = new DataSlotMeta(wfProcess, keyAttrs, blobAttrs, ptID, true);
        dataSlotMeta.execute(gds);
        gds = dataSlotMeta.getGds();
        wfProcess.setGlobalDSTableName(dataSlotMeta.getTableName());
        dataSlotMeta = new DataSlotMeta(wfProcess, keyAttrs, blobAttrs, ptID, false);
        dataSlotMeta.execute(gds);
        wfProcess.setDSTableName(dataSlotMeta.getTableName());
    }

    private static Map getKeyAttributes() {
        HashMap<String, Object> keyAttrs = new HashMap<String, Object>(2);
        keyAttrs.put("DATASLOTTYPE", "LONG");
        keyAttrs.put("DATA_NULL", Boolean.FALSE);
        return keyAttrs;
    }

    static final void addDataSlotColumns(WFProcess pt, HashMap addedInstanceDSInfo, HashMap addedGlobalDSInfo, boolean hasInstanceBlobDS, boolean hasGlobalBlobDS) {
        String tableName;
        String sqlStmt = null;
        Map blobAttrs = ProcessControl.getBlobAttributes();
        if (addedGlobalDSInfo != null && !addedGlobalDSInfo.isEmpty()) {
            Map<Object, Object> addedGlobalDS = ProcessControl.getAddedDataSlotMap(addedGlobalDSInfo, hasGlobalBlobDS, blobAttrs);
            tableName = pt.getGlobalDSTableName();
            try {
                sqlStmt = SBMControl.dbmap.getAlterAddSQLStatementForDS(tableName, (HashMap)addedGlobalDS);
                BLUtil.getServiceLocal().executeDDL(sqlStmt);
            }
            catch (Exception ex) {
                throw new BizLogicException("BizLogic_ERR_5014", "ProcessControl.addDataSlotColumns", new Object[]{tableName, sqlStmt}, (Throwable)ex);
            }
        }
        if (addedInstanceDSInfo != null && !addedInstanceDSInfo.isEmpty()) {
            Map<Object, Object> addedInstanceDS = ProcessControl.getAddedDataSlotMap(addedInstanceDSInfo, hasInstanceBlobDS, blobAttrs);
            tableName = pt.getDSTableName();
            try {
                sqlStmt = SBMControl.dbmap.getAlterAddSQLStatementForDS(tableName, (HashMap)addedInstanceDS);
                BLUtil.getServiceLocal().executeDDL(sqlStmt);
            }
            catch (Exception ex) {
                ProcessControl.dropDataSlotColumns(pt, null, addedGlobalDSInfo, false, hasGlobalBlobDS);
                throw new BizLogicException("BizLogic_ERR_5014", "ProcessControl.dropDataSlotColumns", new Object[]{tableName, sqlStmt}, (Throwable)ex);
            }
        }
    }

    private static Map getBlobAttributes() {
        HashMap<String, String> blobAttrs = new HashMap<String, String>(1);
        blobAttrs.put("DATASLOTTYPE", "OBJECT");
        return blobAttrs;
    }

    private static Map<Object, Object> getAddedDataSlotMap(Map<Object, Object> addedDsInfo, boolean hasBlobDS, Map<Object, Object> blobAttrs) {
        boolean removed;
        Map addedDS = DataSlotDAO.polishDataslotNames(addedDsInfo);
        if (hasBlobDS && (removed = ProcessControl.removeLargeDataSlots((HashMap)addedDS))) {
            addedDS.put("large_dataslots", blobAttrs);
        }
        return addedDS;
    }

    static final void dropDataSlotColumns(WFProcess pt, HashMap addedInstanceDSInfo, HashMap addedGlobalDSInfo, boolean hasInstanceBlobDS, boolean hasGlobalBlobDS) {
        List dropColQuery;
        String tableName;
        BLControl.logger.warn((Object)" in Process control alter table ");
        Map blobAttrs = ProcessControl.getBlobAttributes();
        if (addedGlobalDSInfo != null && !addedGlobalDSInfo.isEmpty()) {
            Map<Object, Object> addedGlobalDS = ProcessControl.getAddedDataSlotMap(addedGlobalDSInfo, hasGlobalBlobDS, blobAttrs);
            tableName = pt.getGlobalDSTableName();
            try {
                dropColQuery = SBMControl.dbmap.getAlterDropSQLStatementForDS(tableName, (HashMap)addedGlobalDS);
                for (String query : dropColQuery) {
                    if (query == null || query.trim().length() <= 0) continue;
                    BLUtil.getServiceLocal().executeDDL(query);
                }
            }
            catch (Throwable th) {
                BLControl.logger.errorKey("BizLogic_ERR_3897", "ProcessControl.dropDataslotColumns", new Object[]{tableName, addedGlobalDS});
            }
        }
        if (addedInstanceDSInfo != null && !addedInstanceDSInfo.isEmpty()) {
            Map<Object, Object> addedInstanceDS = ProcessControl.getAddedDataSlotMap(addedInstanceDSInfo, hasInstanceBlobDS, blobAttrs);
            tableName = pt.getDSTableName();
            try {
                dropColQuery = SBMControl.dbmap.getAlterDropSQLStatementForDS(tableName, (HashMap)addedInstanceDS);
                for (String query : dropColQuery) {
                    if (query == null || query.trim().length() <= 0) continue;
                    BLUtil.getServiceLocal().executeDDL(query);
                }
            }
            catch (Throwable th) {
                BLControl.logger.errorKey("BizLogic_ERR_3898", "ProcessControl.dropDataslotColumns", new Object[]{tableName, addedInstanceDS});
            }
        }
    }

    private static final boolean removeLargeDataSlots(HashMap dsList) {
        boolean removed = false;
        Vector<String> dsRemove = new Vector<String>();
        Iterator iterator = dsList.keySet().iterator();
        String dsName = null;
        while (iterator.hasNext()) {
            dsName = (String)iterator.next();
            HashMap dsAttrs = (HashMap)dsList.get(dsName);
            if (dsAttrs == null) continue;
            String type = (String)dsAttrs.get("DATASLOTTYPE");
            if (!BLUtil.isLargeDataSlot((String)type)) continue;
            dsRemove.addElement(dsName);
            removed = true;
        }
        for (int ds = 0; ds < dsRemove.size(); ++ds) {
            dsName = (String)dsRemove.elementAt(ds);
            dsList.remove(dsName);
        }
        return removed;
    }

    public static void activateProcessTemplate(long ptid) {
        WFProcess ptObject = ProcessControl.getProcessTemplate(ptid);
        ptObject.activate();
        if (BLControl.util.isClustering()) {
            if (BLControl.util.DEBUG_CLUSTERING) {
                BLControl.logger.debug((Object)("Clustering:Publishing message to activate process template " + ptid));
            }
            ProcessControl.sendPTChangeNotification(ptid, "UPDATE");
        }
        BLProcessCacheService.self().onInstall(ptid);
    }

    public static void suspendProcessTemplate(long ptid) {
        WFProcess ptObject = ProcessControl.getProcessTemplate(ptid);
        ptObject.suspend();
        if (BLControl.util.isClustering()) {
            if (BLControl.util.DEBUG_CLUSTERING) {
                BLControl.logger.debug((Object)("Clustering:Publishing message to suspend process template " + ptid));
            }
            ProcessControl.sendPTChangeNotification(ptid, "UPDATE");
        }
        BLProcessCacheService.self().onSuspend(ptid);
    }

    public static void suspendProcessTemplateBySeqVer(long ptid) {
        WFProcess ptObject = ProcessControl.getProcessTemplate(ptid);
        ptObject.suspendOnSeqVersion();
        if (BLControl.util.isClustering()) {
            if (BLControl.util.DEBUG_CLUSTERING) {
                BLControl.logger.debug((Object)("Clustering:Publishing message to suspend process template by version" + ptid));
            }
            ProcessControl.sendPTChangeNotification(ptid, "UPDATE");
        }
        BLProcessCacheService.self().onDeprecate(ptid);
    }

    public static void resumeProcessTemplate(long ptid) {
        WFProcess ptObject = ProcessControl.getProcessTemplate(ptid);
        ptObject.resume();
        if (BLControl.util.isClustering()) {
            if (BLControl.util.DEBUG_CLUSTERING) {
                BLControl.logger.debug((Object)("Clustering:Publishing message to resume process template " + ptid));
            }
            ProcessControl.sendPTChangeNotification(ptid, "UPDATE");
        }
        BLProcessCacheService.self().onResume(ptid);
    }

    public static Collection getAllProcessTemplates() {
        return PTCache.values();
    }

    public static List<WFProcess> getAllProcessTemplates(String appName) {
        Iterator itr = PTCache.values().iterator();
        ArrayList<WFProcess> ptList = new ArrayList<WFProcess>();
        while (itr.hasNext()) {
            WFProcess process = (WFProcess)itr.next();
            if (!process.getAppName().equalsIgnoreCase(appName) || !process.isSuspendedBySeqVersion() && !process.isActivated() && !process.isSuspended()) continue;
            ptList.add(process);
        }
        return ptList;
    }

    private static void insertGlobalDS(Session session, WFProcess pt) {
        WFDataslot ds = null;
        HashMap<String, Object> hm = new HashMap<String, Object>();
        Vector hasDataslots = pt.getDataslots();
        for (int i = 0; i < hasDataslots.size(); ++i) {
            ds = (WFDataslot)hasDataslots.elementAt(i);
            if (!ds.global) continue;
            if (ds.isObject()) {
                hm.put(ds.getName(), WFDataSlotInstance.self().createObjectForObjectDS(session, ds));
                continue;
            }
            hm.put(ds.getName(), ds.getValue());
        }
        HashMap defValues = ProcessControl.getGlobalDSWithDefaultValues(session, pt, null);
        if (!defValues.isEmpty()) {
            hm.putAll(defValues);
        }
        DataSlotDAO.create(pt.getID(), hm);
    }

    static void updateNewGlobalDSForPTR(Session session, WFProcess pt, HashMap newGlobalDS) {
        if (newGlobalDS != null && !newGlobalDS.isEmpty()) {
            WFDataslot ds = null;
            String dsName = null;
            HashMap<String, Object> hm = new HashMap<String, Object>();
            Vector hasDataslots = pt.getDataslots();
            HashMap<String, Object> excludeDS = new HashMap<String, Object>();
            for (int i = 0; i < hasDataslots.size(); ++i) {
                ds = (WFDataslot)hasDataslots.elementAt(i);
                dsName = ds.getName();
                if (!ds.global) continue;
                if (newGlobalDS.get(dsName) != null) {
                    if (ds.isObject()) {
                        hm.put(ds.getName(), WFDataSlotInstance.self().createObjectForObjectDS(session, ds));
                        continue;
                    }
                    hm.put(ds.getName(), ds.getValue());
                    continue;
                }
                excludeDS.put(ds.getName(), ds.getValue());
            }
            HashMap defValues = ProcessControl.getGlobalDSWithDefaultValues(session, pt, excludeDS);
            if (!defValues.isEmpty()) {
                for (String key : newGlobalDS.keySet()) {
                    Object value = defValues.get(key);
                    if (value == null) continue;
                    hm.put(key, value);
                }
            }
            DataSlotDAO.store(pt.getID(), hm);
        }
    }

    private static HashMap getGlobalDSWithDefaultValues(Session session, WFProcess pt, HashMap excludeDS) {
        HashMap dsValues = new HashMap();
        HashMap<String, XML> newXMLDS = new HashMap<String, XML>();
        HashMap xmlDS = pt.getXMLDSWithDefaultValues(excludeDS, true);
        if (!xmlDS.isEmpty()) {
            Iterator itr = xmlDS.entrySet().iterator();
            Map.Entry entry = null;
            while (itr.hasNext()) {
                entry = itr.next();
                String dsName = (String)entry.getKey();
                XML value = (XML)entry.getValue();
                try {
                    WFDataslot ds = pt.getDataslot(pt.getName(), dsName);
                    if (ds == null) continue;
                    value = XMLDocRepository.validate(pt.getName(), dsName, ds.getXMLCollectionID(), null, value);
                    newXMLDS.put(dsName, value);
                    ds.setValue(value);
                }
                catch (Exception ignore) {
                    BLControl.logger.errorKey("BizLogic_ERR_3508", "ProcessControl.getGlobalDSWithDefValues", (Throwable)ignore, new Object[]{"XML document", pt.getName(), dsName});
                }
            }
        }
        HashMap dateDS = pt.getDateTimeDSWithDefaultValues(excludeDS, true, pt.getStartTime());
        HashMap docDS = ProcessControl.getDocumentDSWithDefaultValues(session, pt, excludeDS, true);
        dsValues.putAll(newXMLDS);
        dsValues.putAll(dateDS);
        dsValues.putAll(docDS);
        if (BLControl.util.DEBUG_UTIL) {
            BLControl.logger.warnKey("BizLogic_ERR_3511", "getGlobalDSWithDefaultValues", new Object[]{dsValues.size(), pt.getName(), dsValues});
        }
        return dsValues;
    }

    public static Vector getActivatedPTList() {
        Vector<WFProcess> ptlist = new Vector<WFProcess>();
        Enumeration enumeration = PTCache.elements();
        while (enumeration.hasMoreElements()) {
            WFProcess ptObject = (WFProcess)enumeration.nextElement();
            if (!ptObject.isActivated()) continue;
            ptlist.addElement(ptObject);
        }
        return ptlist;
    }

    public static Vector getSuspendedProcessTemplateList() {
        Vector<WFProcess> ptlist = new Vector<WFProcess>();
        Enumeration enumeration = PTCache.elements();
        while (enumeration.hasMoreElements()) {
            WFProcess ptObject = (WFProcess)enumeration.nextElement();
            if (!ptObject.isSuspended()) continue;
            ptlist.addElement(ptObject);
        }
        return ptlist;
    }

    public static Map<String, PTState> getTemplateNames() {
        HashMap<String, PTState> ptInfo = new HashMap<String, PTState>();
        Set pts = PTCache.entrySet();
        for (Map.Entry mapEntry : pts) {
            Object ptState = null;
            WFProcess ptObject = (WFProcess)mapEntry.getValue();
            if (ptObject.isSuspendedBySeqVersion()) {
                ptInfo.put(ptObject.getName(), PTState.DEPRECATED);
                continue;
            }
            ptInfo.put(ptObject.getName(), PTState.get((int)ptObject.getStatus()));
        }
        return ptInfo;
    }

    public static WFWorkstep getWorkStep(long ptID, String wsName) {
        WFProcess ptObject = ProcessControl.getProcessTemplate(ptID);
        return ptObject.getWorkstep(wsName);
    }

    public static Vector getUserAuthorizedProcessTemplateList(String user) {
        if (!BLUtil.isUser((String)user)) {
            throw new BizLogicException("BizLogic_ERR_504", "ProcessControl.getUserAuthorizedProcessTemplateList", new Object[]{user});
        }
        User userObj = UserManager.getUser((String)user);
        String[] allGroupsOfUser = userObj.getAllGroupNames();
        Vector<WFProcess> userPTList = new Vector<WFProcess>();
        Enumeration enumeration = PTCache.elements();
        WFProcess pt = null;
        block0: while (enumeration.hasMoreElements()) {
            pt = (WFProcess)enumeration.nextElement();
            if (!pt.isActivated()) continue;
            String groupName = pt.getGroup();
            if (groupName == null || groupName.trim().isEmpty()) {
                userPTList.addElement(pt);
                continue;
            }
            for (String group : allGroupsOfUser) {
                if ((!BLUtil.isUserManagerCaseSensitive() || !groupName.equals(group)) && (BLUtil.isUserManagerCaseSensitive() || !groupName.equalsIgnoreCase(group))) continue;
                userPTList.addElement(pt);
                continue block0;
            }
        }
        if (BLControl.util.DEBUG_ENGINE) {
            ArrayList<String> ptNameList = new ArrayList<String>();
            for (int idx = 0; idx < userPTList.size(); ++idx) {
                ptNameList.add(((WFProcess)userPTList.get(idx)).getName());
            }
            BLControl.logger.debugKey("BizLogic_ERR_3283", "ProcessControl.getUserAuthorizedProcessTemplateList", new Object[]{user, ptNameList});
        }
        return userPTList;
    }

    public static Vector getUserProcessTemplateList(String user) {
        User perf = BLUtil.getUser((String)user);
        if (perf == null) {
            throw new BizLogicException("BizLogic_ERR_504", "ProcessControl.getUserProcessTemplateList", new Object[]{user});
        }
        String[] groupNames = perf.getAllGroupNames();
        Vector<WFProcess> ptlist = new Vector<WFProcess>();
        String ptGroupName = null;
        Enumeration enumeration = PTCache.elements();
        block0: while (enumeration.hasMoreElements()) {
            WFProcess ptObject = (WFProcess)enumeration.nextElement();
            ptGroupName = ptObject.getGroup();
            if (ptGroupName == null || ptGroupName.trim().length() == 0) {
                ptlist.addElement(ptObject);
                continue;
            }
            for (int y = 0; y < groupNames.length; ++y) {
                if (!groupNames[y].equals(ptGroupName)) continue;
                ptlist.addElement(ptObject);
                continue block0;
            }
        }
        return ptlist;
    }

    public static HashMap getXMLFileInfo(long ptID) {
        WFProcess ptObject = ProcessControl.getProcessTemplate(ptID);
        String fileName = BLUtil.getPTXMLFilePath((String)ptObject.getXMLFileName());
        File templateFile = new File(fileName);
        int fileLength = (int)templateFile.length();
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("XML_FILE_LENGTH", fileLength);
        try {
            FileInputStream fis = new FileInputStream(fileName);
            SBMConstants.self().getClass();
            InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
            BufferedReader reader = new BufferedReader(isr);
            info.put("XML_READER", reader);
        }
        catch (IOException e) {
            throw new BizLogicException("BizLogic_ERR_2538", "ProcessControl.getXMLFileInfo", new Object[]{ptObject.getName()}, (Throwable)e);
        }
        return info;
    }

    public static final Collection getVersions(long ptID) {
        WFProcess currentObject = ProcessControl.getProcessTemplate(ptID);
        String appName = currentObject.getAppName();
        if (appName == null || appName.trim().isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_1509", "ProcessControl.getVersions", new Object[]{currentObject.getName()});
        }
        Vector<WFProcess> list = new Vector<WFProcess>();
        Collection ptCollection = ProcessControl.getAllProcessTemplates();
        for (WFProcess ptObject : ptCollection) {
            if (!ptObject.getAppName().equals(appName)) continue;
            list.add(ptObject);
        }
        return list;
    }

    public static final Collection getVersions(String appName) {
        Vector<WFProcess> list = new Vector<WFProcess>();
        Collection ptCollection = ProcessControl.getAllProcessTemplates();
        for (WFProcess ptObject : ptCollection) {
            if (!ptObject.getAppName().equals(appName)) continue;
            list.add(ptObject);
        }
        return list;
    }

    public static final Collection getAppNames() {
        ArrayList<String> list = new ArrayList<String>();
        Collection ptCollection = ProcessControl.getAllProcessTemplates();
        for (WFProcess ptObject : ptCollection) {
            String appName = ptObject.getAppName();
            if (list.contains(appName)) continue;
            list.add(appName);
        }
        return list;
    }

    public static final void updateProcessTemplate(WFProcess pt) {
        if (!pt.isDynamic()) {
            if (BLControl.util.isClustering()) {
                BLUtil.getServiceLocal().saveProcessTemplate(pt);
                if (BLControl.util.DEBUG_CLUSTERING) {
                    BLControl.logger.debug((Object)("Clustering:Publishing message to update process template " + pt.getID()));
                }
                ProcessControl.sendPTChangeNotification(pt.getID(), "UPDATE");
            } else {
                ProcessTemplateDAO.store(pt);
            }
        } else if (pt.isDynamic() && pt.getDynamicInstanceID() > 0L) {
            ProcessInstanceTemplateDAO.store(pt.getDynamicInstanceID(), pt);
        } else {
            throw new BizLogicException("Bizlogic_ERR_3701", "ProcessControl.updateProcessTemplate", new Object[]{pt.getDynamicInstanceID(), pt.getName()});
        }
        BLProcessCacheService.self().onUpdate(pt.getID());
    }

    public static final long getMaxID(String appName) {
        Collection ptCollection = ProcessControl.getAllProcessTemplates();
        Iterator iterator = ptCollection.iterator();
        long maxID = 0L;
        WFProcess ptObject = null;
        while (iterator.hasNext()) {
            long id;
            ptObject = (WFProcess)iterator.next();
            if (!ptObject.getAppName().equals(appName) || (id = ptObject.getID()) <= maxID) continue;
            maxID = id;
        }
        return maxID;
    }

    public static boolean isProcessTemplateExist(long ptid) {
        WFProcess ptObject = (WFProcess)PTCache.get(ptid);
        return ptObject != null;
    }

    public static boolean isProcessTemplateExist(String ptName) {
        Collection ptList = ProcessControl.getAllProcessTemplates();
        for (WFProcess ptObject : ptList) {
            if (!ptObject.getName().equals(ptName)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getInvalidProcessTemplates(List<String> ptNames) {
        ArrayList<String> invalidList = new ArrayList<String>();
        List<String> ptNamesList = ProcessControl.getProcessTemplateNames();
        for (String ptName : ptNames) {
            if (ptName != null && ptName.trim().length() != 0 && ptNamesList.contains(ptName)) continue;
            invalidList.add(ptName);
        }
        return invalidList;
    }

    public static List<String> getProcessTemplateNames() {
        ArrayList<String> ptNamesList = new ArrayList<String>();
        Collection ptList = ProcessControl.getAllProcessTemplates();
        for (WFProcess ptObject : ptList) {
            ptNamesList.add(ptObject.getName());
        }
        return ptNamesList;
    }

    public static List<Long> getInvalidProcessTemplates(long[] ptIDs) {
        ArrayList<Long> invalidList = new ArrayList<Long>();
        List<Long> ptIDList = ProcessControl.getProcessTemplateIDs();
        long[] lArray = ptIDs;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long ptID = lArray[i];
            if (ptID != null && ptID != -1L && ptIDList.contains(ptID)) continue;
            invalidList.add(ptID);
        }
        return invalidList;
    }

    public static List<Long> getProcessTemplateIDs() {
        ArrayList<Long> ptIDList = new ArrayList<Long>();
        Collection ptList = ProcessControl.getAllProcessTemplates();
        for (WFProcess ptObject : ptList) {
            ptIDList.add(ptObject.getID());
        }
        return ptIDList;
    }

    public static List<WFProcess> getTemplates(Session ses, EnumSet<PTState> ptStates) {
        ArrayList<WFProcess> ptObjects = new ArrayList<WFProcess>();
        Set pts = PTCache.entrySet();
        for (Map.Entry mapEntry : pts) {
            WFProcess ptObject = (WFProcess)mapEntry.getValue();
            if (ptObject.isSuspended()) {
                if (ptStates.contains(PTState.SUSPENDED) && !ptObject.isDeprecated()) {
                    ptObjects.add(ptObject);
                    continue;
                }
                if (!ptStates.contains(PTState.DEPRECATED) || !ptObject.isDeprecated()) continue;
                ptObjects.add(ptObject);
                continue;
            }
            if (!ptStates.contains(PTState.get((int)ptObject.getStatus()))) continue;
            ptObjects.add(ptObject);
        }
        return ptObjects;
    }

    public static WFProcess getProcess(long piid) {
        Vector piList = ProcessInstanceDAO.getProcessInstanceList(null, new long[]{piid}, null, null, false);
        if (piList == null || piList.isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_527", "ProcessControl.getProcess", new Object[]{piid});
        }
        HashMap piAttrs = (HashMap)piList.elementAt(0);
        long parentID = (Long)piAttrs.get("PARENTID");
        if (parentID > 0L) {
            return ProcessInstanceTemplateDAO.load(piid);
        }
        long ptid = (Long)piAttrs.get("PROCESSTEMPLATEID");
        return ProcessControl.getProcessTemplate(ptid);
    }

    public static WFProcess getProcess(long pid, boolean dynamic) {
        if (dynamic) {
            return ProcessInstanceTemplateDAO.load(pid);
        }
        return ProcessControl.getProcessTemplate(pid);
    }

    public static void updateNewDataSlotsForPTR(Session sess, long ptid) {
        WFProcess pt = ProcessControl.addProcessTemplateToCache(ptid);
        ProcessControl.updateNewDataSlotsForPTR(sess, pt);
    }

    public static void updateNewDataSlotsForPTR(Session sess, WFProcess pt) {
        long ptid = pt.getID();
        WFProcessReplaceInfo replaceInfo = pt.getReplaceInfo();
        if (replaceInfo == null) {
            throw new BizLogicException("BizLogic_ERR_2782", "ProcessControl.updateNewDataSlotsForPTR", new Object[]{ptid});
        }
        long ptReplaceID = replaceInfo.getReplaceID();
        BLUtil.self();
        List<Map<String, Object>> piDetailsList = BLUtil.getServiceLocal().getInstanceListForPTRDataSlotUpdate(ptReplaceID, ptid);
        if (piDetailsList == null || piDetailsList.isEmpty()) {
            return;
        }
        HashMap<String, Object> dsNameValueMap = new HashMap<String, Object>();
        Map newInstanceDS = replaceInfo.getNewInstanceDSList();
        if (newInstanceDS != null && !newInstanceDS.isEmpty()) {
            for (String dsName : newInstanceDS.keySet()) {
                WFDataslot ds = pt.getDataslot(dsName);
                Object dsValue = null;
                dsValue = ds.isObject() ? WFDataSlotInstance.self().createObjectForObjectDS(sess, ds) : ds.getValue();
                dsNameValueMap.put(dsName, dsValue);
            }
            ProcessControl.updateNewDSForPI(sess, ptReplaceID, piDetailsList, dsNameValueMap);
        }
        BLUtil.self();
        BLUtil.getServiceLocal().updatePTReplaceStatus(ptReplaceID);
    }

    public static List<Map<String, Object>> getInstanceListForPTRDataSlotUpdate(long ptReplaceID, long ptid) {
        long lastPiid = PTReplaceInfoDAO.getLastPID(ptReplaceID);
        List<Map<String, Object>> piDetailsList = ProcessInstanceDAO.findAfterLastInstanceId(ptid, lastPiid);
        if (piDetailsList == null || piDetailsList.isEmpty()) {
            PTReplaceInfoDAO.update(ptReplaceID, true);
            return piDetailsList;
        }
        return piDetailsList;
    }

    public static void updateNewDSForPI(Session sess, long ptReplaceID, List<Map<String, Object>> piDetailsList, Map dsNameValueMap) {
        if (piDetailsList == null || piDetailsList.isEmpty()) {
            return;
        }
        int from = 0;
        while (from < piDetailsList.size()) {
            int to = Math.min(from + 1000, piDetailsList.size());
            List<Map<String, Object>> batch = piDetailsList.subList(from, to);
            BLUtil.getServiceLocal().updateNewDataSlotsForPTRList(sess, batch, dsNameValueMap, ptReplaceID);
            from = to;
        }
    }

    public static void updatePTReplaceStatus(long ptReplaceID) {
        PTReplaceInfoDAO.update(ptReplaceID, true);
    }

    public static final Collection getProcessTemplateListByCategory(String category, String subCategory) {
        Collection ptCollection = ProcessControl.getAllProcessTemplates();
        if (!SBMUtil.isValidProperty((String)category) && !SBMUtil.isValidProperty((String)subCategory)) {
            return ptCollection;
        }
        ArrayList<WFProcess> list = new ArrayList<WFProcess>();
        for (WFProcess ptObject : ptCollection) {
            if (SBMUtil.isValidProperty((String)category) && SBMUtil.isValidProperty((String)subCategory)) {
                if (!category.equals(ptObject.getCategory()) || !subCategory.equals(ptObject.getSubCategory())) continue;
                list.add(ptObject);
                continue;
            }
            if (SBMUtil.isValidProperty((String)category)) {
                if (!category.equals(ptObject.getCategory())) continue;
                list.add(ptObject);
                continue;
            }
            if (!SBMUtil.isValidProperty((String)subCategory) || !subCategory.equals(ptObject.getSubCategory())) continue;
            list.add(ptObject);
        }
        return list;
    }

    public static HashMap getDocumentDSWithDefaultValues(Session session, WFProcess pt, HashMap excludeDS, boolean onlyGlobalDS) {
        HashMap<String, DocumentDS> dsValues = new HashMap<String, DocumentDS>();
        BLConstants.single();
        HashMap dslist = pt.getDataSlotsWithDefaultValues("DOCUMENT", onlyGlobalDS);
        if (dslist.isEmpty()) {
            return dsValues;
        }
        Iterator itr = dslist.entrySet().iterator();
        String dsName = null;
        String defaultValue = null;
        ArrayList defaultValues = null;
        Map.Entry entry = null;
        while (itr.hasNext()) {
            entry = itr.next();
            dsName = (String)entry.getKey();
            defaultValues = (ArrayList)entry.getValue();
            if (defaultValues == null || defaultValues.isEmpty() || excludeDS != null && excludeDS.containsKey(dsName)) continue;
            WFDataslot ds = pt.getDataslot(dsName);
            DSContext dsContext = null;
            if (BLUtil.self().isMultiUserCredential()) {
                dsContext = BLUtil.self().getDSContext(session);
            }
            DocumentDS docDS = BLDocService.getGlobalDocumentDS((DSContext)dsContext, (long)pt.getID(), (String)dsName, null, (boolean)ds.isEditableByAuthor(), (boolean)ds.isMultiLine());
            for (int ix = 0; ix < defaultValues.size(); ++ix) {
                defaultValue = (String)defaultValues.get(ix);
                ProcessControl.addDefaultDocument(session, pt, docDS, defaultValue);
            }
            dsValues.put(dsName, docDS);
            ds.setValue(docDS);
        }
        return dsValues;
    }

    private static void addDefaultDocument(Session session, WFProcess pt, DocumentDS docDS, String defaultValue) {
        try {
            URL fileurl = BLUtil.getDefaultDocumentURL((WFProcess)pt, (String)docDS.getDataslotName(), (String)defaultValue);
            docDS.create(session.getUser(), BLUtil.getDocumentName((URL)fileurl), fileurl, null);
            if (BLControl.util.DEBUG_UTIL) {
                BLControl.logger.debugKey("BizLogic_ERR_3510", "getDocDSWithDefaultValues", new Object[]{fileurl, pt.getName(), docDS.getDataslotName()});
            }
        }
        catch (Exception ignore) {
            BLControl.logger.errorKey("BizLogic_ERR_3508", "getDocDSWithDefaultValues", (Throwable)ignore, new Object[]{defaultValue, pt.getName(), docDS.getDataslotName()});
        }
    }

    public static void removeDocuments(Session session, WFProcess pt) throws IOException {
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.debug((Object)("removing all documents of PT:" + pt.getName()));
        }
        if (pt.hasDocumentDataslot()) {
            DSContext dsContext = null;
            if (BLUtil.self().isMultiUserCredential()) {
                dsContext = BLUtil.self().getDSContext(session);
            }
            BLDocService.removeAllPTDocs((DSContext)dsContext, (long)pt.getID());
        }
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.debug((Object)("Removed all public document for PT: " + pt.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final void createDataSlotIndexes(WFProcess pt) {
        if (SBMDatabase.self().isOpenEdge()) {
            return;
        }
        List<DataSlotTableIndex> dsTableIndexData = pt.getDataSlotIndexData();
        String tableName = pt.getDSTableName();
        for (DataSlotTableIndex dsTableIndex : dsTableIndexData) {
            if (!dsTableIndex.hasBizLogicIndex()) continue;
            String indexName = dsTableIndex.getBizLogicIndexName();
            List<String> columnNames = dsTableIndex.getDataslotNames();
            String query = ProcessControl.getCreateIndexSql((String)tableName, (String)indexName, columnNames);
            try {
                if (SBMControl.dbmap.isDDLAutocommit()) {
                    BLUtil.getServiceLocal().executeDDL(query);
                } else {
                    Connection conn = null;
                    Statement stmt = null;
                    try {
                        conn = ProcessControl.getConnection();
                        stmt = conn.createStatement();
                        stmt.execute(query);
                    }
                    finally {
                        ProcessControl.clean(null, (Statement)stmt, (Connection)conn);
                    }
                }
                BLControl.logger.infoKey("BizLogic_ERR_4105", new Object[]{indexName, tableName, columnNames, pt.getName()});
            }
            catch (Throwable th) {
                throw new BizLogicException("BizLogic_ERR_4604", "ProcessControl.createIndex()", new Object[]{tableName, columnNames, pt.getName()}, th);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateDataSlotIndexes(long ptid) {
        WFProcess pt = ProcessControl.addProcessTemplateToCache(ptid);
        WFProcessReplaceInfo replaceInfo = pt.getReplaceInfo();
        if (SBMDatabase.self().isOpenEdge()) {
            return;
        }
        if (replaceInfo == null) {
            throw new BizLogicException("BizLogic_ERR_2782", "ProcessControl.createDataSlotIndexes", new Object[]{ptid});
        }
        String tableName = pt.getDSTableName();
        List<DataSlotTableIndex> createIndexes = replaceInfo.getaddedIndexes();
        List<DataSlotTableIndex> deleteIndexes = replaceInfo.getremovedIndexes();
        if ((createIndexes == null || createIndexes.isEmpty()) && (deleteIndexes == null || deleteIndexes.isEmpty())) {
            return;
        }
        Connection conn = null;
        Statement stmt = null;
        try {
            String indexName;
            conn = SBMDatabase.self().getConnection();
            if (deleteIndexes != null && !deleteIndexes.isEmpty()) {
                for (DataSlotTableIndex deleteIndex : deleteIndexes) {
                    indexName = deleteIndex.getBizLogicIndexName();
                    String dropIndexQuery = ProcessControl.getDropIndexSql((String)indexName);
                    try {
                        stmt = conn.createStatement();
                        stmt.execute(dropIndexQuery);
                    }
                    finally {
                        ProcessControl.clean(null, (Statement)stmt, null);
                    }
                }
            }
            if (createIndexes != null && !createIndexes.isEmpty()) {
                for (DataSlotTableIndex createIndex : createIndexes) {
                    indexName = createIndex.getBizLogicIndexName();
                    List<String> columnNames = createIndex.getDataslotNames();
                    String createIndexQuery = ProcessControl.getCreateIndexSql((String)tableName, (String)indexName, columnNames);
                    try {
                        stmt = conn.createStatement();
                        stmt.execute(createIndexQuery);
                    }
                    finally {
                        ProcessControl.clean(null, (Statement)stmt, null);
                    }
                }
            }
        }
        catch (Throwable th) {
            throw new BizLogicException("BizLogic_ERR_4824", "ProcessControl.updateDataSlotIndexes()", null, th);
        }
        finally {
            ProcessControl.clean(null, null, (Connection)conn);
        }
    }

    public static void updateGlobalDSValue(Session session, long ptid, String dsName, Object dsValue) {
        HashMap<String, Object> dsValues = new HashMap<String, Object>();
        dsValues.put(dsName, dsValue);
        ProcessControl.updateGlobalDSValues(session, ptid, dsValues);
    }

    public static void updateGlobalDSValues(Session session, long ptid, Map<String, Object> dsValues) {
        WFDataSlotInstance.self().updateGlobalDSValues(session, ptid, dsValues);
    }

    public static Object getGlobalDSValue(Session sess, long ptid, String dsName) {
        WFDataslot ds = ProcessControl.getProcessTemplate(ptid).getDataslot(dsName);
        return WFDataSlotInstance.self().getGlobalDSValue(sess, ds);
    }

    public static Map<String, Object> getGlobalDSValues(Session sess, long ptid) {
        return WFDataSlotInstance.self().getGlobalDSValues(sess, ptid);
    }

    private static void removeMonitorEventData(String ptName) {
        MPService.self().getPersistenceService().removeMonitorWaitWorkstep(ptName);
        HashMap<String, Object> whereAttributes = new HashMap<String, Object>();
        whereAttributes.put("PROCESS_NAME", ptName);
        List<Map<String, Object>> events = MPService.self().getPersistenceService().getEventAttributes(whereAttributes);
        for (Map<String, Object> eventAttrs : events) {
            eventAttrs.put("REASON", "Event removed as the process template is removed");
            MPService.self().getPersistenceService().storeInvalidEvent(eventAttrs);
        }
        MPService.self().getPersistenceService().removeEvent(ptName);
    }

    public static boolean isMonitoringProcessInstalled() {
        return ProcessTemplateDAO.getPTCount(ProcessType.MONITORING.getId()) > 0L;
    }

    public static WFWorkstep getWorkStep(String ptName, String wsName, boolean nullIfNotFound) {
        return ProcessControl.getProcessTemplate(ptName).getWorkstep(wsName, nullIfNotFound);
    }

    public static boolean isValidWorkstep(String ptName, String wsName) {
        WFWorkstep workstep = ProcessControl.getWorkStep(ptName, wsName, true);
        return null != workstep;
    }

    public static synchronized ProcessTemplate reinstallProcessTemplate(Session session, String ptName, boolean forceRemoveInstances) {
        BLUtil.getServiceLocal().removeProcessTemplate(session, ptName, forceRemoveInstances);
        return BLUtil.getServiceLocal().createProcessTemplate(session, ptName);
    }

    public static synchronized void updatePTCache(String ptName, String operation) {
        BLConstants consts = BLConstants.single();
        if (operation.equalsIgnoreCase("ADD")) {
            WFProcess ptObject = ProcessTemplateDAO.load(ptName);
            ProcessControl.addProcessTemplateToCache(ptObject.getID());
        } else if (operation.equalsIgnoreCase("REMOVE")) {
            List<Long> ptIdsInCache = ProcessControl.getPtIdsInCache(ptName);
            for (Long ptId : ptIdsInCache) {
                ProcessControl.removeAlertsFromCache(ptId);
                ProcessControl.removeProcessTemplateFromCache(ptId);
            }
        } else if (operation.equalsIgnoreCase("UPDATE")) {
            List<Long> ptIdsInCache = ProcessControl.getPtIdsInCache(ptName);
            for (Long ptId : ptIdsInCache) {
                ProcessControl.removeAlertsFromCache(ptId);
                ProcessControl.addProcessTemplateToCache(ptId);
            }
        } else {
            BLConstants.ClusterConstants cfr_ignored_0 = consts.cluster;
            if (operation.equalsIgnoreCase("CLEAR_PT_CACHE")) {
                ProcessControl.doClearCache();
            }
        }
    }

    private static List<Long> getPtIdsInCache(String ptName) {
        ArrayList<Long> ptIds = new ArrayList<Long>();
        Enumeration pkeys = PTCache.keys();
        while (pkeys.hasMoreElements()) {
            Long ptidKey = (Long)pkeys.nextElement();
            WFProcess ptObject = (WFProcess)PTCache.get(ptidKey);
            if (!ptObject.getName().equals(ptName)) continue;
            ptIds.add(ptidKey);
        }
        return ptIds;
    }

    private static class DataSlotMeta {
        private final WFProcess wfProcess;
        private final Map<Object, Object> keyAttrs;
        private final Map<Object, Object> blobAttrs;
        private final long ptID;
        private final boolean isGlobal;
        private final String type;
        private HashMap dsMap;
        private String tableName;
        private String constraintName;
        private boolean gds;

        private DataSlotMeta(WFProcess wfProcess, Map keyAttrs, Map blobAttrs, long ptID, boolean isGlobal) {
            this.wfProcess = wfProcess;
            this.keyAttrs = keyAttrs;
            this.blobAttrs = blobAttrs;
            this.ptID = ptID;
            this.isGlobal = isGlobal;
            if (isGlobal) {
                this.initializeGlobalDS();
                this.type = "Global";
            } else {
                this.initializeInstanceDS();
                this.type = "Instance";
            }
        }

        private boolean getGds() {
            return this.gds;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void execute(boolean wasGlobalDSExecuted) {
            String sqlStmt = null;
            Connection conn = null;
            Statement stmt = null;
            try {
                sqlStmt = SBMControl.dbmap.getSQLCreateStatementForDS(this.tableName, this.dsMap, this.constraintName);
                if (SBMControl.dbmap.isDDLAutocommit()) {
                    this.executeDDL(this.tableName, sqlStmt);
                } else {
                    conn = ProcessControl.getConnection();
                    stmt = conn.createStatement();
                    stmt.execute(sqlStmt);
                }
                if (this.isGlobal) {
                    this.gds = true;
                }
                BLControl.logger.infoKey("BizLogic_ERR_4104", new Object[]{this.type, this.tableName, this.wfProcess.getName()});
            }
            catch (RuntimeException | SQLException th) {
                try {
                    this.clearResourcesIfGds(this.wfProcess, wasGlobalDSExecuted);
                    this.throwBizlogicException(this.tableName, sqlStmt, th);
                }
                catch (Throwable throwable) {
                    DBService.clean(null, stmt, conn);
                    throw throwable;
                }
                DBService.clean(null, (Statement)stmt, (Connection)conn);
            }
            DBService.clean(null, (Statement)stmt, (Connection)conn);
        }

        private String getTableName() {
            return this.tableName;
        }

        private void initializeGlobalDS() {
            this.dsMap = this.getDSMap(this.wfProcess.getGlobalDataSlotMetaInfo());
            this.tableName = "BIZLOGIC_GLOBALDS_" + String.valueOf(this.ptID).trim();
            this.constraintName = "bl_gs_pkey" + String.valueOf(this.ptID).trim();
        }

        private void initializeInstanceDS() {
            this.dsMap = this.getDSMap(this.wfProcess.getInstanceDataSlotMetaInfo());
            this.tableName = "BIZLOGIC_DS_" + String.valueOf(this.ptID).trim();
            this.constraintName = "bl_ds_pkey" + String.valueOf(this.ptID).trim();
        }

        private HashMap getDSMap(Map dataSlotMetaMap) {
            String string;
            HashMap<String, Map<Object, Object>> dsMap = (HashMap<String, Map<Object, Object>>)DataSlotDAO.polishDataslotNames(dataSlotMetaMap);
            if (dsMap == null) {
                BLControl.logger.warn((Object)(this.type.toLowerCase() + " dataslot is null. Hashmap is created "));
                dsMap = new HashMap<String, Map<Object, Object>>();
            }
            boolean removed = ProcessControl.removeLargeDataSlots(dsMap);
            if (!this.isGlobal) {
                DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
                dsMap.put("PROCESS_INSTANCE_ID", this.keyAttrs);
            }
            DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
            dsMap.put("PROCESS_TEMPLATE_ID", this.keyAttrs);
            if (this.isGlobal) {
                DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
                string = "PROCESS_TEMPLATE_ID";
            } else {
                DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
                string = "PROCESS_INSTANCE_ID";
            }
            dsMap.put("PRIMARY_KEY", (Map<Object, Object>)((Object)string));
            if (removed) {
                dsMap.put("large_dataslots", this.blobAttrs);
            }
            return dsMap;
        }

        private void throwBizlogicException(String tableName, String sqlStmt, Exception th) {
            sqlStmt = this.initializeSqlStmt(sqlStmt);
            throw new BizLogicException("BizLogic_ERR_5014", "ProcessControl.createDataSlotTables", new Object[]{tableName, sqlStmt}, (Throwable)th);
        }

        private String initializeSqlStmt(String sqlStmt) {
            if (sqlStmt == null) {
                sqlStmt = "";
            }
            return sqlStmt;
        }

        private void clearResourcesIfGds(WFProcess pt, boolean gds) {
            if (gds) {
                try {
                    if (SBMControl.dbmap.isDDLAutocommit()) {
                        ProcessControl.removeDataSlotTables(pt.getID());
                    } else {
                        DataSlotDAO.deleteTable(pt);
                    }
                }
                catch (Throwable ignore) {
                    BLControl.logger.error((Object)"Error happened while cleaning the dataslot tables on exception : ", ignore);
                }
            }
        }

        private void executeDDL(String tableName, String sqlStmt) {
            BLUtil.getServiceLocal().executeDDL(sqlStmt);
            if (SBMDatabase.self().isDualDbUser()) {
                String strGrant = SBMDatabase.getSqlGrantStatement((String)tableName, (String)SBMDatabase.self().getAppUserRole());
                BLUtil.getServiceLocal().executeDDL(strGrant);
            }
        }
    }
}

