/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.tdiinc.userManager.Group;
import com.tdiinc.userManager.User;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Vector;

public class Performer
implements Serializable {
    static final long serialVersionUID = -1418904600248474065L;
    public static final int INVALID_USER = -1;
    public static final int USER = 1;
    public static final int GROUP = 2;
    public static final int EMAIL = 3;
    public static final int QUEUE = 4;
    private final String name;
    private int type;
    private String suffix;
    private User user;
    private Group group;

    public Performer(String name, int type) {
        this.name = name;
        this.suffix = name;
        this.type = type;
    }

    public Performer(String name, User userObject) {
        this(name, 1);
        this.user = userObject;
    }

    public User getUser() {
        return this.user;
    }

    public void setGroup(Group grpObj) {
        this.group = grpObj;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getName() {
        return this.name;
    }

    public boolean isInvalid() {
        return this.type == -1;
    }

    public boolean isUser() {
        return this.type == 1;
    }

    public boolean isGroup() {
        return this.type == 2;
    }

    public boolean isQueue() {
        return this.type == 4;
    }

    public boolean isEmail() {
        return this.type == 3;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public boolean equals(Object perf) {
        Performer performer;
        return perf != null && perf instanceof Performer && (performer = (Performer)perf).getName() != null && performer.getName().equals(this.name) && performer.getType() == this.type;
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getType());
    }

    public String toString() {
        return this.name;
    }

    public static boolean areAllInvalid(List perfs) {
        if (perfs == null) {
            return false;
        }
        for (int ix = 0; ix < perfs.size(); ++ix) {
            Performer perf = (Performer)perfs.get(ix);
            if (perf.isInvalid()) continue;
            return false;
        }
        return true;
    }

    public static boolean hasQueue(List perfs) {
        if (perfs == null) {
            return false;
        }
        for (int ix = 0; ix < perfs.size(); ++ix) {
            Performer perf = (Performer)perfs.get(ix);
            if (!perf.isQueue()) continue;
            return true;
        }
        return false;
    }

    public static List getPerformerNames(List perfs) {
        if (perfs == null) {
            return null;
        }
        Vector<String> perfNames = new Vector<String>();
        for (int ix = 0; ix < perfs.size(); ++ix) {
            String name = ((Performer)perfs.get(ix)).getName();
            perfNames.add(name);
        }
        return perfNames;
    }

    public static List getValidPerformerNames(List perfs) {
        if (perfs == null) {
            return null;
        }
        Vector<String> validPerfs = new Vector<String>();
        for (int ix = 0; ix < perfs.size(); ++ix) {
            Performer perf = (Performer)perfs.get(ix);
            if (perf.isInvalid()) continue;
            validPerfs.add(perf.getName());
        }
        return validPerfs;
    }

    public static List getInvalidPerformerNames(List perfs) {
        if (perfs == null) {
            return null;
        }
        Vector<String> invalidPerfs = new Vector<String>();
        for (int ix = 0; ix < perfs.size(); ++ix) {
            Performer perf = (Performer)perfs.get(ix);
            if (!perf.isInvalid()) continue;
            invalidPerfs.add(perf.getName());
        }
        return invalidPerfs;
    }

    public static List getValidPerformers(List perfs) {
        if (perfs == null) {
            return null;
        }
        Vector<Performer> validPerfs = new Vector<Performer>();
        for (int ix = 0; ix < perfs.size(); ++ix) {
            Performer perf = (Performer)perfs.get(ix);
            if (perf.isInvalid()) continue;
            validPerfs.add(perf);
        }
        return validPerfs;
    }

    public static List getInvalidPerformers(List perfs) {
        if (perfs == null) {
            return null;
        }
        Vector<Performer> invalidPerfs = new Vector<Performer>();
        for (int ix = 0; ix < perfs.size(); ++ix) {
            Performer perf = (Performer)perfs.get(ix);
            if (!perf.isInvalid()) continue;
            invalidPerfs.add(perf);
        }
        return invalidPerfs;
    }

    public static List removeAll(List source, Collection target) {
        if (source == null || target == null) {
            return source;
        }
        Vector<Performer> perfs = new Vector<Performer>();
        for (int ix = 0; ix < source.size(); ++ix) {
            Performer perf = (Performer)source.get(ix);
            String name = perf.getName();
            if (target.contains(name)) continue;
            perfs.add(perf);
        }
        return perfs;
    }
}

