/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.messaging.subscriber;

import com.savvion.sbm.bizlogic.client.messagehandler.ICustomMessageHandler;
import com.savvion.sbm.bizlogic.email.EmailComposer;
import com.savvion.sbm.bizlogic.email.EmailNotify;
import com.savvion.sbm.bizlogic.message.EmailMessage;
import com.savvion.sbm.bizlogic.messaging.BLMessageException;
import com.savvion.sbm.bizlogic.messaging.InvalidMessageException;
import com.savvion.sbm.bizlogic.messaging.MessageControl;
import com.savvion.sbm.bizlogic.messaging.MessageHandler;
import com.savvion.sbm.bizlogic.messaging.MsgErrorHandler;
import com.savvion.sbm.bizlogic.messaging.dao.BLMessagesDAO;
import com.savvion.sbm.bizlogic.messaging.subscriber.BLBizMessage;
import com.savvion.sbm.bizlogic.messaging.subscriber.BizTarget;
import com.savvion.sbm.bizlogic.messaging.subscriber.InstanceLocator;
import com.savvion.sbm.bizlogic.messaging.subscriber.MessageComparator;
import com.savvion.sbm.bizlogic.messaging.subscriber.TemplateLocator;
import com.savvion.sbm.bizlogic.server.ProcessControl;
import com.savvion.sbm.bizlogic.server.WFDataslot;
import com.savvion.sbm.bizlogic.server.WFMessageSubscriberInstance;
import com.savvion.sbm.bizlogic.server.WFMessageSubscriberWS;
import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.server.WFProcessContext;
import com.savvion.sbm.bizlogic.server.WFWorkstep;
import com.savvion.sbm.bizlogic.server.WFWorkstepInstance;
import com.savvion.sbm.bizlogic.server.dao.ProcessInstanceDAO;
import com.savvion.sbm.bizlogic.server.dao.WorkStepInstanceDAO;
import com.savvion.sbm.bizlogic.server.ejb.ServiceLocal;
import com.savvion.sbm.bizlogic.server.ejb.WorkStepInstanceEBLocal;
import com.savvion.sbm.bizlogic.server.svo.DateTime;
import com.savvion.sbm.bizlogic.server.svo.Decimal;
import com.savvion.sbm.bizlogic.server.svo.MessageSubscription;
import com.savvion.sbm.bizlogic.server.svo.MessageSubscriptionList;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.ProcessContext;
import com.savvion.sbm.messaging.svo.MessageDescriptor;
import com.savvion.sbm.messaging.svo.MessageProperty;
import com.savvion.sbm.messaging.util.MessagingUtil;
import com.savvion.sbm.util.SBMUtil;
import com.savvion.sbm.util.TransactionService;
import com.savvion.sbm.util.dcl.FCLService;
import com.savvion.sbm.util.logger.SBMLogger;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.jms.Message;
import javax.naming.NamingException;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.apache.commons.collections.MapUtils;

public class MessageManager {
    private static final String NO_TARGET_REASON = "No Start workstep or " + "subscriber workstep in wait state for " + "this message";
    private static final String BIZ_LOGIC_ERR_3073 = "BizLogic_ERR_3073";
    private static final String MEHOD_EXECUTE_TARGET_INSTANCE = "MessageManager.executeTargetInstance";
    private static final String BIZ_LOGIC_ERR_3273 = "BizLogic_ERR_3273";
    private static final String BIZ_LOGIC_ERR_3274 = "BizLogic_ERR_3274";

    public static void processCustomMessage(Message message) {
        if (message == null) {
            throw MsgErrorHandler.createEx("BizLogic_ERR_3605", "MessageManager.processCustomMessage");
        }
        String msgName = null;
        try {
            msgName = message.getStringProperty("messageName");
            ICustomMessageHandler msgHandler = MessageControl.CustomHandler.getCustomHandler(msgName).loadMapMessageHandler();
            msgHandler.execute(message);
        }
        catch (BizLogicException be) {
            throw be;
        }
        catch (Throwable th) {
            throw MsgErrorHandler.createEx("BizLogic_ERR_3773", "MessageManager.processCustomMessage", new Object[]{message, msgName}, th);
        }
    }

    public static void process(BLBizMessage message) {
        if (message == null) {
            return;
        }
        try {
            if (MessageManager.isValid(message)) {
                MessageDescriptor msgDescr = message.getMessageDescriptor();
                if (msgDescr.isWorkFlowMessage()) {
                    MessageManager.processWorkFlowMessage(message);
                } else {
                    MessageManager.processNonWorkFlowMessage(message, msgDescr);
                }
            }
        }
        catch (Throwable t) {
            BLControl.logger.error((Object)"MessageManager.process: Throwable", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processNonWorkFlowMessage(BLBizMessage message, MessageDescriptor msgDescr) {
        MessageHandler handler = null;
        UserTransaction uTx = null;
        try {
            if (BLControl.util.DEBUG_MESSAGING) {
                MessageControl.self().logger.debugKey("BizLogic_ERR_2232", "MessageManager.processNonWorkFlowMessage", new Object[]{message.getMessageName()});
            }
            ArrayList<BLBizMessage> msgList = new ArrayList<BLBizMessage>();
            msgList.add(message);
            String handlerName = msgDescr.getHandler();
            if (handlerName == null || handlerName.trim().length() == 0) {
                throw MsgErrorHandler.createEx("MessageManager.processNonWorkFlowMessage", "BizLogic_ERR_899", new Object[]{message.getMessageName()});
            }
            handler = MessageControl.loadSubscriberHandler(handlerName, null, false);
            uTx = TransactionService.getUserTransaction();
            TransactionService.begin((UserTransaction)uTx);
            handler.init();
            handler.execute(msgList);
            handler.destroy();
            HashMap messagesToDiscard = handler.getMessagesToDiscard();
            if (messagesToDiscard != null && !messagesToDiscard.isEmpty()) {
                TransactionService.rollback((UserTransaction)uTx);
                MessageManager.discardMessagesAndNotify(null, -1L, messagesToDiscard, null);
            } else {
                TransactionService.commit((UserTransaction)uTx);
            }
        }
        catch (InvalidMessageException ex) {
            TransactionService.rollback(uTx);
            if (handler != null) {
                HashMap messagesToDiscard = handler.getMessagesToDiscard();
                MessageManager.discardMessagesAndNotify(null, -1L, messagesToDiscard, ex);
            }
        }
        catch (BLMessageException e) {
            if (e.isDiscardAndNotify()) {
                MessageManager.discardMessageAndNotify(message, e);
            }
            TransactionService.rollback(uTx, (SBMLogger)BLControl.logger);
        }
        catch (Throwable t) {
            TransactionService.rollback(uTx, (SBMLogger)BLControl.logger);
            BLControl.logger.error((Object)"MessageManager.processNonWorkFlowMessage: Throwable", t);
        }
        finally {
            FCLService.removeCurrentThreadCL();
        }
    }

    private static void processWorkFlowMessage(BLBizMessage message) {
        List<BizTarget> runnableTargets = MessageManager.findRunnableInstances(message);
        if (runnableTargets != null && !runnableTargets.isEmpty()) {
            MessageManager.executeRunnableTargetInstances(runnableTargets);
        }
    }

    private static List<BizTarget> findRunnableInstances(BLBizMessage message) {
        UserTransaction uTx = null;
        List runnableTargetInstances = null;
        boolean foundTarget = false;
        try {
            if (BLControl.util.DEBUG_MESSAGING) {
                MessageControl.self().logger.debugKey("BizLogic_ERR_2231", "MessageManager.processWorkFlowMessage", new Object[]{message.getMessageName()});
            }
            if (!message.getMessageDescriptor().isNotification() && !message.isSerializable()) {
                throw MsgErrorHandler.createEx("BizLogic_ERR_701", "MessageManager.processWorkFlowMessage", new Object[]{message.getMessageName()}, true);
            }
            List templateIDs = TemplateLocator.getTemplates(message);
            uTx = TransactionService.getUserTransaction();
            TransactionService.begin((UserTransaction)uTx);
            if (templateIDs != null && !templateIDs.isEmpty()) {
                TemplateLocator.instantiateTemplates(templateIDs, message);
                foundTarget = true;
            }
            runnableTargetInstances = MessageManager.getTargetInstances(message);
            TransactionService.commit((UserTransaction)uTx);
            if (runnableTargetInstances != null && !runnableTargetInstances.isEmpty()) {
                foundTarget = true;
            }
            if (!foundTarget) {
                MessageManager.discardMessageAndNotify(message, NO_TARGET_REASON);
            }
        }
        catch (BLMessageException e) {
            if (e.isDiscardAndNotify()) {
                MessageManager.discardMessageAndNotify(message, e);
            }
            TransactionService.rollback(uTx, (SBMLogger)BLControl.logger);
        }
        catch (Throwable t) {
            TransactionService.rollback(uTx, (SBMLogger)BLControl.logger);
            BLControl.logger.error((Object)"MessageManager.process: Throwable", t);
        }
        return runnableTargetInstances;
    }

    private static List getTargetInstances(BLBizMessage message) {
        List targets = InstanceLocator.getTargetInstances(message);
        if (BLControl.util.DEBUG_MESSAGING) {
            MessageControl.self().logger.debugKey("BizLogic_ERR_2235", "MessageManager.getTargetInstances", new Object[]{targets.size(), message.getMessageName()});
        }
        if (targets.isEmpty()) {
            return targets;
        }
        if (!message.getMessageDescriptor().isNotification()) {
            MessageManager.persistTargetInstances(targets, message);
        }
        targets = MessageManager.getRunnableWSInstances(targets);
        for (int i = 0; i < targets.size(); ++i) {
            BizTarget target = (BizTarget)targets.get(i);
            MessageManager.setWorkstepStateForSubscriber(target.piid, target.wsid, 18);
        }
        return targets;
    }

    private static void persistTargetInstances(List targets, BLBizMessage message) {
        ArrayList<HashMap> targetInstances = new ArrayList<HashMap>(targets.size());
        for (int ix = 0; ix < targets.size(); ++ix) {
            BizTarget target = (BizTarget)targets.get(ix);
            long piid = target.piid;
            long wsid = target.wsid;
            HashMap targetInstanceInfo = WorkStepInstanceDAO.getLoopCounterAndStatus(piid, wsid);
            if (targetInstanceInfo.isEmpty()) {
                if (!ProcessInstanceDAO.isProcessInstanceExist(piid)) continue;
                targetInstanceInfo.put("LOOPCOUNTER", 1);
                targetInstanceInfo.put("STATUS", 15);
            }
            int status = (Integer)targetInstanceInfo.get("STATUS");
            if (status == 18) {
                int loopCounter = (Integer)targetInstanceInfo.get("LOOPCOUNTER");
                targetInstanceInfo.put("LOOPCOUNTER", loopCounter + 1);
            }
            targetInstanceInfo.put("PROCESSINSTANCEID", piid);
            targetInstanceInfo.put("WORKSTEPID", wsid);
            targetInstances.add(targetInstanceInfo);
        }
        BLMessagesDAO.create(targetInstances, message);
        if (BLControl.util.DEBUG_MESSAGING) {
            MessageControl.self().logger.debugKey("BizLogic_ERR_2236", "MessageManager.persistTargetInstances", new Object[]{targetInstances.size(), message.getMessageName()});
        }
    }

    private static List getRunnableWSInstances(List targets) {
        ArrayList<BizTarget> runnableTargets = new ArrayList<BizTarget>();
        for (int ix = 0; ix < targets.size(); ++ix) {
            BizTarget target = (BizTarget)targets.get(ix);
            HashMap msgCountsInDB = BLMessagesDAO.getMessageCount(target.piid, target.wsid, 60);
            WFProcess pt = ProcessControl.getProcessTemplate(target.ptid);
            WFWorkstep ws = pt.getWorkstep(target.wsid);
            if (!WFMessageSubscriberInstance.hasRequiredMessageCount(ws, msgCountsInDB)) continue;
            runnableTargets.add(target);
        }
        return runnableTargets;
    }

    private static void executeRunnableTargetInstances(List readyTargetInstances) {
        for (int ix = 0; ix < readyTargetInstances.size(); ++ix) {
            BizTarget target = (BizTarget)readyTargetInstances.get(ix);
            MessageManager.executeTargetInstance(target.piid, target.wsid, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeTargetInstance(long piid, long wsid, boolean useUserTx) {
        TargetInstanceMeta meta = new TargetInstanceMeta();
        try {
            String handlerName;
            MessageHandler handler;
            meta.initTransaction(piid, wsid, useUserTx);
            meta.setContext(piid);
            meta.setWorkstep(wsid);
            int loopCounter = MessageManager.getLoopCounter(wsid, meta.pCtx);
            meta.setMessageList(piid, wsid, loopCounter);
            MessageManager.logDebug(BIZ_LOGIC_ERR_3274, meta.messageList, piid, meta.workstep.getName(), loopCounter);
            MessageManager.sortListBySubscription(meta.workstep, meta.messageList);
            MessageManager.updateDataslots(meta.pCtx, meta.workstep, meta.messageList);
            boolean sync = MessageManager.isSynchronous(meta.workstep);
            if (meta.workstep.isMessageSubscriberWS() && !sync) {
                meta.pCtx.completeWorkstep(wsid);
                meta.wsCompleted = true;
                TransactionService.commit((UserTransaction)meta.uTx);
                TransactionService.begin((UserTransaction)meta.uTx);
            }
            if ((handler = MessageControl.loadSubscriberHandler(handlerName = meta.workstep.getMessageSubscriptionList().getHandler(), meta.ptName, false)) != null && MessageManager.handleDiscardedMessages(wsid, meta, loopCounter, handler)) {
                return;
            }
            meta.wsCompleted = MessageManager.handleWSMessageSubscription(piid, wsid, meta, loopCounter, sync);
            TransactionService.commit((UserTransaction)meta.uTx);
        }
        catch (Throwable t) {
            MessageManager.handleThrowable(wsid, meta, t);
        }
        finally {
            FCLService.removeCurrentThreadCL();
        }
    }

    private static int getLoopCounter(long wsid, WFProcessContext pCtx) {
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
        return wsieb.getLoopCounter();
    }

    private static boolean handleWSMessageSubscription(long piid, long wsid, TargetInstanceMeta meta, int loopCounter, boolean sync) {
        boolean isWsFinish = meta.wsCompleted;
        if (meta.workstep.isMessageSubscriberWS() && sync) {
            meta.pCtx.completeWorkstep(wsid);
            isWsFinish = true;
        }
        BLMessagesDAO.remove(piid, wsid, loopCounter);
        if (!meta.workstep.isMessageSubscriberWS()) {
            WFWorkstepInstance.getWorkstepInstance(meta.workstep.getType()).runIt(meta.pCtx, wsid);
        }
        return isWsFinish;
    }

    private static void handleThrowable(long wsid, TargetInstanceMeta meta, Throwable throwable) {
        if (meta.pCtx != null && meta.workstep != null) {
            BLControl.logger.errorKey(BIZ_LOGIC_ERR_3073, MEHOD_EXECUTE_TARGET_INSTANCE, throwable, new Object[]{meta.workstep.getName(), meta.pCtx.getProcessInstanceID()});
        } else if (meta.pCtx != null && meta.workstep == null) {
            BLControl.logger.errorKey(BIZ_LOGIC_ERR_3073, MEHOD_EXECUTE_TARGET_INSTANCE, throwable, new Object[]{null, meta.pCtx.getProcessInstanceID()});
        } else {
            BLControl.logger.errorKey(BIZ_LOGIC_ERR_3073, MEHOD_EXECUTE_TARGET_INSTANCE, throwable, new Object[]{null, null});
        }
        TransactionService.rollback((UserTransaction)meta.uTx, (SBMLogger)BLControl.logger);
        if (!meta.wsCompleted) {
            MessageManager.suspend(meta.pCtx, wsid);
        }
    }

    private static boolean handleDiscardedMessages(long wsid, TargetInstanceMeta meta, int loopCounter, MessageHandler handler) {
        try {
            MessageManager.invokeHandler(meta.pCtx, wsid, loopCounter, meta.messageList, handler);
            HashMap messagesToDiscard = handler.getMessagesToDiscard();
            if (MapUtils.isNotEmpty((Map)messagesToDiscard)) {
                TransactionService.rollback((UserTransaction)meta.uTx);
                MessageManager.discardMessagesAndNotify(meta.pCtx, wsid, messagesToDiscard, null);
                return true;
            }
        }
        catch (InvalidMessageException ex) {
            TransactionService.rollback((UserTransaction)meta.uTx);
            HashMap messagesToDiscard = handler.getMessagesToDiscard();
            MessageManager.discardMessagesAndNotify(meta.pCtx, wsid, messagesToDiscard, ex);
            return true;
        }
        return false;
    }

    private static void logDebug(String message, Object ... objects) {
        if (BLControl.util.DEBUG_MESSAGING) {
            BLControl.logger.debugKey(message, "MessageManager.executeTargetInstance()", objects);
        }
    }

    private static void sortListBySubscription(WFWorkstep ws, List messageList) {
        Map<String, Integer> subscribedMessageOrdering = ws.getMessageSubscriptionList().getMessageOrderingBySubscription();
        MessageComparator messageComparator = new MessageComparator(subscribedMessageOrdering);
        Collections.sort(messageList, messageComparator);
    }

    private static void updateDataslots(WFProcessContext pCtx, WFWorkstep ws, List messageList) {
        for (int ix = 0; ix < messageList.size(); ++ix) {
            BLBizMessage message = (BLBizMessage)messageList.get(ix);
            MessageManager.updateDataslots(message, pCtx, ws);
        }
    }

    private static void updateDataslots(BLBizMessage message, WFProcessContext pCtx, WFWorkstep ws) {
        HashMap<String, Object> dsValues = MessageManager.getDSValuesMappedToMessage(message, ws, pCtx.getProcess(), true);
        if (BLControl.util.DEBUG_MESSAGING) {
            BLControl.logger.debugKey("BizLogic_ERR_3275", "MessageManager.updateDataslots()", new Object[]{dsValues, pCtx.getProcessInstanceName()});
        }
        pCtx.updateSlotValue(dsValues);
    }

    private static void invokeHandler(WFProcessContext pCtx, long wsid, int loopCntr, List messageList, MessageHandler handler) {
        WFWorkstep ws = pCtx.getWorkstep(wsid);
        String wsName = ws.getName();
        String piName = pCtx.getProcessInstanceName();
        if (BLControl.util.DEBUG_MESSAGING) {
            MessageControl.self().logger.debugKey("BizLogic_ERR_2238", "MessageManager.invokeHandler", new Object[]{"init", wsName, piName});
        }
        handler.init();
        if (BLControl.util.DEBUG_MESSAGING) {
            MessageControl.self().logger.debugKey("BizLogic_ERR_2238", "MessageManager.invokeHandler", new Object[]{"setContext", wsName, piName});
        }
        ProcessContext contextData = MessageManager.getContextData(pCtx, wsid, loopCntr);
        handler.setContext(contextData);
        if (BLControl.util.DEBUG_MESSAGING) {
            MessageControl.self().logger.debugKey("BizLogic_ERR_2238", "MessageManager.invokeHandler", new Object[]{"execute", wsName, piName});
        }
        HashMap outputSlots = handler.execute(messageList);
        if (MessageManager.isSynchronous(ws)) {
            if (BLControl.util.DEBUG_MESSAGING) {
                MessageControl.self().logger.debugKey("BizLogic_ERR_2239", "MessageManager.invokeHandler", new Object[]{wsName, piName});
            }
            pCtx.updateSlotValue(outputSlots);
        }
        if (BLControl.util.DEBUG_MESSAGING) {
            MessageControl.self().logger.debugKey("BizLogic_ERR_2238", "MessageManager.invokeHandler", new Object[]{"destroy", wsName, piName});
        }
        handler.destroy();
    }

    private static ProcessContext getContextData(WFProcessContext pCtx, long wsid, int loopCounter) {
        WFWorkstep ws = pCtx.getWorkstep(wsid);
        boolean sync = MessageManager.isSynchronous(ws);
        HashMap contextInfo = new HashMap();
        HashMap<String, Object> processCtx = new HashMap<String, Object>();
        processCtx.put("ProcessTemplateName", pCtx.getProcessTemplateName());
        processCtx.put("ProcessInstanceName", pCtx.getProcessInstanceName());
        processCtx.put("ProcessInstanceID", pCtx.getProcessInstanceID());
        processCtx.put("WorkstepName", ws.getName());
        processCtx.put("WorkstepID", wsid);
        processCtx.put("MappedInputDataslots", ws.getInputSlotsMapping());
        HashMap inputSlotValuesByMappedName = WFWorkstepInstance.single().getInputSlotValueByMappedName(pCtx, ws.getID());
        if (inputSlotValuesByMappedName == null) {
            inputSlotValuesByMappedName = new HashMap();
        }
        contextInfo.put("InputSlots", inputSlotValuesByMappedName);
        MessageSubscriptionList msgSubscriptionList = ws.getMessageSubscriptionList();
        processCtx.put("MappedOutputDataslots", msgSubscriptionList.getAllMessageMapping());
        processCtx.put("DataslotTypes", pCtx.getSlotsType());
        processCtx.put("SYNCHRONOUS", sync);
        processCtx.put("LOOPCOUNTER", loopCounter);
        if (!sync) {
            contextInfo.put("CallerInfo", BLControl.getCallerInfo());
        }
        contextInfo.put("ProcessContext", processCtx);
        return new ProcessContext(contextInfo);
    }

    private static void discardMessageAndNotify(BLBizMessage message, BLMessageException blme) {
        String reason = "no reason";
        if (blme != null) {
            reason = blme.getMessage();
        }
        MessageManager.discardMessageAndNotify(message, reason);
    }

    private static void discardMessageAndNotify(BLBizMessage message, String reason) {
        HashMap<BLBizMessage, String> messagesToDiscard = new HashMap<BLBizMessage, String>();
        messagesToDiscard.put(message, reason);
        MessageManager.discardMessagesAndNotify(null, -1L, messagesToDiscard, null);
    }

    private static void discardMessagesAndNotify(WFProcessContext pCtx, long wsid, HashMap messagesToDiscard, Throwable th) {
        ServiceLocal serviceLocal = BLUtil.getServiceLocal();
        serviceLocal.discardMessagesAndNotify(pCtx, wsid, messagesToDiscard, th);
    }

    public static void doDiscardMessagesAndNotify(WFProcessContext pCtx, long wsid, HashMap messagesToDiscard, Throwable th) {
        if (pCtx != null && wsid != -1L) {
            long piid = pCtx.getProcessInstanceID();
            int loopCounter = MessageManager.getLoopCounter(wsid, pCtx);
            String[] msgNames = new String[messagesToDiscard.size()];
            int index = 0;
            for (BLBizMessage message : messagesToDiscard.keySet()) {
                msgNames[index++] = message.getMessageName();
            }
            BLMessagesDAO.removeByMessageNames(piid, wsid, loopCounter, msgNames);
            WFWorkstep ws = pCtx.getWorkstep(wsid);
            if (ws.isMessageSubscriberWS()) {
                MessageManager.setWorkstepStateForSubscriber(piid, wsid, 60);
            }
        }
        for (BLBizMessage message : messagesToDiscard.keySet()) {
            String discardReason = (String)messagesToDiscard.get(message);
            if (discardReason == null || discardReason.trim().length() == 0) {
                discardReason = "no reason";
            }
            if (BLControl.util.DEBUG_MESSAGING) {
                MessageControl.self().logger.debugKey("BizLogic_ERR_2152", "MessageManager.doDiscardMessagesAndNotify", new Object[]{message.getMessageName(), discardReason});
            }
            String stackTrace = "no exception";
            if (th != null) {
                stackTrace = SBMUtil.getStackTrace((Throwable)th);
            }
            BLMessagesDAO.createDiscardedMessage(message, discardReason, stackTrace);
            if (!message.senderEmailExists()) continue;
            if (BLControl.util.DEBUG_MESSAGING) {
                MessageControl.self().logger.debugKey("BizLogic_ERR_2153", "MessageManager.doDiscardMessagesAndNotify", new Object[]{message.getSenderEmail(), message.getMessageName()});
            }
            try {
                Locale recipientLocale = SBMUtil.self().getUserLocale(message.getSenderName(), true);
                String invalidMsgEmailSub = EmailComposer.self().getBLEmailMessageFactory(recipientLocale).lookup("BLEMAIL_MSG_032", null, false);
                String subj = MessageManager.format(invalidMsgEmailSub, message.getMessageName());
                String invalidMsgEmailBody = EmailComposer.self().getBLEmailMessageFactory(recipientLocale).lookup("BLEMAIL_MSG_033", null, false);
                String content = MessageManager.format(invalidMsgEmailBody, message.getMessageName(), discardReason, stackTrace);
                String[] from = new String[]{BLUtil.BLEMAILACCOUNT};
                String[] to = new String[]{message.getSenderEmail()};
                EmailMessage emailMsg = new EmailMessage(subj, content, null, from, to);
                EmailNotify.self().send(emailMsg);
            }
            catch (Throwable throwable) {
                MessageControl.self().logger.warnKey("BizLogic_ERR_3612", "MessageManager.doDiscardMessagesAndNotify", throwable, new Object[]{message.getMessageName()});
            }
        }
    }

    private static void suspend(WFProcessContext pCtx, long wsid) {
        try {
            BLUtil.getServiceLocal().suspendSubscriber(pCtx, wsid);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static final void doSuspend(WFProcessContext pCtx, long wsid) {
        pCtx.getWorkstepInstanceEB(wsid).setSuspendState(10);
        WFMessageSubscriberInstance.self().suspend(pCtx, wsid, true, null, null);
    }

    private static boolean isSynchronous(WFWorkstep ws) {
        boolean sync = true;
        if (ws.isMessageSubscriberWS()) {
            sync = ((WFMessageSubscriberWS)ws).isSynchronous();
        }
        return sync;
    }

    private static void setWorkstepStateForSubscriber(long piid, long wsid, int newState) {
        WorkStepInstanceEBLocal wsieb = BLControl.util.getWorkStepInstanceEB(piid, wsid);
        int type = wsieb.getType();
        if (type != 110) {
            return;
        }
        int currentState = wsieb.getState();
        wsieb.setPreviousState(currentState);
        wsieb.setState(newState);
    }

    private static boolean isValid(BLBizMessage message) {
        UserTransaction uTx = null;
        try {
            uTx = TransactionService.getUserTransaction();
            TransactionService.begin((UserTransaction)uTx);
            if (!MessageManager.isValidExpirationDate(message)) {
                return false;
            }
            if (!MessageManager.isValidPassword(message)) {
                return false;
            }
            if (BLControl.util.DEBUG_MESSAGING) {
                MessageControl.self().logger.debugKey("BizLogic_ERR_2229", "MessageManager.isValid", new Object[]{message.getMessageName()});
            }
            TransactionService.commit((UserTransaction)uTx, (SBMLogger)BLControl.logger);
        }
        catch (Throwable th) {
            TransactionService.rollback((UserTransaction)uTx, (SBMLogger)BLControl.logger);
            throw MsgErrorHandler.createEx("MessageManager.isValid", "BizLogic_ERR_4523", new Object[]{message.getMessageName()});
        }
        return true;
    }

    private static boolean isValidExpirationDate(BLBizMessage message) {
        String name = message.getMessageName();
        MessageDescriptor msgDescr = message.getMessageDescriptor();
        String expDateStr = msgDescr.getExpirationDate();
        if (BLControl.util.DEBUG_MESSAGING) {
            MessageControl.self().logger.debugKey("BizLogic_ERR_2233", "MessageManager.isValidExpirationDate", new Object[]{name, expDateStr});
        }
        if (expDateStr == null || expDateStr.trim().length() == 0) {
            return true;
        }
        try {
            DateTime date = new DateTime(expDateStr);
            long expTime = date.getTime();
            long recTime = message.getReceivedTime();
            if (recTime <= expTime) {
                return true;
            }
            MessageControl.self().logger.warnKey("BizLogic_ERR_706", "MessageManager.isValidExpirationDate", null, new Object[]{name});
            return false;
        }
        catch (ParseException e) {
            MessageControl.self().logger.warnKey("BizLogic_ERR_713", "MessageManager.isValidExpirationDate", (Throwable)e, new Object[]{name});
            return true;
        }
    }

    private static boolean isValidPassword(BLBizMessage message) {
        String reqdPwd;
        String name = message.getMessageName();
        MessageDescriptor msgDescr = message.getMessageDescriptor();
        if (BLControl.util.DEBUG_MESSAGING) {
            MessageControl.self().logger.debugKey("BizLogic_ERR_2234", "MessageManager.isValidPassword", new Object[]{name});
        }
        if ((reqdPwd = msgDescr.getPassword()) == null || reqdPwd.trim().length() == 0) {
            return true;
        }
        String msgPwd = message.getPassword();
        if (msgPwd != null && msgPwd.equals(reqdPwd)) {
            return true;
        }
        MessageControl.self().logger.errorKey("BizLogic_ERR_707", "MessageManager.isValidPassword", null, new Object[]{name});
        return false;
    }

    private static String format(String toFormat, Object ... arguments) {
        StringBuilder sb = new StringBuilder(100);
        Formatter formatter = new Formatter(sb, Locale.getDefault());
        formatter.format(toFormat, arguments);
        return sb.toString();
    }

    public static List<HashMap<String, Object>> getWorkstepMessages(long piid) {
        List<HashMap<String, Object>> messageList = BLMessagesDAO.getWorkstepMessages(piid);
        for (HashMap<String, Object> hm : messageList) {
            BLConstants.single();
            long ptid = (Long)hm.get("PROCESSTEMPLATEID");
            BLConstants.single();
            long wsid = (Long)hm.get("WORKSTEPID");
            WFProcess process = ProcessControl.getProcessTemplate(ptid);
            String ptName = process.getName();
            String wsName = process.getWorkstep(wsid).getName();
            BLConstants.single();
            hm.put("PROCESSTEMPLATENAME", ptName);
            BLConstants.single();
            hm.put("WORKSTEPNAME", wsName);
        }
        return messageList;
    }

    public static HashMap<String, Object> getDSValuesMappedToMessage(BLBizMessage message, WFWorkstep ws, WFProcess pt, boolean throwExOnMissingData) {
        String msgName = message.getMessageName();
        MessageSubscriptionList msgSubscriptionList = ws.getMessageSubscriptionList();
        MessageSubscription msgSubscr = msgSubscriptionList.getSubscribedMessage(msgName);
        HashMap<String, Object> dsValues = new HashMap<String, Object>();
        if (msgSubscr == null) {
            return dsValues;
        }
        List messageMapping = msgSubscr.getMessageMapping();
        String msgValue = null;
        for (int ix = 0; ix < messageMapping.size(); ++ix) {
            HashMap oneMapping = (HashMap)messageMapping.get(ix);
            String msgPropName = (String)oneMapping.get("COPY_FROM");
            try {
                msgValue = message.getProperty(msgPropName);
                if (msgValue == null || msgValue.length() == 0) continue;
                MessageProperty msgProp = message.getMessageDescriptor().getProperty(msgPropName);
                String dsName = (String)oneMapping.get("COPY_TO");
                if (pt.getDataslot(dsName = dsName.substring(1)).isXML() && msgProp.getXPath().endsWith("text()")) {
                    msgValue = MessagingUtil.decodeString((byte[])msgValue.getBytes(), (String)"base64");
                }
                dsValues.put(dsName, msgValue);
                continue;
            }
            catch (BLMessageException blme) {
                if (throwExOnMissingData) {
                    throw blme;
                }
                MessageControl.self().logger.warnKey("BizLogic_ERR_3079", "MessageManager.getDSValuesMappedToMessage", new Object[]{msgPropName, message.getMessageName(), ws.getName(), ws.getProcessName()});
            }
        }
        MessageManager.convertEncodedValuesToObjects(pt, dsValues);
        return dsValues;
    }

    private static void convertEncodedValuesToObjects(WFProcess pt, Map<String, Object> dsValues) {
        if (dsValues == null || dsValues.isEmpty()) {
            return;
        }
        ArrayList<String> keyList = new ArrayList<String>(dsValues.keySet());
        for (String dsName : keyList) {
            WFDataslot ds = pt.getDataslot(dsName);
            MessageManager.convertEncodedValueToObject(ds, dsValues);
        }
    }

    private static void convertEncodedValueToObject(WFDataslot ds, Map<String, Object> dsValues) {
        String dsName = ds.getName();
        String strValue = (String)dsValues.get(dsName);
        if ((strValue = strValue.trim()) == null || strValue.length() == 0 || "<NULL>".equals(strValue)) {
            dsValues.remove(dsName);
            BLControl.logger.infoKey("BizLogic_ERR_3249", new Object[]{strValue, dsName});
            return;
        }
        if (ds.isDecimal()) {
            BigDecimal bd = new BigDecimal(strValue);
            bd = bd.setScale(ds.getScale());
            Decimal decimal = new Decimal(bd);
            dsValues.put(dsName, decimal);
        } else if (ds.isDate()) {
            long time = -1L;
            try {
                time = Long.parseLong(strValue);
            }
            catch (NumberFormatException nfe) {
                throw MsgErrorHandler.createEx("BizLogic_ERR_3072", "MessageManager.convertEncodedValueToObject", new Object[]{strValue, dsName, ds.getParentProcess().getName()}, nfe);
            }
            Timestamp ts = new Timestamp(time);
            DateTime dt = new DateTime(ts);
            dsValues.put(dsName, dt);
        } else if (!ds.isXML() && ds.isComplex()) {
            String decodedStrValue = MessagingUtil.decodeString((byte[])strValue.getBytes(), (String)"base64");
            Object value = BLUtil.self().getDataTransformer().fromString(decodedStrValue);
            dsValues.put(dsName, value);
        }
    }

    private static class TargetInstanceMeta {
        private boolean wsCompleted;
        private WFProcessContext pCtx;
        private WFWorkstep workstep;
        private UserTransaction uTx;
        private String ptName;
        private List<Object> messageList;

        private TargetInstanceMeta() {
        }

        private void setWorkstep(long wsid) {
            this.workstep = this.pCtx.getWorkstep(wsid);
            this.ptName = this.workstep.getProcessName();
        }

        private void setContext(long piid) {
            this.pCtx = new WFProcessContext(BLControl.getServerSession(), piid);
        }

        private void setMessageList(long piid, long wsid, int loopCounter) {
            this.messageList = BLMessagesDAO.getMessageList(piid, wsid, loopCounter);
        }

        private void initTransaction(long piid, long wsid, boolean useUserTx) throws NamingException, NotSupportedException, SystemException {
            if (useUserTx) {
                this.uTx = TransactionService.getUserTransaction();
                TransactionService.begin((UserTransaction)this.uTx);
                MessageManager.logDebug(MessageManager.BIZ_LOGIC_ERR_3273, new Object[]{piid, wsid});
            }
        }
    }
}

