/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.messaging.publisher;

import com.savvion.sbm.bizlogic.messaging.MsgErrorHandler;
import com.savvion.sbm.bizlogic.messaging.publisher.MessagePublisher;
import com.savvion.sbm.bizlogic.util.BLJMSService;
import com.savvion.sbm.messaging.svo.Channel;
import com.savvion.sbm.util.BMJMSService;
import com.savvion.sbm.util.ServiceLocator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Message;
import javax.jms.Session;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class BLJMSMessagePublisher
extends MessagePublisher {
    @Override
    public void init() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public Object createMessage() throws Exception {
        String correlationId;
        HashMap<String, Object> headerProps = this.getHeaderProperties();
        String payload = this.createPayload();
        Message message = this.createMessage(1, headerProps, payload);
        if (this.isDebug() && (correlationId = message.getJMSCorrelationID()) != null) {
            this.getLogger().debugKey("BizLogic_ERR_3141", "MessagePublisher.createMessage", new Object[]{this.getWorkStepName(), this.getProcessInstanceName(), this.getMessageDescriptor().getMessageName(), correlationId});
        }
        return message;
    }

    @Override
    public HashMap publish(Object message) throws Exception {
        Message jmsMsg = (Message)message;
        this.doPublish(jmsMsg);
        this.getLogger().debugKey("BizLogic_ERR_3139", "BLJMSMessagePublisher.publish", new Object[]{this.getMessageDescriptor().getMessageName(), this.getWorkStepName(), this.getProcessInstanceName()});
        return null;
    }

    public final Message createMessage(int msgType, HashMap<String, Object> msgProps, Object msgPayload) throws Exception {
        boolean hasCorrelationId;
        Channel channel = this.getChannel();
        Message message = null;
        InitialContext ic = null;
        Connection conn = null;
        Session sess = null;
        try {
            ic = this.getInitialContext(channel);
            ConnectionFactory cf = (ConnectionFactory)ic.lookup(channel.getConnectionFactoryName());
            conn = BLJMSService.self().createConnection(cf, null, null);
            sess = BLJMSService.self().createSession(conn);
            message = BLJMSService.self().createMessage(sess, msgType, msgPayload, msgProps);
        }
        catch (NamingException e) {
            try {
                throw MsgErrorHandler.createEx("BizLogic_ERR_3618", "BLJMSMessagePublisher.createMessage", new Object[]{this.getMessageDescriptor().getMessageName(), this.getWorkStepName(), this.getProcessInstanceName()}, e);
            }
            catch (Throwable throwable) {
                BMJMSService.close(null, conn, sess);
                throw throwable;
            }
        }
        BMJMSService.close(null, (Connection)conn, (Session)sess);
        if (msgProps != null && (hasCorrelationId = msgProps.containsKey("SenderCorrelationId"))) {
            String correlationId = (String)msgProps.get("SenderCorrelationId");
            if (correlationId != null) {
                message.setJMSCorrelationID(correlationId);
            } else {
                throw MsgErrorHandler.createEx("BizLogic_ERR_3142", "BLJMSMessagePublisher.createMessage", new Object[]{this.getMessageDescriptor().getMessageName(), this.getWorkStepName(), this.getProcessInstanceID()});
            }
        }
        return message;
    }

    public final void doPublish(Message msg) throws Exception {
        Channel channel = this.getChannel();
        InitialContext ic = null;
        try {
            ic = this.getInitialContext(channel);
        }
        catch (NamingException e) {
            throw MsgErrorHandler.createEx("BizLogic_ERR_3618", "BLJMSMessagePublisher.publish", new Object[]{this.getMessageDescriptor().getMessageName(), this.getWorkStepName(), this.getProcessInstanceName()}, e);
        }
        ConnectionFactory cf = (ConnectionFactory)ic.lookup(channel.getConnectionFactoryName());
        HashMap<String, Object> jmsProps = new HashMap<String, Object>();
        jmsProps.put("destination_name", channel.getDestinationName());
        jmsProps.put("factoryobject", cf);
        jmsProps.put("initialcontext", ic);
        BLJMSService.self().sendMessage(jmsProps, (Object)msg, 6, null);
    }

    private InitialContext getInitialContext(Channel channel) throws NamingException {
        Map serverProps = channel.getServerProperties();
        String channelName = channel.getChannelName();
        if (channel.isLocal()) {
            if (ServiceLocator.self().isRemoteJMS()) {
                String provider = ServiceLocator.self().getJMSProvider();
                return ServiceLocator.self().getInitialContext(provider + ".jms", true);
            }
            return ServiceLocator.self().getInitialContext();
        }
        String factoryInitial = (String)serverProps.get("factoryInitial");
        this.validate(factoryInitial, "initial context factory", channelName);
        String providerURL = (String)serverProps.get("providerURL");
        this.validate(providerURL, "provider URL", channelName);
        String principal = (String)serverProps.get("principal");
        String credential = (String)serverProps.get("credential");
        Properties jndiProps = new Properties();
        jndiProps.put("java.naming.factory.initial", factoryInitial);
        jndiProps.put("java.naming.provider.url", providerURL);
        if (principal != null) {
            jndiProps.put("java.naming.security.principal", principal);
        }
        if (credential != null) {
            jndiProps.put("java.naming.security.credentials", credential);
        }
        InitialContext ic = new InitialContext(jndiProps);
        return ic;
    }

    private void validate(String stringToValidate, String channelProp, String channelName) {
        if (stringToValidate == null || stringToValidate.trim().length() == 0) {
            throw MsgErrorHandler.createEx("BizLogic_ERR_3619", "BLJMSMessagePublisher.validate()", new Object[]{channelProp, channelName});
        }
    }
}

