/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.storeevent.mconsole;

import com.savvion.sbm.bizlogic.storeevent.mconsole.MConsole;
import java.lang.reflect.Method;
import java.sql.Connection;

public class ConsoleTable {
    private String tableName = "";
    private Class appClass;
    private Method insertMethod;
    private Method updateMethod;
    private final String dbtype;
    private int oneRowPer = 0;
    private int updateFrequency = 1;
    private int maxRows = 0;
    private boolean hasMaxRowLimit = false;
    private String schema;
    private boolean callInsert = false;
    private Object appObject;
    private int initCounter;
    private int iCounter;
    private int uCounter;
    private String timeColumn;
    public static int YEAR = 0;
    public static int MONTH = 1;
    public static int WEEK = 2;
    public static int DAY = 3;
    public static int HOUR = 4;

    public ConsoleTable(String dbtype, int counter) {
        this.dbtype = dbtype;
        this.initCounter = counter;
        this.uCounter = -1;
        this.iCounter = -1;
    }

    public void setReflection(Object self, Method insert, Method update) {
        this.appObject = self;
        this.insertMethod = insert;
        this.updateMethod = update;
    }

    public ConsoleTable(Class self, Method insert, Method update, String dbtype) {
        this.appClass = self;
        this.insertMethod = insert;
        this.updateMethod = update;
        this.dbtype = dbtype;
    }

    public String toString() {
        StringBuilder strValue = new StringBuilder();
        strValue.append("TableConsole ");
        strValue.append(this.getName());
        strValue.append(" ");
        strValue.append(this.getOneRowPer());
        strValue.append(" ");
        strValue.append(this.getUpdateFrequency());
        strValue.append(" ");
        strValue.append(this.getMaxRows());
        strValue.append(" ");
        strValue.append(this.getSchema());
        strValue.append(" ");
        strValue.append(this.dbtype);
        strValue.append(" ");
        strValue.append(this.callInsert);
        return strValue.toString();
    }

    public void setName(String name) {
        this.tableName = name;
    }

    public String getName() {
        return this.tableName;
    }

    public void setTimeColumn(String tCol) {
        this.timeColumn = tCol;
    }

    public String getTimeColumn() {
        return this.timeColumn;
    }

    public void setOneRowPer(String value) {
        String lowervalue = value.toLowerCase();
        if ("year".equals(lowervalue)) {
            this.oneRowPer = YEAR;
        }
        if ("month".equals(lowervalue)) {
            this.oneRowPer = MONTH;
        }
        if ("week".equals(lowervalue)) {
            this.oneRowPer = WEEK;
        }
        if ("day".equals(lowervalue)) {
            this.oneRowPer = DAY;
        }
        if ("hour".equals(lowervalue)) {
            this.oneRowPer = HOUR;
        }
    }

    public void setOneRowPer(int value) {
        if (value >= 0 && value <= 4) {
            this.oneRowPer = value;
        }
    }

    public int getOneRowPer() {
        return this.oneRowPer;
    }

    public void setUpdateFrequency(String uf) {
        try {
            int uf1 = Integer.parseInt(uf);
            this.setUpdateFrequency(uf1);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setUpdateFrequency(int uf) {
        if (uf > 0) {
            this.updateFrequency = uf;
        }
    }

    public int getUpdateFrequency() {
        return this.updateFrequency;
    }

    public void setMaxRows(String numOfRows) {
        try {
            int nr1 = Integer.parseInt(numOfRows);
            this.setMaxRows(nr1);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setMaxRows(int numOfRows) {
        if (numOfRows > 0) {
            this.maxRows = numOfRows;
            this.hasMaxRowLimit = true;
        }
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public boolean hasMaxRows() {
        return this.hasMaxRowLimit;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getSchema() {
        return this.schema;
    }

    public void populate(Connection con, int counter) throws Exception {
        try {
            Object[] parameters = new Object[]{con, this.dbtype, this.getName(), this.getInterval()};
            if (this.getInsert()) {
                this.insertMethod.invoke(this.appObject, parameters);
            } else {
                this.updateMethod.invoke(this.appObject, parameters);
            }
        }
        catch (Exception e) {
            MConsole.logger.errorKey("MConsole_MSG_1506", "ConsoleTable.populate()", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
    }

    public Integer getInterval() {
        return 86400;
    }

    public boolean getInsert() {
        return this.callInsert;
    }

    public void setInsert(boolean callInsert) {
        this.callInsert = callInsert;
    }
}

