/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.storeevent;

import com.savvion.sbm.bizlogic.storeevent.BSControl;
import com.savvion.sbm.bizlogic.storeevent.BSDataslot;
import com.savvion.sbm.bizlogic.storeevent.BSProcess;
import com.savvion.sbm.bizlogic.storeevent.BSUtil;
import com.savvion.sbm.bizlogic.storeevent.BizLogicEventMap;
import com.savvion.sbm.util.CommonEvent;
import com.savvion.sbm.util.SBMDAOService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableLong;

public class BSWorkstepInstance
extends BSProcess {
    private static final String SQL_INSERT_WS = "INSERT INTO WORKSTEP (PROCESS_TEMPLATE_ID, PROCESS_INSTANCE_ID, WORKSTEP_NAME, TYPE, PERFORMER, GROUP_TYPE, LOOPCOUNTER, STATUS, PRIORITY, ESTIMATED_DURATION, START_TIME, DUE_DATE, INLINEBLOCK_NAME, MONITOR_STEP)VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)";
    private static final String SQL_INSERT_SKIPPEDWS = "INSERT INTO WORKSTEP (PROCESS_TEMPLATE_ID, PROCESS_INSTANCE_ID, WORKSTEP_NAME, TYPE, PERFORMER, GROUP_TYPE, LOOPCOUNTER, STATUS, PRIORITY, ESTIMATED_DURATION, START_TIME, DUE_DATE, INLINEBLOCK_NAME, MONITOR_STEP, END_TIME, DURATION)VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String SQL_CHECK_RECORD_EXISTS = "SELECT 1 FROM WORKSTEP WHERE PROCESS_INSTANCE_ID = ? AND WORKSTEP_NAME = ? AND LOOPCOUNTER = ? ";
    private static final String SQL_SELECTWS_TIMECOST_FROMWI = "SELECT SUM(WAIT_TIME), SUM(WORK_TIME), SUM(COST) FROM WORKITEM WHERE PROCESS_INSTANCE_ID = ? AND WORKSTEP_NAME = ? AND LOOPCOUNTER = ?";
    private static final String SQL_SELECT_TIMECOST_FROMWS = "SELECT WAIT_TIME, WORK_TIME, TOTAL_COST FROM WORKSTEP WHERE PROCESS_INSTANCE_ID = ? AND  WORKSTEP_NAME = ? AND LOOPCOUNTER = ?";
    private static final String SQL_UPDATEPI_TIMECOST_FROMWS = "UPDATE PROCESSINSTANCE SET WAIT_TIME = WAIT_TIME + ?, WORK_TIME = WORK_TIME + ?, TOTAL_COST = TOTAL_COST + ? WHERE PROCESS_INSTANCE_ID = ? ";
    private static final String SQL_UPDATEWS_TIMECOST = "UPDATE WORKSTEP SET WAIT_TIME = ?, WORK_TIME = ?, TOTAL_COST = ? WHERE PROCESS_INSTANCE_ID = ? AND  WORKSTEP_NAME = ? AND LOOPCOUNTER = ?";
    private static final String SQL_SELECTSWS_TIMECOST_FROMPI = "SELECT SUM(PI.WAIT_TIME), SUM(PI.WORK_TIME), SUM(PI.TOTAL_COST) FROM PROCESSINSTANCE PI , SUBPROCESSINFO SPI WHERE SPI.PARENT_PROCESS_INSTANCE_ID = ? AND SPI.PARENT_WORKSTEP_NAME = ? AND SPI.PARENT_WORKSTEP_LOOPCOUNTER = ? AND SPI.PROCESS_INSTANCE_ID = PI.PROCESS_INSTANCE_ID";
    private static final String SQL_COMPLETE_WS = "UPDATE WORKSTEP SET STATUS = ?, END_TIME = ?, DURATION = ?, PERFORMER = ? WHERE PROCESS_INSTANCE_ID = ? and WORKSTEP_NAME = ? and  LOOPCOUNTER = ? ";
    private static final String SQL_COMPLETE_MONITORWS = "UPDATE WORKSTEP SET STATUS = ?, END_TIME = ?, DURATION = ?, PERFORMER = ?, START_TIME = ? WHERE PROCESS_INSTANCE_ID = ? and WORKSTEP_NAME = ? and  LOOPCOUNTER = ? ";
    private static final String SQL_UPDATE_WSD = "UPDATE WORKSTEP SET DUE_DATE = ? WHERE PROCESS_INSTANCE_ID = ? and WORKSTEP_NAME = ? and  LOOPCOUNTER = ?  ";
    private static final String SQL_UPDATE_WSP = "UPDATE WORKSTEP SET PRIORITY = ? WHERE PROCESS_INSTANCE_ID = ? and WORKSTEP_NAME = ? and  LOOPCOUNTER = ?  ";
    private static final String SQL_UPDATE_WSPERF = "UPDATE WORKSTEP SET PERFORMER = ? WHERE PROCESS_INSTANCE_ID = ? and WORKSTEP_NAME = ? and  LOOPCOUNTER = ?  ";
    private static final String SQL_UPDATE_WS = "UPDATE WORKSTEP SET PERFORMER = ?, GROUP_TYPE = ?, LOOPCOUNTER = ?, STATUS = ?, PRIORITY = ?, ESTIMATED_DURATION = ?, START_TIME = ?, DUE_DATE = ? WHERE PROCESS_INSTANCE_ID = ? and WORKSTEP_NAME = ? and  LOOPCOUNTER = ?  ";
    private static final String SQL_UPDATE_ACTIVATEDWS = "UPDATE WORKSTEP SET STATUS = ?, START_TIME = ?, PERFORMER = ?, DUE_DATE = ? WHERE PROCESS_INSTANCE_ID = ? and WORKSTEP_NAME = ? and  LOOPCOUNTER = ? ";
    private static final String SQL_UPDATE_WSSTATUS = "UPDATE WORKSTEP SET STATUS = ? WHERE PROCESS_INSTANCE_ID = ? and WORKSTEP_NAME = ? and  LOOPCOUNTER = ? ";
    private static final String BIZ_STORE_MSG_1501 = "BizStore_MSG_1501";
    private static final String W_PRIORITYSET = "W_PRIORITYSET";
    private static final String W_PERFORMERSET = "W_PERFORMERSET";
    private static final String W_DUEDATESET = "W_DUEDATESET";

    protected static void onActivation(CommonEvent event) throws SQLException {
        if (!BizLogicEventMap.isMonitorStep(event) && !BSWorkstepInstance.isExistRecord(event)) {
            BSWorkstepInstance.insertRecord(event);
            return;
        }
        long iid = BizLogicEventMap.getProcessInstanceID(event);
        String workstepname = BizLogicEventMap.getWorkstepName(event);
        int loopcounter = BizLogicEventMap.getLoopcounter(event);
        String status = BizLogicEventMap.getStatusString(event);
        String str = BizLogicEventMap.getStartTime(event);
        Timestamp startTime = BSUtil.stringToTimestamp(str);
        String performer = BizLogicEventMap.getPerformerValue(event);
        if (performer != null && performer.length() > 255) {
            performer = BizLogicEventMap.getPerformer(event);
        }
        String dDate = BizLogicEventMap.getDueDate(event);
        Timestamp duedate = BSUtil.stringToTimestamp(dDate);
        Connection conn = null;
        PreparedStatement stmtUpdateWSS = null;
        try {
            conn = BSControl.util.getBSConnection();
            stmtUpdateWSS = conn.prepareStatement(SQL_UPDATE_ACTIVATEDWS);
            BSUtil.setValue(stmtUpdateWSS, 1, status);
            BSUtil.setValue(stmtUpdateWSS, 91, 2, startTime);
            BSUtil.setValue(stmtUpdateWSS, 3, performer);
            BSUtil.setValue(stmtUpdateWSS, 91, 4, duedate);
            stmtUpdateWSS.setLong(5, iid);
            stmtUpdateWSS.setString(6, workstepname);
            stmtUpdateWSS.setInt(7, loopcounter);
            stmtUpdateWSS.executeUpdate();
        }
        catch (SQLException se) {
            try {
                BSControl.logger.errorKey(BIZ_STORE_MSG_1501, new Object[]{SQL_UPDATE_ACTIVATEDWS, se.getMessage()});
                throw se;
            }
            catch (Throwable throwable) {
                SBMDAOService.clean(null, stmtUpdateWSS, (Connection)conn);
                throw throwable;
            }
        }
        SBMDAOService.clean(null, (Statement)stmtUpdateWSS, (Connection)conn);
    }

    protected static void onSkip(CommonEvent event) throws SQLException {
        if (BSWorkstepInstance.isExistRecord(event)) {
            BSWorkstepInstance.onCompleteTerminateSkip(event);
        } else {
            BSWorkstepInstance.insertRecord(event);
            BSWorkstepInstance.storeDSValues(event);
        }
    }

    protected static void onActivationAndPreConditionWait(CommonEvent event) throws SQLException {
        if (!BSWorkstepInstance.isExistRecord(event)) {
            BSWorkstepInstance.insertRecord(event);
            return;
        }
        long iid = BizLogicEventMap.getProcessInstanceID(event);
        String workstepname = BizLogicEventMap.getWorkstepName(event);
        int loopcounter = BizLogicEventMap.getLoopcounter(event);
        String status = BizLogicEventMap.getStatusString(event);
        Connection conn = null;
        PreparedStatement stmtUpdateWSS = null;
        try {
            conn = BSControl.util.getBSConnection();
            stmtUpdateWSS = conn.prepareStatement(SQL_UPDATE_WSSTATUS);
            BSUtil.setValue(stmtUpdateWSS, 1, status);
            stmtUpdateWSS.setLong(2, iid);
            stmtUpdateWSS.setString(3, workstepname);
            stmtUpdateWSS.setInt(4, loopcounter);
            stmtUpdateWSS.executeUpdate();
        }
        catch (SQLException se) {
            try {
                BSControl.logger.errorKey(BIZ_STORE_MSG_1501, new Object[]{SQL_UPDATE_WSSTATUS, se.getMessage()});
                throw se;
            }
            catch (Throwable throwable) {
                SBMDAOService.clean(null, stmtUpdateWSS, (Connection)conn);
                throw throwable;
            }
        }
        SBMDAOService.clean(null, (Statement)stmtUpdateWSS, (Connection)conn);
    }

    private static void insertRecord(CommonEvent event) throws SQLException {
        String dDate;
        long duedate;
        int eventType = BizLogicEventMap.getType(event);
        long ptid = BizLogicEventMap.getProcessTemplateID(event);
        long iid = BizLogicEventMap.getProcessInstanceID(event);
        String workstepname = BizLogicEventMap.getWorkstepName(event);
        String type = BizLogicEventMap.getWorkstepType(event);
        String performer = BizLogicEventMap.getPerformerValue(event);
        if (performer != null && performer.length() > 255) {
            performer = BizLogicEventMap.getPerformer(event);
        }
        String grouptype = BizLogicEventMap.getGroupType(event);
        int loopcounter = BizLogicEventMap.getLoopcounter(event);
        String status = BizLogicEventMap.getStatusString(event);
        String priority = BizLogicEventMap.getPriority(event);
        String strEstimatedDuration = BizLogicEventMap.getEstimatedDuration(event);
        long estimatedDuration = BSUtil.stringToLong(strEstimatedDuration);
        String inlineBlockName = BizLogicEventMap.getInlineBlockName(event);
        String str = BizLogicEventMap.getStartTime(event);
        Timestamp st = BSUtil.stringToTimestamp(str);
        str = BizLogicEventMap.getDueDate(event);
        Timestamp dueDate = BSUtil.stringToTimestamp(str);
        int isMonitorStep = BizLogicEventMap.isMonitorStep(event) ? 1 : 0;
        long duration = 0L;
        Timestamp et = null;
        if (eventType == 27) {
            String strDuration = BizLogicEventMap.getDuration(event);
            duration = BSUtil.stringToLong(strDuration);
            String strEndTime = BizLogicEventMap.getEndTime(event);
            et = BSUtil.stringToTimestamp(strEndTime);
        }
        if (estimatedDuration <= 0L && (duedate = BSUtil.stringToLong(dDate = BizLogicEventMap.getDueDate(event))) > 0L && st != null) {
            estimatedDuration = (duedate - st.getTime()) / 1000L;
        }
        String sql = null;
        sql = eventType == 27 ? SQL_INSERT_SKIPPEDWS : SQL_INSERT_WS;
        Connection conn = null;
        PreparedStatement pstmtInsertWS = null;
        try {
            conn = BSControl.util.getBSConnection();
            pstmtInsertWS = conn.prepareStatement(sql);
            pstmtInsertWS.setLong(1, ptid);
            pstmtInsertWS.setLong(2, iid);
            BSUtil.setValue(pstmtInsertWS, 3, workstepname);
            BSUtil.setValue(pstmtInsertWS, 4, type);
            BSUtil.setValue(pstmtInsertWS, 5, performer);
            BSUtil.setValue(pstmtInsertWS, 6, grouptype);
            pstmtInsertWS.setInt(7, loopcounter);
            BSUtil.setValue(pstmtInsertWS, 8, status);
            BSUtil.setValue(pstmtInsertWS, 9, priority);
            pstmtInsertWS.setLong(10, estimatedDuration);
            BSUtil.setValue(pstmtInsertWS, 91, 11, st);
            BSUtil.setValue(pstmtInsertWS, 91, 12, dueDate);
            BSUtil.setValue(pstmtInsertWS, 13, inlineBlockName);
            pstmtInsertWS.setInt(14, isMonitorStep);
            if (eventType == 27) {
                BSUtil.setValue(pstmtInsertWS, 91, 15, et);
                pstmtInsertWS.setLong(16, duration);
            }
            pstmtInsertWS.executeUpdate();
        }
        catch (SQLException se) {
            try {
                BSControl.logger.errorKey(BIZ_STORE_MSG_1501, new Object[]{sql, se.getMessage()});
                throw se;
            }
            catch (Throwable throwable) {
                SBMDAOService.clean(null, pstmtInsertWS, (Connection)conn);
                throw throwable;
            }
        }
        SBMDAOService.clean(null, (Statement)pstmtInsertWS, (Connection)conn);
    }

    private static boolean isExistRecord(CommonEvent event) {
        long piid = BizLogicEventMap.getProcessInstanceID(event);
        String wsName = BizLogicEventMap.getWorkstepName(event);
        int loopCounter = BizLogicEventMap.getLoopcounter(event);
        return BSWorkstepInstance.isExistRecord(piid, wsName, loopCounter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isExistRecord(long iid, String wsName, int loopCounter) {
        PreparedStatement stmtCheckRecordExists;
        ResultSet rs;
        Connection conn;
        block4: {
            boolean bl;
            conn = null;
            rs = null;
            stmtCheckRecordExists = null;
            try {
                conn = BSControl.util.getBSConnection();
                stmtCheckRecordExists = conn.prepareStatement(SQL_CHECK_RECORD_EXISTS);
                stmtCheckRecordExists.setLong(1, iid);
                stmtCheckRecordExists.setString(2, wsName);
                stmtCheckRecordExists.setInt(3, loopCounter);
                boolean retSus = stmtCheckRecordExists.execute();
                if (!retSus || !(rs = stmtCheckRecordExists.getResultSet()).next()) break block4;
                bl = true;
            }
            catch (SQLException se) {
                try {
                    BSControl.logger.errorKey(BIZ_STORE_MSG_1501, new Object[]{SQL_CHECK_RECORD_EXISTS, se.getMessage()});
                }
                catch (Throwable throwable) {
                    SBMDAOService.clean(rs, stmtCheckRecordExists, (Connection)conn);
                    throw throwable;
                }
                SBMDAOService.clean(rs, (Statement)stmtCheckRecordExists, (Connection)conn);
            }
            SBMDAOService.clean((ResultSet)rs, (Statement)stmtCheckRecordExists, (Connection)conn);
            return bl;
        }
        SBMDAOService.clean((ResultSet)rs, (Statement)stmtCheckRecordExists, (Connection)conn);
        return false;
    }

    protected static void onUpdate(CommonEvent event) throws SQLException {
        block35: {
            try (Connection conn = BSControl.util.getBSConnection();){
                long iid = BizLogicEventMap.getProcessInstanceID(event);
                if (iid == -1L) {
                    return;
                }
                String workStepName = BizLogicEventMap.getWorkstepName(event);
                String performer = BSWorkstepInstance.getPerformer(event);
                int loopCounter = BizLogicEventMap.getLoopcounter(event);
                String status = BizLogicEventMap.getStatusString(event);
                String priority = BizLogicEventMap.getPriority(event);
                String startTime = BizLogicEventMap.getStartTime(event);
                boolean ignoreWDueDateSet = false;
                if (startTime.trim().compareTo("0") == 0) {
                    ignoreWDueDateSet = true;
                }
                if (W_PRIORITYSET.equals(status)) {
                    BSWorkstepInstance.executePrioritySetUpdateWs(conn, iid, workStepName, loopCounter, priority);
                    break block35;
                }
                if (W_PERFORMERSET.equals(status)) {
                    BSWorkstepInstance.executePerformerSetUpdateWs(conn, iid, workStepName, performer, loopCounter);
                    break block35;
                }
                if (W_DUEDATESET.equals(status)) {
                    if (!ignoreWDueDateSet) {
                        BSWorkstepInstance.executeDueDateUpdateWs(event, conn, iid, workStepName, loopCounter);
                    }
                    break block35;
                }
                String groupType = BizLogicEventMap.getGroupType(event);
                Timestamp startTimeStamp = BSUtil.stringToTimestamp(startTime);
                startTime = BizLogicEventMap.getDueDate(event);
                Timestamp dueDate = BSUtil.stringToTimestamp(startTime);
                try (PreparedStatement stmtUpdateWS = conn.prepareStatement(SQL_UPDATE_WS);){
                    BSUtil.setValue(stmtUpdateWS, 1, performer);
                    BSUtil.setValue(stmtUpdateWS, 2, groupType);
                    stmtUpdateWS.setInt(3, loopCounter);
                    BSUtil.setValue(stmtUpdateWS, 4, status);
                    BSUtil.setValue(stmtUpdateWS, 5, priority);
                    String estDurationStr = BizLogicEventMap.getEstimatedDuration(event);
                    long estimatedDuration = BSUtil.stringToLong(estDurationStr);
                    stmtUpdateWS.setLong(6, estimatedDuration);
                    BSUtil.setValue(stmtUpdateWS, 91, 7, startTimeStamp);
                    BSUtil.setValue(stmtUpdateWS, 91, 8, dueDate);
                    stmtUpdateWS.setLong(9, iid);
                    stmtUpdateWS.setString(10, workStepName);
                    stmtUpdateWS.setInt(11, loopCounter);
                    stmtUpdateWS.executeUpdate();
                }
                catch (SQLException se) {
                    BSControl.logger.errorKey(BIZ_STORE_MSG_1501, new Object[]{SQL_UPDATE_WS}, (Throwable)se);
                    throw se;
                }
            }
        }
    }

    private static String getPerformer(CommonEvent event) {
        String performer = BizLogicEventMap.getPerformerValue(event);
        if (performer != null && performer.length() > 255) {
            performer = BizLogicEventMap.getPerformer(event);
        }
        return performer;
    }

    private static void executeDueDateUpdateWs(CommonEvent event, Connection conn, long iid, String workStepName, int loopCounter) throws SQLException {
        String startTime = BizLogicEventMap.getDueDate(event);
        Timestamp dueDate = BSUtil.stringToTimestamp(startTime);
        try (PreparedStatement stmtUpdateWSD = conn.prepareStatement(SQL_UPDATE_WSD);){
            stmtUpdateWSD.setTimestamp(1, dueDate);
            stmtUpdateWSD.setLong(2, iid);
            stmtUpdateWSD.setString(3, workStepName);
            stmtUpdateWSD.setInt(4, loopCounter);
            stmtUpdateWSD.executeUpdate();
        }
        catch (SQLException se) {
            BSControl.logger.errorKey(BIZ_STORE_MSG_1501, new Object[]{SQL_UPDATE_WSD}, (Throwable)se);
            throw se;
        }
    }

    private static void executePerformerSetUpdateWs(Connection conn, long iid, String workStepName, String performer, int loopCounter) throws SQLException {
        try (PreparedStatement stmtUpdateWSPerf = conn.prepareStatement(SQL_UPDATE_WSPERF);){
            BSUtil.setValue(stmtUpdateWSPerf, 1, performer);
            stmtUpdateWSPerf.setLong(2, iid);
            stmtUpdateWSPerf.setString(3, workStepName);
            stmtUpdateWSPerf.setInt(4, loopCounter);
            stmtUpdateWSPerf.executeUpdate();
        }
        catch (SQLException se) {
            BSControl.logger.errorKey(BIZ_STORE_MSG_1501, new Object[]{SQL_UPDATE_WSPERF}, (Throwable)se);
            throw se;
        }
    }

    private static void executePrioritySetUpdateWs(Connection conn, long iid, String workStepName, int loopCounter, String priority) throws SQLException {
        try (PreparedStatement stmtUpdateWSP = conn.prepareStatement(SQL_UPDATE_WSP);){
            BSUtil.setValue(stmtUpdateWSP, 1, priority);
            stmtUpdateWSP.setLong(2, iid);
            stmtUpdateWSP.setString(3, workStepName);
            stmtUpdateWSP.setInt(4, loopCounter);
            stmtUpdateWSP.executeUpdate();
        }
        catch (SQLException se) {
            BSControl.logger.errorKey(BIZ_STORE_MSG_1501, new Object[]{SQL_UPDATE_WSP}, (Throwable)se);
            throw se;
        }
    }

    protected static void onCompleteTerminateSkip(CommonEvent event) throws SQLException {
        if (BSControl.RESOURCE_USAGE) {
            long piid = BizLogicEventMap.getProcessInstanceID(event);
            String wsName = BizLogicEventMap.getWorkstepName(event);
            int loopCounter = BizLogicEventMap.getLoopcounter(event);
            long startTime = BSUtil.stringToLong(BizLogicEventMap.getStartTime(event));
            long endTime = BSUtil.stringToLong(BizLogicEventMap.getEndTime(event));
            String wstype = (String)event.getContext().get("TYPE");
            MutableLong waitTime = new MutableLong(0L);
            MutableLong workTime = new MutableLong(0L);
            MutableDouble cost = new MutableDouble(0.0);
            long readTime = BizLogicEventMap.getReadTime(event);
            if (readTime != 0L) {
                waitTime.setValue(readTime - startTime);
                workTime.setValue(endTime - readTime);
            } else if ("ATOMIC".equals(wstype)) {
                BSWorkstepInstance.getTimeCostFromWI(piid, wsName, loopCounter, waitTime, workTime, cost);
            } else if ("NESTED".equals(wstype)) {
                BSWorkstepInstance.getTimeCostFromPI(piid, wsName, loopCounter, waitTime, workTime, cost);
            } else {
                workTime.setValue(endTime - startTime);
            }
            BSWorkstepInstance.updateWS(waitTime.longValue(), workTime.longValue(), cost.doubleValue(), piid, wsName, loopCounter);
            BSWorkstepInstance.updatePITimeCost(piid, waitTime.longValue(), workTime.longValue(), cost.doubleValue());
        } else {
            BSControl.logger.debug((Object)"BSWorkstepInstance.onCompleteTerminateSkip(): As resource usage is disabled, none of resource columns will be updated.");
        }
        BSWorkstepInstance.completeWS(event);
        if (!BizLogicEventMap.isMonitorStep(event)) {
            int eventType = BizLogicEventMap.getType(event);
            if (eventType == 24 || eventType == 27) {
                BSWorkstepInstance.storeDSValues(event);
            }
            if (eventType == 24) {
                BSWorkstepInstance.updatePriority(event);
            }
        }
    }

    private static void getTimeCostFromWI(long piid, String wsName, int loopCounter, MutableLong mlWaitTime, MutableLong mlWorkTime, MutableDouble mdCost) throws SQLException {
        Connection conn = null;
        PreparedStatement stmtSelectWSTimeCostFromWI = null;
        ResultSet rs = null;
        try {
            conn = BSControl.util.getBSConnection();
            stmtSelectWSTimeCostFromWI = conn.prepareStatement(SQL_SELECTWS_TIMECOST_FROMWI);
            stmtSelectWSTimeCostFromWI.setLong(1, piid);
            stmtSelectWSTimeCostFromWI.setString(2, wsName);
            stmtSelectWSTimeCostFromWI.setLong(3, loopCounter);
            rs = stmtSelectWSTimeCostFromWI.executeQuery();
            if (rs.next()) {
                mlWaitTime.setValue(rs.getLong(1));
                mlWorkTime.setValue(rs.getLong(2));
                mdCost.setValue(rs.getDouble(3));
            }
        }
        catch (SQLException se) {
            try {
                BSControl.logger.errorKey(BIZ_STORE_MSG_1501, new Object[]{SQL_SELECTWS_TIMECOST_FROMWI, se.getMessage()});
                throw se;
            }
            catch (Throwable throwable) {
                SBMDAOService.clean(rs, stmtSelectWSTimeCostFromWI, (Connection)conn);
                throw throwable;
            }
        }
        SBMDAOService.clean((ResultSet)rs, (Statement)stmtSelectWSTimeCostFromWI, (Connection)conn);
    }

    private static void getTimeCostFromPI(long piid, String wsName, int loopCounter, MutableLong waitTime, MutableLong workTime, MutableDouble cost) throws SQLException {
        Connection conn = null;
        PreparedStatement stmtSelectSWSTimeCostFromPI = null;
        ResultSet rsSelectSWSTimeCostFromPI = null;
        try {
            conn = BSControl.util.getBSConnection();
            stmtSelectSWSTimeCostFromPI = conn.prepareStatement(SQL_SELECTSWS_TIMECOST_FROMPI);
            stmtSelectSWSTimeCostFromPI.setLong(1, piid);
            stmtSelectSWSTimeCostFromPI.setString(2, wsName);
            stmtSelectSWSTimeCostFromPI.setLong(3, loopCounter);
            rsSelectSWSTimeCostFromPI = stmtSelectSWSTimeCostFromPI.executeQuery();
            if (rsSelectSWSTimeCostFromPI.next()) {
                waitTime.setValue(rsSelectSWSTimeCostFromPI.getLong(1));
                workTime.setValue(rsSelectSWSTimeCostFromPI.getLong(2));
                cost.setValue(rsSelectSWSTimeCostFromPI.getDouble(3));
            }
        }
        catch (SQLException se) {
            try {
                BSControl.logger.errorKey(BIZ_STORE_MSG_1501, new Object[]{SQL_SELECTSWS_TIMECOST_FROMPI, se.getMessage()});
                throw se;
            }
            catch (Throwable throwable) {
                SBMDAOService.clean(rsSelectSWSTimeCostFromPI, stmtSelectSWSTimeCostFromPI, (Connection)conn);
                throw throwable;
            }
        }
        SBMDAOService.clean((ResultSet)rsSelectSWSTimeCostFromPI, (Statement)stmtSelectSWSTimeCostFromPI, (Connection)conn);
    }

    private static void updateWS(long waitTime, long workTime, double cost, long piId, String workstepName, int loopCounter) throws SQLException {
        Connection conn = null;
        PreparedStatement stmtUpdateWSTimeCost = null;
        try {
            conn = BSControl.util.getBSConnection();
            stmtUpdateWSTimeCost = conn.prepareStatement(SQL_UPDATEWS_TIMECOST);
            stmtUpdateWSTimeCost.setLong(1, waitTime);
            stmtUpdateWSTimeCost.setLong(2, workTime);
            stmtUpdateWSTimeCost.setDouble(3, cost);
            stmtUpdateWSTimeCost.setLong(4, piId);
            stmtUpdateWSTimeCost.setString(5, workstepName);
            stmtUpdateWSTimeCost.setLong(6, loopCounter);
            stmtUpdateWSTimeCost.executeUpdate();
        }
        catch (SQLException se) {
            try {
                BSControl.logger.errorKey(BIZ_STORE_MSG_1501, new Object[]{SQL_UPDATEWS_TIMECOST, se.getMessage()});
                throw se;
            }
            catch (Throwable throwable) {
                SBMDAOService.clean(null, stmtUpdateWSTimeCost, (Connection)conn);
                throw throwable;
            }
        }
        SBMDAOService.clean(null, (Statement)stmtUpdateWSTimeCost, (Connection)conn);
    }

    private static void updatePITimeCost(long piid, long waitTime, long workTime, double cost) throws SQLException {
        Connection conn = null;
        PreparedStatement stmtUpdatePITimeCostFromWS = null;
        try {
            conn = BSControl.util.getBSConnection();
            stmtUpdatePITimeCostFromWS = conn.prepareStatement(SQL_UPDATEPI_TIMECOST_FROMWS);
            stmtUpdatePITimeCostFromWS.setLong(1, waitTime);
            stmtUpdatePITimeCostFromWS.setLong(2, workTime);
            stmtUpdatePITimeCostFromWS.setDouble(3, cost);
            stmtUpdatePITimeCostFromWS.setLong(4, piid);
            stmtUpdatePITimeCostFromWS.executeUpdate();
        }
        catch (SQLException se) {
            try {
                BSControl.logger.errorKey(BIZ_STORE_MSG_1501, new Object[]{SQL_UPDATEPI_TIMECOST_FROMWS, se.getMessage()});
                throw se;
            }
            catch (Throwable throwable) {
                SBMDAOService.clean(null, stmtUpdatePITimeCostFromWS, (Connection)conn);
                throw throwable;
            }
        }
        SBMDAOService.clean(null, (Statement)stmtUpdatePITimeCostFromWS, (Connection)conn);
    }

    private static void completeWS(CommonEvent event) throws SQLException {
        long piid = BizLogicEventMap.getProcessInstanceID(event);
        String workstepname = BizLogicEventMap.getWorkstepName(event);
        int loopCounter = BizLogicEventMap.getLoopcounter(event);
        String status = BizLogicEventMap.getStatusString(event);
        String str = BizLogicEventMap.getEndTime(event);
        Timestamp et = BSUtil.stringToTimestamp(str);
        str = BizLogicEventMap.getStartTime(event);
        Timestamp st = BSUtil.stringToTimestamp(str);
        boolean isMonitorStep = BizLogicEventMap.isMonitorStep(event);
        String strDuration = BizLogicEventMap.getDuration(event);
        long duration = BSUtil.stringToLong(strDuration);
        String performer = BizLogicEventMap.getPerformerValue(event);
        if (performer != null && performer.length() > 255) {
            performer = BizLogicEventMap.getPerformer(event);
        }
        Connection conn = null;
        PreparedStatement stmtUpdateWSS = null;
        String sql = null;
        try {
            conn = BSControl.util.getBSConnection();
            sql = isMonitorStep ? SQL_COMPLETE_MONITORWS : SQL_COMPLETE_WS;
            stmtUpdateWSS = conn.prepareStatement(sql);
            int stmtIndex = 1;
            BSUtil.setValue(stmtUpdateWSS, stmtIndex++, status);
            BSUtil.setValue(stmtUpdateWSS, 91, stmtIndex++, et);
            stmtUpdateWSS.setLong(stmtIndex++, duration);
            BSUtil.setValue(stmtUpdateWSS, stmtIndex++, performer);
            if (isMonitorStep) {
                BSUtil.setValue(stmtUpdateWSS, 91, stmtIndex++, st);
            }
            stmtUpdateWSS.setLong(stmtIndex++, piid);
            stmtUpdateWSS.setString(stmtIndex++, workstepname);
            stmtUpdateWSS.setInt(stmtIndex++, loopCounter);
            stmtUpdateWSS.executeUpdate();
        }
        catch (SQLException se) {
            try {
                BSControl.logger.errorKey(BIZ_STORE_MSG_1501, new Object[]{sql, se.getMessage()});
                throw se;
            }
            catch (Throwable throwable) {
                SBMDAOService.clean(null, stmtUpdateWSS, (Connection)conn);
                throw throwable;
            }
        }
        SBMDAOService.clean(null, (Statement)stmtUpdateWSS, (Connection)conn);
    }

    private static void updatePriority(CommonEvent event) throws SQLException {
        Map.Entry entry2 = null;
        Map context = event.getContext();
        for (Map.Entry entry2 : context.entrySet()) {
            String k = (String)entry2.getKey();
            if (k.startsWith("PIPR_")) {
                BSWorkstepInstance.updatePIPriority(event, entry2);
                continue;
            }
            if (!k.startsWith("WSPR_")) continue;
            BSWorkstepInstance.updateWSPriority(event, entry2);
        }
    }

    private static void updatePIPriority(CommonEvent event, Map.Entry entry) throws SQLException {
        long piid = BizLogicEventMap.getProcessInstanceID(event);
        String k = (String)entry.getKey();
        String dsn = k.substring(5);
        String pidstr = (String)entry.getValue();
        if (pidstr == null) {
            return;
        }
        String prio = (String)BizLogicEventMap.getKeyValue(event, dsn);
        Connection conn = null;
        PreparedStatement pstmtUpdatePIPriority = null;
        try {
            conn = BSControl.util.getBSConnection();
            pstmtUpdatePIPriority = conn.prepareStatement("UPDATE PROCESSINSTANCE SET PRIORITY=? WHERE PROCESS_INSTANCE_ID = ? ");
            pstmtUpdatePIPriority.setString(1, prio);
            pstmtUpdatePIPriority.setLong(2, piid);
            pstmtUpdatePIPriority.execute();
        }
        catch (SQLException se) {
            try {
                BSControl.logger.errorKey(BIZ_STORE_MSG_1501, new Object[]{"UPDATE PROCESSINSTANCE SET PRIORITY=? WHERE PROCESS_INSTANCE_ID = ? ", se.getMessage()});
                throw se;
            }
            catch (Throwable throwable) {
                SBMDAOService.clean(null, pstmtUpdatePIPriority, (Connection)conn);
                throw throwable;
            }
        }
        SBMDAOService.clean(null, (Statement)pstmtUpdatePIPriority, (Connection)conn);
    }

    private static void updateWSPriority(CommonEvent event, Map.Entry entry) throws SQLException {
        long piid = BizLogicEventMap.getProcessInstanceID(event);
        int loopcounter = BizLogicEventMap.getLoopcounter(event);
        String k = (String)entry.getKey();
        String dsn = k.substring(5);
        String wsn = (String)entry.getValue();
        if (wsn == null) {
            return;
        }
        String prio = (String)BizLogicEventMap.getKeyValue(event, dsn);
        Connection conn = null;
        PreparedStatement stmtUpdateWSP = null;
        try {
            conn = BSControl.util.getBSConnection();
            stmtUpdateWSP = conn.prepareStatement(SQL_UPDATE_WSP);
            stmtUpdateWSP.setString(1, prio);
            stmtUpdateWSP.setLong(2, piid);
            stmtUpdateWSP.setString(3, wsn);
            stmtUpdateWSP.setInt(4, loopcounter);
            stmtUpdateWSP.execute();
        }
        catch (SQLException se) {
            try {
                BSControl.logger.errorKey(BIZ_STORE_MSG_1501, new Object[]{SQL_UPDATE_WSP, se.getMessage()});
                throw se;
            }
            catch (Throwable throwable) {
                SBMDAOService.clean(null, stmtUpdateWSP, (Connection)conn);
                throw throwable;
            }
        }
        SBMDAOService.clean(null, (Statement)stmtUpdateWSP, (Connection)conn);
    }

    protected static void onSuspendAndResume(CommonEvent event) throws SQLException {
        long piid = BizLogicEventMap.getProcessInstanceID(event);
        String workstepname = BizLogicEventMap.getWorkstepName(event);
        String status = BizLogicEventMap.getStatusString(event);
        int loopcounter = BizLogicEventMap.getLoopcounter(event);
        if ("W_SUSPENDED".equals(status) && !BSWorkstepInstance.isExistRecord(piid, workstepname, loopcounter)) {
            BSWorkstepInstance.insertRecord(event);
        }
        if ("W_RESUMED".equals(status)) {
            status = "W_ACTIVATED";
        }
        Connection conn = null;
        PreparedStatement stmtUpdateWSS = null;
        try {
            conn = BSControl.util.getBSConnection();
            stmtUpdateWSS = conn.prepareStatement(SQL_UPDATE_WSSTATUS);
            BSUtil.setValue(stmtUpdateWSS, 1, status);
            stmtUpdateWSS.setLong(2, piid);
            stmtUpdateWSS.setString(3, workstepname);
            stmtUpdateWSS.setInt(4, loopcounter);
            stmtUpdateWSS.executeUpdate();
        }
        catch (SQLException se) {
            try {
                BSControl.logger.errorKey(BIZ_STORE_MSG_1501, new Object[]{SQL_UPDATE_WSSTATUS, se.getMessage()});
                throw se;
            }
            catch (Throwable throwable) {
                SBMDAOService.clean(null, stmtUpdateWSS, (Connection)conn);
                throw throwable;
            }
        }
        SBMDAOService.clean(null, (Statement)stmtUpdateWSS, (Connection)conn);
    }

    private static void storeDSValues(CommonEvent event) throws SQLException {
        long ptid = BizLogicEventMap.getProcessTemplateID(event);
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Integer> types = new ArrayList<Integer>();
        ArrayList<Object> values = new ArrayList<Object>();
        ArrayList<String> globalnames = new ArrayList<String>();
        ArrayList<Integer> globaltypes = new ArrayList<Integer>();
        ArrayList<Object> globalvalues = new ArrayList<Object>();
        Hashtable dsMetadata = ptCache.getDSData(ptid);
        if (dsMetadata != null) {
            for (String name : dsMetadata.keySet()) {
                if (!BizLogicEventMap.hasDataslotValue(event, name)) continue;
                Integer type = (Integer)dsMetadata.get(name);
                Object o = BizLogicEventMap.getDataslotValue(event, name);
                boolean isGlobal = BizLogicEventMap.isGlobalDS(event, name);
                if (isGlobal) {
                    globalnames.add(name);
                    globaltypes.add(type);
                    globalvalues.add(o);
                    continue;
                }
                names.add(name);
                types.add(type);
                values.add(o);
            }
        }
        if (!names.isEmpty()) {
            BSDataslot.updateDSTable(names, types, values, event, false);
        }
        if (!globalnames.isEmpty()) {
            BSDataslot.updateDSTable(globalnames, globaltypes, globalvalues, event, true);
        }
    }

    public static void printSQLStatements() {
        BSControl.logger.debug((Object)"BSWorkstepInstance.printSQLStatements:");
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_INSERT_WS});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_CHECK_RECORD_EXISTS});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_UPDATE_WSSTATUS});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_UPDATE_WSD});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_UPDATE_WSP});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_UPDATE_WSPERF});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_UPDATE_WS});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_SELECTWS_TIMECOST_FROMWI});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_SELECT_TIMECOST_FROMWS});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_UPDATEPI_TIMECOST_FROMWS});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_UPDATEWS_TIMECOST});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_SELECTSWS_TIMECOST_FROMPI});
    }

    protected static void onEventActivationWait(CommonEvent event) throws SQLException {
        if (!BSWorkstepInstance.wasSuspended(event)) {
            BSWorkstepInstance.insertRecord(event);
            return;
        }
        long piid = BizLogicEventMap.getProcessInstanceID(event);
        String workstepname = BizLogicEventMap.getWorkstepName(event);
        int loopcounter = BizLogicEventMap.getLoopcounter(event);
        String status = BizLogicEventMap.getStatusString(event);
        Connection conn = null;
        PreparedStatement stmtUpdateWSS = null;
        try {
            conn = BSControl.util.getBSConnection();
            stmtUpdateWSS = conn.prepareStatement(SQL_UPDATE_WSSTATUS);
            BSUtil.setValue(stmtUpdateWSS, 1, status);
            stmtUpdateWSS.setLong(2, piid);
            stmtUpdateWSS.setString(3, workstepname);
            stmtUpdateWSS.setInt(4, loopcounter);
            stmtUpdateWSS.executeUpdate();
        }
        catch (SQLException se) {
            try {
                BSControl.logger.errorKey(BIZ_STORE_MSG_1501, new Object[]{SQL_UPDATE_WSSTATUS, se.getMessage()});
                throw se;
            }
            catch (Throwable throwable) {
                SBMDAOService.clean(null, stmtUpdateWSS, (Connection)conn);
                throw throwable;
            }
        }
        SBMDAOService.clean(null, (Statement)stmtUpdateWSS, (Connection)conn);
    }

    private static boolean wasSuspended(CommonEvent event) {
        return "W_SUSPENDED".equalsIgnoreCase(BizLogicEventMap.getPreviousStatus(event));
    }
}

