/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.storeevent;

import com.savvion.sbm.bizlogic.storeevent.BSControl;
import com.savvion.sbm.bizlogic.storeevent.BSDataslot;
import com.savvion.sbm.bizlogic.storeevent.BSProcess;
import com.savvion.sbm.bizlogic.storeevent.BSUtil;
import com.savvion.sbm.bizlogic.storeevent.BizLogicEventMap;
import com.savvion.sbm.bizlogic.storeevent.BizStoreException;
import com.savvion.sbm.util.CommonEvent;
import com.savvion.sbm.util.SBMDAOService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;

public class BSProcessInstance
extends BSProcess {
    private static final String SQL_INSERT_PI = "INSERT INTO PROCESSINSTANCE (PROCESS_TEMPLATE_ID, PROCESS_INSTANCE_ID, PROCESS_INSTANCE_NAME, RPID, CREATOR, STATUS, PRIORITY, SUBPROCESS_TYPE, ESTIMATED_DURATION, START_TIME, DUE_DATE)VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String SQL_UPDATE_PIS = "UPDATE PROCESSINSTANCE SET STATUS=? WHERE PROCESS_INSTANCE_ID = ? ";
    private static final String SQL_COMPLETE_PI = "UPDATE PROCESSINSTANCE SET STATUS=?, END_TIME=?, DURATION=? WHERE PROCESS_INSTANCE_ID = ? ";
    private static final String SQL_UPDATE_PID = "UPDATE PROCESSINSTANCE SET DUE_DATE=? WHERE PROCESS_INSTANCE_ID = ? ";
    private static final String SQL_UPDATE_PI = "UPDATE PROCESSINSTANCE SET CREATOR=?, STATUS=?, PRIORITY=?, ESTIMATED_DURATION=?, START_TIME=?, DUE_DATE=? WHERE PROCESS_INSTANCE_ID = ? ";
    private static final String SQL_INSERT_SPI = "INSERT INTO SUBPROCESSINFO (PROCESS_TEMPLATE_ID, PROCESS_TEMPLATE_NAME, PROCESS_INSTANCE_ID, PARENT_PROCESS_INSTANCE_ID, PARENT_PROCESS_INSTANCE_NAME, PARENT_WORKSTEP_NAME, PARENT_WORKSTEP_LOOPCOUNTER) VALUES (?, ?, ?, ?, ?, ?, ?)";
    private static final String SQL_UPDATE_PIC = "UPDATE PROCESSINSTANCE SET CREATOR=? WHERE PROCESS_INSTANCE_ID = ? ";

    protected static void onCreate(CommonEvent event) throws SQLException {
        BSProcessInstance.insertProcessInstance(event);
        BSProcessInstance.storeDSValues(event);
    }

    protected static void onStatusChange(CommonEvent event) throws SQLException {
        long piid = BizLogicEventMap.getProcessInstanceID(event);
        String status = BizLogicEventMap.getStatusString(event);
        if ("PI_RESUMED".equals(status)) {
            status = "PI_ACTIVATED";
        }
        Connection conn = null;
        PreparedStatement pstmtUpdatePIStatus = null;
        try {
            conn = BSControl.util.getBSConnection();
            pstmtUpdatePIStatus = conn.prepareStatement(SQL_UPDATE_PIS);
            BSUtil.setValue(pstmtUpdatePIStatus, 1, status);
            pstmtUpdatePIStatus.setLong(2, piid);
            pstmtUpdatePIStatus.executeUpdate();
        }
        catch (SQLException se) {
            try {
                BSControl.logger.errorKey("BizStore_MSG_1501", new Object[]{SQL_UPDATE_PIS, se.getMessage()});
                throw se;
            }
            catch (Throwable throwable) {
                SBMDAOService.clean(null, pstmtUpdatePIStatus, (Connection)conn);
                throw throwable;
            }
        }
        SBMDAOService.clean(null, (Statement)pstmtUpdatePIStatus, (Connection)conn);
    }

    protected static void onComplete(CommonEvent event) throws SQLException {
        long piid = BizLogicEventMap.getProcessInstanceID(event);
        String strDuration = BizLogicEventMap.getDuration(event);
        long duration = BSUtil.stringToLong(strDuration);
        String status = BizLogicEventMap.getStatusString(event);
        String str = null;
        str = BizLogicEventMap.getEndTime(event);
        Timestamp et = BSUtil.stringToTimestamp(str);
        Connection conn = null;
        PreparedStatement pstmtCompletePI = null;
        try {
            conn = BSControl.util.getBSConnection();
            pstmtCompletePI = conn.prepareStatement(SQL_COMPLETE_PI);
            BSUtil.setValue(pstmtCompletePI, 1, status);
            BSUtil.setValue(pstmtCompletePI, 91, 2, et);
            pstmtCompletePI.setLong(3, duration);
            pstmtCompletePI.setLong(4, piid);
            pstmtCompletePI.executeUpdate();
        }
        catch (SQLException se) {
            try {
                BSControl.logger.errorKey("BizStore_MSG_1501", new Object[]{SQL_COMPLETE_PI, se.getMessage()});
                throw se;
            }
            catch (Throwable throwable) {
                SBMDAOService.clean(null, pstmtCompletePI, (Connection)conn);
                throw throwable;
            }
        }
        SBMDAOService.clean(null, (Statement)pstmtCompletePI, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void onActivate(CommonEvent event, int evtype) throws SQLException {
        block14: {
            Connection conn = null;
            long ptid = BizLogicEventMap.getProcessTemplateID(event);
            String ptName = BizLogicEventMap.getProcessTemplateName(event);
            long piid = BizLogicEventMap.getProcessInstanceID(event);
            String strEstimatedDuration = BizLogicEventMap.getEstimatedDuration(event);
            long estimatedDuration = BSUtil.stringToLong(strEstimatedDuration);
            String creator = BizLogicEventMap.getCreator(event);
            String status = BizLogicEventMap.getStatusString(event);
            String priority = BizLogicEventMap.getPriority(event);
            String str = BizLogicEventMap.getStartTime(event);
            Timestamp st = BSUtil.stringToTimestamp(str);
            str = BizLogicEventMap.getDueDate(event);
            Timestamp dueDate = BSUtil.stringToTimestamp(str);
            try {
                conn = BSControl.util.getBSConnection();
                PreparedStatement pstmtActivatePI = null;
                try {
                    pstmtActivatePI = conn.prepareStatement(SQL_UPDATE_PI);
                    BSUtil.setValue(pstmtActivatePI, 1, creator);
                    BSUtil.setValue(pstmtActivatePI, 2, status);
                    BSUtil.setValue(pstmtActivatePI, 3, priority);
                    pstmtActivatePI.setLong(4, estimatedDuration);
                    BSUtil.setValue(pstmtActivatePI, 91, 5, st);
                    BSUtil.setValue(pstmtActivatePI, 91, 6, dueDate);
                    pstmtActivatePI.setLong(7, piid);
                    pstmtActivatePI.executeUpdate();
                }
                catch (SQLException se) {
                    BSControl.logger.errorKey("BizStore_MSG_1501", new Object[]{SQL_UPDATE_PI, se.getMessage()});
                    throw se;
                }
                finally {
                    SBMDAOService.clean(null, (Statement)pstmtActivatePI, null);
                }
                String pwsn = BizLogicEventMap.getParentWorkstepName(event);
                int wsLoopCounter = BizLogicEventMap.getLoopcounter(event);
                if (evtype != 11 || pwsn == null) break block14;
                long ppiid = BizLogicEventMap.getParentProcessInstanceID(event);
                String ppiName = BizLogicEventMap.getParentProcessInstanceName(event);
                PreparedStatement stmtInsertSPI = null;
                try {
                    stmtInsertSPI = conn.prepareStatement(SQL_INSERT_SPI);
                    stmtInsertSPI.setLong(1, ptid);
                    stmtInsertSPI.setString(2, ptName);
                    stmtInsertSPI.setLong(3, piid);
                    stmtInsertSPI.setLong(4, ppiid);
                    stmtInsertSPI.setString(5, ppiName);
                    stmtInsertSPI.setString(6, pwsn);
                    stmtInsertSPI.setInt(7, wsLoopCounter);
                    stmtInsertSPI.executeUpdate();
                }
                catch (SQLException se) {
                    BSControl.logger.errorKey("BizStore_MSG_1501", new Object[]{SQL_INSERT_SPI, se.getMessage()});
                    throw se;
                }
                finally {
                    SBMDAOService.clean(null, (Statement)stmtInsertSPI, null);
                }
            }
            finally {
                SBMDAOService.clean(null, null, (Connection)conn);
            }
        }
    }

    protected static void onUpdate(CommonEvent event, int evtype) throws SQLException {
        block23: {
            Connection conn = null;
            try {
                conn = BSControl.util.getBSConnection();
                long iid = BizLogicEventMap.getProcessInstanceID(event);
                String creator = BizLogicEventMap.getCreator(event);
                String status = BizLogicEventMap.getStatusString(event);
                String priority = BizLogicEventMap.getPriority(event);
                String str = BizLogicEventMap.getDueDate(event);
                Timestamp et = BSUtil.stringToTimestamp(str);
                if ("PI_PRIORITYSET".equals(status)) {
                    PreparedStatement pstmtUpdatePIPriority = null;
                    try {
                        pstmtUpdatePIPriority = conn.prepareStatement("UPDATE PROCESSINSTANCE SET PRIORITY=? WHERE PROCESS_INSTANCE_ID = ? ");
                        BSUtil.setValue(pstmtUpdatePIPriority, 1, priority);
                        pstmtUpdatePIPriority.setLong(2, iid);
                        pstmtUpdatePIPriority.executeUpdate();
                        break block23;
                    }
                    catch (SQLException se) {
                        BSControl.logger.errorKey("BizStore_MSG_1501", new Object[]{"UPDATE PROCESSINSTANCE SET PRIORITY=? WHERE PROCESS_INSTANCE_ID = ? ", se.getMessage()});
                        throw se;
                    }
                    finally {
                        SBMDAOService.clean(null, (Statement)pstmtUpdatePIPriority, null);
                    }
                }
                if ("PI_DUEDATESET".equals(status)) {
                    PreparedStatement stmtUpdatePID = null;
                    try {
                        stmtUpdatePID = conn.prepareStatement(SQL_UPDATE_PID);
                        stmtUpdatePID.setTimestamp(1, et);
                        stmtUpdatePID.setLong(2, iid);
                        stmtUpdatePID.executeUpdate();
                        break block23;
                    }
                    catch (SQLException se) {
                        BSControl.logger.errorKey("BizStore_MSG_1501", new Object[]{SQL_UPDATE_PID, se.getMessage()});
                        throw se;
                    }
                    finally {
                        SBMDAOService.clean(null, (Statement)stmtUpdatePID, null);
                    }
                }
                if ("PI_CREATORSET".equals(status)) {
                    PreparedStatement stmtUpdatePIC = null;
                    try {
                        stmtUpdatePIC = conn.prepareStatement(SQL_UPDATE_PIC);
                        stmtUpdatePIC.setString(1, creator);
                        stmtUpdatePIC.setLong(2, iid);
                        stmtUpdatePIC.executeUpdate();
                        break block23;
                    }
                    catch (SQLException se) {
                        BSControl.logger.errorKey("BizStore_MSG_1501", new Object[]{SQL_UPDATE_PIC, se.getMessage()});
                        throw se;
                    }
                    finally {
                        SBMDAOService.clean(null, (Statement)stmtUpdatePIC, null);
                    }
                }
                throw new BizStoreException("BizStore_MSG_1601", "BSProcessInstance.onUpdate()", new Object[]{status, iid}, true, event.getEventID());
            }
            catch (SQLException se) {
                throw se;
            }
            finally {
                SBMDAOService.clean(null, null, (Connection)conn);
            }
        }
    }

    protected static void onAttributeSet(CommonEvent event) throws SQLException {
        Connection conn = null;
        try {
            conn = BSControl.util.getBSConnection();
            long iid = BizLogicEventMap.getProcessInstanceID(event);
            HashMap changedATTs = BizLogicEventMap.getChangedAttributesList(event);
            for (String attribute : changedATTs.keySet()) {
                if ("creator".equalsIgnoreCase(attribute)) {
                    String creator = (String)changedATTs.get(attribute);
                    PreparedStatement stmtUpdatePIC = null;
                    try {
                        stmtUpdatePIC = conn.prepareStatement(SQL_UPDATE_PIC);
                        BSUtil.setValue(stmtUpdatePIC, 1, creator);
                        stmtUpdatePIC.setLong(2, iid);
                        stmtUpdatePIC.executeUpdate();
                        continue;
                    }
                    catch (SQLException se) {
                        BSControl.logger.errorKey("BizStore_MSG_1501", new Object[]{SQL_UPDATE_PIC, se.getMessage()});
                        throw se;
                    }
                    finally {
                        SBMDAOService.clean(null, (Statement)stmtUpdatePIC, null);
                        continue;
                    }
                }
                if ("duedate".equalsIgnoreCase(attribute)) {
                    String str = BizLogicEventMap.getDueDate(event);
                    Timestamp et = BSUtil.stringToTimestamp(str);
                    PreparedStatement stmtUpdatePID = null;
                    try {
                        stmtUpdatePID = conn.prepareStatement(SQL_UPDATE_PID);
                        stmtUpdatePID.setTimestamp(1, et);
                        stmtUpdatePID.setLong(2, iid);
                        stmtUpdatePID.executeUpdate();
                        continue;
                    }
                    catch (SQLException se) {
                        BSControl.logger.errorKey("BizStore_MSG_1501", new Object[]{SQL_UPDATE_PID, se.getMessage()});
                        throw se;
                    }
                    finally {
                        SBMDAOService.clean(null, (Statement)stmtUpdatePID, null);
                        continue;
                    }
                }
                if ("priority".equalsIgnoreCase(attribute)) {
                    String priority = (String)changedATTs.get(attribute);
                    PreparedStatement pstmtUpdatePIPriority = null;
                    try {
                        pstmtUpdatePIPriority = conn.prepareStatement("UPDATE PROCESSINSTANCE SET PRIORITY=? WHERE PROCESS_INSTANCE_ID = ? ");
                        BSUtil.setValue(pstmtUpdatePIPriority, 1, priority);
                        pstmtUpdatePIPriority.setLong(2, iid);
                        pstmtUpdatePIPriority.executeUpdate();
                        continue;
                    }
                    catch (SQLException se) {
                        BSControl.logger.errorKey("BizStore_MSG_1501", new Object[]{"UPDATE PROCESSINSTANCE SET PRIORITY=? WHERE PROCESS_INSTANCE_ID = ? ", se.getMessage()});
                        throw se;
                    }
                    finally {
                        SBMDAOService.clean(null, (Statement)pstmtUpdatePIPriority, null);
                        continue;
                    }
                }
                throw new BizStoreException("BizStore_MSG_1602", "BSProcessInstance.onUpdate()", new Object[]{attribute, iid}, true, event.getEventID());
            }
        }
        catch (SQLException se) {
            throw se;
        }
        finally {
            SBMDAOService.clean(null, null, (Connection)conn);
        }
    }

    protected static void onDataslotSet(CommonEvent event) throws SQLException {
        long ptid = BizLogicEventMap.getProcessTemplateID(event);
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Integer> types = new ArrayList<Integer>();
        ArrayList values = new ArrayList();
        ArrayList<String> globalnames = new ArrayList<String>();
        ArrayList<Integer> globaltypes = new ArrayList<Integer>();
        ArrayList globalvalues = new ArrayList();
        HashMap changedDS = BizLogicEventMap.getChangedDataslotsList(event);
        for (String dataslotName : changedDS.keySet()) {
            if (!ptCache.contains(ptid, dataslotName)) continue;
            Object value = changedDS.get(dataslotName);
            boolean isGlobal = BizLogicEventMap.isGlobalDS(event, dataslotName);
            Integer dstype = ptCache.getDSType(ptid, dataslotName);
            if (isGlobal) {
                globalnames.add(dataslotName);
                globaltypes.add(dstype);
                globalvalues.add(value);
                continue;
            }
            names.add(dataslotName);
            types.add(dstype);
            values.add(value);
        }
        if (!names.isEmpty()) {
            BSDataslot.updateDSTable(names, types, values, event, false);
        }
        if (!globalnames.isEmpty()) {
            BSDataslot.updateDSTable(globalnames, globaltypes, globalvalues, event, true);
        }
    }

    private static void insertProcessInstance(CommonEvent event) throws SQLException {
        Connection conn = null;
        PreparedStatement stmtInsertPI = null;
        try {
            conn = BSControl.util.getBSConnection();
            String instanceName = BizLogicEventMap.getProcessInstanceName(event);
            long ptid = BizLogicEventMap.getProcessTemplateID(event);
            long iid = BizLogicEventMap.getProcessInstanceID(event);
            String creator = BizLogicEventMap.getCreator(event);
            String status = BizLogicEventMap.getStatusString(event);
            String priority = BizLogicEventMap.getPriority(event);
            String strEstDuration = BizLogicEventMap.getEstimatedDuration(event);
            long estimatedDuration = BSUtil.stringToLong(strEstDuration);
            String str = BizLogicEventMap.getStartTime(event);
            Timestamp st = BSUtil.stringToTimestamp(str);
            str = BizLogicEventMap.getDueDate(event);
            Timestamp dueDate = BSUtil.stringToTimestamp(str);
            long rpid = BizLogicEventMap.getRootPID(event);
            int subProcessType = BizLogicEventMap.getSubProcessType(event);
            stmtInsertPI = conn.prepareStatement(SQL_INSERT_PI);
            stmtInsertPI.setLong(1, ptid);
            stmtInsertPI.setLong(2, iid);
            stmtInsertPI.setString(3, instanceName);
            stmtInsertPI.setLong(4, rpid);
            BSUtil.setValue(stmtInsertPI, 5, creator);
            BSUtil.setValue(stmtInsertPI, 6, status);
            BSUtil.setValue(stmtInsertPI, 7, priority);
            stmtInsertPI.setInt(8, subProcessType);
            stmtInsertPI.setLong(9, estimatedDuration);
            BSUtil.setValue(stmtInsertPI, 91, 10, st);
            BSUtil.setValue(stmtInsertPI, 91, 11, dueDate);
            stmtInsertPI.executeUpdate();
        }
        catch (SQLException se) {
            try {
                BSControl.logger.errorKey("BizStore_MSG_1501", new Object[]{SQL_INSERT_PI, se.getMessage()});
                throw se;
            }
            catch (Throwable throwable) {
                SBMDAOService.clean(null, stmtInsertPI, (Connection)conn);
                throw throwable;
            }
        }
        SBMDAOService.clean(null, (Statement)stmtInsertPI, (Connection)conn);
    }

    private static void storeDSValues(CommonEvent event) throws SQLException {
        long ptid = BizLogicEventMap.getProcessTemplateID(event);
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Integer> types = new ArrayList<Integer>();
        ArrayList<Object> values = new ArrayList<Object>();
        ArrayList<String> globalnames = new ArrayList<String>();
        ArrayList<Integer> globaltypes = new ArrayList<Integer>();
        ArrayList<Object> globalvalues = new ArrayList<Object>();
        Hashtable dsMetadata = ptCache.getDSData(ptid);
        if (dsMetadata != null) {
            for (String name : dsMetadata.keySet()) {
                if (!BizLogicEventMap.hasDataslotValue(event, name)) continue;
                Integer type = (Integer)dsMetadata.get(name);
                Object o = BizLogicEventMap.getDataslotValue(event, name);
                boolean isGlobal = BizLogicEventMap.isGlobalDS(event, name);
                if (isGlobal) {
                    globalnames.add(name);
                    globaltypes.add(type);
                    globalvalues.add(o);
                    continue;
                }
                names.add(name);
                types.add(type);
                values.add(o);
            }
        }
        if (!names.isEmpty()) {
            BSDataslot.insertIntoDSTable(names, types, values, event, false);
        }
        if (!globalnames.isEmpty()) {
            BSDataslot.updateDSTable(globalnames, globaltypes, globalvalues, event, true);
        }
    }

    public static void printSQLStatements() {
        BSControl.logger.debug((Object)"BSProcessInstance.printSQLStatements:");
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_INSERT_PI});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_UPDATE_PIS});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_UPDATE_PID});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_UPDATE_PI});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_INSERT_SPI});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_UPDATE_PIC});
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_COMPLETE_PI});
    }
}

