/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.storeevent;

import com.savvion.sbm.bizlogic.enums.DSAttribute;
import com.savvion.sbm.bizlogic.server.ejb.ServiceLocal;
import com.savvion.sbm.bizlogic.server.ejb.ServiceLocalHome;
import com.savvion.sbm.bizlogic.storeevent.BSControl;
import com.savvion.sbm.bizlogic.storeevent.BSProcess;
import com.savvion.sbm.bizlogic.storeevent.BSProcessTemplate;
import com.savvion.sbm.bizlogic.storeevent.BSUtil;
import com.savvion.sbm.bizlogic.storeevent.BizLogicEventMap;
import com.savvion.sbm.bizlogic.storeevent.BizStoreException;
import com.savvion.sbm.bizlogic.util.DBConstants;
import com.savvion.sbm.util.CommonEvent;
import com.savvion.sbm.util.DBService;
import com.savvion.sbm.util.SBMControl;
import com.savvion.sbm.util.SBMDAOService;
import com.savvion.sbm.util.SBMDatabase;
import com.savvion.sbm.util.SBMHomeFactory;
import com.savvion.sbm.util.SBMUtil;
import com.savvion.sbm.util.ServiceLocator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class BSDataslot
extends BSProcess {
    private static final String SQL_INSERT_PDI = "INSERT INTO PROCESSDATAINFO (PROCESS_TEMPLATE_ID, DATASLOT_NAME, DATASLOT_TYPE, DATASLOT_SIZE, BIZLOGIC_DATASLOT_TYPE, BIZMANAGE_ACCESS_FLAG, SCALE, GLOBAL_FLAG, LABEL, BIZSITE_ACCESS_FLAG, MONITOR_ID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final int OPERATION_DROP_TABLE = 1;
    private static final int OPERATION_CREATE_INDEX = 2;
    private static final int STATUS_EXECUTION_PENDING = 0;
    private static final String[] TABLE_NAME_PATTERN = new String[]{"BIZLOGIC_DS_", "BIZLOGIC_GLOBALDS_", "BS_"};
    private static final String TRUE_STR = "t";
    private static final String FALSE_STR = "f";
    private static final String BIZ_STORE_MSG_1501 = "BizStore_MSG_1501";
    protected static final String GLOBAL = "global";
    protected static final String INSTANCE = "instance";

    protected static void onUpdate(CommonEvent event) throws SQLException {
        String dataslotName;
        long ptid = BizLogicEventMap.getProcessTemplateID(event);
        if (ptCache.contains(ptid, dataslotName = BizLogicEventMap.getDataslotName(event))) {
            Object value = BizLogicEventMap.getDataslotValue(event);
            boolean isGlobal = BizLogicEventMap.isGlobalDS(event);
            int dstype = ptCache.getDSType(ptid, dataslotName);
            BSDataslot.updateDSTable(dataslotName, dstype, value, event, isGlobal);
        }
    }

    protected static void replaceProcessDataInfos(CommonEvent event) throws Exception {
        HashMap processData = BizLogicEventMap.getProcessData(event);
        long id = BizLogicEventMap.getProcessTemplateID(event);
        String templateName = BizLogicEventMap.getProcessTemplateName(event);
        ptCache.addPTName(id, templateName);
        DBConstants consts = DBConstants.single();
        String[] addedds = BizLogicEventMap.getAdditionalDSData(event);
        ProcessDataMeta globalProcessDataMeta = new ProcessDataMeta(TABLE_NAME_PATTERN[2] + id, 100);
        ProcessDataMeta instanceProcessData = new ProcessDataMeta(DBService.polish((String)templateName), 300);
        ArrayList<String> supportedInstDSNames = new ArrayList<String>();
        BSDataslot.startColumnBuilder(globalProcessDataMeta, instanceProcessData);
        for (String name : processData.keySet()) {
            StringBuilder tempDropColBuff;
            StringBuilder tempAddColBuff;
            boolean addDS = BSDataslot.isAddedDS(addedds, name);
            String str = (String)processData.get(name);
            Map<DSAttribute, Object> dsAttrs = BSDataslot.getDSAttributes(id, templateName, name, str);
            String dstype = (String)dsAttrs.get(DSAttribute.TYPE);
            boolean global = (Boolean)dsAttrs.get(DSAttribute.GLOBAL);
            if (global) {
                tempAddColBuff = globalProcessDataMeta.addColBuff;
                tempDropColBuff = globalProcessDataMeta.dropColBuff;
            } else {
                tempAddColBuff = instanceProcessData.addColBuff;
                tempDropColBuff = instanceProcessData.dropColBuff;
                if (BizLogicEventMap.isSupportedDSType(dstype)) {
                    supportedInstDSNames.add(name);
                }
            }
            if (BizLogicEventMap.isSupportedDSType(dstype)) {
                ProcessDataInfoFields pdiFields = new ProcessDataInfoFields(dsAttrs, id, name, dstype, global, 12);
                BSDataslot.addInfoFields(globalProcessDataMeta, instanceProcessData, addDS, tempAddColBuff, tempDropColBuff, pdiFields, dsAttrs);
            }
            if (global) {
                globalProcessDataMeta.setAddDropColBuff(tempAddColBuff, tempDropColBuff);
                continue;
            }
            instanceProcessData.setAddDropColBuff(tempAddColBuff, tempDropColBuff);
        }
        if (ServiceLocator.self().isOracle() || SBMDatabase.self().isOpenEdge()) {
            instanceProcessData.addCloseBrace();
            globalProcessDataMeta.addCloseBrace();
        }
        BSDataslot.logDsSqls(globalProcessDataMeta, instanceProcessData);
        BSDataslot.executeAddDlls(event, globalProcessDataMeta, instanceProcessData);
        Map<String, Object> viewInfo = BSDataslot.getProcessTemplateViewMap(event, templateName, supportedInstDSNames);
        BSProcessTemplate.createProcessTemplateView(viewInfo, true);
    }

    private static void addInfoFields(ProcessDataMeta globalProcessDataMeta, ProcessDataMeta instanceProcessData, boolean addDS, StringBuilder tempAddColBuff, StringBuilder tempDropColBuff, ProcessDataInfoFields pdiFields, Map<DSAttribute, Object> dsAttrs) throws SQLException {
        if (addDS) {
            if (pdiFields.global) {
                globalProcessDataMeta.updateTemporaryBuffers(pdiFields.name, tempAddColBuff, tempDropColBuff);
            } else {
                instanceProcessData.updateTemporaryBuffers(pdiFields.name, tempAddColBuff, tempDropColBuff);
            }
            tempAddColBuff.append(DBService.polish((String)pdiFields.name)).append(" ");
            tempDropColBuff.append(DBService.polish((String)pdiFields.name)).append(" ");
        }
        tempAddColBuff.append((CharSequence)BSDataslot.getSlotTypeSQLString(pdiFields, addDS, false));
        if (BizLogicEventMap.isSupportedDSType(pdiFields.dstype)) {
            BSDataslot.insertProcessDataInfo(pdiFields);
            if (addDS) {
                if (pdiFields.global) {
                    globalProcessDataMeta.addToList(pdiFields.name, pdiFields.optype, (String)dsAttrs.get(DSAttribute.VALUE));
                } else {
                    instanceProcessData.addToList(pdiFields.name, pdiFields.optype, (String)dsAttrs.get(DSAttribute.VALUE));
                }
            }
        }
        ptCache.addDSType(pdiFields.id, pdiFields.name, pdiFields.optype);
    }

    private static void executeAddDlls(CommonEvent event, ProcessDataMeta globalProcessDataMeta, ProcessDataMeta instanceProcessData) throws Exception {
        try {
            globalProcessDataMeta.executeDll();
            instanceProcessData.executeDll();
            if (!globalProcessDataMeta.types.isEmpty()) {
                BSDataslot.updateDSValuesForReplace((ArrayList)globalProcessDataMeta.names, (ArrayList)globalProcessDataMeta.types, (ArrayList)globalProcessDataMeta.values, event, true);
            }
        }
        catch (RuntimeException | SQLException e) {
            if (globalProcessDataMeta.isDsColumnAdded) {
                BSDataslot.dropColumnOnError(globalProcessDataMeta, GLOBAL);
            }
            if (instanceProcessData.isDsColumnAdded) {
                BSDataslot.dropColumnOnError(instanceProcessData, INSTANCE);
            }
            throw e;
        }
    }

    private static void startColumnBuilder(ProcessDataMeta globalProcessDataMeta, ProcessDataMeta instanceProcessData) {
        if (ServiceLocator.self().isOracle() || SBMDatabase.self().isOpenEdge()) {
            instanceProcessData.addColBuff.append(" (");
            globalProcessDataMeta.addColBuff.append(" (");
        }
        if (ServiceLocator.self().isOracle()) {
            instanceProcessData.dropColBuff.append(" (");
            globalProcessDataMeta.dropColBuff.append(" (");
        } else {
            instanceProcessData.dropColBuff.append(" COLUMN ");
            globalProcessDataMeta.dropColBuff.append(" COLUMN ");
        }
    }

    private static void logDsSqls(ProcessDataMeta globalPd, ProcessDataMeta instancePd) {
        BSControl.logger.debug((Object)(" instance_AddDSCol_sql is " + instancePd.addColBuff));
        BSControl.logger.debug((Object)(" global_AddDSCol_sql is " + globalPd.addColBuff));
        BSControl.logger.debug((Object)(" instance_DropDSCol_sql is " + instancePd.dropColBuff));
        BSControl.logger.debug((Object)(" global_DS_sql is " + globalPd.dropColBuff));
    }

    private static void insertProcessDataInfo(ProcessDataInfoFields pdiFields) throws SQLException {
        Connection conn = null;
        PreparedStatement preparedStatement = null;
        try {
            conn = BSControl.util.getBSConnection();
            preparedStatement = conn.prepareStatement(SQL_INSERT_PDI);
            preparedStatement.setLong(1, pdiFields.id);
            preparedStatement.setString(2, pdiFields.name);
            preparedStatement.setInt(3, pdiFields.optype);
            preparedStatement.setInt(4, pdiFields.size);
            preparedStatement.setString(5, pdiFields.dstype);
            preparedStatement.setString(6, pdiFields.bizManageAccess ? TRUE_STR : FALSE_STR);
            preparedStatement.setInt(7, pdiFields.scale);
            preparedStatement.setString(8, pdiFields.global ? TRUE_STR : FALSE_STR);
            BSUtil.setValue(preparedStatement, 9, pdiFields.label);
            preparedStatement.setString(10, pdiFields.bizSiteAccess ? TRUE_STR : FALSE_STR);
            preparedStatement.setInt(11, pdiFields.monitorDS ? 1 : 0);
            preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                BSControl.logger.errorKey(BIZ_STORE_MSG_1501, new Object[]{SQL_INSERT_PDI, e.getMessage()});
                throw e;
            }
            catch (Throwable throwable) {
                SBMDAOService.clean(null, preparedStatement, (Connection)conn);
                throw throwable;
            }
        }
        SBMDAOService.clean(null, (Statement)preparedStatement, (Connection)conn);
    }

    private static void dropColumnOnError(ProcessDataMeta processData, String type) {
        if (ServiceLocator.self().isDB2()) {
            BSControl.logger.warnKey("BizStore_MSG_1008", new Object[]{processData.dropColBuff});
        } else {
            BSControl.logger.warn((Object)(" dropping " + type + " ds columns"));
            if (SBMDatabase.self().isOpenEdge()) {
                BSDataslot.dropColumns(processData.dropColList);
            } else {
                BSDataslot.dropColumns(processData.dropColBuff.toString());
            }
        }
    }

    private static int getDSSize(String dsType, int size) {
        int sqlSize = SBMControl.dbmap.getSQLSize(dsType);
        if (size == -1 || size > sqlSize) {
            size = sqlSize;
        }
        return size;
    }

    private static int getDSScale(String dsType, int scale) {
        int sqlScale = SBMControl.dbmap.getSQLScale(dsType);
        if (scale == -1 || scale > sqlScale) {
            scale = sqlScale;
        }
        return scale;
    }

    private static Map<DSAttribute, Object> getDSAttributes(long eventId, String templateName, String dsName, String dsAttrStr) {
        int dsAttrLength = 9;
        String[] dsAttrs = dsAttrStr.split("\\|");
        if (dsAttrs == null || dsAttrs.length < dsAttrLength) {
            throw new BizStoreException("BizStore_MSG_1612", "getDSAttributes()", new Object[]{dsAttrStr, dsName, templateName}, true, eventId);
        }
        HashMap<DSAttribute, Object> dsAttrMap = new HashMap<DSAttribute, Object>();
        dsAttrMap.put(DSAttribute.TYPE, dsAttrs[0]);
        dsAttrMap.put(DSAttribute.VALUE, dsAttrs[1]);
        int sizeInt = BSDataslot.getIntValue(dsAttrs[2], -1);
        dsAttrMap.put(DSAttribute.SIZE, sizeInt);
        boolean bizManageAcess = BSDataslot.getBooleanValue(dsAttrs[3], true);
        dsAttrMap.put(DSAttribute.BIZMANAGE_ACCESS, bizManageAcess);
        int scaleInt = BSDataslot.getIntValue(dsAttrs[4], -1);
        dsAttrMap.put(DSAttribute.SCALE, scaleInt);
        boolean global = BSDataslot.getBooleanValue(dsAttrs[5], false);
        dsAttrMap.put(DSAttribute.GLOBAL, global);
        dsAttrMap.put(DSAttribute.LABEL, dsAttrs[6]);
        boolean bizSiteAcess = BSDataslot.getBooleanValue(dsAttrs[7], true);
        dsAttrMap.put(DSAttribute.BIZSITE_ACCESS, bizSiteAcess);
        boolean monitorDS = BSDataslot.getBooleanValue(dsAttrs[8], false);
        dsAttrMap.put(DSAttribute.MONITOR_DS, monitorDS);
        return dsAttrMap;
    }

    private static boolean getBooleanValue(String booleanStr, boolean defaultVal) {
        boolean booleanVal = Boolean.parseBoolean(booleanStr);
        if (!booleanVal) {
            booleanVal = defaultVal;
        }
        return booleanVal;
    }

    private static int getIntValue(String intStr, int defaultVal) {
        int intVal = defaultVal;
        try {
            intVal = Integer.parseInt(intStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return intVal;
    }

    private static void updateDSValuesForReplace(ArrayList names, ArrayList types, ArrayList values, CommonEvent event, boolean isGlobal) throws Exception {
        Object conn = null;
        try {
            ServiceLocalHome serviceHome = (ServiceLocalHome)SBMHomeFactory.self().lookupLocalHome(ServiceLocalHome.class);
            ServiceLocal serviceLocal = serviceHome.create();
            serviceLocal.updateBSNewDataSlotsForPTR(names, types, values, event, isGlobal);
        }
        catch (Exception e) {
            BSControl.logger.errorKey(BIZ_STORE_MSG_1501, new Object[]{"updateDSValuesForReplace", e.getMessage()});
            throw e;
        }
    }

    private static void dropColumns(String sqlStmt) {
        try {
            BSControl.util.executeDDLStmt(sqlStmt, true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void dropColumns(List<String> sqlStmts) {
        for (String sqlStmt : sqlStmts) {
            try {
                BSControl.util.executeDDLStmt(sqlStmt, true);
            }
            catch (Throwable th) {
                SBMUtil.self().getLogger().error((Object)("BSDataSlot.dropColumns : Error in deleting column. Reason : " + th.getMessage()));
            }
        }
    }

    private static boolean isAddedDS(String[] addds, String dsname) {
        if (addds == null || addds.length == 0) {
            return false;
        }
        for (int itr = 0; itr < addds.length; ++itr) {
            if (!addds[itr].equals(dsname)) continue;
            return true;
        }
        return false;
    }

    protected static void insertProcessDataInfos(CommonEvent event) throws Exception {
        String createTableSuffix;
        HashMap processData = BizLogicEventMap.getProcessData(event);
        long id = BizLogicEventMap.getProcessTemplateID(event);
        String templateName = BizLogicEventMap.getProcessTemplateName(event);
        ptCache.addPTName(id, templateName);
        DBConstants consts = DBConstants.single();
        ArrayList<String> supportedInstDSNames = new ArrayList<String>();
        ArrayList<String> globalNames = new ArrayList<String>();
        ArrayList<Integer> globalTypes = new ArrayList<Integer>();
        ArrayList<String> globalValues = new ArrayList<String>();
        String dataTableName = DBService.polish((String)templateName);
        StringBuilder instanceSql = BSDataslot.getInstanceDsInsertBaseSql(consts, dataTableName);
        String globalDataTableName = TABLE_NAME_PATTERN[2] + id;
        StringBuilder globalSql = BSDataslot.getGlobalDsInsertBaseSql(consts, globalDataTableName, 100, SBMControl.dbmap.getSQLType("LONG"));
        for (String dsKey : processData.keySet()) {
            StringBuilder tempSql;
            String dsValue = (String)processData.get(dsKey);
            Map<DSAttribute, Object> dsAttrs = BSDataslot.getDSAttributes(id, templateName, dsKey, dsValue);
            String dsType = (String)dsAttrs.get(DSAttribute.TYPE);
            boolean global = (Boolean)dsAttrs.get(DSAttribute.GLOBAL);
            StringBuilder stringBuilder = tempSql = global ? globalSql : instanceSql;
            if (!global && BizLogicEventMap.isSupportedDSType(dsType)) {
                supportedInstDSNames.add(dsKey);
            }
            if (BizLogicEventMap.isSupportedDSType(dsType)) {
                DBConstants.KeywordConstants cfr_ignored_0 = consts.kwd;
                DBConstants.KeywordConstants cfr_ignored_1 = consts.kwd;
                tempSql.append(", ").append(DBService.polish((String)dsKey)).append(" ");
                ProcessDataInfoFields pdiFields = new ProcessDataInfoFields(dsAttrs, id, dsKey, dsType, global, 12);
                tempSql.append((CharSequence)BSDataslot.getSlotTypeSQLString(pdiFields, true, true));
                BSDataslot.insertProcessDataInfo(pdiFields);
                if (pdiFields.global) {
                    globalNames.add(pdiFields.name);
                    globalTypes.add(pdiFields.optype);
                    globalValues.add((String)dsAttrs.get(DSAttribute.VALUE));
                }
                ptCache.addDSType(pdiFields.id, pdiFields.name, pdiFields.optype);
            }
            if (global) {
                globalSql = tempSql;
                continue;
            }
            instanceSql = tempSql;
        }
        instanceSql.append((CharSequence)BSDataslot.appendPrimaryKeyConstraint(event, consts, "CONSTRAINT piid_key", " PRIMARY KEY(PROCESS_INSTANCE_ID)"));
        globalSql.append((CharSequence)BSDataslot.appendPrimaryKeyConstraint(event, consts, "CONSTRAINT ptid_key", " PRIMARY KEY(PROCESS_TEMPLATE_ID)"));
        if (SBMControl.dbmap.isSybase()) {
            DBConstants.KeywordConstants cfr_ignored_2 = consts.kwd;
            instanceSql.append(" ").append("LOCK DATAROWS");
            DBConstants.KeywordConstants cfr_ignored_3 = consts.kwd;
            globalSql.append(" ").append("LOCK DATAROWS");
        }
        if (StringUtils.isNotBlank((CharSequence)(createTableSuffix = SBMControl.dbmap.getCreateTableSuffix()))) {
            DBConstants.KeywordConstants cfr_ignored_4 = consts.kwd;
            instanceSql.append(" ").append(createTableSuffix);
            DBConstants.KeywordConstants cfr_ignored_5 = consts.kwd;
            globalSql.append(" ").append(createTableSuffix);
        }
        BSDataslot.executeInstanceDsDll(dataTableName, instanceSql.toString());
        ptCache.addInstanceDSInfo(id, true);
        BSDataslot.executeGlobalDsDll(event, consts, globalNames, globalTypes, globalValues, dataTableName, globalDataTableName, globalSql.toString());
        ptCache.addGlobalDSInfo(id, true);
        Map<String, Object> viewInfo = BSDataslot.getProcessTemplateViewMap(event, templateName, supportedInstDSNames);
        BSProcessTemplate.createProcessTemplateView(viewInfo, false);
    }

    private static Map<String, Object> getProcessTemplateViewMap(CommonEvent event, String templateName, List<String> supportedInstDSNames) {
        HashMap<String, Object> viewInfo = new HashMap<String, Object>();
        viewInfo.put("PT_NAME", templateName);
        viewInfo.put("PT_ID", BizLogicEventMap.getProcessTemplateID(event));
        viewInfo.put("MONITOR_DS", BizLogicEventMap.getMonitorDSName(event));
        viewInfo.put("INSTANCE_DS", supportedInstDSNames);
        return viewInfo;
    }

    private static void executeInstanceDsDll(String dataTableName, String instanceDsSql) {
        try {
            BSControl.util.executeDDLStmt(instanceDsSql);
            SBMDatabase sbmDatabase = SBMDatabase.self();
            if (sbmDatabase.isDualDbUser()) {
                String strGrant = SBMDatabase.getSqlGrantStatement((String)dataTableName, (String)sbmDatabase.getAppUserRole());
                BSControl.util.executeDDLStmt(strGrant);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void executeGlobalDsDll(CommonEvent event, DBConstants consts, List<String> globalNames, List<Integer> globalTypes, List<String> globalValues, String dataTableName, String globalDataTableName, String globalDsSql) {
        try {
            BSControl.util.executeDDLStmt(globalDsSql);
            SBMDatabase sbmDatabase = SBMDatabase.self();
            if (sbmDatabase.isDualDbUser()) {
                String strGrant = SBMDatabase.getSqlGrantStatement((String)globalDataTableName, (String)sbmDatabase.getAppUserRole());
                BSControl.util.executeDDLStmt(strGrant);
            }
            BSDataslot.createDSIndexes(event, dataTableName);
            BSDataslot.insertIntoDSTable((ArrayList)globalNames, (ArrayList)globalTypes, (ArrayList)globalValues, event, true);
        }
        catch (Exception ex) {
            try {
                DBConstants.KeywordConstants cfr_ignored_0 = consts.kwd;
                BSControl.util.executeDDLStmt(" DROP TABLE " + dataTableName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new RuntimeException(ex);
        }
    }

    private static StringBuilder appendPrimaryKeyConstraint(CommonEvent event, DBConstants consts, String constraintName, String tableName) {
        DBConstants.KeywordConstants cfr_ignored_0 = consts.kwd;
        DBConstants.KeywordConstants cfr_ignored_1 = consts.kwd;
        return new StringBuilder().append(", ").append(constraintName).append(BizLogicEventMap.getProcessTemplateID(event)).append(tableName).append(") ");
    }

    private static StringBuilder getSlotTypeSQLString(ProcessDataInfoFields pdiFields, boolean addDs, boolean isInsertSql) {
        StringBuilder builder = new StringBuilder();
        int dataSlotType = BizLogicEventMap.getMap(pdiFields.dstype);
        switch (dataSlotType) {
            case 51: 
            case 72: {
                pdiFields.optype = -5;
                if (!addDs) break;
                return builder.append(SBMControl.dbmap.getSQLType("LONG"));
            }
            case 52: {
                pdiFields.optype = 7;
                if (!addDs) break;
                return builder.append(SBMControl.dbmap.getSQLType("DOUBLE"));
            }
            case 53: {
                pdiFields.optype = 1;
                return BSDataslot.getDataTypeString(pdiFields, addDs);
            }
            case 54: 
            case 55: 
            case 58: {
                pdiFields.optype = 12;
                return BSDataslot.getDataTypeString(pdiFields, addDs);
            }
            case 56: {
                pdiFields.optype = -7;
                if (addDs) {
                    builder.append(SBMControl.dbmap.getSQLType("BOOLEAN"));
                }
                if (isInsertSql) {
                    return builder.append(" ").append(" NOT NULL ");
                }
                return builder;
            }
            case 70: {
                pdiFields.optype = 93;
                if (!addDs) break;
                return builder.append(SBMControl.dbmap.getSQLType("DATETIME"));
            }
            case 71: {
                pdiFields.optype = 3;
                pdiFields.size = BSDataslot.getDSSize("DECIMAL", pdiFields.size);
                pdiFields.scale = BSDataslot.getDSScale("DECIMAL", pdiFields.scale);
                if (!addDs) break;
                builder.append(SBMControl.dbmap.getSQLType("DECIMAL"));
                return BSDataslot.appendSizeScaleString(pdiFields, builder);
            }
            case 73: {
                pdiFields.optype = 3;
                pdiFields.size = BSDataslot.getDSSize("CURRENCY", pdiFields.size);
                pdiFields.scale = BSDataslot.getDSScale("CURRENCY", pdiFields.scale);
                if (!addDs) break;
                builder.append(SBMControl.dbmap.getSQLType("CURRENCY"));
                return BSDataslot.appendSizeScaleString(pdiFields, builder);
            }
            default: {
                return builder;
            }
        }
        return builder;
    }

    private static StringBuilder appendSizeScaleString(ProcessDataInfoFields pdiFields, StringBuilder builder) {
        return builder.append(" (").append(pdiFields.size).append(", ").append(pdiFields.scale).append(") ");
    }

    private static StringBuilder getDataTypeString(ProcessDataInfoFields pdiFields, boolean addDs) {
        pdiFields.size = BSDataslot.getDSSize("STRING", pdiFields.size);
        if (addDs) {
            return new StringBuilder().append(SBMControl.dbmap.getSQLType("STRING")).append(" (").append(pdiFields.size).append(") ");
        }
        return new StringBuilder();
    }

    private static StringBuilder getGlobalDsInsertBaseSql(DBConstants consts, String globalDataTableName, int size, String sqlType) {
        DBConstants.KeywordConstants cfr_ignored_0 = consts.kwd;
        DBConstants.KeywordConstants cfr_ignored_1 = consts.kwd;
        DBConstants.KeywordConstants cfr_ignored_2 = consts.kwd;
        DBConstants.ColConstants cfr_ignored_3 = consts.col;
        DBConstants.KeywordConstants cfr_ignored_4 = consts.kwd;
        DBConstants.KeywordConstants cfr_ignored_5 = consts.kwd;
        return new StringBuilder(size).append(" CREATE TABLE ").append(globalDataTableName).append(" (").append(" ").append("PROCESS_TEMPLATE_ID").append(" ").append(sqlType).append(" NOT NULL ");
    }

    private static StringBuilder getInstanceDsInsertBaseSql(DBConstants consts, String dataTableName) {
        DBConstants.KeywordConstants cfr_ignored_0 = consts.kwd;
        DBConstants.KeywordConstants cfr_ignored_1 = consts.kwd;
        DBConstants.ColConstants cfr_ignored_2 = consts.col;
        DBConstants.KeywordConstants cfr_ignored_3 = consts.kwd;
        DBConstants.KeywordConstants cfr_ignored_4 = consts.kwd;
        return BSDataslot.getGlobalDsInsertBaseSql(consts, dataTableName, 300, SBMControl.dbmap.getSQLType("LONG")).append(", ").append(" ").append("PROCESS_INSTANCE_ID").append(" ").append(SBMControl.dbmap.getSQLType("LONG")).append(" NOT NULL ");
    }

    private static void addCreateIndexQueries(String bsTableName, List<String> createIdxQrys, CommonEvent event) {
        String blIndexNamePrefix = "bl";
        String bsIndexNamePrefix = "bs";
        long ptId = BizLogicEventMap.getProcessTemplateID(event);
        String blTableName = TABLE_NAME_PATTERN[0] + ptId;
        for (String query : createIdxQrys) {
            try {
                BSDataslot.insertDDLStatementOE(query, 2, bsTableName);
                BSControl.logger.infoKey("BizStore_MSG_528", new Object[]{query});
                query = query.replaceFirst(bsIndexNamePrefix, blIndexNamePrefix);
                query = query.replaceFirst(bsTableName, blTableName);
                BSDataslot.insertDDLStatementOE(query, 2, blTableName);
                BSControl.logger.infoKey("BizStore_MSG_528", new Object[]{query});
            }
            catch (Throwable th) {
                throw new BizStoreException("BizStore_MSG_1603", "BSDataslot.createDSIndexes()", new Object[]{query}, false, event.getEventID());
            }
        }
    }

    private static void createDSIndexes(CommonEvent event, String tableName) {
        Map<String, List<String>> dbIndexdata = BizLogicEventMap.getDataSlotDBIndexData(event);
        String ptName = BizLogicEventMap.getProcessTemplateName(event);
        if (dbIndexdata == null) {
            return;
        }
        Set<String> indexNames = dbIndexdata.keySet();
        ArrayList<String> idxQueries = null;
        for (String indexName : indexNames) {
            List<String> columnNames = dbIndexdata.get(indexName);
            String createIndexQuery = BSUtil.getCreateIndexSql((String)tableName, (String)indexName, columnNames);
            if (SBMDatabase.self().isOpenEdge()) {
                if (idxQueries == null) {
                    idxQueries = new ArrayList<String>();
                }
                idxQueries.add(createIndexQuery);
                continue;
            }
            try {
                BSUtil.self().executeDDLStmt(createIndexQuery);
                BSControl.logger.infoKey("BizStore_MSG_527", new Object[]{indexName, tableName, columnNames, ptName});
            }
            catch (Throwable th) {
                throw new BizStoreException("BizStore_MSG_1534", "BSDataslot.createDSIndexes()", new Object[]{tableName, columnNames, ptName}, false, event.getEventID());
            }
        }
        if (SBMDatabase.self().isOpenEdge()) {
            BSDataslot.addCreateIndexQueries(tableName, idxQueries, event);
        }
    }

    public static void addDropTableQueries(String templateName, long templateId) throws Throwable {
        if (templateId <= 0L || templateName == null || templateName.trim().length() == 0) {
            return;
        }
        for (String tblPrefix : TABLE_NAME_PATTERN) {
            DBConstants.KeywordConstants cfr_ignored_0 = DBConstants.single().kwd;
            StringBuilder query = new StringBuilder(" DROP TABLE ");
            String tableName = tblPrefix + templateId;
            query.append(tableName);
            BSDataslot.insertDDLStatementOE(query.toString(), 1, tableName);
            BSControl.logger.infoKey("BizStore_MSG_528", new Object[]{query.toString()});
        }
        DBConstants.KeywordConstants cfr_ignored_1 = DBConstants.single().kwd;
        StringBuilder query = new StringBuilder(" DROP TABLE ").append(templateName);
        BSDataslot.insertDDLStatementOE(query.toString(), 1, templateName);
        BSControl.logger.infoKey("BizStore_MSG_528", new Object[]{query.toString()});
    }

    private static void insertDDLStatementOE(String statement, int operation, String tableName) throws Throwable {
        String sequenceName = "OE_DDL_OPERATION_SEQ";
        StringBuilder insertQuery = new StringBuilder("INSERT INTO OE_DDL_OPERATION");
        insertQuery.append("( STATEMENT_ID, \"STATEMENT\", OPERATION, \"OBJECT\", STATUS )");
        insertQuery.append("VALUES (").append(DBService.getSequenceName((String)sequenceName)).append(".NEXTVAL ,");
        insertQuery.append("? ,?, ?, ?").append(")");
        Connection conn = null;
        PreparedStatement pst = null;
        try {
            conn = BSControl.util.getBSConnection();
            pst = conn.prepareStatement(insertQuery.toString());
            pst.setString(1, statement);
            pst.setInt(2, operation);
            pst.setString(3, tableName);
            pst.setInt(4, 0);
            pst.executeUpdate();
        }
        catch (Throwable th) {
            try {
                BSControl.logger.errorKey(BIZ_STORE_MSG_1501, new Object[]{insertQuery.toString(), th.getMessage()});
                throw th;
            }
            catch (Throwable throwable) {
                SBMDAOService.clean(null, pst, (Connection)conn);
                throw throwable;
            }
        }
        SBMDAOService.clean(null, (Statement)pst, (Connection)conn);
    }

    protected static void dropDSTables(String templateName, long id, boolean hasIDS, boolean hasGDS) throws Throwable {
        block6: {
            String dataTableName;
            String dropTableQuery;
            block5: {
                dropTableQuery = null;
                dataTableName = null;
                try {
                    dataTableName = DBService.polish((String)templateName);
                    DBConstants.KeywordConstants cfr_ignored_0 = DBConstants.single().kwd;
                    dropTableQuery = " DROP TABLE " + dataTableName;
                    if (SBMDatabase.self().isOpenEdge()) {
                        BSDataslot.addDropTableQueries(dataTableName, id);
                        return;
                    }
                    BSControl.util.executeDDLStmt(dropTableQuery);
                }
                catch (Throwable th) {
                    if (!BSUtil.checkTableExists((String)BSUtil.self().DS_JNDI_NAME, (String)dataTableName) || SBMDatabase.self().isOpenEdge()) break block5;
                    throw th;
                }
            }
            StringBuilder sb = new StringBuilder();
            DBConstants.KeywordConstants cfr_ignored_1 = DBConstants.single().kwd;
            sb.append(" DROP TABLE ").append(TABLE_NAME_PATTERN[2]).append(id);
            dropTableQuery = sb.toString();
            try {
                BSControl.util.executeDDLStmt(dropTableQuery);
            }
            catch (Throwable th) {
                if (!BSUtil.checkTableExists((String)BSUtil.self().DS_JNDI_NAME, (String)dataTableName) || SBMDatabase.self().isOpenEdge()) break block6;
                throw th;
            }
        }
    }

    protected static void insertIntoDSTable(ArrayList names, ArrayList types, ArrayList values, CommonEvent event, boolean isGlobal) throws SQLException {
        Connection conn = null;
        PreparedStatement stmtInsertAt = null;
        String sqlInsertAt = null;
        try {
            conn = BSControl.util.getBSConnection();
            long ptid = BizLogicEventMap.getProcessTemplateID(event);
            long iid = BizLogicEventMap.getProcessInstanceID(event);
            String templateName = BSProcessTemplate.getName(ptid);
            String tableName = null;
            tableName = isGlobal ? TABLE_NAME_PATTERN[2] + ptid : templateName;
            sqlInsertAt = BSDataslot.createInsertQuery(tableName, names, isGlobal);
            stmtInsertAt = conn.prepareStatement(sqlInsertAt);
            Iterator it = names.iterator();
            Iterator tit = types.iterator();
            Iterator vit = values.iterator();
            int i = 1;
            stmtInsertAt.setLong(i++, ptid);
            if (!isGlobal) {
                stmtInsertAt.setLong(i++, iid);
            }
            while (it.hasNext()) {
                it.next();
                Integer type = (Integer)tit.next();
                Object o = vit.next();
                BSUtil.setValue(stmtInsertAt, type, i++, o);
            }
            stmtInsertAt.executeUpdate();
        }
        catch (SQLException se) {
            try {
                BSControl.logger.errorKey(BIZ_STORE_MSG_1501, new Object[]{sqlInsertAt, se.getMessage()});
                throw se;
            }
            catch (Throwable throwable) {
                SBMDAOService.clean(null, stmtInsertAt, (Connection)conn);
                throw throwable;
            }
        }
        SBMDAOService.clean(null, (Statement)stmtInsertAt, (Connection)conn);
    }

    protected static String createInsertQuery(String tableName, ArrayList names, boolean isGlobal) {
        Iterator it = names.iterator();
        names.size();
        StringBuilder head = new StringBuilder(100);
        StringBuilder flds = new StringBuilder();
        StringBuilder vals = new StringBuilder();
        head.append("INSERT INTO ");
        String dataTableName = DBService.polish((String)tableName);
        head.append(dataTableName);
        flds.append(" (");
        vals.append(" (");
        flds.append(" PROCESS_TEMPLATE_ID");
        vals.append(" ? ");
        if (!isGlobal) {
            flds.append(", PROCESS_INSTANCE_ID");
            vals.append(", ?");
        }
        while (it.hasNext()) {
            flds.append(", ");
            vals.append(", ");
            String dsstr = (String)it.next();
            flds.append(DBService.polish((String)dsstr));
            vals.append("?");
        }
        flds.append(")");
        vals.append(")");
        head.append(flds.toString());
        head.append(" VALUES ");
        head.append(vals.toString());
        return head.toString();
    }

    protected static void updateDSTable(String dataslotName, int dstype, Object value, CommonEvent event, boolean isGlobal) throws SQLException {
        Connection conn = null;
        PreparedStatement stmtUpdateAt = null;
        String sqlUpdateAt = null;
        try {
            conn = BSControl.util.getBSConnection();
            long ptid = BizLogicEventMap.getProcessTemplateID(event);
            String templateName = BSProcessTemplate.getName(ptid);
            String dataTableName = null;
            long iid = -1L;
            if (!isGlobal) {
                dataTableName = DBService.polish((String)templateName);
                iid = BizLogicEventMap.getProcessInstanceID(event);
            } else {
                dataTableName = TABLE_NAME_PATTERN[2] + ptid;
            }
            StringBuilder head = new StringBuilder();
            head.append("UPDATE ");
            head.append(dataTableName);
            head.append(" SET ");
            head.append(DBService.polish((String)dataslotName));
            head.append("=?");
            if (isGlobal) {
                head.append(" WHERE PROCESS_TEMPLATE_ID = ?");
            } else {
                head.append(" WHERE PROCESS_INSTANCE_ID = ?");
            }
            sqlUpdateAt = head.toString();
            stmtUpdateAt = conn.prepareStatement(sqlUpdateAt);
            BSUtil.setValue(stmtUpdateAt, dstype, 1, value);
            if (isGlobal) {
                stmtUpdateAt.setLong(2, ptid);
            } else {
                stmtUpdateAt.setLong(2, iid);
            }
            stmtUpdateAt.executeUpdate();
        }
        catch (SQLException se) {
            try {
                BSControl.logger.errorKey(BIZ_STORE_MSG_1501, new Object[]{sqlUpdateAt, se.getMessage()});
                throw se;
            }
            catch (Throwable throwable) {
                SBMDAOService.clean(null, stmtUpdateAt, (Connection)conn);
                throw throwable;
            }
        }
        SBMDAOService.clean(null, (Statement)stmtUpdateAt, (Connection)conn);
    }

    protected static void updateDSTable(ArrayList names, ArrayList types, ArrayList values, CommonEvent event, boolean isGlobal) throws SQLException {
        Connection conn = null;
        PreparedStatement stmtUpdateAt = null;
        String sqlUpdateAt = null;
        try {
            conn = BSControl.util.getBSConnection();
            long ptid = BizLogicEventMap.getProcessTemplateID(event);
            long iid = BizLogicEventMap.getProcessInstanceID(event);
            String templateName = BSProcessTemplate.getName(ptid);
            Iterator it = names.iterator();
            String dataTableName = null;
            dataTableName = !isGlobal ? DBService.polish((String)templateName) : TABLE_NAME_PATTERN[2] + ptid;
            StringBuilder head = new StringBuilder(100);
            head.append("UPDATE ");
            head.append(dataTableName);
            head.append(" SET ");
            String str = null;
            while (it.hasNext()) {
                str = (String)it.next();
                head.append(DBService.polish((String)str));
                head.append("=?");
                if (!it.hasNext()) continue;
                head.append(", ");
            }
            if (isGlobal) {
                head.append(" WHERE PROCESS_TEMPLATE_ID = ?");
            } else {
                head.append(" WHERE PROCESS_INSTANCE_ID = ?");
            }
            sqlUpdateAt = head.toString();
            stmtUpdateAt = conn.prepareStatement(sqlUpdateAt);
            it = names.iterator();
            Iterator tit = types.iterator();
            Iterator vit = values.iterator();
            int i = 1;
            while (it.hasNext()) {
                it.next();
                Integer type = (Integer)tit.next();
                Object o = vit.next();
                BSUtil.setValue(stmtUpdateAt, type, i++, o);
            }
            if (isGlobal) {
                stmtUpdateAt.setLong(i++, ptid);
            } else {
                stmtUpdateAt.setLong(i++, iid);
            }
            stmtUpdateAt.executeUpdate();
        }
        catch (SQLException se) {
            try {
                se.printStackTrace();
                BSControl.logger.errorKey(BIZ_STORE_MSG_1501, new Object[]{sqlUpdateAt, se.getMessage()});
                throw se;
            }
            catch (Throwable throwable) {
                SBMDAOService.clean(null, stmtUpdateAt, (Connection)conn);
                throw throwable;
            }
        }
        SBMDAOService.clean(null, (Statement)stmtUpdateAt, (Connection)conn);
    }

    public static void printSQLStatements() {
        BSControl.logger.debug((Object)"BSDataslot.printSQLStatements:");
        BSControl.logger.debugKey("BizStore_MSG_002", new Object[]{SQL_INSERT_PDI});
    }

    private static class ProcessDataMeta {
        private final String tableName;
        private final List<String> names = new ArrayList<String>();
        private final List<Integer> types = new ArrayList<Integer>();
        private final List<String> values = new ArrayList<String>();
        private StringBuilder addColBuff;
        private StringBuilder dropColBuff;
        private final List<String> dropColList = new ArrayList<String>();
        private boolean isFirst = true;
        private boolean isDsAdded;
        private boolean isDsColumnAdded;

        ProcessDataMeta(String tableName, int defaultCapacity) {
            this.addColBuff = new StringBuilder(defaultCapacity).append(" ALTER TABLE ").append(tableName).append(" ADD ");
            this.dropColBuff = new StringBuilder(defaultCapacity).append(" ALTER TABLE ").append(tableName).append(" DROP ");
            this.tableName = tableName;
        }

        private void addToDropColList(String name) {
            if (SBMDatabase.self().isOpenEdge()) {
                StringBuilder dropQuery = new StringBuilder(" ALTER TABLE ").append(this.tableName).append(" DROP COLUMN ").append(DBService.polish((String)name));
                this.dropColList.add(dropQuery.toString());
            }
        }

        private void setAddDropColBuff(StringBuilder addColBuff, StringBuilder dropColBuff) {
            this.addColBuff = addColBuff;
            this.dropColBuff = dropColBuff;
        }

        private void addCloseBrace() {
            this.addColBuff.append(") ");
            this.dropColBuff.append(") ");
        }

        private void addToList(String name, int opType, String value) {
            this.names.add(name);
            this.types.add(opType);
            this.values.add(value);
        }

        private void updateTemporaryBuffers(String name, StringBuilder tempAddColBuff, StringBuilder tempDropColBuff) {
            this.isDsAdded = true;
            if (this.isFirst) {
                tempAddColBuff.append(" ");
                tempDropColBuff.append(" ");
                this.isFirst = false;
            } else if (ServiceLocator.self().isDB2()) {
                tempAddColBuff.append(" ADD ");
                tempDropColBuff.append(" DROP COLUMN ");
            } else {
                tempAddColBuff.append(", ");
                tempDropColBuff.append(", ");
            }
            this.addToDropColList(name);
        }

        private void executeDll() {
            if (this.isDsAdded) {
                BSControl.util.executeDDLStmt(this.addColBuff.toString(), true);
                this.isDsColumnAdded = true;
            }
        }
    }

    private static class ProcessDataInfoFields {
        private final long id;
        private final String name;
        private final String dstype;
        private int size;
        private final boolean bizManageAccess;
        private int scale;
        private final boolean global;
        private final String label;
        private final boolean bizSiteAccess;
        private final boolean monitorDS;
        private int optype;

        private ProcessDataInfoFields(Map<DSAttribute, Object> dsAttrs, long id, String name, String dstype, boolean global, int opType) {
            this.label = (String)dsAttrs.get(DSAttribute.LABEL);
            this.bizSiteAccess = (Boolean)dsAttrs.get(DSAttribute.BIZSITE_ACCESS);
            this.monitorDS = (Boolean)dsAttrs.get(DSAttribute.MONITOR_DS);
            this.size = (Integer)dsAttrs.get(DSAttribute.SIZE);
            this.bizManageAccess = (Boolean)dsAttrs.get(DSAttribute.BIZMANAGE_ACCESS);
            this.scale = (Integer)dsAttrs.get(DSAttribute.SCALE);
            this.id = id;
            this.name = name;
            this.dstype = dstype;
            this.global = global;
            this.optype = opType;
        }
    }
}

