/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.storeevent;

import com.savvion.sbm.bizlogic.storeevent.BSProcess;
import com.savvion.sbm.bizlogic.storeevent.BizStoreException;
import java.util.Hashtable;
import java.util.Set;

public class BSCache {
    private static BSCache self;
    private final Hashtable processData = new Hashtable();
    private static final String PT_NAME = "PT_NAME";
    private static final String DS_KEY = "DS";
    private static final String HAS_GLOBAL_DS = "HAS_GLOBAL_DS";
    private static final String HAS_INSTANCE_DS = "HAS_INSTANCE_DS";

    private BSCache() {
    }

    public static BSCache self() {
        if (self == null) {
            self = new BSCache();
        }
        return self;
    }

    public final void addGlobalDSInfo(long ptid, boolean hadGDS) {
        this.addValue(ptid, HAS_GLOBAL_DS, hadGDS);
    }

    public final void addInstanceDSInfo(long ptid, boolean hadIDS) {
        this.addValue(ptid, HAS_INSTANCE_DS, hadIDS);
    }

    public final boolean hasInstanceDS(long ptid) {
        Boolean status = (Boolean)this.getValue(ptid, HAS_INSTANCE_DS);
        if (status == null) {
            return false;
        }
        return status;
    }

    public final boolean hasGlobalDS(long ptid) {
        Boolean status = (Boolean)this.getValue(ptid, HAS_GLOBAL_DS);
        if (status == null) {
            return false;
        }
        return status;
    }

    public final void addPTName(long ptid, String ptName) {
        this.addValue(ptid, PT_NAME, ptName);
    }

    public final String getPTName(long ptid) {
        return (String)this.getValue(ptid, PT_NAME);
    }

    public final void addDSType(long ptid, String dsName, int type) {
        this.addValue(ptid, DS_KEY, dsName, type);
    }

    public final int getDSType(long ptid, String dsName) {
        return (Integer)this.getValue(ptid, DS_KEY, dsName);
    }

    public final void remove(long ptid) {
        this.processData.remove(ptid);
    }

    public final void close() {
        this.clear();
        self = null;
    }

    public final Hashtable getDSData(long ptid) {
        Hashtable dsData = new Hashtable();
        Hashtable ptData = this.getProcessData(ptid);
        if (ptData != null) {
            dsData = (Hashtable)ptData.get(DS_KEY);
        }
        return dsData;
    }

    public final boolean contains(long ptid, String dsName) {
        Hashtable dsData;
        boolean isContains = false;
        Hashtable ptData = this.getProcessData(ptid);
        if (ptData != null && (dsData = (Hashtable)ptData.get(DS_KEY)) != null) {
            isContains = dsData.containsKey(dsName);
        }
        return isContains;
    }

    public final void clear() {
        this.processData.clear();
    }

    private final void addValue(Object ptid, Object key, Object value) {
        Hashtable<Object, Object> ptData = (Hashtable<Object, Object>)this.processData.get(ptid);
        if (ptData != null) {
            ptData.put(key, value);
        } else {
            ptData = new Hashtable<Object, Object>();
            ptData.put(key, value);
            this.processData.put(ptid, ptData);
        }
    }

    public final Set<Long> getAllPtId() {
        return this.processData.keySet();
    }

    private final void addValue(Object ptid, Object dsKey, Object key, Object value) {
        Hashtable<Object, Hashtable<Object, Object>> ptData = (Hashtable<Object, Hashtable<Object, Object>>)this.processData.get(ptid);
        if (ptData != null) {
            Hashtable<Object, Object> dsData = (Hashtable<Object, Object>)ptData.get(dsKey);
            if (dsData != null) {
                dsData.put(key, value);
            } else {
                dsData = new Hashtable<Object, Object>();
                dsData.put(key, value);
                ptData.put(dsKey, dsData);
            }
        } else {
            Hashtable<Object, Object> dsData = new Hashtable<Object, Object>();
            dsData.put(key, value);
            ptData = new Hashtable<Object, Hashtable<Object, Object>>();
            ptData.put(dsKey, dsData);
            this.processData.put(ptid, ptData);
        }
    }

    private final Object getValue(Object ptid, Object key) {
        Object value = null;
        Hashtable ptData = this.getProcessData(ptid);
        if (ptData != null) {
            value = ptData.get(key);
        }
        if (value == null) {
            throw new BizStoreException("BizStore_MSG_1523", "PTID=" + ptid);
        }
        return value;
    }

    private final Object getValue(Object ptid, Object dsKey, Object key) {
        Object value = null;
        Hashtable dsData = null;
        Hashtable ptData = this.getProcessData(ptid);
        if (ptData != null && (dsData = (Hashtable)ptData.get(dsKey)) != null) {
            value = dsData.get(key);
        }
        if (value == null) {
            throw new BizStoreException("BizStore_MSG_1522", "PTID=" + ptid + ":" + key);
        }
        return value;
    }

    private final Hashtable getProcessData(Object ptid) {
        Hashtable processMetadata = (Hashtable)this.processData.get(ptid);
        if (processMetadata != null) {
            return processMetadata;
        }
        try {
            BSProcess.updateCache(ptid);
        }
        catch (Exception e) {
            throw new BizStoreException("BizStore_MSG_1521", "", (Throwable)e);
        }
        processMetadata = (Hashtable)this.processData.get(ptid);
        if (processMetadata != null) {
            return processMetadata;
        }
        throw new BizStoreException("BizStore_MSG_1531", ptid);
    }
}

