/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.storeevent;

import com.savvion.sbm.bizlogic.storeevent.BSControl;
import com.savvion.sbm.bizlogic.storeevent.BSProcess;
import com.savvion.sbm.bizlogic.storeevent.BSUtil;
import com.savvion.sbm.bizlogic.storeevent.BizLogicEventMap;
import com.savvion.sbm.util.CommonEvent;
import com.savvion.sbm.util.SBMDAOService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Map;

public class BSCWorkItem
extends BSProcess {
    private static final String INSERT_CSTEP_SQL = "INSERT INTO CSTEP (CSTEP_ID, PROCESS_TEMPLATE_ID, PROCESS_INSTANCE_ID, PARENT_WORKITEM_ID, DATASLOT_ACCESS, CSTEP_NAME) VALUES (?, ?, ?, ?, ?, ?)";
    private static final String INSERT_CSTEPDS_SQL = "INSERT INTO CSTEP_DS (CSTEP_ID, PROCESS_TEMPLATE_ID, PROCESS_INSTANCE_ID, PARENT_WORKITEM_ID, DATASLOT_ACCESS, DATASLOT_NAME) VALUES (?, ?, ?, ?, ?, ?)";
    private static final String INSERT_CWORKITEM_SQL = "INSERT INTO CWORKITEM (CWORKITEM_ID, CSTEP_ID, PARENT_WORKITEM_ID, PROCESS_INSTANCE_ID, PROCESS_TEMPLATE_ID, START_TIME, DUEDATE, END_TIME, CWORKITEM_NAME, COLLABORATOR, CREATOR, PRIORITY, STATUS, INSTRUCTION, RESPONSE) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String STATUS_CHANGE_SQL = "UPDATE CWORKITEM SET COLLABORATOR = ?, STATUS = ?  WHERE CWORKITEM_ID = ?";
    private static final String CREATOR_UPDATE_SQL = "UPDATE CWORKITEM SET CREATOR = ?  WHERE PARENT_WORKITEM_ID = ?";
    private static final String UPDATE_SQL = "UPDATE CWORKITEM SET PRIORITY = ?, RESPONSE = ?, DUEDATE = ?, END_TIME = ?, STATUS = ?, COLLABORATOR = ? WHERE CWORKITEM_ID = ?";
    private static final String REMOVE_CWORKITEM_SQL = "DELETE FROM CWORKITEM WHERE PARENT_WORKITEM_ID = ?";
    private static final String REMOVE_CSTEP_SQL = "DELETE FROM CSTEP WHERE PARENT_WORKITEM_ID = ?";
    private static final String REMOVE_CSTEPDS_SQL = "DELETE FROM CSTEP_DS WHERE PARENT_WORKITEM_ID = ?";

    protected static void onCreate(CommonEvent commonEvent) throws SQLException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            long cWorkItemID = BizLogicEventMap.getCWorkItemID(commonEvent);
            long cStepID = BizLogicEventMap.getCStepID(commonEvent);
            long wiid = BizLogicEventMap.getWorkitemID(commonEvent);
            long piid = BizLogicEventMap.getProcessInstanceID(commonEvent);
            long ptid = BizLogicEventMap.getProcessTemplateID(commonEvent);
            String cWorkItemName = BizLogicEventMap.getCWorkItemName(commonEvent);
            String collaborator = BizLogicEventMap.getCollaborator(commonEvent);
            String creator = BizLogicEventMap.getCreator(commonEvent);
            String instruction = BizLogicEventMap.getInstruction(commonEvent);
            String response = BizLogicEventMap.getResponse(commonEvent);
            String priority = BizLogicEventMap.getPriority(commonEvent);
            String status = (String)commonEvent.getContext().get("STATUS");
            String startTimeStr = BizLogicEventMap.getStartTime(commonEvent);
            Timestamp startTime = BSUtil.stringToTimestamp(startTimeStr);
            String dueDateStr = BizLogicEventMap.getDueDate(commonEvent);
            Timestamp dueDate = BSUtil.stringToTimestamp(dueDateStr);
            String endTimeStr = BizLogicEventMap.getEndTime(commonEvent);
            Timestamp endTime = BSUtil.stringToTimestamp(endTimeStr);
            int ix = 1;
            conn = BSControl.util.getBSConnection();
            pstmt = conn.prepareStatement(INSERT_CWORKITEM_SQL);
            pstmt.setLong(ix++, cWorkItemID);
            pstmt.setLong(ix++, cStepID);
            pstmt.setLong(ix++, wiid);
            pstmt.setLong(ix++, piid);
            pstmt.setLong(ix++, ptid);
            BSUtil.setValue(pstmt, 91, ix++, startTime);
            BSUtil.setValue(pstmt, 91, ix++, dueDate);
            BSUtil.setValue(pstmt, 91, ix++, endTime);
            pstmt.setString(ix++, cWorkItemName);
            pstmt.setString(ix++, collaborator);
            pstmt.setString(ix++, creator);
            pstmt.setString(ix++, priority);
            pstmt.setString(ix++, status);
            pstmt.setString(ix++, instruction);
            pstmt.setString(ix++, response);
            pstmt.executeUpdate();
        }
        catch (SQLException se) {
            try {
                BSControl.logger.errorKey("BizStore_MSG_1501", new Object[]{INSERT_CWORKITEM_SQL, se.getMessage()});
                throw se;
            }
            catch (Throwable throwable) {
                SBMDAOService.clean(null, pstmt, conn);
                throw throwable;
            }
        }
        SBMDAOService.clean(null, (Statement)pstmt, (Connection)conn);
    }

    protected static void onStatusChange(CommonEvent commonEvent) throws SQLException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            long cWorkItemID = BizLogicEventMap.getCWorkItemID(commonEvent);
            String collaborator = BizLogicEventMap.getCollaborator(commonEvent);
            String status = BizLogicEventMap.getStatusString(commonEvent);
            conn = BSControl.util.getBSConnection();
            pstmt = conn.prepareStatement(STATUS_CHANGE_SQL);
            pstmt.setString(1, collaborator);
            pstmt.setString(2, status);
            pstmt.setLong(3, cWorkItemID);
            pstmt.executeUpdate();
        }
        catch (SQLException se) {
            try {
                BSControl.logger.errorKey("BizStore_MSG_1501", new Object[]{STATUS_CHANGE_SQL, se.getMessage()});
                throw se;
            }
            catch (Throwable throwable) {
                SBMDAOService.clean(null, pstmt, conn);
                throw throwable;
            }
        }
        SBMDAOService.clean(null, (Statement)pstmt, (Connection)conn);
    }

    protected static void onUpdate(CommonEvent commonEvent) throws SQLException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            long cWorkItemID = BizLogicEventMap.getCWorkItemID(commonEvent);
            String priority = BizLogicEventMap.getPriority(commonEvent);
            String response = BizLogicEventMap.getResponse(commonEvent);
            String dueDateStr = BizLogicEventMap.getDueDate(commonEvent);
            Timestamp dueDate = BSUtil.stringToTimestamp(dueDateStr);
            String endTimeStr = BizLogicEventMap.getEndTime(commonEvent);
            Timestamp endTime = BSUtil.stringToTimestamp(endTimeStr);
            String status = BizLogicEventMap.getStatusString(commonEvent);
            String collaborator = BizLogicEventMap.getCollaborator(commonEvent);
            conn = BSControl.util.getBSConnection();
            pstmt = conn.prepareStatement(UPDATE_SQL);
            pstmt.setString(1, priority);
            pstmt.setString(2, response);
            BSUtil.setValue(pstmt, 91, 3, dueDate);
            BSUtil.setValue(pstmt, 91, 4, endTime);
            pstmt.setString(5, status);
            pstmt.setString(6, collaborator);
            pstmt.setLong(7, cWorkItemID);
            pstmt.executeUpdate();
        }
        catch (SQLException se) {
            try {
                BSControl.logger.errorKey("BizStore_MSG_1501", new Object[]{UPDATE_SQL, se.getMessage()});
                throw se;
            }
            catch (Throwable throwable) {
                SBMDAOService.clean(null, pstmt, conn);
                throw throwable;
            }
        }
        SBMDAOService.clean(null, (Statement)pstmt, (Connection)conn);
    }

    protected static void onCreatorUpdate(CommonEvent commonEvent) throws SQLException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            String prevPerf = BizLogicEventMap.getPreviousPerformer(commonEvent);
            String performer = BizLogicEventMap.getPerformer(commonEvent);
            if (prevPerf == null || performer == null || performer.equals(prevPerf)) {
                return;
            }
            long parentWIID = BizLogicEventMap.getWorkitemID(commonEvent);
            conn = BSControl.util.getBSConnection();
            pstmt = conn.prepareStatement(CREATOR_UPDATE_SQL);
            pstmt.setString(1, performer);
            pstmt.setLong(2, parentWIID);
            pstmt.executeUpdate();
            SBMDAOService.clean(null, (Statement)pstmt, (Connection)conn);
        }
        catch (SQLException se) {
            BSControl.logger.errorKey("BizStore_MSG_1501", new Object[]{CREATOR_UPDATE_SQL, se.getMessage()});
            throw se;
        }
        finally {
            SBMDAOService.clean(null, pstmt, conn);
        }
    }

    protected static void onRemove(CommonEvent commonEvent) throws SQLException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        String sql = null;
        try {
            String prevStatus = BizLogicEventMap.getPreviousStatus(commonEvent);
            int prevStatusIntValue = BizLogicEventMap.getMap(prevStatus);
            if (prevStatus == null || prevStatusIntValue != 31) {
                return;
            }
            long parentWIID = BizLogicEventMap.getWorkitemID(commonEvent);
            conn = BSControl.util.getBSConnection();
            sql = REMOVE_CWORKITEM_SQL;
            pstmt = conn.prepareStatement(sql);
            pstmt.setLong(1, parentWIID);
            pstmt.executeUpdate();
            SBMDAOService.clean(null, (Statement)pstmt, null);
            sql = REMOVE_CSTEPDS_SQL;
            pstmt = conn.prepareStatement(sql);
            pstmt.setLong(1, parentWIID);
            pstmt.executeUpdate();
            SBMDAOService.clean(null, (Statement)pstmt, null);
            sql = REMOVE_CSTEP_SQL;
            pstmt = conn.prepareStatement(sql);
            pstmt.setLong(1, parentWIID);
            pstmt.executeUpdate();
            SBMDAOService.clean(null, (Statement)pstmt, (Connection)conn);
        }
        catch (SQLException se) {
            BSControl.logger.errorKey("BizStore_MSG_1501", new Object[]{sql, se.getMessage()});
            throw se;
        }
        finally {
            SBMDAOService.clean(null, pstmt, conn);
        }
    }

    protected static void onCStepCreate(CommonEvent commonEvent) throws SQLException {
        Map<String, String> dataslots;
        int ix;
        long wiid;
        long piid;
        long ptid;
        long cStepID;
        PreparedStatement pstmt;
        Connection conn;
        block6: {
            conn = null;
            pstmt = null;
            cStepID = BizLogicEventMap.getCStepID(commonEvent);
            ptid = BizLogicEventMap.getProcessTemplateID(commonEvent);
            piid = BizLogicEventMap.getProcessInstanceID(commonEvent);
            wiid = BizLogicEventMap.getWorkitemID(commonEvent);
            conn = BSControl.util.getBSConnection();
            ix = 1;
            String cStepName = BizLogicEventMap.getCStepName(commonEvent);
            String dsAccess = BizLogicEventMap.getDataSlotAccessForCStep(commonEvent);
            pstmt = conn.prepareStatement(INSERT_CSTEP_SQL);
            pstmt.setLong(ix++, cStepID);
            pstmt.setLong(ix++, ptid);
            pstmt.setLong(ix++, piid);
            pstmt.setLong(ix++, wiid);
            pstmt.setString(ix++, dsAccess);
            pstmt.setString(ix++, cStepName);
            pstmt.executeUpdate();
            SBMDAOService.clean(null, (Statement)pstmt, null);
            dataslots = BizLogicEventMap.getCStepDataSlots(commonEvent);
            if (dataslots != null && !dataslots.isEmpty()) break block6;
            SBMDAOService.clean(null, (Statement)pstmt, (Connection)conn);
            return;
        }
        try {
            pstmt = conn.prepareStatement(INSERT_CSTEPDS_SQL);
            for (String dsName : dataslots.keySet()) {
                String eachDSAccess = dataslots.get(dsName);
                ix = 1;
                pstmt.setLong(ix++, cStepID);
                pstmt.setLong(ix++, ptid);
                pstmt.setLong(ix++, piid);
                pstmt.setLong(ix++, wiid);
                pstmt.setString(ix++, eachDSAccess);
                pstmt.setString(ix++, dsName);
                pstmt.executeUpdate();
            }
        }
        catch (SQLException se) {
            try {
                BSControl.logger.errorKey("BizStore_MSG_1501", new Object[]{INSERT_CSTEPDS_SQL, se.getMessage()});
                throw se;
            }
            catch (Throwable throwable) {
                SBMDAOService.clean(null, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SBMDAOService.clean(null, (Statement)pstmt, (Connection)conn);
    }
}

