/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.smp.util;

import com.savvion.sbm.bizlogic.scheduler.BLScheduler;
import com.savvion.sbm.bizlogic.smp.model.OperationType;
import com.savvion.sbm.util.LoggerUtil;
import com.savvion.sbm.util.SBMUtil;
import com.savvion.sbm.util.config.AbstractConfig;
import java.util.ArrayList;
import java.util.List;

public class SMPConfig
extends AbstractConfig {
    private static SMPConfig self = null;
    private static final String SMP_PROPERTY_FILE = "smp.properties";
    private static final String EVENT_TRIGGER_EXPRESSION = "smp.trigger.event.expression";
    private static final String EVENT_JOB_BATCH = "smp.job.event.batch";
    private static final String WAITWS_TRIGGER_EXPRESSION = "smp.trigger.waitws.expression";
    private static final String WAITWS_JOB_BATCH = "smp.job.waitws.batch";
    private static final String HISTORY_TRIGGER_EXPRESSION = "smp.trigger.history.expression";
    private static final String HISTORY_JOB_BATCH = "smp.job.history.batch";
    private static final String MAX_EVENT_RETRY = "smp.event.max.retrycount";
    private static final String EMAIL_TEMPLATE_TYPE = "smp.email.preferred.template.type";
    private static final String EVENT_BS_CHECK = "smp.event.bizstore.uniqueid.check";
    private static final String EVENT_RETRY_INTERVAL = "smp.event.retryinterval";
    private static final String EVENT_SELECT_SORTEDORDER = "smp.eventselection.sortedorder";
    private static final String INVALIDEVENT_EMAIL_NOTIFY = "smp.invalidevent.notify";
    private static final String INVALIDEVENT_EMAIL_IDS = "smp.invalidevent.notify.email";
    private static final String WSWAIT_UPDATEEVENT = "smp.wswait.updateevent";
    private static final String PROCESSEXTEVENT_FROM_GATEWAY = "smp.processinline.extevents.from.gateway";
    private static final String EXTEVENTHISTORY_ENABLED = "smp.enable.extevent.history";
    private static final String PROCESSEXTEVENT_FROM_BIZLOGIC = "smp.processinline.extevents.from.bizlogic";
    private static final String MAX_BULKMESSAGE_SIZE = "smp.bulk.message.max.size";
    private static final String FIRE_ACTIVATIONEVENT_ONCOMPLETION = "smp.fire.activationevent.oncompletion";
    private static final String MAX_EVENT_RETRY_INVALIDSTATE = "smp.event.invalidstate.max.retrycount";
    private static final String EVENT_RETRY_INTERVAL_INVALIDSTATE = "smp.event.invalidstate.retryinterval";
    private static final String EVENTS_TO_PROCESS_FROM_GATEWAY = "smp.events.to.process.from.gateway";
    private static final String ENABLE_WARNING_FOR_OPTIONAL_DATA = "smp.event.log.warning.enable";
    private static final String ENABLE_MULTITRANSACTION_WAITWSPROCESSOR = "smp.waitws.enable.multitrans";
    private String evtTriggerExpn = "0/15 * * * * ?";
    private String wsTriggerExpn = "0 0/1 * * * ?";
    private String historyTriggerExpn = "0 0/2 * * * ?";
    private String emailTemplateType = "htl";
    private boolean emailNotify = false;
    private List<String> emailIds = null;
    private boolean checkBizStore = true;
    private boolean isSortedEventSelection = true;
    private long eventRetryInterval = 180000L;
    private int evtJobBatch = 30;
    private int wsJobBatch = 500;
    private int historyJobBatch = 500;
    private long maxEventRetryCnt = 10L;
    private static final int MIN_BATCH_SIZE = 1;
    private static final int MAX_BATCH_SIZE = 900;
    private static final int MIN_EVENT_RETRY_CNT = -1;
    private boolean isUpdateEventForWSWait = true;
    private long maxInvalidSateEventRetryCnt = -1L;
    private long invalidSateEventRetryInterval = 3600000L;
    private static final String PURGEEVENT_TRIGGER_EXPRESSION = "smp.trigger.purgeevent.expression";
    private static final String PURGE_EVENT = "smp.purge.event";
    private static final String PURGE_EVENT_DURATION = "smp.purgeevent.created.before";
    private static final String DEFAULT_PURGE_EVENT_DURATION = "90d";
    private static final int DEFAULT_MAX_BULKMESSAGE_SIZE = 40;
    private boolean isPurgeEvents = false;
    private String purgeEvtTriggerExpn = "0 0 22 * * ?";
    private int purgeEventDuration = 90;
    private boolean processExtEventFromGW = true;
    private boolean extEventHistoryEnabled = false;
    private boolean processExtEventFromBL = true;
    private int maxBulkMessageSize;
    private final List<Integer> eventsToProcessFromGW = new ArrayList<Integer>();
    private boolean logWarningMessage = false;
    private boolean waitWSMultiTransEnabled = true;
    private boolean fireActivationEvent = false;

    private SMPConfig() {
        super(SMP_PROPERTY_FILE);
        this.validateProps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SMPConfig self() {
        if (self != null) return self;
        Class<SMPConfig> clazz = SMPConfig.class;
        synchronized (SMPConfig.class) {
            if (self != null) return self;
            self = new SMPConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return self;
        }
    }

    private void validateProps() {
        String propStr = "";
        if (this.config.containsKey(EVENT_TRIGGER_EXPRESSION)) {
            propStr = this.config.getString(EVENT_TRIGGER_EXPRESSION);
            if (!this.isValidString(propStr)) {
                throw new RuntimeException("Invalid value <" + propStr + "> specified for parameter <" + EVENT_TRIGGER_EXPRESSION + ">.");
            }
            this.evtTriggerExpn = propStr;
        }
        if (this.config.containsKey(WAITWS_TRIGGER_EXPRESSION)) {
            propStr = this.config.getString(WAITWS_TRIGGER_EXPRESSION);
            if (!this.isValidString(propStr)) {
                throw new RuntimeException("Invalid value <" + propStr + "> specified for parameter <" + WAITWS_TRIGGER_EXPRESSION + ">.");
            }
            this.wsTriggerExpn = propStr;
        }
        if (this.config.containsKey(HISTORY_TRIGGER_EXPRESSION)) {
            propStr = this.config.getString(HISTORY_TRIGGER_EXPRESSION);
            if (!this.isValidString(propStr)) {
                throw new RuntimeException("Invalid value <" + propStr + "> specified for parameter <" + HISTORY_TRIGGER_EXPRESSION + ">.");
            }
            this.historyTriggerExpn = propStr;
        }
        int batchSize = 0;
        if (this.config.containsKey(EVENT_JOB_BATCH)) {
            batchSize = this.config.getInt(EVENT_JOB_BATCH);
            if (batchSize < 1 || batchSize > 900) {
                throw new RuntimeException("Invalid value <" + batchSize + "> specified for parameter <" + EVENT_JOB_BATCH + ">. It should be between <" + 1 + "> and <" + 900 + ">");
            }
            this.evtJobBatch = batchSize;
        }
        if (this.config.containsKey(WAITWS_JOB_BATCH)) {
            batchSize = this.config.getInt(WAITWS_JOB_BATCH);
            if (batchSize < 1 || batchSize > 900) {
                throw new RuntimeException("Invalid value <" + batchSize + "> specified for parameter <" + WAITWS_JOB_BATCH + ">. It should be between <" + 1 + "> and <" + 900 + ">");
            }
            this.wsJobBatch = batchSize;
        }
        if (this.config.containsKey(HISTORY_JOB_BATCH)) {
            batchSize = this.config.getInt(HISTORY_JOB_BATCH);
            if (batchSize < 1 || batchSize > 900) {
                throw new RuntimeException("Invalid value <" + batchSize + "> specified for parameter <" + HISTORY_JOB_BATCH + ">. It should be between <" + 1 + "> and <" + 900 + ">");
            }
            this.historyJobBatch = batchSize;
        }
        if (this.config.containsKey(MAX_EVENT_RETRY)) {
            long cnt = this.config.getLong(MAX_EVENT_RETRY);
            if (cnt < -1L) {
                throw new RuntimeException("Invalid value <" + cnt + "> specified for parameter <" + MAX_EVENT_RETRY + ">. It should be greater than or equal to <" + -1 + ">");
            }
            this.maxEventRetryCnt = cnt;
        }
        if (this.config.containsKey(EMAIL_TEMPLATE_TYPE)) {
            propStr = this.config.getString(EMAIL_TEMPLATE_TYPE);
            if (!this.isValidString(propStr)) {
                throw new RuntimeException("Invalid value <" + propStr + "> specified for parameter <" + EMAIL_TEMPLATE_TYPE + ">.");
            }
            this.emailTemplateType = propStr;
        }
        if (this.config.containsKey(EVENT_BS_CHECK)) {
            this.checkBizStore = this.config.getBoolean(EVENT_BS_CHECK);
        }
        if (this.config.containsKey(EVENT_SELECT_SORTEDORDER)) {
            this.isSortedEventSelection = this.config.getBoolean(EVENT_SELECT_SORTEDORDER);
        }
        if (this.config.containsKey(EVENT_RETRY_INTERVAL)) {
            long interval = this.config.getLong(EVENT_RETRY_INTERVAL);
            this.eventRetryInterval = interval * 1000L;
        }
        if (this.config.containsKey(INVALIDEVENT_EMAIL_NOTIFY)) {
            this.emailNotify = this.config.getBoolean(INVALIDEVENT_EMAIL_NOTIFY, false);
        }
        if (this.emailNotify) {
            propStr = this.config.getString(INVALIDEVENT_EMAIL_IDS, "");
            if (this.isValidString(propStr)) {
                this.emailIds = SBMUtil.convertToStringList((String)propStr.trim(), (String)",");
            }
            if (this.emailIds == null || this.emailIds.isEmpty()) {
                this.emailNotify = false;
            }
        }
        if (this.config.containsKey(WSWAIT_UPDATEEVENT)) {
            this.isUpdateEventForWSWait = this.config.getBoolean(WSWAIT_UPDATEEVENT);
        }
        if (this.config.containsKey(PROCESSEXTEVENT_FROM_GATEWAY)) {
            this.processExtEventFromGW = this.config.getBoolean(PROCESSEXTEVENT_FROM_GATEWAY, true);
        }
        if (this.config.containsKey(EXTEVENTHISTORY_ENABLED)) {
            this.extEventHistoryEnabled = this.config.getBoolean(EXTEVENTHISTORY_ENABLED, false);
        }
        if (this.config.containsKey(PROCESSEXTEVENT_FROM_BIZLOGIC)) {
            this.processExtEventFromBL = this.config.getBoolean(PROCESSEXTEVENT_FROM_BIZLOGIC, true);
        }
        if (this.config.containsKey(MAX_BULKMESSAGE_SIZE)) {
            this.maxBulkMessageSize = this.config.getInt(MAX_BULKMESSAGE_SIZE, 40);
        }
        if (this.config.containsKey(FIRE_ACTIVATIONEVENT_ONCOMPLETION)) {
            this.fireActivationEvent = this.config.getBoolean(FIRE_ACTIVATIONEVENT_ONCOMPLETION, false);
        }
        if (this.config.containsKey(EVENTS_TO_PROCESS_FROM_GATEWAY)) {
            String eventsToProcess = this.config.getString(EVENTS_TO_PROCESS_FROM_GATEWAY, null);
            if (null == eventsToProcess || eventsToProcess.trim().length() <= 0) {
                this.populateAllOperations();
            } else {
                String[] eventIdArray = eventsToProcess.split(",");
                for (int idx = 0; idx < eventIdArray.length; ++idx) {
                    try {
                        Integer operationId = Integer.parseInt(eventIdArray[idx].trim());
                        this.validateOperationId(operationId);
                        this.eventsToProcessFromGW.add(operationId);
                        continue;
                    }
                    catch (Throwable th) {
                        LoggerUtil.logSOP((Object)("WARN: " + th.getMessage() + ": The member " + eventIdArray[idx].trim() + " of value " + eventsToProcess + " provided for property " + EVENTS_TO_PROCESS_FROM_GATEWAY + " in the configuration file " + SMP_PROPERTY_FILE + " is invalid. The value for this configuration parameter should be comma-separated operation type Ids. The valid Ids and their descriptions are as follows: <1: CREATE_INSTANCE>, <2: ACTIVATE_WORKSTEP>, <3: COMPLETE_WORKSTEP>, <4: UPDATE_DATASLOT>"));
                        this.populateAllOperations();
                        break;
                    }
                }
            }
        } else {
            this.populateAllOperations();
        }
        if (this.config.containsKey(ENABLE_WARNING_FOR_OPTIONAL_DATA)) {
            this.logWarningMessage = this.config.getBoolean(ENABLE_WARNING_FOR_OPTIONAL_DATA, false);
        }
        if (this.config.containsKey(ENABLE_MULTITRANSACTION_WAITWSPROCESSOR)) {
            this.waitWSMultiTransEnabled = this.config.getBoolean(ENABLE_MULTITRANSACTION_WAITWSPROCESSOR, true);
        }
        if (this.config.containsKey(MAX_EVENT_RETRY_INVALIDSTATE)) {
            long cnt = this.config.getLong(MAX_EVENT_RETRY_INVALIDSTATE);
            if (cnt < -1L) {
                throw new RuntimeException("Invalid value <" + cnt + "> specified for parameter <" + MAX_EVENT_RETRY_INVALIDSTATE + ">. It should be greater than or equal to <" + -1 + ">");
            }
            this.maxInvalidSateEventRetryCnt = cnt;
        }
        if (this.config.containsKey(EVENT_RETRY_INTERVAL_INVALIDSTATE)) {
            long interval = this.config.getLong(EVENT_RETRY_INTERVAL_INVALIDSTATE);
            this.invalidSateEventRetryInterval = interval * 1000L;
        }
        if (this.config.containsKey(PURGE_EVENT)) {
            this.isPurgeEvents = this.config.getBoolean(PURGE_EVENT, false);
        }
        if (this.config.containsKey(PURGEEVENT_TRIGGER_EXPRESSION)) {
            propStr = this.config.getString(PURGEEVENT_TRIGGER_EXPRESSION);
            if (!this.isValidString(propStr)) {
                throw new RuntimeException("Invalid value <" + propStr + "> specified for parameter <" + PURGEEVENT_TRIGGER_EXPRESSION + ">.");
            }
            this.purgeEvtTriggerExpn = propStr.trim();
        }
        if (this.config.containsKey(PURGE_EVENT_DURATION)) {
            propStr = this.config.getString(PURGE_EVENT_DURATION, DEFAULT_PURGE_EVENT_DURATION);
            this.purgeEventDuration = this.calculateCreateTimeBefore(propStr.trim());
        }
    }

    public boolean isWaitWSMultiTransEnabled() {
        return this.waitWSMultiTransEnabled;
    }

    public boolean logWarningMessage() {
        return this.logWarningMessage;
    }

    private void populateAllOperations() {
        for (OperationType operationType : OperationType.values()) {
            this.eventsToProcessFromGW.add(operationType.getId());
        }
    }

    private void validateOperationId(Integer operationId) {
        OperationType[] operationTypes;
        for (OperationType operationType : operationTypes = OperationType.values()) {
            if (operationType.getId() != operationId.intValue()) continue;
            return;
        }
        throw new RuntimeException("OperationType ID " + operationId + " is not valid!");
    }

    public boolean isProcessExtEventFromBL() {
        return this.processExtEventFromBL;
    }

    public int getMaxBulkMessageSize() {
        return this.maxBulkMessageSize;
    }

    public boolean isFireActivationEvent() {
        return this.fireActivationEvent;
    }

    public String getEventTriggerExpression() {
        return this.evtTriggerExpn;
    }

    public int getEventJobBatch() {
        return this.evtJobBatch;
    }

    public String getWaitWSTriggerExpression() {
        return this.wsTriggerExpn;
    }

    public int getWaitWSJobBatch() {
        return this.wsJobBatch;
    }

    public String getHistoryTriggerExpression() {
        return this.historyTriggerExpn;
    }

    public int getHistoryJobBatch() {
        return this.historyJobBatch;
    }

    public long getMaxEventRetryCount() {
        return this.maxEventRetryCnt;
    }

    public String getEmailTemplateType() {
        return this.emailTemplateType;
    }

    public boolean isCheckBizStoreForUniqueId() {
        return this.checkBizStore;
    }

    public boolean isEmailNotify() {
        return this.emailNotify;
    }

    public List<String> getEmailIds() {
        return this.emailIds;
    }

    private boolean isValidString(String str) {
        return str != null && str.trim().length() != 0;
    }

    public boolean isSortedEventSelection() {
        return this.isSortedEventSelection;
    }

    public long getEventRetryInterval() {
        return this.eventRetryInterval;
    }

    public boolean isUpdateEventForWaitWS() {
        return this.isUpdateEventForWSWait;
    }

    public long getInvalidStateEventRetryInterval() {
        return this.invalidSateEventRetryInterval;
    }

    public long getMaxInvalidStateEventRetryCount() {
        return this.maxInvalidSateEventRetryCnt;
    }

    public boolean checkMaxInvalidStateEventRetryCount() {
        return this.getMaxInvalidStateEventRetryCount() != -1L;
    }

    public boolean checkMaxEventRetryCount() {
        return this.getMaxEventRetryCount() != -1L;
    }

    public boolean isPurgeEvents() {
        return this.isPurgeEvents;
    }

    public String getPurgeEventTriggerExpression() {
        return this.purgeEvtTriggerExpn;
    }

    public int getPurgeEventDuration() {
        return this.purgeEventDuration;
    }

    public boolean isInlineProcessAtGateway() {
        return this.processExtEventFromGW;
    }

    public boolean isExtEventHistoryEnabled() {
        return this.extEventHistoryEnabled;
    }

    public boolean isInlineProcessAtGatewayOfEventType(OperationType operationType) {
        return this.eventsToProcessFromGW.contains(operationType.getId());
    }

    private int calculateCreateTimeBefore(String days) {
        if (!this.isValidString(days) && !days.endsWith("d") && days.length() <= 1) {
            throw new RuntimeException("For purging events, the created before value specified is either [null] or not in format [1d].");
        }
        int actualDays = 0;
        try {
            actualDays = Integer.valueOf(days.substring(0, days.length() - 1));
        }
        catch (Throwable th) {
            throw new RuntimeException("Invalid created before value [" + actualDays + "] specified for purging events.", th);
        }
        if (actualDays <= 0) {
            throw new RuntimeException("Created before value specified for purging events should be greater than 0.");
        }
        return actualDays;
    }

    public synchronized void refresh() {
        self = null;
        if (SMPConfig.self().isPurgeEvents()) {
            BLScheduler.self().resumeJob("PurgeEventJob", "MonitoringJobGroup");
        } else {
            BLScheduler.self().pauseJob("PurgeEventJob", "MonitoringJobGroup", "PurgeEventTrigger", "MonitoringTriggerGroup");
        }
    }
}

