/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.smp.util;

import com.savvion.sbm.bizlogic.email.EmailTemplate;
import com.savvion.sbm.bizlogic.email.REManager;
import com.savvion.sbm.bizlogic.smp.MPService;
import com.savvion.sbm.bizlogic.smp.model.OperationType;
import com.savvion.sbm.bizlogic.smp.util.MPUtil;
import com.savvion.sbm.bizlogic.smp.util.MonitoringProcessException;
import com.savvion.sbm.bizlogic.smp.util.SMPConfig;
import com.savvion.sbm.util.SBMUtil;
import com.tdiinc.common.Emailer.SendEmail;
import com.tdiinc.common.Emailer.SendEmailRef;
import com.tdiinc.common.Emailer.SendHtmlEmail;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MPEmailService {
    private static MPEmailService self = null;
    private String defaultTemplatePath = null;
    private EmailTemplate defaultTemplate;

    private MPEmailService() {
        this.setDefaultTemplate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MPEmailService self() {
        if (null != self) return self;
        Class<MPEmailService> clazz = MPEmailService.class;
        synchronized (MPEmailService.class) {
            if (null != self) return self;
            self = new MPEmailService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return self;
        }
    }

    public void notifyInvalidEvent(List<String> emailIds, Map<String, Object> eventData) {
        if (eventData == null || eventData.isEmpty()) {
            throw (MonitoringProcessException)((Object)MPService.self().getMonitoringProcessES().createException("BM_MPCM401", "MPEmailServervice.notifyInvalidEvent(List<String>,Map<String,Object>)"));
        }
        if (emailIds == null || emailIds.isEmpty()) {
            throw (MonitoringProcessException)((Object)MPService.self().getMonitoringProcessES().createException("BM_MPCM402", "MPEmailServervice.notifyInvalidEvent(List<String>,Map<String,Object>)"));
        }
        Map<String, Object> eventAttributes = this.getEventAttributes(eventData);
        String emailData = this.prepareEmailData(eventAttributes);
        int emailSubjectIdx = emailData.indexOf("$EMAIL.SUBJECT");
        String emailContent = "";
        if (emailSubjectIdx != -1) {
            emailContent = emailData.substring(0, emailSubjectIdx);
        }
        String subject = this.prepareEmailSubject(emailData.substring(emailSubjectIdx), eventData);
        this.sendMail(emailIds, subject, emailContent, this.defaultTemplate);
    }

    private Map<String, Object> getEventAttributes(Map<String, Object> eventData) {
        HashMap<String, Object> eventAttributes = new HashMap<String, Object>();
        try {
            Map dataSlots;
            HashMap<String, Object> context = new HashMap<String, Object>();
            Map message = (Map)eventData.get("MESSAGE");
            if (message != null && !message.isEmpty() && (dataSlots = (Map)message.get("DATASLOT")) != null && !dataSlots.isEmpty()) {
                context.putAll(dataSlots);
            }
            eventAttributes.put("EECTX.EIID", this.getValidValue(eventData.get("EXTERNAL_INSTANCE_ID")));
            eventAttributes.put("EECTX.PROCESS_NAME", this.getValidValue(eventData.get("PROCESS_NAME")));
            eventAttributes.put("EECTX.WORKSTEP_NAME", this.getValidValue(eventData.get("WORKSTEP_NAME")));
            eventAttributes.put("EECTX.SENDER", this.getValidValue(eventData.get("SENDER")));
            String operationType = OperationType.getType((Integer)eventData.get("OPERATION_TYPE")).getDescription();
            eventAttributes.put("EECTX.OPERATION_TYPE", operationType);
            eventAttributes.put("EECTX.REASON", this.getValidValue(eventData.get("REASON")));
            context.put("CREATE_TIME", this.getValidValue(eventData.get("CREATE_TIME")));
            context.put("RECEIVED_TIME", this.getValidValue(eventData.get("RECEIVED_TIME")));
            if ("htl".equalsIgnoreCase(SMPConfig.self().getEmailTemplateType())) {
                eventAttributes.put("EECTX.CONTEXT_TABLE", this.getHTMLContext(context));
            } else {
                eventAttributes.put("EECTX.CONTEXT", this.getEventContext(context));
            }
        }
        catch (Throwable th) {
            throw (MonitoringProcessException)((Object)MPService.self().getMonitoringProcessES().createException("BM_MPCM403", "MPEmailServervice.getEventAttributes(Map<String,Object>)", new Object[]{MPUtil.getInvalidEvtCtx(eventData)}, th));
        }
        return eventAttributes;
    }

    private String getEventContext(Map<String, Object> eventCtxAttributes) {
        StringBuilder text = new StringBuilder();
        Set<String> keys = eventCtxAttributes.keySet();
        for (String key : keys) {
            text.append("   ").append(key);
            text.append(" = ");
            text.append(eventCtxAttributes.get(key));
            text.append(System.getProperty("line.separator"));
        }
        return text.toString();
    }

    private String prepareEmailData(Map<String, Object> eventData) {
        return REManager.self().fillFormalReferences(this.defaultTemplate.getContent(), eventData);
    }

    private String prepareEmailSubject(String text, Map<String, Object> eventData) {
        String subject = null;
        int idx = text.indexOf("=");
        if (text.length() > idx + 1) {
            subject = text.substring(idx + 1, text.length());
        }
        if (subject == null || "".equals(subject.trim())) {
            subject = this.getDefaultSubject(eventData);
        }
        return subject;
    }

    private String getDefaultSubject(Map<String, Object> eventData) {
        StringBuilder subject = new StringBuilder();
        String operationType = OperationType.getType((Integer)eventData.get("OPERATION_TYPE")).getDescription();
        subject.append("InvalidExternal Event");
        subject.append(" <").append((String)eventData.get("EXTERNAL_INSTANCE_ID")).append(":");
        subject.append((String)eventData.get("PROCESS_NAME")).append(":");
        subject.append((String)eventData.get("WORKSTEP_NAME")).append(":");
        subject.append(operationType).append(">");
        return subject.toString();
    }

    private void sendMail(List<String> emailIds, String subject, String content, EmailTemplate template) {
        try {
            if (template.isHtml()) {
                SendEmailRef sm = this.createHtmlEmailerInstance(template, content);
                for (String emailId : emailIds) {
                    sm.addMailTo(emailId);
                }
                sm.setMailFrom(SBMUtil.self().getAdminEmailId());
                sm.setSubject(subject);
                sm.send();
            } else {
                SendEmailRef sm = this.createTextEmailerInstance();
                for (String emailId : emailIds) {
                    sm.addMailTo(emailId);
                }
                sm.setMailFrom(SBMUtil.self().getAdminEmailId());
                sm.setSubject(subject);
                sm.setText(content);
                sm.send();
            }
        }
        catch (Throwable th) {
            throw (MonitoringProcessException)((Object)MPService.self().getMonitoringProcessES().createException("BM_MPCM404", "MPEmailServervice.sendMail(List<String>,String,String)", new Object[]{emailIds, subject, content}, th));
        }
    }

    private SendEmailRef createTextEmailerInstance() {
        return new SendEmail(SBMUtil.self().getOutgoingMailUser(), SBMUtil.self().getOutgoingMailPassword(), SBMUtil.self().getOutgoingMailCharset(), SBMUtil.self().getOutgoingMailServerProps());
    }

    private SendEmailRef createHtmlEmailerInstance(EmailTemplate template, String content) {
        SendHtmlEmail sm;
        SendHtmlEmail shm = sm = new SendHtmlEmail(SBMUtil.self().getOutgoingMailUser(), SBMUtil.self().getOutgoingMailPassword(), SBMUtil.self().getOutgoingMailCharset(), SBMUtil.self().getOutgoingMailServerProps());
        shm.setContent(content);
        Hashtable inlineImages = template.getHtmlImages();
        if (inlineImages != null && !inlineImages.isEmpty()) {
            Set set = inlineImages.entrySet();
            for (Map.Entry element : set) {
                shm.addHtmlImage((URL)element.getKey(), (String)element.getValue());
            }
        }
        return sm;
    }

    private void setDefaultTemplate() {
        this.defaultTemplatePath = SBMUtil.self().getSBMAppsDir() + "common/templates/email/";
        String templateFile = null;
        templateFile = "htl".equalsIgnoreCase(SMPConfig.self().getEmailTemplateType()) ? this.defaultTemplatePath + "externalevent.htl" : this.defaultTemplatePath + "externalevent.etl";
        if (!this.isValidFile(templateFile)) {
            throw (MonitoringProcessException)((Object)MPService.self().getMonitoringProcessES().createException("BM_MPCM405", "MPEmailService.setDefaultTemplate()", new Object[]{templateFile}));
        }
        this.defaultTemplate = new EmailTemplate(templateFile);
    }

    private String getHTMLContext(Map<String, Object> context) {
        StringBuilder htmlTable = new StringBuilder();
        if (context == null || context.size() < 0) {
            return htmlTable.toString();
        }
        Set<String> keys = context.keySet();
        htmlTable.append("<table border=1 cellpadding=2 cellspacing=0>");
        htmlTable.append("<tr><td align='left'><b>Context Key</b></td><td align='left'><b>Context Value</b></td></tr>");
        for (String key : keys) {
            htmlTable.append("<tr>");
            htmlTable.append("<td align='left' nowrap><b>").append(key).append("</b></td>");
            htmlTable.append("<td align='left' nowrap>").append(this.getValidValue(context.get(key))).append("</td>");
            htmlTable.append("</tr>");
        }
        htmlTable.append("</table>");
        return htmlTable.toString();
    }

    public List<String> prepareEmailIds(Map<String, Object> invalidEvent) {
        ArrayList<String> emailIds = new ArrayList<String>();
        emailIds.addAll(MPUtil.convertToStringList((String)invalidEvent.get("NOTIFY_EMAILS")));
        if (SMPConfig.self().isEmailNotify()) {
            emailIds.addAll(SMPConfig.self().getEmailIds());
        }
        return emailIds;
    }

    private boolean isValidFile(String path) {
        File file = new File(path);
        return file.exists() && file.canRead();
    }

    public static synchronized void clean() {
        self = null;
    }

    private String getValidValue(Object obj) {
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }
}

