/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.smp.persistence.dao;

import com.savvion.sbm.bizlogic.smp.MPService;
import com.savvion.sbm.bizlogic.smp.model.OperationType;
import com.savvion.sbm.bizlogic.smp.util.MPUtil;
import com.savvion.sbm.bizlogic.smp.util.MonitoringProcessException;
import com.savvion.sbm.util.DBService;
import com.savvion.sbm.util.ExceptionService;
import com.savvion.sbm.util.SBMConstants;
import com.savvion.sbm.util.logger.SBMLogger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MonitorWaitWorkStepDAO
extends DBService {
    private static final String[] CREATE_LIST = new String[]{"PROCESS_INSTANCE_ID", "WORKSTEP_ID", "LOOP_COUNTER", "PROCESS_TEMPLATE_NAME", "EXTERNAL_INSTANCE_ID", "WORKSTEP_NAME", "PROCESS_TEMPLATE_ID", "WAIT_FOR_ACTIVATEEVENT"};
    private static String createwaitwsinstance = null;
    private static String removewaitwsinstance = null;
    private static String removewaitpiinstance = null;
    private static String removewaitpt = null;
    private static String getWaitWSAttributes = null;
    private static String updateWaitForActivation = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void create(Connection conn, Map<String, Object> attrsList) {
        if (conn == null) {
            throw (MonitoringProcessException)((Object)MonitorWaitWorkStepDAO.getMonitoringPrcExSvc().createException("BM_MPCM122", "MonitorWaitWorkStepDAO.create(Map)"));
        }
        String key = null;
        Object value = null;
        PreparedStatement pstmtCreateWaitWorkStep = null;
        try {
            pstmtCreateWaitWorkStep = conn.prepareStatement(createwaitwsinstance);
            for (int idx = 0; idx < CREATE_LIST.length; ++idx) {
                key = CREATE_LIST[idx];
                value = attrsList.get(key);
                if (key.equalsIgnoreCase("PROCESS_INSTANCE_ID")) {
                    if (value == null) {
                        pstmtCreateWaitWorkStep.setNull(idx + 1, -5);
                        continue;
                    }
                    pstmtCreateWaitWorkStep.setLong(idx + 1, (Long)value);
                    continue;
                }
                if (key.equalsIgnoreCase("WORKSTEP_ID")) {
                    if (value == null) {
                        pstmtCreateWaitWorkStep.setNull(idx + 1, -5);
                        continue;
                    }
                    pstmtCreateWaitWorkStep.setLong(idx + 1, (Long)value);
                    continue;
                }
                if (key.equalsIgnoreCase("LOOP_COUNTER")) {
                    if (value == null) {
                        pstmtCreateWaitWorkStep.setNull(idx + 1, 4);
                        continue;
                    }
                    pstmtCreateWaitWorkStep.setInt(idx + 1, (Integer)value);
                    continue;
                }
                if (key.equalsIgnoreCase("PROCESS_TEMPLATE_NAME") || key.equalsIgnoreCase("EXTERNAL_INSTANCE_ID") || key.equalsIgnoreCase("WORKSTEP_NAME")) {
                    if (value == null) {
                        pstmtCreateWaitWorkStep.setNull(idx + 1, 12);
                        continue;
                    }
                    pstmtCreateWaitWorkStep.setString(idx + 1, (String)value);
                    continue;
                }
                if (key.equalsIgnoreCase("PROCESS_TEMPLATE_ID")) {
                    if (value == null) {
                        pstmtCreateWaitWorkStep.setNull(idx + 1, -5);
                        continue;
                    }
                    pstmtCreateWaitWorkStep.setLong(idx + 1, (Long)value);
                    continue;
                }
                if (!key.equalsIgnoreCase("WAIT_FOR_ACTIVATEEVENT")) continue;
                if (value == null) {
                    value = SBMConstants.Boolean.FALSE.intValue();
                }
                pstmtCreateWaitWorkStep.setInt(idx + 1, (Integer)value);
            }
            if (MPUtil.isDebug()) {
                MPService.self().getLogger().debugKey("BM_MPCM125", new Object[]{createwaitwsinstance, attrsList});
            }
            pstmtCreateWaitWorkStep.executeUpdate();
        }
        catch (Throwable th) {
            MPUtil.handleThrowable("BM_MPCM203", "MonitorWaitWorkStepDAO.create(Map)", new Object[]{attrsList}, th);
        }
        finally {
            MonitorWaitWorkStepDAO.clean(null, (Statement)pstmtCreateWaitWorkStep, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(Connection conn, long piid, long wsid, int loopcounter) {
        if (conn == null) {
            throw (MonitoringProcessException)((Object)MonitorWaitWorkStepDAO.getMonitoringPrcExSvc().createException("BM_MPCM122", "MonitorWaitWorkStepDAO.remove(long, long, int)"));
        }
        PreparedStatement pstmtRemovewaitwsinstance = null;
        try {
            pstmtRemovewaitwsinstance = conn.prepareStatement(removewaitwsinstance);
            pstmtRemovewaitwsinstance.setLong(1, piid);
            pstmtRemovewaitwsinstance.setLong(2, wsid);
            pstmtRemovewaitwsinstance.setInt(3, loopcounter);
            if (MPUtil.isDebug()) {
                StringBuilder ctx = new StringBuilder().append(piid).append(" ").append(wsid).append(" ").append(wsid);
                MPService.self().getLogger().debugKey("BM_MPCM125", new Object[]{removewaitwsinstance, ctx.toString()});
            }
            pstmtRemovewaitwsinstance.executeUpdate();
        }
        catch (Throwable th) {
            MPUtil.handleThrowable("BM_MPCM208", "MonitorWaitWorkStepDAO.remove(long, long, int)", new Object[]{piid, wsid, loopcounter}, th);
        }
        finally {
            MonitorWaitWorkStepDAO.clean(null, (Statement)pstmtRemovewaitwsinstance, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(Connection conn, long piid) {
        if (conn == null) {
            throw (MonitoringProcessException)((Object)MonitorWaitWorkStepDAO.getMonitoringPrcExSvc().createException("BM_MPCM122", "MonitorWaitWorkStepDAO.remove(long)"));
        }
        PreparedStatement pstmtRemovewaitpiinstance = null;
        try {
            pstmtRemovewaitpiinstance = conn.prepareStatement(removewaitpiinstance);
            pstmtRemovewaitpiinstance.setLong(1, piid);
            if (MPUtil.isDebug()) {
                MPService.self().getLogger().debugKey("BM_MPCM125", new Object[]{removewaitpiinstance, piid});
            }
            pstmtRemovewaitpiinstance.executeUpdate();
        }
        catch (Throwable th) {
            MPUtil.handleThrowable("BM_MPCM207", "MonitorWaitWorkStepDAO.remove(long)", new Object[]{piid}, th);
        }
        finally {
            MonitorWaitWorkStepDAO.clean(null, (Statement)pstmtRemovewaitpiinstance, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(Connection conn, String ptName) {
        if (conn == null) {
            throw (MonitoringProcessException)((Object)MonitorWaitWorkStepDAO.getMonitoringPrcExSvc().createException("BM_MPCM122", "MonitorWaitWorkStepDAO.remove(String)"));
        }
        PreparedStatement pstmtRemovewaitpt = null;
        try {
            pstmtRemovewaitpt = conn.prepareStatement(removewaitpt);
            pstmtRemovewaitpt.setString(1, ptName);
            if (MPUtil.isDebug()) {
                MPService.self().getLogger().debugKey("BM_MPCM125", new Object[]{removewaitpt, ptName});
            }
            pstmtRemovewaitpt.executeUpdate();
        }
        catch (Throwable th) {
            MPUtil.handleThrowable("BM_MPCM206", "MonitorWaitWorkStepDAO.remove(String)", new Object[]{ptName}, th);
        }
        finally {
            MonitorWaitWorkStepDAO.clean(null, (Statement)pstmtRemovewaitpt, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateEIID(Connection conn, long piid, String eiidValue) {
        if (conn == null) {
            throw (MonitoringProcessException)((Object)MonitorWaitWorkStepDAO.getMonitoringPrcExSvc().createException("BM_MPCM122", "MonitorWaitWorkStepDAO.updateEIID"));
        }
        StringBuilder ctx = new StringBuilder(eiidValue).append(" ").append(piid);
        StringBuilder updateWait = new StringBuilder(500);
        updateWait.append("UPDATE ");
        updateWait.append("MONITORING_WAIT_WORKSTEP");
        updateWait.append(" SET ");
        updateWait.append("EXTERNAL_INSTANCE_ID");
        updateWait.append(" = ? ");
        updateWait.append(" WHERE ");
        updateWait.append("PROCESS_INSTANCE_ID");
        updateWait.append(" = ?");
        PreparedStatement pstmtUpdateWait = null;
        try {
            pstmtUpdateWait = conn.prepareStatement(updateWait.toString());
            if (MPUtil.isDebug()) {
                MPService.self().getLogger().debugKey("BM_MPCM125", new Object[]{updateWait.toString(), ctx.toString()});
            }
            pstmtUpdateWait.setString(1, eiidValue);
            pstmtUpdateWait.setLong(2, piid);
            pstmtUpdateWait.executeUpdate();
        }
        catch (Throwable th) {
            MPUtil.handleThrowable("BM_MPCM205", "MonitorWaitWorkStepDAO.updateEIID", new Object[]{eiidValue, piid}, th);
        }
        finally {
            MonitorWaitWorkStepDAO.clean(null, (Statement)pstmtUpdateWait, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, Object>> getAttributes(Connection conn, int batchSize) {
        if (conn == null) {
            throw (MonitoringProcessException)((Object)MonitorWaitWorkStepDAO.getMonitoringPrcExSvc().createException("BM_MPCM122", "MonitorWaitWorkStepDAO.getAttributes"));
        }
        ArrayList<Map<String, Object>> waitWSList = new ArrayList<Map<String, Object>>();
        HashMap<String, Number> waitWSAttributes = null;
        PreparedStatement pstmtGetWaitWSAttributes = null;
        ResultSet rs = null;
        StringBuilder selectAttrs = new StringBuilder(getWaitWSAttributes);
        try {
            pstmtGetWaitWSAttributes = conn.prepareStatement(selectAttrs.toString());
            pstmtGetWaitWSAttributes.setMaxRows(batchSize);
            pstmtGetWaitWSAttributes.setFetchSize(batchSize);
            if (MPUtil.isDebug()) {
                MPService.self().getLogger().debugKey("BM_MPCM125", new Object[]{selectAttrs.toString()});
            }
            rs = pstmtGetWaitWSAttributes.executeQuery();
            while (rs.next()) {
                waitWSAttributes = new HashMap<String, Number>();
                waitWSAttributes.put("EVENT_ID", rs.getLong("EVENT_ID"));
                waitWSAttributes.put("PROCESS_INSTANCE_ID", rs.getLong("PROCESS_INSTANCE_ID"));
                waitWSAttributes.put("WORKSTEP_ID", rs.getLong("WORKSTEP_ID"));
                waitWSAttributes.put("LOOP_COUNTER", rs.getInt("LOOP_COUNTER"));
                waitWSAttributes.put("PROCESS_TEMPLATE_ID", rs.getLong("PROCESS_TEMPLATE_ID"));
                waitWSList.add(waitWSAttributes);
            }
        }
        catch (Throwable th) {
            try {
                MPUtil.handleThrowable("BM_MPCM219", "MonitorWaitWorkStepDAO.getAttributes", null, th);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                MonitorWaitWorkStepDAO.clean(rs, (Statement)pstmtGetWaitWSAttributes, null);
            }
        }
        MonitorWaitWorkStepDAO.clean((ResultSet)rs, (Statement)pstmtGetWaitWSAttributes, null);
        return waitWSList;
    }

    public static synchronized void initSQLStatements() {
        int idx = 0;
        StringBuilder sb = new StringBuilder(220);
        sb.append("INSERT INTO ");
        sb.append("MONITORING_WAIT_WORKSTEP");
        sb.append(" (");
        for (idx = 0; idx < CREATE_LIST.length; ++idx) {
            sb.append(CREATE_LIST[idx]);
            if (idx == CREATE_LIST.length - 1) continue;
            sb.append(", ");
        }
        sb.append(") VALUES (");
        for (idx = 0; idx < CREATE_LIST.length; ++idx) {
            sb.append("?");
            if (idx == CREATE_LIST.length - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        createwaitwsinstance = sb.toString();
        sb = new StringBuilder();
        sb.append("DELETE FROM ");
        sb.append("MONITORING_WAIT_WORKSTEP");
        sb.append(" WHERE ");
        sb.append("PROCESS_INSTANCE_ID").append(" = ? AND ");
        sb.append("WORKSTEP_ID").append(" = ? AND ");
        sb.append("LOOP_COUNTER").append(" = ?");
        removewaitwsinstance = sb.toString();
        sb = new StringBuilder();
        sb.append("DELETE FROM ");
        sb.append("MONITORING_WAIT_WORKSTEP");
        sb.append(" WHERE ");
        sb.append("PROCESS_INSTANCE_ID").append(" = ?");
        removewaitpiinstance = sb.toString();
        sb = new StringBuilder();
        sb.append("DELETE FROM ");
        sb.append("MONITORING_WAIT_WORKSTEP");
        sb.append(" WHERE ");
        sb.append("PROCESS_TEMPLATE_NAME").append(" = ?");
        removewaitpt = sb.toString();
        sb = new StringBuilder();
        sb.append("SELECT ");
        sb.append("BEE.").append("EVENT_ID").append(", ");
        sb.append("MWW.").append("PROCESS_INSTANCE_ID").append(", ");
        sb.append("MWW.").append("WORKSTEP_ID").append(", ");
        sb.append("MWW.").append("LOOP_COUNTER").append(", ");
        sb.append("MWW.").append("PROCESS_TEMPLATE_ID");
        sb.append(" FROM ");
        sb.append("MONITORING_WAIT_WORKSTEP");
        sb.append(" MWW, ");
        sb.append("BIZEVENT_EXTERNAL");
        sb.append(" BEE ");
        sb.append(MonitorWaitWorkStepDAO.getWhereClause());
        getWaitWSAttributes = sb.toString();
        sb = new StringBuilder();
        sb.append(" UPDATE ");
        sb.append("MONITORING_WAIT_WORKSTEP");
        sb.append(" SET ");
        sb.append("WAIT_FOR_ACTIVATEEVENT");
        sb.append(" = ? ");
        sb.append(" WHERE ");
        sb.append("PROCESS_INSTANCE_ID");
        sb.append(" = ? ");
        sb.append(" AND ");
        sb.append("WORKSTEP_ID");
        sb.append(" = ? ");
        sb.append(" AND ");
        sb.append("LOOP_COUNTER");
        sb.append(" = ? ");
        updateWaitForActivation = sb.toString();
        if (MPUtil.isDebug()) {
            MonitorWaitWorkStepDAO.printSQLStatements();
        }
    }

    public static void printSQLStatements() {
        String initStatement = "Init SQL Statement: ";
        MonitorWaitWorkStepDAO.getLogger().debug((Object)"MonitorWaitWorkStepDAO:");
        MonitorWaitWorkStepDAO.getLogger().debug((Object)(initStatement + createwaitwsinstance));
        MonitorWaitWorkStepDAO.getLogger().debug((Object)(initStatement + removewaitwsinstance));
        MonitorWaitWorkStepDAO.getLogger().debug((Object)(initStatement + removewaitpiinstance));
        MonitorWaitWorkStepDAO.getLogger().debug((Object)(initStatement + removewaitpt));
        MonitorWaitWorkStepDAO.getLogger().debug((Object)(initStatement + getWaitWSAttributes));
        MonitorWaitWorkStepDAO.getLogger().debug((Object)(initStatement + updateWaitForActivation));
    }

    private static ExceptionService<MonitoringProcessException> getMonitoringPrcExSvc() {
        return MPService.self().getMonitoringProcessES();
    }

    private static SBMLogger getLogger() {
        return MPService.self().getLogger();
    }

    private static String getWhereClause() {
        StringBuilder whereClause = new StringBuilder(100);
        whereClause.append(" WHERE ");
        whereClause.append("MWW.").append("EXTERNAL_INSTANCE_ID").append(" IS NOT NULL ");
        whereClause.append(" AND ").append(" MWW.").append("PROCESS_TEMPLATE_NAME").append(" = ");
        whereClause.append(" BEE.").append("PROCESS_NAME");
        whereClause.append(" AND ").append(" MWW.").append("EXTERNAL_INSTANCE_ID").append(" = ");
        whereClause.append(" BEE.").append("EXTERNAL_INSTANCE_ID");
        whereClause.append(" AND ").append(" MWW.").append("WORKSTEP_NAME").append(" = ");
        whereClause.append(" BEE.").append("WORKSTEP_NAME");
        whereClause.append(" AND ").append(" BEE.").append("READY_TO_PROCESS").append(" = ").append(" 0 ");
        whereClause.append(" AND ");
        whereClause.append(" (").append(" BEE.").append("LOOP_COUNTER").append(" = 0 OR ");
        whereClause.append(" (").append(" BEE.").append("LOOP_COUNTER").append(" > 0 AND ");
        whereClause.append(" BEE.").append("LOOP_COUNTER").append(" = ");
        whereClause.append(" MWW.").append("LOOP_COUNTER").append(") ").append(") ");
        whereClause.append(" AND ");
        whereClause.append(" (MWW.").append("WAIT_FOR_ACTIVATEEVENT").append(" = ");
        whereClause.append(SBMConstants.Boolean.FALSE.intValue()).append(" OR ");
        whereClause.append(" (MWW.").append("WAIT_FOR_ACTIVATEEVENT").append(" = ");
        whereClause.append(SBMConstants.Boolean.TRUE.intValue()).append(" AND ");
        whereClause.append(" BEE.").append("OPERATION_TYPE").append(" = ").append(OperationType.ACTIVATE_WORKSTEP.getId()).append(") ").append(") ");
        whereClause.append(" ORDER BY ").append(" BEE.").append("CREATE_TIME");
        return whereClause.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateWaitForActivation(long piid, long wsid, int loopCounter, int waitForActivateEvent, Connection conn) {
        if (conn == null) {
            throw (MonitoringProcessException)((Object)MonitorWaitWorkStepDAO.getMonitoringPrcExSvc().createException("BM_MPCM122", "MonitorWaitWorkStepDAO.updateWaitForActivation"));
        }
        PreparedStatement pstmtUpdateWait = null;
        try {
            pstmtUpdateWait = conn.prepareStatement(updateWaitForActivation);
            if (MPUtil.isDebug()) {
                MPService.self().getLogger().debugKey("BM_MPCM125", new Object[]{updateWaitForActivation, MonitorWaitWorkStepDAO.getParamsAsString(piid, wsid, loopCounter, waitForActivateEvent)});
            }
            pstmtUpdateWait.setInt(1, waitForActivateEvent);
            pstmtUpdateWait.setLong(2, piid);
            pstmtUpdateWait.setLong(3, wsid);
            pstmtUpdateWait.setInt(4, loopCounter);
            pstmtUpdateWait.executeUpdate();
        }
        catch (Throwable th) {
            MPUtil.handleThrowable("BM_MPCM503", "MonitorWaitWorkStepDAO.updateWaitForActivation", new Object[]{updateWaitForActivation, MonitorWaitWorkStepDAO.getParamsAsString(piid, wsid, loopCounter, waitForActivateEvent)}, th);
        }
        finally {
            MonitorWaitWorkStepDAO.clean(null, (Statement)pstmtUpdateWait, null);
        }
    }

    private static String getParamsAsString(Object ... params) {
        if (null == params) {
            return "";
        }
        return Arrays.asList(params).toString();
    }
}

