/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.smp.persistence.dao;

import com.savvion.sbm.bizlogic.smp.MPService;
import com.savvion.sbm.bizlogic.smp.util.MPUtil;
import com.savvion.sbm.util.DBService;
import com.savvion.sbm.util.logger.SBMLogger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;

public class MonitorProcessEiidDAO
extends DBService {
    private static String createSQL = null;
    private static String removeSQL = null;

    public static void printSQLStatements() {
        String initStatement = "Init SQL Statement: ";
        MonitorProcessEiidDAO.getLogger().debug((Object)"MonitorProcessEiidDAO: ");
        MonitorProcessEiidDAO.getLogger().debug((Object)(initStatement + createSQL));
        MonitorProcessEiidDAO.getLogger().debug((Object)(initStatement + removeSQL));
    }

    private static SBMLogger getLogger() {
        return MPService.self().getLogger();
    }

    public static synchronized void initSQLStatements() {
        createSQL = MonitorProcessEiidDAO.buildQuery(" INSERT INTO ", "MONITOR_PROCESS_EIID", " VALUES ", " (", " ? ", ", ", " ? ", ") ");
        removeSQL = MonitorProcessEiidDAO.buildQuery(" DELETE ", " FROM ", "MONITOR_PROCESS_EIID", " WHERE ", "PROCESS_TEMPLATE_ID", " = ? ", " AND ", "EXTERNAL_INSTANCE_ID", " = ? ");
        if (MPUtil.isDebug()) {
            MonitorProcessEiidDAO.printSQLStatements();
        }
    }

    private static String buildQuery(String ... strs) {
        StringBuilder sb = new StringBuilder();
        if (null != strs && strs.length > 0) {
            for (String string : strs) {
                sb.append(string);
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void create(Connection conn, long ptId, String eiid) {
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(createSQL);
            pstmt.setLong(1, ptId);
            pstmt.setString(2, eiid);
            if (MPUtil.isDebug()) {
                MPService.self().getLogger().debugKey("BM_MPCM125", new Object[]{removeSQL, ptId + ", " + eiid});
            }
            pstmt.executeUpdate();
        }
        catch (Throwable e) {
            MPUtil.handleThrowable("BM_MPCM505", "MonitorProcessEiidDAO.create(conn, ptId, eiid)", new Object[]{ptId, eiid}, e);
        }
        finally {
            MonitorProcessEiidDAO.clean(null, (Statement)pstmt, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(Connection conn, long ptId, String eiid) {
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(removeSQL);
            pstmt.setLong(1, ptId);
            pstmt.setString(2, eiid);
            if (MPUtil.isDebug()) {
                MPService.self().getLogger().debugKey("BM_MPCM125", new Object[]{removeSQL, ptId + ", " + eiid});
            }
            pstmt.executeUpdate();
        }
        catch (Throwable e) {
            MPUtil.handleThrowable("BM_MPCM506", "MonitorProcessEiidDAO.remove(conn, ptId, eiid)", new Object[]{ptId, eiid}, e);
        }
        finally {
            MonitorProcessEiidDAO.clean(null, (Statement)pstmt, null);
        }
    }
}

