/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.smp.model;

import com.savvion.sbm.bizlogic.server.ProcessControl;
import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.smp.MPService;
import com.savvion.sbm.bizlogic.smp.model.OperationType;
import com.savvion.sbm.bizlogic.smp.util.InvalidEventDataException;
import com.savvion.sbm.bizlogic.smp.util.MPUtil;
import com.savvion.sbm.bizlogic.smp.util.SMPConfig;
import com.savvion.sbm.util.ExceptionService;
import com.savvion.sbm.util.logger.SBMLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ExternalEvent {
    private String extInstanceId;
    private final String processName;
    private String workstepName;
    private String instanceAlias;
    private final OperationType operationType;
    private String sender;
    private String category;
    private String priority;
    private String performer;
    private int loopCounter;
    private long createTime;
    private long startTime;
    private long endTime;
    private long duration;
    private final List<String> emailId = new ArrayList<String>();
    private Map<String, Object> eventContext;
    private Map<String, Object> eventData;
    private boolean isProcessed = false;

    public boolean isProcessed() {
        return this.isProcessed;
    }

    public void setProcessed(boolean isProcessed) {
        this.isProcessed = isProcessed;
    }

    public ExternalEvent(String eiid, String processName, OperationType operationType) {
        if (operationType == null) {
            throw (InvalidEventDataException)((Object)ExternalEvent.getInvalidEventDataES().createException("BM_MPGW109", "ExternalEvent(String,String,OperationType)", new Object[]{operationType, OperationType.getValidValues(), MPUtil.getEventCtx(eiid, processName, null, null)}));
        }
        if (!ExternalEvent.isValidProcessName(processName)) {
            throw (InvalidEventDataException)((Object)ExternalEvent.getInvalidEventDataES().createException("BM_MPCM110", "ExternalEvent(String,String,OperationType)", new Object[]{processName, 64, MPUtil.getEventCtx(eiid, processName, operationType.getDescription(), null)}));
        }
        this.processName = processName.trim();
        this.operationType = operationType;
        if (!this.isValidExtInstanceId(eiid)) {
            throw (InvalidEventDataException)((Object)ExternalEvent.getInvalidEventDataES().createException("BM_MPCM109", "ExternalEvent(String,String,OperationType)", new Object[]{eiid, 128, MPUtil.getEventCtx(eiid, processName, operationType.getDescription(), null)}));
        }
        if (MPUtil.isValidString(eiid)) {
            this.extInstanceId = eiid.trim();
        }
    }

    public ExternalEvent(String eiid, String processName, OperationType operationType, String workstepName) {
        this(eiid, processName, operationType);
        if (operationType.isWorkstep()) {
            if (!ExternalEvent.isValidWorkstepName(workstepName)) {
                throw (InvalidEventDataException)((Object)ExternalEvent.getInvalidEventDataES().createException("BM_MPCM111", "ExternalEvent(String,String,OperationType,String)", new Object[]{workstepName, 64, MPUtil.getEventCtx(eiid, processName, operationType.getDescription(), workstepName)}));
            }
            this.workstepName = workstepName.trim();
        }
    }

    public String getExternalInstanceId() {
        return this.extInstanceId;
    }

    public String getProcessName() {
        return this.processName;
    }

    public String getWorkstepName() {
        return this.workstepName;
    }

    public String getInstanceAlias() {
        return this.instanceAlias;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public String getSender() {
        return this.sender;
    }

    public String getCategory() {
        return this.category;
    }

    public String getPerformer() {
        return this.performer;
    }

    public int getLoopCounter() {
        return this.loopCounter;
    }

    public String getPriority() {
        return this.priority;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getDuration() {
        return this.duration;
    }

    public Map<String, Object> getEventContext() {
        return this.eventContext;
    }

    public Map<String, Object> getEventData() {
        return this.eventData;
    }

    public List<String> getEmailId() {
        return new ArrayList<String>(this.emailId);
    }

    public void setInstanceAlias(String piAlias) {
        if (piAlias != null) {
            if ((piAlias = piAlias.trim()).length() > 64) {
                this.instanceAlias = piAlias.substring(0, 64);
                if (SMPConfig.self().logWarningMessage()) {
                    ExternalEvent.getLogger().warnKey("BM_MPCM123", "ExternalEvent.setInstanceAlias(String)", new Object[]{"INSTANCE_ALIAS", piAlias, this.instanceAlias, 64, MPUtil.getEventCtx(this)});
                }
            } else {
                this.instanceAlias = piAlias;
            }
        }
    }

    public void setSender(String sender) {
        if (sender == null || sender.trim().length() > 64) {
            throw (InvalidEventDataException)((Object)ExternalEvent.getInvalidEventDataES().createException("BM_MPCM112", "ExternalEvent.setSender(String)", new Object[]{sender, 64, MPUtil.getEventCtx(this)}));
        }
        this.sender = sender.trim();
    }

    public void setCategory(String category) {
        if (category != null) {
            if ((category = category.trim()).length() > 128) {
                this.category = category.substring(0, 128);
                if (SMPConfig.self().logWarningMessage()) {
                    ExternalEvent.getLogger().warnKey("BM_MPCM123", "ExternalEvent.setCategory(String)", new Object[]{"CATEGORY", category, this.category, 128, MPUtil.getEventCtx(this)});
                }
            } else {
                this.category = category;
            }
        }
    }

    public void setLoopCounter(int loopCounter) {
        this.loopCounter = loopCounter;
    }

    public void setPerformer(String performer) {
        if (performer != null) {
            if ((performer = performer.trim()).trim().length() > 64) {
                this.performer = performer.substring(0, 64);
                ExternalEvent.getLogger().warnKey("BM_MPCM123", "ExternalEvent.setPerformer(String)", new Object[]{"PERFORMER", performer, this.performer, 64, MPUtil.getEventCtx(this)});
            } else {
                this.performer = performer;
            }
        }
    }

    public void setPriority(String priority) {
        if (priority != null) {
            if ((priority = priority.trim()).trim().length() > 32) {
                this.priority = priority.substring(0, 32);
                if (SMPConfig.self().logWarningMessage()) {
                    ExternalEvent.getLogger().warnKey("BM_MPCM123", "ExternalEvent.setPriority(String)", new Object[]{"PRIORITY", priority, this.priority, 32, MPUtil.getEventCtx(this)});
                }
            } else {
                this.priority = priority;
            }
        }
    }

    public void setCreateTime(long createTime) {
        if (createTime <= 0L) {
            throw (InvalidEventDataException)((Object)ExternalEvent.getInvalidEventDataES().createException("BM_MPCM113", "ExternalEvent.setCreateTime(long)", new Object[]{createTime, MPUtil.getEventCtx(this)}));
        }
        this.createTime = createTime;
    }

    public void setStartTime(long startTime) {
        if (startTime < 0L) {
            ExternalEvent.getLogger().warnKey("BM_MPCM124", "ExternalEvent.setStartTime(long)", new Object[]{"START_TIME", startTime, MPUtil.getEventCtx(this)});
        } else {
            this.startTime = startTime;
        }
    }

    public void setEndTime(long endTime) {
        if (endTime < 0L) {
            if (SMPConfig.self().logWarningMessage()) {
                ExternalEvent.getLogger().warnKey("BM_MPCM124", "ExternalEvent.setEndTime(long)", new Object[]{"END_TIME", endTime, MPUtil.getEventCtx(this)});
            }
        } else {
            this.endTime = endTime;
        }
    }

    public void setDuration(long duration) {
        if (duration < 0L) {
            if (SMPConfig.self().logWarningMessage()) {
                ExternalEvent.getLogger().warnKey("BM_MPCM124", "ExternalEvent.setDuration(long)", new Object[]{"DURATION", duration, MPUtil.getEventCtx(this)});
            }
        } else {
            this.duration = duration;
        }
    }

    public void setEventContext(Map<String, Object> eventContext) {
        this.eventContext = new HashMap<String, Object>(eventContext);
    }

    public void setEventData(Map<String, Object> eventData) {
        this.eventData = new HashMap<String, Object>(eventData);
    }

    public void setEmailId(List<String> emailIdLst) {
        if (emailIdLst != null) {
            this.emailId.addAll(emailIdLst);
        }
    }

    private static ExceptionService<InvalidEventDataException> getInvalidEventDataES() {
        return MPService.self().getInvalidEventDataES();
    }

    private static SBMLogger getLogger() {
        return MPService.self().getLogger();
    }

    private boolean isValidExtInstanceId(String eiid) {
        WFProcess ptObj = ProcessControl.getProcessTemplate(this.processName);
        if (ptObj.isMonitoringProcess()) {
            if (eiid == null) {
                return ptObj.isMonitorDSMappedToPIID() && this.operationType.isCreateInstance();
            }
            if (eiid.trim().length() > 128) {
                return false;
            }
        }
        return true;
    }

    private static boolean isValidProcessName(String procName) {
        return procName != null && procName.trim().length() <= 64;
    }

    private static boolean isValidWorkstepName(String wsName) {
        return wsName != null && wsName.trim().length() <= 64;
    }

    public Map<String, Object> getAttributes() {
        LinkedHashMap<String, Object> attrs = new LinkedHashMap<String, Object>();
        attrs.put("EXTERNAL_INSTANCE_ID", this.extInstanceId);
        attrs.put("PROCESS_NAME", this.processName);
        attrs.put("WORKSTEP_NAME", this.workstepName);
        attrs.put("INSTANCE_ALIAS", this.instanceAlias);
        attrs.put("OPERATION_TYPE", this.operationType.getId());
        attrs.put("SENDER", this.sender);
        attrs.put("CATEGORY", this.category);
        attrs.put("PRIORITY", this.priority);
        attrs.put("PERFORMER", this.performer);
        attrs.put("LOOP_COUNTER", this.loopCounter);
        attrs.put("CREATE_TIME", this.createTime);
        attrs.put("START_TIME", this.startTime);
        attrs.put("END_TIME", this.endTime);
        attrs.put("DURATION", this.duration);
        attrs.put("CONTEXT", this.eventContext);
        attrs.put("DATASLOT", this.eventData);
        attrs.put("NOTIFY_EMAILS", MPUtil.getListAsDelimitedStr(this.emailId));
        return attrs;
    }

    public boolean containsEventData() {
        return this.eventData != null && !this.eventData.isEmpty();
    }

    public boolean containsEventContext() {
        return this.eventContext != null && !this.eventContext.isEmpty();
    }
}

