/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.smp;

import com.savvion.sbm.bizlogic.smp.gateway.jms.JMSService;
import com.savvion.sbm.bizlogic.smp.gateway.rest.RESTService;
import com.savvion.sbm.bizlogic.smp.persistence.EventPersistenceService;
import com.savvion.sbm.bizlogic.smp.util.InvalidEventDataException;
import com.savvion.sbm.bizlogic.smp.util.InvalidProcessStateException;
import com.savvion.sbm.bizlogic.smp.util.MPUtil;
import com.savvion.sbm.bizlogic.smp.util.MonitoringProcessException;
import com.savvion.sbm.util.ExceptionService;
import com.savvion.sbm.util.MessageFactory;
import com.savvion.sbm.util.SBMConstants;
import com.savvion.sbm.util.SBMUtil;
import com.savvion.sbm.util.logger.LoggerManager;
import com.savvion.sbm.util.logger.SBMLogger;
import java.util.Map;
import javax.sql.DataSource;

public class MPService {
    private static SBMLogger logger = null;
    private static DataSource datasource = null;
    private static MessageFactory msgFactory = null;
    private static ExceptionService<InvalidEventDataException> invEvtDataExSvc;
    private static ExceptionService<MonitoringProcessException> monProcessExSvc;
    private static ExceptionService<InvalidProcessStateException> invProcessStateExSvc;
    private static RESTService restService;
    private static JMSService jmsService;
    private static EventPersistenceService evtPersistentSvc;
    private static MPService self;

    public static synchronized void prepareResource(DataSource ds, SBMLogger sbmLogger, Map<String, Object> properties) {
        if (ds == null) {
            throw new RuntimeException("Specified datasource is null");
        }
        datasource = ds;
        MPService.init(sbmLogger);
        MPUtil.printDAOSql();
    }

    public static MPService self() {
        if (self == null) {
            throw new RuntimeException("Monitoring Process Entry point service is not initialized. Initialize it calling MPService.prepareResource(DataSource,SBMLogger,Map)");
        }
        return self;
    }

    private static synchronized void init(SBMLogger sbmLogger) {
        if (self == null) {
            MPService.initMessageFactory();
            MPService.initLogger(sbmLogger);
            MPService.initExceptionService();
            evtPersistentSvc = new EventPersistenceService(datasource);
            MPUtil.init();
            self = new MPService();
        }
    }

    private static synchronized void initMessageFactory() {
        try {
            msgFactory = MessageFactory.getInstance((String)"mpmessages", (ClassLoader)MPService.class.getClassLoader());
        }
        catch (Throwable th) {
            throw new RuntimeException("Error initializing message factory with message file: mpmessages", th);
        }
    }

    private static synchronized void initLogger(SBMLogger sbmLogger) {
        if (sbmLogger != null) {
            logger = sbmLogger.cloneInstance(msgFactory);
        } else {
            LoggerManager loggerManager = LoggerManager.self();
            SBMConstants.self().getClass();
            logger = loggerManager.createLogger("BizLogic", SBMUtil.self().SBM_LOGGER_FILE, "mpmessages", MPService.class.getClassLoader());
        }
    }

    private static synchronized void initExceptionService() {
        invEvtDataExSvc = new ExceptionService(InvalidEventDataException.class, msgFactory, logger);
        monProcessExSvc = new ExceptionService(MonitoringProcessException.class, msgFactory, logger);
        invProcessStateExSvc = new ExceptionService(InvalidProcessStateException.class, msgFactory, logger);
    }

    public static synchronized void cleanup() {
        evtPersistentSvc = null;
        jmsService = null;
        restService = null;
        monProcessExSvc = null;
        invEvtDataExSvc = null;
        invProcessStateExSvc = null;
        datasource = null;
        self = null;
    }

    public void refresh() {
        logger.reload();
        MPUtil.refresh();
        if (MPUtil.isDebug()) {
            logger.setLevel(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JMSService getJMSService() {
        if (jmsService == null) {
            MPService mPService = this;
            synchronized (mPService) {
                if (jmsService == null) {
                    jmsService = new JMSService();
                }
            }
        }
        return jmsService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RESTService getRESTService() {
        if (restService == null) {
            MPService mPService = this;
            synchronized (mPService) {
                if (restService == null) {
                    restService = new RESTService();
                }
            }
        }
        return restService;
    }

    public EventPersistenceService getPersistenceService() {
        return evtPersistentSvc;
    }

    public DataSource getDatasource() {
        return datasource;
    }

    public boolean isDebug() {
        return this.getLogger().isDebugEnabled();
    }

    public ExceptionService<InvalidEventDataException> getInvalidEventDataES() {
        return invEvtDataExSvc;
    }

    public ExceptionService<MonitoringProcessException> getMonitoringProcessES() {
        return monProcessExSvc;
    }

    public ExceptionService<InvalidProcessStateException> getInvalidProcessStateES() {
        return invProcessStateExSvc;
    }

    public SBMLogger getLogger() {
        return logger;
    }

    public MessageFactory getMessageFactory() {
        return msgFactory;
    }

    static {
        restService = null;
        jmsService = null;
        evtPersistentSvc = null;
        self = null;
    }
}

