/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.svo;

import com.savvion.sbm.bizlogic.client.queryservice.QSClientUtil;
import com.savvion.sbm.bizlogic.enums.PTState;
import com.savvion.sbm.bizlogic.server.ejb.BLServer;
import com.savvion.sbm.bizlogic.server.ejb.BLServerHome;
import com.savvion.sbm.bizlogic.server.ejb.ProcessTemplateSB;
import com.savvion.sbm.bizlogic.server.ejb.ProcessTemplateSBHome;
import com.savvion.sbm.bizlogic.server.svo.BLProcess;
import com.savvion.sbm.bizlogic.server.svo.DataSlotTemplate;
import com.savvion.sbm.bizlogic.server.svo.ProcessInstance;
import com.savvion.sbm.bizlogic.server.svo.ProcessInstanceList;
import com.savvion.sbm.bizlogic.server.svo.ProcessTemplateList;
import com.savvion.sbm.bizlogic.server.svo.TimerAction;
import com.savvion.sbm.bizlogic.server.svo.TimerActionList;
import com.savvion.sbm.bizlogic.server.svo.WorkStepInstanceList;
import com.savvion.sbm.bizlogic.server.svo.WorkStepTemplate;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BizLogicClientException;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.ProcessType;
import com.savvion.sbm.bizlogic.util.Session;
import java.rmi.RemoteException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.ejb.EJBObject;

public class ProcessTemplate
extends BLProcess {
    private boolean dynamic;
    private long dynamicInstanceID;

    ProcessTemplate(Session session, HashMap attribs) {
        BLConstants.single();
        super(session, (Long)attribs.get("PROCESSTEMPLATEID"), attribs);
        this.dynamic = false;
        this.dynamicInstanceID = -1L;
        BLConstants.single();
        this.dynamic = (Boolean)this.attributes.get("DYNAMIC");
        if (this.dynamic) {
            BLConstants.single();
            this.dynamicInstanceID = (Long)this.attributes.get("DYNAMICINSTANCEID");
        }
    }

    public WorkStepTemplate getWorkStepTemplate(String wsName) throws RemoteException {
        if (wsName == null || wsName.trim().length() == 0) {
            throw new BizLogicClientException("BizLogic_ERR_548", new Object[]{this.getName(), "null"});
        }
        return ((ProcessTemplateSB)this.getRemoteRef()).getWorkStepTemplate(this.session, this.dynamic ? this.dynamicInstanceID : this.getID(), wsName, this.dynamic);
    }

    public Vector getWorkStepTemplateList() throws RemoteException {
        return ((ProcessTemplateSB)this.getRemoteRef()).getWorkStepTemplateList(this.session, this.dynamic ? this.dynamicInstanceID : this.getID(), this.dynamic);
    }

    public Vector getWorkStepTemplateList(boolean inlcudeInlineActivities) throws RemoteException {
        return ((ProcessTemplateSB)this.getRemoteRef()).getWorkStepTemplateList(this.session, this.dynamic ? this.dynamicInstanceID : this.getID(), this.dynamic, inlcudeInlineActivities);
    }

    public Vector getDataSlotTemplateList() throws RemoteException {
        return ((ProcessTemplateSB)this.getRemoteRef()).getDataSlotTemplateList(this.session, this.dynamic ? this.dynamicInstanceID : this.getID(), this.dynamic);
    }

    public Vector getDataSlotTemplateList(Vector dsNames) throws RemoteException {
        if (dsNames == null || dsNames.isEmpty()) {
            throw new BizLogicClientException("Bizlogic_ERR_3707", new Object[]{dsNames, this.getName()});
        }
        return ((ProcessTemplateSB)this.getRemoteRef()).getDataSlotTemplateList(this.session, this.dynamic ? this.dynamicInstanceID : this.getID(), dsNames, this.dynamic);
    }

    @Override
    public String getName() {
        BLConstants.single();
        return (String)this.attributes.get("PROCESSTEMPLATENAME");
    }

    @Override
    public long getID() {
        return this.id;
    }

    public String getVersionID() {
        BLConstants.single();
        return (String)this.attributes.get("VERSION");
    }

    public String getCreator() {
        BLConstants.single();
        return (String)this.attributes.get("CREATOR");
    }

    public String getManager() {
        BLConstants.single();
        return (String)this.attributes.get("PMANAGER");
    }

    public String getCategory() {
        BLConstants.single();
        return (String)this.attributes.get("CATEGORY");
    }

    public String getSubCategory() {
        BLConstants.single();
        return (String)this.attributes.get("SUBCATEGORY");
    }

    public long getLastModifiedTime() {
        BLConstants.single();
        return (Long)this.attributes.get("LAST_MODIFIED_TIME");
    }

    public String getGroup() {
        BLConstants.single();
        return (String)this.attributes.get("GROUP");
    }

    public String getInfo() {
        BLConstants.single();
        return (String)this.attributes.get("INFO");
    }

    public String getAppName() {
        BLConstants.single();
        String appName = (String)this.attributes.get("APP_NAME");
        if (appName == null || "".equals(appName)) {
            return this.getName();
        }
        return appName;
    }

    public String getDisplayName() {
        BLConstants.single();
        String displayName = (String)this.attributes.get("APP_NAME");
        if (displayName == null || "".equals(displayName)) {
            return this.getName();
        }
        return displayName;
    }

    public String getDescription() {
        BLConstants.single();
        return (String)this.attributes.get("DESCRIPTION");
    }

    public long getEstimatedDuration() {
        BLConstants.single();
        return (Long)this.attributes.get("ESTIMATEDDURATION");
    }

    public String getXMLFileName() throws RemoteException {
        BLConstants.single();
        return (String)this.attributes.get("XMLFILE");
    }

    public void setManager(String manager) {
        if (manager == null) {
            return;
        }
        BLConstants.single();
        this.setAttribute("PMANAGER", manager);
    }

    public void setDescription(String desc) {
        if (desc == null) {
            return;
        }
        BLConstants.single();
        this.setAttribute("DESCRIPTION", desc);
    }

    public void setDisplayName(String name) {
        throw new BizLogicClientException("Bizlogic_ERR_3703", new Object[]{"setDisplayName", "ProcessTemplate"});
    }

    public void setEstimatedDuration(long duration) {
        BLConstants.single();
        this.setAttribute("ESTIMATEDDURATION", duration);
    }

    public void setFYI(Vector fyi) {
        if (fyi == null) {
            return;
        }
        BLConstants.single();
        this.setAttribute("FYI", fyi);
    }

    public void activate() throws RemoteException {
        int n = this.getState();
        BLConstants.single();
        if (n != 1) {
            throw new BizLogicClientException("BizLogic_ERR_544", new Object[]{this.getName()});
        }
        if (this.dynamic) {
            throw new BizLogicClientException("BizLogic_ERR_660", new Object[]{"activate", this.getName()});
        }
        ((ProcessTemplateSB)this.getRemoteRef()).activate(this.session, this.getID());
        BLConstants.single();
        super.setState(2);
    }

    public ProcessInstance getProcessInstance(long piid) throws RemoteException {
        ProcessTemplate.validateNumber(piid, "PIID");
        ProcessInstance pi = ((ProcessTemplateSB)this.getRemoteRef()).getProcessInstance(this.session, piid);
        return pi;
    }

    public ProcessInstanceList getProcessInstanceList(long[] piids) throws RemoteException {
        ProcessInstanceList piList = null;
        piList = piids == null || piids.length == 0 ? new ProcessInstanceList(this.session, null) : ((ProcessTemplateSB)this.getRemoteRef()).getProcessInstanceList(this.session, piids);
        return piList;
    }

    public ProcessInstance createProcessInstance(String piNamePrefix, HashMap attributes, HashMap dsValues, boolean toActivate) throws RemoteException {
        boolean wildcardcheck;
        if (this.dynamic) {
            throw new BizLogicClientException("BizLogic_ERR_660", new Object[]{"createProcessInstance", this.getName()});
        }
        if (piNamePrefix == null || "".equals(piNamePrefix)) {
            piNamePrefix = this.getName();
        }
        if (wildcardcheck = this.checkName(piNamePrefix)) {
            Object[] objectArray = new Object[2];
            objectArray[0] = piNamePrefix;
            BLConstants.single();
            objectArray[1] = "*!#@\\'\"/?:%$<>";
            throw new BizLogicClientException("BizLogic_ERR_598", objectArray);
        }
        if (attributes == null) {
            attributes = new HashMap<String, Long>();
        }
        BLConstants.single();
        attributes.put("PROCESSTEMPLATEID", this.getID());
        BLConstants.single();
        attributes.put("PROCESSINSTANCENAME", (Long)((Object)piNamePrefix));
        ProcessInstance pi = ((ProcessTemplateSB)this.getRemoteRef()).createProcessInstance(this.session, this.getName(), attributes, dsValues, toActivate);
        return pi;
    }

    public void removeProcessInstance(long piid) throws RemoteException {
        ProcessTemplate.validateNumber(piid, "PIID");
        ((ProcessTemplateSB)this.getRemoteRef()).removeProcessInstance(this.session, piid);
    }

    public int getProcessInstanceCount() throws RemoteException {
        int count = ((ProcessTemplateSB)this.getRemoteRef()).getProcessInstanceCount(this.session, this.getID());
        return count;
    }

    public int getActivatedProcessInstanceCount() throws RemoteException {
        int count = ((ProcessTemplateSB)this.getRemoteRef()).getActivatedProcessInstanceCount(this.session, this.getID());
        return count;
    }

    public int getSuspendedProcessInstanceCount() throws RemoteException {
        int count = ((ProcessTemplateSB)this.getRemoteRef()).getSuspendedProcessInstanceCount(this.session, this.getID());
        return count;
    }

    public ProcessInstanceList getProcessInstanceList() throws RemoteException {
        ProcessInstanceList piList = ((ProcessTemplateSB)this.getRemoteRef()).getProcessInstanceList(this.session, this.getID());
        return piList;
    }

    public ProcessInstanceList getActivatedProcessInstanceList() throws RemoteException {
        ProcessInstanceList piList = ((ProcessTemplateSB)this.getRemoteRef()).getActivatedProcessInstanceList(this.session, this.getID());
        return piList;
    }

    public ProcessInstanceList getSuspendedProcessInstanceList() throws RemoteException {
        ProcessInstanceList piList = ((ProcessTemplateSB)this.getRemoteRef()).getSuspendedProcessInstanceList(this.session, this.getID());
        return piList;
    }

    @Override
    public void remove() throws RemoteException {
        ((ProcessTemplateSB)this.getRemoteRef()).remove(this.session, this.getID());
        this.removed = true;
    }

    public long removeAllProcessInstance() throws RemoteException {
        return ((ProcessTemplateSB)this.getRemoteRef()).removeAllProcessInstance(this.session, this.getID());
    }

    @Override
    public void refresh() throws RemoteException {
        HashMap attribs = ((ProcessTemplateSB)this.getRemoteRef()).getAttributes(this.session, this.dynamic ? this.dynamicInstanceID : this.getID(), this.dynamic);
        this.attributes.clear();
        this.modifiedAttrs.clear();
        this.attributes.putAll(attribs);
    }

    @Override
    public void save() throws RemoteException {
        if (this.removed) {
            throw new BizLogicClientException("BizLogic_ERR_910", new Object[]{"ProcessTemplate"});
        }
        boolean receivedException = false;
        try {
            if (!this.modifiedAttrs.isEmpty()) {
                ((ProcessTemplateSB)this.getRemoteRef()).save(this.session, this.dynamic ? this.dynamicInstanceID : this.getID(), this.modifiedAttrs, this.dynamic);
                this.modifiedAttrs.clear();
            }
        }
        catch (BizLogicException | RemoteException e) {
            receivedException = true;
            throw e;
        }
        finally {
            ProcessTemplate.doFinally(receivedException, this);
        }
    }

    @Override
    public void suspend() throws RemoteException {
        if (this.isSuspended()) {
            throw new BizLogicClientException("BizLogic_ERR_1653", new Object[]{this.getName()});
        }
        if (!this.isActivated()) {
            throw new BizLogicClientException("BizLogic_ERR_1547", new Object[]{this.getName()});
        }
        if (this.dynamic) {
            throw new BizLogicClientException("BizLogic_ERR_660", new Object[]{"suspend", this.getName()});
        }
        ((ProcessTemplateSB)this.getRemoteRef()).suspend(this.session, this.getID());
        BLConstants.single();
        super.setState(4);
    }

    public HashMap validateForUpdate(String xmldefinition) throws RemoteException {
        if (this.isSuspended() && !this.isSuspendedBySeqVersion()) {
            throw new BizLogicClientException("BizLogic_ERR_8801", new Object[]{this.getName()});
        }
        if (!this.isActivated() && !this.isSuspendedBySeqVersion()) {
            throw new BizLogicClientException("BizLogic_ERR_8802", new Object[]{this.getName()});
        }
        ProcessTemplate.validateString(xmldefinition, "PT Xml Content");
        return ((ProcessTemplateSB)this.getRemoteRef()).validateForUpdate(this.session, this.getID(), xmldefinition);
    }

    public HashMap validateForUpdate() throws RemoteException {
        if (this.isSuspended() && !this.isSuspendedBySeqVersion()) {
            throw new BizLogicClientException("BizLogic_ERR_8801", new Object[]{this.getName()});
        }
        if (!this.isActivated() && !this.isSuspendedBySeqVersion()) {
            throw new BizLogicClientException("BizLogic_ERR_8802", new Object[]{this.getName()});
        }
        return ((ProcessTemplateSB)this.getRemoteRef()).validateForUpdate(this.session, this.getID());
    }

    public ProcessTemplate replace() throws RemoteException {
        if (this.isSuspended() && !this.isSuspendedBySeqVersion()) {
            throw new BizLogicClientException("BizLogic_ERR_8801", new Object[]{this.getName()});
        }
        if (!this.isActivated() && !this.isSuspendedBySeqVersion()) {
            throw new BizLogicClientException("BizLogic_ERR_8802", new Object[]{this.getName()});
        }
        return ((ProcessTemplateSB)this.getRemoteRef()).replace(this.session, this.getID());
    }

    public ProcessTemplate replace(String xmldefinition) throws RemoteException {
        if (this.isSuspended() && !this.isSuspendedBySeqVersion()) {
            throw new BizLogicClientException("BizLogic_ERR_8801", new Object[]{this.getName()});
        }
        if (!this.isActivated() && !this.isSuspendedBySeqVersion()) {
            throw new BizLogicClientException("BizLogic_ERR_8802", new Object[]{this.getName()});
        }
        ProcessTemplate.validateString(xmldefinition, "PT Xml Content");
        return ((ProcessTemplateSB)this.getRemoteRef()).replace(this.session, this.getID(), xmldefinition);
    }

    @Override
    public void resume() throws RemoteException {
        if (!this.isSuspended()) {
            throw new BizLogicClientException("BizLogic_ERR_1659", new Object[]{this.getName()});
        }
        if (this.dynamic) {
            throw new BizLogicClientException("BizLogic_ERR_660", new Object[]{"resume", this.getName()});
        }
        ((ProcessTemplateSB)this.getRemoteRef()).resume(this.session, this.getID());
        BLConstants.single();
        super.setState(2);
    }

    public void resumeWorkStepInstances() throws RemoteException {
        ((BLServer)ProcessTemplate.getRemoteRef(BLServerHome.class)).resumeWorkStepInstances(this.session, new long[]{this.getID()}, null);
    }

    public void resumeWorkStepInstances(int[] wsTypes) throws RemoteException {
        ((BLServer)ProcessTemplate.getRemoteRef(BLServerHome.class)).resumeWorkStepInstances(this.session, new long[]{this.getID()}, wsTypes);
    }

    public WorkStepInstanceList getSuspendedWorkStepInstanceList() throws RemoteException {
        return ((BLServer)ProcessTemplate.getRemoteRef(BLServerHome.class)).getSuspendedWorkStepInstanceList(this.session, this.getID());
    }

    @Override
    protected EJBObject findRemoteRef() {
        try {
            return (ProcessTemplateSB)ProcessTemplate.getRemoteRef(ProcessTemplateSBHome.class);
        }
        catch (Exception e) {
            throw new BizLogicClientException("BizLogic_ERR_1527", new Object[]{this.getName()}, (Throwable)e);
        }
    }

    private boolean checkName(String piname) {
        if (piname == null) {
            return false;
        }
        BLConstants consts = BLConstants.single();
        int x = 0;
        while (true) {
            if (x >= "*!#@\\'\"/?:%$<>".length()) break;
            if (piname.indexOf("*!#@\\'\"/?:%$<>".charAt(x)) != -1) {
                return true;
            }
            ++x;
        }
        return false;
    }

    public Vector getFYI() throws RemoteException {
        HashMap hashMap = this.getAttributes();
        BLConstants.single();
        return (Vector)hashMap.get("FYI");
    }

    public WorkStepTemplate getStartWorkStep() throws RemoteException {
        return ((ProcessTemplateSB)this.getRemoteRef()).getStartWorkStep(this.session, this.dynamic ? this.dynamicInstanceID : this.getID(), this.dynamic);
    }

    public DataSlotTemplate getDataSlotTemplate(String dsName) throws RemoteException {
        ProcessTemplate.validateString(dsName, "dataslot name");
        return ((ProcessTemplateSB)this.getRemoteRef()).getDataSlotTemplate(this.session, this.dynamic ? this.dynamicInstanceID : this.getID(), dsName, this.dynamic);
    }

    public Vector getRollbackPoints() throws RemoteException {
        BLConstants.single();
        if (this.attributes.containsKey("ROLLBACKPOINTS")) {
            HashMap hashMap = this.getAttributes();
            BLConstants.single();
            return (Vector)hashMap.get("ROLLBACKPOINTS");
        }
        ProcessTemplateSB ptSB = (ProcessTemplateSB)this.getRemoteRef();
        Vector rbPoints = ptSB.getRollbackPoints(this.session, this.dynamic ? this.dynamicInstanceID : this.getID(), this.dynamic);
        BLConstants.single();
        this.attributes.put("ROLLBACKPOINTS", rbPoints);
        return rbPoints;
    }

    public String getXML() throws RemoteException {
        BLConstants.single();
        if (this.attributes.containsKey("XML")) {
            HashMap hashMap = this.getAttributes();
            BLConstants.single();
            return (String)hashMap.get("XML");
        }
        ProcessTemplateSB ptSB = (ProcessTemplateSB)this.getRemoteRef();
        String xmlInfo = ptSB.getXML(this.session, this.dynamic ? this.dynamicInstanceID : this.getID(), this.dynamic);
        BLConstants.single();
        this.attributes.put("XML", xmlInfo);
        return xmlInfo;
    }

    public ProcessTemplate createVersion(String xmlFileName) throws RemoteException {
        if (xmlFileName == null || "".equals(xmlFileName)) {
            throw new BizLogicClientException("BizLogic_ERR_2544");
        }
        if (this.dynamic) {
            throw new BizLogicClientException("BizLogic_ERR_660", new Object[]{"createVersion", this.getName()});
        }
        ProcessTemplateSB ptSB = (ProcessTemplateSB)this.getRemoteRef();
        ProcessTemplate newPT = ptSB.createVersionAndGetTemplate(this.session, xmlFileName, true);
        this.refresh();
        return newPT;
    }

    public ProcessTemplateList getVersions() throws RemoteException {
        if (this.dynamic) {
            throw new BizLogicClientException("BizLogic_ERR_660", new Object[]{"getVersions", this.getName()});
        }
        ProcessTemplateSB ptSB = (ProcessTemplateSB)this.getRemoteRef();
        return ptSB.getVersions(this.session, this.getID());
    }

    public boolean isSuspendedBySeqVersion() throws RemoteException {
        if (this.dynamic) {
            throw new BizLogicClientException("BizLogic_ERR_660", new Object[]{"isSuspendedBySeqVersion", this.getName()});
        }
        BLConstants.single();
        Boolean flag = (Boolean)this.attributes.get("ISSUSPENDEDBYVERSION");
        return flag != false && this.isSuspended();
    }

    public ProcessTemplate getParent() throws RemoteException {
        if (this.dynamic) {
            throw new BizLogicClientException("BizLogic_ERR_660", new Object[]{"getParent", this.getName()});
        }
        BLConstants.single();
        long parentID = (Long)this.attributes.get("PARENT_ID");
        if (parentID <= 0L) {
            return null;
        }
        ProcessTemplateSB ptSB = (ProcessTemplateSB)this.getRemoteRef();
        return ptSB.getParent(this.session, parentID);
    }

    public Hashtable getDataSlotInfo(String dsName) throws RemoteException {
        if (dsName == null || "".equals(dsName)) {
            throw new BizLogicClientException("BizLogic_ERR_1512", new Object[]{dsName});
        }
        return ((ProcessTemplateSB)this.getRemoteRef()).getDataSlotInfo(this.session, this.dynamic ? this.dynamicInstanceID : this.getID(), dsName, this.dynamic);
    }

    public TimerActionList getOverDueAction() throws RemoteException {
        BLConstants.single();
        if (this.attributes.containsKey("TIMER_ACTION")) {
            BLConstants.single();
            return (TimerActionList)this.attributes.get("TIMER_ACTION");
        }
        TimerActionList list = ((ProcessTemplateSB)this.getRemoteRef()).getOverDueAction(this.session, this.dynamic ? this.dynamicInstanceID : this.getID(), this.dynamic);
        BLConstants.single();
        this.attributes.put("TIMER_ACTION", list);
        return list;
    }

    public TimerAction getOverDueAction(int escalateLevel) throws RemoteException {
        TimerActionList timerActionList = this.getOverDueAction();
        if (timerActionList != null) {
            return timerActionList.get(escalateLevel);
        }
        return null;
    }

    public void setOverDueAction(TimerActionList glist) {
        BLConstants.single();
        this.setAttribute("TIMER_ACTION", glist);
    }

    public boolean isDataSlot(String dsName) throws RemoteException {
        return this.isDataSlot(dsName, this.getDataSlotNameList());
    }

    public Vector getDataSlotNameList() throws RemoteException {
        BLConstants.single();
        if (this.attributes.containsKey("DATASLOTNAMELIST")) {
            BLConstants.single();
            return (Vector)this.attributes.get("DATASLOTNAMELIST");
        }
        Vector dsNameList = ((ProcessTemplateSB)this.getRemoteRef()).getDataSlotNameList(this.session, this.dynamic ? this.dynamicInstanceID : this.getID(), this.dynamic);
        BLConstants.single();
        this.attributes.put("DATASLOTNAMELIST", dsNameList);
        return dsNameList;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public long getDynamicInstanceID() {
        return this.dynamicInstanceID;
    }

    public void updateNewDataSlotsForPTR() throws RemoteException {
        ((ProcessTemplateSB)this.getRemoteRef()).updateNewDataSlotsForPTR(this.session, this.getID());
    }

    public void createDataSlotIndexesForPTR() throws RemoteException {
        ((ProcessTemplateSB)this.getRemoteRef()).createDataSlotIndexesForPTR(this.session, this.getID());
    }

    public ProcessInstanceList getProcessInstanceList(String milestoneName) throws RemoteException {
        if (milestoneName == null || "".equals(milestoneName)) {
            throw new BizLogicClientException("Bizlogic_ERR_3705", new Object[]{milestoneName, this.getName()});
        }
        return ((ProcessTemplateSB)this.getRemoteRef()).getProcessInstanceList(this.session, this.getID(), milestoneName);
    }

    public WorkStepInstanceList getWorkStepInstanceList(String milestoneName) throws RemoteException {
        if (milestoneName == null || "".equals(milestoneName)) {
            throw new BizLogicClientException("Bizlogic_ERR_3705", new Object[]{milestoneName, this.getName()});
        }
        if ("@@ALL_MILESTONE@@".equals(milestoneName)) {
            milestoneName = null;
        }
        return ((ProcessTemplateSB)this.getRemoteRef()).getWorkStepInstanceList(this.session, this.getID(), milestoneName);
    }

    public Map getMilestoneList() throws RemoteException {
        return ((ProcessTemplateSB)this.getRemoteRef()).getMilestoneList(this.session, this.getID());
    }

    public String getMilestoneDescription(String milestoneName) throws RemoteException {
        if (milestoneName == null || "".equals(milestoneName)) {
            throw new BizLogicClientException("Bizlogic_ERR_3705", new Object[]{milestoneName, this.getName()});
        }
        return ((ProcessTemplateSB)this.getRemoteRef()).getMilestoneDescription(this.session, this.getID(), milestoneName);
    }

    public void updateGlobalDataSlot(String dsName, Object dsValue) throws RemoteException {
        ProcessTemplate.updateGlobalDataSlot(this.session, this.getID(), dsName, dsValue);
    }

    public void updateGlobalDataSlots(Map<String, Object> dsValues) throws RemoteException {
        ProcessTemplate.updateGlobalDataSlots(this.session, this.getID(), dsValues);
    }

    public Object getGlobalDataSlot(String dsName) throws RemoteException {
        return ProcessTemplate.getGlobalDataSlot(this.session, this.getID(), dsName);
    }

    public Map<String, Object> getGlobalDataSlots() throws RemoteException {
        return ProcessTemplate.getGlobalDataSlots(this.session, this.getID());
    }

    public static void remove(Session session, String ptName, boolean removePi) throws RemoteException {
        ProcessTemplate.validateSession(session);
        ProcessTemplate.validateString(ptName, "PTName");
        ((ProcessTemplateSB)BLProcess.getRemoteRef(ProcessTemplateSBHome.class)).remove(session, ptName, removePi);
    }

    public static ProcessTemplate replace(Session session, String ptName) throws RemoteException {
        ProcessTemplate.validateSession(session);
        ProcessTemplate.validateString(ptName, "PTName");
        ProcessTemplate pt = ((ProcessTemplateSB)BLProcess.getRemoteRef(ProcessTemplateSBHome.class)).replace(session, ptName);
        return pt;
    }

    public static void suspend(Session session, String ptName) throws RemoteException {
        ProcessTemplate.validateSession(session);
        ProcessTemplate.validateString(ptName, "PTName");
        ((ProcessTemplateSB)BLProcess.getRemoteRef(ProcessTemplateSBHome.class)).suspend(session, ptName);
    }

    public static void resume(Session session, String ptName) throws RemoteException {
        ProcessTemplate.validateSession(session);
        ProcessTemplate.validateString(ptName, "PTName");
        ((ProcessTemplateSB)BLProcess.getRemoteRef(ProcessTemplateSBHome.class)).resume(session, ptName);
    }

    private static void validateSession(Session session) {
        if (session == null) {
            throw new BizLogicClientException("BizLogic_ERR_3870", new Object[]{"ProcessTemplate.validateSession()"});
        }
    }

    private static void validateString(String str, String name) {
        if (str == null || str.trim().isEmpty()) {
            throw new BizLogicClientException("BizLogic_ERR_8107", new Object[]{name, "ProcessTemplate.validateString()"});
        }
    }

    private static void validateNumber(long number, String name) {
        if (number <= 0L) {
            throw new BizLogicClientException("BizLogic_ERR_8108", new Object[]{name, "ProcessTemplate.validateNumber()"});
        }
    }

    public static void updateGlobalDataSlot(Session session, long ptid, String dsName, Object dsValue) throws RemoteException {
        ProcessTemplate.validateNumber(ptid, "PTID");
        ProcessTemplate.validateSession(session);
        if (dsName == null || dsName.trim().length() == 0) {
            throw new BizLogicClientException("BizLogic_ERR_3065");
        }
        ((ProcessTemplateSB)BLProcess.getRemoteRef(ProcessTemplateSBHome.class)).updateGlobalDataSlot(session, ptid, dsName, dsValue);
    }

    public static void updateGlobalDataSlots(Session session, long ptid, Map<String, Object> dsValues) throws RemoteException {
        ProcessTemplate.validateSession(session);
        ProcessTemplate.validateNumber(ptid, "PTID");
        if (dsValues == null || dsValues.isEmpty()) {
            return;
        }
        ((ProcessTemplateSB)BLProcess.getRemoteRef(ProcessTemplateSBHome.class)).updateGlobalDataSlots(session, ptid, dsValues);
    }

    public static Object getGlobalDataSlot(Session session, long ptid, String dsName) throws RemoteException {
        ProcessTemplate.validateSession(session);
        ProcessTemplate.validateNumber(ptid, "PTID");
        if (dsName == null || dsName.trim().length() == 0) {
            throw new BizLogicClientException("BizLogic_ERR_3065");
        }
        return ((ProcessTemplateSB)BLProcess.getRemoteRef(ProcessTemplateSBHome.class)).getGlobalDataSlot(session, ptid, dsName);
    }

    public static Map<String, Object> getGlobalDataSlots(Session session, long ptid) throws RemoteException {
        ProcessTemplate.validateSession(session);
        ProcessTemplate.validateNumber(ptid, "PTID");
        return ((ProcessTemplateSB)BLProcess.getRemoteRef(ProcessTemplateSBHome.class)).getGlobalDataSlots(session, ptid);
    }

    public static ProcessTemplate create(Session session, String processDefinition, boolean activate) throws RemoteException {
        return ProcessTemplate.create(session, processDefinition);
    }

    public static ProcessTemplate create(Session session, String processDefinition) throws RemoteException {
        ProcessTemplate.validateSession(session);
        ProcessTemplate.validateString(processDefinition, "PT Xml Content");
        BLServer blserver = (BLServer)BLProcess.getRemoteRef(BLServerHome.class);
        return blserver.createProcessTemplate(session, processDefinition, true);
    }

    public static ProcessTemplate get(Session session, long ptid) throws RemoteException {
        ProcessTemplate.validateSession(session);
        ProcessTemplate.validateNumber(ptid, "PTID");
        BLServer blserver = (BLServer)BLProcess.getRemoteRef(BLServerHome.class);
        return blserver.getProcessTemplate(session, ptid);
    }

    public static ProcessTemplate get(Session session, String ptName) throws RemoteException {
        ProcessTemplate.validateSession(session);
        ProcessTemplate.validateString(ptName, "PTName");
        BLServer blserver = (BLServer)BLProcess.getRemoteRef(BLServerHome.class);
        return blserver.getProcessTemplate(session, ptName);
    }

    public static boolean isExist(Session session, long ptID) throws RemoteException {
        ProcessTemplate.validateSession(session);
        ProcessTemplate.validateNumber(ptID, "PTID");
        return ((ProcessTemplateSB)ProcessTemplate.getRemoteRef(ProcessTemplateSBHome.class)).isExist(session, ptID);
    }

    public static boolean isExist(Session session, String ptName) throws RemoteException {
        ProcessTemplate.validateSession(session);
        return ((ProcessTemplateSB)ProcessTemplate.getRemoteRef(ProcessTemplateSBHome.class)).isExist(session, ptName);
    }

    public static String getProcessTemplateName(Session session, long ptid) throws RemoteException {
        ProcessTemplate.validateSession(session);
        ProcessTemplate.validateNumber(ptid, "PTID");
        BLServer blserver = (BLServer)ProcessTemplate.getRemoteRef(BLServerHome.class);
        if (!blserver.isSessionValid(session)) {
            throw new BizLogicClientException("BizLogic_ERR_3873", new Object[]{session.getUser(), "ProcessTemplate.getProcessTemplateName()"});
        }
        return QSClientUtil.getProcessTemplateName((long)ptid);
    }

    public static Map<String, PTState> getNames(Session session) throws RemoteException {
        ProcessTemplate.validateSession(session);
        return ((ProcessTemplateSB)ProcessTemplate.getRemoteRef(ProcessTemplateSBHome.class)).getNames(session);
    }

    public static long getProcessTemplateId(Session session, String ptName) throws RemoteException {
        ProcessTemplate.validateSession(session);
        if (ptName == null || ptName.trim().isEmpty()) {
            throw new BizLogicClientException("BizLogic_ERR_3871", new Object[]{"ProcessTemplate.getProcessTemplateId()"});
        }
        BLServer blserver = (BLServer)ProcessTemplate.getRemoteRef(BLServerHome.class);
        if (!blserver.isSessionValid(session)) {
            throw new BizLogicClientException("BizLogic_ERR_3873", new Object[]{session.getUser(), "ProcessTemplate.getProcessTemplateId()"});
        }
        return QSClientUtil.getProcessTemplateId((String)ptName);
    }

    public static ProcessTemplate reinstall(Session session, String ptName, boolean forceRemoveInstances) throws RemoteException {
        ProcessTemplate.validateSession(session);
        ProcessTemplate.validateString(ptName, "PTName");
        return ((ProcessTemplateSB)ProcessTemplate.getRemoteRef(ProcessTemplateSBHome.class)).reinstall(session, ptName, forceRemoveInstances);
    }

    public static ProcessTemplateList get(Session session, String category, String subCategory) throws RemoteException {
        ProcessTemplate.validateSession(session);
        return ((ProcessTemplateSB)ProcessTemplate.getRemoteRef(ProcessTemplateSBHome.class)).getProcessTemplateList(session, category, subCategory);
    }

    public static List<ProcessTemplate> getList(Session session, EnumSet<PTState> ptStates) throws RemoteException {
        ProcessTemplate.validateSession(session);
        if (ptStates == null) {
            return null;
        }
        return ((ProcessTemplateSB)ProcessTemplate.getRemoteRef(ProcessTemplateSBHome.class)).getList(session, ptStates);
    }

    public boolean isAuditEnabled() {
        HashMap hashMap = this.getAttributes();
        BLConstants.single();
        Object obj = hashMap.get("AUDIT");
        if (obj == null) {
            return true;
        }
        return (Boolean)obj;
    }

    public ProcessType getProcessType() {
        BLConstants.single();
        return (ProcessType)this.attributes.get("PROCESS_TYPE");
    }

    public String getMonitorDSName() {
        String dsName = null;
        if (ProcessType.MONITORING == this.getProcessType()) {
            BLConstants.single();
            dsName = (String)this.attributes.get("MONITOR_DS");
        }
        return dsName;
    }

    public boolean isMonitorDSMappedPIID() {
        boolean monitorDSMappedToPIID = false;
        if (ProcessType.MONITORING == this.getProcessType()) {
            BLConstants.single();
            monitorDSMappedToPIID = (Boolean)this.attributes.get("ISMONITORDSMAPPEDTOPIID");
        }
        return monitorDSMappedToPIID;
    }
}

