/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.svo;

import com.savvion.sbm.bizlogic.server.svo.DataSlotMapping;
import com.savvion.sbm.bizlogic.util.BLConstants;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataSlotMappingList
implements Serializable,
Cloneable {
    static final long serialVersionUID = -6033715306664504332L;
    private ArrayList dsMappingList = new ArrayList();

    public DataSlotMappingList(ArrayList mappingList) {
        if (mappingList == null) {
            throw new RuntimeException("DataSlotMappingList.<init>: The data slot list <null> is invalid");
        }
        this.dsMappingList = mappingList;
    }

    public Object clone() {
        ArrayList<Object> mappingList = new ArrayList<Object>(this.dsMappingList.size());
        for (int ix = 0; ix < this.dsMappingList.size(); ++ix) {
            DataSlotMapping dsMapping = (DataSlotMapping)this.dsMappingList.get(ix);
            mappingList.add(dsMapping.clone());
        }
        return new DataSlotMappingList(mappingList);
    }

    public boolean isEmpty() {
        return this.dsMappingList.isEmpty();
    }

    public ArrayList getMappingList() {
        return this.dsMappingList;
    }

    public void addMapping(DataSlotMapping mapping) {
        this.dsMappingList.add(mapping);
    }

    public void populateValues(HashMap dsValues) {
        for (int ix = 0; ix < this.dsMappingList.size(); ++ix) {
            DataSlotMapping dsMapping = (DataSlotMapping)this.dsMappingList.get(ix);
            String dsName = dsMapping.getDataSlotName();
            Object dsValue = dsValues.get(dsName);
            dsMapping.setValue(dsValue);
        }
    }

    public void populateValuesByMappedName(HashMap dsValues) {
        for (int ix = 0; ix < this.dsMappingList.size(); ++ix) {
            DataSlotMapping dsMapping = (DataSlotMapping)this.dsMappingList.get(ix);
            String mappedName = dsMapping.getMappedName();
            Object dsValue = dsValues.get(mappedName);
            dsMapping.setValue(dsValue);
        }
    }

    public String[] getDataSlotNames() {
        String[] dsNames = new String[this.dsMappingList.size()];
        for (int ix = 0; ix < this.dsMappingList.size(); ++ix) {
            String dsName;
            DataSlotMapping dsMapping = (DataSlotMapping)this.dsMappingList.get(ix);
            dsNames[ix] = dsName = dsMapping.getDataSlotName();
        }
        return dsNames;
    }

    public Map<String, String> getDocumentDSNames() {
        HashMap<String, String> dsNames = new HashMap<String, String>();
        for (int ix = 0; ix < this.dsMappingList.size(); ++ix) {
            DataSlotMapping dsMapping = (DataSlotMapping)this.dsMappingList.get(ix);
            String string = dsMapping.getType();
            BLConstants.single();
            if (!string.equals("DOCUMENT")) continue;
            String dsName = dsMapping.getDataSlotName();
            dsNames.put(dsName, dsMapping.getMappedName());
        }
        return dsNames;
    }

    public String[] getMappedNames() {
        String[] mappedNames = new String[this.dsMappingList.size()];
        for (int ix = 0; ix < this.dsMappingList.size(); ++ix) {
            String mappedName;
            DataSlotMapping dsMapping = (DataSlotMapping)this.dsMappingList.get(ix);
            mappedNames[ix] = mappedName = dsMapping.getMappedName();
        }
        return mappedNames;
    }

    public String[] getIndexedDataSlotNames() {
        ArrayList indexedSlots = this.getIndexedDataSlotMappings();
        String[] dsNames = new String[indexedSlots.size()];
        for (int ix = 0; ix < indexedSlots.size(); ++ix) {
            String dsName;
            DataSlotMapping dsMapping = (DataSlotMapping)indexedSlots.get(ix);
            dsNames[ix] = dsName = dsMapping.getDataSlotName();
        }
        return dsNames;
    }

    public ArrayList getIndexedDataSlotMappings() {
        ArrayList<DataSlotMapping> list = new ArrayList<DataSlotMapping>();
        for (int ix = 0; ix < this.dsMappingList.size(); ++ix) {
            DataSlotMapping dsMapping = (DataSlotMapping)this.dsMappingList.get(ix);
            if (!dsMapping.isIndexed()) continue;
            list.add(dsMapping);
        }
        return list;
    }

    public DataSlotMapping getMapping(String dsName) {
        for (int ix = 0; ix < this.dsMappingList.size(); ++ix) {
            DataSlotMapping dsMapping = (DataSlotMapping)this.dsMappingList.get(ix);
            if (!dsName.equals(dsMapping.getDataSlotName())) continue;
            return dsMapping;
        }
        return null;
    }

    public HashMap getMappingInfo() {
        HashMap<String, String> mapDataslots = new HashMap<String, String>();
        for (int ix = 0; ix < this.dsMappingList.size(); ++ix) {
            DataSlotMapping dsMapping = (DataSlotMapping)this.dsMappingList.get(ix);
            String dsName = dsMapping.getDataSlotName();
            String mappedName = dsMapping.getMappedName();
            mapDataslots.put(dsName, mappedName);
        }
        return mapDataslots;
    }

    public HashMap getValues() {
        HashMap<String, Object> dsValues = new HashMap<String, Object>();
        for (int ix = 0; ix < this.dsMappingList.size(); ++ix) {
            DataSlotMapping dsMapping = (DataSlotMapping)this.dsMappingList.get(ix);
            String dsName = dsMapping.getDataSlotName();
            Object value = dsMapping.getValue();
            dsValues.put(dsName, value);
        }
        return dsValues;
    }

    public HashMap getValuesByMappedName() {
        HashMap<String, Object> dsValues = new HashMap<String, Object>();
        for (int ix = 0; ix < this.dsMappingList.size(); ++ix) {
            DataSlotMapping dsMapping = (DataSlotMapping)this.dsMappingList.get(ix);
            String dsName = dsMapping.getMappedName();
            Object value = dsMapping.getValue();
            dsValues.put(dsName, value);
        }
        return dsValues;
    }

    public HashMap getValuesByMappedName(int index, String key) {
        HashMap<String, Object> dsValues = new HashMap<String, Object>();
        for (int ix = 0; ix < this.dsMappingList.size(); ++ix) {
            DataSlotMapping dsMapping = (DataSlotMapping)this.dsMappingList.get(ix);
            String dsName = dsMapping.getMappedName();
            Object value = dsMapping.getValue();
            if (value != null && dsMapping.isIndexed()) {
                if (dsMapping.isList()) {
                    try {
                        value = ((List)value).get(index);
                    }
                    catch (Throwable th) {
                        value = null;
                    }
                } else if (dsMapping.isObject()) {
                    if (!(value instanceof HashMap)) {
                        throw new RuntimeException("DataSlotMappingList.getValuesByMappedName(): The Object dataslot <" + dsMapping.getName() + "> should be of type java.util.HashMap");
                    }
                    value = ((HashMap)value).get(key);
                }
            }
            dsValues.put(dsName, value);
        }
        return dsValues;
    }
}

