/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.svo;

import com.savvion.sbm.bizlogic.server.ejb.WorkItemSB;
import com.savvion.sbm.bizlogic.server.svo.BLCollection;
import com.savvion.sbm.bizlogic.server.svo.BLCollectionOperation;
import com.savvion.sbm.bizlogic.server.svo.CWorkItem;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BizLogicClientException;
import com.savvion.sbm.bizlogic.util.Session;
import com.savvion.sbm.util.ResultData;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class CWorkItemList
extends BLCollection
implements BLCollectionOperation {
    static final long serialVersionUID = -8012948459451488615L;

    CWorkItemList(Session session, Vector list) {
        this.session = session;
        if (list != null) {
            this.list = list;
        }
    }

    @Override
    public void save() throws RemoteException {
        HashMap modifiedAttrsList = this.getModifiedAttrsList();
        if (!modifiedAttrsList.isEmpty()) {
            ((WorkItemSB)this.getRemoteRef()).saveCWorkItem(this.session, modifiedAttrsList);
        }
    }

    @Override
    public void complete() throws RemoteException {
        if (this.list == null || this.list.isEmpty()) {
            return;
        }
        Integer[] integerArray = new Integer[1];
        BLConstants.single();
        integerArray[0] = 66;
        List<Long> invalidIdList = this.getSVOsInState(integerArray);
        if (!invalidIdList.isEmpty()) {
            throw new BizLogicClientException("BizLogic_ERR_3757", new Object[]{"complete", invalidIdList, "CI_SUSPENDED"});
        }
        Integer[] integerArray2 = new Integer[1];
        BLConstants.single();
        integerArray2[0] = 67;
        List<Long> validIdList = this.getSVOsNotInState(integerArray2);
        List<Map<String, Long>> idList = this.getIDList(validIdList);
        if (!validIdList.isEmpty()) {
            ResultData<List<Long>> result = ((WorkItemSB)this.getRemoteRef()).completeCWorkItem(this.session, idList);
            if (!result.isSuccessful()) {
                List completedIds = (List)result.getReturnValue();
                BLConstants.single();
                this.setState(67, completedIds);
                this.throwEx(completedIds, "CWorkItemList", "complete", result.getError());
            } else {
                BLConstants.single();
                this.setState(67);
            }
        }
    }

    @Override
    public void suspend() throws RemoteException {
        if (this.list == null || this.list.isEmpty()) {
            return;
        }
        Integer[] integerArray = new Integer[1];
        BLConstants.single();
        integerArray[0] = 66;
        List<Long> validIdList = this.getSVOsNotInState(integerArray);
        List<Map<String, Long>> idList = this.getIDList(validIdList);
        if (!idList.isEmpty()) {
            ResultData<List<Long>> result = ((WorkItemSB)this.getRemoteRef()).suspendCWorkItem(this.session, idList);
            if (!result.isSuccessful()) {
                List suspendedIds = (List)result.getReturnValue();
                BLConstants.single();
                this.setState(66, suspendedIds);
                this.throwEx(suspendedIds, "CWorkItemList", "suspend", result.getError());
            } else {
                BLConstants.single();
                this.setState(66);
            }
        }
    }

    @Override
    public void resume() throws RemoteException {
        if (this.list == null || this.list.isEmpty()) {
            return;
        }
        Integer[] integerArray = new Integer[3];
        BLConstants.single();
        integerArray[0] = 65;
        BLConstants.single();
        integerArray[1] = 69;
        BLConstants.single();
        integerArray[2] = 70;
        List<Long> validIdList = this.getSVOsNotInState(integerArray);
        List<Map<String, Long>> idList = this.getIDList(validIdList);
        if (!idList.isEmpty()) {
            ResultData<List<Long>> result = ((WorkItemSB)this.getRemoteRef()).resumeCWorkItem(this.session, idList);
            if (!result.isSuccessful()) {
                List resumedIds = (List)result.getReturnValue();
                this.setPreviousState(resumedIds);
                this.throwEx(resumedIds, "CWorkItemList", "resume", result.getError());
            } else {
                this.setPreviousState();
            }
        }
    }

    @Override
    public void remove() {
        throw new BizLogicClientException("Remove operation is not supported");
    }

    public void terminate() throws RemoteException {
        if (this.list == null || this.list.isEmpty()) {
            return;
        }
        Integer[] integerArray = new Integer[2];
        BLConstants.single();
        integerArray[0] = 67;
        BLConstants.single();
        integerArray[1] = 74;
        List<Long> invalidIdList = this.getSVOsInState(integerArray);
        if (!invalidIdList.isEmpty()) {
            throw new BizLogicClientException("BizLogic_ERR_3757", new Object[]{"terminate", invalidIdList, "CI_COMPLETED or CI_DECLINED"});
        }
        Integer[] integerArray2 = new Integer[1];
        BLConstants.single();
        integerArray2[0] = 68;
        List<Long> validList = this.getSVOsNotInState(integerArray2);
        List<Map<String, Long>> idList = this.getIDList(validList);
        if (!idList.isEmpty()) {
            ResultData<List<Long>> result = ((WorkItemSB)this.getRemoteRef()).terminateCWorkItem(this.session, idList);
            if (!result.isSuccessful()) {
                List terminatedIds = (List)result.getReturnValue();
                BLConstants.single();
                this.setState(68, terminatedIds);
                this.throwEx(terminatedIds, "CWorkItemList", "terminate", result.getError());
            } else {
                BLConstants.single();
                this.setState(68);
            }
        }
    }

    public List<String> getCStepNames() {
        HashSet<String> cStepNames = new HashSet<String>();
        CWorkItem cwi = null;
        for (int ix = this.list.size() - 1; ix >= 0; --ix) {
            cwi = (CWorkItem)this.list.elementAt(ix);
            cStepNames.add(cwi.getCStepName());
        }
        ArrayList<String> cStepNamesList = new ArrayList<String>();
        cStepNamesList.addAll(cStepNames);
        return cStepNamesList;
    }

    public List<CWorkItem> getCWorkItems(String cStepName) {
        ArrayList<CWorkItem> cWorkItems = new ArrayList<CWorkItem>();
        if (cStepName == null || cStepName.trim().length() == 0) {
            return cWorkItems;
        }
        CWorkItem cwi = null;
        for (int ix = this.list.size() - 1; ix >= 0; --ix) {
            cwi = (CWorkItem)this.list.elementAt(ix);
            if (!cwi.getCStepName().equals(cStepName)) continue;
            cWorkItems.add(cwi);
        }
        return cWorkItems;
    }

    private List<Map<String, Long>> getIDList(List<Long> cwiIdList) {
        ArrayList<Map<String, Long>> cwiList = new ArrayList<Map<String, Long>>();
        if (cwiIdList == null || cwiIdList.isEmpty()) {
            return cwiList;
        }
        CWorkItem cwi = null;
        for (int i = 0; i < this.list.size(); ++i) {
            cwi = (CWorkItem)this.list.elementAt(i);
            if (!cwiIdList.contains(cwi.getID())) continue;
            HashMap<String, Long> cwiIDs = new HashMap<String, Long>();
            BLConstants.single();
            cwiIDs.put("CWORKITEM_ID", cwi.getID());
            BLConstants.single();
            cwiIDs.put("CSTEP_ID", cwi.getCStepID());
            BLConstants.single();
            cwiIDs.put("PROCESSINSTANCEID", cwi.getProcessInstanceID());
            cwiList.add(cwiIDs);
        }
        return cwiList;
    }
}

