/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.svo;

import com.savvion.sbm.bizlogic.server.svo.BLProcess;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BizLogicClientException;
import com.savvion.sbm.bizlogic.util.Session;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import javax.ejb.EJBObject;

public abstract class BLCollection
implements Serializable {
    public Vector list = new Vector();
    public Session session;
    private int lastIndex = -1;

    public List getList() {
        return (List)this.list.clone();
    }

    public Iterator sort() {
        TreeMap tm = new TreeMap();
        for (int ix = 0; ix < this.list.size(); ++ix) {
            long piid = ((BLProcess)this.list.get(ix)).getID();
            tm.put(piid, this.list.get(ix));
        }
        Iterator sortedData = tm.values().iterator();
        return sortedData;
    }

    public abstract void save() throws BizLogicClientException, RemoteException;

    public Object first() {
        if (this.list != null && !this.list.isEmpty()) {
            this.lastIndex = 0;
            return this.list.get(this.lastIndex);
        }
        return null;
    }

    public Object next() {
        int size = this.list.size();
        if (this.list != null && size > 0 && size > ++this.lastIndex) {
            return this.list.get(this.lastIndex);
        }
        return null;
    }

    public Object prev() {
        if (this.list != null && this.lastIndex > 0 && this.list.size() > this.lastIndex) {
            --this.lastIndex;
            return this.list.get(this.lastIndex);
        }
        return null;
    }

    protected final boolean isEmptyList() {
        return this.list == null || this.list.isEmpty();
    }

    protected EJBObject getRemoteRef() throws BizLogicClientException, RemoteException {
        if (!this.isEmptyList()) {
            return ((BLProcess)this.list.firstElement()).getRemoteRef();
        }
        throw new RuntimeException("No SVO Object available in the List. So SessionBean lookup failed");
    }

    protected HashMap getModifiedAttrsList() {
        HashMap<Long, HashMap> modifiedAttrs = new HashMap<Long, HashMap>();
        HashMap hm = null;
        BLProcess svo = null;
        for (int ix = this.list.size() - 1; ix >= 0; --ix) {
            svo = (BLProcess)this.list.elementAt(ix);
            hm = svo.getModifiedAttributes();
            if (hm == null || hm.isEmpty()) continue;
            modifiedAttrs.put(svo.getID(), hm);
        }
        return modifiedAttrs;
    }

    protected Vector getIDList() {
        Vector<Long> idList = new Vector<Long>();
        BLProcess svo = null;
        for (int ix = this.list.size() - 1; ix >= 0; --ix) {
            svo = (BLProcess)this.list.elementAt(ix);
            idList.addElement(svo.getID());
        }
        return idList;
    }

    protected void setState(int state) {
        BLProcess svo = null;
        for (int ix = 0; ix < this.list.size(); ++ix) {
            svo = (BLProcess)this.list.elementAt(ix);
            svo.setState(state);
        }
    }

    protected void setState(int state, List<Long> validIds) {
        if (validIds == null || validIds.isEmpty()) {
            return;
        }
        BLProcess svo = null;
        for (int ix = 0; ix < this.list.size(); ++ix) {
            svo = (BLProcess)this.list.elementAt(ix);
            if (!validIds.contains(svo.getID())) continue;
            svo.setState(state);
        }
    }

    protected void setPreviousState() throws RemoteException {
        ArrayList<Long> validIds = new ArrayList<Long>(this.getIDList());
        this.setPreviousState(validIds);
    }

    protected void setPreviousState(List<Long> validIds) throws RemoteException {
        if (validIds == null || validIds.isEmpty()) {
            return;
        }
        BLProcess svo = null;
        for (int ix = 0; ix < this.list.size(); ++ix) {
            svo = (BLProcess)this.list.elementAt(ix);
            if (!validIds.contains(svo.getID())) continue;
            if (svo.attributes != null) {
                HashMap hashMap = svo.attributes;
                BLConstants.single();
                if (hashMap.containsKey("PREVIOUSSTATUS")) {
                    HashMap hashMap2 = svo.attributes;
                    BLConstants.single();
                    svo.setState((Integer)hashMap2.get("PREVIOUSSTATUS"));
                    continue;
                }
            }
            svo.refresh();
        }
    }

    protected void removeFromList(List<Long> idsToBeRemoved) {
        if (idsToBeRemoved == null || idsToBeRemoved.isEmpty()) {
            return;
        }
        ArrayList<BLProcess> svoList = new ArrayList<BLProcess>();
        BLProcess svo = null;
        for (int ix = 0; ix < this.list.size(); ++ix) {
            svo = (BLProcess)this.list.elementAt(ix);
            if (!idsToBeRemoved.contains(svo.getID())) continue;
            svoList.add(svo);
        }
        this.list.removeAll(svoList);
    }

    protected List<Long> getSVOsInState(Integer ... states) {
        ArrayList<Long> idList = new ArrayList<Long>();
        List<Integer> statesList = Arrays.asList(states);
        for (int i = 0; i < this.list.size(); ++i) {
            BLProcess svo = (BLProcess)this.list.get(i);
            if (!statesList.contains(svo.getState())) continue;
            idList.add(svo.getID());
        }
        return idList;
    }

    protected List<Long> getSVOsNotInState(Integer ... states) {
        ArrayList<Long> idList = new ArrayList<Long>();
        List<Integer> statesList = Arrays.asList(states);
        for (int i = 0; i < this.list.size(); ++i) {
            BLProcess svo = (BLProcess)this.list.get(i);
            if (statesList.contains(svo.getState())) continue;
            idList.add(svo.getID());
        }
        return idList;
    }

    protected <T> void throwEx(List<T> ids, String svo, String operation, Throwable th) {
        if (th == null) {
            return;
        }
        throw new BizLogicClientException("BizLogic_ERR_3761", new Object[]{operation, svo, ids}, th);
    }

    protected int getLastIndex() {
        return this.lastIndex;
    }

    protected void setLastIndex(int index) {
        this.lastIndex = index;
    }
}

