/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.svo;

import com.savvion.sbm.bizlogic.client.queryservice.ProcessInstanceFilter;
import com.savvion.sbm.bizlogic.client.queryservice.QSClientUtil;
import com.savvion.sbm.bizlogic.client.queryservice.QSProcessInstance;
import com.savvion.sbm.bizlogic.client.queryservice.QSProcessInstanceFilter;
import com.savvion.sbm.bizlogic.client.queryservice.QSProcessInstanceRS;
import com.savvion.sbm.bizlogic.client.queryservice.QSWorkItem;
import com.savvion.sbm.bizlogic.client.queryservice.QSWorkItemFilter;
import com.savvion.sbm.bizlogic.client.queryservice.QSWorkItemRS;
import com.savvion.sbm.bizlogic.client.queryservice.QSWorkStepInstance;
import com.savvion.sbm.bizlogic.client.queryservice.QSWorkStepInstanceFilter;
import com.savvion.sbm.bizlogic.client.queryservice.QSWorkStepInstanceRS;
import com.savvion.sbm.bizlogic.client.queryservice.QueryService;
import com.savvion.sbm.bizlogic.client.queryservice.WorkItemFilter;
import com.savvion.sbm.bizlogic.client.queryservice.WorkStepInstanceFilter;
import com.savvion.sbm.bizlogic.server.ejb.DataSlotSB;
import com.savvion.sbm.bizlogic.server.ejb.DataSlotSBHome;
import com.savvion.sbm.bizlogic.server.ejb.ProcessTemplateSB;
import com.savvion.sbm.bizlogic.server.ejb.ProcessTemplateSBHome;
import com.savvion.sbm.bizlogic.server.svo.ApplicationService;
import com.savvion.sbm.bizlogic.server.svo.DocumentDS;
import com.savvion.sbm.bizlogic.server.svo.ProcessCountList;
import com.savvion.sbm.bizlogic.server.svo.ProcessInstance;
import com.savvion.sbm.bizlogic.server.svo.ProcessInstanceList;
import com.savvion.sbm.bizlogic.server.svo.ProcessTemplate;
import com.savvion.sbm.bizlogic.server.svo.WorkItemList;
import com.savvion.sbm.bizlogic.server.svo.WorkStepInstanceList;
import com.savvion.sbm.bizlogic.server.svo.WorkStepTemplate;
import com.savvion.sbm.bizlogic.util.BizLogicClientException;
import com.savvion.sbm.bizlogic.util.Session;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class Application
implements Serializable {
    static final long serialVersionUID = 5189469796878828723L;
    private final String appName;
    private ArrayList ptsvos;
    private final Session ses;
    private transient QueryService qs;

    Application(Session session, String name, ArrayList ptList) {
        this.ses = session;
        this.appName = name;
        this.ptsvos = ptList;
    }

    public static Application get(Session session, String appName) throws BizLogicClientException, RemoteException {
        Application.validateSession(session);
        Application.checkAppName(appName);
        return ApplicationService.getBLServer().getApplication(session, appName);
    }

    public static ArrayList getList(Session session) throws BizLogicClientException, RemoteException {
        Application.validateSession(session);
        return ApplicationService.getBLServer().getApplicationList(session);
    }

    public static boolean isExist(Session session, String appName) throws BizLogicClientException, RemoteException {
        Application.validateSession(session);
        Application.checkAppName(appName);
        return ApplicationService.getProcessTemplateSB().isApplicationExist(session, appName);
    }

    public static Application createVersion(Session ses, String xmlFileName) throws BizLogicClientException, RemoteException {
        Application.validateSession(ses);
        return ApplicationService.createVersion(ses, xmlFileName);
    }

    public static Application createVersion(Session ses, ByteArrayInputStream xmlContent) throws BizLogicClientException, RemoteException {
        Application.validateSession(ses);
        return ApplicationService.createVersion(ses, xmlContent);
    }

    public static ByteArrayInputStream getContent(String xmlFileName) throws BizLogicClientException {
        if (xmlFileName == null || xmlFileName.trim().length() == 0) {
            throw new BizLogicClientException("BizLogic_ERR_8101", new Object[]{xmlFileName});
        }
        return ApplicationService.getContent(xmlFileName);
    }

    public static String getContentString(String xmlFileName) throws BizLogicClientException {
        if (xmlFileName == null || xmlFileName.trim().length() == 0) {
            throw new BizLogicClientException("BizLogic_ERR_8101", new Object[]{xmlFileName});
        }
        return ApplicationService.getContentString(xmlFileName);
    }

    public static Application create(Session session, String appName, String xmlFileName) throws BizLogicClientException, RemoteException {
        Application.validateSession(session);
        Application.checkAppName(appName);
        return ApplicationService.create(session, xmlFileName);
    }

    public static Application create(Session session, String xmlFileName) throws BizLogicClientException, RemoteException {
        Application.validateSession(session);
        return ApplicationService.create(session, xmlFileName);
    }

    public static Application create(Session session, ByteArrayInputStream xmlContent) throws BizLogicClientException, RemoteException {
        Application.validateSession(session);
        return ApplicationService.create(session, xmlContent);
    }

    public static ProcessTemplate getActiveVersion(Session session, String appName) throws BizLogicClientException, RemoteException {
        Application.validateSession(session);
        Application.checkAppName(appName);
        return ApplicationService.getBLServer().getActiveVersion(session, appName);
    }

    public static ProcessTemplate getLastVersion(Session session, String appName) throws BizLogicClientException, RemoteException {
        Application.validateSession(session);
        Application.checkAppName(appName);
        return ApplicationService.getBLServer().getLastVersion(session, appName);
    }

    public static List<Long> getProcessTemplateIDList(String appName) {
        return QSClientUtil.getProcessTemplateIDList((String)appName);
    }

    public ProcessTemplate createTemplateVersion(String xmlFileName) throws BizLogicClientException, RemoteException {
        ProcessTemplate ptObj = this.getLastVersion();
        if (ptObj.isSuspended()) {
            throw new BizLogicClientException("Bizlogic_ERR_3717", new Object[]{this.appName, ptObj.getStateDescription()});
        }
        ProcessTemplate activePT = ApplicationService.createTemplateVersion(ptObj, xmlFileName);
        this.ptsvos.add(activePT);
        return activePT;
    }

    public ProcessTemplate createTemplateVersion(ByteArrayInputStream xmlContent) throws BizLogicClientException, RemoteException {
        ProcessTemplate ptObj = this.getLastVersion();
        if (ptObj.isSuspended()) {
            throw new BizLogicClientException("Bizlogic_ERR_3717", new Object[]{this.appName, ptObj.getStateDescription()});
        }
        ProcessTemplate activePT = ApplicationService.createTemplateVersion(ptObj, xmlContent);
        this.ptsvos.add(activePT);
        return activePT;
    }

    public ProcessInstance createInstance(String piNamePrefix, String priority, HashMap dsValues) throws BizLogicClientException, RemoteException {
        return ProcessInstance.create(this.ses, this.getActiveVersion().getName(), piNamePrefix, priority, dsValues);
    }

    public ProcessTemplate replaceActiveTemplate() throws BizLogicClientException, RemoteException {
        return ApplicationService.replaceActiveTemplate(this.getActiveVersion(), null);
    }

    public ProcessTemplate replaceActiveTemplate(ByteArrayInputStream xmlContent) throws BizLogicClientException, RemoteException {
        return ApplicationService.replaceActiveTemplate(this.getActiveVersion(), xmlContent);
    }

    public String getAppName() {
        return this.appName;
    }

    public long[] getProcessTemplateIDs() {
        return ApplicationService.getProcessTemplateIDs(this.ptsvos);
    }

    public String[] getProcessTemplateNames() {
        return ApplicationService.getProcessTemplateNames(this.ptsvos);
    }

    public ProcessTemplate getActiveVersion() throws BizLogicClientException, RemoteException {
        ProcessTemplate lastVersion = this.getLastVersion();
        if (lastVersion.isActivated()) {
            return lastVersion;
        }
        throw new BizLogicClientException("Bizlogic_ERR_3717", new Object[]{this.appName, lastVersion.getStateDescription()});
    }

    public ProcessTemplate getLastVersion() {
        return (ProcessTemplate)this.ptsvos.get(this.ptsvos.size() - 1);
    }

    public ArrayList getTemplateList() {
        return this.ptsvos;
    }

    public ProcessInstance getProcessInstance(long piid) throws BizLogicClientException, RemoteException {
        return ProcessInstance.get(this.ses, piid);
    }

    public void remove() throws BizLogicClientException, RemoteException {
        for (int i = 0; i < this.ptsvos.size(); ++i) {
            ProcessTemplate pt = (ProcessTemplate)this.ptsvos.get(i);
            pt.removeAllProcessInstance();
            pt.remove();
        }
    }

    public void removeAllInstances() throws BizLogicClientException, RemoteException {
        for (int i = 0; i < this.ptsvos.size(); ++i) {
            ProcessTemplate pt = (ProcessTemplate)this.ptsvos.get(i);
            pt.removeAllProcessInstance();
        }
    }

    public void suspend() throws BizLogicClientException, RemoteException {
        this.getActiveVersion().suspend();
    }

    public void resume() throws BizLogicClientException, RemoteException {
        this.getLastVersion().resume();
    }

    public void refresh() throws BizLogicClientException, RemoteException {
        Application app = Application.get(this.ses, this.appName);
        this.ptsvos = app.ptsvos;
        app = null;
    }

    public int size() {
        return this.ptsvos.size();
    }

    public ProcessInstanceList getProcessInstanceList() {
        QSProcessInstanceFilter filter = new QSProcessInstanceFilter("appFilter", this.appName);
        filter.setFetchSize(0);
        QSProcessInstance qspi = this.getQSProcessInstance();
        QSProcessInstanceRS qspirs = qspi.getList((ProcessInstanceFilter)filter);
        return new ProcessInstanceList(this.ses, this.getVector(qspirs.getSVOList()));
    }

    public WorkStepInstanceList getWorkStepInstanceList() {
        QSWorkStepInstanceFilter filter = new QSWorkStepInstanceFilter("appFilter", this.appName);
        filter.setFetchSize(0);
        QSWorkStepInstance qswsi = this.getQSWorkStepInstance();
        QSWorkStepInstanceRS qswsirs = qswsi.getList((WorkStepInstanceFilter)filter);
        return new WorkStepInstanceList(this.ses, this.getVector(qswsirs.getSVOList()));
    }

    public WorkItemList getAssignedWorkItemList() {
        QSWorkItemFilter filter = new QSWorkItemFilter("appFilter", this.appName);
        filter.setFetchSize(0);
        QSWorkItem qswi = this.getQSWorkItem();
        QSWorkItemRS qswirs = qswi.getAssignedList((WorkItemFilter)filter);
        return new WorkItemList(this.ses, this.getVector(qswirs.getSVOList()));
    }

    public WorkItemList getAvailableWorkItemList() {
        QSWorkItemFilter filter = new QSWorkItemFilter("appFilter", this.appName);
        filter.setFetchSize(0);
        QSWorkItem qswi = this.getQSWorkItem();
        QSWorkItemRS qswirs = qswi.getAvailableList((WorkItemFilter)filter);
        return new WorkItemList(this.ses, this.getVector(qswirs.getSVOList()));
    }

    public WorkItemList getSuspendedWorkItemList() {
        QSWorkItemFilter filter = new QSWorkItemFilter("appFilter", this.appName);
        filter.setFetchSize(0);
        QSWorkItem qswi = this.getQSWorkItem();
        QSWorkItemRS qswirs = qswi.getSuspendedList((WorkItemFilter)filter);
        return new WorkItemList(this.ses, this.getVector(qswirs.getSVOList()));
    }

    public WorkItemList getProxyAssignedWorkItemList(ArrayList users, ArrayList apps) {
        QSWorkItemFilter filter = new QSWorkItemFilter("appFilter");
        filter.setFetchSize(0);
        QSWorkItem qswi = this.getQSWorkItem();
        QSWorkItemRS qswirs = qswi.getProxyAssignedList((WorkItemFilter)filter, (List)users, (List)apps);
        return new WorkItemList(this.ses, this.getVector(qswirs.getSVOList()));
    }

    public WorkItemList getProxyAvailableWorkItemList(ArrayList users, ArrayList apps) {
        QSWorkItemFilter filter = new QSWorkItemFilter("appFilter");
        filter.setFetchSize(0);
        QSWorkItem qswi = this.getQSWorkItem();
        QSWorkItemRS qswirs = qswi.getProxyAvailableList((WorkItemFilter)filter, (List)users, (List)apps);
        return new WorkItemList(this.ses, this.getVector(qswirs.getSVOList()));
    }

    public ProcessInstanceList getProcessInstanceList(int[] states) {
        QSProcessInstanceFilter filter = new QSProcessInstanceFilter("appFilter", this.appName);
        if (states != null && states.length > 0) {
            StringBuffer sb = new StringBuffer(50);
            sb.append("BLPI.STATUS ");
            this.prepareCondition(sb, states);
            filter.setCondition(sb.toString());
        }
        filter.setFetchSize(0);
        QSProcessInstance qspi = this.getQSProcessInstance();
        QSProcessInstanceRS qspirs = qspi.getList((ProcessInstanceFilter)filter);
        return new ProcessInstanceList(this.ses, this.getVector(qspirs.getSVOList()));
    }

    public WorkStepInstanceList getWorkStepInstanceList(int[] states) {
        QSWorkStepInstanceFilter filter = new QSWorkStepInstanceFilter("appFilter", this.appName);
        if (states != null && states.length > 0) {
            StringBuffer sb = new StringBuffer(50);
            sb.append("BLWSI.STATUS ");
            this.prepareCondition(sb, states);
            filter.setCondition(sb.toString());
        }
        filter.setFetchSize(0);
        QSWorkStepInstance qswsi = this.getQSWorkStepInstance();
        QSWorkStepInstanceRS qswsirs = qswsi.getList((WorkStepInstanceFilter)filter);
        return new WorkStepInstanceList(this.ses, this.getVector(qswsirs.getSVOList()));
    }

    public ProcessCountList getProcessCountList() throws RemoteException {
        return ProcessCountList.get(this.ses, null, null, this.appName);
    }

    public ProcessCountList getProcessCountList(String performer) throws RemoteException {
        return ProcessCountList.get(this.ses, performer, null, this.appName);
    }

    private QSProcessInstance getQSProcessInstance() {
        if (this.qs == null) {
            this.qs = new QueryService(this.ses);
        }
        return this.qs.getProcessInstance();
    }

    private QSWorkStepInstance getQSWorkStepInstance() {
        if (this.qs == null) {
            this.qs = new QueryService(this.ses);
        }
        return this.qs.getWorkStepInstance();
    }

    private QSWorkItem getQSWorkItem() {
        if (this.qs == null) {
            this.qs = new QueryService(this.ses);
        }
        return this.qs.getWorkItem();
    }

    private static void checkAppName(String appName) throws BizLogicClientException {
        if (appName == null || "".equals(appName)) {
            throw new BizLogicClientException("Bizlogic_ERR_3716", new Object[]{appName});
        }
    }

    private void prepareCondition(StringBuffer sb, int[] states) {
        sb.append(" IN (");
        for (int i = 0; i < states.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(states[i]);
        }
        sb.append(" ) ");
    }

    private Vector getVector(List arrList) {
        Vector list = null;
        list = arrList != null ? new Vector(arrList) : new Vector();
        return list;
    }

    public Map getCommonDataSlots() throws RemoteException, BizLogicClientException {
        return ApplicationService.getBLServer().getCommonDataSlots(this.ses, this.appName);
    }

    public static void updateSlotValue(Session session, List<Long> piids, Map<String, Object> dsValues, boolean isMultiTrans) throws BizLogicClientException, RemoteException {
        if (dsValues == null || dsValues.isEmpty()) {
            throw new BizLogicClientException("Bizlogic_ERR_4624");
        }
        DataSlotSB dsSB = (DataSlotSB)ApplicationService.getRemoteRef(DataSlotSBHome.class);
        dsSB.updateSlotValue(session, piids, dsValues, isMultiTrans);
        for (Object value : dsValues.values()) {
            if (value == null || !(value instanceof DocumentDS)) continue;
            DocumentDS docDS = (DocumentDS)value;
            docDS.clean();
        }
    }

    public static void updateSlotValue(Session session, Map<Long, Map<String, Object>> piDataslots, boolean isMultiTrans) throws BizLogicClientException, RemoteException {
        if (piDataslots == null || piDataslots.isEmpty()) {
            throw new BizLogicClientException("Bizlogic_ERR_4623");
        }
        DataSlotSB dsSB = (DataSlotSB)ApplicationService.getRemoteRef(DataSlotSBHome.class);
        dsSB.updateSlotValue(session, piDataslots, isMultiTrans);
        Set<Long> piids = piDataslots.keySet();
        for (Long piid : piids) {
            Map<String, Object> dsValues = piDataslots.get(piid);
            for (Object value : dsValues.values()) {
                if (value == null || !(value instanceof DocumentDS)) continue;
                DocumentDS docDS = (DocumentDS)value;
                docDS.clean();
            }
        }
    }

    public static Map<String, List<WorkStepTemplate>> getWorkstepTemplates(Session session, String appName, int wsType) throws BizLogicClientException, RemoteException {
        if (appName == null || appName.trim().length() == 0) {
            throw new BizLogicClientException("BizLogic_ERR_4629", (Object)"Application.getWorkstepTemplates");
        }
        ProcessTemplateSB ptsb = (ProcessTemplateSB)ApplicationService.getRemoteRef(ProcessTemplateSBHome.class);
        return ptsb.getWorkstepTemplates(session, appName, wsType);
    }

    public static Map<String, Map<String, List<WorkStepTemplate>>> getWorkstepTemplates(Session session, int wsType) throws BizLogicClientException, RemoteException {
        ProcessTemplateSB ptsb = (ProcessTemplateSB)ApplicationService.getRemoteRef(ProcessTemplateSBHome.class);
        return ptsb.getWorkstepTemplates(session, wsType);
    }

    public static Map<String, Map<String, Map<String, Object>>> getAppVersionInfo() {
        return QSClientUtil.getAppVersionInfo();
    }

    public ProcessTemplate reinstallActiveTemplate() {
        try {
            ProcessTemplate pt = this.getActiveVersion();
            return ProcessTemplate.reinstall(this.ses, this.appName, true);
        }
        catch (Throwable th) {
            throw new BizLogicClientException("BizLogic_ERR_8804", new Object[]{this.appName, "Application.reinstallActiveTemplate()"}, th);
        }
    }

    private static void validateSession(Session session) {
        if (session == null) {
            throw new BizLogicClientException("BizLogic_ERR_3870", new Object[]{"Application.validateSession()"});
        }
    }
}

