/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.ejb;

import com.savvion.sbm.bizlogic.server.dao.WorkStepInstanceDAO;
import com.savvion.sbm.bizlogic.server.ejb.WorkStepInstancePK;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.EntityAdapter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;

public class WorkStepInstanceEBBBean
extends EntityAdapter {
    public long id;
    public long processTemplateID;
    public long processInstanceID;
    public int type;
    public int priority;
    public int state;
    public int previousState;
    public int suspendState;
    public int suspendedByCompensatory;
    public int loopcounter;
    public String name;
    public String creator;
    public String performer;
    public String instruction;
    public long duedate;
    public long timeStarted;
    public long timeCompleted;
    public HashMap dataslotCopies;
    public long subProcessInstanceID;
    public int isSubProcessActivated;
    public String expectArrivals;
    public String actualPerformer;
    public long duration;
    public String inlineBlockName;
    public String milestoneName;
    public String milestoneDesc;
    public boolean isMonitorStep;

    public long getId() {
        return this.id;
    }

    public long getProcessTemplateID() {
        return this.processTemplateID;
    }

    public long getProcessInstanceID() {
        return this.processInstanceID;
    }

    public int getType() {
        return this.type;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getState() {
        return this.state;
    }

    public int getPreviousState() {
        return this.previousState;
    }

    public int getSuspendState() {
        return this.suspendState;
    }

    public boolean isSuspendedByCompensatory() {
        return this.suspendedByCompensatory == 1;
    }

    public int getLoopCounter() {
        return this.loopcounter;
    }

    public String getName() {
        return this.name;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getPerformer() {
        return this.performer;
    }

    public String getInstruction() {
        return this.instruction;
    }

    public long getDuedate() {
        return this.duedate;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getTimeStarted() {
        return this.timeStarted;
    }

    public long getTimeCompleted() {
        return this.timeCompleted;
    }

    public long getSubProcessInstanceID() {
        return this.subProcessInstanceID;
    }

    public int isSubProcessActivated() {
        return this.isSubProcessActivated;
    }

    public String getExpectArrivals() {
        return this.expectArrivals;
    }

    public String getActualPerformer() {
        return this.actualPerformer;
    }

    public HashMap getDataSlotCopies() {
        if (this.dataslotCopies == null) {
            WorkStepInstancePK primaryKey = (WorkStepInstancePK)this.ctx.getPrimaryKey();
            WorkStepInstanceDAO.getDataSlotCopies(this, primaryKey);
        }
        return this.dataslotCopies;
    }

    public String getInlineBlockName() {
        return this.inlineBlockName;
    }

    public String getMilestoneName() {
        return this.milestoneName;
    }

    public String getMilestoneDescription() {
        return this.milestoneDesc;
    }

    public boolean isMilestone() {
        return this.milestoneName != null && this.milestoneName.trim().length() != 0;
    }

    public boolean isMonitorStep() {
        return this.isMonitorStep;
    }

    public void setPriority(int priority) {
        this.priority = priority;
        this.modifiedAttrs.put("PRIORITY", priority);
    }

    public void setState(int state) {
        this.setPreviousState(this.state);
        this.state = state;
        this.modifiedAttrs.put("STATUS", state);
    }

    public void setPreviousState(int state) {
        this.previousState = state;
        this.modifiedAttrs.put("PREVIOUSSTATUS", state);
    }

    public void setSuspendState(int state) {
        this.suspendState = state;
        this.modifiedAttrs.put("SUSPENDSTATUS", state);
    }

    public void setSuspendedByCompensatory(boolean flag) {
        this.suspendedByCompensatory = flag ? 1 : 0;
        this.modifiedAttrs.put("ISSUSPENDEDBYCOMP", this.suspendedByCompensatory);
    }

    public void incrementLoopCounter() {
        ++this.loopcounter;
        this.modifiedAttrs.put("LOOPCOUNTER", this.loopcounter);
    }

    public void setCreator(String creator) {
        this.creator = creator;
        this.modifiedAttrs.put("CREATOR", creator);
    }

    public void setPerformer(String performer) {
        this.performer = performer;
        this.modifiedAttrs.put("PERFORMER", performer);
    }

    public void setInstruction(String instruction) {
        this.instruction = BLUtil.trim((String)String.valueOf(this.getProcessInstanceID()), (String)"INSTRUCTION", (String)instruction, (int)BLControl.util.MAX_INSTRUCTION_SIZE);
        this.modifiedAttrs.put("INSTRUCTION", this.instruction);
    }

    public void setDuedate(long duedate) {
        this.duedate = duedate;
        this.modifiedAttrs.put("DUEDATE", duedate);
    }

    public void setDuration(long duration) {
        this.duration = duration;
        this.modifiedAttrs.put("DURATION", duration);
    }

    public void setTimeStarted(long timeStarted) {
        this.timeStarted = timeStarted;
        this.modifiedAttrs.put("STARTTIME", timeStarted);
    }

    public void setTimeCompleted(long timeCompleted) {
        this.timeCompleted = timeCompleted;
        this.modifiedAttrs.put("ENDTIME", timeCompleted);
    }

    public void setSubProcessInstanceID(long subPIID) {
        this.subProcessInstanceID = subPIID;
        this.modifiedAttrs.put("SUBPIID", subPIID);
    }

    public void setIsSubProcessActivated(int isSubProcessActivated) {
        this.isSubProcessActivated = isSubProcessActivated;
        this.modifiedAttrs.put("ISSUBPIACTIVATED", isSubProcessActivated);
    }

    public void setExpectArrivals(String expectArrivals) {
        if (expectArrivals != null && expectArrivals.length() > BLControl.util.MAX_EXPECTARRIVALS_SIZE) {
            throw new BizLogicException("BizLogic_ERR_686", "WSEB::setExpectArrivals", new Object[]{expectArrivals, this.name, String.valueOf(this.processInstanceID), String.valueOf(BLControl.util.MAX_EXPECTARRIVALS_SIZE)});
        }
        this.expectArrivals = expectArrivals;
        this.modifiedAttrs.put("EXPECTARRIVALS", expectArrivals);
    }

    public void setActualPerformer(String actualPerformer) {
        if (actualPerformer != null && actualPerformer.length() > BLControl.util.MAX_PERFORMER_SIZE) {
            actualPerformer = actualPerformer.substring(0, BLControl.util.MAX_PERFORMER_SIZE - 1);
        }
        this.actualPerformer = actualPerformer;
        this.modifiedAttrs.put("ACTUALPERFORMER", actualPerformer);
    }

    public void setDataSlotCopies(HashMap dataslotCopies) {
        this.dataslotCopies = dataslotCopies;
        this.modifiedAttrs.put("DATASLOTCOPIES", dataslotCopies);
    }

    public void setInlineBlockName(String inlineBlockName) {
        this.inlineBlockName = inlineBlockName;
        this.modifiedAttrs.put("INLINEBLOCK_NAME", inlineBlockName);
    }

    public void setMileStone(String milestoneName, String milestoneDescription) {
        this.milestoneName = milestoneName;
        this.milestoneDesc = milestoneDescription;
        this.modifiedAttrs.put("MILESTONE_NAME", milestoneName);
        this.modifiedAttrs.put("MILESTONE_DESC", milestoneDescription);
    }

    public void setMonitorStep(boolean isMonitorStep) {
        this.isMonitorStep = isMonitorStep;
        this.modifiedAttrs.put("MONITOR_STEP", isMonitorStep);
    }

    public HashMap getAttributes() {
        HashMap<String, Object> attrsList = new HashMap<String, Object>();
        attrsList.put("WORKSTEPID", this.id);
        attrsList.put("PROCESSTEMPLATEID", this.processTemplateID);
        attrsList.put("PROCESSINSTANCEID", this.processInstanceID);
        attrsList.put("TYPE", this.type);
        attrsList.put("PRIORITY", this.priority);
        attrsList.put("STATUS", this.state);
        attrsList.put("WORKSTEPNAME", this.name);
        attrsList.put("CREATOR", this.creator);
        attrsList.put("PERFORMER", this.performer);
        attrsList.put("ACTUALPERFORMER", this.actualPerformer);
        attrsList.put("INSTRUCTION", this.instruction);
        attrsList.put("DUEDATE", this.duedate);
        attrsList.put("STARTTIME", this.timeStarted);
        attrsList.put("ENDTIME", this.timeCompleted);
        attrsList.put("LOOPCOUNTER", this.loopcounter);
        attrsList.put("SUBPIID", this.subProcessInstanceID);
        attrsList.put("INLINEBLOCK_NAME", this.inlineBlockName);
        attrsList.put("MILESTONE_NAME", this.milestoneName);
        attrsList.put("MILESTONE_DESC", this.milestoneDesc);
        attrsList.put("MONITOR_STEP", this.isMonitorStep);
        return attrsList;
    }

    public void ejbHomeDelete(WorkStepInstancePK primaryKey) throws RemoveException {
        WorkStepInstanceDAO.remove(primaryKey);
        if (BLControl.util.DEBUG_ENTITY) {
            Object[] largs = new Object[]{"WSEB", "ejbHomeDelete()", this.getPrimaryKey(primaryKey.processinstanceID, primaryKey.id, null), this};
            BLControl.logger.debugKey("BizLogic_ERR_1206", largs);
        }
    }

    public void ejbHomeDeleteByProcessInstance(long piid) throws RemoveException {
        if (BLControl.util.DEBUG_ENTITY) {
            Object[] largs = new Object[]{"WSEB", "ejbHomeDeleteByProcessInstance()", this};
            BLControl.logger.debugKey("BizLogic_ERR_1201", largs);
        }
        WorkStepInstanceDAO.removeByProcessInstance(piid);
    }

    public WorkStepInstancePK ejbCreate(HashMap attrsList) throws CreateException {
        Iterator keySet = attrsList.keySet().iterator();
        String key = null;
        Object value = null;
        while (keySet.hasNext()) {
            key = (String)keySet.next();
            value = attrsList.get(key);
            if (key.equalsIgnoreCase("WORKSTEPID")) {
                this.id = value;
                continue;
            }
            if ("PROCESSINSTANCEID".equalsIgnoreCase(key) && value instanceof Long) {
                this.processInstanceID = value;
                continue;
            }
            if (key.equalsIgnoreCase("PROCESSTEMPLATEID")) {
                this.processTemplateID = value;
                continue;
            }
            if (key.equalsIgnoreCase("TYPE")) {
                this.type = value;
                continue;
            }
            if (key.equalsIgnoreCase("PRIORITY")) {
                this.priority = value;
                continue;
            }
            if (key.equalsIgnoreCase("STATUS")) {
                this.state = value;
                continue;
            }
            if (key.equalsIgnoreCase("WORKSTEPNAME")) {
                this.name = value;
                continue;
            }
            if (key.equalsIgnoreCase("CREATOR")) {
                this.creator = value;
                continue;
            }
            if (key.equalsIgnoreCase("PERFORMER")) {
                this.performer = value;
                continue;
            }
            if (key.equalsIgnoreCase("INSTRUCTION")) {
                this.instruction = BLUtil.trim((String)String.valueOf(this.getProcessInstanceID()), (String)"INSTRUCTION", (String)value, (int)BLControl.util.MAX_INSTRUCTION_SIZE);
                attrsList.put("INSTRUCTION", this.instruction);
                continue;
            }
            if (key.equalsIgnoreCase("INLINEBLOCK_NAME")) {
                this.inlineBlockName = value;
                continue;
            }
            if (key.equalsIgnoreCase("MILESTONE_NAME")) {
                this.milestoneName = value;
                continue;
            }
            if (key.equalsIgnoreCase("MILESTONE_DESC")) {
                this.milestoneDesc = value;
                continue;
            }
            if (key.equalsIgnoreCase("MONITOR_STEP")) {
                this.isMonitorStep = value;
                continue;
            }
            Object[] eargs = new Object[]{"WSEB.create()", key, value};
            throw new BizLogicException("BizLogic_ERR_1506", "WorkStepInstanceEBBean.create", eargs);
        }
        WorkStepInstanceDAO.create(attrsList);
        this.setLoaded(true);
        this.modifiedAttrs = new HashMap();
        if (BLControl.util.DEBUG_ENTITY) {
            Object[] largs = new Object[]{"WSEB", "ejbCreate()", this.getPrimaryKey(), this};
            BLControl.logger.debugKey("BizLogic_ERR_1206", largs);
        }
        return new WorkStepInstancePK(this.processInstanceID, this.id);
    }

    public void ejbPostCreate(HashMap attrsList) {
        if (BLControl.util.DEBUG_ENTITY) {
            Object[] largs = new Object[]{"WSEB", "ejbPostCreate()", this.getPrimaryKey(), this};
            BLControl.logger.debugKey("BizLogic_ERR_1206", largs);
        }
    }

    public WorkStepInstancePK ejbFindByPrimaryKey(WorkStepInstancePK primaryKey) throws ObjectNotFoundException {
        if (BLControl.util.DEBUG_ENTITY) {
            Object[] largs = new Object[]{"WSEB", "ejbFindByPrimaryKey()", this.getPrimaryKey(primaryKey.processinstanceID, primaryKey.id, null), this};
            BLControl.logger.debugKey("BizLogic_ERR_1206", largs);
        }
        return WorkStepInstanceDAO.findByPrimaryKey(primaryKey);
    }

    public Collection ejbFindByStatus(int[] status) {
        if (BLControl.util.DEBUG_ENTITY) {
            Object[] largs = new Object[]{"WSEB", "ejbFindByStatus()", this};
            BLControl.logger.debugKey("BizLogic_ERR_1201", largs);
        }
        return WorkStepInstanceDAO.findByStatus(status);
    }

    public void ejbActivate() {
        this.setLoaded(false);
        this.modifiedAttrs = new HashMap();
        if (BLControl.util.DEBUG_ENTITY) {
            Object[] largs = new Object[]{"WSEB", "ejbActivate()", this.getPrimaryKey(), this};
            BLControl.logger.debugKey("BizLogic_ERR_1206", largs);
        }
    }

    public void ejbPassivate() {
        if (BLControl.util.DEBUG_ENTITY) {
            Object[] largs = new Object[]{"WSEB", "ejbPassivate()", this.getPrimaryKey(), this};
            BLControl.logger.debugKey("BizLogic_ERR_1206", largs);
        }
        this.setLoaded(false);
        this.modifiedAttrs = new HashMap();
        this.clean();
    }

    public void refresh() {
        this.load();
    }

    public void ejbLoad() {
        Object[] largs;
        if (BLControl.util.DEBUG_ENTITY) {
            largs = new Object[]{"WSEB", "ejbLoad()", this.getPrimaryKey(), this};
            BLControl.logger.debugKey("BizLogic_ERR_1208", largs);
        }
        if (this.isLoadRequired()) {
            this.load();
            if (BLControl.util.DEBUG_ENTITY) {
                largs = new Object[]{"WSEB", "ejbLoad()", this.getPrimaryKey(), this};
                BLControl.logger.debugKey("BizLogic_ERR_1206", largs);
            }
        }
    }

    private void load() {
        WorkStepInstancePK primaryKey = (WorkStepInstancePK)this.ctx.getPrimaryKey();
        WorkStepInstanceDAO.load(this, primaryKey);
        this.setLoaded(true);
        this.modifiedAttrs = new HashMap();
        if (BLControl.util.DEBUG_ENTITY) {
            BLControl.logger.debugKey("BizLogic_ERR_1204", new Object[]{this.name, primaryKey.toString(), "WSEB.load()"});
        }
    }

    public void ejbStore() {
        if (BLControl.util.DEBUG_ENTITY) {
            Object[] largs = new Object[]{"WSEB", "ejbStore()", this.getPrimaryKey(), this};
            BLControl.logger.debugKey("BizLogic_ERR_1208", largs);
        }
        if (!this.modifiedAttrs.isEmpty()) {
            WorkStepInstancePK primaryKey = (WorkStepInstancePK)this.ctx.getPrimaryKey();
            WorkStepInstanceDAO.store(this, primaryKey, this.modifiedAttrs);
            this.modifiedAttrs = new HashMap();
            if (BLControl.util.DEBUG_ENTITY) {
                Object[] largs = new Object[]{"WSEB", "ejbStore()", this.getPrimaryKey(), this};
                BLControl.logger.debugKey("BizLogic_ERR_1206", largs);
            }
        }
    }

    public void ejbRemove() throws RemoveException {
        WorkStepInstancePK primaryKey = (WorkStepInstancePK)this.ctx.getPrimaryKey();
        this.setLoaded(false);
        this.clean();
        WorkStepInstanceDAO.remove(primaryKey);
        if (BLControl.util.DEBUG_ENTITY) {
            Object[] largs = new Object[]{"WSEB", "ejbRemove()", this.getPrimaryKey(), this};
            BLControl.logger.debugKey("BizLogic_ERR_1206", largs);
        }
    }

    public void save() {
        if (BLControl.util.DEBUG_ENTITY) {
            Object[] largs = new Object[]{"WSEB", "save()", this};
            BLControl.logger.debugKey("BizLogic_ERR_1201", largs);
        }
        if (!this.modifiedAttrs.isEmpty()) {
            WorkStepInstancePK primaryKey = (WorkStepInstancePK)this.ctx.getPrimaryKey();
            WorkStepInstanceDAO.store(this, primaryKey, this.modifiedAttrs);
            this.modifiedAttrs = new HashMap();
        }
    }

    protected final void clean() {
        this.id = -1L;
        this.processTemplateID = -1L;
        this.processInstanceID = -1L;
        this.type = 0;
        this.priority = 0;
        this.state = 0;
        this.previousState = 0;
        this.suspendState = 0;
        this.suspendedByCompensatory = 0;
        this.loopcounter = 0;
        this.name = null;
        this.creator = null;
        this.performer = null;
        this.instruction = null;
        this.duedate = -1L;
        this.timeStarted = -1L;
        this.timeCompleted = -1L;
        this.dataslotCopies = null;
        this.subProcessInstanceID = -1L;
        this.isSubProcessActivated = 0;
        this.expectArrivals = null;
        this.actualPerformer = null;
        this.inlineBlockName = null;
        this.milestoneName = null;
        this.milestoneDesc = null;
        this.isMonitorStep = false;
    }

    public boolean isSuspended() {
        return this.state == 16;
    }

    private String getPrimaryKey(long pid, long wsid, String wsName) {
        StringBuilder primaryKey = new StringBuilder("piid=");
        primaryKey.append(pid);
        primaryKey.append(";wsid=").append(wsid);
        if (this.name != null) {
            primaryKey.append(";wsname=").append(wsName);
        }
        return primaryKey.toString();
    }

    private String getPrimaryKey() {
        return this.getPrimaryKey(this.processInstanceID, this.id, this.name);
    }
}

