/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.ejb;

import com.savvion.sbm.bizlogic.email.EmailComposer;
import com.savvion.sbm.bizlogic.messaging.subscriber.MessageManager;
import com.savvion.sbm.bizlogic.server.ApplicationManager;
import com.savvion.sbm.bizlogic.server.ProcessControl;
import com.savvion.sbm.bizlogic.server.TimerActionManager;
import com.savvion.sbm.bizlogic.server.WFExternalInstance;
import com.savvion.sbm.bizlogic.server.WFNestedInstance;
import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.server.WFProcessContext;
import com.savvion.sbm.bizlogic.server.WFProcessInstance;
import com.savvion.sbm.bizlogic.server.WFWorkItem;
import com.savvion.sbm.bizlogic.server.WFWorkstep;
import com.savvion.sbm.bizlogic.server.WFWorkstepInstance;
import com.savvion.sbm.bizlogic.server.XMLDocRepository;
import com.savvion.sbm.bizlogic.server.dao.ProcessInstanceDAO;
import com.savvion.sbm.bizlogic.server.dao.WorkItemDAO;
import com.savvion.sbm.bizlogic.server.ejb.ProcessInstanceEBLocal;
import com.savvion.sbm.bizlogic.server.ejb.WorkItemEBLocal;
import com.savvion.sbm.bizlogic.server.ejb.WorkItemEBLocalHome;
import com.savvion.sbm.bizlogic.server.svo.Application;
import com.savvion.sbm.bizlogic.server.svo.DataSlot;
import com.savvion.sbm.bizlogic.server.svo.DataSlotList;
import com.savvion.sbm.bizlogic.server.svo.DataSlotTemplate;
import com.savvion.sbm.bizlogic.server.svo.ProcessCountList;
import com.savvion.sbm.bizlogic.server.svo.ProcessInstance;
import com.savvion.sbm.bizlogic.server.svo.ProcessInstanceList;
import com.savvion.sbm.bizlogic.server.svo.ProcessTemplate;
import com.savvion.sbm.bizlogic.server.svo.ProcessTemplateList;
import com.savvion.sbm.bizlogic.server.svo.SVOFactory;
import com.savvion.sbm.bizlogic.server.svo.WorkItem;
import com.savvion.sbm.bizlogic.server.svo.WorkItemList;
import com.savvion.sbm.bizlogic.server.svo.WorkStepInstance;
import com.savvion.sbm.bizlogic.server.svo.WorkStepInstanceList;
import com.savvion.sbm.bizlogic.server.svo.WorkStepTemplate;
import com.savvion.sbm.bizlogic.smp.MPService;
import com.savvion.sbm.bizlogic.smp.gateway.rest.ProcessingResponse;
import com.savvion.sbm.bizlogic.storeevent.BSControl;
import com.savvion.sbm.bizlogic.util.BCLService;
import com.savvion.sbm.bizlogic.util.BLAlertService;
import com.savvion.sbm.bizlogic.util.BLCalendar;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLDAOService;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.PerformerUtil;
import com.savvion.sbm.bizlogic.util.Session;
import com.savvion.sbm.bizlogic.util.SessionAdapter;
import com.savvion.sbm.bizlogic.util.SessionManager;
import com.savvion.sbm.distcache.client.CacheOperationService;
import com.savvion.sbm.messaging.core.ChannelService;
import com.savvion.sbm.messaging.core.MDService;
import com.savvion.sbm.messaging.svo.Channel;
import com.savvion.sbm.messaging.svo.MessageDescriptor;
import com.savvion.sbm.util.LoggerUtil;
import com.savvion.sbm.util.QueryAccThreadBound;
import com.savvion.sbm.util.SBMConstants;
import com.savvion.sbm.util.SBMControl;
import com.savvion.sbm.util.SBMUtil;
import com.savvion.sbm.util.ServiceLocator;
import com.savvion.sbm.util.dcl.FCLService;
import com.tdiinc.userManager.User;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.sql.DataSource;
import net.sf.json.JSONObject;

public class BLServerBean
extends SessionAdapter {
    public Session connect(String user, String passwd) {
        this.checkForStart();
        Session ses = SessionManager.self().createSession(user, passwd);
        BLControl.util.logAPIName(new Object[]{0, user, "connect(u,p)"});
        return ses;
    }

    public void disConnect(Session ses) {
        SessionManager.validate((Session)ses, (String)"disConnect(s)");
        SessionManager.self().closeSession(ses);
    }

    public boolean validUser(Session ses, String user, String passwd) {
        SessionManager.validate((Session)ses, (String)"validUser(s,u,p)");
        boolean valid = false;
        try {
            SessionManager.validateUser((String)user, (String)passwd);
            valid = true;
        }
        catch (BizLogicException bizLogicException) {
            // empty catch block
        }
        return valid;
    }

    public boolean validUser(String user, String passwd) {
        try {
            SBMUtil.validateUser((String)user, (String)passwd);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void validateUser(String user, String passwd) {
        SBMUtil.validateUser((String)user, (String)passwd);
    }

    public void start(String user, String passwd) {
        int n = BLControl.getServerState();
        BLConstants.single();
        if (n == 1) {
            throw new BizLogicException("BizLogic_ERR_619", "BLServerBean.start");
        }
        User u = BLUtil.getUser((String)user);
        if (u == null) {
            throw new RuntimeException("User is not valid. Server startup terminated");
        }
        if (!u.passwordOK(passwd)) {
            throw new RuntimeException("Password is not valid. Server startup terminated");
        }
        try {
            BLControl.start();
        }
        catch (Throwable th) {
            throw new RuntimeException("BizLogic startup failed: ", th);
        }
        BLControl.util.logAPIName(new Object[]{0, user, "start(u,p)"});
    }

    public void shutdown(Session ses) {
        if (BLControl.isServerNotReady()) {
            throw new RuntimeException("BizLogic server is not running");
        }
        SessionManager.validate((Session)ses, (String)"shutdown(s)");
        BLControl.shutdown();
    }

    public boolean ping() {
        if (BLControl.isServerReady()) {
            BLControl.util.logAPIName(new Object[]{0, "", "ping()"});
        } else {
            LoggerUtil.logSOP((Object)" BizLogic Server is not ready. API BLServerBean.ping() invoked ");
        }
        return BLControl.isServerReady();
    }

    public void suspend(Session ses) {
        SessionManager.validate((Session)ses, (String)"suspend(s)");
        BLControl.suspend();
    }

    public void resume(String user, String passwd) {
        BLControl.util.logAPIName(new Object[]{0, user, "resume(u,p)"});
        SessionManager.validateUser((String)user, (String)passwd);
        BLControl.resume();
    }

    public void suspendConnections(Session session) {
        SessionManager.validate((Session)session, (String)"suspendConnections(s)");
        BLControl.suspendConnections();
    }

    public void resumeConnections(String user, String passwd) {
        BLControl.util.logAPIName(new Object[]{0, user, "resumeConnections(u,p)"});
        SessionManager.validateUser((String)user, (String)passwd);
        BLControl.resumeConnections();
    }

    public Map getCommonDataSlots(Session session, String appName) {
        SessionManager.validate((Session)session, (String)"getCommonDataSlots(s, appName)");
        return ApplicationManager.getCommonDataSlots(session, appName);
    }

    public HashMap getInfo(Session ses) {
        SessionManager.validate((Session)ses, (String)"getInfo(s)");
        return BLUtil.getServerInfo();
    }

    public Date getStartTime(Session ses) {
        SessionManager.validate((Session)ses, (String)"getStartTime(s)");
        return BLControl.getServerStartTime();
    }

    public String getVersion(Session ses) {
        SessionManager.validate((Session)ses, (String)"getVersion(s)");
        return BLControl.util.getVersion();
    }

    public void setTimerSchedule(Session ses, int minutes) {
        SessionManager.validate((Session)ses, (String)"setTimerSchedule(s,m)");
        BLControl.util.setTimerSchedule(minutes * 60 * 1000);
    }

    public boolean isClustering(Session ses) {
        SessionManager.validate((Session)ses, (String)"isClustering(s)");
        return BLControl.util.isClustering();
    }

    public void refresh(Session ses) {
        SessionManager.validate((Session)ses, (String)"refresh(s)");
        BLConstants.ClusterConstants cfr_ignored_0 = BLControl.consts.cluster;
        BLControl.refresh((String)"BL_PROPS_REFRESH");
    }

    public void refreshSBM(Session ses) {
        SessionManager.validate((Session)ses, (String)"refreshSBM(s)");
        SBMControl.refresh();
    }

    public void refresh(Session ses, String type) {
        SessionManager.validate((Session)ses, (String)"refresh(s, type)");
        BLControl.refresh((String)type);
    }

    public int getSessionCount(Session ses) {
        SessionManager.validate((Session)ses, (String)"getSessionCount(s)");
        return SessionManager.self().getCount();
    }

    public Vector getSessionList(Session ses) {
        SessionManager.validate((Session)ses, (String)"getSessionList(s)");
        return SessionManager.self().getSessionList();
    }

    public boolean isSessionValid(Session ses) {
        boolean valid = false;
        try {
            SessionManager.validate((Session)ses, (String)"isSessionValid(s)");
            valid = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return valid;
    }

    public long getSessionTimeOut(Session ses) {
        SessionManager.validate((Session)ses, (String)"getSessionTimeOut(s)");
        return BLControl.util.getSessionTimeOutMinutes();
    }

    public void setSessionTimeOut(Session ses, long minutes) {
        SessionManager.validate((Session)ses, (String)"setSessionTimeOut(s,m)");
        BLControl.setSessionTimeOut((long)(minutes * 60L * 1000L));
    }

    public int getMaxSessions(Session ses) {
        SessionManager.validate((Session)ses, (String)"getMaxSessions(s)");
        return BLControl.util.getMaxSessions();
    }

    public void setMaxSessions(Session ses, int maxses) {
        SessionManager.validate((Session)ses, (String)"setMaxSessions(s,m)");
        BLControl.setMaxSessions((int)maxses);
    }

    private void checkForStart() {
        if (BLControl.isServerNotReady()) {
            throw new RuntimeException("BizLogic server is not running");
        }
    }

    public ProcessTemplate createProcessTemplate(Session session, String processDefinition, boolean activate) {
        SessionManager.validate((Session)session, (String)"createProcessTemplate(s,xml,activate)");
        return ApplicationManager.createVersionAndGetTemplate(session, processDefinition, activate);
    }

    public void executeDDL(String ddlQuery) {
        try {
            BLDAOService.executeDDL((String)ddlQuery);
        }
        catch (Throwable th) {
            throw new BizLogicException("BizLogic_ERR_2575", "executeDDL(ddlQuery)", new Object[]{ddlQuery});
        }
    }

    public ProcessTemplate getProcessTemplate(Session session, long ptid) {
        SessionManager.validate((Session)session, (String)"getProcessTemplate (s,ptid)");
        return SVOFactory.getProcessTemplate(session, ptid);
    }

    public ProcessTemplate getProcessTemplate(Session session, String ptName) {
        SessionManager.validate((Session)session, (String)"getProcessTemplate (s,ptName)");
        return SVOFactory.getProcessTemplate(session, ptName);
    }

    public ProcessTemplateList getProcessTemplateList(Session session) {
        SessionManager.validate((Session)session, (String)"getProcessTemplateList (s)");
        return SVOFactory.getProcessTemplateList(session);
    }

    public WorkStepInstance getWorkStepInstance(Session session, long piid, long wsid) {
        SessionManager.validate((Session)session, (String)"getWorkStepInstance(session, piid, wsid)");
        return SVOFactory.getWorkStepInstance(session, piid, wsid);
    }

    public WorkStepInstance getWorkStepInstance(Session session, long piid, String wsName) {
        SessionManager.validate((Session)session, (String)"getWorkStepInstance(session, piid, wsid)");
        return SVOFactory.getWorkStepInstance(session, piid, wsName);
    }

    public WorkStepInstance getWorkStepInstance(Session session, String piName, String wsName) {
        SessionManager.validate((Session)session, (String)"getWorkStepInstance(session, piName, wsName)");
        ProcessInstanceEBLocal piEB = BLControl.util.getProcessInstanceEB(piName);
        return SVOFactory.getWorkStepInstance(session, (long)piEB.getId(), wsName);
    }

    public WorkStepTemplate getWorkStepTemplate(Session session, String ptName, String wsName) {
        SessionManager.validate((Session)session, (String)"getWorkStepTemplate(session, piName, wsName)");
        WFProcess pt = ProcessControl.getProcessTemplate(ptName);
        return SVOFactory.getWorkStepTemplate(session, pt, wsName);
    }

    public WorkItem getWorkItem(Session session, long wiid) {
        SessionManager.validate((Session)session, (String)"getWorkItem(session, wiid)");
        return SVOFactory.getWorkItem(session, wiid, true);
    }

    public WorkItemList getWorkItemList(Session session) {
        SessionManager.validate((Session)session, (String)"getWorkItemList(session)");
        return SVOFactory.getWorkItemList(session, null, null, null, session.getUser());
    }

    public WorkItemList getWorkItemListRO(Session session) {
        SessionManager.validate((Session)session, (String)"getWorkItemListRO(session)");
        return SVOFactory.getWorkItemListRO(session, null, null, null, session.getUser());
    }

    public WorkItemList getNextAvailableWorkItems(Session session, String user, HashMap filter) {
        return WFWorkItem.self().getNextAvailableWorkItems(session, user, filter);
    }

    public WorkItem getNextAvailableWorkItem(Session session, String user) {
        return WFWorkItem.self().getNextAvailableWorkItem(session, user);
    }

    public WorkItemList getQueueWorkItemList(Session session, String[] queueNames) {
        SessionManager.validate((Session)session, (String)"getQueueWorkItemList(s,queueNames)");
        return SVOFactory.getQueueWorkItemList(session, queueNames, null);
    }

    public WorkItemList getQueueWorkItemList(Session session, String[] queueNames, String excludeUser) {
        SessionManager.validate((Session)session, (String)"getQueueWorkItemList(s,queueNames,excludeUser)");
        return SVOFactory.getQueueWorkItemList(session, queueNames, new String[]{excludeUser});
    }

    public WorkItemList getQueueWorkItemList(Session session, String[] queueNames, String[] excludeUsers) {
        SessionManager.validate((Session)session, (String)"getQueueWorkItemList(s,queueNames,excludeUsers)");
        return SVOFactory.getQueueWorkItemList(session, queueNames, excludeUsers);
    }

    public HashMap getWorkItemDataSlotList(Session session, long wiid, boolean withMetaData) {
        SessionManager.validate((Session)session, (String)"getWorkItemDataSlotList(session, wiid, withMetaData)");
        WFProcessContext pCtx = new WFProcessContext(session, wiid, withMetaData);
        return SVOFactory.getWorkItemDataSlotList(pCtx, wiid, withMetaData);
    }

    public ProcessInstance getProcessInstance(Session ses, long piid) {
        SessionManager.validate((Session)ses, (String)"getProcessInstance(s,piid)");
        return SVOFactory.getProcessInstance(ses, piid);
    }

    public ProcessInstanceList getProcessInstanceList(Session ses, long ptid) {
        SessionManager.validate((Session)ses, (String)"getProcessInstanceList(s,ptid)");
        return SVOFactory.getProcessInstanceList(ses, new long[]{ptid}, null, null, null);
    }

    public ProcessInstanceList getProcessInstanceListRO(Session ses, long ptid) {
        SessionManager.validate((Session)ses, (String)"getProcessInstanceListRO(s,ptid)");
        return SVOFactory.getProcessInstanceListRO(ses, new long[]{ptid}, null, null, null);
    }

    public ProcessInstanceList getActivatedProcessInstanceList(Session ses, long ptid) {
        SessionManager.validate((Session)ses, (String)"getActiveProcessInstanceList(s,ptid)");
        int[] nArray = new int[1];
        nArray[0] = 7;
        return SVOFactory.getProcessInstanceList(ses, new long[]{ptid}, null, nArray, null);
    }

    public ProcessInstanceList getActivatedProcessInstanceListRO(Session ses, long ptid) {
        SessionManager.validate((Session)ses, (String)"getActiveProcessInstanceListRO(s,ptid)");
        int[] nArray = new int[1];
        nArray[0] = 7;
        return SVOFactory.getProcessInstanceListRO(ses, new long[]{ptid}, null, nArray, null);
    }

    public ProcessInstanceList getActivatedProcessInstanceList(Session ses) {
        SessionManager.validate((Session)ses, (String)"getActiveProcessInstanceList(s)");
        int[] nArray = new int[1];
        nArray[0] = 7;
        return SVOFactory.getProcessInstanceList(ses, null, null, nArray, null);
    }

    public ProcessInstanceList getActivatedProcessInstanceListRO(Session ses) {
        SessionManager.validate((Session)ses, (String)"getActiveProcessInstanceListRO(s)");
        int[] nArray = new int[1];
        nArray[0] = 7;
        return SVOFactory.getProcessInstanceListRO(ses, null, null, nArray, null);
    }

    public ProcessInstanceList getSuspendedProcessInstanceList(Session ses, long ptid) {
        SessionManager.validate((Session)ses, (String)"getSuspendedProcessInstanceList(s,ptid)");
        int[] nArray = new int[1];
        nArray[0] = 8;
        return SVOFactory.getProcessInstanceList(ses, new long[]{ptid}, null, nArray, null);
    }

    public ProcessInstanceList getSuspendedProcessInstanceListRO(Session ses, long ptid) {
        SessionManager.validate((Session)ses, (String)"getSuspendedProcessInstanceListRO(s,ptid)");
        int[] nArray = new int[1];
        nArray[0] = 8;
        return SVOFactory.getProcessInstanceListRO(ses, new long[]{ptid}, null, nArray, null);
    }

    public WorkStepInstanceList getActivatedWorkStepInstanceList(Session ses, long ptid) {
        SessionManager.validate((Session)ses, (String)"getActivatedWorkStepInstanceList(s,ptid)");
        int[] nArray = new int[1];
        nArray[0] = 18;
        return SVOFactory.getWorkStepInstanceList(ses, new long[]{ptid}, null, nArray, null);
    }

    public WorkStepInstanceList getActivatedWorkStepInstanceListRO(Session ses, long ptid) {
        SessionManager.validate((Session)ses, (String)"getActivatedWorkStepInstanceListRO(s,ptid)");
        int[] nArray = new int[1];
        nArray[0] = 18;
        return SVOFactory.getWorkStepInstanceListRO(ses, new long[]{ptid}, null, nArray, null);
    }

    public WorkStepInstanceList getSuspendedWorkStepInstanceList(Session ses, long ptid) {
        SessionManager.validate((Session)ses, (String)"getSuspendedWorkStepInstanceList(s,ptid)");
        int[] nArray = new int[1];
        nArray[0] = 16;
        return SVOFactory.getWorkStepInstanceList(ses, new long[]{ptid}, null, nArray, null);
    }

    public WorkStepInstanceList getSuspendedWorkStepInstanceListRO(Session ses, long ptid) {
        SessionManager.validate((Session)ses, (String)"getSuspendedWorkStepInstanceListRO(s,ptid)");
        int[] nArray = new int[1];
        nArray[0] = 16;
        return SVOFactory.getWorkStepInstanceListRO(ses, new long[]{ptid}, null, nArray, null);
    }

    public WorkStepInstanceList getWorkStepInstanceList(Session ses, long ptid) {
        SessionManager.validate((Session)ses, (String)"getWorkStepInstanceList(s,ptid)");
        return SVOFactory.getWorkStepInstanceList(ses, new long[]{ptid}, null, null, null);
    }

    public WorkStepInstanceList getWorkStepInstanceListRO(Session ses, long ptid) {
        SessionManager.validate((Session)ses, (String)"getWorkStepInstanceListRO(s,ptid)");
        return SVOFactory.getWorkStepInstanceListRO(ses, new long[]{ptid}, null, null, null);
    }

    public WorkStepInstanceList getActivatedWorkStepInstanceList(Session session, long pid, boolean isInstance) {
        SessionManager.validate((Session)session, (String)"getActivatedWorkStepInstanceList(s,pid,isInstance)");
        if (isInstance) {
            int[] nArray = new int[1];
            nArray[0] = 18;
            return SVOFactory.getWorkStepInstanceList(session, null, new long[]{pid}, nArray, null);
        }
        int[] nArray = new int[1];
        nArray[0] = 18;
        return SVOFactory.getWorkStepInstanceList(session, new long[]{pid}, null, nArray, null);
    }

    public WorkStepInstanceList getActivatedWorkStepInstanceListRO(Session session, long pid, boolean isInstance) {
        SessionManager.validate((Session)session, (String)"getActivatedWorkStepInstanceListRO(s,pid,isInstance)");
        if (isInstance) {
            int[] nArray = new int[1];
            nArray[0] = 18;
            return SVOFactory.getWorkStepInstanceListRO(session, null, new long[]{pid}, nArray, null);
        }
        int[] nArray = new int[1];
        nArray[0] = 18;
        return SVOFactory.getWorkStepInstanceListRO(session, new long[]{pid}, null, nArray, null);
    }

    public WorkStepInstanceList getActivatedWorkStepInstanceList(Session session) {
        SessionManager.validate((Session)session, (String)"getActivatedWorkStepInstanceList(s)");
        int[] nArray = new int[1];
        nArray[0] = 18;
        return SVOFactory.getWorkStepInstanceList(session, null, null, nArray, null);
    }

    public WorkStepInstanceList getActivatedWorkStepInstanceListRO(Session session) {
        SessionManager.validate((Session)session, (String)"getActivatedWorkStepInstanceListRO(s)");
        int[] nArray = new int[1];
        nArray[0] = 18;
        return SVOFactory.getWorkStepInstanceListRO(session, null, null, nArray, null);
    }

    public WorkStepInstanceList getSuspendedWorkStepInstanceList(Session session) {
        SessionManager.validate((Session)session, (String)"getSuspendedWorkStepInstanceList(s)");
        int[] nArray = new int[1];
        nArray[0] = 16;
        return SVOFactory.getSuspendedWorkStepInstanceList(session, null, null, nArray, null);
    }

    public WorkStepInstanceList getSuspendedWorkStepInstanceList(Session session, long[] pids, boolean isProcessInstance) {
        SessionManager.validate((Session)session, (String)"getSuspendedWorkStepInstanceList(s)");
        if (isProcessInstance) {
            int[] nArray = new int[1];
            nArray[0] = 16;
            return SVOFactory.getSuspendedWorkStepInstanceList(session, null, pids, nArray, null);
        }
        int[] nArray = new int[1];
        nArray[0] = 16;
        return SVOFactory.getSuspendedWorkStepInstanceList(session, pids, null, nArray, null);
    }

    public WorkStepInstanceList getSuspendedWorkStepInstanceListRO(Session session) {
        SessionManager.validate((Session)session, (String)"getSuspendedWorkStepInstanceListRO(s)");
        int[] nArray = new int[1];
        nArray[0] = 16;
        return SVOFactory.getWorkStepInstanceListRO(session, null, null, nArray, null);
    }

    public WorkStepInstanceList getWorkStepInstanceList(Session session, String user) {
        SessionManager.validate((Session)session, (String)"getWorkStepInstanceList(s,user)");
        int[] nArray = new int[2];
        nArray[0] = 18;
        nArray[1] = 16;
        return SVOFactory.getWorkStepInstanceList(session, null, null, nArray, user);
    }

    public WorkStepInstanceList getWorkStepInstanceListRO(Session session, String user) {
        SessionManager.validate((Session)session, (String)"getWorkStepInstanceListRO(s,user)");
        int[] nArray = new int[2];
        nArray[0] = 18;
        nArray[1] = 16;
        return SVOFactory.getWorkStepInstanceListRO(session, null, null, nArray, user);
    }

    public long createSubProcessInstance(Session ses, String ptName, String piPrefix, String priority, String creator, HashMap dsValues, boolean callback, HashMap callerInfo) {
        SessionManager.validate((Session)ses, (String)"createSubProcessInstance(s,ptname,piprefix,priority,creator,dsvalues,callback,callerinfo)");
        WFProcessContext processContext = WFNestedInstance.self().doCreateSubProcess(ses, ptName, piPrefix, priority, creator, dsValues, callback, callerInfo);
        return processContext.getProcessInstanceID();
    }

    public void completeCallerWorkStep(Session ses, long piid, long wsid, HashMap dsValues) {
        SessionManager.validate((Session)ses, (String)"completeCallerWorkStep(s,piid,wsid,subpiid,dsvalues)");
        WFExternalInstance.self().completeCallerWorkstep(ses, piid, wsid, dsValues);
    }

    public ProcessTemplateList getSuspendedProcessTemplateList(Session session) {
        SessionManager.validate((Session)session, (String)"getSuspendedProcessTemplateList(s,ptid)");
        return SVOFactory.getSuspendedProcessTemplateList(session);
    }

    public ProcessTemplateList getUserAuthorizedProcessTemplateList(Session session) {
        SessionManager.validate((Session)session, (String)"getUserAuthorizedProcessTemplateList(s)");
        return SVOFactory.getUserAuthorizedProcessTemplateList(session);
    }

    public ProcessTemplateList getUserProcessTemplateList(Session session) {
        SessionManager.validate((Session)session, (String)"getUserProcessTemplateList(s)");
        return SVOFactory.getUserProcessTemplateList(session);
    }

    public ProcessTemplate getProcess(Session session, String pName) {
        SessionManager.validate((Session)session, (String)"getParentProcessTemplate(s,piName)");
        if (pName != null) {
            if (pName.indexOf("#") != -1) {
                WFProcessContext pCtx = new WFProcessContext(session, pName);
                return SVOFactory.getProcessTemplate(session, pCtx);
            }
            return SVOFactory.getProcessTemplate(session, pName);
        }
        throw new BizLogicException("BizLogic_ERR_670", "BLServerBean::getProcess");
    }

    public WorkItem getWorkItem(Session session, String wiName) {
        SessionManager.validate((Session)session, (String)"getWorkItem(s,wiName)");
        WorkItemEBLocal wi = BLControl.util.getWorkItemEB(wiName);
        return SVOFactory.getWorkItem(session, wi.getId());
    }

    public ProcessInstanceList getProcessInstanceList(Session session) {
        SessionManager.validate((Session)session, (String)"getProcessInstanceList(s)");
        return SVOFactory.getProcessInstanceList(session, null, null, null, null);
    }

    public ProcessInstanceList getProcessInstanceListRO(Session session) {
        SessionManager.validate((Session)session, (String)"getProcessInstanceListRO(s)");
        return SVOFactory.getProcessInstanceListRO(session, null, null, null, null);
    }

    public ProcessInstance getProcessInstance(Session session, String piName) {
        SessionManager.validate((Session)session, (String)"getProcessInstance(s,piName)");
        ProcessInstanceEBLocal pi = BLControl.util.getProcessInstanceEB(piName);
        return SVOFactory.getProcessInstance(session, pi.getId());
    }

    public ProcessInstance createProcessInstance(Session session, String ptName, HashMap attributes, HashMap dsValues, boolean toActivate) {
        SessionManager.validate((Session)session, (String)"createPI(s,ptName,attrs,dsValues,toActivate)");
        HashMap attrs = WFProcessInstance.self().validateAttributesForCreateInstance(ptName, attributes);
        WFProcessContext pCtx = WFProcessContext.createProcessInstance(session, attrs, dsValues, toActivate);
        if (pCtx.getSVO() != null) {
            return pCtx.getSVO();
        }
        return SVOFactory.getProcessInstance(session, pCtx);
    }

    public ProcessInstance createProcessInstance(Session session, String appName, HashMap attributes, HashMap dsValues) {
        SessionManager.validate((Session)session, (String)"createPI(s,appName,attrs,dsValues)");
        QueryAccThreadBound.start();
        ProcessInstance instance = null;
        try {
            instance = WFProcessInstance.self().createInstance(session, appName, attributes, dsValues, true);
            QueryAccThreadBound.execute((DataSource)ServiceLocator.self().getDataSource(BLUtil.self().DS_JNDI_NAME));
        }
        catch (Exception e) {
            throw new BizLogicException("Could not create a process instance!", (Throwable)e);
        }
        finally {
            QueryAccThreadBound.end();
        }
        return instance;
    }

    public WorkItemList getWorkItemList(Session session, String user) {
        SessionManager.validate((Session)session, (String)"getWorkItemList(s,user)");
        int[] nArray = new int[2];
        nArray[0] = 28;
        nArray[1] = 27;
        int[] status = nArray;
        return SVOFactory.getWorkItemList(session, null, null, status, user);
    }

    public WorkItemList getWorkItemListRO(Session session, String user) {
        SessionManager.validate((Session)session, (String)"getWorkItemListRO(s,user)");
        int[] nArray = new int[2];
        nArray[0] = 28;
        nArray[1] = 27;
        int[] status = nArray;
        return SVOFactory.getWorkItemListRO(session, null, null, status, user);
    }

    public WorkItemList getAssignedWorkItemList(Session session, String user) {
        SessionManager.validate((Session)session, (String)"getAssignedWorkItemList(s,user)");
        int[] nArray = new int[1];
        nArray[0] = 28;
        int[] status = nArray;
        return SVOFactory.getWorkItemList(session, null, null, status, user);
    }

    public WorkItemList getAssignedWorkItemListRO(Session session, String user) {
        SessionManager.validate((Session)session, (String)"getAssignedWorkItemListRO(s,user)");
        int[] nArray = new int[1];
        nArray[0] = 28;
        int[] status = nArray;
        return SVOFactory.getWorkItemListRO(session, null, null, status, user);
    }

    public WorkItemList getAvailableWorkItemList(Session session, String user) {
        SessionManager.validate((Session)session, (String)"getAvailableWorkItemList(s,user)");
        int[] nArray = new int[1];
        nArray[0] = 27;
        int[] status = nArray;
        return SVOFactory.getWorkItemList(session, null, null, status, user);
    }

    public WorkItemList getAvailableWorkItemListRO(Session session, String user) {
        SessionManager.validate((Session)session, (String)"getAvailableWorkItemListRO(s,user)");
        int[] nArray = new int[1];
        nArray[0] = 27;
        int[] status = nArray;
        return SVOFactory.getWorkItemListRO(session, null, null, status, user);
    }

    public ProcessInstanceList getActivatedProcessInstanceList(Session session, String user) {
        SessionManager.validate((Session)session, (String)"getActivatedProcessInstanceList(s,user)");
        int[] nArray = new int[1];
        nArray[0] = 7;
        return SVOFactory.getProcessInstanceList(session, null, null, nArray, user);
    }

    public ProcessInstanceList getActivatedProcessInstanceListRO(Session session, String user) {
        SessionManager.validate((Session)session, (String)"getActivatedProcessInstanceListRO(s,user)");
        int[] nArray = new int[1];
        nArray[0] = 7;
        return SVOFactory.getProcessInstanceListRO(session, null, null, nArray, user);
    }

    public ProcessInstanceList getProcessInstanceList(Session session, String user) {
        SessionManager.validate((Session)session, (String)"getProcessInstanceList(s,user)");
        return SVOFactory.getProcessInstanceList(session, null, null, null, user);
    }

    public ProcessInstanceList getProcessInstanceListRO(Session session, String user) {
        SessionManager.validate((Session)session, (String)"getProcessInstanceListRO(s,user)");
        return SVOFactory.getProcessInstanceListRO(session, null, null, null, user);
    }

    public ProcessTemplateList getActivatedProcessTemplateList(Session session) {
        SessionManager.validate((Session)session, (String)"getActivatedProcessTemplateList (s)");
        return SVOFactory.getActivatedProcessTemplateList(session);
    }

    public void runGarbageCollector(Session session) {
        SessionManager.validate((Session)session, (String)"runGarbageCollector (s)");
        BLControl.util.RUNTIME_OBJECT.gc();
        BLControl.util.RUNTIME_OBJECT.runFinalization();
    }

    public int getServerState() {
        return BLControl.getServerState();
    }

    public DataSlot getDataSlot(Session session, long piid, String dsName) {
        SessionManager.validate((Session)session, (String)"getDataSlot(s,piid,dsName)");
        return SVOFactory.getDataSlot(session, piid, dsName);
    }

    public DataSlot getDataSlot(Session session, String piName, String dsName) {
        SessionManager.validate((Session)session, (String)"getDataSlot(s,piName,dsName)");
        ProcessInstanceEBLocal piEB = BLControl.util.getProcessInstanceEB(piName);
        return SVOFactory.getDataSlot(session, piEB.getId(), dsName);
    }

    public DataSlotTemplate getDataSlotTemplate(Session session, String ptName, String dsName) {
        SessionManager.validate((Session)session, (String)"getDataSlotTemplate(s,ptName,dsName)");
        WFProcess pt = ProcessControl.getProcessTemplate(ptName);
        return SVOFactory.getDataSlotTemplate(session, pt, dsName);
    }

    public DataSlotList getDataSlotList(Session session, long piid) {
        SessionManager.validate((Session)session, (String)"getDataSlotList(s,piid)");
        return SVOFactory.getDataSlotList(session, piid);
    }

    public DataSlotList getDataSlotList(Session session, long piid, String[] dsNames) {
        SessionManager.validate((Session)session, (String)"getDataSlotList(s,piid,dsNames[])");
        return SVOFactory.getDataSlotList(session, piid, dsNames);
    }

    public DataSlotList getDataSlotList(Session session, String piName, String[] dsNames) {
        SessionManager.validate((Session)session, (String)"getDataSlotList(s,piName,dsNames[])");
        long piid = ProcessInstanceDAO.getProcessInstanceID(piName);
        return SVOFactory.getDataSlotList(session, piid, dsNames);
    }

    public HashMap getProcessTemplateStartWorkStepData(Session session, String ptName) {
        SessionManager.validate((Session)session, (String)"getProcessTemplateWorkitem(session, ptName)");
        WFProcess ptObject = ProcessControl.getProcessTemplate(ptName);
        WFWorkstep ws = ptObject.getInitialWorkstep();
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("PROCESSTEMPLATEID", ptObject.getID());
        hm.put("APP_NAME", ptObject.getAppName());
        hm.put("WORKSTEPID", ws.getID());
        hm.put("WORKSTEPNAME", ws.getName());
        hm.put("PRIORITY", SBMControl.util.getStringPriority(ws.getPriority()));
        hm.put("INSTRUCTION", ws.getRealInstruction());
        hm.put("PERFORMINGAPP", ws.getRealPerformingApp());
        hm.put("OUTPUTDATASLOTS", SVOFactory.getDataSlotTemplateList(session, ptObject, ws.getOutputSlotsKeys(), true));
        return hm;
    }

    public ProcessCountList getProcessCountList(Session session, String performer, List<String> ptNames, String appName) {
        SessionManager.validate((Session)session, (String)"getProcessCountList(session, performer, ptNameList, appName)");
        return this.getProcessCountList(session, performer, ptNames, appName, false);
    }

    public ProcessCountList getProcessCountList(Session session, String performer) {
        SessionManager.validate((Session)session, (String)"getProcessCountList(session, ptName)");
        return this.getProcessCountList(session, performer, null, null, false);
    }

    public ProcessCountList getProcessCountList(Session session) {
        SessionManager.validate((Session)session, (String)"getProcessCountList(session, ptName)");
        return this.getProcessCountList(session, null, null, null, false);
    }

    public ProcessCountList getProcessCountListRO(Session session, String performer) {
        SessionManager.validate((Session)session, (String)"getProcessCountListRO(session, ptName)");
        return this.getProcessCountList(session, performer, null, null, true);
    }

    public ProcessCountList getProcessCountListRO(Session session) {
        SessionManager.validate((Session)session, (String)"getProcessCountListRO(session, ptName)");
        return this.getProcessCountList(session, null, null, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcessCountList getProcessCountList(Session session, String performer, List<String> ptNames, String appName, boolean readOnly) {
        try {
            SessionManager.setThreadSession((Session)session);
            ProcessCountList processCountList = SVOFactory.getProcessCountList(performer, ptNames, appName, readOnly);
            return processCountList;
        }
        finally {
            SessionManager.removeThreadSession();
        }
    }

    public void makeAvailable(Session session, long piid, long wsid, Vector performers) {
        SessionManager.validate((Session)session, (String)"makeAvailable(session,piid,wsid,performers)");
        new WFProcessContext(session, piid).makeAvailable(wsid, performers);
    }

    public void reAssign(Session session, String oldPerformer, String newPerformer) {
        SessionManager.validate((Session)session, (String)"reAssign(session,oldPerformer,newPerformer)");
        if (!BLUtil.isUser((String)oldPerformer)) {
            throw new BizLogicException("BizLogic_ERR_504", "BLServerBean.reAssign", new Object[]{oldPerformer});
        }
        if (!BLUtil.isUser((String)oldPerformer)) {
            throw new BizLogicException("BizLogic_ERR_504", "BLServerBean.reAssign", new Object[]{newPerformer});
        }
        try {
            WorkItemEBLocalHome wiebHome = BLControl.util.getWorkItemEBHome();
            Collection wiebList = wiebHome.findByPerformer(oldPerformer);
            if (wiebList != null && !wiebList.isEmpty()) {
                for (WorkItemEBLocal wieb : wiebList) {
                    long wiid = wieb.getId();
                    new WFProcessContext(session, wiid, true).reAssignWorkItem(wiid, newPerformer);
                }
            }
        }
        catch (BizLogicException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new BizLogicException("BizLogic_ERR_2133", "BLServerBean.reAssign", new Object[]{oldPerformer}, (Throwable)ex);
        }
    }

    public ProcessTemplateList getProcessTemplateVersions(Session session, String appName) {
        SessionManager.validate((Session)session, (String)"getProcessTemplateVersions(session, appName)");
        Collection ptList = ProcessControl.getVersions(appName);
        if (ptList.isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_1511", "BLServerBean.getProcessTemplateVersions", new Object[]{appName});
        }
        return SVOFactory.getProcessTemplateList(session, ptList);
    }

    public long getXMLCollectionID(Session session, long docid) {
        SessionManager.validate((Session)session, (String)"getXMLCollectionID(s,docid)");
        return XMLDocRepository.getCollectionID(docid);
    }

    public String getXMLContent(Session session, long docid) {
        SessionManager.validate((Session)session, (String)"getXMLContent(s,docid)");
        return XMLDocRepository.getContent(docid);
    }

    public boolean isProcessTemplateExist(Session session, String ptName) {
        SessionManager.validate((Session)session, (String)"isProcessTemplateExist(s, ptName)");
        return ProcessControl.isProcessTemplateExist(ptName);
    }

    public boolean isProcessTemplateExist(Session session, long ptid) {
        SessionManager.validate((Session)session, (String)"isProcessTemplateExist(s, ptid)");
        return ProcessControl.isProcessTemplateExist(ptid);
    }

    public boolean isWorkItemExist(Session session, long wiid) {
        SessionManager.validate((Session)session, (String)"isWorkItemExist(s, wiid)");
        return WorkItemDAO.isWorkItemExist(wiid);
    }

    public boolean isProcessInstanceExist(Session session, String piName) {
        SessionManager.validate((Session)session, (String)"isProcessInstanceExist(s, piName)");
        return ProcessInstanceDAO.isProcessInstanceExist(piName);
    }

    public boolean isProcessInstanceExist(Session session, long piid) {
        SessionManager.validate((Session)session, (String)"isProcessInstanceExist(s, piid)");
        return ProcessInstanceDAO.isProcessInstanceExist(piid);
    }

    public void emailAssignedTaskWithWarning(Session session, long wiid, String warning) {
        SessionManager.validate((Session)session, (String)"emailAssignedTaskWithWarning(s, wiid, warning)");
        WFProcessContext pCtx = new WFProcessContext(session, wiid, true);
        String performer = pCtx.getWorkItemEB(wiid).getPerformer();
        String performerEmail = PerformerUtil.getUserEmailAddress((String)performer);
        EmailComposer.self().sendAssignedTask(pCtx, wiid, performerEmail, warning);
    }

    public void startEmailServer(Session session) {
        SessionManager.validate((Session)session, (String)"startEmailServer(Session session)");
        BLControl.util.startEmailReader = true;
        BLControl.startEmailReader();
    }

    public void stopEmailServer(Session session) {
        SessionManager.validate((Session)session, (String)"stopEmailServer(Session session)");
        BLControl.stopEmailReader();
    }

    public int getBizStoreState(Session session) {
        SessionManager.validate((Session)session, (String)"getBizStoreState (s)");
        return BSControl.getState();
    }

    public WorkItemList getProxyAssignedWorkItemList(Session session, String user) {
        SessionManager.validate((Session)session, (String)"getProxyAssignedWorkItemList(s,user)");
        int[] nArray = new int[1];
        nArray[0] = 28;
        int[] status = nArray;
        return SVOFactory.getProxyWorkItemList(session, user, null, null, status, false, false);
    }

    public WorkItemList getProxyAssignedWorkItemList(Session session, String user, String proxyFor) {
        SessionManager.validate((Session)session, (String)"getProxyAssignedWorkItemList(s,user,proxyFor)");
        int[] nArray = new int[1];
        nArray[0] = 28;
        int[] status = nArray;
        ArrayList<String> proxyForList = new ArrayList<String>();
        proxyForList.add(proxyFor);
        return SVOFactory.getProxyWorkItemList(session, user, proxyForList, null, status, false, false);
    }

    public WorkItemList getProxyAvailableWorkItemList(Session session, String user) {
        SessionManager.validate((Session)session, (String)"getProxyAvailableWorkItemList(s,user)");
        int[] nArray = new int[1];
        nArray[0] = 27;
        int[] status = nArray;
        return SVOFactory.getProxyWorkItemList(session, user, null, null, status, true, false);
    }

    public WorkItemList getProxyAvailableWorkItemList(Session session, String user, String proxyFor) {
        SessionManager.validate((Session)session, (String)"getProxyAvailableWorkItemList(s,user,proxyFor)");
        int[] nArray = new int[1];
        nArray[0] = 27;
        int[] status = nArray;
        ArrayList<String> proxyForList = new ArrayList<String>();
        proxyForList.add(proxyFor);
        return SVOFactory.getProxyWorkItemList(session, user, proxyForList, null, status, true, false);
    }

    public long createTimerAction(Session session, long executeTime, String actionName, String actionInput, String notifyEmail) {
        SessionManager.validate((Session)session, (String)"createTimerAction(s, executeTime, actionName, actionInput, notifyEmail)");
        return TimerActionManager.self().createTimerAction(executeTime, actionName, actionInput, notifyEmail, session.getUser());
    }

    public List getQueues(Session session, String user) {
        SessionManager.validate((Session)session, (String)"getQueues(session, user)");
        if (user == null) {
            user = session.getUser();
        }
        return PerformerUtil.getQueues((Session)session, (String)user);
    }

    public void removeProcessTemplates(Session session, boolean force) {
        SessionManager.validate((Session)session, (String)"removeProcessTemplates(session, force)");
        ProcessControl.removeProcessTemplates(session, force);
    }

    public void setDynamicClassLoading(Session session, boolean value) {
        SessionManager.validate((Session)session, (String)"setDynamicLoading");
        FCLService.setDynamicLoading((boolean)value);
    }

    public boolean isDynamicClassLoading(Session session) {
        SessionManager.validate((Session)session, (String)"isDynamicLoading(s)");
        return FCLService.isDynamicLoading();
    }

    public String getProperties(Session session) {
        SessionManager.validate((Session)session, (String)"getProperties(s)");
        return BLUtil.getProperties();
    }

    public void resumeWorkStepInstances(Session session, long[] ptids, int[] wsTypes) {
        SessionManager.validate((Session)session, (String)"resumeWorkStepInstances(session, ptids, wsTypes");
        WFWorkstepInstance.single().resumeWorkStepInstances(ptids, wsTypes);
    }

    public ArrayList getSequenceId(String component, int count) {
        return BLControl.util.getSequenceId(component, count);
    }

    public Calendar getBizDate(String calName, long startTime, long duration) {
        return BLCalendar.self().getCalDueDate(calName, startTime, duration);
    }

    public Calendar getBizDate(long startTime, long duration) {
        return BLCalendar.self().getCalDueDate(startTime, duration);
    }

    public void refreshClassLoader(Session ses) {
        SessionManager.validate((Session)ses, (String)"reloadPtCL(s)");
        BCLService.reloadJars();
    }

    public void refreshClassLoader(Session ses, String ptName) {
        SessionManager.validate((Session)ses, (String)"reloadPtCL(s, ptName)");
        BCLService.reloadJars((String)ptName);
    }

    public Application getApplication(Session ses, String appName) {
        SessionManager.validate((Session)ses, (String)"getApplication(s, appName)");
        return ApplicationManager.getApplication(ses, appName);
    }

    public ArrayList getApplicationList(Session ses) {
        SessionManager.validate((Session)ses, (String)"getApplicationList(s)");
        return ApplicationManager.getApplicationList(ses);
    }

    public void printInfo(Session ses, String message, boolean logMessage) {
        SessionManager.validate((Session)ses, (String)"printInfo(s, msg)");
        if (logMessage) {
            BLControl.logger.info((Object)message);
        } else {
            LoggerUtil.logSOP((Object)message);
        }
    }

    public ProcessTemplate getActiveVersion(Session ses, String appName) {
        SessionManager.validate((Session)ses, (String)"getActiveVersion(s, msg)");
        return ApplicationManager.getActiveVersion(ses, appName);
    }

    public ProcessTemplate getLastVersion(Session ses, String appName) {
        SessionManager.validate((Session)ses, (String)"getLastVersion(ses, appName)");
        return SVOFactory.getLastVersion(ses, appName);
    }

    public void refreshChannels(List<String> channelNames) {
        ChannelService.self().refresh(channelNames);
    }

    public void refreshMessageDescriptors(List<String> messageDescriptorNames) {
        MDService.self().refresh(messageDescriptorNames);
    }

    public List<MessageDescriptor> getMessageList(Session session) {
        SessionManager.validate((Session)session, (String)"getMessageList(s)");
        Map messages = MDService.self().getMessages();
        ArrayList<MessageDescriptor> list = new ArrayList<MessageDescriptor>();
        list.addAll(messages.values());
        return list;
    }

    public List<Channel> getChannelList(Session session) {
        SessionManager.validate((Session)session, (String)"getChannelList(s)");
        Map channels = ChannelService.self().getChannels();
        ArrayList<Channel> list = new ArrayList<Channel>();
        list.addAll(channels.values());
        return list;
    }

    public List<HashMap<String, Object>> getWorkstepMessages(Session session, long piid) {
        SessionManager.validate((Session)session, (String)"getWorkstepMessages(s, piid)");
        return MessageManager.getWorkstepMessages(piid);
    }

    public void refreshMP(Session ses) {
        SessionManager.validate((Session)ses, (String)"refreshMP(s)");
        BLConstants.ClusterConstants cfr_ignored_0 = BLControl.consts.cluster;
        BLControl.refresh((String)"MP_REFRESH");
    }

    public void cacheOperation(Session session, SBMConstants.CacheInfo cacheInfo, SBMConstants.CacheOperation cacheOperation, String cacheKey, String cacheValue, Map<String, Object> attribs) {
        SessionManager.validate((Session)session, (String)"cacheOperation(s,CacheInfo,CacheOperation,cacheKey,cacheValue,attribs)");
        CacheOperationService.doCacheOperation((SBMConstants.CacheInfo)cacheInfo, (SBMConstants.CacheOperation)cacheOperation, (String)cacheKey, (Object)cacheValue, attribs);
    }

    public int userExistsInCache(Session session, SBMConstants.CacheInfo cacheInfo, String cacheKey) {
        return CacheOperationService.userExistsInCache((SBMConstants.CacheInfo)cacheInfo, (String)cacheKey);
    }

    public void updateProcessTemplateCache(Session session, String ptName, String operation) {
        SessionManager.validate((Session)session, (String)"updateProcessTemplateCache(session, ptName, operation)");
        ProcessControl.updatePTCache(ptName, operation);
    }

    public void clearAlertCache(Session session) {
        SessionManager.validate((Session)session, (String)"clearAlertCache(session)");
        BLAlertService.single().doClearAlertCache();
    }

    public void clearProcessAlertCache(Session session, String ptName) {
        SessionManager.validate((Session)session, (String)"clearProcessAlertCache(session, ptName)");
        BLAlertService.single().doClearAlertCache(ptName);
    }

    public void clearCalendarCache(Session session) {
        SessionManager.validate((Session)session, (String)"clearCalendarCache(session)");
        BLControl.refreshBLCalendars();
    }

    public String processExternalEvent(Session session, String extEventJSONString) {
        SessionManager.validate((Session)session, (String)"processExternalEvent(session, extEventJSON)");
        JSONObject extEventJSON = JSONObject.fromObject((Object)extEventJSONString);
        ProcessingResponse processingResponse = MPService.self().getRESTService().processJSON(extEventJSON);
        JSONObject responseJSON = new JSONObject();
        responseJSON.put((Object)"responseStatus", (Object)processingResponse.getEventStatus());
        String message = processingResponse.getMessage();
        if (message != null && !message.isEmpty()) {
            responseJSON.put((Object)"responseMessage", (Object)message);
        }
        return responseJSON.toString();
    }
}

