/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.ejb;

import com.savvion.sbm.bizlogic.email.EmailReader;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.MDBAdapter;
import com.savvion.sbm.util.SBMConstants;
import com.savvion.sbm.util.SBMUtil;
import com.savvion.sbm.util.logger.SBMLogger;
import javax.jms.Message;

public class BLEmailMDB
extends MDBAdapter {
    public void onMessage(Message message) {
        String opr = null;
        try {
            BLConstants.single();
            opr = message.getStringProperty("OPERATION");
        }
        catch (Throwable th) {
            if (BLControl.logger != null) {
                Object[] objectArray = new Object[1];
                BLConstants.single();
                objectArray[0] = "Incoming Email Service(BLEMAILMDB)";
                BLControl.logger.errorKey("BizLogic_ERR_3912", objectArray, th);
            }
            return;
        }
        BLUtil bLUtil = BLUtil.self();
        BLConstants.single();
        BLConstants.single();
        BLConstants.single();
        if (!bLUtil.isBLServerReady("BLEMAILMDB", opr, 5000, 10)) {
            return;
        }
        if (!BLControl.util.startEmailReader) {
            Object[] objectArray = new Object[4];
            BLConstants.single();
            objectArray[0] = "Incoming Email Service(BLEMAILMDB)";
            objectArray[1] = "bizlogic.conf";
            objectArray[2] = "bizlogic.email.reader.start";
            objectArray[3] = opr;
            BLControl.logger.infoKey("BizLogic_ERR_3174", objectArray);
            return;
        }
        if (BLControl.util.DEBUG_UTIL) {
            Object[] objectArray = new Object[2];
            BLConstants.single();
            objectArray[0] = "BLEMAILMDB";
            objectArray[1] = opr;
            BLControl.logger.debugKey("BizLogic_ERR_1187", objectArray);
        }
        BLConstants.ClusterConstants cfr_ignored_0 = BLControl.consts.cluster;
        if ("EMAIL_REFRESH".equals(opr)) {
            BLControl.doRefreshEmail();
            return;
        }
        this.processEmailReaderRequest(message);
    }

    private void processEmailReaderRequest(Message message) {
        String operation;
        String sender = null;
        try {
            if (BLUtil.ignoreRedeliveredLifeCycleMessages((Message)message, (String)"BLEMAILMDB")) {
                return;
            }
            SBMConstants.self().getClass();
            operation = message.getStringProperty("OPERATION");
            sender = message.getStringProperty("SENDER_NODE_NAME");
        }
        catch (Throwable thr) {
            BLControl.logger.errorKey("Bizlogic_ERR_3804", new Object[0], thr);
            return;
        }
        BLConstants.single();
        if (SBMUtil.isMessageNotFromSameNode((String)operation, (String)sender, (SBMLogger)BLControl.logger, (String)"BizLogic_ERR_3173", (String)"Incoming Email Service(BLEMAILMDB)")) {
            return;
        }
        try {
            if (operation.equals("START")) {
                EmailReader.self().startEmailReader(BLControl.logger);
            } else if (operation.equals("REFRESH")) {
                EmailReader.self().refresh();
            }
        }
        catch (Throwable thr) {
            BLControl.logger.errorKey("Bizlogic_ERR_3803", new Object[]{operation}, thr);
        }
    }
}

