/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.dao;

import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLDAOService;
import com.savvion.sbm.bizlogic.util.DBConstants;
import com.savvion.sbm.util.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public class VoteDAO
extends BLDAOService {
    private static final String[] INSERT_TABLELIST;
    private static String insert;
    public static String removeByPI;
    public static String removeByWSI;
    public static String updateVote;
    public static String loadVoteDetails;
    public static String loadTotalCount;
    public static String loadExpCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(long piid, long wsid, int loopcounter, int totalCount, int expCount, Map map) {
        block8: {
            Connection conn = null;
            PreparedStatement pstmtInsert = null;
            ByteArrayInputStream mapStream = null;
            try {
                conn = VoteDAO.getConnection();
                pstmtInsert = conn.prepareStatement(insert);
                if (BLControl.util.DEBUG_DAO) {
                    BLControl.logger.debugKey("BizLogic_ERR_1185", insert, new Object[0]);
                }
                pstmtInsert.setLong(1, piid);
                pstmtInsert.setLong(2, wsid);
                pstmtInsert.setInt(3, loopcounter);
                pstmtInsert.setInt(4, totalCount);
                pstmtInsert.setInt(5, expCount);
                pstmtInsert.setInt(6, 0);
                if (map != null && !map.isEmpty()) {
                    mapStream = new ByteArrayInputStream(VoteDAO.convertToBytes((Object)map));
                    pstmtInsert.setBinaryStream(7, (InputStream)mapStream, mapStream.available());
                } else {
                    pstmtInsert.setBinaryStream(7, (InputStream)null, 0);
                }
                pstmtInsert.executeUpdate();
                FileUtil.close((InputStream)mapStream);
                mapStream = null;
            }
            catch (SQLException sqlex) {
                VoteDAO.handle((Throwable)sqlex, (String)("VoteDAO.insert(PKey:: piid:" + piid + ":wsid:" + wsid + ":lc:" + loopcounter + ")"));
                break block8;
            }
            finally {
                FileUtil.close(mapStream);
                mapStream = null;
                VoteDAO.clean(null, (Statement)pstmtInsert, (Connection)conn);
            }
            VoteDAO.clean(null, (Statement)pstmtInsert, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateVoteInfo(long piid, long wsid, int loopcounter, int validCount, Map votes) {
        Connection conn = null;
        PreparedStatement pstmtUpdateVote = null;
        ByteArrayInputStream voteStream = null;
        try {
            conn = VoteDAO.getConnection();
            pstmtUpdateVote = conn.prepareStatement(updateVote);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", updateVote, new Object[0]);
            }
            pstmtUpdateVote.setInt(1, validCount);
            voteStream = new ByteArrayInputStream(VoteDAO.convertToBytes((Object)votes));
            pstmtUpdateVote.setBinaryStream(2, (InputStream)voteStream, voteStream.available());
            pstmtUpdateVote.setLong(3, piid);
            pstmtUpdateVote.setLong(4, wsid);
            pstmtUpdateVote.setInt(5, loopcounter);
            pstmtUpdateVote.executeUpdate();
        }
        catch (SQLException sqlex) {
            try {
                VoteDAO.handle((Throwable)sqlex, (String)("VoteDAO.updateVoteInfo(PKey:: piid:" + piid + ":wsid:" + wsid + ":lc:" + loopcounter + ")"));
            }
            catch (Throwable throwable) {
                FileUtil.close(voteStream);
                voteStream = null;
                VoteDAO.clean(null, (Statement)pstmtUpdateVote, (Connection)conn);
                throw throwable;
            }
            FileUtil.close((InputStream)voteStream);
            voteStream = null;
            VoteDAO.clean(null, (Statement)pstmtUpdateVote, (Connection)conn);
        }
        FileUtil.close((InputStream)voteStream);
        voteStream = null;
        VoteDAO.clean(null, (Statement)pstmtUpdateVote, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getVoteInfo(long piid, long wsid, int loopcounter) {
        HashMap<String, Serializable> voteDetails;
        InputStream is;
        ResultSet rset;
        PreparedStatement pstmtLoadVoteDetails;
        Connection conn;
        block6: {
            conn = null;
            pstmtLoadVoteDetails = null;
            rset = null;
            is = null;
            voteDetails = new HashMap<String, Serializable>();
            try {
                conn = VoteDAO.getConnection();
                pstmtLoadVoteDetails = conn.prepareStatement(loadVoteDetails);
                if (BLControl.util.DEBUG_DAO) {
                    BLControl.logger.debugKey("BizLogic_ERR_1185", loadVoteDetails, new Object[0]);
                }
                pstmtLoadVoteDetails.setLong(1, piid);
                pstmtLoadVoteDetails.setLong(2, wsid);
                pstmtLoadVoteDetails.setInt(3, loopcounter);
                rset = pstmtLoadVoteDetails.executeQuery();
                if (!rset.next()) break block6;
                DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
                voteDetails.put("TOTAL_COUNT", Integer.valueOf(rset.getInt(1)));
                DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
                voteDetails.put("EXPECTED_COUNT", Integer.valueOf(rset.getInt(2)));
                DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
                voteDetails.put("VALID_COUNT", Integer.valueOf(rset.getInt(3)));
                is = rset.getBinaryStream(4);
                HashMap votes = new HashMap();
                if (is != null) {
                    votes = (HashMap)VoteDAO.convertToObject((InputStream)is);
                }
                DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
                voteDetails.put("VOTES", votes);
            }
            catch (SQLException sqlex) {
                try {
                    VoteDAO.handle((Throwable)sqlex, (String)("VoteDAO.getVoteInfo(PKey:: piid:" + piid + ":wsid:" + wsid + ":lc:" + loopcounter + ")"));
                }
                catch (Throwable throwable) {
                    FileUtil.close(is);
                    is = null;
                    VoteDAO.clean(rset, (Statement)pstmtLoadVoteDetails, (Connection)conn);
                    throw throwable;
                }
                FileUtil.close(is);
                is = null;
                VoteDAO.clean((ResultSet)rset, (Statement)pstmtLoadVoteDetails, (Connection)conn);
            }
        }
        FileUtil.close(is);
        is = null;
        VoteDAO.clean((ResultSet)rset, (Statement)pstmtLoadVoteDetails, (Connection)conn);
        return voteDetails;
    }

    public static int getTotalCount(long piid, long wsid, int loopcounter) {
        return VoteDAO.getCount(piid, wsid, loopcounter, loadTotalCount);
    }

    public static int getExpectedCount(long piid, long wsid, int loopcounter) {
        return VoteDAO.getCount(piid, wsid, loopcounter, loadExpCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getCount(long piid, long wsid, int loopcounter, String sqlQuery) {
        int count;
        ResultSet rset;
        PreparedStatement pstmtLoadCount;
        Connection conn;
        block5: {
            conn = null;
            pstmtLoadCount = null;
            rset = null;
            count = -1;
            try {
                conn = VoteDAO.getConnection();
                pstmtLoadCount = conn.prepareStatement(sqlQuery);
                if (BLControl.util.DEBUG_DAO) {
                    BLControl.logger.debugKey("BizLogic_ERR_1185", sqlQuery, new Object[0]);
                }
                pstmtLoadCount.setLong(1, piid);
                pstmtLoadCount.setLong(2, wsid);
                pstmtLoadCount.setInt(3, loopcounter);
                rset = pstmtLoadCount.executeQuery();
                if (!rset.next()) break block5;
                count = rset.getInt(1);
            }
            catch (SQLException sqlex) {
                try {
                    VoteDAO.handle((Throwable)sqlex, (String)("VoteDAO.getCount(PKey:: piid:" + piid + ":wsid:" + wsid + ":lc:" + loopcounter + ")"));
                }
                catch (Throwable throwable) {
                    VoteDAO.clean(rset, (Statement)pstmtLoadCount, (Connection)conn);
                    throw throwable;
                }
                VoteDAO.clean((ResultSet)rset, (Statement)pstmtLoadCount, (Connection)conn);
            }
        }
        VoteDAO.clean((ResultSet)rset, (Statement)pstmtLoadCount, (Connection)conn);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeByProcessInstance(long piid) {
        Connection conn = null;
        PreparedStatement pstmtRemoveByPI = null;
        try {
            conn = VoteDAO.getConnection();
            pstmtRemoveByPI = conn.prepareStatement(removeByPI);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", removeByPI, new Object[0]);
            }
            pstmtRemoveByPI.setLong(1, piid);
            pstmtRemoveByPI.executeUpdate();
        }
        catch (SQLException sqlex) {
            VoteDAO.handle((Throwable)sqlex, (String)("VoteDAO.removeByProcessInstance( piid:" + piid + ")"));
        }
        finally {
            VoteDAO.clean(null, (Statement)pstmtRemoveByPI, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeByWorktepInstance(long piid, long wsid) {
        Connection conn = null;
        PreparedStatement pstmtRemoveByWSI = null;
        try {
            conn = VoteDAO.getConnection();
            pstmtRemoveByWSI = conn.prepareStatement(removeByWSI);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", removeByWSI, new Object[0]);
            }
            pstmtRemoveByWSI.setLong(1, piid);
            pstmtRemoveByWSI.setLong(2, wsid);
            pstmtRemoveByWSI.executeUpdate();
        }
        catch (SQLException sqlex) {
            VoteDAO.handle((Throwable)sqlex, (String)("VoteDAO.removeByWorktepInstance(piid:" + piid + ":wsid:" + wsid + ")"));
        }
        finally {
            VoteDAO.clean(null, (Statement)pstmtRemoveByWSI, (Connection)conn);
        }
    }

    public static synchronized void initSQLStatements() {
        DBConstants.TableConstants cfr_ignored_0 = BLControl.dbconsts.tab;
        insert = VoteDAO.composeInsertStatement((String)"BIZLOGIC_VOTE", (String[])INSERT_TABLELIST);
        StringBuffer whereClause = new StringBuffer(100);
        whereClause.append(" where ");
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        whereClause.append("PROCESS_INSTANCE_ID").append(" = ?");
        whereClause.append(" and ");
        DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
        whereClause.append("WORKSTEP_ID").append(" = ?");
        whereClause.append(" and ");
        DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
        whereClause.append("LOOPCOUNTER").append(" = ?");
        StringBuffer sb = new StringBuffer(100);
        sb.append("delete from ");
        DBConstants.TableConstants cfr_ignored_4 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_VOTE");
        sb.append(" where ");
        DBConstants.ColConstants cfr_ignored_5 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID");
        sb.append(" = ? ");
        removeByPI = sb.toString();
        sb = new StringBuffer(100);
        sb.append("delete from ");
        DBConstants.TableConstants cfr_ignored_6 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_VOTE");
        sb.append(" where ");
        DBConstants.ColConstants cfr_ignored_7 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID");
        sb.append(" = ? ");
        sb.append(" and ");
        DBConstants.ColConstants cfr_ignored_8 = BLControl.dbconsts.col;
        sb.append("WORKSTEP_ID");
        sb.append(" = ? ");
        removeByWSI = sb.toString();
        sb = new StringBuffer(300);
        sb.append("update ");
        DBConstants.TableConstants cfr_ignored_9 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_VOTE");
        sb.append(" set ");
        DBConstants.ColConstants cfr_ignored_10 = BLControl.dbconsts.col;
        sb.append("VALID_COUNT");
        sb.append(" = ? , ");
        DBConstants.ColConstants cfr_ignored_11 = BLControl.dbconsts.col;
        sb.append("VOTES");
        sb.append(" = ? ");
        sb.append(whereClause.toString());
        updateVote = sb.toString();
        sb = new StringBuffer(300);
        sb.append("select ");
        DBConstants.ColConstants cfr_ignored_12 = BLControl.dbconsts.col;
        sb.append("TOTAL_COUNT").append(", ");
        DBConstants.ColConstants cfr_ignored_13 = BLControl.dbconsts.col;
        sb.append("EXPECTED_COUNT").append(", ");
        DBConstants.ColConstants cfr_ignored_14 = BLControl.dbconsts.col;
        sb.append("VALID_COUNT").append(", ");
        DBConstants.ColConstants cfr_ignored_15 = BLControl.dbconsts.col;
        sb.append("VOTES");
        sb.append(" from ");
        DBConstants.TableConstants cfr_ignored_16 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_VOTE");
        sb.append(whereClause.toString());
        loadVoteDetails = sb.toString();
        sb = new StringBuffer(200);
        sb.append("select ");
        DBConstants.ColConstants cfr_ignored_17 = BLControl.dbconsts.col;
        sb.append("TOTAL_COUNT");
        sb.append(" from ");
        DBConstants.TableConstants cfr_ignored_18 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_VOTE");
        sb.append(whereClause.toString());
        loadTotalCount = sb.toString();
        sb = new StringBuffer(200);
        sb.append("select ");
        DBConstants.ColConstants cfr_ignored_19 = BLControl.dbconsts.col;
        sb.append("EXPECTED_COUNT");
        sb.append(" from ");
        DBConstants.TableConstants cfr_ignored_20 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_VOTE");
        sb.append(whereClause.toString());
        loadExpCount = sb.toString();
        VoteDAO.printSQLStatements();
    }

    private static void printSQLStatements() {
        if (BLControl.util.DEBUG_DAO) {
            BLControl.logger.debug((Object)"VoteDAO:");
            BLControl.logger.debugKey("BizLogic_ERR_1199", insert, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", removeByPI, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", removeByWSI, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", updateVote, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", loadVoteDetails, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", loadTotalCount, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", loadExpCount, new Object[0]);
        }
    }

    static {
        String[] stringArray = new String[7];
        DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
        stringArray[0] = "PROCESS_INSTANCE_ID";
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        stringArray[1] = "WORKSTEP_ID";
        DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
        stringArray[2] = "LOOPCOUNTER";
        DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
        stringArray[3] = "TOTAL_COUNT";
        DBConstants.ColConstants cfr_ignored_4 = BLControl.dbconsts.col;
        stringArray[4] = "EXPECTED_COUNT";
        DBConstants.ColConstants cfr_ignored_5 = BLControl.dbconsts.col;
        stringArray[5] = "VALID_COUNT";
        DBConstants.ColConstants cfr_ignored_6 = BLControl.dbconsts.col;
        stringArray[6] = "VOTES";
        INSERT_TABLELIST = stringArray;
    }
}

